<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Rest\Messaging\V1\Service\AlphaSenderContext;
use Twilio\Rest\Messaging\V1\Service\AlphaSenderList;
use Twilio\Rest\Messaging\V1\Service\PhoneNumberContext;
use Twilio\Rest\Messaging\V1\Service\PhoneNumberList;
use Twilio\Rest\Messaging\V1\Service\ShortCodeContext;
use Twilio\Rest\Messaging\V1\Service\ShortCodeList;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 * 
 * @property PhoneNumberList phoneNumbers
 * @property ShortCodeList shortCodes
 * @property AlphaSenderList alphaSenders
 * @method PhoneNumberContext phoneNumbers(string $sid)
 * @method ShortCodeContext shortCodes(string $sid)
 * @method AlphaSenderContext alphaSenders(string $sid)
 */
class ServiceContext extends InstanceContext {
    protected $_phoneNumbers = null;
    protected $_shortCodes = null;
    protected $_alphaSenders = null;

    /**
     * Initialize the ServiceContext
     * 
     * @param Version $version Version that contains the resource
     * @param string $sid The sid
     * @return ServiceContext
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('sid' => $sid, );

        $this->uri = '/Services/' . rawurlencode($sid) . '';
    }

    /**
     * Update the ServiceInstance
     * 
     * @param array|Options $options Optional Arguments
     * @return ServiceInstance Updated ServiceInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update($options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'FriendlyName' => $options['friendlyName'],
            'InboundRequestUrl' => $options['inboundRequestUrl'],
            'InboundMethod' => $options['inboundMethod'],
            'FallbackUrl' => $options['fallbackUrl'],
            'FallbackMethod' => $options['fallbackMethod'],
            'StatusCallback' => $options['statusCallback'],
            'StickySender' => Serialize::booleanToString($options['stickySender']),
            'MmsConverter' => Serialize::booleanToString($options['mmsConverter']),
            'SmartEncoding' => Serialize::booleanToString($options['smartEncoding']),
            'ScanMessageContent' => $options['scanMessageContent'],
            'FallbackToLongCode' => Serialize::booleanToString($options['fallbackToLongCode']),
            'AreaCodeGeomatch' => Serialize::booleanToString($options['areaCodeGeomatch']),
            'ValidityPeriod' => $options['validityPeriod'],
            'SynchronousValidation' => Serialize::booleanToString($options['synchronousValidation']),
        ));

        $payload = $this->version->update(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new ServiceInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Fetch a ServiceInstance
     * 
     * @return ServiceInstance Fetched ServiceInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new ServiceInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Deletes the ServiceInstance
     * 
     * @return boolean True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete() {
        return $this->version->delete('delete', $this->uri);
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     *
     * @return ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get($name) {
        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $property = $this->$name;
        if (method_exists($property, 'getContext')) {
            return call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.ServiceContext ' . implode(' ', $context) . ']';
    }

    /**
     * Access the phoneNumbers
     *
     * @return PhoneNumberList
     */
    protected function getPhoneNumbers() {
        if (!$this->_phoneNumbers) {
            $this->_phoneNumbers = new PhoneNumberList($this->version, $this->solution['sid']);
        }

        return $this->_phoneNumbers;
    }

    /**
     * Access the shortCodes
     *
     * @return ShortCodeList
     */
    protected function getShortCodes() {
        if (!$this->_shortCodes) {
            $this->_shortCodes = new ShortCodeList($this->version, $this->solution['sid']);
        }

        return $this->_shortCodes;
    }

    /**
     * Access the alphaSenders
     *
     * @return AlphaSenderList
     */
    protected function getAlphaSenders() {
        if (!$this->_alphaSenders) {
            $this->_alphaSenders = new AlphaSenderList($this->version, $this->solution['sid']);
        }

        return $this->_alphaSenders;
    }
}