<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://ideas.echopointer.com
 * @since      1.0.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/admin/partials
 */
settings_errors();
if (isset($_GET['tab'])) {
	$active_tab = $_GET['tab'];
} else {
	$active_tab = 'general';
} // end if

?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<div class="wrap">

	<h2><?php esc_html_e(get_admin_page_title()) . ' ' . $this->version; ?></h2>

	<h2 class="nav-tab-wrapper"><a href="?page=<?php echo $this->plugin_name; ?>&tab=general" class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>">عمومی</a>
		<a href="?page=<?php echo $this->plugin_name; ?>&tab=forms" class="nav-tab <?php echo $active_tab == 'forms' ? 'nav-tab-active' : ''; ?>">فرم ها</a>
		<a href="?page=<?php echo $this->plugin_name; ?>&tab=scripts" class="nav-tab <?php echo $active_tab == 'scripts' ? 'nav-tab-active' : ''; ?>">اسکریپت</a>
	</h2>

	<form method="post" action="options.php">

		<?php
		//Grab all options
		$g_options = get_option($this->plugin_name . '-general');
		// Cleanup
		$result_link = $g_options['results'];
		$products_pp = $g_options['products-perpage'];
		$distance_type = $g_options['distance-type'];
		$show_products = $g_options['show-products'];
		?>

		<table class="form-table">
			<!--  General settings start -->
			<?php if ($active_tab == 'general') { ?>
				<?php settings_fields($this->plugin_name . '-general'); ?>
				<?php do_settings_sections($this->plugin_name . '-general'); ?>
				<tr valign="top">
					<td colspan="2">
						<h2><?php esc_html_e('ShortCodes & Description', $this->plugin_name); ?></h2>
						<h4>[kas_dokan_vendor_filter]</h4>
						<p><?php esc_html_e('Above ShortCode is to show Filter form on any page you want.', $this->plugin_name); ?></p>
						<h4>[kas_dokan_vendor_filter_aio]</h4>
						<p><?php esc_html_e('Above ShortCode is to show filter single filed on any page you want.', $this->plugin_name); ?></p>
						<h4>[kas_dokan_vendor_filter_results]</h4>
						<p><?php esc_html_e('Above ShortCode is to show all the results, results page already get generated once you install this plugin in case to show results on new page you also need to change results link in below field to the page where you using this ShortCode, or you can add this shortcode to show all vendors on any page any place on your website set map if you want to show all vendors on Google Map.', $this->plugin_name); ?></p>
						<strong><?php esc_html_e('Result Page Link: ', $this->plugin_name); ?></strong><input style="width: 300px;" type="text" name="<?php echo $this->plugin_name; ?>-general[results]" value="<?php echo sanitize_text_field($result_link); ?>" />

					</td>
				</tr>
				<tr valign="top">
					<td><strong><?php esc_html_e('Products Per Page: ', $this->plugin_name); ?></strong><input type="text" name="<?php echo $this->plugin_name; ?>-general[products-perpage]" value="<?php echo sanitize_text_field($products_pp); ?>" /><br>
						<p><?php esc_html_e('Set numeric value only best fit is 10.', $this->plugin_name); ?></p>
					</td>

					<td><strong><?php esc_html_e('Calculate Distance In: ', $this->plugin_name); ?></strong>
						<select name="<?php echo $this->plugin_name; ?>-general[distance-type]">
							<?php
							if ($distance_type == 'metric') {
								$calculate_m = 'selected';
								$calculate_k = '';
							} elseif ($distance_type == 'imperial') {
								$calculate_m = '';
								$calculate_k = 'selected';
							} else {
								$calculate_m = '';
								$calculate_k = '';
							}

							?>
							<option>Choose Type</option>
							<option value="metric" <?php echo $calculate_m; ?>><?php esc_html_e('kilometres', $this->plugin_name); ?></option>
							<option value="imperial" <?php echo $calculate_k; ?>><?php esc_html_e('Miles', $this->plugin_name); ?></option>
						</select><br>
						<p><?php esc_html_e('Distance select unit.', $this->plugin_name); ?></p>
					</td>

				</tr>
				<tr valign="top">
					<td>
						<strong><?php esc_html_e('Show Products: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
						<label class="radio-inline"> 
							<input type="radio" name="<?php echo $this->plugin_name; ?>-general[show-products]" id="show-products" value="1" <?php checked(esc_attr($show_products), 1, true); ?>>
							<?php esc_html_e('Yes', $this->plugin_name); ?> 
						</label> 
						<label class="radio-inline"> 
							<input type="radio" name="<?php echo $this->plugin_name; ?>-general[show-products]" id="show-products" value="0" <?php checked(esc_attr($show_products), 0, true); ?>>
							<?php esc_html_e('No', $this->plugin_name); ?>
						</label>
					</td>
					
					<td>&nbsp;</td>				
				</tr>


			<?php } ?>
			<!--  General settings end -->

			<?php
			//Grab all options
			$f_options = get_option($this->plugin_name . '-forms');
			// filter
			$show_country = $f_options['show-country'];
			$show_state = $f_options['show-state'];
			$show_city = $f_options['show-city'];
			$show_store = $f_options['show-store'];
			$show_zip = $f_options['show-zip'];
			$show_category = $f_options['show-category'];

			?>


			<!-- Forms Settings start -->
			<?php if ($active_tab == 'forms') { ?>
				<?php settings_fields($this->plugin_name . '-forms'); ?>
				<?php do_settings_sections($this->plugin_name . '-forms'); ?>
				<tr valign="top">
					<td colspan="2">
						<h2><?php esc_html_e('تنظیمات فرم فیلدها را جدا کنید', $this->plugin_name); ?></h2>
						<p>از شورتکد <strong>[kas_dokan_vendor_filter]</strong> برای
   جدا سازی فیلدها در هر صفحه ای استفاده کنید.</p>
					</td>
				</tr>
				<!-- Full filter fields start -->
				<tr valign="top">

					<th scope="row"><?php esc_html_e('Enable/Disable Fields', $this->plugin_name); ?></th>

					<td>
						<table class="form-table">
							<tr valign="top">
								<td><strong><?php esc_html_e('Show Country: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-country]" id="show-country" value="1" <?php checked(esc_attr($show_country), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-country]" id="show-country" value="0" <?php checked(esc_attr($show_country), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?></label></td>


								<td><strong><?php esc_html_e('Show State: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-state]" id="show-state" value="1" <?php checked(esc_attr($show_state), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-state]" id="show-state" value="0" <?php checked(esc_attr($show_state), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label></td>

							</tr>


							<tr valign="top">

								<td><strong><?php esc_html_e('Show City: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-city]" id="show-city" value="1" <?php checked(esc_attr($show_city), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-city]" id="show-city" value="0" <?php checked(esc_attr($show_city), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label></td>


								<td><strong><?php esc_html_e('Show Stores: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-store]" id="show-store" value="1" <?php checked(esc_attr($show_store), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-store]" id="show-store" value="0" <?php checked(esc_attr($show_store), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label></td>

							</tr>


							<tr valign="top">

								<td>
									<strong><?php esc_html_e('Show ZIP Code: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-zip]" id="show-zip" value="1" <?php checked(esc_attr($show_zip), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-zip]" id="show-zip" value="0" <?php checked(esc_attr($show_zip), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label></td>


								<td><strong><?php esc_html_e('Show Categories: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-category]" id="show-category" value="1" <?php checked(esc_attr($show_category), 1, true); ?>>
										<?php esc_html_e('Yes', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-forms[show-category]" id="show-category" value="0" <?php checked(esc_attr($show_category), 0, true); ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label></td>

							</tr>
							
						</table>
					</td>

					<td>&nbsp;</td>

				</tr>

				<!-- single filter start -->
				<tr valign="top">
					<td colspan="2">
						<h2><?php esc_html_e('All-In-One Field form settings', $this->plugin_name); ?></h2>
						<p><?php printf(
								esc_html('از کد کوتاه %s برای فرم تک فیلد در هر صفحه استفاده کنید. ', $this->plugin_name),
								'<strong>[kas_dokan_vendor_filter_aio]</strong>'
							); ?></p>
					</td>
				</tr>
				<!-- single filter end -->

			<?php } ?>
			<!-- Form settings end -->


			<?php
			//Grab all options
			$s_options = get_option($this->plugin_name . '-scripts');

			?>


			<!-- scripts Settings start -->
			<?php if ($active_tab == 'scripts') { ?>
				<?php settings_fields($this->plugin_name . '-scripts'); ?>
				<?php do_settings_sections($this->plugin_name . '-scripts'); ?>
				<tr valign="top">
					<td colspan="2">
						<h2><?php esc_html_e('Scripts & Other settings', $this->plugin_name); ?></h2>
					</td>
				</tr>
				<tr valign="top">

					<th scope="row"><?php esc_html_e('Enable/Disable', $this->plugin_name); ?></th>


					<td>
						<table class="form-table">
							<tr valign="top">


								<td><strong><?php esc_html_e('Select2: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[enable-select2]" value="1" <?php echo checked(esc_attr($s_options['enable-select2']), 1, true) ?>>
										<?php esc_html_e('Classic', $this->plugin_name); ?></label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[enable-select2]" value="2" <?php checked(esc_attr($s_options['enable-select2']), 2, true) ?>>
										<?php esc_html_e('Bootstrap', $this->plugin_name); ?></label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[enable-select2]" value="3" <?php checked(esc_attr($s_options['enable-select2']), 3, true) ?>>
										<?php esc_html_e('Custom', $this->plugin_name); ?></label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[enable-select2]" value="0" <?php checked(esc_attr($s_options['enable-select2']), 0, true) ?>>
										<?php esc_html_e('None', $this->plugin_name); ?></label><br>
									<p><?php esc_html_e('IF your Theme or Plugin already has Select2 and conflict select "none"', $this->plugin_name); ?></p>
								</td>



								<td><strong><?php esc_html_e('Map View: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[show-mapview]" value="1" <?php checked(esc_attr($s_options['show-mapview']), 1, true) ?>>
										<?php esc_html_e('Map Only', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[show-mapview]" value="2" <?php checked(esc_attr($s_options['show-mapview']), 2, true) ?>>
										<?php esc_html_e('Both', $this->plugin_name); ?> </label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[show-mapview]" value="0" <?php checked(esc_attr($s_options['show-mapview']), 0, true) ?>>
										<?php esc_html_e('No', $this->plugin_name); ?> </label><br>
									<p><?php esc_html_e('If you want to show results on Google Map.', $this->plugin_name); ?></p>
								</td>

							</tr>
							<tr valign="top">


								<td><strong><?php esc_html_e('Google Map Height: ', $this->plugin_name); ?></strong><input type="text" name="<?php echo $this->plugin_name; ?>-scripts[map-height]" value="<?php echo esc_attr($s_options['map-height']); ?>" />px<br>
									<p><?php esc_html_e('Set numeric value only px already set example: "400".', $this->plugin_name); ?></p>
								</td>



								<td><strong><?php esc_html_e('Google Map Zoom: ', $this->plugin_name); ?></strong><input type="text" name="<?php echo $this->plugin_name; ?>-scripts[map-zoom]" value="<?php echo esc_attr($s_options['map-zoom']); ?>" /><br>
									<p><?php esc_html_e('Set numeric value only best fit is 12.', $this->plugin_name); ?></p>
								</td>

							</tr>
							<tr valign="top">


								<td><strong><?php esc_html_e('Search Radius: ', $this->plugin_name); ?></strong><input type="text" name="<?php echo $this->plugin_name; ?>-scripts[search-radius]" value="<?php echo esc_attr($s_options['search-radius']); ?>" /><br>
									<p><?php //_e('Set numeric value only px already set example: "400".', $this->plugin_name);
										?></p>
								</td>



								<td><strong><?php esc_html_e('Get Location: ', $this->plugin_name); ?></strong>&nbsp;&nbsp;
									<label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[get-location]" value="0" <?php checked(esc_attr($s_options['get-location']), 0, true)?>>
										<?php esc_html_e('Auto by User Location', $this->plugin_name); ?></label> <label class="radio-inline"> <input type="radio" name="<?php echo $this->plugin_name; ?>-scripts[get-location]" value="1" <?php checked(esc_attr($s_options['get-location']), 1, true)?>>
										<?php esc_html_e('Manual by Search', $this->plugin_name); ?></label>
									<p><?php _e('get user locaiton and show results according', $this->plugin_name); ?></p>
								</td>

							</tr>

						</table>
					</td>

					<td>&nbsp;</td>

				</tr>
			<?php } ?>
			<!-- scripts Settings start -->

		</table>




		<?php submit_button('ذخیره همه تغییرات', 'primary', 'submit', TRUE); ?>

	</form>




</div>