<?php
/**
 * @link              http://echopointer.com
 * @since             1.3.0
 * @package           Kas_Dvf
 *
 * @wordpress-plugin
 * Plugin Name:       فیلتر فروشندگان دکان
 * Plugin URI:        https://wpnovin.com
 * Description:       افزونه برای Dokan - بازار چند فروشنده به شما امکان می دهد فروشگاه را بر اساس مکان و موارد دیگر فیلتر کنید...
 * Version:           2.0.0
 * Author:            نوین وردپرس
 * Author URI:        https://wpnovin.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       kas-dvf
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in classes/class-kas-dvf-activator.php
 */
function activate_kas_dvf() {
	require_once plugin_dir_path( __FILE__ ) . 'classes/class-kas-dvf-activator.php';
	Kas_Dvf_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in classes/class-kas-dvf-deactivator.php
 */
function deactivate_kas_dvf() {
	require_once plugin_dir_path( __FILE__ ) . 'classes/class-kas-dvf-deactivator.php';
	Kas_Dvf_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_kas_dvf' );
register_deactivation_hook( __FILE__, 'deactivate_kas_dvf' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'classes/class-kas-dvf.php';
require plugin_dir_path( __FILE__ ) . 'includes/functions.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_dvf() {

	$plugin = new Kas_Dvf();
	$plugin->run();

}
run_dvf();
