<?php

/**
 * Provide a public-facing view
 *
 * This file is used to markup the public-facing aspects for filter form.
 *
 * @link       http://ideas.echopointer.com
 * @since      1.0.6
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/templates
 */
?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
//Grab all options

$g_options = get_option($text_domain . '-general');
$f_options = get_option($text_domain . '-forms');
$s_options = get_option($text_domain . '-scripts');
if (isset($_GET['kas_country']) && !empty($_GET['kas_country'])) {
	$kas_country = urlencode($_GET['kas_country']);
} else {
	$kas_country = '';
}
if (isset($_GET['kas_state']) && !empty($_GET['kas_state'])) {
	$kas_state = urlencode($_GET['kas_state']);
} else {
	$kas_state = '';
}
if (isset($_GET['kas_city']) && !empty($_GET['kas_city'])) {
	$kas_city = urlencode($_GET['kas_city']);
} else {
	$kas_city = '';
}
if (isset($_GET['kas_zip']) && !empty($_GET['kas_zip'])) {
	$kas_zip = urlencode($_GET['kas_zip']);
} else {
	$kas_zip = '';
}
if (isset($_GET['kas_category']) && !empty($_GET['kas_category'])) {
	$kas_category = $_GET['kas_category'];
} else {
	$kas_category = '';
}
if (isset($_GET['kas_rating']) && !empty($_GET['kas_rating'])) {
	$kas_rating = $_GET['kas_rating'];
} else {
	$kas_rating = '';
}
if (isset($_GET['query_type']) && !empty($_GET['query_type'])) {
	$query_type = $_GET['query_type'];
	if ($query_type == 'products') {
		$range_display = 'block';
	} else {
		$range_display = 'none';
	}
} else {
	$query_type = '';
	$range_display = 'none';
}

echo  '<script type="text/javascript">';

if ($s_options['enable-select2'] == 1) {
	echo 'var kas_select2_01 = "classic"; ';
} elseif ($s_options['enable-select2'] == 2) {
	echo 'var kas_select2_01 = "bootstrap";';
} elseif ($s_options['enable-select2'] == 3) {
	echo 'var kas_select2_01 = "custom"; ';
} else {
	echo 'var kas_select2_01 = ""; ';
}

echo '</script>';

// check if bootstrap enable
    if ($s_options['enable-select2'] == 1) {
    	$css_main_form = 'form-inline';
    	$css_select_class = 'form-control';
    	$css_form_group = 'form-group';
    	$btn_css = "dokan-btn dokan-btn-theme";
    } else {
    	$css_main_form = 'kas-search';
    	$css_select_class = 'kas-control';
    	$css_form_group = 'kas-group';
    	$btn_css = 'dokan-btn dokan-btn-theme';
    }


?>

<div class="kas-ripple"><div></div><div></div></div>


<form id="kas_search" method="get" class="<?php echo $css_main_form; ?> kas_center kas_search" action="<?php echo $g_options['results']; ?>">
	<?php if ($f_options['show-country'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?> "><select id="kas_country" name="kas_country" class="<?php echo $css_select_class; ?> kas_country">
				<option value=""><?php esc_html_e('Country..', $text_domain); ?></option>
				<?php
				asort($countries);
				foreach ($countries as $country) {
					if ($country) {
						if ($kas_country == $country[0]) {
							echo '<option selected value="' . $country[0] . '">' . $country[1] . '</option>';
						} else {
							echo '<option value="' . $country[0] . '">' . $country[1] . '</option>';
						}
					}
				}
				?>
			</select></div>
	<?php } ?>
	<?php if ($f_options['show-state'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?>"><select id="kas_state" name="kas_state" class="<?php echo $css_select_class; ?> kas_state">
				<option value=""><?php esc_html_e('State..', $text_domain); ?></option>
				<?php
				asort($states);
				foreach ($states as $state) {
					if ($state) {
						if ($kas_state == $state[0]) {
							echo '<option selected value="' . $state[0] . '">' . $state[1] . '</option>';
						} else {
							echo '<option value="' . $state[0] . '">' . $state[1] . '</option>';
						}
					}
				}
				?>

			</select></div>
	<?php } ?>
	<?php if ($f_options['show-city'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?>"><select id="kas_city" name="kas_city" class="<?php echo $css_select_class; ?> kas_city">
				<option value=""><?php esc_html_e('City..', $text_domain); ?></option>
				<?php
				sort($cities);
				foreach ($cities as $city) {
					if ($city) {
						if ($kas_city == $city) {
							echo '<option selected value="' . $city . '">' . $city . '</option>';
						} else {
							echo '<option value="' . $city . '">' . $city . '</option>';
						}
					}
				}
				?>

			</select></div>
	<?php } ?>

	<?php if ($f_options['show-zip'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?>"><select id="kas_zip" name="kas_zip" class="<?php echo $css_select_class; ?> kas_zip">
				<option value=""><?php esc_html_e('Zip..', $text_domain); ?></option>
				<?php
				sort($zips);
				foreach ($zips as $zip) {

					if ($zip) {
						if ($kas_zip == $zip) {
							echo '<option selected value="' . $zip . '">' . $zip . '</option>';
						} else {
							echo '<option value="' . $zip . '">' . $zip . '</option>';
						}
					}
				}
				?>

			</select></div>
	<?php } ?>

	<?php if ($f_options['show-category'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?>"><select id="kas_category" name="kas_category" class="<?php echo $css_select_class; ?> kas_category">
				<option value=""><?php esc_html_e('Vendor Category..', $text_domain); ?></option>

				<?php

				$taxonomy = 'product_cat';
				$orderby = 'name';
				$order = 'ASC';
				$show_count = 0; // 1 for yes, 0 for no
				$pad_counts = 0; // 1 for yes, 0 for no
				$hierarchical = 1; // 1 for yes, 0 for no
				$title = '';
				$empty = 1;

				$cat_args = array(
					'taxonomy' => $taxonomy,
					'orderby' => $orderby,
					'order' => $order,
					'show_count' => $show_count,
					'pad_counts' => $pad_counts,
					'hierarchical' => $hierarchical,
					'title_li' => $title,
					'hide_empty' => $empty,
					'parent' => 0
				);

				$all_categories = get_categories($cat_args);
				foreach ($all_categories as $cat) {
					$category_id = $cat->term_id;
					$sub_args = array('taxonomy' => $taxonomy, 'parent' => $category_id, 'hierarchical' => $hierarchical, 'orderby' => $orderby, 'order' => $order, 'hide_empty' => $empty);
					if ($kas_category == $cat->cat_name) {
						echo '<option selected value="' . $cat->cat_name . '">' . $cat->cat_name . '</option>';
					} else {
						echo '<option value="' . $cat->cat_name . '">' . $cat->cat_name . '</option>';
					}
					$sub_cats = get_categories($sub_args);
					if ($sub_cats) {

						foreach ($sub_cats as $sub_category) {

							if ($kas_category == $sub_category->cat_name) {
								echo '<option selected value="' . $cat->cat_name . '"> ->' . $sub_category->cat_name . '</option>';
							} else {
								echo '<option value="' . $sub_category->cat_name . '"> ->' . $sub_category->cat_name . '</option>';
							}
						}
					}
				}
				?>
			</select></div>
	<?php } ?>

	<?php if ($f_options['show-store'] == 1) { ?>
		<div class="<?php echo $css_form_group; ?>"><select id="kas_store" name="kas_store" class="<?php echo $css_select_class; ?> kas_store">
				<option value=""><?php esc_html_e('Store Name..', $text_domain); ?></option>
				<?php
				foreach ($stores as $store) {
					echo '<option value="' . $store['link'] . '">' . $store['name'] . '</option>';
				}
				?>
			</select></div>
	<?php } ?>



	<button type="submit" class="kas-mobile-responsive <?php echo $btn_css; ?>"><?php esc_html_e('Go', $text_domain); ?></button>

</form>