<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://echopointer.com
 * @since      1.3.0
 *
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/templates
 */

/**
 * @package    Kas_Dvf
 * @subpackage Kas_Dvf/templates
 * @author     Syed Muhammad Shafiq <shafiq_shaheen@hotmail.com>
 */

global $post;

$pagination_base = str_replace($post->ID, '%#%', esc_url(get_pagenum_link($post->ID)));
?>


<h3><?php esc_html_e('Results for : ' . $query, $text_domain); ?></h3>

<?php
$paged  = (int) is_front_page() ? max(1, get_query_var('page')) : max(1, get_query_var('paged'));
$limit  = 10;
$offset = ($paged - 1) * $limit;

$template_args = array(
	'sellers'         => $data,
	'limit'           => $limit,
	'offset'          => $offset,
	'paged'           => $paged,
	'search_query'    => '',
	'pagination_base' => $pagination_base,
	'per_row'         => '3',
	'search_enabled'  => 'no',
    'image_size'      => $image_size,
	'per_page'        => 10,
	'search'          => 'yes',

);
kas_dvf_get_template('map.php', array('data' => $data, 'text_domain' => $text_domain));
echo dokan_get_template_part('store-lists-loop', false, $template_args);

if($show_products > 0){

?>
    <!-- show products  -->
    <h3><?php esc_html_e('Vendor porducts', $text_domain); ?></h3>
    <?php 
    if ( $loop->have_posts() ) {
    
        woocommerce_product_loop_start();
    
        while ( $loop->have_posts() ) {
            $loop->the_post();
                
                /**
                 * Hook: woocommerce_shop_loop.
                 */
                do_action( 'woocommerce_shop_loop' );
                
                wc_get_template_part( 'content', 'product' );
            }
        
        woocommerce_product_loop_end();
    } else {
        /**
         * Hook: woocommerce_no_products_found.
         *
         * @hooked wc_no_products_found - 10
         */
        do_action( 'woocommerce_no_products_found' );
    }
    wp_reset_postdata();
}
?>