<?php

$settings = array(

	/** SIDE CART MAIN **/
	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض سبد خرید کناری',
		'id' 			=> 'scm-width',
		'section_id' 	=> 'sc_main',
		'default' 		=> '400',
		'desc' 			=> 'اندازه به پیکسل'
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'ارتفاع سبد خرید کناری',
		'id' 			=> 'scm-height',
		'section_id' 	=> 'sc_main',
		'args' 			=> array(
			'options' 	=> array(
				'full' 		=> 'ارتفاع کامل',
				'auto' 		=> 'تنظیم خودکار',
			),
		),
		'default' 	=> 'full'
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'باز شدن از',
		'id' 			=> 'scm-open-from',
		'section_id' 	=> 'sc_main',
		'args' 			=> array(
			'options' 	=> array(
				'left' 		=> 'چپ',
				'right' 	=> 'راست',
			),
		),
		'default' 	=> 'right'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'فونت',
		'id' 			=> 'scm-font',
		'section_id' 	=> 'sc_main',
		'default' 		=> '',
		'desc' 			=> 'از فونت سفارشی برای سبد خرید استفاده کنید'
	),

	/** SIDE CART BASKET **/
	array(
		'callback' 		=> 'select',
		'title' 		=> 'فعالسازی',
		'id' 			=> 'sck-enable',
		'section_id' 	=> 'sc_basket',
		'args' 			=> array(
			'options' 	=> array(
				'always_hide' 	=> 'همیشه پنهان کن',
				'always_show' 	=> 'همیشه نمایش بده',
				'hide_empty' 	=> 'وقتی سبد خرید خالی است پنهان کن',
			),
		),
		'default' 	=> 'always_show'
	),


	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'نمایش در موبایل',
		'id' 			=> 'sck-show-mobile',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'شکل',
		'id' 			=> 'sck-shape',
		'section_id' 	=> 'sc_basket',
		'args' 			=> array(
			'options' 	=> array(
				'round' 	=> 'گرد',
				'square' 	=> 'مربع',
			),
		),
		'default' 	=> 'round'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه آیکن',
		'id' 			=> 'sck-size',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 30,
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه جعبه',
		'id' 			=> 'sck-bk-size',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '60',
	),

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'سبد را برای دستگاه های تلفن همراه کوچکتر کنید',
		'id' 			=> 'sck-mob-size',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 'yes',
		'desc' 			=> 'در صورت فعال بودن، تنظیمات فوق برای دستگاه های تلفن همراه بی اثر خواهند بود.'
	),


	array(
		'callback' 		=> 'radio',
		'title' 		=> 'آیکن جعبه سبد خرید',
		'id' 			=> 'sck-basket-icon',
		'section_id' 	=> 'sc_basket',
		'args' 			=> array(
			'options' 	=> array(
				'xoo-wsc-icon-basket1' 		=> 'xoo-wsc-icon-basket1',
				'xoo-wsc-icon-basket2' 		=> 'xoo-wsc-icon-basket2',
				'xoo-wsc-icon-basket3'		=> 'xoo-wsc-icon-basket3',
				'xoo-wsc-icon-basket4' 		=> 'xoo-wsc-icon-basket4',
				'xoo-wsc-icon-basket5' 		=> 'xoo-wsc-icon-basket5',
				'xoo-wsc-icon-basket6' 		=> 'xoo-wsc-icon-basket6',
				'xoo-wsc-icon-cart1' 		=> 'xoo-wsc-icon-cart1',
				'xoo-wsc-icon-cart2' 		=> 'xoo-wsc-icon-cart2',
				'xoo-wsc-icon-bag1' 		=> 'xoo-wsc-icon-bag1',
				'xoo-wsc-icon-bag2' 		=> 'xoo-wsc-icon-bag2',
				'xoo-wsc-icon-shopping-bag1'=> 'xoo-wsc-icon-shopping-bag1',
			),
			'has_asset' 	=> true,
			'asset_type' 	=> 'icon',
			'upload' 		=> 'yes'
		),
		'default' 	=> 'xoo-wsc-icon-basket1'
	),

	array(
		'callback' 		=> 'upload',
		'title' 		=> 'آیکن جعبه سفارشی',
		'id' 			=> 'sck-cust-icon',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت سبد',
		'id' 			=> 'sck-position',
		'section_id' 	=> 'sc_basket',
		'args' 			=> array(
			'options' 	=> array(
				'top' 		=> 'Top',
				'bottom' 	=> 'Bottom',
			),
		),
		'default' 	=> 'bottom'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'افست سبد ↨',
		'id' 			=> 'sck-offset',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 12,
		'desc' 			=> 'موقعیت سبد را به صورت عمودی تغییر می دهد'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'افست سبد ⟷',
		'id' 			=> 'sck-hoffset',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 1,
		'desc' 			=> 'موقعیت سبد را به صورت افقی تغییر می دهد (زمانی که گاری جانبی بسته است)'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ سبد',
		'id' 			=> 'sck-basket-color',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '#000000',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه سبد',
		'id' 			=> 'sck-basket-bg',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'سایه سبد',
		'id' 			=> 'sck-basket-sh',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '0px 0px 15px 2px #0000001a',
		'desc' 			=> xoo_wsc_helper()->box_shadow_desc('0px 0px 15px 2px #0000001a')
	),

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'نمایش شمارش',
		'id' 			=> 'sck-show-count',
		'section_id' 	=> 'sc_basket',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت شمارش',
		'id' 			=> 'sck-count-pos',
		'section_id' 	=> 'sc_basket',
		'args' 			=> array(
			'options' 	=> array(
				'top_right' 	=> 'بالا راست',
				'top_left' 		=> 'بالا چپ',
				'bottom_right'	=> 'پایین راست',
				'bottom_left' 	=> 'پایین چپ=',
			),
		),
		'default' 	=> 'top_left'
	),



	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ شمارش',
		'id' 			=> 'sck-count-color',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه شمارش',
		'id' 			=> 'sck-count-bg',
		'section_id' 	=> 'sc_basket',
		'default' 		=> '#000000',
	),



	/** SIDE CART HEADER **/

	array(
		'callback' 		=> 'select',
		'title' 		=> 'ترازبندی تیتر',
		'id' 			=> 'sch-head-align',
		'section_id' 	=> 'sc_head',
		'args' 			=> array(
			'options' 	=> array(
				'center' 		=> 'وسط',
				'flex-start' 	=> 'چپ',
				'flex-end' 		=> 'راست'
			),
		),
		'default' 	=> 'center'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'ترازبندی آیکن بستن',
		'id' 			=> 'sch-close-align',
		'section_id' 	=> 'sc_head',
		'args' 			=> array(
			'options' 	=> array(
				'left' 		=> 'چپ',
				'right' 	=> 'راست'
			),
		),
		'default' 	=> 'right'
	),

	array(
		'callback' 		=> 'radio',
		'title' 		=> 'آیکن بستن',
		'id' 			=> 'sch-close-icon',
		'section_id' 	=> 'sc_head',
		'args' 			=> array(
			'options' 	=> array(
				'xoo-wsc-icon-cross' => 'xoo-wsc-icon-cross',
				'xoo-wsc-icon-arrow-long-right' => 'xoo-wsc-icon-arrow-long-right',
				'xoo-wsc-icon-arrow-thin-right' => 'xoo-wsc-icon-arrow-thin-right',
				'xoo-wsc-icon-del4' => 'xoo-wsc-icon-del4',
				'xoo-wsc-icon-del1' => 'xoo-wsc-icon-del1',
				'xoo-wsc-icon-del2' => 'xoo-wsc-icon-del2',
				'xoo-wsc-icon-del3' => 'xoo-wsc-icon-del3',
				'xoo-wsc-icon-arrow-left' => 'xoo-wsc-icon-arrow-left',
				'xoo-wsc-icon-arrow-thin-left' => 'xoo-wsc-icon-arrow-thin-left',
			),
			'has_asset' 	=> true,
			'asset_type' 	=> 'icon',
			'upload' 		=> 'yes'
		),
		'default' 	=> 'xoo-wsc-icon-cross',
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه آیکن بستن',
		'id' 			=> 'sch-close-fsize',
		'section_id' 	=> 'sc_head',
		'default' 		=> '16',
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه فونت تیتر',
		'id' 			=> 'sch-head-fsize',
		'section_id' 	=> 'sc_head',
		'default' 		=> '20',
		'desc' 			=> 'اندازه به پیکسل'
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ نوار پیشرفت',
		'id' 			=> 'sch-pbcolor',
		'section_id' 	=> 'sc_head',
		'default' 		=> '#f0f0f0',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پر شدن نوار پیشرفت',
		'id' 			=> 'sch-pbfillcolor',
		'section_id' 	=> 'sc_head',
		'default' 		=> '#000000',
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه',
		'id' 			=> 'sch-bgcolor',
		'section_id' 	=> 'sc_head',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن',
		'id' 			=> 'sch-txtcolor',
		'section_id' 	=> 'sc_head',
		'default' 		=> '#000000',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'حاشیه',
		'id' 			=> 'sch-border',
		'section_id' 	=> 'sc_head',
		'default' 		=> '2px solid #eee',
		'desc' 			=> 'پیشفرض: 2px solid #eee'
	),

	/** SIDE CART BODY **/

	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه فونت',
		'id' 			=> 'scb-fsize',
		'section_id' 	=> 'sc_body',
		'default' 		=> 16,
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه',
		'id' 			=> 'scb-bgcolor',
		'section_id' 	=> 'sc_body',
		'default' 		=> '#f8f9fa',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن',
		'id' 			=> 'scb-txtcolor',
		'section_id' 	=> 'sc_body',
		'default' 		=> '#000000',
	),


	array(
		'callback' 		=> 'upload',
		'title' 		=> 'تصویر سبد خرید خالی',
		'id' 			=> 'scb-empty-img',
		'section_id' 	=> 'sc_body',
		'default' 		=> '',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'نوع حذف',
		'id' 			=> 'scbp-deltype',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'icon' 		=> 'آیکن',
				'text' 		=> 'متن',
			),
		),
		'default' 		=> 'icon',
		'desc' 			=> 'Set text under general -> texts'
	),

	array(
		'callback' 		=> 'radio',
		'title' 		=> 'آیکن حذف',
		'id' 			=> 'scb-del-icon',
		'section_id' 	=> 'sc_body',
		'args' 			=> array(
			'options' 	=> array(
				'xoo-wsc-icon-trash' 	=> 'xoo-wsc-icon-trash',
				'xoo-wsc-icon-trash1' 	=> 'xoo-wsc-icon-trash1',
				'xoo-wsc-icon-trash2' 	=> 'xoo-wsc-icon-trash2',
				'xoo-wsc-icon-cross' 	=> 'xoo-wsc-icon-cross',
				'xoo-wsc-icon-del1'  	=> 'xoo-wsc-icon-del1',
				'xoo-wsc-icon-del2'  	=> 'xoo-wsc-icon-del2',
				'xoo-wsc-icon-del3'  	=> 'xoo-wsc-icon-del3',
				'xoo-wsc-icon-del4'  	=> 'xoo-wsc-icon-del4',
			),
			'has_asset'  => true,
			'asset_type' => 'icon'
		),
		'default' 	=> 'xoo-wsc-icon-trash'
	),


	/** Product Row Layout **/

	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض تصویر',
		'id' 			=> 'scbp-imgw',
		'section_id' 	=> 'scb_product',
		'default' 		=> 28,
		'desc' 			=> 'مقدار به درصد'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ محصول',
		'id' 			=> 'scbp-bgcolor',
		'section_id' 	=> 'scb_product',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'پدینگ محصول',
		'id' 			=> 'scbp-padding',
		'section_id' 	=> 'scb_product',
		'default' 		=> '15px 20px',
		'desc' 			=> '↨ ⟷ ( پیشفرض: 15px 20px )'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'مارجین محصول',
		'id' 			=> 'scbp-margin',
		'section_id' 	=> 'scb_product',
		'default' 		=> '10px 15px',
		'desc' 			=> '↨ ⟷ ( پیشفرض: 10px 15px )'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'شعاع حاشیه محصول',
		'id' 			=> 'scbp-bradius',
		'section_id' 	=> 'scb_product',
		'default' 		=> '5',
		'desc' 			=> 'اندازه به پیکسل'
	),



	array(
		'callback' 		=> 'text',
		'title' 		=> 'سایه',
		'id' 			=> 'scbp-shadow',
		'section_id' 	=> 'scb_product',
		'default' 		=> '0 2px 2px #00000005',
		'desc' 			=> xoo_wsc_helper()->box_shadow_desc('0 2px 2px #00000005')
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'فرمت متغیرها',
		'id' 			=> 'scbp-var-format',
		'section_id' 	=> 'scb_product',
		'args' 			=> array(
			'options' 	=> array(
				'sep_line' 	=> 'نمایش متغیرها در ردیف های جداگانه',
				'one_line'	=> 'نمایش متغیرها در ردیف تکی',
			),
		),
		'default' 	=> 'sep_line',
		'desc' 		=> 'فرمت برای نمایش متغیرهای متعدد'
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'نمایش جزئیات محصول',
		'id' 			=> 'scbp-display',
		'section_id' 	=> 'scb_product',
		'args' 			=> array(
			'options' 	=> array(
				'stretched' 	=> 'به طور مساوی',
				'center' 		=> 'مرکز',
				'flex-start'	=> 'بالا'
			),
		),
		'default' 		=> 'center',
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت دکمه حذف',
		'id' 			=> 'scbp-delpos',
		'section_id' 	=> 'scb_product',
		'args' 			=> array(
			'options' 	=> array(
				'image' 	=> 'زیر تصویر محصول',
				'default' 	=> 'پیشفرض',
			),
		),
		'default' 		=> 'default',
	),



	


	/** SIDE CART BODY Quantity **/

	array(
		'callback' 		=> 'select',
		'title' 		=> 'استایل تعداد ورودی',
		'id' 			=> 'scbq-style',
		'section_id' 	=> 'scb_qty',
		'args' 			=> array(
			'options' 	=> array(
				'square' 	=> 'گوشه های مربع',
				'circle' 	=> 'گوشه های گرد',
			),
		),
		'default' 	=> 'square'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض جعبه',
		'id' 			=> 'scbq-width',
		'section_id' 	=> 'scb_qty',
		'default' 		=> 75,
		'desc' 			=> 'اندازه به پیکسل'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> '+/- اندازه دکمه ها',
		'id' 			=> 'scbq-btnsize',
		'section_id' 	=> 'scb_qty',
		'default' 		=> 20,
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'ارتفاع جعبه',
		'id' 			=> 'scbq-height',
		'section_id' 	=> 'scb_qty',
		'default' 		=> 28,
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه حاشیه',
		'id' 			=> 'scbq-bsize',
		'section_id' 	=> 'scb_qty',
		'default' 		=> 1,
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ حاشیه ورودی',
		'id' 			=> 'scbq-input-bcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#000000',
		'desc' 			=> 'برای حذف حاشیه خالی بگذارید'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ حاشیه جعبه',
		'id' 			=> 'scbq-box-bcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#000000',
		'desc' 			=> 'برای حذف حاشیه خالی بگذارید'
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه ورودی',
		'id' 			=> 'scbq-input-bgcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن ورودی',
		'id' 			=> 'scbq-input-txtcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#000000',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> '+/- رنگ پس زمینه دکمه ها',
		'id' 			=> 'scbq-box-bgcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> '+/- رنگ متن دکمه ها',
		'id' 			=> 'scbq-box-txtcolor',
		'section_id' 	=> 'scb_qty',
		'default' 		=> '#000000',
	),

	/** SIDE CART FOOTER **/

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'چسبیده به پایین',
		'id' 			=> 'scf-stick',
		'section_id' 	=> 'sc_footer',
		'default' 		=> 'yes',
		'desc' 			=> 'اگر فعال باشد، پاورقی به پایین چسبانده می شود.'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت جمع کل سبد خرید',
		'id' 			=> 'scf-totals-loc',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 	=> array(
				'footer'		=> 'پاورقی',
				'body' 			=> 'بدنه اصلی',
				'mobile_body' 	=> 'بدنه اصلی در موبایل'
			),
		),
		'default' 	=> 'footer'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'پدینگ',
		'id' 			=> 'scf-padding',
		'section_id' 	=> 'sc_footer',
		'default' 		=> '10px 20px',
		'desc' 			=> '↨ ⟷ ( پیشفرض: 10px 20px ), از مقادیر استفاده کنید'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه فونت',
		'id' 			=> 'scf-fsize',
		'section_id' 	=> 'sc_footer',
		'default' 		=> '15',
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه',
		'id' 			=> 'scf-bgcolor',
		'section_id' 	=> 'sc_footer',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن',
		'id' 			=> 'scf-txtcolor',
		'section_id' 	=> 'sc_footer',
		'default' 		=> '#000000',
	),



	array(
		'callback' 		=> 'text',
		'title' 		=> 'سایه',
		'id' 			=> 'scf-shadow',
		'section_id' 	=> 'sc_footer',
		'default' 		=> '0 -5px 10px #0000001a',
		'desc' 			=> xoo_wsc_helper()->box_shadow_desc('0 -5px 10px #0000001a')
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'نمایش فرم کوپن در',
		'id' 			=> 'scf-coup-display',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 	=> array(
				'slider'		=> 'اسلایدر',
				'main' 			=> 'اصلی',
			),
		),
		'default' 	=> 'slider'
	),

	array(
		'callback' 		=> 'radio',
		'title' 		=> 'آیکن کوپن',
		'id' 			=> 'scf-coup-icon',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 	=> array(
				'xoo-wsc-icon-coupon' 			=> 'xoo-wsc-icon-coupon',
				'xoo-wsc-icon-coupon-1' 		=> 'xoo-wsc-icon-coupon-1',
				'xoo-wsc-icon-coupon-2' 		=> 'xoo-wsc-icon-coupon-2',
				'xoo-wsc-icon-coupon-3' 		=> 'xoo-wsc-icon-coupon-3',
				'xoo-wsc-icon-coupon-4' 		=> 'xoo-wsc-icon-coupon-4',
				'xoo-wsc-icon-coupon-5' 		=> 'xoo-wsc-icon-coupon-5',
				'xoo-wsc-icon-coupon-6' 		=> 'xoo-wsc-icon-coupon-6',
				'xoo-wsc-icon-coupon-7' 		=> 'xoo-wsc-icon-coupon-7',
				'xoo-wsc-icon-coupon-8' 		=> 'xoo-wsc-icon-coupon-8',
			),
			'has_asset' 	=> true,
			'asset_type' 	=> 'icon',
			'upload' 		=> 'yes'
		),
		'default' 	=> 'xoo-wsc-icon-coupon-8'
	),

	array(
		'callback' 		=> 'sortable',
		'title' 		=> 'موقعیت دکمه',
		'id' 			=> 'scf-button-pos',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 		=> array(
				'continue' 	=> 'Continue Shopping',
				'cart' 		=> 'مشاهده سبد خرید',
				'checkout'	=> 'بررسی'
			),
			'display' 	=> 'vertical'
		),
		'default' => array( 'cart', 'continue', 'checkout' ),
		'desc' 	=> 'برای تغییر ترتیب بکشید. متن دکمه را در زیر دکمه general -> texts to remove خالی بگذارید'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'ردیف دکمه',
		'id' 			=> 'scf-btns-row',
		'section_id' 	=> 'sc_footer',
		'args' 			=> array(
			'options' 	=> array(
				'one'		=> 'یکی در هر ردیف (1+1+1)',
				'two_one' 	=> 'دو تا در اولین ردیف (2+1)',
				'one_two' 	=> 'دو تا در ردیف دوم (1+2)',
				'three' 	=> 'سه تا در اولین ردیف (3)'
			),
		),
		'default' 	=> 'two_one'
	),


	array(
		'callback' 		=> 'select',
		'title' 		=> 'طراحی',
		'id' 			=> 'scf-btns-theme',
		'section_id' 	=> 'sc_button',
		'args' 			=> array(
			'options' 	=> array(
				'theme'		=> 'از طرح و رنگ دکمه تم استفاده کنید',
				'custom' 	=> 'سفارشی',
			),
		),
		'default' 	=> 'custom',
		'desc' 		=> 'اگر روی طرح تم تنظیم شود، همه گزینه های زیر بی اثر خواهند بود. طراحی دکمه تم می تواند متناقض باشد و از موضوعی به موضوع دیگر متفاوت باشد.'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'پدینگ',
		'id' 			=> 'scf-btn-padding',
		'section_id' 	=> 'sc_button',
		'default' 		=> '10px 20px',
		'desc' 			=> '↨ ⟷ ( پیشفرض: 10px 20px ), از مقادیر استفاده کنید'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه',
		'id' 			=> 'scf-btn-bgcolor',
		'section_id' 	=> 'sc_button',
		'default' 		=> '#000000',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن',
		'id' 			=> 'scf-btn-txtcolor',
		'section_id' 	=> 'sc_button',
		'default' 		=> '#ffffff',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'حاشیه',
		'id' 			=> 'scf-btn-border',
		'section_id' 	=> 'sc_button',
		'default' 		=> '2px solid #ffffff',
		'desc' 			=> 'پیشفرض: 2px solid #000000'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه هاور',
		'id' 			=> 'scf-btnhv-bgcolor',
		'section_id' 	=> 'sc_button',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن هاور',
		'id' 			=> 'scf-btnhv-txtcolor',
		'section_id' 	=> 'sc_button',
		'default' 		=> '#000000',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'حاشیه هاور',
		'id' 			=> 'scf-btnhv-border',
		'section_id' 	=> 'sc_button',
		'default' 		=> '2px solid #000000',
		'desc' 			=> 'پیشفرض: 2px solid #000000'
	),


	/** Suggested products **/

	array(
		'callback' 		=> 'select',
		'title' 		=> 'موقعیت',
		'id' 			=> 'scsp-main-location',
		'section_id' 	=> 'sc_sug_products',
		'args' 			=> array(
			'options' 	=> array(
				'drawer' 	=> 'منوی کشویی',
				'before' 	=> 'قبل از جمع کل',
				'after' 	=> 'بعد از جمع کل',
			),
		),
		'default' 	=> 'drawer'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض منوی کشویی',
		'id' 			=> 'scs-drawer-width',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '350',
		'desc' 			=> 'اندازه به پیکسل'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'باز شدن منوی کشویی بعد از چند ثانیه',
		'id' 			=> 'scs-drawer-wait',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '500',
		'desc' 			=> '1000 = 1 second'
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'سبک',
		'id' 			=> 'scsp-style',
		'section_id' 	=> 'sc_sug_products',
		'args' 			=> array(
			'options' 	=> array(
				'narrow' 	=> 'باریک',
				'wide' 		=> 'عریض',
				'column' 	=> 'ستون'
			),
		),
		'default' 	=> 'wide'
	),


		array(
		'callback' 		=> 'number',
		'title' 		=> 'تعداد محصولات در هر ستون',
		'id' 			=> 'scsp-col-items',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> 2,
	),



	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'اسلایدر',
		'id' 			=> 'scsp-slide-en',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> 'yes',
	),



	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'اسلاید خودکار',
		'id' 			=> 'scsp-slide-auto',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> 'yes',
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'سرعت اسلاید',
		'id' 			=> 'scsp-slide-timer',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> 5000,
		'desc' 			=> '1000 = 1 ثانیه'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض تصویر',
		'id' 			=> 'scsp-imgw',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '80',
		'desc' 			=> 'مقدار به پیکسل'
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه فونت',
		'id' 			=> 'scsp-fsize',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '14',
		'desc' 			=> 'اندازه به پیکسل'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> ' رنگ پس زمینه کانتینر',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '#eee',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه محصول',
		'id' 			=> 'scsp-prd-bgcolor',
		'section_id' 	=> 'sc_sug_products',
		'default' 		=> '#fff',
	),


	/***** Shortcode ****/

	array(
		'callback' 		=> 'number',
		'title' 		=> 'اندازه آیکن',
		'id' 			=> 'shbk-size',
		'section_id' 	=> 'sh_bk',
		'default' 		=> 28,
		'desc' 			=> 'اندازه به پیکسل'
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ آیکن',
		'id' 			=> 'shbk-color',
		'section_id' 	=> 'sh_bk',
		'default' 		=> '#000000',
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ شمارش',
		'id' 			=> 'shbk-count-color',
		'section_id' 	=> 'sh_bk',
		'default' 		=> '#ffffff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه شمارش',
		'id' 			=> 'shbk-count-bg',
		'section_id' 	=> 'sh_bk',
		'default' 		=> '#000000',
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن',
		'id' 			=> 'shbk-txt-color',
		'section_id' 	=> 'sh_bk',
		'default' 		=> '#000000',
	),


	/* Product card */

	array(
		'callback' 		=> 'checkbox',
		'title' 		=> 'فعالسازی طرحبندی سبد خرید',
		'id' 			=> 'scbp-card-en',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> 'no',
		'desc' 			=> '',
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'تعداد خرید در هر ردیف',
		'id' 			=> 'scbp-card-count',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '2',
	),

	
	array(
		'callback' 		=> 'select',
		'title' 		=> 'نمایش جزئیات',
		'id' 			=> 'scbp-card-visible',
		'section_id' 	=> 'scb_productcard',
		'args' 			=> array(
			'options' 	=> array(
				'all_on_front'		=> 'همه چیز در جلو',
				'back_hover' 		=> 'سمت عقب در هاور',
				'back_click' 		=> 'سمت عقب با کلیک',
			),
		),
		'default' 		=> 'back_hover',
	),

	array(
		'callback' 		=> 'checkbox_list',
		'title' 		=> 'جزئیات برای نمایش در پشت کارت <br>اگر علامت را بردارید، در جلو نشان داده می شود.',
		'id' 			=> 'scbp-card-back',
		'section_id' 	=> 'scb_productcard',
		'args' 			=> array(
			'options' 	=> array(
				'total_sales' 	=> 'شمارش فروش محصولات',
				'name' 	=> 'نام محصول',
				'price' => 'قیمت محصول',
				'qty' 	=> 'تعداد محصول',
				'total' => 'جمع کل محصول',
				'meta' 	=> 'متغیرهای محصول',
				'link' 	=> 'مشاهده لینک محصول',
			),
		),
		'default' 	=> array(
			'total_sales', 'name', 'link', 'meta', 'price'
		),
		'desc' 		=> 'این فقط نمایشگر پشت و جلو را کنترل می کند. برای فعال کردن/غیرفعال کردن جزئیات به برگه کلی -> بدنه سبد خرید -> نمایش و تیک زدن/انتخاب جزئیات از آنجا بروید.',
		'pro' => array(
			'total_sales'
		)
	),

	array(
		'callback' 		=> 'select',
		'title' 		=> 'انیمیشن نمایش جزئیات سبد خرید',
		'id' 			=> 'scbp-card-anim-type',
		'section_id' 	=> 'scb_productcard',
		'args' 			=> array(
			'options' 	=> array(
				'openUpLeft'		=> 'openUpLeft',
				'openDownRight'		=> 'openDownRight',
				'openUpLeft'		=> 'openUpLeft',
				'openUpRight'		=> 'openUpRight',
				'perspectiveDown'	=> 'perspectiveDown',
				'perspectiveUp'		=> 'perspectiveUp',
				'perspectiveLeft'	=> 'perspectiveLeft',
				'perspectiveRight'	=> 'perspectiveRight',
				'slideDown' 		=> 'slideDown',
				'slideUp' 			=> 'slideUp',
				'slideLeft' 		=> 'slideLeft',
				'slideRight' 		=> 'slideRight'
			),
		),
		'default' 		=> 'slideUp',
	),

	array(
		'callback' 		=> 'text',
		'title' 		=> 'انیمیشن زمان',
		'id' 			=> 'scbp-card-anim-time',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '0.5',
		'desc' 			=> 'به ثانیه'
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه تصویر',
		'id' 			=> 'scbp-card-img-color',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '#eee',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه جزئیات سمت عقب',
		'id' 			=> 'scbp-card-back-color',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '#fff',
	),


	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ پس زمینه جزئیات جلویی',
		'id' 			=> 'scbp-card-front-color',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '#eee',
	),

	array(
		'callback' 		=> 'color',
		'title' 		=> 'رنگ متن سبد خرید',
		'id' 			=> 'scbp-card-txtcolor',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '#000',
	),


	array(
		'callback' 		=> 'number',
		'title' 		=> 'عرض تصویر',
		'id' 			=> 'scbp-card-imgw',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> 100,
		'desc' 			=> 'مقدار به درصد'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'فاصله بین محصولات',
		'id' 			=> 'scbp-card-padding',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '10px 10px',
		'desc' 			=> '↨ ⟷ ( پیشفرض: 10px 10px )'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'حاشیه سبد خرید',
		'id' 			=> 'scbp-card-border',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '0',
		'desc' 			=> 'به طور مثال:  2px solid #777'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'شعاع حاشیه بالایی سبد خرید',
		'id' 			=> 'scbp-card-radius-top',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '5',
		'desc' 			=> 'به px'
	),

	array(
		'callback' 		=> 'number',
		'title' 		=> 'شعاع حاشیه پایینی سبد خرید',
		'id' 			=> 'scbp-card-radius-btm',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '5',
		'desc' 			=> 'به px'
	),


	array(
		'callback' 		=> 'text',
		'title' 		=> 'سایه',
		'id' 			=> 'scbp-card-shadow',
		'section_id' 	=> 'scb_productcard',
		'default' 		=> '0px 10px 15px -12px #0000001a',
		'desc' 			=> xoo_wsc_helper()->box_shadow_desc('0px 10px 15px -12px #0000001a')
	),


);

return apply_filters( 'xoo_wsc_admin_settings', $settings, 'style' );
?>