<?php
	
$options = apply_filters( 'xoo_aff_export_options', $adminObj->tabs, $adminObj->helper->slug );


?>

<div class="xoo-settings-container">

	<ul class="xoo-sc-tabs">
		<?php foreach( $tabs as $tab_id => $tab_data ): ?>
			<li data-tab="<?php echo esc_attr( $tab_id ); ?>" <?php if( $tab_data['pro'] === 'yes' ) echo 'class="xoo-as-is-pro"'; ?>><?php echo esc_html( $tab_data['title'] ); ?></li>
		<?php endforeach; ?>
	</ul>

	<form class="xoo-as-form">

		<?php foreach( $tabs as $tab_id => $tab_data ): ?>
			<div class="xoo-sc-tab-content <?php if( $tab_data['pro'] === 'yes' ) echo 'xoo-as-is-pro'; ?>" data-tab="<?php echo esc_attr( $tab_id ); ?>">
				<?php do_action( 'xoo_tab_page_start', $tab_id, $tab_data ); ?>
				<?php $adminObj->create_settings_html( $tab_id ); ?>
				<?php do_action( 'xoo_tab_page_end', $tab_id, $tab_data ); ?>
			</div>
		<?php endforeach; ?>

		<div class="xoo-sc-bottom-btns">
			<?php if( $hasPRO ): ?>
				<a class="xoo-as-pro-toggle">نمایش گزینه های پرو</a>
				<a class="xoo-as-pro-toggle xoo-aspt-two">پنهان سازی گزینه های پرو</a>
			<?php endif; ?>
			<button type="submit" class="xoo-as-form-save">ذخیره</button>
			<a class="xoo-as-form-reset" href="<?php echo esc_url( add_query_arg( 'reset', wp_create_nonce('reset') ) ) ?>">باز نشانی</a>
			<div class="xoo-as-exim">
				<div class="xoo-as-eximbtns" style="display: none;">
					<span class="xoo-as-setexport" >برون بری تنظیمات</span>
					<span class="xoo-as-setimport">درون ریزی تنظیمات</span>
				</div>
				<span class="dashicons dashicons-move"></span>
			</div>
		</div>

	</form>

	<div class="xoo-as-modal">

		<div class="xoo-as-expimmodal">
			
			<div class="xoo-as-emod-cont">

				<span class="xoo-as-exipclose">X</span>

				<div class="xoo-as-excont">

					<div class="xoo-as-exoptions">

						<span>برون بری تنظیمات</span>

						<div class="xoo-as-expcheck">
							<?php

							foreach ( $options as $id => $data ) {
								if( !$data['option_key'] ) continue;
								?>
								<label>
									<?php esc_html_e( $data['title'] ); ?>
									<input type="checkbox" value="<?php echo esc_attr( $data['option_key'] ) ?>" checked>
								</label>
								<?php
							}

							?>
						</div>

						<i>هرگونه تغییر ذخیره نشده برون بری نخواهد شد. لطفاً تنظیمات را ذخیره کنید.</i>
					

						<button class="xoo-as-run-export">برون بری</button>

					</div>

					<div class="xoo-as-expdone">

						<b>مقدار زیر را کپی کرده و در ویژگی «واردات تنظیمات» در وب‌سایتی که می‌خواهید آن را وارد کنید، جای‌گذاری کنید</b>
						<i>تنظیمات آپلود فایل/تصویر باید به صورت دستی انجام شود.</i>

						<textarea rows="10"></textarea>

					</div>
				</div>

				<div class="xoo-as-impcont">
					<b>مقدار کپی شده را اینجا قرار دهید.</b>
					<i>تنظیمات آپلود فایل/تصویر باید به صورت دستی انجام شود.</i>
					<textarea rows="10"></textarea>
					<button class="xoo-as-run-import">اجرای درون ریزی</button>
					<span class="xoo-as-imported">درون ریزی انجام شد. در حال رفرش ...</span>
				</div>
			</div>
		</div>
	</div>
</div>