<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wooninjas.com/
 * @since      1.0.0
 *
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/admin
 * @author     WooNinjas <info@wooninjas.com>
 */
class Tutorlms_Certificate_Verify_And_Share_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		if ( isset( $_GET['page'] ) && 'tutorlms-certificate-verify-and-share' === rtrim( $_GET['page'] ) ) { 

			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/tutorlms-certificate-verify-and-share-admin.css', array(), $this->version, 'all' );

			// Font awesome
			wp_enqueue_style( 'tutorlms-cvs-fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', array(), $this->version );
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/tutorlms-certificate-verify-and-share-admin.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Add plugin action links
	 *
	 * @param $links
	 *
	 * @return mixed
	 */
	public function plugin_action_links( $links ) {
		
		$settings = '<a href="' . admin_url('admin.php?page=' . $this->plugin_name) . '">'. __( 'Settings', 'tutorlms-certificate-verify-and-share' ). '</a>';
		
		array_unshift( $links, $settings );
		return $links;
	}

	/**
	 * Add plugin's menu
	 */
	public function admin_menu() {

		add_submenu_page(
			'tutor',
			__( 'تایید و به اشتراک گذاری گواهینامه', 'tutorlms-certificate-verify-and-share' ),
			__( 'تایید و به اشتراک گذاری گواهینامه', 'tutorlms-certificate-verify-and-share' ),
			'manage_options',
			$this->plugin_name,
			[ $this, 'plugin_page' ]
		);
	}

	public function plugin_row_meta($links, $file) {

		if ( plugin_basename( TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_FILE ) === $file ) {
			$row_meta = array(
				'docs'    => '<a href="' . esc_url( apply_filters( 'Tutorlms_Certificate_Verify_And_Share_docs_url', 'https://wooninjas.com/docs/tutorlms-addons/tutorlms-certificate-verify-and-share' ) ) . '" aria-label="' . sprintf( esc_attr__( 'View %s documentation', 'tutorlms-certificate-verify-and-share' ), $this->plugin_name ) . '" target="_blank">' . esc_html__( 'Docs', 'tutorlms-certificate-verify-and-share' ) . '</a>',
				'support' => '<a href="' . esc_url( apply_filters( 'Tutorlms_Certificate_Verify_And_Share_support_url', 'https://wooninjas.com/open-support-ticket/' ) ) . '" aria-label="' . esc_attr__( 'Visit premium customer support', 'tutorlms-certificate-verify-and-share' ) . '" target="_blank">' . esc_html__( 'Premium support', 'tutorlms-certificate-verify-and-share' ) . '</a>',
			);

			return array_merge( $links, $row_meta );
		}

		return (array) $links;
	}

	/**
	 * Plugin Review Notice
	 */
	public function plugin_review_notice() {

		if( ! current_user_can('manage_options') || ! is_admin() || ! is_plugin_active(  plugin_basename ( TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_FILE ) ) ) {
			return;
		}

		$user_id = get_current_user_id();
		$review_dismissed_key = $this->plugin_name . '_review_dismissed_' . $user_id;
		$review_dismissed_action_key = $this->plugin_name . '_dismiss_notice';

		if( isset( $_GET[$review_dismissed_action_key] ) ) {
			set_transient($review_dismissed_key, 1, MONTH_IN_SECONDS);
		}

		
	}

	/**
	 * Add branding to footer
	 *
	 * @param $footer_text
	 *
	 * @return mixed
	 */
	public function admin_footer_text( $footer_text ) {
		if( isset( $_GET['page'] ) && ( $_GET['page'] == $this->plugin_name ) ) {
			_e('Powered by <a href="http://www.wordpress.org" target="_blank">WordPress</a> | Designed &amp; Developed by <a href="https://wooninjas.com" target="_blank">WooNinjas</a></p>', 'tutorlms-certificate-verify-and-share');
		} else {
			return $footer_text;
		}
	}

	public function plugin_page() {
		$page_tab = ( isset($_GET['tab'] ) && ! empty( $_GET['tab'] ) ) ? $_GET['tab'] : 'license';

		?>
		<div class="wrap wn_wrap">

			<?php settings_errors(); ?>
			<div id="icon-options-general" class="icon32"></div>
			<h1 class="tlms-cvs-main-title"><?php echo __( 'TutorLMS Certificate Verify And Share', 'tutorlms-certificate-verify-and-share' ); ?></h1>

			<div class="tlms-cvs-nav">
				<?php
				$sections = $this->get_sections();
				$url = admin_url('admin.php?page=' . $this->plugin_name);

				foreach($sections as $key => $section ) {
					$url = add_query_arg('tab', $key, $url);

					if(isset($section['action'])) {
						$url = add_query_arg('action', $section['action'], $url);
					} else {
						remove_query_arg('action', $url);
					}

					if( isset( $section['id'] ) ) {
						$url = add_query_arg('id', $section['id'], $url);
					} else {
						remove_query_arg('id', $url);
					}
					?>
					<a href="<?php echo $url; ?>"
					   class="nav-tab <?php echo $page_tab == $key ? 'nav-tab-active' : ''; ?>">
						<i class="dashicons dashicons-<?php echo $section['icon']; ?>" aria-hidden="true"></i>
						<?php echo $section['title']; ?>
					</a>
					<?php
				}
				?>
			</div>

			<?php
			foreach( $sections as $key => $section ) {
				if( $page_tab == $key ) {
					include( 'partials/' . $key . '.php' );
				}
			}
			?>

		</div>
		<?php
	}

	private function get_sections() {
		$tutorlms_cvs_settings = get_option( '__tutorlms_cvs_plugin_global_settings' );
		$sections = array(

			
			'settings' => array(
				'title' => __( 'تنظیمات', 'tutorlms-course-import-export' ),
				'icon' => 'upload',
			),
			'logs' => array(
				'title' => __( 'Certificate Logs', 'tutorlms-certificate-verify-and-share' ),
				'icon' => 'editor-table',
			),
		);

		if( isset( $tutorlms_cvs_settings['tutorlms_cvs_wp_log'] ) && $tutorlms_cvs_settings['tutorlms_cvs_wp_log'] == '1' ) {
			$sections['debug-logs'] = array(
				'title' => __( 'Debug Logs', 'tutorlms-course-import-export' ),
				'icon' => 'upload',
			);
			$sections['systems-info'] = array(
				'title' => __( 'Systems Information', 'tutorlms-course-import-export' ),
				'icon' => 'download',
			);	
		}
		return $sections;
	}



	/**
	 * Certificate expiration metabox
	 *
	 * @since v.1.5.1
	 */
	public function add_certificate_expiration_metabox() {

		add_meta_box(
        	'tutor_certificate_expiration_metabox',
        	esc_html( 'Certificate Expiration', 'tutorlms-certificate-verify-and-share' ),
        	[ $this, 'tutor_certificate_expiration_metabox_callback' ],
        	'courses',
        	'normal',
        	'high'
    	);
	}

	public function tutor_certificate_expiration_metabox_callback( $post ) {
		
		$post_id = isset( $_GET['post'] ) ? absint( $_GET['post'] ) : $post->ID;
		$enable_certificate_expiration = get_post_meta( $post_id, '_tutor_enable_certificate_expiration', true );
		$duration 		= get_post_meta( $post_id, '_tutor_certificate_expiration_duration', true );
		$duration_type 	= get_post_meta( $post_id, '_tutor_certificate_expiration_duration_type', true );

		?>
		<!-- Toggle: Enable certificate feature -->
		<div class="tutor-row tutor-mb-32" style="padding:10px;">
			<div class="tutor-col-12 tutor-col-md-5">
				<label class="tutor-course-setting-label" style="font-size:16px; font-weight: 500;">
					<?php esc_html_e( 'Enable Certificate Expiration', 'tutorlms-certificate-verify-and-share' ); ?>
				</label>
			</div>
			<div class="tutor-col-12 tutor-col-md-7">
				<label class="tutor-form-toggle">
					<input id="course_setting_toggle_switch__tutor_enable_certificate_expiration" 
						type="checkbox" 
						class="tutor-form-toggle-input" 
						name="_tutor_enable_certificate_expiration"
						value="on" 
						<?php echo $enable_certificate_expiration == 'on' ? 'checked="checked"' : '' ?> >
					<span class="tutor-form-toggle-control"></span>
				</label>
				<div class="tutor-fs-7 tutor-has-icon tutor-color-muted tutor-d-flex tutor-mt-12">
					<i class="tutor-icon-circle-info-o tutor-mt-4 tutor-mr-8"></i>
					<?php esc_html_e( 'Enable certificate expiration feature', 'tutorlms-certificate-verify-and-share' ); ?>
				</div>
			</div>
		</div>

		<!-- Input: Duration -->
		<div class="tutor-row tutor-mb-32" id="tutor_expiration_duration_div" style="padding:10px;">
			<div class="tutor-col-12 tutor-col-md-5">
				<label class="tutor-course-setting-label" style="font-size:16px; font-weight: 500;">
					<?php esc_html_e( 'Duration', 'tutorlms-certificate-verify-and-share' ); ?>
				</label>
			</div>
			<div class="tutor-col-12 tutor-col-md-7">
				<input 
					id="tutor_expiration_duration" 
					class="tutor-form-control" 
					type="number" 
					name="_tutor_certificate_expiration_duration" 
					value="<?php echo $duration; ?>" 
					min="1">
				<div class="tutor-fs-7 tutor-has-icon tutor-color-muted tutor-d-flex tutor-mt-12">
					<i class="tutor-icon-circle-info-o tutor-mt-4 tutor-mr-8"></i>
					<?php esc_html_e( 'Number of days/month/year after certificate will expire', 'tutorlms-certificate-verify-and-share' ); ?>
				</div>
			</div>
		</div>

		<?php $options = array( 'days' => 'Days', 'months' => 'Months', 'years' => 'Years' ); ?>

		<!-- Select: Duration type -->
		<div class="tutor-row tutor-mb-32" style="padding:10px;" id="tutor_expiration_duration_type_div">
			<div class="tutor-col-12 tutor-col-md-5">
				<label class="tutor-course-setting-label" style="font-size:16px; font-weight: 500;">
					<?php esc_html_e( 'Duration Type', 'tutorlms-certificate-verify-and-share' ); ?>
				</label>
			</div>
			<div class="tutor-col-12 tutor-col-md-7">
				<select class="tutor-form-select" name="_tutor_certificate_expiration_duration_type" class="tutor_select2">
					<?php

					if ( ! empty( $options ) ) {
						foreach ( $options as $option_key => $option ) {
					?>
						<option value="<?php echo esc_attr( $option_key ); ?>" <?php selected( $duration_type, $option_key ); ?> >
							<?php echo esc_html( $option ); ?>
						</option>
					<?php
						}
					}
					?>
				</select>
				<div class="tutor-fs-7 tutor-has-icon tutor-color-muted tutor-d-flex tutor-mt-12">
					<i class="tutor-icon-circle-info-o tutor-mt-4 tutor-mr-8"></i>
					<?php esc_html_e( 'Type of duration for certificate expiration', 'tutorlms-certificate-verify-and-share' ); ?>
				</div>
			</div>
		</div>
		<?php
	}

	public function tutor_certificate_expiration_save_metabox( $post_id ) {

		// Check the logged in user has permission to edit this post
		if ( ! current_user_can( 'manage_options' ) ) {
			return false;
		}

		// Save or Update : Expiration enable.
		if ( isset( $_POST['_tutor_enable_certificate_expiration'] ) ) {
			update_post_meta( $post_id, '_tutor_enable_certificate_expiration', sanitize_text_field( $_POST['_tutor_enable_certificate_expiration'] ) );
		} else {
			update_post_meta( $post_id, '_tutor_enable_certificate_expiration', '' );
		}

		// Save or Update : Duration.
		if ( isset( $_POST['_tutor_certificate_expiration_duration'] ) ) {
			update_post_meta( $post_id, '_tutor_certificate_expiration_duration', absint( $_POST['_tutor_certificate_expiration_duration']) );
		} else {
			update_post_meta( $post_id, '_tutor_certificate_expiration_duration', 1 );
		}

		// Save or Update : Duration type.
		if ( isset( $_POST['_tutor_certificate_expiration_duration_type'] ) ) {
			update_post_meta( $post_id, '_tutor_certificate_expiration_duration_type', sanitize_text_field( $_POST['_tutor_certificate_expiration_duration_type'] ) );
		} else {
			update_post_meta( $post_id, '_tutor_certificate_expiration_duration_type', 'days' );
		}

	}

	public function upgrade_or_revoke_certificate() {

		$certificate_id = isset( $_GET['certificate_id'] ) ? absint( $_GET['certificate_id'] ) : 0;
		$course_id = isset( $_GET['course_id'] ) ? absint( $_GET['course_id'] ) : 0;
		$action_id = isset( $_GET['action'] ) ? sanitize_text_field( $_GET['action'] ) : 0;
		$user_id   = isset( $_GET['user_id'] ) ? sanitize_text_field( $_GET['user_id'] ) : 0;

		if( ( isset( $_GET['page'] ) && 'tutorlms-certificate-verify-and-share' === $_GET['page'] ) && 
			( isset( $_GET['tab'] ) && 'logs' === $_GET['tab'] ) ) {

			if ( 'revoke' === $action_id ) {

				update_comment_meta( $certificate_id, '_certificate_status_' . $course_id, 'expire' );
				
				Tutorlms_Certificate_Verify_And_Share_WP_Logging::add( 
	                $title          = __( 'Admin Activity', 'tutorlms-certificate-verify-and-share' ), 
	                $message        = sprintf( __( 'Admin revoked certificate of user with ID: %d', 'tutorlms-certificate-verify-and-share' ), absint( $user_id ) ),
	                $post_parent    = 0, // ID of post where settings are loaded
	                $log_type       = 'event' 
	            );

			} elseif ( 'upgrade' === $action_id ) {
				
				// Update date to current date then add status as active
				$this->update_certificate_award_date( $certificate_id );
				update_comment_meta( $certificate_id, '_certificate_status_' . $course_id, 'active' );

				Tutorlms_Certificate_Verify_And_Share_WP_Logging::add( 
	                $title          = __( 'Admin Activity', 'tutorlms-certificate-verify-and-share' ), 
	                $message        = sprintf( __( 'Admin upgraded certificate of user with ID: %d', 'tutorlms-certificate-verify-and-share' ), absint( $user_id ) ),
	                $post_parent    = 0, // ID of post where settings are loaded
	                $log_type       = 'event' 
	            );

			}
		}

	}

	private function update_certificate_award_date( $certificate_id ) {
		
		global $wpdb;
		
		$current_date = date('Y-m-d');

		$result = $wpdb->get_results( 	
			$wpdb->prepare( "UPDATE $wpdb->comments SET `comment_date` = %s WHERE `wp_comments`.`comment_ID` = %d", 
				$current_date,
				absint( $certificate_id )
			)
		);
	}

	/**
	 * Save the plugin's settings.
	 */
	public function save_settings() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// Check if we are on the plugin settings page.
		if ( isset( $_REQUEST['page'] ) && 'tutorlms-certificate-verify-and-share' === rtrim( $_REQUEST['page'] ) ) {

			// Check if the active tab is settings.
			if ( isset( $_REQUEST['tab'] ) && 'settings' === rtrim( $_REQUEST['tab'] ) ) {

				if ( ! empty( $_POST ) ) {
					$tutorlms_cvs_nonce = isset( $_POST['tutorlms_certificate_verify_and_share_nonce'] ) ? $_POST['tutorlms_certificate_verify_and_share_nonce'] : -100;

					// Check if the nonce is valid.
					if ( ! wp_verify_nonce( $tutorlms_cvs_nonce, 'tutorlms_certificate_verify_and_share_nonce' ) ) {
						die( 'Process stopped, request could not be verified. Please contact the administrator.' );
					}

					$tutor_cvs_settings = get_option( '__tutorlms_cvs_plugin_global_settings', array() );

					$tutor_cvs_settings['tutorlms_cvs_wp_log'] = isset( $_POST['tutorlms_cvs_wp_log'] ) ? $_POST['tutorlms_cvs_wp_log'] : '';
					// Update tutor_cvs global settings.
					update_option( '__tutorlms_cvs_plugin_global_settings', $tutor_cvs_settings );

					Tutorlms_Certificate_Verify_And_Share_WP_Logging::add( 
		                $title          = __( 'Admin Activity', 'tutorlms-certificate-verify-and-share' ), 
		                $message        = __( 'General settings updated', 'tutorlms-certificate-verify-and-share' ),
		                $post_parent    = 0, // ID of post where settings are loaded
		                $log_type       = 'event' 
		            );
				}
			}
		}
	}

	private function get_server_information() {
		
		return array(
	        'PHP Version' 			=> phpversion(),
	        'PHP OS' 				=> PHP_OS,
	        'PHP OS Family' 		=> php_uname('s'),
	        'max_execution_time' 	=> ini_get('max_execution_time'),
	        'max_file_uploads' 		=> ini_get('max_file_uploads'),
	        'max_input_time' 		=> ini_get('max_input_time'),
	        'max_input_vars' 		=> ini_get('max_input_vars'),
	        'post_max_size' 		=> ini_get('post_max_size'),
	        'upload_max_filesize' 	=> ini_get('upload_max_filesize'),
	        'curl Version' 			=> curl_version()['version'],
	        'SSL Version' 			=> curl_version()['ssl_version'],
	        'Libz Version' 			=> curl_version()['libz_version'],
	        'Protocols' 			=> implode(', ', curl_version()['protocols']),
	        'mbstring' 				=> extension_loaded('mbstring') ? 'Yes' : 'No',
	        'WordPress Version' 	=> get_bloginfo('version'),
	        'WordPress Home URL' 	=> home_url(),
	        'WordPress Site URL' 	=> site_url(),
	        'Is Multisite' 			=> is_multisite() ? 'Yes' : 'No',
	        'Site Language' 		=> get_locale(),
	        'Object Cache' 			=> defined('WP_CACHE') && WP_CACHE ? 'Yes' : 'No',
	        'DISABLE_WP_CRON' 		=> defined('DISABLE_WP_CRON') && DISABLE_WP_CRON ? 'Yes' : 'No',
	        'WP_DEBUG' 				=> defined('WP_DEBUG') && WP_DEBUG ? 'Yes' : 'No',
	        'WP_DEBUG_DISPLAY' 		=> defined('WP_DEBUG_DISPLAY') && WP_DEBUG_DISPLAY ? 'Yes' : 'No',
	        'SCRIPT_DEBUG' 			=> defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? 'Yes' : 'No',
	        'WP_DEBUG_LOG' 			=> defined('WP_DEBUG_LOG') && WP_DEBUG_LOG ? 'Yes' : 'No',
	        'WP_PLUGIN_DIR' 		=> WP_PLUGIN_DIR,
	        'WP_MAX_MEMORY_LIMIT' 	=> WP_MAX_MEMORY_LIMIT,
	        'WP_MEMORY_LIMIT' 		=> WP_MEMORY_LIMIT,
	    );	
	}

}
