<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://wooninjas.com/
 * @since      1.0.0
 *
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/includes
 * @author     WooNinjas <info@wooninjas.com>
 */
class Tutorlms_Certificate_Verify_And_Share_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'tutorlms-certificate-verify-and-share',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
