<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://wooninjas.com/
 * @since      1.0.0
 *
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Tutorlms_Certificate_Verify_And_Share
 * @subpackage Tutorlms_Certificate_Verify_And_Share/includes
 * @author     WooNinjas <info@wooninjas.com>
 */
class Tutorlms_Certificate_Verify_And_Share {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Tutorlms_Certificate_Verify_And_Share_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_VERSION' ) ) {
			$this->version = TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'tutorlms-certificate-verify-and-share';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Tutorlms_Certificate_Verify_And_Share_Loader. Orchestrates the hooks of the plugin.
	 * - Tutorlms_Certificate_Verify_And_Share_i18n. Defines internationalization functionality.
	 * - Tutorlms_Certificate_Verify_And_Share_Admin. Defines all hooks for the admin area.
	 * - Tutorlms_Certificate_Verify_And_Share_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-tutorlms-certificate-verify-and-share-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-tutorlms-certificate-verify-and-share-i18n.php';

		/**
		 * The class responsible for defining logs functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-tutorlms-certificate-verify-and-share-wp-logger.php';

		/**
		 * The class responsible for defining croon functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-tutorlms-certificate-verify-and-share-cron.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-tutorlms-certificate-verify-and-share-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-tutorlms-certificate-verify-and-share-public.php';

		/**
		 * The class responsible for defining all actions that occur to verify license.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/license/class-tutorlms-certificate-verify-and-share-license.php';

		/**
		 * The class responsible for defining all actions that occur to verify and update plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/license/class-tutorlms-certificate-verify-and-share-plugin-updater.php';

		$this->loader = new Tutorlms_Certificate_Verify_And_Share_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Tutorlms_Certificate_Verify_And_Share_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Tutorlms_Certificate_Verify_And_Share_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin 	= new Tutorlms_Certificate_Verify_And_Share_Admin( $this->get_plugin_name(), $this->get_version() );
		$plugin_license = new Tutorlms_Certificate_Verify_And_Share_License( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

		// Plugin related menu, links and notifications
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'admin_menu' );
		$this->loader->add_action( 'plugin_action_links_' . plugin_basename(TUTORLMS_CERTIFICATE_VERIFY_AND_SHARE_FILE), $plugin_admin, 'plugin_action_links' );
		$this->loader->add_action( 'plugin_row_meta', 	$plugin_admin, 'plugin_row_meta', 10, 2 );
		$this->loader->add_action( 'admin_footer_text', $plugin_admin, 'admin_footer_text' );
		$this->loader->add_action( 'admin_notices', 	$plugin_admin, 'plugin_review_notice' );
		$this->loader->add_action( 'admin_init', $plugin_admin, 'save_settings' );

		// Plugin license initialize and notices
		$this->loader->add_action( 'admin_init', 	$plugin_license, 'plugin_updater' );
		$this->loader->add_action( 'admin_init', 	$plugin_license, 'register_license_option' );
		$this->loader->add_action( 'admin_init', 	$plugin_license, 'activate_license' );
		$this->loader->add_action( 'admin_init', 	$plugin_license, 'deactivate_license' );
		$this->loader->add_action( 'admin_notices', $plugin_license, 'admin_notices' );
		$this->loader->add_action( 'admin_notices', $plugin_license, 'license_activation_notices' );

		// Certificate upgrade or revoke action 
		$this->loader->add_action( 'admin_init', $plugin_admin, 'upgrade_or_revoke_certificate' );

		// Metabox
		$this->loader->add_action( 'add_meta_boxes', $plugin_admin, 'add_certificate_expiration_metabox' );
		$this->loader->add_action( 'save_post', $plugin_admin, 'tutor_certificate_expiration_save_metabox' );


		$this->loader->add_action( 'tutorlms_certificate_verify_and_share_weekly_scheduled_events', $plugin_license, 'weekly_license_check' );
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Tutorlms_Certificate_Verify_And_Share_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		$this->loader->add_action( 'tutor_certificate/before_content', $plugin_public, 'load_social_buttons_template' );
		$this->loader->add_action( 'wp_head', $plugin_public, 'add_og_header_content', -99 );
		$this->loader->add_action( 'init', $plugin_public, 'register_certificate_verification_shortcode' );

		// Verification ajax
		$this->loader->add_action( 'wp_ajax_nopriv_user_certificate_verification', $plugin_public, 'user_certificate_verification_callback' );
		$this->loader->add_action( 'wp_ajax_user_certificate_verification', $plugin_public, 'user_certificate_verification_callback' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Tutorlms_Certificate_Verify_And_Share_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
