<?php
class Whmcs_Http_Sync_Handler extends Wp_Whmcs_Sync_Public  {

    public $_http_socket;          // HTTP socket resource
    public $_full_url;             // Full URL including protocol, host, port, and URI
    public $_http_host;            // HTTP host
    public $_protocol;             // Protocol (HTTP/HTTPS)
    public $_request_uri;          // Request URI
    public $_port;                 // Port number
    public $_path;                 // Path part of the URL
    public $error = false;         // Indicates if an error occurred during the HTTP request
    public $errno = false;         // Error number associated with the HTTP request
    public $post = array();        // Post variables, defaults to $_POST
    public $redirect = false;      // Indicates whether a redirect is being followed
    public $force_with_redirect = array(); // URLs to force redirect to
    public $errors = array();      // Array to store errors
    public $count_redirects = 0;   // Count of redirects followed
    public $sid;                   // Session ID
    public $http_code;             // HTTP response code
    public $repost = false;        // Indicates whether it's a repost
    public $type;                  // Content type of the HTTP response
    public $follow = true;         // Whether to follow redirect links or not
    public $no_errors = false;     // Whether to trigger an error in case of a cURL error
    public $error_message;         // Error message associated with the HTTP request
    public $http_headers = array('Expect:', 'whmcssync: 1'); // Additional HTTP headers for the request
    public $debug_function;        // Debugging function to log messages
    public $time;                  // Execution time of the HTTP request
    public $cookie_array = array(); // Array to store cookies
    public $cookie_cach = '';      // Cache for cookies
    public $debug_prefix = '';     // Prefix for debug messages

    // constructor
    public function __construct($url = "", $sid = "", $repost = false) {
        if (!$url) return;
        $this->sid=$sid;
        $this->_full_url = $url;
        $this->_scan_url();
        $this->post=$_POST;
        $this->repost=$repost;
        $this->debug_prefix = "[connect ".uniqid()."] ";

        $meta_options = get_option( 'wp-whmcs-sync-admin-page', true );
		if(is_array($meta_options)) {
			$this->meta_data = $meta_options;
		}
    }

    private function time($action) {
        $t=function_exists('microtime') ? 'microtime' :'time';
        if ($action=='reset') $this->time=$t(true);
        elseif ($action=='delta') return round(($t(true)-$this->time)*100,0);
    }

    private function forceWithRedirectToString($url) {
        $s='';
        if (count($this->force_with_redirect)) {
            foreach ($this->force_with_redirect as $n => $v) {
                if (stristr($url,$n.'=')) continue;
                if ($s) $s.='&';
                $s.=$n.'='.$v;
            }
        }
        return $s;
    }

    private function debug($type=0,$msg='',$filename="",$linenum=0) {
        if ($f=$this->debug_function) $f($type,$this->debug_prefix.$msg,$filename,$linenum);
    }

    private function os() {
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') return 'WINDOWS';
        else return 'LINUX';
    }

    // scan url
    private function _scan_url() {
        $req = $this->_full_url;

        $pos = strpos($req, '://');
        $this->_protocol = strtolower(substr($req, 0, $pos));

        $req = substr($req, $pos+3);
        $pos = strpos($req, '/');
        if($pos === false)
            $pos = strlen($req);
        $host = substr($req, 0, $pos);

        if(strpos($host, ':') !== false)  {
            list($this->_http_host, $this->_port) = explode(':', $host);
        } else {
            $this->_http_host = $host;
            $this->_port = ($this->_protocol == 'https') ? 443 : 80;
        }

        $this->_request_uri = substr($req, $pos);
        if($this->_request_uri == '') {
            $this->_request_uri = '/';
        } else {
            $params=substr(strrchr($this->_request_uri,'/'),1);
            $this->_path=str_replace($params,'',$this->_request_uri);
        }
    }

    //check if server is live
    public function live() {
        //return true;
        if (ip2long($this->_http_host)) return true; //in case using an IP instead of a host name
        $url=$this->_http_host;
        if (gethostbyname($url) == $url)
            return false;
        else
            return true;
    }

    //get mime type of uploaded file
    public function mimeType($file) {
        $mime='';
        if (function_exists('finfo_open')) {
            if ($finfo = finfo_open(FILEINFO_MIME_TYPE)) {
                $mime=finfo_file($finfo, $file);
                finfo_close($finfo);
            }
        }
        if ($mime) return $mime;
        else return '';
    }

    //check if wp HTTP API is available
    public function curlInstalled() {
        if (!function_exists('wp_remote_request')) return false;
        else return true;
    }

    //check destination is reachable
    public function checkConnection() {
        $this->post['checkconnection']=1;
        $output=$this->connect($this->_protocol.'://'.$this->_http_host.$this->_request_uri);
        if ($output=='zingiri' || $output=='connected') return true;
        else return false;
    }

    //error logging
    public function error($msg) {
        $this->errorMsg=$msg;
        $this->error=true;
        //if (!$this->no_errors) trigger_error($msg,E_USER_WARNING);
        $this->debug(E_USER_WARNING,$msg);
    }

    //notification logging
    public function notify($msg) {
        $this->errorMsg=$msg;
        $this->error=true;
        if (!$this->no_errors) trigger_error($msg,E_USER_NOTICE);
        $this->debug(E_USER_NOTICE,$msg);
    }

    // download URL to string
    public function DownloadToString($withHeaders=true,$withCookies=false) {
        if ($this->_port == 80 || $this->_port == 443)
            $html = $this->connect($this->_protocol.'://'.$this->_http_host.$this->_request_uri,$withHeaders,$withCookies);
        else
            $html = $this->connect($this->_protocol.'://'.$this->_http_host.':'.$this->_port.$this->_request_uri,$withHeaders,$withCookies);

        return $html;
    }

    public function makeQueryString($params, $prefix = '', $removeFinalAmp = true) {
        $queryString = '';
        if (is_array($params)) {
            foreach ($params as $key => $value) {
                $correctKey = $prefix;
                if ('' === $prefix) {
                    $correctKey .= $key;
                } else {
                    $correctKey .= "[" . $key . "]";
                }
                if (!is_array($value) && !is_object($value)) {
                    $queryString .= urlencode($correctKey) . "="
                        . urlencode($value) . "&";
                } else {
                    $queryString .= $this->makeQueryString($value, $correctKey, false);
                }
            }
        }
        if ($removeFinalAmp === true) {
            return substr($queryString, 0, strlen($queryString) - 1);
        } else {
            return $queryString;
        }
    }

    private function generatePostArray() {
        $apost = [];
        if (count($this->post) > 0) {
            $post = "";
            $apost = array();
            $this->post = stripslashes_deep($this->post);
            foreach ($this->post as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if (is_array($v2)) {
                            foreach ($v2 as $k3 => $v3) {
                                if (is_array($v3)) {
                                    foreach ($v3 as $k4 => $v4) {
                                        $apost[$k . '[' . $k2 . ']' . '[' . $k3 . '][' . $k4 . ']'] = ($v4);
                                    }
                                } else {
                                    $apost[$k . '[' . $k2 . ']' . '[' . $k3 . ']'] = ($v3);
                                }
                            }
                        } else {
                            $apost[$k . '[' . $k2 . ']'] = ($v2);
                        }
                    }

                } else {
                    $apost[$k] = ($v);
                }
            }
        }
        return $apost;
    }

    /**
     * Method to login WP user within whmcs using SSO token
     */
    public function login_user_to_whmcs_using_sso_token()
    {
        // $_SESSION['whmcs_sso_session'] = false;
        if(!isset($_SESSION['whmcs_sso_session']) || $_SESSION['whmcs_sso_session'] == false){
            if(is_array($this->meta_data) && $this->meta_data['whmcs-sync-sso'] == true){
                //check if api credentials are added
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    $body = [
                        'action'       => 'GetClients',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'search'       => wp_get_current_user()->user_email,
                        // 'search'       => 'ahtisham.shokat@devbunch.com',
                        'responsetype' => 'json',
                    ];
            
                    //get client info from WHMCS
                    $client_info = $this->whmcs_api_calling($body);
                    if($client_info && isset($client_info['result'])){
                        if($client_info['result'] === 'success'){
                            if(is_array($client_info['clients'])){
                                $client_details = $client_info['clients']['client'] ? $client_info['clients']['client'][0] : '';
                                if(!empty($client_details)){
                                    if($client_details['status'] === 'Active'){
                                        //if found active then create sso token for the same user
                                        $whmcs_usr_details = [
                                            'whmcs_user_id'    => $client_details['id'],
                                            'whmcs_user_email' => $client_details['email']
                                        ];
                                        
                                        $_SESSION['whmcs_user_details'] = $whmcs_usr_details;
    
                                        $body = [
                                            'action'       => 'CreateSsoToken',
                                            'username'     => $this->meta_data['whmcs-api-identifier'],
                                            'password'     => $this->meta_data['whmcs-api-secret'],
                                            'client_id'    => $client_details['id'],
                                            'destination'  => 'clientarea:product_details',
                                            'responsetype' => 'json',
                                        ];
    
                                        $client_info = $this->whmcs_api_calling($body);
                                        if($client_info && isset($client_info['result'])){
                                            if($client_info['result'] === 'success'){
                                                if(isset($client_info['redirect_url'])){
                                                    return $client_info['redirect_url'];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function connect($url, $withHeaders=true, $withCookies=false) {
        $this->time('reset');
        global $wordpressPageName;

        $newfiles = array();

        $url = str_replace('?m=DNSManagerII', '?m=DNSManager2', $url);

        // 2co/SolusVM/Quantumvault callback requires get params
        if ((stristr($url, 'solusvm') !== false || stristr($url, 'quantumvault') !== false || stristr($url, 'twocheckout')) && count($_GET) > 0) {
            $ignore = array('ccce');
            $get_params = array();
            foreach ($_GET as $k => $v) {
                if (!in_array($k, $ignore)) {
                    $get_params[$k] = $v;
                }
            }
            if (count($get_params) > 0) {
                if (stristr($url, '?') !== false) {
                    $url .= '&' . http_build_query($get_params);
                } else {
                    $url .= '?' . http_build_query($get_params);
                }
            }
        }

        $substr = stristr($url, '?', true);
        if (stristr($url, '/store/') !== false && $substr !== false && substr($substr, -1) == "/")
            $url = str_replace($substr, substr($substr, 0, -1), $url);

        $this->debug(0, 'Not cached, processing file - '.$url);

        $http_args = array();

        $this->debug(0, 'HTTP Call: ' . $url . (is_array($this->post) ? ' with ' . json_encode($this->post) : ''));

        $this->http_headers['whmcssync'] = 1;

        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') {
            $this->http_headers['X-Requested-With'] = 'XMLHttpRequest';
        }

        $http_args['headers'] = $this->http_headers;
        $http_args['timeout'] = 60;

        if ($this->_protocol == "https") {
            $http_args['sslverify'] = false;
        }

        $cookies = [];

        if (isset($_SESSION[$this->sid]['cookieArr']) && count($_SESSION[$this->sid]['cookieArr']) > 0) {
            $cookies = $_SESSION[$this->sid]['cookieArr'];
        }

        if (!empty($cookies)) {
            //$this->debug(0, 'Cookie before:' . json_encode($cookies));
            $http_args['cookies'] = $cookies;
        }

        $_SESSION['cookieCach'] = $cookies;

        if (count($_FILES) > 0) {
            foreach ($_FILES as $name => $file) {
                if (is_array($file['tmp_name']) && count($file['tmp_name']) > 0) {
                    $c = count($file['tmp_name']);
                    for ($i = 0; $i < $c; $i++) {
                        if ($file['tmp_name'][$i]) {
                            $newfile = BLOGUPLOADDIR. $file['name'][$i];
                            copy($file['tmp_name'][$i], $newfile);
                            if (!file_exists($newfile)) {
                                $this->debug(0, 'Cant copy '.$file['tmp_name'][$i].' to '.$newfile);
                            } else {
                                $newfiles[] = [
                                    'file' => $newfile,
                                    'name' => $name.'['.$i.']'
                                ];
                            }
                        }
                    }
                } elseif ($file['tmp_name']) {
                    $newfile = BLOGUPLOADDIR. $file['name'];
                    copy($file['tmp_name'], $newfile);
                    if (!file_exists($newfile)) {
                        $this->debug(0, 'Cant copy '.$file['tmp_name'][$i].' to '.$newfile);
                    } else {
                        $newfiles[] = [
                            'file' => $newfile,
                            'name' => $name
                        ];
                    }
                }
            }
            $this->debug(0, 'There are files:  '.json_encode($newfiles));
        }

        $rawPost = file_get_contents('php://input');

        if (!empty($rawPost))
            $this->debug(0, "Raw data: ".$rawPost);

        $apost = $this->generatePostArray();

        if (!empty($newfiles)) {
            $http_args['method'] = 'POST';
            $boundary = substr(md5(time()), -24);
            $http_args['headers']['content-type'] = 'multipart/form-data; boundary='.$boundary;
            $http_args['body'] = '';

            if (!empty($apost)) {
                foreach ($apost as $k => $v) {
                    $http_args['body'] .= '--'.$boundary;
                    $http_args['body'] .= "\r\n";
                    $http_args['body'] .= 'content-disposition: form-data; name="' . $k .
                        '"' . "\r\n\r\n";
                    $http_args['body'] .= $v;
                    $http_args['body'] .= "\r\n";
                }
            }

            foreach ($newfiles as $file) {
                $http_args['body'] .= '--' . $boundary;
                $http_args['body'] .= "\r\n";
                $http_args['body'] .= 'content-disposition: form-data; name="' . $file['name'] .
                    '"; filename="' . basename( $file['file'] ) . '"' . "\r\n";
                $http_args['body'] .= 'content-type: '. $this->mimeType($file['file']) . "\r\n";
                $http_args['body'] .= "\r\n";
                $http_args['body'] .= file_get_contents( $file['file'] );
                $http_args['body'] .= "\r\n";
            }
            $http_args['body'] .= '--' . $boundary . '--';

            $this->debug(0, 'Posting with file attachment '.json_encode($newfiles));

        } else if (!empty($apost)) {
            $http_args['method'] = 'POST';

            if (stristr($url, 'clientarea.php?action=details') !== false && !isset($apost['save']) && isset($apost['firstname'], $apost['lastname'], $apost['companyname'], $apost['address1'])) {
                $apost['save'] = 'Save Changes';
                $this->debug(0, 'Safari patch for updating personal details');
            }

            $pfields = $this->makeQueryString($apost);
            $this->debug(0, 'Posting as:  ' . json_encode($pfields));

            $http_args['body'] = $pfields;
        } else if (!empty($rawPost)) {
            $http_args['method'] = 'POST';

            if (!in_array(substr($rawPost, 0, 1),  ['[', '{', '"'])) {
                parse_str($rawPost, $rawPost);
            }

            $http_args['body'] = $rawPost;

            $this->debug(0, "Posting RAW: ".$rawPost);
        } else if (strtolower($_SERVER['REQUEST_METHOD']) == "post" && strstr($url, 'viewinvoice.php') === false) {
            $http_args['method'] = 'POST';

            $this->debug(0, "HTTP Method POST 1");
        }

        // Fix legacy headers
        foreach ($http_args['headers'] as $k => $v) {
            if (is_numeric($k)) {
                unset($http_args['headers'][$k]);
                $v = explode(':', $v);
                if ($v > 1) {
                    $key = $v[0];
                    unset($v[0]);
                    $value = implode(':', $v);
                    $http_args['headers'][$key] = $value;
                }
            }
        }

        if (empty($http_args['method']))
            $http_args['method'] = 'GET';

        $this->debug(0, $http_args['method']." to {$url} with headers: ".json_encode($http_args['headers']));

        //generate sso token if enabled from the sync settings and make the user logged in
        if(is_user_logged_in() && !isset($_SESSION['whmcs_sso_session'])){
            $url = $this->login_user_to_whmcs_using_sso_token();
            $_SESSION['whmcs_sso_session'] = true;
            $_SESSION['whmcs_sso_redirect'] = $url;
        }

        //if sso request is generated then hit the sso redirect url first
        // if(isset($_SESSION['whmcs_sso_redirect'])){
        //     $url = $_SESSION['whmcs_sso_redirect'];
        // }

        if(isset($_REQUEST['token']) && isset($_REQUEST['username']) && isset($_REQUEST['password'])){
            if(!empty($this->meta_data['whmcs-url']) && !empty($this->meta_data['whmcs-template'])){
                $url = $this->meta_data['whmcs-url'].'index.php?rp=/login&systpl='.$this->meta_data['whmcs-template'].'';
            }
        }

        $http_args['redirection'] = 0;
        $data = wp_remote_request($url, $http_args);
        
        if (is_wp_error($data)) {
            $this->errno = $data->get_error_code();
            $this->error = $data->get_error_message($this->errno);
            $error_msg = 'An error has occurred: ' . $this->error;
            $this->error($this->errno . '/' . $error_msg.' ('.$url.')');
            $this->debug(0, 'HTTP Error:  '.$this->errno . '/' . $error_msg.' ('.$url.')');
            return '<body>'.$error_msg.'<br>Please try again later.</body>';
        }

        if (!empty($data)) {
            $headers = $data['headers']->getAll();

            $this->debug(0, 'Headers: '.json_encode($headers));

            $cookies = wp_remote_retrieve_cookies($data);
            if (!empty($cookies) && !is_wp_error($cookies)) {
                $_SESSION[$this->sid]['cookieArr'] = $cookies;
            } else {
                $cookies = $_SESSION['cookieCach'];
            }

            $body = $data['body'];
        } else {
            $headers = array();
            $cookies = [];
            $body = "";

            $this->error("An undefined error occurred");

            return '<body>An undefined error occurred</body>';
        }

        $foundSessId = false;
        foreach ($cookies as $ck) {
            if ($ck->name == 'PHPSESSID') {
                $foundSessId = true;
                $_SESSION[$this->sid]['sessid'] = $ck->value;
            }
        }

        if (!empty($cookies)) {
            //$this->debug(0, 'Cookie after:' . json_encode($cookies));

            if (!isset($_SESSION[$this->sid]))
                $_SESSION[$this->sid] = array();

            if (isset($_SESSION[$this->sid]['sessid'])) {
                if (!$foundSessId)
                    $cookies[] = new WP_Http_Cookie(['name' => 'PHPSESSID', 'value' => $_SESSION[$this->sid]['sessid']]);
            }

            $_SESSION[$this->sid]['cookies'] = $cookies;
        }

        //if (is_array($cookies))
            //$this->debug(0, 'Cookie after:' . json_encode($cookies));

        // remove temporary upload files
        if (count($newfiles) > 0) {
            foreach ($newfiles as $nF) {
                @unlink($nF);
            }
        }

        $this->headers = $headers;
        $this->data = isset($data['raw']) ? $data['raw'] : '';
        $this->cookies = $cookies;
        $this->body = $body;

        if ($headers['content-type']) {
            $this->type = $headers['content-type'];
        }

        $this->debug(0, 'Call process completed in ' . $this->time('delta') . ' microseconds');

        if ($this->follow && isset ($headers['location']) && $headers['location']) {
            $this->debug(0, 'XX: redirect to:'.json_encode($headers));
            $this->debug(0, 'XX: protocol='.$this->_protocol);
            $this->debug(0, 'XX: path='.$this->_path);

            $redir = $headers['location'];

            $main_whmcs_url = parse_url($this->wp_whmcs_sync_custom_url_handler());
            $this->debug(0, 'S0: '.json_encode($main_whmcs_url));

            if (strstr($this->_path, '/store/order') === false && strstr($this->_path, '/password/reset/change')) {
                if ($this->os() == 'WINDOWS') {
                    if (strpos($redir, $this->_protocol . '://' . $this->_http_host . $this->_path) === 0) {
                        //do nothing
                    } elseif (strstr($this->_protocol . '://' . $this->_http_host . $redir, $this->_protocol . '://' . $this->_http_host . $this->_path)) {
                        $new_redir = $this->_protocol . '://' . $this->_http_host . $this->_path;
                        if (strstr($new_redir, $redir) === false) {
                            $new_redir .= $redir;
                        }
                        $redir = $new_redir;
                    } elseif (!strstr($redir, $this->_http_host)) {
                        $redir = $this->_protocol . '://' . $this->_http_host . $this->_path . $redir;
                    }
                } else {
                    if (strpos($redir, $this->_protocol . '://' . $this->_http_host . $this->_path) === 0) {
                        //do nothing
                    } elseif (strstr($this->_protocol . '://' . $this->_http_host . $redir, $this->_protocol . '://' . $this->_http_host . $this->_path)) {
                        $redir = $this->_protocol . '://' . $this->_http_host . $redir;
                    } elseif (((strpos($redir, 'http://') === 0) || (strpos($redir, 'https://') === 0)) && !strstr($redir, $this->_http_host)) {
                        $this->redirect = true;
                        return $redir;
                    } elseif (!strstr($redir, $this->_http_host)) {
                        $redir = $this->_protocol . '://' . $this->_http_host . $this->_path . $redir;
                    }
                }
            } else {
                if (substr($redir, 0, 1) != '/' && stristr($redir, ':208') === false
                    && substr($redir, 0, 4) != 'http')
                    $redir = '/' . $redir;

                $redir_parts = parse_url($redir);
                if (!empty($redir_parts['path'])) {
                    $redir_parts = pathinfo($redir_parts['path']);
                    if (!empty($redir_parts['dirname']))
                        $redir_parts = $redir_parts['dirname'];
                    else
                        $redir_parts = $redir;
                } else
                    $redir_parts = $redir;

                $this->debug(0, "Redir: ".$redir);

                if ((stristr($this->_protocol . '://' . $this->_http_host . $this->_path, $redir) === false
                        || (
                            stristr($redir, $main_whmcs_url['host']) === false &&
                            stristr($redir, $main_whmcs_url['path']) === false
                        )) && strstr($redir, '://') !== false
                ) {
                    // do nothing
                    $bounce = true;
                    $this->debug(0, 'S2: ' . $redir);
                } else if (stristr($redir, ':208') === false
                    && (!empty($main_whmcs_url['path']) && $main_whmcs_url['path'] != $redir_parts)
                    && stristr($redir, 'password/reset') === false
                    && strstr($redir, 'account/') === false
                    && strstr($redir, 'user/') === false
                    && strstr($redir, 'login/challenge') === false
                    && strstr($redir, 'store/') === false
                    && strstr($redir, 'clientarea.php') === false
                    && strstr($redir, 'rp=/login') === false
                    && stristr($redir, '://') === false
                ) {
                    $redir = $this->_http_host . $this->_path . $redir;
                    $this->debug(0, 'S3: '.$redir);
                } else if (stristr($redir, ':208') !== false) {
                    $bounce = true;
                    $this->debug(0, 'S4: ' . $redir);
                } else if ($redir == '/clientarea.php') {
                    if (empty($rawPost))
                        $bounce = true;
                    if (stristr($this->_path, '/user/accounts') !== false)
                        $redir = $this->_protocol . '://' .$this->_http_host .'/'. $redir;
                    else
                        $redir = $this->_protocol . '://' .$this->_http_host .$this->_path. $redir;
                    $this->debug(0, 'S4.1: '.$redir);
                } else {
                    $redir = $this->_http_host . $redir;
                    $this->debug(0, 'S5: '.$redir);
                }

                if (empty($bounce) && substr($redir, -15) != '/clientarea.php') {
                    $redir = $this->_protocol . '://' . str_replace('//', '/', $redir);
                    $this->debug(0, 'S6: '.$redir);
                }
            }
            $fwd = $this->forceWithRedirectToString($redir);
            if ($fwd) {
                if (strstr($redir, '&')) $redir .= '&';
                elseif (strstr($redir, '?')) $redir .= '&';
                else $redir .= '?';
                $redir .= $fwd;
            }
            $this->debug(0, '[3] Redirect to: ' . $redir);

            if (strstr($redir, 'viewinvoice.php') ||
                (strstr($this->_path, '/store/order') && strstr($redir, 'cart.php')) ||
                (strstr($redir, 'action=details&success')) ||
                !empty($rawPost)
            ) {
                if (empty($bounce)) {
                    $opt = 0;
                    if (strstr($redir, 'action=details&success') || (!empty($rawPost) && !strstr($redir, 'clientarea.php'))) {
                        if(isset($this->meta_data['whmcs-friendly-url-support'])){
                            if($this->meta_data['whmcs-friendly-url-support'] != true){
                                $newRedir = $this->wp_whmcs_sync_parse_url($redir, true);
                                $opt = 1;
                            } else {
                                $page_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';
                                if(!empty($page_slug)){
                                    $newRedir = site_url( $page_slug ).strstr($redir, '/cart.php');
                                    $opt = 1;
                                }
                            }
                        } else {
                            $newRedir = $this->wp_whmcs_sync_parse_url($redir, true);
                            $opt = 1;
                        }
                    } else {
                        $newRedir = $this->wp_whmcs_sync_parse_url($redir);
                        $opt = 2;
                    }
                    if (strstr($this->_path, '/store/order') && strstr($redir, 'cart.php')) {
                        $newRedir = str_replace('/store/order', '', $newRedir);
                        $newRedir = $this->wp_whmcs_sync_parse_url($newRedir);
                        $opt = 3;
                    }

                    $substr = stristr($newRedir, '?', true);
                    if ($substr !== false && substr($substr, -1) != '/') {
                        $newRedir = str_replace($substr, $substr.'/', $newRedir);
                    }

                    $this->debug(0, '[XX - '.$opt.'] New Redirect: ' . $newRedir . ' (' . $redir . ')');
                } else {
                    $newRedir = $redir;
                    $redir = false;
                }

                if(isset($this->meta_data['whmcs-friendly-url-support'])){
                    if($this->meta_data['whmcs-friendly-url-support'] != true){
                        if ($redir != $newRedir || stristr($redir, '../viewinvoice')) {
                            $newRedir = urldecode($newRedir);
                            $this->debug(0, 'Header relocation '.$newRedir);
                            header('Location:' . $newRedir);
                            die();
                        }
                    } else {
                        $newRedir = urldecode($newRedir);
                        $this->debug(0, 'Header relocation '.$newRedir);
                        header('Location:' . $newRedir);
                        die();
                    }
                } else {
                    if ($redir != $newRedir || stristr($redir, '../viewinvoice')) {
                        $newRedir = urldecode($newRedir);
                        $this->debug(0, 'Header relocation '.$newRedir);
                        header('Location:' . $newRedir);
                        die();
                    }
                }

                
            } else if (substr_count($redir, "knowledgebase") > 1 && isset($headers, $headers['location'])) {
                $newRedir = $headers['location'];
                $newRedir = $this->wp_whmcs_sync_parse_url($newRedir);

                $this->debug(0, '[XX] New Redirect: ' . $newRedir . ' (' . $redir . ')');
                header('Location:' . $newRedir);
                die();
            } else if (strstr($redir, 'cart.php?a=add&domain=register') || strstr($redir, 'cart.php?a=confproduct&i=')
                || strstr($redir, 'cart.php?a=view')
                || strstr($redir, 'cart.php?a=complete')
            ) {
                if(isset($this->meta_data['whmcs-friendly-url-support'])){
					if($this->meta_data['whmcs-friendly-url-support'] != true){
                        $newRedir = $this->wp_whmcs_sync_parse_url($redir);
                        header('location: '.$newRedir);
                        die();
                    } else {
                        $page_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';
                        if(!empty($page_slug)){
                            $newRedir = site_url( $page_slug ).strstr($redir, '/cart.php?a=add&domain=register');
                            header('location: '.$newRedir);
                            die();
                        }
                    }
                } else {
                    $newRedir = $this->wp_whmcs_sync_parse_url($redir);
                    header('location: '.$newRedir);
                    die();
                }
            } else if (strstr($redir, 'cpsess') || strstr($redir, 'service-name') || stristr($redir, $main_whmcs_url['host']) === false) {
                header('location: '.$redir);
                die();
            } else if (strstr($redir, 'custom_page=reissue') ||
                strstr($redir, 'custom_page=manage_validation') || (strstr($url, 'login') !== false && !isset($this->post['bg']))
            ) {
                $newRedir =  $this->wp_whmcs_sync_parse_url($redir);
                if ($wordpressPageName) $p = $wordpressPageName;
                else $p = '/';

                $this->debug(0, 'Processing redirect...');

                if (strstr($url, 'login') !== false && class_exists('wpusers') && !empty($this->post['username'])) {
                    $this->debug(0, 'Logging in to WordPress with ' . $this->post['username'] . '/' . $this->post['password']);
                    $wpusers = new wpusers();
                    $wpusers->loginWpUser($this->post['username'], $this->post['password']);
                }

                $this->wp_whmcs_sync_main_screen($home, $pid, false);

                if (get_option('whmcs_permalinks') && function_exists('whmcs_parser_with_permalinks')) {
                    if (substr($home, -1) == '/')
                        $link = substr($home, 0, -1);
                    else
                        $link = $home;
                    $f[] = '/.*\/([a-zA-Z\_]*?).php.(.*?)/';
                    $r[] = $link . '/$1?$2';
                    $f[] = "/([a-zA-Z0-9\_]*?).php.(.*?)/";
                    $r[] = $link . '/$1?$2';
                } else {
                    $f[] = '/.*\/([a-zA-Z\_]*?).php.(.*?)/';
                    $r[] = $home . '?ccce=$1&$2';
                    $f[] = "/([a-zA-Z0-9\_]*?).php.(.*?)/";
                    $r[] = $home . '?ccce=$1&$2';
                }

                $this->debug(0, 'Location [1]: '.$newRedir);

                $newRedir = preg_replace($f, $r, $newRedir, -1, $count);

                $this->debug(0, 'Location [P]: '.$newRedir);

                header('Location:' . $newRedir);

                die();
            }
            if (!$this->repost) $this->post = array();
            $this->count_redirects++;
            if ($this->count_redirects < 10) {
                return $this->connect($redir, $withHeaders, $withCookies);
            } else {
                $error_msg = 'ERROR: Too many redirects ' . $url . ' > ' . $headers['location'];
                $this->error($error_msg, E_USER_ERROR);
                return '<body>'.$error_msg.'</body>';
            }
        }

        return $body;
    }

    function wp_whmcs_sync_parse_url($redir, $bypass = false) {
        $this->wp_whmcs_sync_main_screen($home,$pid,false);
        $whmcs = $this->wp_whmcs_sync_custom_url_handler();
        if (substr($whmcs,-1) != '/')
            $whmcs.='/';
        $whmcs_parts = parse_url($whmcs);

        $this->whmcs_sync_logger(0, "REDIR: ".$redir);
    
        if (stristr($redir, "http") !== false && strstr($redir, "://") !== false) {
            $redir = str_replace($whmcs, "", $redir);
        } else {
            $redir = str_replace($whmcs_parts['host'].$whmcs_parts['path'], "", $redir);
        }
    
        if (substr($redir, 0, 1) == "/") $redir = substr($redir, 1);
    
        $this->whmcs_sync_logger(0, "REDIR 2: ".$redir);
        $this->whmcs_sync_logger(0, "BYPASS: ".json_encode($bypass));
        $this->whmcs_sync_logger(0, "WHMCS: ".$whmcs);
    
        $folder = parse_url($whmcs, PHP_URL_PATH);

        $this->whmcs_sync_logger(0, "FOLDER: ".$folder);
    
        if ($bypass ||
            (strstr($redir, 'knowledgebase.php') !== false ||
                strstr($redir, 'cart.php?') !== false ||
                strstr($redir, 'clientarea.php') !== false) ||
                strstr($redir, 'clientarea.php?action=details&success') !== false) {
    
    
            if (strstr($redir, 'knowledgebase.php') === false || $bypass)
                $redir = str_replace($whmcs, '', $redir);
    
            if ($folder != '/')
                $redir = str_replace($folder, '', $redir);
    
            if (!get_option('whmcs_permalinks'))
                $return = $home.'?ccce='.str_replace(['.php?', '.php'], ['&', ''], $redir);
            else
                $return = $home.str_replace('.php', '', $redir);
    
            $substr = stristr($return, '?', true);
            if ($substr !== false && substr($substr, -1) != '/') {
                $return = str_replace($substr, $substr.'/', $return);
            }
    
            $this->whmcs_sync_logger(0, "RETURN: ".$return);
    
            return $return;
        }
    
        $f[] = '/'.preg_quote($whmcs,'/').'viewinvoice\.php\?id\=([0-9]*?)&(.*?)$/';
    
        if (get_option('whmcs_permalinks'))
            $r[]=''.$home.'viewinvoice/?id=$1'.$pid.'';
        else
            $r[]=''.$home.'?ccce=viewinvoice&id=$1'.$pid.'';
    
        $f[] = '/viewinvoice\.php\?id\=([0-9]*?)&(.*?)$/';
    
        if (get_option('whmcs_permalinks'))
            $r[]=''.$home.'viewinvoice/?id=$1'.$pid.'';
        else
            $r[]=''.$home.'?ccce=viewinvoice&id=$1'.$pid.'';
    
    
        $f[] = '/'.preg_quote($whmcs,'/').'clientarea\.php\?action\=([0-9]*?)&(.*?)$/';
    
    
        $f[] = '/'.preg_quote($whmcs,'/').'cart\.php\?(.*?)$/';
    
        if (get_option('whmcs_permalinks'))
            $r[] = ''.$home.'cart/?$1'.$pid.'';
        else
            $r[] = ''.$home.'?ccce=cart&$1'.$pid.'';
    
        if (stristr($redir, 'modules/gateways/../../viewinvoice.php?') !== false) {
            $f[] = '/'.preg_quote($whmcs,'/').'modules\/gateways\/..\/..\/viewinvoice\.php\?id\=([0-9]*?)&(.*?)$/';
            if (get_option('whmcs_permalinks'))
                $r[] = ''.$home.'viewinvoice/?id=$1'.$pid.'';
            else
                $r[] = ''.$home.'?ccce=viewinvoice&id=$1'.$pid.'';
        }
    
        $newRedir = preg_replace($f,$r,$redir);
        
        return $newRedir;
    }

}