<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://designingmedia.com
 * @since      1.0.0
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/public
 * @author     Designingmedia
 */


trait Whmcs_Sync_Parser {

	/**
	 * Method to parse content on the WHMCS-Sync page.
	 *
	 * This method is responsible for parsing the content for the WHMCS-Sync page.
	 *
	 */
	private function parse_whmcs_sync_content( $result_data = null, $current = false ) {
	// private function parse_whmcs_sync_content( $buffer=null, $current=false ) {

		global $wp;
		$filtered_data = [];
		$raw_data = [];
		$reference_number = rand(100, 999);

		$this->wp_whmcs_sync_main_screen( $home, $pid, $current);

		// If $result_data is not available, generate output using whmcs_sync_response_renderer
		if (!$result_data) {
			$result_data = $this->whmcs_sync_response_renderer();
		}

		// Extract parts from the custom WHMCS URL
		$url_parts = explode('://', $this->wp_whmcs_sync_custom_url_handler(), 2);
		$domain_parts = explode('/', $url_parts[1], 2);
		$subpath = str_replace($url_parts[0] . '://' . $domain_parts[0], '', $this->wp_whmcs_sync_custom_url_handler()) . '/';
		$secure_parameter = '&sec=1';

		// Obtain the custom WHMCS URL
		$custom_whmcs_url = $this->wp_whmcs_sync_custom_url_handler();

		// Ensure the custom WHMCS URL ends with '/'
		if (substr($custom_whmcs_url, -1) != '/') {
			$custom_whmcs_url .= '/';
		}

		// If the custom WHMCS URL starts with 'https://', replace it with 'http://'
		if (strpos($custom_whmcs_url, 'https://') === 0) {
			$custom_whmcs_url = str_replace('https://', 'http://', $custom_whmcs_url);
		}

		// Create an 'https://' version of the WHMCS URL
		$https_whmcs_url = str_replace('http://', 'https://', $custom_whmcs_url);

		// Remove 'http:' from the WHMCS URL
		$cleaned_whmcs_url = str_replace('http:', '', $custom_whmcs_url);

		// Create a parser instance
		$parser = new Wp_Whmcs_Sync_Simple_Html_Dom();
		// Load the result data into the parser
		$parser->load($result_data);
		// Extract page title from HTML
		$html_title = $parser->find('title', 0);

		// Check if the title is an object and has plaintext
		if (is_object($html_title) && isset($html_title->plaintext)) {
			// Store page title in the page_data array
			$page_data['page_title'] = $html_title->plaintext;

			// Extract language information from the parser
			$language_element = $parser->find('a[id=languageChooser]', 0);

			// Check if language element is an object
			if (is_object($language_element)) {
				// Store selected language
				$selected_language = $language_element->plaintext;
			} else {
				$selected_language = null;
			}

			// Store the selected language in the session
			$_SESSION['syncCurLang'] = sanitize_text_field($selected_language);

			// Store title cache information
			$combined_data = $selected_language . '|' . $wp->query_string;

			if (isset($_REQUEST['id'])) {
				$combined_data .= sanitize_text_field($_REQUEST['id']);
			}
			if (isset($_REQUEST['catid'])) {
				$combined_data .= 'c' . sanitize_text_field($_REQUEST['catid']);
			}
			if (isset($_REQUEST['rp'])) {
				$combined_data .= 'rp' . sanitize_text_field($_REQUEST['rp']);
			}
		}

		$whmcs_path = parse_url($this->wp_whmcs_sync_custom_url_handler(), PHP_URL_PATH);
		if (substr($whmcs_path, -1) != '/'){
			$whmcs_path .= '/';
		}

		// Initialize an array to store various URL variations
		$url_variations = array();
		$url_variations[ $this->wp_whmcs_sync_custom_url_handler().'/' ] = $this->wp_whmcs_sync_custom_url_handler().'/';
		$url_variations[ $custom_whmcs_url ] = $custom_whmcs_url;

		// Include additional URL variations based on conditions
		if (!is_null($https_whmcs_url)){
			$url_variations[$https_whmcs_url] = $https_whmcs_url;
		}
		if (!is_null($cleaned_whmcs_url)){
			$url_variations[$cleaned_whmcs_url] = $cleaned_whmcs_url;
		}
		if ($whmcs_path != ''){
			$url_variations[$whmcs_path] = $whmcs_path;
		}
		if ($subpath != ''){
			$url_variations[$subpath] = $subpath;
		}

		// Include an empty string to handle specific cases
		$url_variations[''] = '';

		// Fix double slash issue with some modules
		foreach ($url_variations as $current_url) {
			// Skip empty or single slash variations
			if (trim($current_url) == '' || trim($current_url) == '/') continue;

			// Prepare the replacement URL with a trailing slash
			$replacement_url_slash = $current_url.'/';

			// Replace double slashes with a single slash in the result data
			$result_data = str_replace($replacement_url_slash, $current_url, $result_data);
		}
		
		$page_data['buffer'] = $result_data;
		$parse = true;
		if ($parse) {
			foreach ($url_variations as $rep_url) {
				// Replace href attributes
				$result_data = str_replace('href="'.$rep_url.'"', 'href="'.$home.'"', $result_data);
				// Handle URLs with trailing slash
				if (substr($rep_url, -1) == '/'){
					$result_data = str_replace('href="'.substr($rep_url, 0, -1).'"', 'href="'.$home.'"', $result_data);
				}
	
				// Modify src and href attributes for modules
				$result_data = str_replace('src="'.$rep_url.'modules/', 'src="'.$home.'?ccce=js&ajax=1&js=modules/', $result_data);
				$result_data = str_replace('href="'.$rep_url.'modules/', 'href="'.$home.'?ccce=js&ajax=1&js=modules/', $result_data);
				// Modify URL attributes for payment methods
				$result_data = str_replace('url: "'.$rep_url.'paymentmethods/', 'url: "'.$home.'?ccce=js&ajax=1&js=paymentmethods/', $result_data);
				$result_data = str_replace('url: "'.$rep_url.'account/paymentmethods', 'url: "'.$home.'?ccce=js&ajax=1&js=account/paymentmethods', $result_data);
	
				// Process various data patterns
				$filtered_data[] = "/.post\(\'".preg_quote($rep_url,'/')."([a-zA-Z0-9-_]*?).php.(.*?)/";
				$raw_data[] = ".post('$home"."?ccce=$1&ajax=1&$2'";
				$filtered_data[] = "/.post\(\'".preg_quote($rep_url,'/')."([a-zA-Z0-9-_]*?).php/";
				$raw_data[] = ".post('$home"."?ccce=$1&ajax=1";
				$filtered_data[] = '/selfLink \= "'.preg_quote($rep_url, '/').'([a-zA-Z0-9-_]*?).php\"/';
				$raw_data[] = 'selfLink = "'.$home.'?ccce=$1'.$pid.'"';
	
				// Replace src attributes for templates and assets
				$result_data = str_replace('src="'.$rep_url.'assets/img/', 'src="'.$home.'?ccce=js&ajax=1&js=assets/img/', $result_data);
				$result_data = str_replace('src="'.$rep_url.'assets/js/', 'src="'.$home.'?ccce=js&ajax=1&js=assets/js/', $result_data);
				$result_data = str_replace('href="'.$rep_url.'assets/css/', 'href="'.$home.'?ccce=js&ajax=1&js=assets/css/', $result_data);

				//hostiko styles and scripts
				$result_data = str_replace('src="'.$rep_url.'templates/'.$this->meta_data['whmcs-template'].'/layouts/', 'src="'.$home.'?ccce=js&ajax=1&js=templates/'.$this->meta_data['whmcs-template'].'/layouts/', $result_data);
				$result_data = str_replace('href="'.$rep_url.'templates/'.$this->meta_data['whmcs-template'].'/layouts/', 'href="'.$home.'?ccce=js&ajax=1&js=templates/'.$this->meta_data['whmcs-template'].'/layouts/', $result_data);
	
				// Process templates, assets, and gateways
				$filtered_data[] = "/src=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/store\/js\/([a-zA-Z0-9\.\_\-]*?).js/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/store/js/$2.js' . $pid;
				$filtered_data[] = "/src=\"".preg_quote($rep_url,'/')."templates\/([a-zA-Z0-9-_]*?)\/store\/js\/([a-zA-Z0-9\_\.\-]*?).js.(.*?)/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=".'templates/$1/store/js/$2.js&'.$pid;
				$filtered_data[] = "/href=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/store\/css\/([a-zA-Z0-9\.\_\-]*?).css/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/store/css/$2.css' . $pid;
				$filtered_data[] = "/href=\"".preg_quote($rep_url,'/')."templates\/([a-zA-Z0-9-_]*?)\/store\/css\/([a-zA-Z0-9\_\.\-]*?).css.(.*?)/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=".'templates/$1/store/css/$2.css?'.$pid;
				$filtered_data[] = "/src=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9\.\_\-]*?).js/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/js/$2.js' . $pid;
				$filtered_data[] = "/src=\"".preg_quote($rep_url,'/')."templates\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9\_\.\-]*?).js.(.*?)/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=".'templates/$1/js/$2.js&'.$pid;
				$filtered_data[] = "/href=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9\.\_\-]*?).css/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/css/$2.css' . $pid;
				$filtered_data[] = "/href=\"".preg_quote($rep_url,'/')."templates\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9\_\.\-]*?).css.(.*?)/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=".'templates/$1/css/$2.css?'.$pid;
	
				$filtered_data[] = '/value\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
				$raw_data[] = 'value="' . $home . '?ccce=$1' . $pid . '"';
	
				$filtered_data[] = '/value\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
				$raw_data[] = 'value="' . $home . '?ccce=$1&$2' . $pid . '"';
	
				$filtered_data[] = '/value\=\"' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php\"/';
				$raw_data[] = 'value="' . $home . '?ajax=1&ccce=modules/gateways/$1/$2"';
	
				$filtered_data[] = '/value\=\"' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php.(.*?)\"/';
				$raw_data[] = 'value="' . $home . '?ajax=1&ccce=modules/gateways/$1/$2&$3"';
	
				//if friendly url support is not enabled then update urls
				if(isset($this->meta_data['whmcs-friendly-url-support'])){
					if($this->meta_data['whmcs-friendly-url-support'] != true){

						$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
						$raw_data[] = 'action="' . $home . '?ccce=$1' . $pid . '"';
			
						$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
						$raw_data[] = 'action="' . $home . '?ccce=$1&$2' . $pid . '"';

						$filtered_data[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
						$raw_data[] = 'href="' . $home . '?ccce=$1' . $pid . '"';
			
						$filtered_data[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\?((?:(?!phpinfo|").)*)\"/';
						$raw_data[] = 'href="' . $home . '?ccce=$1&$2' . $pid . '"';
			
						$filtered_data[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
						$raw_data[] = 'href="' . $home . '?ccce=$1' . $pid . '"';
					} else {
						$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
						$raw_data[] = 'action="' . $home . '$1' . $pid . '.php"';
			
						$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
						$raw_data[] = 'action="' . $home . '$1/$2' . $pid . '.php"';
					}
				} else {
					$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
					$raw_data[] = 'action="' . $home . '$1' . $pid . '.php"';
		
					$filtered_data[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
					$raw_data[] = 'action="' . $home . '$1/$2' . $pid . '.php"';
				}

				$filtered_data[] = "/action=\"".preg_quote($rep_url,'/')."modules\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php/";
				$raw_data[] = "action=\"{$home}js/?ajax=1&js=".'modules/$1/$2.php'.$pid;
	
				$filtered_data[] = '/\'' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php\'/';
				$raw_data[] = '\'' . $home . '?ajax=1&ccce=modules/gateways/$1/$2\'';
	
				$filtered_data[] = '/action=\"' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php\"/';
				$raw_data[] = 'action="' . $home . '?ajax=1&ccce=modules/gateways/$1/$2"';
	
				$filtered_data[] = '/action\=\"'.preg_quote($rep_url,'/').'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php/';
				$raw_data[] =  'action="'.$home.'?ajax=1&ccce=modules/gateways/$1/$2';
	
				$filtered_data[] = '/value\=\"'.preg_quote($rep_url,'/').'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php/';
				$raw_data[] =  'value="'.$home.'?ajax=1&ccce=modules/gateways/$1/$2';
	
				$filtered_data[] = "/src=\"".preg_quote($rep_url,'/')."templates\/orderforms\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9\_\.]*?).js/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=".'templates/orderforms/$1/js/$2.js'.$pid;
	
				$filtered_data[] = "/src=\"".preg_quote($rep_url,'/')."templates\/orderforms\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9\_\.]*?).js/";
				$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=".'templates/orderforms/$1/$2.js'.$pid;
	
				$filtered_data[] = "/href=\"".preg_quote($rep_url,'/')."templates\/orderforms\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9\_\.]*?).css/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=".'templates/orderforms/$1/$2.css'.$pid;
	
				$filtered_data[] = "/href=\"".preg_quote($rep_url,'/')."templates\/orderforms\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9\_\.]*?).css/";
				$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=".'templates/orderforms/$1/css/$2.css'.$pid;
	
				$result_data = str_replace('src="'.$rep_url.'templates/orderforms', 'src="'.$home.'?ccce=js&ajax=1&js=templates/orderforms', $result_data);
			}
	
			// Replace content based on filtered data and raw data
			$result_data = preg_replace($filtered_data, $raw_data, $result_data, -1, $count);

			// Iterate over URL variations to replace specific patterns
			foreach ($url_variations as $rep_url) {
				// Check if URL has a trailing slash
				if (substr($rep_url, -1) == '/') {
					// Replace specific patterns for URLs with a trailing slash
					$result_data = str_replace('jqClient.post(\'' . $rep_url, 'jqClient.post(\'' . $home, $result_data);
					$result_data = str_replace('$.post(\'' . $rep_url, '$.post(\'' . $home, $result_data);
					$result_data = str_replace('href="' . $rep_url, 'href="' . $home, $result_data);
					$result_data = str_replace('action="' . $rep_url, 'action="' . $home, $result_data);
				} else {
					// Replace specific patterns for URLs without a trailing slash
					$result_data = str_replace('jqClient.post(\'' . $rep_url .'/', 'jqClient.post(\'' . $home, $result_data);
					$result_data = str_replace('$.post(\'' . $rep_url .'/', '$.post(\'' . $home, $result_data);
					$result_data = str_replace('href="' . $rep_url . '/', 'href="' . $home, $result_data);
					$result_data = str_replace('action="' . $rep_url . '/', 'action="' . $home, $result_data);
				}
			}

			$result_data = str_replace('src="templates/orderforms', 'src="'.$home.'?ccce=js&ajax=1&js=templates/orderforms', $result_data);
			# custom paths
			$custom_paths = explode("\n", str_replace("\r\n", "\n", get_option('whmcs_sync_custom_rules')));
			if (!is_array($custom_paths))
				$custom_paths = array();
	
			if (is_array($custom_paths)) {
				foreach ($custom_paths as $pth) {
					if (trim($pth) == '') continue;
	
					if (substr($pth, 0, 1) == '*') {
						$pth = substr($pth, 1);
						$filtered_data[] = "\${$pth}([a-zA-Z0-9\_\.]*?).js\$";
						$raw_data[] = $home . "?ccce=js&ajax=1&js=" . $pth . '$1.js' . $pid;
	
						$filtered_data[] = "\${$pth}([a-zA-Z0-9\_\.]*?).css\$";
						$raw_data[] = $home . "?ccce=js&ajax=1&js=" . $pth . '$1.css' . $pid;
					} else {
						$filtered_data[] = "\${$pth}([a-zA-Z0-9\_\.]*?).js\$";
						$raw_data[] = $home . "?ccce=js&ajax=2&js=" . $pth . '$1.js' . $pid;
	
						$filtered_data[] = "\${$pth}([a-zA-Z0-9\_\.]*?).css\$";
						$raw_data[] = $home . "?ccce=js&ajax=2&js=" . $pth . '$1.css' . $pid;
					}
				}
			}

			// 2factor images replacement
			$filtered_data[] = '/img src\=\"\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php.(.*?)\"/';
			$raw_data[] = "img src=\"$home" . "?ccce=$2&$3&ajax=2\"";

			// wbteampro images replacement
			$filtered_data[] = '/img src\=\"([a-zA-Z0-9-_]*?).php.(.*?)\"/';
			$raw_data[] = "img src=\"$home" . "?ccce=$1&$2&ajax=2\"";

			// SUB FOLDERS hyperlink replacement
			$filtered_data[] = '/href\=\"' . preg_quote($subpath, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
			$raw_data[] = 'href="' . $home . '?ccce=$1&$2' . $pid . '"';

			// hyperlinks with parameters replacement
			$filtered_data[] = '/href\=\"([a-zA-Z0-9-_]*?).php\?(.*?)\"/';
			$raw_data[] = 'href="' . $home . '?ccce=$1&$2' . $pid . '"';

			// hyperlinks without parameters replacement
			$filtered_data[] = '/href\=\"([a-zA-Z0-9-_]*?).php\"/';
			$raw_data[] = 'href="' . $home . '?ccce=$1' . $pid . '"';

			// images replacement
			$filtered_data[] = '/img src\=\"([a-zA-Z0-9-_]*?).php.(.*?)\"/';
			$raw_data[] = "img src=\"$home" . "$1/?$2&ajax=2\"";

			// form posts replacement
			$filtered_data[] = '/<form(.*?)method\=\"get\"(.*?)action\=\"([a-zA-Z0-9-_]*?).php\"(.*?)>/';
			if (!$pid) {
				$raw_data[] = '<form$1method="get"$2action="' . $home . '"$4><input type="hidden" name="ccce" value="$3" />';
			} else {
				$raw_data[] = '<form$1method="get"$2action="' . $home . '"$4><input type="hidden" name="ccce" value="$3" /><input type="hidden" name="page_id" value="' . $this->wp_whmcs_sync_main_page() . '"/>';
			}
	
			// Form action with parameters replacement
			$filtered_data[] = '/action\=\"([a-zA-Z0-9-_]*?).php\?(.*?)\"/';
			$raw_data[] = 'action="' . $home . '?ccce=$1&$2' . $pid . '"';

			// Form action without parameters replacement
			$filtered_data[] = '/action\=\"([a-zA-Z0-9-_]*?).php\"/';
			$raw_data[] = 'action="' . $home . '?ccce=$1' . $pid . '"';

			// Form within subpath, action with parameters replacement
			$filtered_data[] = '/<form(.*?)method\=\"get\"(.*?)action\=\"' . preg_quote($subpath, '/') . '([a-zA-Z0-9-_]*?).php\"(.*?)>/';
			if (!$pid) {
				$raw_data[] = '<form$1method="get"$2action="' . $home . '"$4><input type="hidden" name="ccce" value="$3" />';
			} else {
				$raw_data[] = '<form$1method="get"$2action="' . $home . '"$4><input type="hidden" name="ccce" value="$3" /><input type="hidden" name="page_id" value="' . $this->wp_whmcs_sync_main_page() . '"/>';
			} 

			// Form action within subpath without parameters replacement
			$filtered_data[] = '/action\=\"' . preg_quote($subpath, '/') . '([a-zA-Z0-9-_]*?).php\"/';
			$raw_data[] = 'action="' . $home . '?ccce=$1' . $pid . '"';

			// Form action within subpath with parameters replacement
			$filtered_data[] = '/action\=\"' . preg_quote($subpath, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
			$raw_data[] = 'action="' . $home . '?ccce=$1&$2' . $pid . '"';

			// Fix for submitticket.php
			$filtered_data[] = '/"submitticket.php/';
			$raw_data[] = '"' . $home . '?ccce=submitticket&ajax=1' . $pid;

			// Fix for register.php
			$filtered_data[] = '/action\=\"(.|\/*?)register.php\"/';
			$raw_data[] = 'action="' . $home . '?ccce=register' . $pid . '"';

			// Remove cart heading
			$filtered_data[] = '#\<p align\=\"center\" class=\"cartheading\">(?:.*?)\<\/p\>#';
			$raw_data[] = '';

			// Font Awesome class replacement (fal to fas)
			$filtered_data[] = '/<i class="([^"]*\bfal\b[^"]*)"><\/i>/';
			$raw_data[] = '<i class="$1 fas"></i>';

			// Font Awesome class replacement (far to fas)
			$filtered_data[] = '/<i class="([^"]*\bfar\b[^"]*)"><\/i>/';
			$raw_data[] = '<i class="$1 fas"></i>';
			
			// Remove base tag
			$filtered_data[] = "(\<base\s*href\=(?:\"|\')(?:.*?)(?:\"|\')\s*/\>)";
			$raw_data[] = '';

			// Remove title tag
			$filtered_data[] = "/<title>.*<\/title>/";
			$raw_data[] = '';

			// Remove meta tag
			$filtered_data[] = "/<meta.*>/";
			$raw_data[] = '';

			// Fix for js single quotes
			$filtered_data[] = '/window.location\=\'' . '([a-zA-Z0-9-_]*?).php\'/';
			$raw_data[] = 'window.location=\'' . $home . '?ccce=$1' . $pid . '\'';

			// Fix for window.location with subpath
			$filtered_data[] = '/window.location\=\'' . preg_quote($subpath, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\'/';
			$raw_data[] = 'window.location=\'' . $home . '?ccce=$1&$2' . $pid . '\'';

			// Fix for window.location without subpath
			$filtered_data[] = '/window.location\=\'' . '([a-zA-Z0-9-_]*?).php.(.*?)\'/';
			$raw_data[] = 'window.location=\'' . $home . '?ccce=$1&$2' . $pid . '\'';

			// Fix for window.location with space before equal sign
			$filtered_data[] = '/window.location \= \'' . '([a-zA-Z0-9-_]*?).php.(.*?)\'/';
			$raw_data[] = 'window.location = \'' . $home . '?ccce=$1' . $pid . '&$2\'';

			// Fix for .post method
			$filtered_data[] = "/.post\(\'([a-zA-Z0-9-_]*?).php/";
			$raw_data[] = ".post('$home?ccce=$1&ajax=1$pid";

			// Fix for popupWindow method
			$filtered_data[] = "/popupWindow\(\'([a-zA-Z0-9-_]*?).php\?/";
			$raw_data[] = "popupWindow('$home?ccce=$1&ajax=1$pid&";

			// Fix for window.open method
			$filtered_data[] = '/window.open\(\'([a-zA-Z0-9-_]*?).php.(.*?)\'/';
			$raw_data[] = 'window.open(\'' . $home . '?ajax=1&ccce=$1&$2' . $pid . '\'';

			// Fix for location.href with single quotes
			$filtered_data[] = '/location.href\=\'' . '([a-zA-Z0-9-_]*?).php\'/';
			$raw_data[] = 'location.href=\'' . $home . '?ccce=$1' . $pid . '\'';

			// Fix for location.href with single quotes and parameters
			$filtered_data[] = '/location.href\=\'' . '([a-zA-Z0-9-_]*?).php.(.*?)\'/';
			$raw_data[] = 'location.href=\'' . $home . '?ccce=$1&$2' . $pid . '\'';

			// Fix for .post method with double quotes
			$filtered_data[] = "/.post\(\"announcements.php/";
			$raw_data[] = ".post(\"$home?ccce=announcements&ajax=1$pid";

			// Fix for .post method with double quotes for submitticket.php
			$filtered_data[] = "/.post\(\"submitticket.php/";
			$raw_data[] = ".post(\"$home?ccce=submitticket&ajax=1$pid";

			// Fix for .load method with submitticket.php
			$filtered_data[] = '/.load\(\"submitticket.php/';
			$raw_data[] = '.load("' . $home . '?ccce=submitticket&ajax=1' . $pid;

			// Fix for .post method with parameters
			$filtered_data[] = "/.post\(\"([a-zA-Z0-9-_]*?).php/";
			$raw_data[] = ".post(\"$home?ccce=$1&ajax=1$pid";

			// Fix for six modules src and href
			$filtered_data[] = "/src=\"" . preg_quote($whmcs_path, '/') . "modules\//";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'modules/$1' . $pid;

			$filtered_data[] = "/href=\"" . preg_quote($whmcs_path, '/') . "modules\//";
			$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'modules/$1' . $pid;

			$filtered_data[] = "/src=\"modules\//";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'modules/$1' . $pid;

			$filtered_data[] = "/href=\"modules\//";
			$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'modules/$1' . $pid;

			// Fix for templates' CSS and JS files
			$filtered_data[] = "/src=\"" . preg_quote($whmcs_path, '/') . "templates\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9\_\.]*?).js/";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/js/$2.js' . $pid;

			$filtered_data[] = "/href=\"" . preg_quote($whmcs_path, '/') . "templates\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9\_\.]*?).css/";
			$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/css/$2.css' . $pid;

			// Fix for orderforms templates
			$filtered_data[] = "/src=\"templates\/orderforms\/([a-zA-Z0-9_]*?)\/js\/([a-zA-Z0-9-_]*?).js/";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/orderforms/$1/js/$2.js' . $pid;

			$filtered_data[] = "/src=\"templates\/orderforms\/([a-zA-Z0-9_]*?)\/([a-zA-Z0-9-_]*?).js/";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/orderforms/$1/$2.js' . $pid;

			$filtered_data[] = "/href=\"templates\/orderforms\/([a-zA-Z0-9_]*?)\/([a-zA-Z0-9-_]*?).css/";
			$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'templates/orderforms/$1/$2.css' . $pid;

			// Fix for general templates' CSS and JS files
			$filtered_data[] = "/src=\"templates\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9-_]*?).js/";
			$raw_data[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/js/$2.js' . $pid;

			$filtered_data[] = "/href=\"templates\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9-_]*?).css/";
			$raw_data[] = "href=\"{$home}?ccce=js&ajax=1&js=" . 'templates/$1/css/$2.css' . $pid;

			// BootWHMCS template
			$filtered_data[] = "/templates\/orderforms\/([a-zA-Z0-9-_]*?)\/static\/app.js/";
			$raw_data[] = $home . "?ccce=js&ajax=2&js=" . 'templates/orderforms/$1/static/app.js' . $pid;

			// Character fixes
			$filtered_data[] = "/>>/";
			$raw_data[] = "&gt;&gt;";

			// 'page' is a WordPress reserved variable
			$filtered_data[] = '/href\=\"(.*?)&amp;page\=([0-9]?)"/';
			$raw_data[] = 'href="$1' . '&whmcspage=$2"';

			// Fix for six JS links
			$filtered_data[] = "/'([a-zA-Z0-9-_]*?).php'/";
			$raw_data[] = "'" . $home . "?ccce=$1" . $pid . "'";

			$filtered_data[] = "/\"([a-zA-Z0-9-_]*?).php\"/";
			$raw_data[] = "\"" . $home . "?ccce=$1" . $pid . "\"";

			$filtered_data[] = "/'([a-zA-Z0-9-_]*?).php.(.*?)'/";
			$raw_data[] = "'" . $home . "?ccce=$1&$2" . $pid . "'";

			$filtered_data[] = "/\"([a-zA-Z0-9-_]*?).php.(.*?)\"/";
			$raw_data[] = "\"" . $home . "?ccce=$1&$2" . $pid . "\"";

			//if friendly url support is disabled
			if(isset($this->meta_data['whmcs-friendly-url-support'])){
				if($this->meta_data['whmcs-friendly-url-support'] != true){
					// Run regex
					$result_data = preg_replace($filtered_data, $raw_data, $result_data, -1, $count);

					// Fix for tickets
					$result_data = str_replace("window.location='?tid=", "window.location='{$home}?ccce=viewticket&tid=", $result_data);
				}
			} else {
				// Run regex
				$result_data = preg_replace($filtered_data, $raw_data, $result_data, -1, $count);

				// Fix for tickets
				$result_data = str_replace("window.location='?tid=", "window.location='{$home}?ccce=viewticket&tid=", $result_data);
			}
		}

		// Fix for selfLink with "a=add" parameter
		if ($parse) {
			$result_data = str_replace("selfLink + \"?a=add", "selfLink + \"&a=add", $result_data);
		}

		// Update whmcsBaseUrl
		$result_data = str_replace("whmcsBaseUrl = ", "whmcsBaseUrl = \"{$home}\"; //", $result_data);

		// Fix for SolusVM
		$result_data = str_replace("window.open('modules/servers/solusvmpro/", "window.open('{$home}?ccce=js&ajax=1&js=modules/servers/solusvmpro/", $result_data);

		// Fix for VMware
		$result_data = str_replace('url: "modules/servers', 'url: "'.$home.'?ccce=js&ajax=1&js=modules/servers', $result_data);

		// Fix for 2factor
		$result_data = str_replace("'clientarea.php'", "'$home?ccce=clientarea'", $result_data);

		//check if friendly url support is enabeld
		if(isset($this->meta_data['whmcs-friendly-url-support'])){
			if($this->meta_data['whmcs-friendly-url-support'] != true){
				// Update Details action
				$result_data = str_replace('action="?action=details"', 'action="'.$home.'?ccce=clientarea&action=details"', $result_data);
			} else {
				// Update Details action
				$result_data = str_replace('action="?action=details"', 'action="'.$home.'clientarea.php?action=details"', $result_data);
			}
		} else {
			// Update Details action
			$result_data = str_replace('action="?action=details"', 'action="'.$home.'?ccce=clientarea&action=details"', $result_data);
		}

		//custom friendly urls
		$urlsToUpdate = array(
			'store/' 							  => '?ccce=index&rp=/store/',
			'clientarea/' 						  => '?ccce=index&rp=/clientarea/',
			'cart/domain/renew' 				  => '?ccce=index&rp=/cart/domain/renew',
			'account/contacts' 					  => '?ccce=index&rp=/account/contacts',
			'store' 							  => '?ccce=store',
			'password/reset' 					  => '?ccce=index&rp=/password/reset',
			'domain/pricing' 					  => '?ccce=index&rp=/domain/pricing',
			'user/profile' 						  => '?ccce=index&rp=/user/profile',
			'knowledgebase/search' 				  => '?ccce=index&rp=/knowledgebase/search',
			'user/password' 					  => '?ccce=index&rp=/user/password',
			'user/security' 					  => '?ccce=index&rp=/user/security',
			'whmcs-sync/includes/verifyimage.php' => 'client/includes/verifyimage.php',
			'login' 							  => '?ccce=index&rp=/login',
			'account/users' 					  => '?ccce=index&rp=/account/users',
			'account/paymentmethods' 			  => '?ccce=index&rp=/account/paymentmethods',
		);
		
		//check if friendly url support is enabeld
		if(isset($this->meta_data['whmcs-friendly-url-support'])){
			if($this->meta_data['whmcs-friendly-url-support'] != true){
				foreach ($urlsToUpdate as $url => $replacement) {
					$pattern = '#(' . preg_quote($home . $url, '#') . '([^"]*))#';
					$result_data = preg_replace($pattern, $home . $replacement . '$2', $result_data);
				}
			}
		} else {
			foreach ($urlsToUpdate as $url => $replacement) {
				$pattern = '#(' . preg_quote($home . $url, '#') . '([^"]*))#';
				$result_data = preg_replace($pattern, $home . $replacement . '$2', $result_data);
			}
		}
		
		// Patch issue with "&amp;"
		$result_data = str_replace('&#038;', '&', $result_data);

		// Fix for some JS not being closed correctly
		$result_data = str_replace("&,", '&",', $result_data);
		$result_data = str_replace("&>", '&">', $result_data);
		$result_data = str_replace("&/>", '&"/>', $result_data);
		$result_data = str_replace("& />", '&" />', $result_data);

		// Fix for the "name" attribute, as "name" is a reserved WordPress field name
		if (isset($_REQUEST['ccce']) && ($_REQUEST['ccce'] == 'viewinvoice')) {
			// Do nothing in the context of viewing an invoice
		} else {
			$result_data = str_replace('name="name"', 'name="whmcsname"', $result_data);
		}

		// Gateway Fees addon fix
		$result_data = str_replace('"./modules/addons/gateway_fees/ajax.php"', '"'.$home.'?ccce=js&ajax=2&js=modules/addons/gateway_fees/ajax.php"', $result_data);

		// Fix for auto-forward to the payment gateway issue
		$result_data = str_replace('$("#submitfrm").', 'jQuery("#submitfrm").', $result_data);
		$result_data = str_replace("\$('#submitfrm').", "jQuery('#submitfrm').", $result_data);
		// End of the fix for auto-forward

		// Replace the base URL in the src attribute for templates
		$result_data = str_replace('src="/templates', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/templates', $result_data);
		// Loop through URL variations and update src and href attributes
		foreach ($url_variations as $current_url) {
			// Update src attributes for templates, includes, modules, assets
			$result_data = str_replace('src="'.$current_url.'templates', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/templates', $result_data);
			$result_data = str_replace('src="'.$current_url.'includes', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/includes', $result_data);
			$result_data = str_replace('src="'.$current_url.'modules', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/modules', $result_data);
			$result_data = str_replace('src="assets', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/assets', $result_data);

			// Update href attributes for templates, includes, modules
			$result_data = str_replace('href="'.$current_url.'templates', 'href="' . $this->wp_whmcs_sync_custom_url_handler() . '/templates', $result_data);
			$result_data = str_replace('href="'.$current_url.'includes', 'href="' . $this->wp_whmcs_sync_custom_url_handler() . '/includes', $result_data);
			$result_data = str_replace('action="'.$current_url.'modules', 'action="' . $home . '?ccce=js&ajax=2&js=modules', $result_data);

			// Replace specific URLs for Stripe and Paypal
			$result_data = str_replace('url: "'.$current_url.'/account/paymentmethods', 'url: "'.$home.'?ccce=js&ajax=1&js=accounts/paymentmethods', $result_data);
			$result_data = str_replace("fetch('{$current_url}paypal", "fetch('{$home}?ccce=js&ajax=1&js=paypal", $result_data);
			$result_data = str_replace("fetch('{$current_url}index.php?rp=/paypal", "fetch('{$home}?ccce=js&ajax=1&js=paypal", $result_data);
			$result_data = str_replace("fetch('{$home}?ccce=js&ajax=1&js=paypal/checkout/order/create&", "fetch('{$home}?ccce=js&ajax=1&js=paypal/checkout/order/create?", $result_data);
			$result_data = str_replace("fetch('{$home}?ccce=js&ajax=1&js=paypal/checkout/payment/verify&", "fetch('{$home}?ccce=js&ajax=1&js=paypal/checkout/payment/verify?", $result_data);

			// Update specific form values and URLs
			if (!empty($current_url)) {
				$result_data = str_replace('value="' . $current_url . '"', 'value="' . $home . '"', $result_data);
				$result_data = str_replace('%2F'.str_replace('/', '', $current_url).'%2F', urlencode($home.'?ccce='), $result_data);
			}
		}

		// Update src attribute for Proxmox modules
		$result_data = str_replace('src=\"modules', 'src=\"' . $this->wp_whmcs_sync_custom_url_handler() . '/modules', $result_data);

		// Replace class selector for Proxmox graph
		$result_data = str_replace('$(".so_graph', '$("div.so_graph', $result_data);

		// Import local images by updating src and background attributes
		$result_data = str_replace('src="images', 'src="' . $this->wp_whmcs_sync_custom_url_handler() . '/images', $result_data);
		$result_data = str_replace('background="images', 'background="' . $this->wp_whmcs_sync_custom_url_handler() . '/images', $result_data);
		$result_data = str_replace("window.open('images", "window.open('" . $this->wp_whmcs_sync_custom_url_handler() . '/images', $result_data);

		// Verify captcha image by updating the URL
		$result_data = str_replace($this->wp_whmcs_sync_custom_url_handler() . '/includes/verifyimage.php', $home . '?ccce=verifyimage' . $pid, $result_data);

		// Update URL for Pesapel gateway
		$result_data = str_replace('https:/modules/gateways/pesapal/iframe.php', $this->wp_whmcs_sync_custom_url_handler().'/modules/gateways/pesapel/iframe.php', $result_data);


		// Check if loading WHMCS invoicestyle.css style sheet is enabled
		if ($this->meta_data['whmcs-load-whmcs-invoice-style'] != true) {
			if($this->meta_data['whmcs-template'] === 'six'){
				$result_data = str_replace($home . '?ccce=js&ajax=1&js=templates/six/css/invoice.css', $home , $result_data);
			} else {
				$result_data = str_replace($home . '?ccce=js&ajax=1&js=templates/twenty-one/css/invoice.min.css', $home , $result_data);
			}
		}

		// Check if the request is for viewing an invoice or announcements RSS
		if (isset($_REQUEST['ccce']) &&
			(($_REQUEST['ccce']=='viewinvoice' && strstr($result_data, 'invoice.css'))
				|| $_REQUEST['ccce']=='announcementsrss')
		) {
			// Output the result data in a specific div and terminate the script
			while (count(ob_get_status(true)) > 0) ob_end_clean();
			echo '<div id="whmcs-sync-invoice">'.$result_data.'</div>';
			die();
		}
	
		// Check if loading WHMCS style.css style sheet is enabled
		if ($this->meta_data['whmcs-load-whmcs-style'] != true) {
			if($this->meta_data['whmcs-template'] === 'six'){
				$result_data = str_replace($home . '?ccce=js&ajax=1&js=templates/six/css/custom.css', $home , $result_data);
			} else {
				$result_data = str_replace($home . '?ccce=js&ajax=1&js=templates/twenty-one/css/custom.css', $home , $result_data);
			}
		} else {
			$matches = array();
			// Extract the href attribute from the link tag for style.css
			if (preg_match('/<link.*href="(.*templates\/[a-zA-Z0-9_-]*\/style.css)" \/>/', $result_data, $matches)) {
				$css = $matches[1];
				// Parse and replace the link tag with the parsed CSS content
				$output = $this->parse_whmcs_sync_css($css);
				$result_data = preg_replace('/<link.*templates\/[a-zA-Z0-9_-]*\/style.css" \/>/', '<style type="text/css">' . $output . '</style>', $result_data);
			}
		}

		// Replaces WHMCS jQuery to prevent it from being included twice
		if (in_array($this->meta_data['whmcs-jquery-library'], array('none', 'wp'))) {
			// Remove script tags for various jQuery libraries
			$result_data = preg_replace('/<script.*jquery.js"><\/script>/', '', $result_data);
			$result_data = preg_replace('/<script.*jquery.min.js"><\/script>/', '', $result_data);
			$result_data = preg_replace('/<script.*jqueryui.js"><\/script>/', '', $result_data);
		}

		// Update jQuery UI stylesheet link to use custom URL handler
		$result_data = str_replace('href="includes/jscript/css/ui.all.css', 'href="' . $this->wp_whmcs_sync_custom_url_handler() . '/includes/jscript/css/ui.all.css', $result_data);

		// Fix URL issues
		$surl = str_replace(array('http:', 'https:'), '', $custom_whmcs_url);
		$result_data = str_replace($surl . $home, $home, $result_data);
		$result_data = str_replace($home . 'index/', $home, $result_data);
		$result_data = str_replace($home . '?m=', $home.'index?m=', $result_data);
		$result_data = str_replace($home . 'cart/cart.php', $home . 'cart', $result_data);
		$result_data = str_replace($home . 'serverstatus/serverstatus.php', $home . 'serverstatus', $result_data);
		$result_data = str_replace('"cart.php"', '"' . $home . '?ccce=cart' . $pid . '"', $result_data);
		$result_data = str_replace('"cart.php?', '"' . $home . '?ccce=cart' . $pid . '&', $result_data);

		// Affiliate link
		$result_data = str_replace($surl.'aff.php?', $home.'?ccce=aff&', $result_data);
	
		// DNSManager2 integration
		$result_data = str_replace($home.'modules/addons/DNSManager2', $this->wp_whmcs_sync_custom_url_handler().'/modules/addons/DNSManager2', $result_data);

		// Fix double URL problems
		$result_data = str_replace('//js?', '/js?', $result_data);
		$result_data = str_replace('//?ccce=js&', '/?ccce=js&', $result_data);
		$result_data = str_replace('http:http', 'http', $result_data);
		$result_data = str_replace('https:http', 'http', $result_data);
		$result_data = str_replace('https://http//', 'http://', $result_data);
		$result_data = str_replace($whmcs_path . 'http', 'http', $result_data);
		$result_data = str_replace($whmcs_path . '://', '://', $result_data);
		$result_data = str_replace($this->wp_whmcs_sync_custom_url_handler() . 'http', 'http', $result_data);
		$result_data = str_replace('http:http', 'http', $result_data);
		$result_data = str_replace('https:http', 'http', $result_data);

		// Adjusting font URL
		$result_data = str_replace($home.'/fonts', '//fonts', $result_data);

		// VMware console
		$result_data = str_replace($home.'modules/servers/vmware/console.php', $home.'?ccce=js&ajax=1&js=modules/servers/vmware/console.php', $result_data);

		// DNSManager2 Issues
		$result_data = str_replace('?m=DNSManager2', '?m=DNSManagerII', $result_data);
		$result_data = str_replace('index?m=DNSManagerII', '?m=DNSManagerII', $result_data);

		// Rewrite for selectChangeNavigate
		$result_data = str_replace("onchange=\"selectChangeNavigate(", "onchange=\"selectChangeNavigateWhmcsSync(", $result_data);

		// TCO tokenize
		$result_data = str_replace('twocheckout.php?2checkout', 'twocheckout.php&2checkout', $result_data);
		$result_data = str_replace(substr($home, 0, -1) . $home, $home, $result_data);

		if (!empty($this->meta_data['whmcs-custom-layout']) && $this->meta_data['whmcs-template'] === 'hostiko') {
			$search_pattern = '/https:\/\/hostiko\.com\/layout' . preg_quote($this->meta_data['whmcs-custom-layout'], '/') . '\/whmcs-sync\//';
			$replacement_url = $home . '?ccce=index';

			// Check if the pattern exists in $result_data
			if (preg_match($search_pattern, $result_data)) {
				$result_data = preg_replace($search_pattern, $replacement_url, $result_data, 1);
			}
		}

		if (!empty($this->meta_data['whmcs-custom-layout']) && $this->meta_data['whmcs-template'] === 'resellpress') {
			$search_pattern = '/https:\/\/resellpress\.com\/layout' . preg_quote($this->meta_data['whmcs-custom-layout'], '/') . '\/whmcs-sync\//';
			$replacement_url = $home . '?ccce=index';

			// Check if the pattern exists in $result_data
			if (preg_match($search_pattern, $result_data)) {
				$result_data = preg_replace($search_pattern, $replacement_url, $result_data, 1);
			}
		}

		// Create a Simple HTML DOM parser instance
		$parser = new Wp_Whmcs_Sync_Simple_Html_Dom();
		$parser->load($result_data);

		// Extracting the side menu HTML from the parsed content
		$sidebar = $parser->find('div[id=side_menu]', 0) ? trim($parser->find('div[id=side_menu]', 0)->innertext) : null;

		// Check if the sidebar content is available
		if ($sidebar) {
			// Matching and extracting the login form if present in the sidebar
			$pattern = '/<form(.*?)login(.*?)>/';
			if (preg_match($pattern, $sidebar, $matches)) {
				$matched_login_form  = $matches[0];
				// Swap around the <form> and <p> tags in the sidebar
				$sidebar = preg_replace('/(<form(.*?)login(.*?)>)(\s*)(<p class.*>)/', '$3$1', $sidebar);
				// Add the modified sidebar with the login form to the page_data array
				$page_data['sidebar'][] = $sidebar;
			}

			// Splitting the sidebar content based on the '<p class="header">' string
			$sidebar_splitter  = '<p class="header">';
			$sidebar_content_array  = explode($sidebar_splitter, $sidebar);

			// Remove end paragraph and text headings
			foreach ($sidebar_content_array as $count => $data) {
				$title = '';
				$text = explode('</p>', $data);
				if (count($text) > 0) {
					$title = $text[0];
					unset($text[0]);
					$data = implode('</p>', $text);
				}

				$sidebar_content_array[$count] = $data;
				$sidebar_content_array['mode'][$count - 1] = $title;
			}

			// Assigning relevant sidebar data to the page_data array
			$page_data['sidebarNav'] = @$sidebar_content_array[1]; // QUICK NAVIGATION
			$page_data['sidebarAcInf'] = @$sidebar_content_array[2]; // ACCOUNT INFORMATION
			$page_data['sidebarAcSta'] = @$sidebar_content_array[3]; // ACCOUNT STATISTICS
			$page_data['mode'] = @$sidebar_content_array['mode'];

			// Check if the 'type="password"' is present in ACCOUNT INFORMATION and append the login form
			if (stristr($page_data['sidebarAcInf'], 'type="password"') !== false) {
				$page_data['sidebarAcInf'] = $matched_login_form . $page_data['sidebarAcInf'] . '</form>';
			}
		}

		// Check if the parsed content contains a specific div for the left content
		if ($body = $parser->find('div[id=content_left]', 0)) {
			// Extract the title and store it in the page_data array
			$title = $body->find('h1', 0);
			$page_data['title'] = $title->innertext;
			$title->outertext = ''; // Remove the title from the main content
			$page_data['main'] = $body->innertext;

			// Remove specific class attributes and replace heading tags for styling consistency
			$page_data['main'] = str_replace(' class="heading2"', "", $page_data['main']);
			$page_data['main'] = str_replace("<h1>", "<h4>", $page_data['main']);
			$page_data['main'] = str_replace("</h1>", "</h4>", $page_data['main']);
			$page_data['main'] = str_replace("<h2>", "<h4>", $page_data['main']);
			$page_data['main'] = str_replace("</h2>", "</h4>", $page_data['main']);
			$page_data['main'] = str_replace("<h3>", "<h5>", $page_data['main']);
			$page_data['main'] = str_replace("</h3>", "</h5>", $page_data['main']);
		} elseif ($body = $parser->find('body', 0)) {
			// If no specific content div is found, use the body content
			$page_data['main'] = $body->innertext;
		} elseif ($body = $parser->find('div', 0)) {
			// If neither the content div nor body is found, use the first div encountered
			$page_data['main'] = $body->innertext;
		}

		//if request is coming from sso then redirect the user to the sync page once
		if(isset($_SESSION['whmcs_sso_redirect'])){
			unset($_SESSION['whmcs_sso_redirect']);
			$whmcs_sync_page_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';
			if(!empty($whmcs_sync_page_slug)){
				wp_redirect( site_url($whmcs_sync_page_slug) ); exit;
			}
		}

		// Check if the main content contains the string 'OnLoadEvent()' and append a script tag if present
		if (strstr($page_data['main'], 'OnLoadEvent()') !== false) {
			$page_data['main'] .= '<script type="text/javascript">OnLoadEvent();</script>';
		}

		// Add a script for handling select change events and remove variations of URLs
		$page_data['main'] .= '<script type="text/javascript">function selectChangeNavigateWhmcsSync(t) { var url = $(t).val();';
		foreach ($url_variations as $current_url) {
			$page_data['main'] .= 'url = url.replace("' . $current_url . '", "");';
		}

		// Append JavaScript code to handle URL navigation based on certain conditions
		$page_data['main'] .= 'console.log(url); if (url.search(\'store\') != -1) {';
		$page_data['main'] .= 'url = "'.$home.'" + url; window.location.href = url;';
		$page_data['main'] .= '} else if (url.search(\''.$home.'\') != -1) {';
		$page_data['main'] .= 'url = url.replace("'.$home.'", "");';
		$page_data['main'] .= 'url = "'.$home.'" + url; window.location.href = url;';
		$page_data['main'] .= '} else if (url == \'\') {';
		$page_data['main'] .= 'url = "'.$home.'" + url; window.location.href = url;';
		$page_data['main'] .= '} else {';
	
		// Check if certain conditions are met for modifying the URL before redirection
		$page_data['main'] .= 'url = "'.$home.'?ccce=" + url; window.location.href = url;';
		$page_data['main'] .= '}}</script>';

		// Extract the content of the 'head' element if present
		if ($head = $parser->find('head', 0)) {
			$page_data['head'] = $head->innertext;
		} 

		// Extract and format the content of the 'top_menu' element
		if ($top_menu_element  = $parser->find('div[id=top_menu] ul', 0)) {
			$top_menu_element = $top_menu_element->__toString();
			$page_data['topNav'] = $top_menu_element;
		} else {
			$page_data['topNav'] = "";
		}

		// Extract and format the content of the 'welcome_box' element
		if ($welcome_box_element  = $parser->find('div[id=welcome_box]', 0)) {
			$welcome_box_element = $welcome_box_element->__toString();
			$welcome_box_element = str_replace("&nbsp;", "", $welcome_box_element);
			$welcome_box_element = str_replace("</div>", "", $welcome_box_element);
			$welcome_box_element = str_replace('<div id="welcome_box">', "", $welcome_box_element);
			$welcome_box_element = preg_replace("/<img[^>]+\>/i", " | ", $welcome_box_element);
			$welcome_box_element = '<div class="search_engine">'.$welcome_box_element;
			$welcome_box_element = $welcome_box_element."</div>";
			$page_data['welcomebox'] = $welcome_box_element;
		}

		// Contribution from northgatewebhosting.co.uk: Extract and format the content of the 'cart-total' element
		if ($cart_total_element = $parser->find('div[id=cart-total]', 0)) {
			$cart_total_element = $cart_total_element->__toString();
			$cart_total_element = str_replace('<div id="cart-total">', '<div id="cart-total-widget">', $cart_total_element);
			$page_data['carttotal'] = $cart_total_element;
		}

		// Iterate through the page_data and ensure that 'sidebar' and 'welcomebox' elements have a closing form tag
		foreach ($page_data as $key => $val) {
			if (stristr($key, 'sidebar') !== false || stristr($key, 'welcomebox') !== false) {
				if (!is_array($val) && stristr($val, '<form') !== false && stristr($val, '</form') === false) {
					$page_data[$key] = $val.'</form>';
				}
			}
		}

		// Store session messages in 'msg' key and return the modified page_data
		$page_data['msg'] = $_SESSION;
		return $page_data;

	}
	
	/**
	 * Method to parse content on the basis of parameters
	 *
	 * This method is responsible for parsing the content on the WHMCS-Sync page on the basis of parameters.
	 *
	 */
 	private function whmcs_sync_ajax_handler_v1($buffer, $page_to_include = '') {
		$url = (isset($_REQUEST['js'])) ? sanitize_text_field($_REQUEST['js']) : '';
		$this->wp_whmcs_sync_main_screen($home, $pid);
		$whmcs = $this->wp_whmcs_sync_custom_url_handler();
	
		if (substr($whmcs, -1) != '/'){
			$whmcs .= '/';
		}
		if (strpos($whmcs, 'https://') === 0){
			$whmcs = str_replace('https://', 'http://', $whmcs);
		}
		$whmcs2 = str_replace('http://', 'https://', $whmcs);
		$whmcs3 = str_replace('http:', '', $whmcs);
	
		$whmcs_path = parse_url($this->wp_whmcs_sync_custom_url_handler(), PHP_URL_PATH);
		if (substr($whmcs_path, -1) != '/')
			$whmcs_path .= '/';
	
		$loop = array();
		$loop[$whmcs] = $whmcs;
		if (!is_null($whmcs2)){
			$loop[$whmcs2] = $whmcs2;
		}
		if (!is_null($whmcs3)){
			$loop[$whmcs3] = $whmcs3;
		}
		if ($whmcs_path != ''){
			$loop[$whmcs_path] = $whmcs_path;
		}

		$loop[''] = '';
	
		// java
		$buffer = str_replace('ARCHIVE="modules', 'ARCHIVE="'.$this->wp_whmcs_sync_custom_url_handler().'/modules', $buffer);
	
		// quantumvault fix added
		if (stristr($page_to_include, 'cart') !== false ||
			stristr($page_to_include, 'quantumvault') !== false ||
			stristr($url, 'inittoken') !== false ||
			stristr($page_to_include, 'protxthreedsecure') !== false
		) {
			$this->whmcs_sync_logger(0, "ajax1 Step 2");
			// FULL URLS
			foreach ($loop as $rep_url) {
				// templates css/js
				$f[] = "/src=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/js\/([a-zA-Z0-9-_]*?).js/";
				$r[] = "src=\"{$home}js/?ajax=1&js=" . 'templates/$1/js/$2.js' . $pid;
	
				$f[] = "/href=\"" . preg_quote($rep_url, '/') . "templates\/([a-zA-Z0-9-_]*?)\/css\/([a-zA-Z0-9-_]*?).css/";
				$r[] = "href=\"{$home}js/?ajax=1&js=" . 'templates/$1/css/$2.css' . $pid;
	
				$f[] = '/value\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
				$r[] = 'value="' . $home . '?ccce=$1' . $pid . '"';
	
				$f[] = '/value\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
				$r[] = 'value="' . $home . '?ccce=$1&$2' . $pid . '"';
	
				$f[] = '/action\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php.(.*?)\"/';
				$r[] = 'action="' . $home . '?ccce=$1&$2' . $pid . '"';
	
				$f[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
				$r[] = 'href="' . $home . '?ccce=$1' . $pid . '"';
	
				$f[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\?((?:(?!phpinfo|").)*)\"/';
				$r[] = 'href="' . $home . '?ccce=$1&$2' . $pid . '"';
	
				$f[] = '/href\=\"' . preg_quote($rep_url, '/') . '([a-zA-Z0-9-_]*?).php\"/';
				$r[] = 'href="' . $home . '?ccce=$1' . $pid . '"';
	
				// Payment Gateways
				$f[] = '/value\=\"' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php.(.*?)\"/';
				$r[] = 'value="' . $home . '?ajax=1&ccce=modules/gateways/$1/$2&$3"';
	
				$f[] = '/value\=\"' . preg_quote($rep_url, '/') . 'modules\/gateways\/([a-zA-Z0-9-_]*?)\/([a-zA-Z0-9-_]*?).php/';
				$r[] = 'value="' . $home . '?ajax=1&ccce=modules/gateways/$1/$2';
	
			}
		}
	
		foreach ($loop as $l) {
			if ($l == '') continue;
	
			$replacementsLoop = [
				'action=\u0022'.$l.'index.php?rp=/account/',
				'src=\u0022'.$l.'index.php?rp=/account/',
				'action=\u0022'.$l.'account/',
				'src=\u0022'.$l.'account/',
				'src=\u0022'.$l.'modules/',
			];
	
			$buffer = str_replace($replacementsLoop, [
				'action=\u0022'.$home.'?ajax=1&ccce=account/',
				'src=\u0022'.$home.'?ajax=1&ccce=account/',
				'action=\u0022'.$home.'?ajax=1&ccce=account/',
				'src=\u0022'.$home.'?ajax=1&ccce=account/',
				'src=\u0022'.$home.'?ajax=1&ccce=modules/',
			], $buffer);
		}
	
		//replaces whmcs jquery so that it doesn't start it twice
		if (in_array($this->meta_data['whmcs-jquery-library'], array('none', 'wp'))) {
			$buffer = preg_replace('/<script.*jquery.js"><\/script>/', '', $buffer);
			$buffer = preg_replace('/<script.*jquery.min.js"><\/script>/', '', $buffer);
			$buffer = preg_replace('/<script.*jqueryui.js"><\/script>/', '', $buffer);
		}
	
		$whmcs_path = parse_url($this->wp_whmcs_sync_custom_url_handler(), PHP_URL_PATH);
		if (substr($whmcs_path, -1) != '/')
			$whmcs_path .= '/';
	
		// wbteampro
		$f[] = "/src=\"modules\//";
		$r[] = "src=\"{$home}?ccce=js&ajax=1&js=" . 'modules/$1' . $pid;
	
		$f[] = "/templates\/orderforms\/([a-zA-Z0-9-_]*?)\/js\/main.js/";
		$r[] = $home . "?ccce=js&ajax=2&js=" . 'templates/orderforms/$1/js/main.js' . $pid;
	
		## BootWHMCS
		$f[] = "/templates\/orderforms\/([a-zA-Z0-9-_]*?)\/static\/app.js/";
		$r[] = $home . "?ccce=js&ajax=2&js=" . 'templates/orderforms/$1/static/app.js' . $pid;
		## BootWHMCS
	
		$f[] = '/href\=\"([a-zA-Z0-9-_]*?).php\?(.*?)\"/';
		$r[] = 'href="' . $home . '?ccce=$1&$2' . $pid . '"';
	
		$f[] = "/jQuery.post\(\"([a-zA-Z0-9-_]*?).php/";
		$r[] = "jQuery.post(\"$home?ccce=$1&ajax=1";
	
		$f[] = "/jqClient.post\(\"([a-zA-Z0-9-_]*?).php/";
		$r[] = "jqClient.post(\"$home?ccce=$1&ajax=1";
	
		$f[] = "/window.location\='([a-zA-Z0-9-_]*?).php.(.*?)'/";
		$r[] = "window.location='" . $home . "?ccce=$1&$2" . $pid . "'";
		// six
		$f[] = "/window.location\ \=\ '([a-zA-Z0-9-_]*?).php.(.*?)'/";
		$r[] = "window.location='" . $home . "?ccce=$1&$2" . $pid . "'";
	
		$f[] = "/2([a-zA-Z0-9-_]*?).php/";
		$r[] = "2" . $home . "?ccce=$1" . $pid . "";
	
		$f[] = "/'([a-zA-Z0-9-_]*?).php'/";
		$r[] = "'" . $home . "?ccce=$1" . $pid . "'";
	
		$f[] = "/\"([a-zA-Z0-9-_]*?).php\"/";
		$r[] = "\"" . $home . "?ccce=$1" . $pid . "\"";
	
		$f[] = "/'([a-zA-Z0-9-_]*?).php.(.*?)'/";
		$r[] = "'" . $home . "?ccce=$1&$2" . $pid . "'";
	
		$f[] = "/\"([a-zA-Z0-9-_]*?).php.(.*?)\"/";
		$r[] = "\"" . $home . "?ccce=$1&$2" . $pid . "\"";
		// six
	
		$buffer = preg_replace($f, $r, $buffer, -1, $count);

		//verify captcha image
		$buffer = str_replace('"includes/verifyimage.php?', '"' . $home . '?ccce=verifyimage' . $pid . '&', $buffer);
	
		$whmcs_sync_url = $this->wp_whmcs_sync_custom_url_handler();

		$whmcs_sync_url = str_replace('https:', '', $whmcs_sync_url);
		$whmcs_sync_url = str_replace('http:', '', $whmcs_sync_url);
	
		$buffer = str_replace('url(images', 'url(' . $whmcs_sync_url . '/images', $buffer);
		$buffer = str_replace('src="includes', 'src="' . $whmcs_sync_url . '/includes', $buffer);
		$buffer = str_replace('src="images', 'src="' . $whmcs_sync_url . '/images', $buffer);
		$buffer = str_replace('src="/assets', 'src="' . $whmcs_sync_url . '/assets', $buffer);
		$buffer = str_replace('background="images', 'background="' . $whmcs_sync_url . '/images', $buffer);
		$buffer = str_replace('href="templates', 'href="' . $whmcs_sync_url . '/templates', $buffer);
		$buffer = str_replace('src="templates', 'src="' . $whmcs_sync_url . '/templates', $buffer);
		

		//hostiko update background image urls
		if( ( $this->meta_data['whmcs-template'] === 'hostiko' || $this->meta_data['whmcs-template'] === 'resellpress' ) && !empty(get_option( '_whmcs_sync_page_id' ))){
			// Pattern to match background-image URLs
			$pattern = '/url\(([^)]+)\)/';

			// Replace the URLs in the buffer
			$buffer = preg_replace_callback($pattern, function ($matches) use ($whmcs_sync_url) {
				$url = trim($matches[1], "'\""); // Remove surrounding quotes from the URL

				if(!empty($this->meta_data['whmcs-custom-layout'])){
					$layout = $this->meta_data['whmcs-custom-layout'];
				} else {
					$layout = '85';
				}

				// Apply the change only if the URL contains "assets/images"
				if (strpos($url, 'assets/images') !== false) {
					return 'url(' . site_url() . '/'.get_post_field('post_name', get_option( '_whmcs_sync_page_id' )).'/?ccce=js&ajax=1&js=templates/'.$this->meta_data['whmcs-template'].'/layouts/wp-'.$layout.'/' . $url . ')';
				}

				// Return the original URL if no replacement is needed
				return $matches[0];
			}, $buffer);
		}
	
		// six
		if (isset($_REQUEST['js']) && (stristr($_REQUEST['js'], 'assets') !== false && stristr($_REQUEST['js'], '.css') !== false)) {
			$path = pathinfo($_REQUEST['js']);
			$relative_dir = $path['dirname'];
			$buffer = str_replace('url(..', 'url(' . $whmcs_sync_url . '/' . $relative_dir . '/..', $buffer);
			$buffer = str_replace('url(' . $whmcs_sync_url . '/' . $relative_dir . '///', 'url(//', $buffer);
			$buffer = str_replace('\'../fonts/', "'".$whmcs_sync_url . '/assets/fonts/', $buffer);
		}
	
		// icheck
		if (isset($_REQUEST['js']) && (stristr($_REQUEST['js'], 'icheck') !== false && stristr($_REQUEST['js'], '.css') !== false)) {
			$buffer = str_replace('url(', 'url(' . $whmcs_sync_url . '/' . $relative_dir . '/', $buffer);
		}
	
		if (isset($_REQUEST['js']) && stristr($_REQUEST['js'], '.css') !== false) {
			$tmp_path = pathinfo($_REQUEST['js'], PATHINFO_DIRNAME);
			$buffer = str_replace("url(blue@2x.png)", "url({$whmcs_sync_url}/{$tmp_path}/blue@2x.png)", $buffer);
			$buffer = str_replace("url(blue.png)", "url({$whmcs_sync_url}/{$tmp_path}/blue.png)", $buffer);
		}
		// virtualizor
		$buffer = str_replace("'src', 'modules/", "'src', '".$whmcs_sync_url . "/modules/", $buffer);
	
		// boleto
		$buffer = str_replace('src=imagens', 'src=' . $whmcs_sync_url . '/modules/gateways/boleto/imagens', $buffer);
		$buffer = str_replace('src="imagens', 'src="' . $whmcs_sync_url . '/modules/gateways/boleto/imagens', $buffer);
		$buffer = str_replace('SRC="imagens', 'src="' . $whmcs_sync_url . '/modules/gateways/boleto/imagens', $buffer);
	
		if (isset($_REQUEST['js']) &&
			(
				(stristr($_REQUEST['js'], '.css') !== false && stristr($_REQUEST['js'], 'templates') !== false
				|| (isset($_REQUEST['give']) && stristr($_REQUEST['give'], '.css') !== false)) ||
				(stristr($_REQUEST['js'], 'vmware') !== false && stristr($_REQUEST['js'], '.css') !== false)
			)
		) {
			$path = pathinfo($_REQUEST['js']);
			$relative_dir = $path['dirname'];
			$buffer = str_replace('url(..', 'url(' . $whmcs_sync_url . '/' . $relative_dir . '/..', $buffer);
			$buffer = str_replace('url(\'', 'url(\'' . $whmcs_sync_url . '/' . $relative_dir . '/', $buffer);
			$buffer = str_replace('url("', 'url("' . $whmcs_sync_url . '/' . $relative_dir . '/', $buffer);
			$buffer = str_replace('url("' . $whmcs_sync_url . '/' . $relative_dir . '///fonts', 'url("//fonts', $buffer);
			$buffer = str_replace('url("' . $whmcs_sync_url . '/' . $relative_dir . '/https://fonts', 'url("https://fonts', $buffer);
		}
	
		if (isset($_REQUEST['js']) && stristr($_REQUEST['js'], 'servers/solusvmpro') !== false) {
			$buffer = str_replace('url: "modules', 'url: "'.$home.'?ccce=js&ajax=1&js=modules', $buffer);
		}
	
		$buffer = str_replace('"cart.php"', '"' . $home . '?ccce=cart' . $pid . '"', $buffer);
		$buffer = str_replace('"cart.php?', '"' . $home . '?ccce=cart' . $pid . '&"', $buffer);
		$buffer = str_replace("'cart.php?", "'" . $home . "?ccce=cart" . $pid . '&', $buffer);
	
		//jQuery UI
		$buffer = str_replace('href="includes/jscript/css/ui.all.css', 'href="' . $this->wp_whmcs_sync_custom_url_handler() . '/includes/jscript/css/ui.all.css', $buffer);
	
		// virtualizor
		if (isset($_REQUEST['give'])) {
			$buffer = str_replace('href="modules', 'href="'.$this->wp_whmcs_sync_custom_url_handler().'/modules', $buffer);
			$buffer = str_replace(' \'modules/servers/virtualizor/ui/images/', " '".$this->wp_whmcs_sync_custom_url_handler().'/modules/servers/virtualizor/ui/images/', $buffer);
		}
	
		// VMWare
		if (isset($_REQUEST['js']) && stristr($_REQUEST['js'], 'vmware') !== false && stristr($_REQUEST['js'], 'console.php') !== false) {
			$buffer = str_replace('"console_lib', '"'.$whmcs_sync_url.'/modules/servers/vmware/console_lib', $buffer);
		}
		$buffer = str_replace('url: \'modules/', 'url: \''.$whmcs_sync_url.'/modules/', $buffer);
	
		// Twitter feed
		$buffer = str_replace('?ccce=index&ajax=1?rp=', '?ccce=index&ajax=1&rp=', $buffer);
	
		if (strstr($url, '?') !== false) {
			$test = explode('?', $url);
			$test = $test[0];
		} else {
			$test = $url;
		}
	
		$this->whmcs_sync_logger(0, '[C] Checking ' . $test);
	
		// whmcsBaseUrl
		$buffer = str_replace("whmcsBaseUrl+\"/index.php?rp=\"", "whmcsBaseUrl+\"?ccce=index&rp=\"", $buffer);
		//whmcsBaseUrl+"/cart"
	
		// Payment Gateways
		$buffer = str_replace([
			'action=\u0022'.$this->wp_whmcs_sync_custom_url_handler().'/account/',
			'action=\u0022'.$this->wp_whmcs_sync_custom_url_handler().'/modules/gateways',
			'.php',
			'value=\u0022'.$this->wp_whmcs_sync_custom_url_handler().'/\u0022'
		], [
			'action=\u0022'.$home.'?ajax=1&ccce=modules/account/',
			'action=\u0022'.$home.'?ajax=1&ccce=modules/gateways',
			'',
			'value=\u0022'.$home.'?ajax=1&ccce=\u0022'
		], $buffer);
		
		//adding .php extension to the redirect url for rsession
		if (strpos($buffer, '"redirectTo"') !== false) {

			$buffer = json_decode($buffer, true);
			if (isset($buffer['redirectTo'])) {
				$redirectToURL = $buffer['redirectTo'];
	
				// Update the "redirectTo" URL
				$buffer['redirectTo'] = preg_replace('/(rsession_init)(\??[^"]*)/', '$1.php$2', $redirectToURL);
			}
			$buffer = json_encode($buffer);
		}

		if(isset($this->meta_data['whmcs-friendly-url-support'])){
			if($this->meta_data['whmcs-friendly-url-support'] == true){
				$buffer = str_replace('whmcsBaseUrl+"/cart"', 'whmcsBaseUrl+"cart.php"', $buffer);
			} else {
				$buffer = str_replace('whmcsBaseUrl+"/cart"', 'whmcsBaseUrl+"?ccce=cart"', $buffer);
			}
		} else {
			$buffer = str_replace('whmcsBaseUrl+"/cart"', 'whmcsBaseUrl+"?ccce=cart"', $buffer);
		}

		$smarterRouteUrlFunction = "this.getRouteUrl=function(t){return ''+";
		$buffer = str_replace("this.getRouteUrl=function(t){return whmcsBaseUrl+", $smarterRouteUrlFunction, $buffer);
	
		return $buffer;
	}
	
	/**
	 * Parses and modifies the content for AJAX requests (ajax=2).
	 *
	 * @param string $buffer The content to be parsed and modified.
	 * @return string The parsed and modified content.
	 */
	private function whmcs_sync_ajax_handler_v2($buffer) {
		$url = (isset($_REQUEST['js'])) ? sanitize_text_field($_REQUEST['js']) : '';
		$this->wp_whmcs_sync_main_screen($home, $pid);

		// Modify URLs for AJAX requests
		$f[] = "/.post\(\"([a-zA-Z0-9-_]*?).php/";
		$r[] = ".post(\"$home?ccce=$1&ajax=2";

		$f[] = "/.post\('([a-zA-Z0-9-_]*?).php/";
		$r[] = ".post('$home?ccce=$1&ajax=2";

		$f[] = '/document.location\=\"([a-zA-Z0-9-_]*?).php.(.*?)\"/';
		$r[] = 'document.location="' . $home . '?ccce=$1&$2' . $pid . '"';

		$f[] = '/window.open\(\"([a-zA-Z0-9-_]*?).php.(.*?)\"/';
		$r[] = 'window.open("' . $home . '?ajax=1&ccce=$1&$2' . $pid . '"';

		$buffer = preg_replace($f, $r, $buffer, -1, $count);

		// Replace specific URLs
		$buffer = str_replace('wbteampro.php?', $home . '?ccce=wbteampro&', $buffer);
		$buffer = str_replace('wbteampro.php', $home . '?ccce=wbteampro', $buffer);

		$buffer = str_replace('"cart.php"', '"' . $home . '?ccce=cart' . $pid . '"', $buffer);
		$buffer = str_replace("'cart.php?", "'" . $home . "?ccce=cart" . $pid . '&', $buffer);

		// Replace URLs with base path
		$buffer = str_replace('url(images', 'url(' . wp_whmcs_sync_custom_url_handler() . '/images', $buffer);
		$buffer = str_replace('src="includes', 'src="' . wp_whmcs_sync_custom_url_handler() . '/includes', $buffer);
		$buffer = str_replace('src="images', 'src="' . wp_whmcs_sync_custom_url_handler() . '/images', $buffer);
		$buffer = str_replace('background="images', 'background="' . wp_whmcs_sync_custom_url_handler() . '/images', $buffer);
		$buffer = str_replace('href="templates', 'href="' . wp_whmcs_sync_custom_url_handler() . '/templates', $buffer);
		$buffer = str_replace('src="templates', 'src="' . wp_whmcs_sync_custom_url_handler() . '/templates', $buffer);

		// Adjust AJAX parameters
		$buffer = str_replace('ajax=2?', 'ajax=2&', $buffer);

		// Cache the parsed content if applicable
		if (strstr($url, '?') !== false) {
			$test = explode('?', $url);
			$test = $test[0];
		} else {
			$test = $url;
		}

		return $buffer;
	}

	/**
	 * Handles the output of content for the specified page or AJAX request.
	 * This method is used to process and deliver content based on various conditions.
	 *
	 * @param string $page The requested page or content identifier.
	 */
	private function whmcs_sync_response_renderer($page = null) {
		global $post, $wpdb, $wordpress_page_name, $wp_whmcs_sync_include;

		$ajax = false;
		$ref = rand(100, 999);
		$post_id = isset($post) ? $post->ID : 1;
		$wp_whmcs_sync_include = '';

		// Determine $wp_whmcs_sync_include value
		if ($page) {
			$wp_whmcs_sync_include = $page;
		} elseif (isset($_REQUEST['ccce'])) {
			$wp_whmcs_sync_include = sanitize_text_field($_REQUEST['ccce']);
			$ajax = isset($_REQUEST['ajax']) && $_REQUEST['ajax'] ? intval($_REQUEST['ajax']) : false;
		} elseif (isset($post->post_title) && $post->post_title === $this->whmcs_page_title) {
			$wp_whmcs_sync_include = "index";
		} else {
			$wp_whmcs_sync_include = "index";
		}

		// Handle friendly URL support
		if (isset($this->meta_data['whmcs-friendly-url-support']) && $this->meta_data['whmcs-friendly-url-support'] == true) {
			$is_https = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
			$current_url = ($is_https ? 'https' : 'http') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
			$page_slug = get_option('_whmcs_sync_page_id') ? get_post_field('post_name', get_option('_whmcs_sync_page_id')) : '';

			if (!empty($page_slug)) {
				$site_url = site_url('' . $page_slug . '/');
				if ($current_url != $site_url) {
					$wp_whmcs_sync_include = str_replace($site_url, '', $current_url);
					$custom_mappings = [
						'cart.php/?a=view' => 'cart',
						'cart.php/?a=confdomains' => 'cart',
						'login' => 'index',
						'?rp=/account/users' => 'index',
						'?rp=/account/paymentmethods' => 'index',
						'?rp=/account/contacts' => 'index',
						'?rp=/user/security' => 'index',
						'?rp=/user/password' => 'index',
						'?rp=/user/profile' => 'index',
						'logout.php/' => 'logout',
						'clientarea.php/clientarea.php/?action=services' => 'clientarea',
						'clientarea.php/?action=services' => 'clientarea',
						'clientarea.php/?action=details' => 'clientarea',
						'clientarea.php?action=details' => 'clientarea',
						'clientarea.php/supporttickets.php/' => 'clientarea',
						'clientarea.php/?action=emails' => 'clientarea',
						'clientarea.php?action=domains' => 'clientarea',
						'clientarea.php?action=invoices' => 'clientarea',
						'clientarea.php/clientarea.php/?action=masspay&all=true' => 'clientarea',
						'clientarea.php/?action=masspay&all=true' => 'clientarea',
					];

					$wp_whmcs_sync_include = isset($custom_mappings[$wp_whmcs_sync_include]) ? $custom_mappings[$wp_whmcs_sync_include] : $wp_whmcs_sync_include;
				} else {
					$wp_whmcs_sync_include = 'index';
				}
			}
		}

		$this->whmcs_sync_logger(0, '[URL Init '.$ref.'] '.$wp_whmcs_sync_include);

		if ($wp_whmcs_sync_include == "index" && !empty($_GET['gid']) && count($_GET) < 2) {
			$this->wp_whmcs_sync_main_screen($home, $pid, false);
			wp_redirect($home."?ccce=cart&gid=".$_REQUEST['gid']);
			exit;
		}

		$http = $this->whmcs_sync_http_client($wp_whmcs_sync_include);
		$this->whmcs_sync_logger(0, '[URL '.$ref.'] '.$http);

		// Adjust URL if it contains specific strings
		if (stristr($http, 'viewinvoice.php') !== false && stristr($http, 'ccce=viewinvoice') !== false) {
			$http = str_replace("&ccce=viewinvoice", "", $http);
			$this->whmcs_sync_logger(0, '[URL '.$ref.'] '.$http);
		}

		if (strstr($http, '?a=checkout') !== false && isset($_REQUEST['action']) && $_REQUEST['action'] == 'doPayment') {
			$http = str_replace('?a=checkout', '?a=complete', $http);
			$this->whmcs_sync_logger(0, '[URL '.$ref.'] URL Adjusted to ?a=complete');
		}

		if (strstr($http, 'index.php?type=q&id') !== false) {
			$http = str_replace('index.php', 'dl.php', $http);
			$wp_whmcs_sync_include = "dl";
		}

		if (strstr($http, 'index.php') !== false && isset($_REQUEST['a']) && in_array($_REQUEST['a'], array('addToCart', 'updateDomainPeriod')) && isset($_REQUEST['domain'])) {
			$http = str_replace('index.php', 'cart.php', $http);
			$this->whmcs_sync_logger(0, '[URL '.$ref.'] URL Adjusted to ?a=complete');
		}

		$news = new Whmcs_Http_Sync_Handler($http);
		// $news->debugFunction = 'cc_whmcs_log';

		if (isset($news->post['whmcsname'])) {
			$news->post['name'] = $news->post['whmcsname'];
			unset($news->post['whmcsname']);
		}

		// $news = apply_filters('bridge_http', $news);
		$news->forceWithRedirect['systpl'] = $this->meta_data['whmcs-template'] ?? 'five';

		// Adjust post data if necessary
		if ($wp_whmcs_sync_include == 'login' && !empty($news->post['username'])) {
			$news->post['rememberme'] = 'on';
		}

		if (!$news->curlInstalled()) {
			$this->whmcs_sync_logger('Error','CURL not installed');
			return "cURL not installed";
		} elseif (!$news->live()) {
			$this->whmcs_sync_logger('Error','A HTTP Error occurred');
			return "A HTTP Error occurred";
		} else {
			if ($wp_whmcs_sync_include == 'verifyimage' ||
				(isset($_REQUEST['ccce']) && stristr($_REQUEST['ccce'], '/qr/') !== false) ||
				(isset($_REQUEST['showqrimage']) && $_REQUEST['showqrimage'] == 1)
				|| (isset($_REQUEST['js']) && (
						stristr($_REQUEST['js'], '.jpg') !== false ||
						stristr($_REQUEST['js'], '.png') !== false ||
						stristr($_REQUEST['js'], '.jpeg') !== false ||
						stristr($_REQUEST['js'], '.gif') !== false ||
						stristr($_REQUEST['js'], '.svg') !== false
					))
			) 	{
				$output = $news->DownloadToString();
				while (count(ob_get_status(true)) > 0) ob_end_clean();

				if (isset($_REQUEST['ccce']) && stristr($_REQUEST['ccce'], '/qr/') !== false) {
					$filename = 'topt';
					$file_extension = 'png';
				} else {
					$filename = basename($_REQUEST['js']);
					$file_extension = strtolower(substr(strrchr($filename, "."), 1));
				}

				switch ($file_extension) {
					case "gif": $ctype="image/gif"; break;
					case "png": $ctype="image/png"; break;
					case "jpeg":
					case "jpg": $ctype="image/jpeg"; break;
					case "svg": $ctype="image/svg+xml"; break;
					default: $ctype="image"; break;
				}

				header("Content-Type: $ctype");
				echo $news->body;

				die();
			} elseif (stristr($wp_whmcs_sync_include, 'announcementsrss') !== false
				|| (
					isset($_REQUEST['rp']) && $_REQUEST['rp'] == '/announcements/rss'
				)
				|| stristr($wp_whmcs_sync_include, 'networkissuesrss') !== false
			) {
				while (count(ob_get_status(true)) > 0) ob_end_clean();
				$output = $news->DownloadToString();
				header('Content-Type: application/rss+xml; charset=utf-8');
				echo $news->body;
				die();
			} elseif (($wp_whmcs_sync_include=='dl' && $news->headers['content-type'] != 'text/html') ||
				(isset($_REQUEST['playlist'], $_REQUEST['device_mac'])) ||
				(isset($_REQUEST['act']) && $_REQUEST['act'] == 'download') ||
				(isset($_REQUEST['XCAction']) && $_REQUEST['XCAction'] == 'downloadCallHistory') ||
				(isset($_REQUEST['playlist'], $_REQUEST['action']) && $_REQUEST['action'] == 'productdetails') ||
				(isset($_REQUEST['vp_login'], $_REQUEST['action']) && $_REQUEST['action'] == 'productdetails') ||
				(isset($_REQUEST['a']) && $_REQUEST['a'] == 'CreateEmailAccount') ||
				(isset($_REQUEST['action'], $_REQUEST['service-id']) && $_REQUEST['action'] == 'manage-service') ||
				(isset($_REQUEST['action'], $_REQUEST['m']) && $_GET['action'] == 'download' && $_GET['m'] == 'invoiceme') ||
				(stristr($wp_whmcs_sync_include, 'wbteampro') !== false && isset($_REQUEST['view']) && $_REQUEST['view'] == 'raw') ||
				(stristr($wp_whmcs_sync_include, 'wbteampro') !== false && isset($_REQUEST['act']) && $_REQUEST['act'] == 'download') ||
				(stristr($wp_whmcs_sync_include, 'project_management') !== false && isset($_REQUEST['action']) && $_REQUEST['action'] == 'dl') ||
				(stristr($wp_whmcs_sync_include, 'project_management') !== false && stristr($wp_whmcs_sync_include, '.css') !== false)
			) {
				while (count(ob_get_status(true)) > 0) ob_end_clean();

				$output = $news->DownloadToString();

				if (strstr($output, 'name="password"')) {
					if ($wordpress_page_name){
						$p = $wordpress_page_name;
					} else {
						$p = '/';
					} 

					header('location:'.get_option('home').$p.'?ccce=clientarea');
				} else {
					header("Content-Disposition: ".$news->headers['content-disposition']);
					header("Content-Type: ".$news->headers['content-type']);
					echo $news->body;
					die();
				}
			} elseif ($ajax == 1 ||
				(isset($_REQUEST['mg-page'], $_REQUEST['mg-action'])) ||
				(isset($_REQUEST['vserverid'])) ||
				(isset($_REQUEST['vserverid'])) ||
				(isset($_REQUEST['_vnc']) && $_REQUEST['ccce'] == 'vnc') ||
				(stristr($wp_whmcs_sync_include, 'serverstatus') !== false && isset($_REQUEST['num'])) ||
				(isset($_REQUEST['action'])	&& $_REQUEST['action'] == 'getcustomfields') ||
				(isset($_REQUEST['check'], $_REQUEST['addtocart'], $_REQUEST['domain'])) ||
				(isset($_REQUEST['a'], $_REQUEST['domain']) && $_REQUEST['a'] == 'updateDomainPeriod') ||
				(isset($_REQUEST['a'], $_REQUEST['domain']) && $_REQUEST['a'] == 'validateCaptcha') ||
				(isset($_REQUEST['a'], $_REQUEST['domain']) && $_REQUEST['a'] == 'checkDomain') ||
				(isset($_REQUEST['responseType']) && $_REQUEST['responseType'] == 'json') ||
				(isset($_REQUEST['action']) && $_REQUEST['action'] == 'doPayment') ||
				(stristr($wp_whmcs_sync_include, 'creditcard') !== false && isset($_REQUEST['cccvv']) && $_REQUEST['action'] == 'submit' && stristr($news->DownloadToString(), 'twocheckout.php') !== false) ||
				(stristr($wp_whmcs_sync_include, 'cart') !== false && isset($_REQUEST['cccvv'], $_REQUEST['paymentmethod']) && $_REQUEST['paymentmethod'] == 'twocheckout') ||
				(isset($_REQUEST['PaRes']) && isset($_REQUEST['MD'])) ||
				(isset($_REQUEST['select_modal'])) ||
				(isset($_REQUEST['rp']) && strstr($_REQUEST['rp'], '/domain') !== false && strstr($_REQUEST['rp'], '/renew') === false) ||
				(isset($_REQUEST['rp']) && strstr($_REQUEST['rp'], '/auth/provider/')) ||
				(isset($_REQUEST['action']) && $_REQUEST['action'] == 'productdetails' && isset($_REQUEST['give'])) ||
				(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest')
			) {
				$this->whmcs_sync_logger(0, "ajax 0 - ".json_encode($_REQUEST));
				$output=$news->DownloadToString();
				if (!$news->redirect) {
					$this->whmcs_sync_logger("ajax Request");
					while (count(ob_get_status(true)) > 0) ob_end_clean();
					$body=$news->body;

					if ((isset($_REQUEST['give']) && stristr($_REQUEST['give'], '.html') !== false)
					|| (isset($_REQUEST['give']) && stristr($_REQUEST['give'], '.js') !== false)
					) {
						$body = $this->whmcs_sync_ajax_handler_v1($body, $wp_whmcs_sync_include);
					} elseif (strstr($wp_whmcs_sync_include, 'creditcard') !== false && strstr($body, 'twocheckout') !== false) {
						$body = $this->parse_whmcs_sync_content($output);
						$body = '<html><head>'.$body['head'].'</head><body onload="callcreatetoken()">'.str_replace('<script>', '<script type="text/javascript">', $body['main']).'</body></html>';
					} elseif (strstr($wp_whmcs_sync_include, 'creditcard') !== false) {
						return $output;
					} else if (isset($_REQUEST['mg-page'], $_REQUEST['mg-action'])) {
						header('Content-Type: application/json');
						echo $body;
						die();                    
					} else if (isset($_REQUEST['vserverid']) || (isset($_REQUEST['rp']) && strstr($_REQUEST['rp'], '/auth/provider/'))) {
						if (isset($_REQUEST['rp']) && $_REQUEST['rp'] == '/auth/provider/google_signin/finalize') {
							if (class_exists('wpusers')) {
								$wpusers = new wpusers();
								$wpusers->loginWpUserOauth('google', trim($body));
							}
						}
						header('Content-Type: application/json');
						echo $body;
						die();
					} else {
						$this->whmcs_sync_logger(0, "ajax1: {$wp_whmcs_sync_include}");
						$body = $this->whmcs_sync_ajax_handler_v1($body, $wp_whmcs_sync_include);
					}

					$body_test = json_decode($body, true);

					if (is_array($body_test)) {
						header('Content-Type: application/json');
						echo $body;
						die();
					} else if ((isset($_REQUEST['js']) && stristr($_REQUEST['js'], '.css') !== false) || (isset($_REQUEST['give']) && stristr($_REQUEST['give'], '.css') !== false)) {
						header('Content-Type: text/css');
						echo $body;

						die();
					} else if ((isset($_REQUEST['js']) && stristr($_REQUEST['js'], '.js') !== false) || (isset($_REQUEST['give']) && stristr($_REQUEST['give'], '.js') !== false)) {
						header('Content-Type: application/javascript');
					} else if (
						isset($_REQUEST['a'], $_REQUEST['type'], $_REQUEST['domain']) ||
						isset($_REQUEST['responseType']) && $_REQUEST['responseType'] == 'json' ||
						(isset($_REQUEST['js']) && strstr($_REQUEST['js'], 'ispapi') !== false) ||
						(isset($_REQUEST['rp']) && strstr($_REQUEST['rp'], '/domain') !== false) ||
						isset($_REQUEST['a'], $_REQUEST['domain'])) {
						return $output;
						// header('Content-Type: application/json');
					} else if (isset($_REQUEST['select_modal'])) {
						header('Content-Type: application/json');
						$body = str_replace(array('\u0027', '\u0022', '\u002'), '\"', $body);
						$body = str_replace('2cart', 'cart', $body);
						echo $body;
						die();
					}
					echo $body;
					die();
				} else {
					$this->whmcs_sync_logger('Notification','[A] Redirect to: '.$output);
					header('Location:'.$output);
					die();
				}
			} elseif ( $ajax == 2 ) {
				while (count(ob_get_status(true)) > 0) ob_end_clean();
				$output = $news->DownloadToString();
				$body = $news->body;
				$body = $this->whmcs_sync_ajax_handler_v2($body);

				if (isset($_REQUEST['js']) && stristr($_REQUEST['js'], '.css') !== false) {
					header('Content-Type: text/css');
				} else if (isset($_REQUEST['js']) && stristr($_REQUEST['js'], '.js') !== false) {
					header('Content-Type: application/javascript');
				} else {
					header('HTTP/1.1 200 OK');
				}

				echo $body;
				die();
			} elseif ($news->redirect) {
				$output = $news->DownloadToString();
				if ($wordpress_page_name) {
					$p = $wordpress_page_name;
				} else {
					$p = '/';
				}
				$f[] = '/.*\/([a-zA-Z\_]*?).php.(.*?)/';
				$r[] = get_option('home').$p.'?ccce=$1&$2';
				$f[] = '/([a-zA-Z\_]*?).php.(.*?)/';
				$r[] = get_option('home').$p.'?ccce=$1&$2';
				$output = preg_replace($f, $r, $news->location, -1, $count);
				$this->whmcs_sync_logger('Notification','[1] Redirect to: '.$output);
				header('Location:'.$output);
				die();
			} else {
				if (isset($_REQUEST['aff'])) {
					$news->follow = false;
				}
				
				$output = $news->DownloadToString();
				
				if ($news->redirect) {
					header('Location:' . $output);
					die();
				}
				
				if (isset($_REQUEST['aff'], $news->headers['location'])) {
					$p = $wordpress_page_name ? $wordpress_page_name : '/';
					$f = '/.*\/([a-zA-Z\_]*?).php.(.*?)/';
					$r = get_option('home') . $p . '?ccce=$1&$2';
					$output = preg_replace([$f, $f], [$r, $r], $news->headers['location'], -1, $count);
					$this->whmcs_sync_logger('Notification', '[2] Redirect to: ' . $output);
					header('Location:' . $output);
					die();
				}
				
				return $output;
			}
		}
	}

	/**
	 * Generate and return the URL for WHMCS integration based on the requested page and parameters.
	 *
	 * @param string $requested_page The requested page.
	 * @return string The WHMCS integration URL.
	 */
	private function whmcs_sync_http_client($requested_page = "index") {
		// Parse the requested page URL
		$parsed_page = parse_url($requested_page);
		
		// Initialize variables and arrays
		$has_extension = true;
		$ignored_get_params = [
			'page_id', 'ccce', 'whmcspage'
		];
		$non_php_endings = [
			'download', '.html',
			'login', 'store', '.php', '/',
		];
		$non_php_contains = [
			'two-factor', 'challenge', 'password/reset',
		];

		// Get the WHMCS URL
		$whmcs_url = $this->wp_whmcs_sync_custom_url_handler() . "/";

		// Check for HTTPS redirection based on 'sec' query parameter
		if ((strpos($whmcs_url, 'https://') !== 0) && isset($_REQUEST['sec']) && ($_REQUEST['sec'] == '1')) {
			$whmcs_url = str_replace('http://', 'https://', $whmcs_url);
		}

		// Initialize parameters string
		$query_parameters = "";

		// Handle specific pages
		if ($requested_page == 'verifyimage') {
			// Handle the 'verifyimage' page
			$http = $whmcs_url . 'includes/' . $requested_page . '.php';
			return $http;
		} elseif (!empty($_REQUEST['ccce']) && $_REQUEST['ccce'] == 'js') {
			// Handle JavaScript requests
			if (isset($_REQUEST['js'])) {
				$http = $whmcs_url . sanitize_text_field($_REQUEST['js']);
				return $http;
			}
		} else {
			// Check for page extensions
			foreach ($non_php_contains as $keyword) {
				if (stristr($requested_page, $keyword) !== false) {
					$has_extension = false;
				}
			}
			foreach ($non_php_endings as $ending) {
				$offset = strlen($ending) * -1;
				if (substr($requested_page, $offset) == $ending) {
					$has_extension = false;
				}
			}
		}

		// Build the final URL based on extension
		if ($has_extension) {
			$http = $whmcs_url . $requested_page . '.php';
		} else {
			$http = $whmcs_url . $requested_page;
		}

		// Initialize an array for parameters
		$parameters = [];

		// Sanitize and filter GET parameters
		if (!empty($_GET)) {
			foreach ($_GET as $param => $value) {
				if (!in_array($param, $ignored_get_params)) {
					if (is_array($value)) {
						foreach ($value as $key => $val) {
							if (is_array($val)) {
								foreach ($val as $subkey => $subval) {
									$parameters[$param][$key][$subkey] = sanitize_text_field($subval);
								}
							} else {
								$parameters[$param][$key] = sanitize_text_field($val);
							}
						}
					} else {
						$parameters[$param] = sanitize_text_field($value);
					}
				}
			}
		}

		// Handle 'whmcspage' parameter
		if (!empty($_GET['whmcspage'])) {
			$parameters['whmcspage'] = sanitize_text_field($_GET['whmcspage']);
		}

		// Get the WHMCS template or use 'twenty-one' as a default
		$template_name = $this->meta_data['whmcs-template'] ? $this->meta_data['whmcs-template'] : 'twenty-one';
		$parameters['systpl'] = $template_name;

		// Set the ampersand character
		$ampersand = '&';

		// Append parameters to the URL
		if (!empty($parameters)) {
			$http .= '?' . http_build_query($parameters);
		}

		if(!empty($this->meta_data['whmcs-custom-layout']) && ($this->meta_data['whmcs-template'] === 'hostiko' || $this->meta_data['whmcs-template'] === 'resellpress')){
			return $http.'&layout='.$this->meta_data['whmcs-custom-layout'].'';
		} else {
			return $http;
		}
	}

	/**
	 * Method to retrieve cached data.
	 *
	 * This method retrieves cached data based on the specified flag.
	 *
	 * @param string $flag The cache flag to specify the type of data to retrieve ('all' or '').
	 * @return array An array of cached data based on the flag.
	 */
	private function get_sync_cache($flag = '') {
		// Define cache flags based on the input flag
		if ($flag === 'all') {
			$cache_flags = array('', '_js', '_css');
		} else {
			$cache_flags = array('');
		}

		$cached_data = array();
		foreach ($cache_flags as $cache_flag) {
			// Retrieve the current cache data
			$current_cache = unserialize(get_option('wp_whmcs_sync_cache' . $cache_flag));

			if (!is_array($current_cache)) {
				$current_cache = array();
			}

			$cache_directory = dirname(__FILE__) . '/cache';

			// Check the current cache and remove expired or non-existent cached data
			foreach ($current_cache as $url => $expiration) {
				$expires = explode('_', $expiration);

				if (time() > $expires[count($expires) - 1] || !file_exists($cache_directory . '/' . $expiration)) {
					if (file_exists($cache_directory . '/' . $expiration)) {
						unlink($cache_directory . '/' . $expiration);
					}
					unset($current_cache[$url]);
				} else {
					$cached_data[$url] = $expiration;
				}
			}
		}

		return $cached_data;
	}

	/**
	 * Parse CSS content for WHMCS Sync.
	 * This method takes CSS content, adds a prefix to selectors, and removes comments.
	 *
	 * @param string $css The input CSS content.
	 * @return string The parsed CSS content.
	 */
	private function parse_whmcs_sync_css($css) {
		// Initialize variables
		$file_contents = file_get_contents( $css );
		$buffer = '';
		$result_output = '';
		$has_comments = false;

		// Loop through each character in the input CSS content
		for ($i = 0; $i < strlen($file_contents); $i++) {
			// Check for the beginning of a comment block
			if ($file_contents[$i] == '/' && $file_contents[$i + 1] == '*') {
				$has_comments = true;
				$result_output .= $buffer;
				$buffer = '';
			}

			// Check for the end of a comment block
			if ($file_contents[$i] == '*' && $file_contents[$i + 1] == '/') {
				$has_comments = false;
				$result_output .= $buffer . '*/';
				$i += 2; // Skip the closing characters of the comment
				$buffer = '';
			}

			// If not in a comment block, process characters
			if (!$has_comments) {
				if ($file_contents[$i] == ',') {
					$result_output .= '#wp_whmcs_sync ' . $buffer . ',';
					$buffer = '';
				} elseif ($file_contents[$i] == '{') {
					$result_output .= '#wp_whmcs_sync ' . $buffer . '{';
					$buffer = '';
				} elseif ($file_contents[$i] == '}') {
					$result_output .= $buffer . '}';
					$buffer = '';
				} else {
					$buffer .= $file_contents[$i];
				}
			} else {
				$buffer .= $file_contents[$i];
			}
		}

		// Return the parsed CSS content
		return $result_output;
	}
}

