<?php

session_start();
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://designingmedia.com
 * @since      1.0.0
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Wp_Whmcs_Sync
 * @subpackage Wp_Whmcs_Sync/public
 * @author     Designingmedia
 */


trait Whmcs_Sync_Shortcode_Handler {

    /**
	 * Callback method for the WHMCS login-link shortcode
	 */
	public function whmcs_login_url_shortcode_callback($atts) {
        // Define default values for attributes
        $atts = shortcode_atts(
            array(
                'class'         => isset($atts['class']) ? $atts['class'] : 'whmcs-login-shortcode',
                'id'            => isset($atts['id']) ? $atts['id'] : 'whmcs-login-shortcode',
                'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-user"></i>',
                'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                'logged-in'     => isset($atts['logged-in']) ? __($atts['logged-in'] , 'wp-whmcs-sync') : __('Clientarea', 'wp-whmcs-sync'),
                'logged-out'    => isset($atts['logged-out']) ? __($atts['logged-out'] , 'wp-whmcs-sync') : __('Login', 'wp-whmcs-sync'),
            ),
            $atts,
            'whmcs-login-url'
        );

        //fontawesome icon location
        $pre_icon = '';
        $post_icon = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        }

        // Check if the user is logged in
        if (isset($_SESSION['whmcsUser'])) {
            if($_SESSION['whmcsUser'] === 'loggedin'){
                // User is logged in
                $url = '<a href="'.site_url( 'whmcs-sync/?ccce=clientarea' ).'" class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '"> '.$pre_icon.' ' . esc_html($atts['logged-in']) . ' '.$post_icon.' </a>';
            } else {
                // User is not logged in
                $url = '<a href="'.site_url( 'whmcs-sync/?ccce=clientarea' ).'" class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '"> '.$pre_icon.' ' . esc_html($atts['logged-out']) . ' '.$post_icon.' </a>';
            }
        } else {
            // User is not logged in
            $url = '<a href="'.site_url( 'whmcs-sync/?ccce=clientarea' ).'" class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '"> '.$pre_icon.' ' . esc_html($atts['logged-out']) . ' '.$post_icon.' </a>';
        }

        return $url;
	}

    /**
     * Callback method for the WHMCS cart redirect shortcode
     */
    public function whmcs_cart_redirect_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'         => isset($atts['class']) ? $atts['class'] : 'whmcs-cart-redirect',
                'id'            => isset($atts['id']) ? $atts['id'] : 'whmcs-cart-redirect',
                'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-shopping-cart"></i>',
                'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                'redirect-text' => isset($atts['redirect-text']) ? __($atts['redirect-text'], 'wp-whmcs-sync') : __('WHMCS Cart', 'wp-whmcs-sync'),
            ),
            $atts,
            'whmcs-cart-redirect'
        );

        //fontawesome icon location
        $pre_icon = '';
        $post_icon = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        }
    
        return '<a href="'.site_url( 'whmcs-sync/?ccce=cart&a=view' ).'" id="' . esc_attr($atts['id']) . '" class="' . esc_attr($atts['class']) . '"> '.$pre_icon.' ' . esc_html($atts['redirect-text']) . ' '.$post_icon.' </a>';
    }

    /**
     * Callback method for the WHMCS domain register form
     */
    public function whmcs_domain_register_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'input-class'   => isset($atts['input-class']) ? $atts['input-class'] : 'domain-name',
                'input-id'      => isset($atts['input-id']) ? $atts['input-id'] : 'whmcs-domain-name',
                'btn-class'     => isset($atts['btn-class']) ? $atts['btn-class'] : 'whmcs-btn',
                'btn-id'        => isset($atts['btn-id']) ? $atts['btn-id'] : 'domain-serach',
                'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-globe"></i>',
                'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                'btn-text'      => isset($atts['btn-text']) ? __($atts['btn-text'], 'wp-whmcs-sync') : __('Register Domain', 'wp-whmcs-sync'),
            ),
            $atts,
            'whmcs-domain-register'
        );

        $pre_icon = '';
        $post_icon = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        }

        $content = '
            '.$pre_icon.' <input class="' . esc_attr($atts['input-class']) . '" type="text" id="' . esc_attr($atts['input-id']) . '" name="domain" placeholder="'.__('yourdomain', 'wp-whmcs-sync').'"> '.$post_icon.'
            <input class="' . esc_attr($atts['btn-class']) . '" type="submit" id="' . esc_attr($atts['btn-id']) . '" value="' . esc_attr($atts['btn-text']) . '">
        ';

        return $content;
    }

     /**
     * Callback method for the WHMCS domain transfer form
     */
    public function whmcs_domain_transfer_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'input-class'   => isset($atts['input-class']) ? $atts['input-class'] : 'domain-name',
                'input-id'      => isset($atts['input-id']) ? $atts['input-id'] : 'whmcs-domain-name',
                'btn-class'     => isset($atts['btn-class']) ? $atts['btn-class'] : 'whmcs-transfer-btn',
                'btn-id'        => isset($atts['btn-id']) ? $atts['btn-id'] : 'domain-serach',
                'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-globe"></i>',
                'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                'btn-text'      => isset($atts['btn-text']) ? __($atts['btn-text'], 'wp-whmcs-sync') : __('Transfer Domain', 'wp-whmcs-sync'),
            ),
            $atts,
            'whmcs-domain-transfer'
        );

        $pre_icon = '';
        $post_icon = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        }

        $content = '
            '.$pre_icon.' <input class="' . esc_attr($atts['input-class']) . '" type="text" id="' . esc_attr($atts['input-id']) . '" name="domain" placeholder="'.__('yourdomain', 'wp-whmcs-sync').'"> '.$post_icon.'
            <input class="' . esc_attr($atts['btn-class']) . '" type="submit" id="' . esc_attr($atts['btn-id']) . '" value="' . esc_attr($atts['btn-text']) . '">
        ';

        return $content;
    }

    /**
     * Callback method for the WHMCS product url shortcode
     */
    public function whmcs_product_url_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'         => isset($atts['class']) ? $atts['class'] : 'whmcs-shortcode-product',
                'id'            => isset($atts['id']) ? $atts['id'] : 'whmcs-shortcode-product',
                'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-box"></i>',
                'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                'anchor-text'   => isset($atts['anchor-text']) ? __($atts['anchor-text'], 'wp-whmcs-sync') : __('View Product', 'wp-whmcs-sync'),
                'show'          => isset($atts['show']) ? $atts['show'] : 'product-url',
                'pid'           => isset($atts['pid']) ? $atts['pid'] : '',
            ),
            $atts,
            'whmcs-product-url'
        );

        //fontawesome icon location
        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
        }

        if(!empty($atts['pid'])){
            $content = '
                <a href="'.site_url( 'whmcs-sync/?ccce=cart&a=add&pid='.$atts['pid'].'' ).'" class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '" > '.$pre_icon.' ' . esc_attr($atts['anchor-text']) . ' '.$post_icon.' </a>
            ';
        } else if(empty($atts['pid'])){
            $content = '
                <a href="'.site_url( 'whmcs-sync/?ccce=cart&a=view' ).'" class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '" > '.$pre_icon.' ' . esc_attr($atts['anchor-text']) . ' '.$post_icon.' </a>
            ';
        }

        return $content;
    }

    /**
     * Callback method for the AJAX domain search form
     */
    public function whmcs_ajax_domain_search_shortcode_callback($atts){
        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
			//TLD Listing
			$body = [
				'action'       => 'GetTLDPricing',
				'username'     => $this->meta_data['whmcs-api-identifier'],
				'password'     => $this->meta_data['whmcs-api-secret'],
				'currencyid'   => '1',
				'responsetype' => 'json',
			];

            $domains_arr = '';
			$domains = $this->whmcs_api_calling($body);
			if ($domains && isset($domains['result'])) {
				if ($domains['result'] == 'success') {
					if (is_array($domains['pricing'])) {
						$domains_arr = $domains['pricing'];
					}
				}
			}

            $atts = shortcode_atts(
                array(
                    'class'         => isset($atts['class']) ? $atts['class'] : 'whmcs-ajax-search',
                    'id'            => isset($atts['id']) ? $atts['id'] : 'whmcs-ajax-search',
                    'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-box"></i>',
                    'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                    'btn-text'      => isset($atts['btn-text']) ? __($atts['btn-text'], 'wp-whmcs-sync') : __('Search Domain', 'wp-whmcs-sync'),
                    'ajax'          => isset($atts['ajax']) ? $atts['ajax'] : 'true',
                    'btn-class'     => isset($atts['btn-class']) ? $atts['btn-class'] : 'whmcs-ajax-btn',
                    'btn-id'        => isset($atts['btn-id']) ? $atts['btn-id'] : 'whmcs-ajax-btn',
                ),
                $atts,
                'whmcs-ajax-domain-searh'
            );
    
            //fontawesome icon location
            $pre_icon = '';
            $post_icon = '';
            $content = '';
            if($atts['icon-location'] === 'pre'){
                $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
            } else {
                $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
            }
    
            if($atts['ajax'] === 'true'){
                $content = '
                    '.$pre_icon.' <input class="' . esc_attr($atts['class']) . '" type="text" id="' . esc_attr($atts['id']) . '" name="ajax-domain-search" placeholder="'.__('yourdomain', 'wp-whmcs-sync').'">
                    <select name="whmcs-tlds" id="whmcs-tlds">
                    ';
                        if(!empty($domains_arr)){
                            foreach($domains_arr as $key => $domain){
                                $content .= '
                                    <option value="'.$key.'">.'.strtoupper($key).'</option>
                                ';
                            }
                        }
                    $content .= '</select> '.$post_icon.'
                    <input class="' . esc_attr($atts['btn-class']) . '" name="whmcs-ajax-search-shortcode" type="submit" id="' . esc_attr($atts['btn-id']) . '" value="' . esc_attr($atts['btn-text']) . '">
                    <div class="loading-icon" style="display: none;">
                        <i class="fas fa-spinner fa-spin"></i>
                        Loading...
                    </div>
                    <div class="whmcs-ajax-search-results">
    
                    </div>
                ';
    
            }
		} else {
            $content = __('API Credentials are missing', 'wp-whmcs-sync');
        }

        return $content;
    }

    /**
     * Callback method to load all service listing of WHMCS
     */
    public function whmcs_service_listing_shortcode_callback($atts){
        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            $body = [
                'action'       => 'GetProducts',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];
    
            $products_arr = false;
            $products = $this->whmcs_api_calling($body);

            $atts = shortcode_atts(
                array(
                    'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-service-listing',
                    'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-service-listing',
                    'btn-id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-order-service-listing',
                    'icon-class'    => isset($atts['icon-class']) ? $atts['icon-class'] : '<i class="fas fa-globe"></i>',
                    'icon-location' => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
                    'anchor-text'    => isset($atts['anchor-text']) ? __($atts['anchor-text'], 'wp-whmcs-sync') : __('Order Now', 'wp-whmcs-sync'),
                ),
                $atts,
                'whmcs-service-listing'
            );

            //fontawesome icon location
            $pre_icon = '';
            $post_icon = '';
            $content = '';
            if($atts['icon-location'] === 'pre'){
                $pre_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
            } else {
                $post_icon = '<i class="'.esc_html($atts['icon-class']).'"></i>';
            }
    
            $content = '
                <div class="' . esc_attr($atts['class']) . ' whmcs-products chosse-plan-con">
                    <div class="domain-generic-title">
                        <h3> '.__('WHMCS Products', 'wp-whmcs-sync').' </h3>
                    </div>
                    <div class="whmcs-product-name">
                        <select class="whmcs-service-listing-select">';
                            foreach($products['products']['product'] as $product){
                                // Parse the URL
                                // $parsed_url = parse_url($product['product_url']);

                                // // Remove "index.php" from the path
                                // if (isset($parsed_url['path'])) {
                                //     $path_without_index = str_replace('index.php', '', $parsed_url['path']);
                                // } else {
                                //     $path_without_index = '';
                                // }

                                // // Build the new URL without the domain
                                // $new_url = $path_without_index;
                                // if (isset($parsed_url['query'])) {
                                //     $new_url .= '?ccce=index/' . $parsed_url['query'];
                                // }

                                // Your modification code
                                // $parsed_url = parse_url($product['product_url']);

                                // // Your modification code
                                // $parsed_url = parse_url($product['product_url']);

                                // // Update the path and query parameters
                                // if (isset($parsed_url['path'])) {
                                //     $parsed_url['path'] = '/whmcs-sync/';
                                // }

                                // if (isset($parsed_url['query'])) {
                                //     // Replace the first '/' with '&' and encode the parameters
                                //     $query_params = preg_replace('/\//', '&', $parsed_url['query'], 1);
                                //     $parsed_url['query'] = 'ccce=index&' . $query_params;
                                // }

                                // // Rebuild the modified URL
                                // $new_product_url = $parsed_url['path'] . '?' . $parsed_url['query'];

                            
                                $content .= '<option data-p-url="'.$product['product_url'].'" data-slug="'.$product['slug'].'">'.__($product['name'], 'wp-whmcs-sync').'</option>';
                            }
                        $content .= '</select>
                    </div>
                    <div class="service-loading-icon" style="display: none;">
                        <i class="fas fa-spinner fa-spin"></i>
                        Loading...
                    </div>
                    <div class="billing-title">
                        <h4>'.__('Product Information', 'wp-whmcs-sync').'</h4>
                        <div class="container mt-4">
                            <div class="alert alert-info billing-products" role="alert">';
                                foreach($products['products']['product'] as $product){
                                    if($product['name'] === 'Basic Shared'){
                                        $content .= '<div class="whmcs-product-desc">';
                                            $content .= __($product['description'], 'wp-whmcs-sync');
                                        $content .= '</div>';
                                    }
                                }
                            $content .= '</div>
                        </div>
                        <h4>'.__('Choose Billing Cycle', 'wp-whmcs-sync').'</h4>
                        <div class="billing-radio">
                            <select class="whmcs-billing-cycles">';
                                $desired_keys = ['monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially'];
                                $count = 1;
                                foreach($products['products']['product'] as $product){
                                    if($product['name'] === 'Basic Shared'){
                                        foreach($product['pricing']['USD'] as $key => $billing){
                                            if(in_array($key, $desired_keys)){
                                                $content .= '
                                                    <option><strong> '.__(ucfirst($key), 'wp-whmcs-sync').'</strong>  <small>$'.__($billing, 'wp-whmcs-sync').' </option>
                                                ';
                                                $count++;
                                            }
                                        }
                                    }
                                }
                            $content .= '</select><br><br>
                        </div>
                    </div>
                    <a href="#" id="' . esc_attr($atts['btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['anchor-text']) . ' '.$post_icon.' </a>
                </div>
            ';

        } else {
            $content = __('API Credentials are missing', 'wp-whmcs-sync');
        }

        return $content;
    }

    /**
     * Callback method for the WHMCS support ticket
     */
    public function whmcs_support_ticket_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-support-ticket',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-support-ticket',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-login-support-ticket',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : 'Login to submit ticket',
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'ticket-icon-class' => isset($atts['ticket-icon-class']) ? $atts['ticket-icon-class'] : 'fas fa-ticket-alt',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'open-ticket'
        );

        $pre_icon = '';
        $post_icon = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        $content = '
            <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                if(!isset($_SESSION['whmcs_client_id']) && !isset($_SESSION['dept-list'])){
                    if(empty($_SESSION['whmcs_client_id']) && empty($_SESSION['dept-list'])){
                        $content .= '<div class="whmcs-login">
                            <div class="whmcs-email">
                                <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                                <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                            </div>
                            <div class="whmcs-password">
                                <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                                <input type="password" class="whmcs-login-password" />
                            </div>
                            <div class="whmcs-login-btn">
                                <a href="#" class="whmcs-login-support-ticket" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                            </div>

                            <div class="loading-icon" style="display: none;">
                                <i class="fas fa-spinner fa-spin"></i>
                                Loading...
                            </div>

                            
                        </div>
                        <div class="whmcs-support-ticket-wrapper">

                        </div>';
                    }
                }
                if(isset($_SESSION['whmcs_client_id']) && isset($_SESSION['dept-list'])){
                    if(!empty($_SESSION['whmcs_client_id']) && !empty($_SESSION['dept-list'])){
                        $content .= '<div class="whmcs-support-ticket-wrapper">
                            <form action="" method="post" enctype="multipart/form-data">
                                <label for="department">'.__('Department:', 'wp-whmcs-sync').'</label>
                                <select id="department" name="department" required>';
                                    foreach($_SESSION['dept-list']['department'] as $dept){
                                        $content .= '<option value="'.$dept['id'].'">'.$dept['name'].'</option>';
                                    }
                                $content .= '</select>
                                <br>
                            
                                <label for="subject">'.__('Subject:', 'wp-whmcs-sync').'</label>
                                <input type="text" id="subject" name="subject" required>
                                <br>
                            
                                <label for="message">'.__('Message:', 'wp-whmcs-sync').'</label>
                                <textarea id="message" name="message" rows="4" required></textarea>
                                <br>
                            
                                <label for="priority">'.__('Priority:', 'wp-whmcs-sync').'</label>
                                <select id="priority" name="priority" required>
                                    <option value="high">'.__('High', 'wp-whmcs-sync').'</option>
                                    <option value="medium">'.__('Medium', 'wp-whmcs-sync').'</option>
                                    <option value="low">'.__('Low', 'wp-whmcs-sync').'</option>
                                </select>
                                <br>
                            
                                <input type="submit" name="whmcs-open-ticket" class="whmcs-open-ticket" value="'.__('Submit', 'wp-whmcs-sync').'">
                                <div class="loading-icon" style="display: none;">
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Loading...
                                </div>
                            </form>
                        </div>';
                    }
                }
                
            $content .= '</div>
        ';

        return $content;
    }

    /**
     * Callback method to get WHMCS tickets
     */
    public function whmcs_get_tickets_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-tickets',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-tickets',
            ),
            $atts,
            'get-tickets'
        );

        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            //validate whmcs login details
            $body = [
                'action'       => 'GetTickets',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];

            $whmcs_tickets = $this->whmcs_api_calling($body);
            $content = '';
            if($whmcs_tickets && isset($whmcs_tickets['result'])){
                if($whmcs_tickets['result'] === 'success'){
                    $content .= '<div id="'.esc_html($atts['class']).'" class="'.esc_html($atts['class']).'">
                        <div class="whmcs-shortcode-title">
                            <h5> '.__('WHMCS Tickets', 'wp-whmcs-sync').' <h5>
                        </div>
                        <table id="whmcs-tickets-tbl" class="whmcs-tk-tbl">
                        <thead>
                            <tr>
                                <th>'.__('Department', 'wp-whmcs-sync').'</th>
                                <th>'.__('Name', 'wp-whmcs-sync').'</th>
                                <th>'.__('Email', 'wp-whmcs-sync').'</th>
                                <th>'.__('Subject', 'wp-whmcs-sync').'</th>
                                <th>'.__('Priority', 'wp-whmcs-sync').'</th>
                            </tr>
                        </thead>
                        <tbody>';
                        foreach($whmcs_tickets['tickets'] as $tickets){
                            foreach($tickets as $ticket){
                                if(!empty($ticket['email'])){
                                    $content .= '
                                        <tr>
                                            <td>'.$ticket['deptname'].'</td>
                                            <td>'.$ticket['name'].'</td>
                                            <td>'.$ticket['email'].'</td>
                                            <td>'.$ticket['subject'].'</td>
                                            <td>'.$ticket['priority'].'</td>
                                        </tr>
                                    ';
                                }
                            }
                        }
                    $content .= '</tbody></table></div>';
                }
            }

            return $content;
            
        }
    }

    /**
     * Callback method for the WHMCS clientarea shortcode
     */
    public function whmcs_clientarea_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-clientarea',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-clientarea',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-clientarea-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : 'Login',
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-clientarea'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_user_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-validate-login" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-clientarea-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_user_id']) && isset($_SESSION['client_info'])) {
            $content = '
                <div class="whmcs-clientarea-wrapper">
                    <div class="clientarea-inner">
                        <table id="clientarea-usr-info" class="tbl whmcs-tbl">
                            <thead>
                                <tr>
                                    <th>'.__('Full Name', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Company', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Address', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Country', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Email', 'wp-whmcs-sync').'</th>
                                    <th>'.__('State', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Phone Number', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Post Code', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Status', 'wp-whmcs-sync').'</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>'.$_SESSION['client_info']['fullname'].'</td>
                                    <td>'.$_SESSION['client_info']['companyname'].'</td>
                                    <td>'.$_SESSION['client_info']['address1'].'</td>
                                    <td>'.$_SESSION['client_info']['countryname'].'</td>
                                    <td>'.$_SESSION['client_info']['email'].'</td>
                                    <td>'.$_SESSION['client_info']['state'].'</td>
                                    <td>'.$_SESSION['client_info']['telephoneNumber'].'</td>
                                    <td>'.$_SESSION['client_info']['postcode'].'</td>
                                    <td>'.$_SESSION['client_info']['status'].'</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            ';
        }

        return $content;
    }

    /**
     * Callback method for the whmsc user invoice lisitngs
     */
    public function whmcs_invoices_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-invoices',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-invoices',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-invoice-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : 'Login',
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-invoice-listing'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_user_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-invoice-login" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-invoices-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_user_id'])) {
            if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                //get all information of the logged in user
                $body = [
                    'action'       => 'GetInvoices',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'userid'       => $_SESSION['whmcs_user_id'],
                    // 'userid'       => 3746,
                    'responsetype' => 'json',
                ];

                $invoices_data = $this->whmcs_api_calling($body);
                if($invoices_data && isset($invoices_data['result'])){
                    if($invoices_data['result'] === 'success' && $invoices_data['totalresults'] > 0){
                        $content = '
                            <div class="whmcs-invoices-wrapper">
                                <div class="invoices-inner">
                                    <div class="whmcs-client-invoices-info">
                                        <table id="usr-invoices" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>'.__('Invoice#', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('First Name', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Last Name', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Date', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Due Date', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Payment method', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Status', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Total', 'wp-whmcs-sync').'</th>
                                                </tr>
                                            </thead>
                                            <tbody>';
                                                foreach ($invoices_data['invoices']['invoice'] as $key => $invoice) {
                                                    $content .= '
                                                        <tr>
                                                            <td>'.$invoice['id'].'</td>
                                                            <td>'.$invoice['firstname'].'</td>
                                                            <td>'.$invoice['lastname'].'</td>
                                                            <td>'.$invoice['date'].'</td>
                                                            <td>'.$invoice['duedate'].'</td>
                                                            <td>'.$invoice['paymentmethod'].'</td>
                                                            <td>'.$invoice['status'].'</td>
                                                            <td>'.$invoice['total'].'</td>
                                                        </tr>
                                                    ';
                                                }
                                            $content .= '</tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        ';
                    }
                }
            }
        }

        return $content;
    }

    /**
     * Callback method to display user's credit balance information
     */
    public function whmcs_credit_balance_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-credit-balance',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-credit-balance',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-credit-balance-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : __('Login', 'wp-whmcs-sync'),
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-credit-balance'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_user_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-credit-balance-login" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-credit-balance-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_user_id'])) {
            if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                //get all information of the logged in user
                $body = [
                    'action'       => 'GetCredits',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'clientid'       => $_SESSION['whmcs_user_id'],
                    // 'clientid'       => 3746,
                    'responsetype' => 'json',
                ];

                $credit_balance = $this->whmcs_api_calling($body);
                if($credit_balance && isset($credit_balance['result'])){
                    if($credit_balance['result'] === 'success' && $credit_balance['totalresults'] > 0){
                        $content = '
                            <div class="whmcs-credit-balance-wrapper">
                                <div class="credit-balance-inner">
                                    <div class="whmcs-client-credit-balance-info">
                                        <table id="usr-credit-balance" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>'.__('Credit ID', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Date', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Description', 'wp-whmcs-sync').'</th>
                                                    <th>'.__('Amount', 'wp-whmcs-sync').'</th>
                                                </tr>
                                            </thead>
                                            <tbody>';
                                                foreach ($credit_balance['credits']['credit'] as $key => $credit) {
                                                    $content .= '
                                                        <tr>
                                                            <td>'.$credit['id'].'</td>
                                                            <td>'.$credit['date'].'</td>
                                                            <td>'.$credit['description'].'</td>
                                                            <td>'.$credit['amount'].'</td>
                                                        </tr>
                                                    ';
                                                }
                                            $content .= '</tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        ';
                    }
                }
            }
        }

        return $content;
    }

    /**
     * Callback method for the whmcs announcements
     */
    public function whmcs_accouncements_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-announcements',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-announcements',
            ),
            $atts,
            'whmcs-announcements'
        );

        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            //get all information of the logged in user
            $body = [
                'action'       => 'GetAnnouncements',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];

            $announcements = $this->whmcs_api_calling($body);
            if($announcements && isset($announcements['result'])){
                if($announcements['result'] === 'success' && $announcements['totalresults'] > 0){
                    $content = '
                        <div class="whmcs-announcements-wrapper">
                            <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                                foreach ($announcements['announcements']['announcement'] as $key => $announcement) {
                                    if($announcement['published'] == true){
                                        $content .= '
                                            <div class="announcement-inner">
                                                <div class="announcement-date">
                                                    '.__('Date: '.$announcement['date'], 'wp-whmcs-sync').'
                                                </div>
                                                <div class="announcement-title">
                                                    '.__('Title: '.$announcement['title'], 'wp-whmcs-sync').'
                                                </div>
                                                <div class="announcement-desc">
                                                    '.__('Description: '.$announcement['announcement'], 'wp-whmcs-sync').'
                                                </div>
                                            </div>
                                        ';
                                    }
                                }
                            $content .='</div>
                        </div>
                    ';
                    return $content;
                }
            }
        }
    }

    /**
     * Callback method to preview affiliate programs
     */
    public function whmcs_affiliate_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-affiliate',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-affiliate',
            ),
            $atts,
            'whmcs-affiliate'
        );

        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            //get all information of the logged in user
            $body = [
                'action'       => 'GetAffiliates',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];

            $affiliates = $this->whmcs_api_calling($body);
            if($affiliates && isset($affiliates['result'])){
                if($affiliates['result'] === 'success' && $affiliates['totalresults'] > 0){
                    $content = '
                        <div class="whmcs-affiliates-wrapper">
                            <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">

                                <table id="usr-invoices" class="tbl whmcs-tbl">
                                    <thead>
                                        <tr>
                                            <th>'.__('Affiliate#', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Date', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Client ID', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Visitors', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Paytype', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Payamount', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Balance', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Withdrawn', 'wp-whmcs-sync').'</th>
                                        </tr>
                                    </thead>
                                    <tbody>';
                                        foreach ($affiliates['affiliates']['affiliate'] as $key => $affiliate) {
                                            $content .= '
                                                <tr>
                                                    <td>'.$affiliate['id'].'</td>
                                                    <td>'.$affiliate['date'].'</td>
                                                    <td>'.$affiliate['clientid'].'</td>
                                                    <td>'.$affiliate['visitors'].'</td>
                                                    <td>'.$affiliate['paytype'].'</td>
                                                    <td>'.$affiliate['payamount'].'</td>
                                                    <td>'.$affiliate['balance'].'</td>
                                                    <td>'.$affiliate['withdrawn'].'</td>
                                                </tr>
                                            ';
                                        }
                                    $content .= '</tbody>
                                </table>
                            </div>
                        </div>
                    ';
                    return $content;
                }
            }
        }
    }

    /**
     * Callback method to present dynamic pricing table
     */
    public function whmcs_dynamic_pricing_table_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-dynamic-pricing-table',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-dynamic-pricing-table',
            ),
            $atts,
            'whmcs-dynamic-pricing-table'
        );

        global $wp;
        $current_url = home_url( add_query_arg( array(), $wp->request ) );
        $whmcs_sync_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';

        if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            //get all information of the logged in user
            $body = [
                'action'       => 'GetProducts',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];

            $content = '';
            $products = $this->whmcs_api_calling($body);
            if($products && isset($products['result'])){
                if($products['result'] === 'success' && $products['totalresults'] > 0){
                    $content .= '
                        <div class="dynamic-pricing-table-wrapper">
                            <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">
                                <ul class="nav nav-tabs" role="tablist">';

                                    // Initialize an empty array to keep track of displayed strings
                                    $displayed_strings = [];

                                    foreach ($products['products']['product'] as $key => $product) {
                                        // Split the URL by "store/" and get the second part
                                        $parts = explode('store/', $product['product_url']);
                                        $sub_string = isset($parts[1]) ? $parts[1] : '';

                                        // Get the part before the next slash
                                        $sub_string = explode('/', $sub_string)[0];

                                        // Remove dashes and capitalize each word
                                        $sub_string = ucwords(str_replace('-', ' ', $sub_string));

                                        // Check if the string has not been displayed before
                                        if (!in_array($sub_string, $displayed_strings)) {
                                            // Add the string to the list of displayed strings
                                            $displayed_strings[] = $sub_string;

                                            // Construct the HTML for each string
                                            $content .= '
                                                <li class="nav-item">
                                                    <a class="nav-link" href="'.$current_url.'/?target='.strtolower(str_replace(' ', '-', $sub_string)).''.'" data-target="' . strtolower(str_replace(' ', '-', $sub_string)) . '">' . $sub_string . '</a>
                                                </li>';
                                        }
                                    }

                    $content .= '
                                </ul>
                            </div>
                        </div>';

                    // Initialize an empty array to store related packages
                    $related_packages = [];

                    // Loop through each product to find related packages for "Shared Hosting"
                    foreach ($products['products']['product'] as $product) {
                        // Get the slug from the product URL
                        $parts = explode('store/', $product['product_url']);
                        $slug = isset($parts[1]) ? $parts[1] : '';

                        // Extract the category part from the slug
                        $category = explode('/', $slug)[0];

                        // Check if the target parameter matches the category
                        if (isset($_GET['target']) && strtolower($_GET['target']) === strtolower($category)) {
                            // Add the product to the list of related packages
                            $related_packages[] = $product;
                        }
                    }

                    // Output related packages and pricing in one row
                    if (!empty($related_packages)) {
                        $content .= '<div class="row">';
                        foreach ($related_packages as $package) {
                            $content .= '<div class="col-md-4">';
                            $content .= '<div class="package">';
                            $content .= '<h3>' . $package['name'] . '</h3>';
                            $content .= '<p>' . $package['description'] . '</p>';
                            
                            // Check if pricing information for USD is available
                            if (isset($package['pricing']['USD'])) {
                                $usd_pricing = $package['pricing']['USD'];

                                // Output pricing details as dropdown menu for USD
                                $content .= '<select class="pricing-dropdown">';
                                foreach ($usd_pricing as $key => $value) {
                                    // Exclude non-monthly fees and suffix, and values equal to 0
                                    if ($key !== 'prefix' && $key !== 'suffix' && $key !== 'monthly' && $value > 0) {
                                        // Format the option value
                                        $option_value = number_format($value, 2);

                                        // Create the option label
                                        $option_label = ucfirst($key) . ': ' . $usd_pricing['prefix'] . $option_value . $usd_pricing['suffix'] . ' per ' . ucfirst($key);

                                        // Add the option to the dropdown
                                        $content .= '<option value="' . $option_value . '">' . $option_label . '</option>';
                                    }
                                }
                                $content .= '</select>';
                            } else {
                                $content .= '<p>No pricing information available for USD.</p>';
                            }

                            // Add "Order Now" button below the pricing dropdown
                            $content .= '<a href="'.site_url(''.$whmcs_sync_slug.'/store/'.explode('store/', $package['product_url'])[1].'').'" target="_blank" class="whmsc-order-now"> Order Now </a>';

                            $content .= '</div>'; // End of package div
                            $content .= '</div>'; // End of column div
                        }
                        $content .= '</div>'; // End of row div
                    } else {
                        // No related packages found
                        $content .= '<p>No related packages found.</p>';
                    }

                    return $content;

                }
            }
        }
    }

    /**
     * Callback method to show usage statistics to the user
     */
    public function whmcs_api_management_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-usage-statistics',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-usage-statistics',
            ),
            $atts,
            'whmcs-usage-statistics'
        );

        $saved_api_credentials = get_option( '_api_key_management' );
        $api_value = isset($saved_api_credentials['whmcs-api-url']) ? $saved_api_credentials['whmcs-api-url'] : '';
        $api_identifier = isset($saved_api_credentials['whmcs-api-identifier']) ? $saved_api_credentials['whmcs-api-identifier'] : '';
        $api_secret = isset($saved_api_credentials['whmcs-api-secret']) ? $saved_api_credentials['whmcs-api-secret'] : '';
        // if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
            
            $content = '
                <form method="post">
                    <div class="form-group">
                        <label for="whmcs-api-url">'.__('WHMCS API URL:', 'wp-whmcs-sync').'</label>
                        <input type="text" name="whmcs-api-url" required class="form-control" value="'.$api_value.'" id="whmcs-api-url" placeholder="https://akdesigner.com/whmcs-templates/includes/api.php">
                    </div>
                    <div class="form-row">
                        <div class="col">
                            <label for="whmsc-api-identifier">'.__('WHMCS API Identifier:', 'wp-whmcs-sync').'</label>
                            <input type="text" required name="whmcs-api-identifier" value="'.$api_identifier.'" class="form-control" placeholder="D4j1dKYE3g40VROOPCGyJ9zRwP0ADJIv">
                        </div>
                        <div class="col">
                            <label for="whmcs-api-secret">'.__('WHMCS API Secret:', 'wp-whmcs-sync').'</label>
                            <input type="text" required name="whmcs-api-secret" value="'.$api_secret.'" class="form-control" placeholder="F1CKGXRIpylMfsrig3mwwdSdYUdLiFlo">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">'.__('Save', 'wp-whmcs-sync').'</button>
                </form>
            ';

            return $content;
            
        // }
    }

    /**
     * Callback method for the WHMCS multi language support
     */
    public function whmcs_multi_language_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-multi-language',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-multi-language',
            ),
            $atts,
            'whmcs-multi-language'
        );

        $sync_page_slug = get_option( '_whmcs_sync_page_id' ) ? get_post_field('post_name', get_option( '_whmcs_sync_page_id' )) : '';
        if(!empty($sync_page_slug)){
            $site_url = site_url($sync_page_slug);
            $whmcs_template = $this->meta_data['whmcs-template'];

            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">
                    <button id="languagePopupBtn">'.__('Select Language', 'wp-whmcs-sync').'</button>
                    <div id="languagePopup" class="popup">
                        <button id="closePopup">'.__('Close', 'wp-whmcs-sync').'</button>
                        <div class="popover-content">
                            <ul>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=arabic">العربية</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=azerbaijani">Azerbaijani</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=catalan">Català</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=chinese">中文</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=croatian">Hrvatski</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=czech">Čeština</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=danish">Dansk</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=dutch">Nederlands</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=english">English</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=estonian">Estonian</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=farsi">Persian</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=french">Français</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=german">Deutsch</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=hebrew">עברית</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=hungarian">Magyar</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=italian">Italiano</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=macedonian">Macedonian</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=norwegian">Norwegian</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=portuguese-br">Português</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=portuguese-pt">Português</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=romanian">Română</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=russian">Русский</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=spanish">Español</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=swedish">Svenska</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=turkish">Türkçe</a>
                                </li>
                                <li>
                                    <a href="'.$site_url.'/?systpl='.$whmcs_template.'&language=ukranian">Українська</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            ';
        }
        return $content;
    }

    /**
     * Callback method to preview usage statistics
     */
    public function whmcs_usage_statistics_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-usage-statistics',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-usage-statistics',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-usage-statistics-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : __('Login', 'wp-whmcs-sync'),
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-usage-statistics'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_client_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-usage-statistics-login" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-usage-statistics-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_client_id'])) {
            if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                $content = '
                    <div class="whmcs-usage-statistics-wrapper">
                        <div class="usage-statistics-inner">
                            <div class="whmcs-client-info">
                                <h3> '.__('Domains:', 'wp-whmcs-sync').' </h3>
                                <table id="usage-statistics" class="tbl whmcs-tbl">
                                    <thead>
                                        <tr>
                                            <th>'.__('Order#', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Registration Type', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Domain Name', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Period', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Amount', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Payment Method', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Next due date', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Status', 'wp-whmcs-sync').'</th>
                                        </tr>
                                    </thead>
                                    <tbody>';
                                        foreach ($_SESSION['usage-statistics']['domains'] as $key => $domain) {
                                            $content .= '
                                                <tr>
                                                    <td>'.$domain['orderid'].'</td>
                                                    <td>'.$domain['regtype'].'</td>
                                                    <td>'.$domain['domainname'].'</td>
                                                    <td>'.$domain['regperiod'].'</td>
                                                    <td>'.$domain['firstpaymentamount'].'</td>
                                                    <td>'.$domain['paymentmethodname'].'</td>
                                                    <td>'.$domain['nextduedate'].'</td>
                                                    <td>'.$domain['status'].'</td>
                                                </tr>
                                            ';
                                        }
                                    $content .= '</tbody>
                                </table>
                            </div>
                            
                            <div class="whmcs-client-products">
                                <h3> '.__('Products:', 'wp-whmcs-sync').' </h3>
                                <table id="usage-statistics-products" class="tbl whmcs-tbl">
                                    <thead>
                                        <tr>
                                            <th>'.__('Order#', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Billing Cycle', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Domain Name', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Amount', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Group Name', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Product Name', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Payment Method', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Status', 'wp-whmcs-sync').'</th>
                                            <th>'.__('Date', 'wp-whmcs-sync').'</th>
                                        </tr>
                                    </thead>
                                    <tbody>';

                                        foreach ($_SESSION['usage-statistics']['products'] as $key => $product) {
                                            $content .= '
                                                <tr>
                                                    <td>'.$product['orderid'].'</td>
                                                    <td>'.$product['billingcycle'].'</td>
                                                    <td>'.$product['domain'].'</td>
                                                    <td>'.$product['firstpaymentamount'].'</td>
                                                    <td>'.$product['groupname'].'</td>
                                                    <td>'.$product['name'].'</td>
                                                    <td>'.$product['paymentmethodname'].'</td>
                                                    <td>'.$product['status'].'</td>
                                                    <td>'.$product['regdate'].'</td>
                                                </tr>
                                            ';
                                        }
                                    $content .= '</tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                ';
            }
        }

        return $content;
    }

    /**
     * Callback method to generate service renewal reminders
     */
    public function whmcs_service_renewal_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-service-renewal-reminders',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-service-renewal-reminders',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-service-renewal-reminders-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : __('Login', 'wp-whmcs-sync'),
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-service-renewal-reminders'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_client_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-service-renewal-reminders-login" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-service-renewal-reminders-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_client_id'])) {
            if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                $content = '
                    <div class="whmcs-service-renewal-reminders-wrapper">
                        <div class="service-renewal-inner">
                            
                        </div>
                    </div>
                ';
            }
        }

        return $content;
    }

    /**
     * Callback method to generate WHMCS dashboard widgets
     */
    public function whmcs_custom_dashboard_widgets_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class'             => isset($atts['class']) ? $atts['class'] : 'whmcs-custom-dashboard-widgets',
                'id'                => isset($atts['id']) ? $atts['id'] : 'whmcs-custom-dashboard-widgets',
                'login-btn-id'      => isset($atts['login-btn-id']) ? $atts['login-btn-id'] : 'whmcs-custom-dashboard-widgets-login',
                'login-anchor-text' => isset($atts['login-anchor-text']) ? $atts['login-anchor-text'] : 'Login',
                'login-icon-class'  => isset($atts['login-icon-class']) ? $atts['login-icon-class'] : 'fas fa-user',
                'icon-location'     => isset($atts['icon-location']) ? $atts['icon-location'] : 'pre',
            ),
            $atts,
            'whmcs-custom-dashboard-widgets'
        );

        $pre_icon = '';
        $post_icon = '';
        $content = '';
        if($atts['icon-location'] === 'pre'){
            $pre_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        } else {
            $post_icon = '<i class="'.esc_html($atts['login-icon-class']).'"></i>';
        }

        if(!isset($_SESSION['whmcs_user_id'])){
            $content = '
                <div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                    $content .= '<div class="whmcs-login">
                        <div class="whmcs-email">
                            <label for="whmcs-login-email"> '.__('Enter your email:', 'wp-whmcs-sync').' </label>
                            <input type="email" class="whmcs-login-email" placeholder="info@domain.com" />
                        </div>
                        <div class="whmcs-password">
                            <label for="whmcs-login-password"> '.__('Enter your password:', 'wp-whmcs-sync').' </label>
                            <input type="password" class="whmcs-login-password" />
                        </div>
                        <div class="whmcs-login-btn">
                            <a href="#" class="whmcs-custom-dashboard" id="' . esc_attr($atts['login-btn-id']) . '" > '.$pre_icon.' ' . esc_attr($atts['login-anchor-text']) . ' '.$post_icon.' </a>
                        </div>

                        <div class="loading-icon" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                            Loading...
                        </div>
                        
                    </div>
                    <div class="whmcs-clientarea-wrapper">

                    </div>';
                    
                $content .= '</div>
            ';
        } else if(isset($_SESSION['whmcs_user_id']) && isset($_SESSION['client_info'])) {
            $content = '
                <div class="whmcs-clientarea-wrapper">
                    <div class="clientarea-inner">
                        <table id="clientarea-usr-info" class="tbl whmcs-tbl">
                            <thead>
                                <tr>
                                    <th>'.__('Full Name', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Company', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Address', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Country', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Email', 'wp-whmcs-sync').'</th>
                                    <th>'.__('State', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Phone Number', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Post Code', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Status', 'wp-whmcs-sync').'</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>'.$_SESSION['client_info']['fullname'].'</td>
                                    <td>'.$_SESSION['client_info']['companyname'].'</td>
                                    <td>'.$_SESSION['client_info']['address1'].'</td>
                                    <td>'.$_SESSION['client_info']['countryname'].'</td>
                                    <td>'.$_SESSION['client_info']['email'].'</td>
                                    <td>'.$_SESSION['client_info']['state'].'</td>
                                    <td>'.$_SESSION['client_info']['telephoneNumber'].'</td>
                                    <td>'.$_SESSION['client_info']['postcode'].'</td>
                                    <td>'.$_SESSION['client_info']['status'].'</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            ';
        }

        return $content;
    }

    /**
     * Callback method to get whmcs payment methods
     */
    public function whmcs_get_payment_methods_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-get-payment-methods',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-get-payment-methods',
            ),
            $atts,
            'whmcs-get-payment-methods'
        );
        
        if (!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])) {
            $body = [
                'action'       => 'GetPaymentMethods',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];
        
            $content = '<div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
            $content .= '<h2> '.__('Available Payment Methods', 'wp-whmcs-sync').' </h2>';
            $payment_methods = $this->whmcs_api_calling($body);
        
            if ($payment_methods && $payment_methods['result'] === 'success') {
                if (is_array($payment_methods['paymentmethods']) && is_array($payment_methods['paymentmethods']['paymentmethod'])) {
                    $content .= '<div class="payment-methods">';
                    foreach ($payment_methods['paymentmethods']['paymentmethod'] as $method) {
                        $content .= '<div class="payment-method">
                                        <h3>' . esc_html($method['displayname']) . '</h3>
                                        <p>' . esc_html($method['module']) . '</p>
                                     </div>';
                    }
                    $content .= '</div>';
                } else {
                    $content .= '<p> ' . __('No payment methods available', 'wp-whmcs-sync') . ' </p>';
                }
            } else {
                $content .= '<p> ' . __('Something Went Wrong', 'wp-whmcs-sync') . ' </p>';
            }
        
            $content .= '</div>';
        
            return $content;
        }
    }

    /**
     * Callback method to get quotes
     */
    public function whmcs_get_quotes_shortcode_callback($atts){
        $atts = shortcode_atts(
            array(
                'class' => isset($atts['class']) ? $atts['class'] : 'whmcs-get-quotes',
                'id'    => isset($atts['id']) ? $atts['id'] : 'whmcs-get-quotes',
            ),
            $atts,
            'whmcs-get-quotes'
        );
        
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
        $current_url = $protocol . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        if (!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])) {
            $body = [
                'action'       => 'GetQuotes',
                'username'     => $this->meta_data['whmcs-api-identifier'],
                'password'     => $this->meta_data['whmcs-api-secret'],
                'responsetype' => 'json',
            ];

            $quotes = $this->whmcs_api_calling($body);
        
            $content = '<div class="' . esc_attr($atts['class']) . '" id="' . esc_attr($atts['id']) . '">';
                $content .= '<h2> '.__('Available Quotes', 'wp-whmcs-sync').' </h2>';
                $content .= '
                    <input type="button" name="create-quote" class="create-quote" value="'.__('Create Quote', 'wp-whmcs-sync').'" />
                    <div class="create-quote-wrapper">
                        '.$this->whmcs_create_quote_form($quotes).'
                    </div>
                ';

                if ($quotes && $quotes['result'] === 'success') {
                    if (isset($quotes['quotes']['quote']) && is_array($quotes['quotes']['quote'])):
                        $content .= '<table id="whmcs-get-quotes-table">
                            <thead>
                                <tr>
                                    <th>'.__('Quote ID', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Subject', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Stage', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Valid Until', 'wp-whmcs-sync').'</th>
                                    <th>'.__('User ID', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Client Name', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Email', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Subtotal', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Tax 1', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Tax 2', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Total', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Proposal', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Customer Notes', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Date Created', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Last Modified', 'wp-whmcs-sync').'</th>
                                    <th>'.__('Actions', 'wp-whmcs-sync').'</th>
                                </tr>
                            </thead>
                            <tbody>';
                                foreach ($quotes['quotes']['quote'] as $quote):
                                    $content .= '<tr>
                                        <td>'.$quote['id'].'</td>
                                        <td>'.$quote['subject'].'</td>
                                        <td>'.$quote['stage'].'</td>
                                        <td>'.$quote['validuntil'].'</td>
                                        <td>'.$quote['userid'].'</td>';
                                        if(isset($quote['client'])){
                                            $content .= '
                                                <td>'.$quote['client']['firstname'] . ' ' . $quote['client']['lastname'].'</td>
                                                <td>'.$quote['client']['email'].'</td>
                                            ';
                                        } else {
                                            $content .= '
                                                <td>'.$quote['firstname'] . ' ' . $quote['lastname'].'</td>
                                                <td>'.$quote['email'].'</td>
                                            ';
                                        }
                                        
                                        $content .= '<td>'.$quote['subtotal'].'</td>
                                        <td>'.$quote['tax1'].'</td>
                                        <td>'.$quote['tax2'].'</td>
                                        <td>'.$quote['total'].'</td>
                                        <td>'.$quote['proposal'].'</td>
                                        <td>'.$quote['customernotes'].'</td>
                                        <td>'.$quote['datecreated'].'</td>
                                        <td>'.$quote['lastmodified'].'</td>
                                        <td>
                                            <input type="button" value="'.__('Delete', 'wp-whmcs-sync').'" data-quote-id="'.$quote['id'].'" name="delete-quote" class="delete-quote" /> 
                                            <a href="'.$current_url.'/?quote=update&quote-id='.$quote['id'].'" name="update-quote" class="update-quote" data-quote-id="'.$quote['id'].'" > '.__('Update', 'wp-whmcs-sync').' </a>
                                        </td>
                                    </tr>';
                                endforeach;
                            $content .= '</tbody>
                        </table>';
                    else:
                        $content .= '<p>'.__('No quotes available.', 'wp-whmcs-sync').'</p>';
                    endif;
                } else {
                    $content .= '<p> ' . __('Something Went Wrong', 'wp-whmcs-sync') . ' </p>';
                }
        
            $content .= '</div>';
        
            return $content;
        }
    }

    /**
     * Method to create quote's content (form)
     */
    private function whmcs_create_quote_form($quotes){

        $update_quote_data = '';
        if(isset($_GET['quote']) && isset($_GET['quote-id'])){
            if(is_array($quotes['quotes'])){
                if(is_array($quotes['quotes']['quote'])){
                    foreach ($quotes['quotes']['quote'] as $quote) {
                        if ($quote['id'] == $_GET['quote-id']) {
                            $update_quote_data = $quote;
                            break;
                        }
                    }
                }
            }
        }
        
        $this->whmcs_create_update_quote();
        $body = [
            'action'       => 'GetClients',
            'username'     => $this->meta_data['whmcs-api-identifier'],
            'password'     => $this->meta_data['whmcs-api-secret'],
            'responsetype' => 'json',
        ];
        $clients = $this->whmcs_api_calling($body);

        $body = [
            'action'       => 'GetProducts',
            'username'     => $this->meta_data['whmcs-api-identifier'],
            'password'     => $this->meta_data['whmcs-api-secret'],
            'responsetype' => 'json',
        ];

        $products = $this->whmcs_api_calling($body);

        $content = '
            <form action="" method="post">
                <h2>'.__('General Information', 'wp-whmcs-sync').'</h2>
                <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
                    <tbody>
                        <tr>
                            <td class="field-label">'.__('Subject', 'wp-whmcs-sync').'</td>
                            <td class="field-area">
                                <input type="text" id="input-quote-subject" required name="subject" value="'. ($update_quote_data['subject'] ?? '') .'" class="form-control">
                            </td>
                            <td>'.__('Stage', 'wp-whmcs-sync').'</td>
                            <td class="field-area">
                                <select id="quote-stage" name="stage" class="form-control">
                                    <option value="Draft" '. (($update_quote_data['stage'] ?? '') == 'Draft' ? 'selected' : '') .'>'.__('Draft', 'wp-whmcs-sync').'</option>
                                    <option value="Delivered" '. (($update_quote_data['stage'] ?? '') == 'Delivered' ? 'selected' : '') .'>'.__('Delivered', 'wp-whmcs-sync').'</option>
                                    <option value="On Hold" '. (($update_quote_data['stage'] ?? '') == 'On Hold' ? 'selected' : '') .'>'.__('On Hold', 'wp-whmcs-sync').'</option>
                                    <option value="Accepted" '. (($update_quote_data['stage'] ?? '') == 'Accepted' ? 'selected' : '') .'>'.__('Accepted', 'wp-whmcs-sync').'</option>
                                    <option value="Lost" '. (($update_quote_data['stage'] ?? '') == 'Lost' ? 'selected' : '') .'>'.__('Lost', 'wp-whmcs-sync').'</option>
                                    <option value="Dead" '. (($update_quote_data['stage'] ?? '') == 'Dead' ? 'selected' : '') .'>'.__('Dead', 'wp-whmcs-sync').'</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td class="field-label">
                                '.__('Date Created', 'wp-whmcs-sync').'    
                            </td>
                            <td class="field-area">
                                <div class="form-group date-picker-prepend-icon">
                                    <input id="input-date-created" type="date" value="'. (isset($update_quote_data['datecreated']) ? $update_quote_data['datecreated'] : date('Y-m-d')) .'" name="date-created" class="form-control future">
                                </div>
                            </td>
                            <td class="field-label">
                                '.__('Valid Until', 'wp-whmcs-sync').'    
                            </td>
                            <td class="field-area">
                                <div class="form-group date-picker-prepend-icon">
                                    <input required id="input-valid-until" type="date" value="'. (isset($update_quote_data['validuntil']) ? $update_quote_data['validuntil'] : date('Y-m-d', strtotime('+1 day'))) .'" name="valid-until" class="form-control future">
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <h2>'.__('Client Information', 'wp-whmcs-sync').'</h2>
                <p class="quote-existing-client">
                    <input type="radio" name="client-type" value="existing" id="client-type-existing" checked=""> 
                    <label for="client-type-existing">'.__('Quote for existing client:', 'wp-whmcs-sync').'</label> ';
                    if ($clients && isset($clients['result']) && $clients['result'] === 'success'):
                        $content .= '<select id="user-dropdown" name="user-id" class="form-control" placeholder="'.__('Start Typing to Search Clients', 'wp-whmcs-sync').'">';
                            foreach ($clients['clients']['client'] as $client):
                                $selected = ($update_quote_data['userid'] ?? '') == $client['id'] ? 'selected' : '';
                                $content .= '<option value="'.$client['id'].'" '.$selected.'>
                                    '.$client['firstname'] . ' ' . $client['lastname'] .' ( '.$client['email'].' )
                                </option>';
                            endforeach;
                        $content .= '</select>';
                    endif;
                    
                    $content .= '<br>
                    <input type="radio" name="client-type" value="new" id="client-type-new"> 
                    <label for="client-type-new">'.__('Quote for new client', 'wp-whmcs-sync').'</label>
                </p>

                <div id="new-client-form">
                    <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
                        <tbody>
                            <tr>
                                <td width="15%" class="field-label">'.__('First Name', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" id="first-name" name="first-name" class="form-control" value="'. ($update_quote_data['firstname'] ?? '') .'"></td>
                                <td width="15%" class="field-label">'.__('Address 1', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="address1" class="form-control" value="'. ($update_quote_data['address1'] ?? '') .'"></td>
                            </tr>
                            <tr>
                                <td class="field-label">'.__('Last Name', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" id="last-name" name="last-name" class="form-control" value="'. ($update_quote_data['lastname'] ?? '') .'"></td>
                                <td class="field-label">'.__('Address 2', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="address2" class="form-control" value="'. ($update_quote_data['address2'] ?? '') .'"></td>
                            </tr>
                            <tr>
                                <td class="field-label">'.__('Company Name', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="company-name" class="form-control" value="'. ($update_quote_data['companyname'] ?? '') .'"></td>
                                <td class="field-label">'.__('City', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="city" class="form-control" value="'. ($update_quote_data['city'] ?? '') .'"></td>
                            </tr>
                            <tr>
                                <td class="field-label">'.__('Email Address', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" id="input-new-client-email" name="email" class="form-control" value="'. ($update_quote_data['email'] ?? '') .'"></td>
                                <td class="field-label">'.__('State/Region', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="state" class="form-control" value="'. ($update_quote_data['state'] ?? '') .'"></td>
                            </tr>
                            <tr>
                                <td class="field-label">'.__('Phone Number', 'wp-whmcs-sync').'</td>
                                <td><input type="text" name="phone-number" class="form-control" value="'. ($update_quote_data['phonenumber'] ?? '') .'" placeholder="201-555-0123"></td>
                                <td class="field-label">'.__('Postcode', 'wp-whmcs-sync').'</td>
                                <td class="field-area"><input type="text" name="postcode" class="form-control" value="'. ($update_quote_data['postcode'] ?? '') .'"></td>
                            </tr>
                            <tr>
                                <td class="field-label">'.__('Currency', 'wp-whmcs-sync').'</td>
                                <td class="field-area">
                                    <select name="currency" class="form-control">
                                        <option value="1" '. (($update_quote_data['currency'] ?? '') == 1 ? 'selected' : '') .'> USD </option>
                                        <option value="3" '. (($update_quote_data['currency'] ?? '') == 3 ? 'selected' : '') .'> SEK </option>
                                        <option value="2" '. (($update_quote_data['currency'] ?? '') == 2 ? 'selected' : '') .'> EUR </option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>';

                $content .= '<h2>'.__('Line Items', 'wp-whmcs-sync').'</h2>';

                // Check if $update_quote_data array is empty
                if (empty($update_quote_data)) {
                    // Display the default HTML structure
                    $content .= '
                        <div class="tablebg">
                            <table class="datatable" width="100%" border="0" cellspacing="1" cellpadding="3">
                                <tbody>
                                    <tr>
                                        <th>'.__('Qty', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Description', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Unit Price', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Discount %', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Total', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Taxed', 'wp-whmcs-sync').'</th>
                                        <th></th>
                                    </tr>
                                    <tr class="quote-products">
                                        <td><input type="text" name="add_qty" value="1" class="form-control"></td>
                                        <td>
                                            <textarea name="add_desc" id="add_desc" rows="1" class="expanding form-control"></textarea>
                                        </td>
                                        <td><input type="text" name="add_up" id="add_up" value="0.00" class="form-control"></td>
                                        <td><input type="text" name="add_discount" value="0.00" class="form-control"></td>
                                        <td></td>
                                        <td><input type="checkbox" name="add_taxable" value="1"></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">
                                            <table width="100%" cellspacing="0" cellpadding="0">
                                                <tbody>
                                                    <tr>
                                                        <td style="text-align:left;font-weight:normal;"><a href="#">'.__('Add a Predefined Product', 'wp-whmcs-sync').'</a></td>
                                                        <td> 
                                                            <select name="pid" id="addproduct">
                                                                <option>Choose a product...</option>';
                                                                if($products && is_array($products['products'])){
                                                                    foreach ($products['products']['product'] as $product):
                                                                        $content .= '<option data-price="'.$product['pricing']['USD']['monthly'].'" value="'.$product['pricing']['USD']['monthly'].'">'.$product['name'].'</option>';
                                                                    endforeach;
                                                                }
                                                            $content .= '</select>
                                                        </td>
                                                        <td align="right">'.__('Sub Total&nbsp;', 'wp-whmcs-sync').'</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                        <td class="quote-total" width="90">$0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" align="right">'.__('Total Due&nbsp;', 'wp-whmcs-sync').'</td>
                                        <td class="quote-total" width="90">$0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>';
                } else {
                    $content .= '
                        <div class="tablebg">
                            <table class="datatable" width="100%" border="0" cellspacing="1" cellpadding="3">
                                <tbody>
                                    <tr>
                                        <th>'.__('Qty', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Description', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Unit Price', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Discount %', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Total', 'wp-whmcs-sync').'</th>
                                        <th>'.__('Taxed', 'wp-whmcs-sync').'</th>
                                        <th></th>
                                    </tr>';

                                    // Loop through each line item in $update_quote_data['items']['item']
                                    foreach ($update_quote_data['items']['item'] as $item) {
                                        $content .= '<tr class="quote-products">
                                            <td><input type="text" name="add_qty[]" value="'. $item['quantity'] .'" class="form-control"></td>
                                            <td>
                                                <textarea name="add_desc[]" id="add_desc" rows="1" class="expanding form-control">'. $item['description'] .'</textarea>
                                            </td>
                                            <td><input type="text" name="add_up[]" id="add_up" value="'. $item['unitprice'] .'" class="form-control"></td>
                                            <td><input type="text" name="add_discount[]" value="'. $item['discount'] .'" class="form-control"></td>
                                            <td>'. ($item['quantity'] * $item['unitprice']) .'</td>
                                            <td><input type="checkbox" name="add_taxable[]" value="1" '. ($item['taxable'] == 1 ? 'checked' : '') .'></td>
                                            <td></td>
                                        </tr>';
                                    }

                                    $content .= '<tr>
                                        <td colspan="4">
                                            <table width="100%" cellspacing="0" cellpadding="0">
                                                <tbody>
                                                    <tr>
                                                        <td style="text-align:left;font-weight:normal;"><a href="#">'.__('Add a Predefined Product', 'wp-whmcs-sync').'</a></td>
                                                        <td> 
                                                            <select name="pid" id="addproduct">
                                                                <option>Choose a product...</option>';
                                                                if($products && is_array($products['products'])){
                                                                    foreach ($products['products']['product'] as $product):
                                                                        $content .= '<option data-price="'.$product['pricing']['USD']['monthly'].'" value="'.$product['pricing']['USD']['monthly'].'">'.$product['name'].'</option>';
                                                                    endforeach;
                                                                }
                                                            $content .= '</select>
                                                        </td>
                                                        <td align="right">'.__('Sub Total&nbsp;', 'wp-whmcs-sync').'</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                        <td class="quote-total" width="90">$0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" align="right">'.__('Total Due&nbsp;', 'wp-whmcs-sync').'</td>
                                        <td class="quote-total" width="90">$0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                            <input type="hidden" name="quote-update" value="'.($update_quote_data['id'] ?? '').'" class="quote-update" />
                        </div>
                    ';
                }

                $content .= '<h2>'.__('Notes', 'wp-whmcs-sync').'</h2>
                <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
                    <tbody>
                        <tr>
                            <td class="fieldlabel">'.__('Proposal Text<br>(Displayed at the Top of the Quote)', 'wp-whmcs-sync').'</td>
                            <td class="field-area"><textarea name="proposal" rows="5" class="form-control">'. ($update_quote_data['proposal'] ?? '') .'</textarea></td>
                        </tr>
                        <tr>
                            <td width="15%" class="fieldlabel">'.__('Customer Notes<br>(Displayed as a Footer to the Quote)', 'wp-whmcs-sync').'</td>
                            <td class="field-area"><textarea name="customernotes" rows="5" class="form-control">'. ($update_quote_data['customernotes'] ?? '') .'</textarea></td>
                        </tr>
                        <tr>
                            <td class="fieldlabel">'.__('Admin Only Notes<br>(Private Notes)', 'wp-whmcs-sync').'</td>
                            <td class="field-area"><textarea name="adminnotes" rows="5" class="form-control">'. ($update_quote_data['adminnotes'] ?? '') .'</textarea></td>
                        </tr>
                    </tbody>
                </table>

                <input type="submit" class="create-quote-submit" value="'.(empty($update_quote_data) ? __('Submit', 'wp-whmcs-sync') : __('Update', 'wp-whmcs-sync')).'">
            </form>
            
        ';

        return $content;
    }
    
    /**
     * Method to create quote
     */
    public function whmcs_create_update_quote(){
        if(isset($_POST['quote-update'])){
            $action = 'UpdateQuote';
            
        } else {
            $action = 'CreateQuote';
        }

        
        if(isset($_POST['subject']) && isset($_POST['stage']) && isset($_POST['date-created']) && isset($_POST['valid-until'])){
            if(!empty($_POST['subject']) && !empty($_POST['stage']) && !empty($_POST['valid-until'])){
                $date = DateTime::createFromFormat('Y-m-d', $_POST['valid-until']);
                $date_created = DateTime::createFromFormat('Y-m-d', $_POST['date-created']);
                

                $add_qty = $_POST['add_qty'];
                $add_desc = $_POST['add_desc'];
                $add_up = $_POST['add_up'];
                $add_discount = $_POST['add_discount'];
                $transformed_array = [];

                // Iterate through the arrays
                for ($i = 0; $i < count($add_desc); $i++) {
                    // Create a new associative array for each item
                    $item = [
                        "desc" => $add_desc[$i],
                        "qty" => $add_qty[$i],
                        "up" => number_format((float)$add_up[$i], 2, '.', ''), // Format unit price to have 2 decimal places
                        "discount" => number_format((float)$add_discount[$i], 2, '.', ''), // Format discount to have 2 decimal places
                        "taxable" => false // Assuming no taxable field is provided in the original data
                    ];

                    // Add the item to the transformed array
                    $transformed_array[] = $item;
                }


                $body = [
                    'action'     => $action,
                    'username'   => $this->meta_data['whmcs-api-identifier'],
                    'password'   => $this->meta_data['whmcs-api-secret'],
                    'subject'    => $_POST['subject'],
                    'stage'      => $_POST['stage'],
                    'userid'     => $_POST['client-type'] != 'new' ? $_POST['user-id'] : '',
                    'datecreated' => empty($_POST['date_created']) ? $date_created->format('m/d/Y') : '',
                    'validuntil' => $date->format('m/d/Y'),
                    'lineitems'  => base64_encode(serialize(
                        $transformed_array
                    )),
                    'quoteid' => $action === 'UpdateQuote' ? $_POST['quote-update'] : '',
                    'firstname' => $_POST['client-type'] === 'new' ? $_POST['first-name'] : '',
                    'lastname' => $_POST['client-type'] === 'new' ? $_POST['last-name'] : '',
                    'companyname' => $_POST['client-type'] === 'new' ? $_POST['company-name'] : '',
                    'email' => $_POST['client-type'] === 'new' ? $_POST['email'] : '',
                    'address1' => $_POST['client-type'] === 'new' ? $_POST['address1'] : '',
                    'address2' => $_POST['client-type'] === 'new' ? $_POST['address2'] : '',
                    'city' => $_POST['client-type'] === 'new' ? $_POST['city'] : '',
                    'state' => $_POST['client-type'] === 'new' ? $_POST['state'] : '',
                    'postcode' => $_POST['client-type'] === 'new' ? $_POST['postcode'] : '',
                    'country' => $_POST['client-type'] === 'new' ? $_POST['country'] : '',
                    'phonenumber' => $_POST['client-type'] === 'new' ? $_POST['phone-number'] : '', 
                    'currency' => $_POST['currency'],
                    'proposal' => $_POST['proposal'] ? $_POST['proposal'] : '',
                    'customernotes' => $_POST['customernotes'] ? $_POST['customernotes'] : '',
                    'adminnotes' => $_POST['adminnotes'] ? $_POST['adminnotes'] : '',
                    'responsetype' => 'json',
                ];

                $create_quote = $this->whmcs_api_calling($body);

                if($create_quote && isset($create_quote['result'])){
                    if($create_quote['result'] === 'success'){
                        echo '<script>alert("Your quote has been created.")</script>'; 
                    }
                }
            }
        }
    }

    /**
     * Method to update quotes
     */
    public function whmcs_update_quote($posted_data){
        
    }







    //SHORTCODE AJAX HANDLERS

    /**
     * AJAX method to check if the WHMCS user is logged in or not
     */
    public function whmcs_login_status(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_login_status' && isset($_POST['whmcsUser'])){
            if($_POST['whmcsUser'] === 'loggedin'){
                $_SESSION['whmcsUser'] = 'loggedin';
            } else {
                $_SESSION['whmcsUser'] = 'loggedout';
            }
        }
    }

    /**
     * AJAX method to trigger domain search
     */
    public function whmcs_ajax_domain_search(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_ajax_domain_search' && isset($_POST['domainName'])){
            if(!empty($_POST['domainName'])){
                if(!empty($this->meta_data['whmcs-api']) && !empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    $body = array(
                        'action'       => 'DomainWhois',
                        'identifier'   => $this->meta_data['whmcs-api-identifier'],
                        'secret'       => $this->meta_data['whmcs-api-secret'],
                        'domain'       => $_POST['domainName'],
                        'responsetype' => 'json',
                    );
            
                    $response = $this->whmcs_api_calling($body);
                    if($response){

                        //TLD Listing
                        $body = [
                            'action'       => 'GetTLDPricing',
                            'username'     => $this->meta_data['whmcs-api-identifier'],
                            'password'     => $this->meta_data['whmcs-api-secret'],
                            'currencyid'   => '1',
                            'responsetype' => 'json',
                        ];

                        $domains = $this->whmcs_api_calling($body);
                        if ($domains && isset($domains['result'])) {
                            if ($domains['result'] == 'success') {
                                if (is_array($domains['pricing'])) {
                                    foreach($domains['pricing'] as $key => $domain){
                                        if(explode('.', $_POST['domainName'])[1] == $key){
                                            $registration = $domain['register'];
                                            $transfer = $domain['transfer'];
                                        }
                                    }
                                }
                            }
                        }

                        $arr = [
                            'response' => $response,
                            'register' => $registration,
                            'transfer' => $transfer
                        ];

                        wp_send_json_success( $arr );
                    } else {
                        wp_send_json_error( 'false' );
                    }
                } else {
                    wp_send_json_error( 'false' );
                }
            }
        }
    }

    /**
	 * Method to get WHMCS product billing cycle
	 */
	public function whmcs_product_billing_cycle_handler(){
		if(isset($_POST['action']) && $_POST['action'] === 'whmcs_product_billing_cycle' && isset($_POST['whmcsProduct'])){
			if(!empty($_POST['whmcsProduct'])){

                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    //Product Listing
                    $body = [
                        'action'       => 'GetProducts',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'responsetype' => 'json',
                    ];

                    $billing_cycle_arr = [];
                    $products = $this->whmcs_api_calling($body);
                    if(isset($products['result']) && $products['result'] == 'success'){
                        $desired_keys = ['monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially'];
                        foreach($products['products']['product'] as $product){
                            if($product['name'] === $_POST['whmcsProduct']){
                                //get product description
                                $description = $product['description'];
                                //get domain billing cycle informatino
                                foreach($product['pricing']['USD'] as $key => $billing){
                                    if(in_array($key, $desired_keys)){
                                        $arr = [
                                            'name'  => ucfirst($key),
                                            'price' => $billing,
                                        ];
                                        $billing_cycle_arr[] = $arr;
                                    }
                                }
                            }
                        }

                        //prepare final array which will contain billing cycle information and product description
                        $final_arr = [
                            'billing_cycle_arr' => $billing_cycle_arr,
                            'desc'  => $description
                        ];

                        if(!empty($billing_cycle_arr) && !empty($final_arr)){
                            wp_send_json_success( $final_arr );
                        }
                    }
                }
			}
		}
	}
    
    /**
     * Method to validate WHMCS login
     */
    public function whmcs_validate_login(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_validate_login' && isset($_POST['email']) && isset($_POST['password']) && !isset($_POST['shortcodeAction'])){
            if(!empty($_POST['email']) && !empty($_POST['password'])){
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    //validate whmcs login details
                    $body = [
                        'action'       => 'ValidateLogin',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'email'        => $_POST['email'],
                        'password2'    => $_POST['password'],
                        'responsetype' => 'json',
                    ];
    
                    $client_info = $this->whmcs_api_calling($body);
                    if($client_info && isset($client_info['result'])){
                        if($client_info['result'] === 'success'){
                            $_SESSION['whmcs_client_id'] = $client_info['userid'];

                            //get whmcs departments list
                            $body = [
                                'action'       => 'GetSupportDepartments',
                                'username'     => $this->meta_data['whmcs-api-identifier'],
                                'password'     => $this->meta_data['whmcs-api-secret'],
                                'responsetype' => 'json',
                            ];
            
                            $department_list = $this->whmcs_api_calling($body);

                            if(isset($department_list['result'])){
                                if($department_list['result'] === 'error'){
                                    wp_send_json_error( $department_list );
                                } else if($department_list['result'] === 'success'){
                                    if(!empty($department_list['departments'])){
                                        $arr = [
                                            // 'client_id' => $_SESSION['whmcs_client_id'],
                                            'department_list' => $department_list['departments']
                                        ];

                                        $_SESSION['dept-list'] = $department_list['departments'];
                                        wp_send_json_success( $arr );
                                    } else {
                                        $message = [
                                            'message' => __('Emtpy department list')
                                        ];
                                        wp_send_json_error( $message );
                                    }
                                }
                            }
                        } else {
                            wp_send_json_error( $client_info );
                        }
                    } else {
                        wp_send_json_error( $client_info );
                    }
                } else {
                    $message = [
                        'message' => __('WHMCS API is missing', 'wp-whmcs-sync')
                    ];
                    wp_send_json_error( $message );
                }
            }
        } else if(isset($_POST['action']) && $_POST['action'] === 'whmcs_validate_login' && isset($_POST['email']) && isset($_POST['password']) && isset($_POST['shortcodeAction'])){
            if(!empty($_POST['email']) && !empty($_POST['password']) && $_POST['shortcodeAction'] === 'usageStatistics' && !empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                //validate whmcs login details
                $body = [
                    'action'       => 'ValidateLogin',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'email'        => $_POST['email'],
                    'password2'    => $_POST['password'],
                    'responsetype' => 'json',
                ];

                $client_info = $this->whmcs_api_calling($body);
                if($client_info && isset($client_info['result'])){
                    if($client_info['result'] === 'success'){
                        $_SESSION['whmcs_client_id'] = $client_info['userid'];

                        $user_id = $client_info['userid'];
                        // $user_id = 3746;

                        //get whmcs departments list
                        $body = [
                            'action'       => 'GetClientsDomains',
                            'username'     => $this->meta_data['whmcs-api-identifier'],
                            'password'     => $this->meta_data['whmcs-api-secret'],
                            'clientid'     => $user_id,
                            'stats'        => true,
                            'responsetype' => 'json',
                        ];
        
                        $client_domains = $this->whmcs_api_calling($body);
                        if(isset($client_domains['result'])){
                            if($client_domains['result'] === 'error'){
                                wp_send_json_error( $client_domains );
                            } else if($client_domains['result'] === 'success'){
                                if(!empty($client_domains['domains'])){

                                    $body = [
                                        'action'       => 'GetClientsProducts',
                                        'username'     => $this->meta_data['whmcs-api-identifier'],
                                        'password'     => $this->meta_data['whmcs-api-secret'],
                                        'clientid'     => $user_id,
                                        'responsetype' => 'json',
                                    ];
                    
                                    $product_info = $this->whmcs_api_calling($body);
                                    if($product_info && $product_info['result'] === 'success'){
                                        $arr = [
                                            'products' => $product_info['products']['product'],
                                            'domains' => $client_domains['domains']['domain']
                                        ];

                                        $_SESSION['usage-statistics'] = $arr;
                                        wp_send_json_success( $arr );
                                    }
                                } else {
                                    $message = [
                                        'message' => __('Emtpy domaim & product list')
                                    ];
                                    wp_send_json_error( $message );
                                }
                            }
                        }
                    } else {
                        wp_send_json_error( $client_info );
                    }
                } else {
                    wp_send_json_error( $client_info );
                }
            } else if(!empty($_POST['email']) && !empty($_POST['password']) && $_POST['shortcodeAction'] === 'serviceRenewalReminders' && !empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                //validate whmcs login details
                $body = [
                    'action'       => 'ValidateLogin',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'email'        => $_POST['email'],
                    'password2'    => $_POST['password'],
                    'responsetype' => 'json',
                ];

                $client_info = $this->whmcs_api_calling($body);
                if($client_info && isset($client_info['result'])){
                    if($client_info['result'] === 'success'){
                        $_SESSION['whmcs_client_id'] = $client_info['userid'];
                        $user_id = $client_info['userid'];
                        $_SESSION['whmcs_client_email'] = $_POST['email'];
                        // $user_id = 3746;

                        $body = [
                            'action'       => 'GetClientsAddons',
                            'username'     => $this->meta_data['whmcs-api-identifier'],
                            'password'     => $this->meta_data['whmcs-api-secret'],
                            'clientid'     => $user_id,
                            'stats'        => true,
                            'responsetype' => 'json',
                        ];
        
                        $client_addons = $this->whmcs_api_calling($body);
                        if($client_addons && isset($client_addons['result'])){
                            if($client_addons['result'] === 'error'){
                                wp_send_json_error( $client_addons );
                            } else if($client_addons['result'] === 'success'){
                                $_SESSION['client_addons'] = $client_addons['addons']['addon'];
                                wp_send_json_success( 'true' );
                            }
                        }
                    } else {
                        wp_send_json_error( $client_info );
                    }
                } else {
                    wp_send_json_error( $client_info );
                }
            } else if(!empty($_POST['email']) && !empty($_POST['password']) && $_POST['shortcodeAction'] === 'customDashboardWidgets' && !empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                //validate whmcs login details
                $body = [
                    'action'       => 'ValidateLogin',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'email'        => $_POST['email'],
                    'password2'    => $_POST['password'],
                    'responsetype' => 'json',
                ];

                $client_info = $this->whmcs_api_calling($body);
                if($client_info && isset($client_info['result'])){
                    if($client_info['result'] === 'success'){
                        $_SESSION['whmcs_user_id'] = 3746;
                        // $_SESSION['whmcs_user_id'] = $client_info['userid'];

                        //get all information of the logged in user
                        $body = [
                            'action'       => 'GetClientsDetails',
                            'username'     => $this->meta_data['whmcs-api-identifier'],
                            'password'     => $this->meta_data['whmcs-api-secret'],
                            'email'        => $_POST['email'],
                            'responsetype' => 'json',
                        ];
        
                        $client_info = $this->whmcs_api_calling($body);
                        if($client_info && isset($client_info['result'])){
                            if($client_info['result'] === 'success'){
                                $_SESSION['client_info'] = $client_info;

                                //get logged in user products
                                $body = [
                                    'action'       => 'GetClientsProducts',
                                    'username'     => $this->meta_data['whmcs-api-identifier'],
                                    'password'     => $this->meta_data['whmcs-api-secret'],
                                    'clientid'     => $client_info['userid'],
                                    'responsetype' => 'json',
                                ];

                                $body2 = [
                                    'action'       => 'GetClientsDomains',
                                    'username'     => $this->meta_data['whmcs-api-identifier'],
                                    'password'     => $this->meta_data['whmcs-api-secret'],
                                    'clientid'     => $client_info['userid'],
                                    'responsetype' => 'json',
                                ];
                
                                $client_products = $this->whmcs_api_calling($body);
                                $client_domains = $this->whmcs_api_calling($body2);
                                if($client_products && isset($client_products['result'])){
                                    if($client_products['result'] === 'success'){
                                        $_SESSION['client_products_info'] = $client_products;

                                        //prepare array for all items to pas to JS side
                                        $arr = [
                                            'client_info' => $client_info,
                                            'client_products' => $client_products['products'],
                                            'client_domain' => $client_domains['domains']
                                        ];

                                        wp_send_json_success( $arr );

                                    } else {
                                        wp_send_json_error( $client_products );
                                    }
                                }
                            } else {
                                wp_send_json_error( $client_info );
                            }
                        }

                    } else {
                        wp_send_json_error( $client_info );
                    }
                }
            }
        }
    }

    /**
     * Method to hit ajax events for the whmcs clientarea
     */
    public function whmcs_clientarea_handler(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_clientarea' && isset($_POST['email']) && isset($_POST['password'])){
            if(!empty($_POST['email']) && !empty($_POST['password'])){
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    //validate whmcs user
                    $body = [
                        'action'       => 'ValidateLogin',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'email'        => $_POST['email'],
                        'password2'    => $_POST['password'],
                        'responsetype' => 'json',
                    ];
    
                    $client_info = $this->whmcs_api_calling($body);
                    if($client_info && isset($client_info['result'])){
                        if($client_info['result'] === 'success'){
                            $_SESSION['whmcs_user_id'] = $client_info['userid'];

                            //get all information of the logged in user
                            $body = [
                                'action'       => 'GetClientsDetails',
                                'username'     => $this->meta_data['whmcs-api-identifier'],
                                'password'     => $this->meta_data['whmcs-api-secret'],
                                'email'        => $_POST['email'],
                                'responsetype' => 'json',
                            ];
            
                            $client_info = $this->whmcs_api_calling($body);
                            if($client_info && isset($client_info['result'])){
                                if($client_info['result'] === 'success'){
                                    $_SESSION['client_info'] = $client_info;

                                    //get logged in user products
                                    $body = [
                                        'action'       => 'GetClientsProducts',
                                        'username'     => $this->meta_data['whmcs-api-identifier'],
                                        'password'     => $this->meta_data['whmcs-api-secret'],
                                        'clientid'     => $client_info['userid'],
                                        'responsetype' => 'json',
                                    ];
                    
                                    $client_products = $this->whmcs_api_calling($body);
                                    if($client_products && isset($client_products['result'])){
                                        if($client_products['result'] === 'success'){
                                            $_SESSION['client_products_info'] = $client_products;

                                            //prepare array for all items to pas to JS side
                                            $arr = [
                                                'client_info' => $client_info,
                                                'client_products' => $client_products['products']
                                            ];

                                            wp_send_json_success( $arr );

                                        } else {
                                            wp_send_json_error( $client_products );
                                        }
                                    }
                                } else {
                                    wp_send_json_error( $client_info );
                                }
                            }

                        } else {
                            wp_send_json_error( $client_info );
                        }
                    }
                } else {
                    $message = [
                        'message' => __('WHMCS API is missing!', 'wp-whmcs-sync')
                    ];
                    wp_send_json_error( $message );
                }
            }
        }
    }

    /**
     * Method to open WHMCS ticket
     */
    public function whmcs_open_ticket(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_open_ticket' && isset($_POST['deptId']) && isset($_POST['subject']) && isset($_POST['message']) && isset($_POST['priority'])){
            if(!empty($_POST['deptId']) && !empty($_POST['subject']) && !empty($_POST['message']) && !empty($_POST['priority'])){
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    if(isset($_SESSION['whmcs_client_id'])){
                        $body = [
                            'action'       => 'OpenTicket',
                            'username'     => $this->meta_data['whmcs-api-identifier'],
                            'password'     => $this->meta_data['whmcs-api-secret'],
                            'deptid'       => $_POST['deptId'],
                            'subject'      => $_POST['subject'],
                            'message'      => $_POST['message'],
                            // 'clientid'     => 3746,
                            'clientid'     => $_SESSION['whmcs_client_id'],
                            'priority'     => $_POST['priority'],
                            'responsetype' => 'json',
                        ];
        
                        $ticket_info = $this->whmcs_api_calling($body);
                        if($ticket_info && isset($ticket_info['result'])){
                            if($ticket_info['result'] === 'error'){
                                wp_send_json_error( $ticket_info );
                            } else if($ticket_info['result'] === 'success'){
                                $message = [
                                    'message' => __('Your ticket has been created')
                                ];
                                wp_send_json_success( $message );
                            }
                        }
                    } else {
                        $message = [
                            'message' => __('Something went wrong!')
                        ];
                        wp_send_json_error( $message );
                    }
                   
                } else {
                    $message = [
                        'message' => __('WHMCS API is missing!')
                    ];
                    wp_send_json_error( $message );
                }
            }
        }
    }

    /**
     * Method to get whmcs user invoices
     */
    public function whmcs_invoices_handler(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_invoices' && isset($_POST['email']) && isset($_POST['pwd'])){
            if(!empty($_POST['email']) && !empty($_POST['pwd'])){
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    //validate whmcs user
                    $body = [
                        'action'       => 'ValidateLogin',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'email'        => $_POST['email'],
                        'password2'    => $_POST['pwd'],
                        'responsetype' => 'json',
                    ];
    
                    $client_info = $this->whmcs_api_calling($body);
                    if($client_info && isset($client_info['result'])){
                        if($client_info['result'] === 'success'){
                            //get all information of the logged in user
                            $body = [
                                'action'       => 'GetInvoices',
                                'username'     => $this->meta_data['whmcs-api-identifier'],
                                'password'     => $this->meta_data['whmcs-api-secret'],
                                'userid'       => $client_info['userid'],
                                // 'userid'       => 3746,
                                'responsetype' => 'json',
                            ];
            
                            $invoices_data = $this->whmcs_api_calling($body);
                            if($invoices_data && isset($invoices_data['result'])){
                                if($invoices_data['result'] === 'success' && $invoices_data['totalresults'] > 0){
                                    $_SESSION['whmcs_user_id'] = $client_info['userid'];
                                    wp_send_json_success( $invoices_data['invoices']['invoice'] );
                                } else {
                                    $message = [
                                        'message' => __('Nothing to preview!', 'wp-whmcs-sync')
                                    ];
                                    wp_send_json_error( $message );
                                }
                            }

                        } else {
                            wp_send_json_error( $client_info );
                        }
                    }
                } else {
                    $message = [
                        'message' => __('WHMCS API is missing!', 'wp-whmcs-sync')
                    ];
                    wp_send_json_error( $message );
                }
            } else {
                $message = [
                    'message' => __('Missing email or password!', 'wp-whmcs-sync')
                ];
                wp_send_json_error( $message );
            }
        } else {
            $message = [
                'message' => __('Something went wrong!', 'wp-whmcs-sync')
            ];
            wp_send_json_error( $message );
        }
    }

    /**
     * Method to get whmcs user credit information
     */
    public function whmcs_credit_balance_handler(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_credit_balance' && isset($_POST['email']) && isset($_POST['pwd'])){
            if(!empty($_POST['email']) && !empty($_POST['pwd'])){
                if(!empty($this->meta_data['whmcs-api-identifier']) && !empty($this->meta_data['whmcs-api-secret'])){
                    //validate whmcs user
                    $body = [
                        'action'       => 'ValidateLogin',
                        'username'     => $this->meta_data['whmcs-api-identifier'],
                        'password'     => $this->meta_data['whmcs-api-secret'],
                        'email'        => $_POST['email'],
                        'password2'    => $_POST['pwd'],
                        'responsetype' => 'json',
                    ];
    
                    $client_info = $this->whmcs_api_calling($body);
                    if($client_info && isset($client_info['result'])){
                        if($client_info['result'] === 'success'){
                            $_SESSION['whmcs_user_id'] = $client_info['userid'];

                            //get all information of the logged in user
                            $body = [
                                'action'       => 'GetCredits',
                                'username'     => $this->meta_data['whmcs-api-identifier'],
                                'password'     => $this->meta_data['whmcs-api-secret'],
                                'clientid'     => $client_info['userid'],
                                // 'clientid'       => 3746,
                                'responsetype' => 'json',
                            ];
            
                            $credit_balance = $this->whmcs_api_calling($body);
                            if($credit_balance && isset($credit_balance['result'])){
                                if($credit_balance['result'] === 'success' && $credit_balance['totalresults'] > 0){
                                    wp_send_json_success( $credit_balance['credits']['credit'] );
                                } else {
                                    wp_send_json_error( $credit_balance );
                                }
                            }

                        } else {
                            wp_send_json_error( $client_info );
                        }
                    }
                } else {
                    $message = [
                        'message' => __('WHMCS API is missing!', 'wp-whmcs-sync')
                    ];
                    wp_send_json_error( $message );
                }
            } else {
                $message = [
                    'message' => __('Missing email or password!', 'wp-whmcs-sync')
                ];
                wp_send_json_error( $message );
            }
        } else {
            $message = [
                'message' => __('Something went wrong!', 'wp-whmcs-sync')
            ];
            wp_send_json_error( $message );
        }
    }

    /**
     * Method to delete quote
     */
    public function whmcs_delete_quote_handler(){
        if(isset($_POST['action']) && $_POST['action'] === 'whmcs_delete_quote' && isset($_POST['quoteId'])){
            if(!empty($_POST['quoteId'])){
                $body = [
                    'action'       => 'DeleteQuote',
                    'username'     => $this->meta_data['whmcs-api-identifier'],
                    'password'     => $this->meta_data['whmcs-api-secret'],
                    'quoteid'      => $_POST['quoteId'],
                    'responsetype' => 'json',
                ];
            
                $quotes = $this->whmcs_api_calling($body);
                if($quotes && isset($quotes['result'])){
                    if($quotes['result'] === 'success'){
                        wp_send_json_success( ['message' => 'Quote Deleted Successfully.'] );
                    }
                }
            } else {
                wp_send_json_error( ['message' => 'Valid quote ID is required'] );
            }
        } else {
            wp_send_json_error( ['message' => 'Something went wrong.'] );
        }
    }
}

