(function($) {
    'use strict';

    /**
     * All of the code for your public-facing JavaScript source
     * should reside in this file.
     *
     * Note: It has been assumed you will write jQuery code here, so the
     * $ function reference has been prepared for usage within the scope
     * of this function.
     *
     * This enables you to define handlers, for when the DOM is ready:
     *
     * $(function() {
     *
     * });
     *
     * When the window is loaded:
     *
     * $( window ).load(function() {
     *
     * });
     *
     * ...and/or other possibilities.
     *
     * Ideally, it is not considered best practise to attach more than a
     * single DOM-ready or window-load handler for a particular page.
     * Although scripts in the WordPress core, Plugins and Themes may be
     * practising this, we should strive to set a better example in our own work.
     */

    $(document).ready(function($) {
        if($('#whmcs-tickets-tbl').length > 0){
            $('#whmcs-tickets-tbl').DataTable();
        }

        extraSiteJs();
        // if(whmcs_data.whmcs_sso === '1' && whmcs_data.whmcs_api != ''){
        //     whmcsSso()
        // }

        if(whmcs_data.whmcs_sync_style === '1' && whmcs_data.whmcs_sync_template != 'hostiko'){
            applyFontFamily();
        }

        // $(document).on('click', '#wp_whmcs_sync .primary-action a', function(e){
        //     sessionStorage.removeItem('whmcsSSOClientEmail');
        //     sessionStorage.removeItem('whmcsSSOLogin');
        // });

        //disable header and footer of theme
        if(whmcs_data.whmcs_disable_theme_header === '1' && whmcs_data.whmcs_sync_template != 'hostiko' && whmcs_data.whmcs_page === 'true'){
            $('#page > header').hide();
            $('footer:eq(2)').hide();
            $('.sidebar').hide();
            $('.elementor').hide();
        }
    });

    /**
     * Applies a custom font family to the HTML document based on the provided font family from whmcs_data.
     * If a font family is specified, it dynamically loads the corresponding Google Fonts CSS
     * and sets the global font family variable for the HTML document.
     */
     function applyFontFamily(){
        // Check if a font family is provided in the whmcs_data object
        if(whmcs_data.font_family != ''){
            $.get('https://fonts.googleapis.com/css2?family='+whmcs_data.font_family+':wght@400;700&display=swap', function(cssContent) {
                // Create a style element and append the CSS content to it
                var styleElement = $('<style class="whmcs-google-font">').text(cssContent);
                // Append the style element to the head of the document
                $('head').append(styleElement);
            });
            // Set the global font family variable for the HTML document
            $('html').css('--global-font-family', whmcs_data.font_family);
        }
    }

    // Function to handle login action
    function handleLogin() {
        //get and store client email address when he tries to login
        // Regular expression for a simple email validation
        let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        let emailValue = $('#inputEmail').val();

        if (emailValue != '' && emailRegex.test(emailValue)) {
            sessionStorage.setItem('whmcsSSOClientEmail', emailValue);
        }
    }

    //method to trigger WHMCS SSO events
    function whmcsSso(){
        // Click event
        $(document).on('click', '#login', function() {
            handleLogin();
        });

        // Keypress event on the input field
        $(document).on('keypress', '#inputEmail', function(event) {
            // Check if the pressed key is Enter (keyCode 13)
            if (event.which === 13) {
                handleLogin();
            }
        });

        // Submit event on the frmCheckout form
        $('#frmCheckout').submit(function() {
            // Call the handleLogin function with the email value
            handleLogin();
        });

        // $(document).on('change focusout', '#inputEmail', function() {
        //     handleLogin();
        // });

        let urlParams = new URLSearchParams(window.location.search);
        let whmcsSection = urlParams.get('ccce');
        //check if the user logged into the clientarea after login
        if(whmcsSection === 'clientarea' && $('#wp_whmcs_sync').find('.primary-action a').attr('href').split('=')[1] === 'logout'){

            if(sessionStorage.getItem('whmcsSSOLogin') != 'true'){

                let loaderContainer = $('<div class="loader-container" id="loaderContainer"></div>').appendTo('body');
                if(whmcs_data.whmcs_loader_enabled != true){
                    $('<div class="default-loader"></div>').appendTo(loaderContainer);
                } else {
                    $('<div class="loader"></div>').appendTo(loaderContainer);
                    
                    // Append the style element to the head of the document
                    $('head').append($('<style>').text(whmcs_data.whmcs_loader_css));
                    $('.loader').css({
                        'position': 'fixed',
                        'top': '50%',
                        'left': '50%'
                    });
                }
                // Show Loader
                loaderContainer.show();

                if(sessionStorage.getItem('whmcsSSOClientEmail') != ''){
                    sessionStorage.setItem('whmcsSSOLogin', true);

                    let data = {
                        action: 'whmcs_sso',
                        email: sessionStorage.getItem('whmcsSSOClientEmail')
                    };
        
                    whmcsAjaxCall(data);
                }

                
            }
        }
    }

    //method to trigger ajax call
    function whmcsAjaxCall(data){
        $.ajax({
            type: 'POST',
            url: urls_to_frontend.ajaxUrl,
            data: data,
            success: function(response) {
                if(response.success === true && response.data != undefined){
                    $('.loader-container').remove();
                    $('.loader').remove();
                    window.open(response.data,'_blank');
                }
            },
            error: function(error) {
                return error
            }
        });
    }

    //Method to trigger some extra features of the site
    function extraSiteJs(){
        $(document).on('click', '.added', function(e) {
            e.preventDefault();
            if(whmcs_data.friendly_url === '1'){
                window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/cart.php?a=confdomains';
            } else {
                window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/?ccce=cart&a=confdomains';
            }
        });
		
		$(document).on('click', '#btnDomainSearch', function (){
            document.querySelector('[name="domain"]').required = true
        });

        $(document).on('click', '#btnTransfer', function (){
            document.querySelector('[name="domain"]').required = true
        });
        if(document.querySelector('[name="domain"]')){
            document.querySelector('[name="domain"]').required = true
        }

        if (window.location.href.indexOf("viewinvoice") > -1 && window.location.href.indexOf("ccce") === -1) {
            // Create Loader Container
            let loaderContainer = $('<div class="loader-container" id="loaderContainer"></div>').appendTo('body');
            // Create Loader
            if(whmcs_data.whmcs_loader_enabled != true){
                $('<div class="default-loader"></div>').appendTo(loaderContainer);
            } else {
                $('<div class="loader"></div>').appendTo(loaderContainer);
                
                // Append the style element to the head of the document
                $('head').append($('<style>').text(whmcs_data.whmcs_loader_css));
                $('.loader').css({
                    'position': 'fixed',
                    'top': '50%',
                    'left': '50%'
                });
            }
            // Show Loader
            loaderContainer.show();

            // Extract the 'id' parameter from the current URL
            var urlParams = new URLSearchParams(window.location.search);
            var invoiceId = urlParams.get('id');

            // Check if 'id' parameter exists and if 'ccce' is not present in the current URL
            if (invoiceId && window.location.href.indexOf("ccce") === -1) {
                // Construct the new URL with the modified path and the extracted 'id' parameter
                // Redirect to the new URL
                window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/?ccce=viewinvoice.php/&id=' + invoiceId;
            }
        }
		
		if (window.location.href.indexOf("confproduct") > -1 && window.location.href.indexOf("ccce") === -1) {
            // Create Loader Container
            let loaderContainer = $('<div class="loader-container" id="loaderContainer"></div>').appendTo('body');
            // Create Loader
            if(whmcs_data.whmcs_loader_enabled != true){
                $('<div class="default-loader"></div>').appendTo(loaderContainer);
            } else {
                $('<div class="loader"></div>').appendTo(loaderContainer);
                
                // Append the style element to the head of the document
                $('head').append($('<style>').text(whmcs_data.whmcs_loader_css));
                $('.loader').css({
                    'position': 'fixed',
                    'top': '50%',
                    'left': '50%'
                });
            }
            // Show Loader
            loaderContainer.show();

            // Extract the 'id' parameter from the current URL
            let urlParams = new URLSearchParams(window.location.search);
            let id = urlParams.get('i');

            // Check if 'id' parameter exists and if 'ccce' is not present in the current URL
            if (id && window.location.href.indexOf("ccce") === -1) {
                // Construct the new URL with the modified path and the extracted 'id' parameter
                // Redirect to the new URL
                window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/?ccce=cart&a=confproduct&i=' + id;
            }
        }

        if(whmcs_data.friendly_url != '1'){
            if (window.location.href.indexOf("confdomains") > -1 && window.location.href.indexOf("ccce") === -1) {
                // Create Loader Container
                let loaderContainer = $('<div class="loader-container" id="loaderContainer"></div>').appendTo('body');
                // Create Loader
                if(whmcs_data.whmcs_loader_enabled != true){
                    $('<div class="default-loader"></div>').appendTo(loaderContainer);
                } else {
                    $('<div class="loader"></div>').appendTo(loaderContainer);
                    
                    // Append the style element to the head of the document
                    $('head').append($('<style>').text(whmcs_data.whmcs_loader_css));
                    $('.loader').css({
                        'position': 'fixed',
                        'top': '50%',
                        'left': '50%'
                    });
                }
                // Show Loader
                loaderContainer.show();
    
                // Check if 'id' parameter exists and if 'ccce' is not present in the current URL
                if (window.location.href.indexOf("ccce") === -1) {
                    // Construct the new URL with the modified path and the extracted 'id' parameter
                    // Redirect to the new URL
                    window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/?ccce=cart&a=confdomains';
                }
            }
        }
		
		if (window.location.href.indexOf("akdesigner.com") > -1 ) {
            let loaderContainer = $('<div class="loader-container" id="loaderContainer"></div>').appendTo('body');
            // Create Loader
            if(whmcs_data.whmcs_loader_enabled != true){
                $('<div class="default-loader"></div>').appendTo(loaderContainer);
            } else {
                $('<div class="loader"></div>').appendTo(loaderContainer);
                
                // Append the style element to the head of the document
                $('head').append($('<style>').text(whmcs_data.whmcs_loader_css));
                $('.loader').css({
                    'position': 'fixed',
                    'top': '50%',
                    'left': '50%'
                });
            }
            // Show Loader
            loaderContainer.show();

            // Extract the 'id' parameter from the current URL
            let urlParams = new URLSearchParams(window.location.search);
            let id = urlParams.get('i');

            // Check if 'id' parameter exists and if 'ccce' is not present in the current URL
            if (id) {
                // Construct the new URL with the modified path and the extracted 'id' parameter
                // Redirect to the new URL
                window.location.href = urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+ '/?ccce=cart&a=confproduct&i=' + id;
            } else {
                let currentURL = window.location.href;

                // Update the relevant part of the URL
                let updatedURL = currentURL.replace('?ccce=https:akdesigner.comcart', '?ccce=cart');

                // Redirect to the updated URL
                window.location.href = updatedURL;
            }
        }

        // Change the class name for all elements with the class 'added'
        let iconElements = document.querySelectorAll('.added i');
        // Loop through each element
        iconElements.forEach(function(iconElement) {
            // Change the class name
            iconElement.className = 'fas fa-shopping-cart fa-fw';
        });

        document.addEventListener('DOMContentLoaded', function () {
            // Get all links with the class 'smooth-scroll'
            var scrollLinks = document.querySelectorAll('a[href^="#"]');
            
            // Iterate over each link and add an event listener
            scrollLinks.forEach(function (link) {
                link.addEventListener('click', function (e) {
                    // Prevent default behavior (jumping to the target)
                    e.preventDefault();
    
                    // Get the target element's ID from the href attribute
                    var targetId = this.getAttribute('href').substring(1);
    
                    // Get the target element
                    var targetElement = document.getElementById(targetId);
    
                    // Scroll smoothly to the target element
                    targetElement.scrollIntoView({
                        behavior: 'smooth'
                    });
                });
            });
        });

        // Find the div with the ID 'creditCardInputFields'
        // let creditCardInputFields = document.getElementById('creditCardInputFields');
        // if(creditCardInputFields && whmcs_data.whmcs_sync_template != 'hostiko') {
        //     // Remove the existing content inside the 'creditCardInputFields' div
        //     creditCardInputFields.innerHTML = '';

        //     // Create a new div element with the desired content
        //     let newContent = `
        //         <div class="row cvv-input" id="existingCardInfo" style="display: none;">
        //             <div class="col-lg-3 col-sm-4">
        //             <div class="form-group prepend-icon">
        //                 <label for="inputCardCVV2" class="field-icon">
        //                 <i class="fas fa-barcode"></i>
        //                 </label>
        //                 <div class="input-group">
        //                     <input type="tel" name="cccvv" id="inputCardCVV2" class="field form-control" placeholder="CVV/CVC2" autocomplete="cc-cvc">
        //                     <span class="input-group-btn input-group-append">
        //                     <button type="button" class="btn btn-default" data-toggle="popover" data-placement="bottom" data-content="<img src='/whmcs-templates/assets/img/ccv.gif' width='210' />">
        //                     ?
        //                     </button>
        //                     <span class=" field-error-msg" =""="" data-original-title="" title="">The CVC number you entered does not appear to be valid.
        //                     </span></span>
        //                 </div>
        //             </div>
        //             </div>
        //         </div>
        //         <ul>
        //             <li>
        //             <label class="radio-inline">
        //                 <div class="iradio_square-blue checked" id="iCheck-new" style="position: relative;"><input type="radio" name="ccinfo" value="new" id="new" checked="checked" style="position: absolute; top: -20%; left: -20%; display: block; width: 140%; height: 140%; margin: 0px; padding: 0px; background: rgb(255, 255, 255); border: 0px; opacity: 0;"><ins class="iCheck-helper" style="position: absolute; top: -20%; left: -20%; display: block; width: 140%; height: 140%; margin: 0px; padding: 0px; background: rgb(255, 255, 255); border: 0px; opacity: 0;"></ins></div>
        //                 &nbsp;
        //                 Enter New Card Information Below
        //             </label>
        //             </li>
        //         </ul>
        //         <div class="row" id="newCardInfo">
        //             <div id="cardNumberContainer" class="col-sm-6 new-card-container">
        //             <div class="form-group prepend-icon">
        //                 <label for="inputCardNumber" class="field-icon">
        //                 <i class="fas fa-credit-card"></i>
        //                 </label>
        //                 <input type="tel" name="ccnumber" id="inputCardNumber" class="field form-control cc-number-field" placeholder="Card Number" autocomplete="cc-number" data-message-unsupported="We are unable to accept the card type you entered. Please use a different card." data-message-invalid="The card number you entered does not appear to be valid." data-supported-cards="visa,mastercard,discover,amex,jcb,dinersclub">
        //                 <span class="field-error-msg"></span>
        //             </div>
        //             </div>
        //             <div class="col-sm-3 new-card-container">
        //             <div class="form-group prepend-icon">
        //                 <label for="inputCardExpiry" class="field-icon">
        //                 <i class="fas fa-calendar-alt"></i>
        //                 </label>
        //                 <input type="tel" name="ccexpirydate" id="inputCardExpiry" class="field form-control" placeholder="MM / YY" autocomplete="cc-exp">
        //                 <span class="field-error-msg">The expiry date you entered does not appear to be valid.</span>
        //             </div>
        //             </div>
        //             <div class="col-sm-3" id="cvv-field-container">
        //             <div class="form-group prepend-icon">
        //                 <label for="inputCardCVV" class="field-icon">
        //                 <i class="fas fa-barcode"></i>
        //                 </label>
        //                 <div class="input-group">
        //                     <input type="tel" name="cccvv" id="inputCardCVV" class="field form-control" placeholder="CVV/CVC2" autocomplete="cc-cvc">
        //                     <span class="input-group-btn input-group-append">
        //                     <button type="button" class="btn btn-default" data-toggle="popover" data-placement="bottom" data-content="<img src='/whmcs-templates/assets/img/ccv.gif' width='210' />">
        //                     ?
        //                     </button>
        //                     <br>
        //                     <span class=" field-error-msg" =""="" data-original-title="" title="">The CVC number you entered does not appear to be valid.
        //                     </span></span>
        //                 </div>
        //             </div>
        //             </div>
        //         </div>
        //         <div id="newCardSaveSettings">
        //             <div class="row form-group new-card-container">
        //             <div id="inputDescriptionContainer" class="col-md-6">
        //                 <div class="prepend-icon">
        //                     <label for="inputDescription" class="field-icon">
        //                     <i class="fas fa-pencil"></i>
        //                     </label>
        //                     <input type="text" class="field form-control" id="inputDescription" name="ccdescription" autocomplete="off" value="" placeholder="Enter a name for this card (Optional)">
        //                 </div>
        //             </div>
        //             </div>
        //         </div>
        //     `;

        //     // Append the new content to the 'creditCardInputFields' div
        //     creditCardInputFields.insertAdjacentHTML('beforeend', newContent);
        //     // Add additional HTML content after 'creditCardInputFields'
        //     let additionalContent = `
        //         <div class="sub-heading" style="display: block;">
        //             <span class="primary-bg-color">Additional Notes</span>
        //         </div>
        //         <div class="row">
        //             <div class="col-sm-12">
        //                 <div class="form-group">
        //                     <textarea name="notes" class="field form-control" rows="4" placeholder="You can enter any additional notes or information you want included with your order here..."></textarea>
        //                 </div>
        //             </div>
        //         </div>
        //         <div class="text-center">
        //             <div class="text-center margin-bottom"></div>
        //             <button type="submit" id="btnCompleteOrder" class="btn btn-primary btn-lg disable-on-click spinner-on-click">
        //                 Complete Order &nbsp;<i class="fas fa-arrow-circle-right"></i>
        //             </button>
        //         </div>
        //     `;

        //     // Append the additional content after 'creditCardInputFields'
        //     creditCardInputFields.insertAdjacentHTML('afterend', additionalContent);
        // }

        let selectElement = document.getElementById('template-select');
        let checkboxElement = document.getElementById('whmcs-default-style');
        if(selectElement){
            // Add event listener to the select element
            selectElement.addEventListener('change', function() {
                // Disable or enable the checkbox based on the selected value
                if (selectElement.value === 'hostiko' || selectElement.value === 'twenty-one') {
                    checkboxElement.disabled = true;
                } else {
                    checkboxElement.disabled = false;
                }
            });

            if (selectElement.value === 'hostiko' || selectElement.value === 'twenty-one') {
                checkboxElement.disabled = true;
            } else {
                checkboxElement.disabled = false;
            }
        }

        if(whmcs_data.whmcs_disable_header === '1' && whmcs_data.whmcs_page === 'true'){
            // $('#content').next().remove();
            // $('#content').find('.page-title-area').remove();
            // $('#page').find('.navbar-area').remove();
            // $('.footer-bottom').remove();
            // let hostikoFooter = $('#content')[0]?.children[1];

            // // Check if the second child has the class 'elementor'
            // if ($(hostikoFooter).hasClass('elementor')) {
            //     hostikoFooter.remove();
            // } 

            $('#content .elementor').css('display', 'block');
            $('#content .page-title-area').css('display', 'block');
            $('#page .navbar-area').css('display', 'block');
            $('.footer-bottom').css('display', 'block');
            $('#footer').css('display', 'block');


            $('i.far').each(function() {
                // Get the current class attribute value
                let currentClasses = $(this).attr('class');
              
                // Replace "far" with "fas"
                let newClasses = currentClasses.replace(/\bfar\b/g, 'fas');
              
                // Update the class attribute
                $(this).attr('class', newClasses);
            });

        }

        if(whmcs_data.whmcs_page === 'true'){
            $('link#bootstrap-css').remove();
            $('#bootstrap-js-js').remove();
        }

        window.onload = function() {
            $('.loader-container').remove();
            $('.loader').remove();
        };

        if ($("a.list-group-item").length > 0) {
            // Get the current URL
            let currentURL = window.location.href;

            // Iterate over all anchor elements
            $("a.list-group-item").each(function() {
                // Get the href attribute of each anchor
                let anchorURL = $(this).attr("href");

                // Check if the current URL contains the anchor's URL
                if (currentURL.includes(anchorURL)) {
                    // Add the "active" class to the current anchor
                    $(this).addClass("active");
                }
            });
        }

        if(whmcs_data.friendly_url != '1'){
            $('#wp_whmcs_sync .navbar-brand').attr('href', urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+'/?ccce=index');
            $('#wp_whmcs_sync #Primary_Navbar-Home a').attr('href', urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+'/?ccce=index');
        } else {
            $('#wp_whmcs_sync .navbar-brand').attr('href', urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+'/index.php');
		    $('#wp_whmcs_sync #Primary_Navbar-Home a').attr('href', urls_to_frontend.siteUrl+'/'+urls_to_frontend.whmcsSlug+'/index.php');
        }


        // Bind to the window load event
        $(window).on('load', function() {
            // Check if title exists
            if ($('title').length === 0) {
                // Append title to the head
                $('head').append($('<title>'+capitalizeAndReplace(urls_to_frontend.whmcsSyncPageData.post_title)+'</title>'));
            }
        });
    }

    function capitalizeAndReplace(slug) {
        // Split the slug by '-' and capitalize each word
        var words = slug.split('-').map(function(word) {
            return word.charAt(0).toUpperCase() + word.slice(1);
        });
        // Join the words with a space
        return words.join(' ');
    }


})(jQuery);