(function($) {
    'use strict';

    /**
     * All of the code for your public-facing JavaScript source
     * should reside in this file.
     *
     * Note: It has been assumed you will write jQuery code here, so the
     * $ function reference has been prepared for usage within the scope
     * of this function.
     *
     * This enables you to define handlers, for when the DOM is ready:
     *
     * $(function() {
     *
     * });
     *
     * When the window is loaded:
     *
     * $( window ).load(function() {
     *
     * });
     *
     * ...and/or other possibilities.
     *
     * Ideally, it is not considered best practise to attach more than a
     * single DOM-ready or window-load handler for a particular page.
     * Although scripts in the WordPress core, Plugins and Themes may be
     * practising this, we should strive to set a better example in our own work.
     */

    $(document).ready(function($) {

        if($('.whmcs-multi-language').length > 0){
            // Function to show the popup
            function showPopup() {
                document.getElementById('languagePopup').style.display = 'block';
                document.getElementsByClassName('overlay')[0].style.display = 'block';
            }

            $(document).on('click', '#closePopup', function(){
                document.getElementById('languagePopup').style.display = 'none';
            });

            // Attach event listener to the button to show the popup
            document.getElementById('languagePopupBtn').addEventListener('click', showPopup);
        }

        if($('#usr-invoices').length > 0){
            $('#usr-invoices').DataTable();
        }
        if($('#usage-statistics').length > 0){
            $('#usage-statistics').DataTable();
        }
        if($('#usage-statistics-products').length > 0){
            $('#usage-statistics-products').DataTable();
        }

         // JavaScript to toggle visibility of description on title click
        let titles = document.querySelectorAll('.announcement-title');
        titles.forEach(function(title) {
            title.addEventListener('click', function() {
                let desc = this.nextElementSibling;
                desc.style.display = (desc.style.display === 'none' || desc.style.display === '') ? 'block' : 'none';
            });
        });

        //extra JS for shotcodes
        extraJsForShortcodes();

        //shortcode handlers
        checkWhmcsUserLoggedInStatus();
        triggerAjaxDomainSearch();
        domainRegisterAndTransferRedirect();
        showWhmcsGetProductBillingCycle();
        whmcsLoginAndSupportTicketForm();
        openWhmcsTicket();
        whmcsClientarea();
        whmcsGetInvoices();
        whmcsGetCreditBalance();
        whmcsUsageStatistics();
        whmcsServiceRenewalReminders();
        whmcsCustomDashboardWidgets();
        deleteQuote();
        createQuote();
        updateQuote();
    });

    //method to trigger service renewal reminders
    function whmcsServiceRenewalReminders(){
        $(document).on('click', '.whmcs-service-renewal-reminders-login', function(e){
            e.preventDefault();
            if($('.whmcs-login-email').val() != '' && $('.whmcs-login-password').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_validate_login',
                        email: $('.whmcs-login-email').val(),
                        password: $('.whmcs-login-password').val(),
                        shortcodeAction: 'serviceRenewalReminders'
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined && response.data === 'true'){
                            $(".loading-icon").hide();
                            $('.whmcs-login').hide();

                            Swal.fire({
                                title: "Success!",
                                text: 'Service Reminders have been configured.',
                                icon: "success"
                            });
                            
                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        });
    }

    //method to get credit balance information of whmcs user
    function whmcsGetCreditBalance(){
        $(document).on('click', '.whmcs-credit-balance-login', function(e){
            e.preventDefault();
            if($(this).parent().parent().find('.whmcs-login-email').val() != '' && $(this).parent().parent().find('.whmcs-login-password').val() != ''){
                $('.loading-icon').show();
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_credit_balance',
                        email: $(this).parent().parent().find('.whmcs-login-email').val(),
                        pwd: $(this).parent().parent().find('.whmcs-login-password').val()
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            
                            let content = `
                            
                                <div class="credit-balance-inner">
                                    <div class="whmcs-client-credit-balance-info">
                                        <table id="usr-credit-balance" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Credit ID</th>
                                                    <th>Date</th>
                                                    <th>Description</th>
                                                    <th>Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                            $(response.data).each(function(index, creditBalance){

                                                content += `
                                                    <tr>
                                                        <td>${creditBalance.id}</td>
                                                        <td>${creditBalance.date}</td>
                                                        <td>${creditBalance.description}</td>
                                                        <td>${creditBalance.amount}</td>
                                                    </tr>
                                                `
                                            });
                                                
                                            content += `</tbody>
                                        </table>
                                    </div>
                                </div>
                            `;

                            $('.loading-icon').hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-credit-balance-wrapper').append(content);
                            $('#usr-credit-balance').DataTable();
                        } else if(response.success === false && response.data != undefined){
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                Swal.fire({
                    title: "Oops!",
                    text: "You need to add valid email and password.",
                    icon: "error"
                });
            }
        });
    }

    //method to get all invoices of user
    function whmcsGetInvoices(){
        $(document).on('click', '.whmcs-invoice-login', function(e){
            e.preventDefault();
            if($(this).parent().parent().find('.whmcs-login-email').val() != '' && $(this).parent().parent().find('.whmcs-login-password').val() != ''){
                $('.loading-icon').show();
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_invoices',
                        email: $(this).parent().parent().find('.whmcs-login-email').val(),
                        pwd: $(this).parent().parent().find('.whmcs-login-password').val()
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            
                            let content = `
                            
                                <div class="invoices-inner">
                                    <div class="whmcs-client-invoices-info">
                                        <table id="usr-invoices" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th> Invoice# </th>
                                                    <th>First Name</th>
                                                    <th>Last Name</th>
                                                    <th>Date</th>
                                                    <th>Due Date</th>
                                                    <th>Payment method</th>
                                                    <th>Status</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                            $(response.data).each(function(index, invoice){

                                                content += `
                                                    <tr>
                                                        <td>${invoice.id}</td>
                                                        <td>${invoice.firstname}</td>
                                                        <td>${invoice.lastname}</td>
                                                        <td>${invoice.date}</td>
                                                        <td>${invoice.duedate}</td>
                                                        <td>${invoice.paymentmethod}</td>
                                                        <td>${invoice.status}</td>
                                                        <td>${invoice.total}</td>
                                                    </tr>
                                                `
                                            });
                                                
                                            content += `</tbody>
                                        </table>
                                    </div>
                                </div>

                            `;

                            $('.loading-icon').hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-invoices-wrapper').append(content);
                            $('#usr-invoices').DataTable();
                        } else if(response.success === false && response.data != undefined){
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                Swal.fire({
                    title: "Oops!",
                    text: "You need to add valid email and password.",
                    icon: "error"
                });
            }
        });
    }

    //method to add some extra JS for the shortcodes
    function extraJsForShortcodes(){
        //domain register, transfer buttons href
        $(document).on('click', '.whmcs-ajax-register, .whmcs-ajax-transfer', function(e){
            e.preventDefault();
            if($(this).data('value') === 'register'){
                if($.trim($('[name="ajax-domain-search"]').val()) != ''){
                    window.location.href = urls_to_frontend.whmcsSync + '?ccce=cart&a=add&domain=register&query='+$.trim($('[name="ajax-domain-search"]').val())+'';
                }
            } else if($(this).data('value') === 'transfer'){
                if($.trim($('[name="ajax-domain-search"]').val()) != ''){
                    window.location.href = urls_to_frontend.whmcsSync + '?ccce=cart&a=add&domain=transfer&query='+$.trim($('[name="ajax-domain-search"]').val())+'';
                }
            }
        });

        //order service listing
        $(document).on('click', '#whmcs-order-service-listing', function(e){
            e.preventDefault();
            // let selectedBillingCycle = $('input[name="billing-cycle"]:checked + label').text();
            let selectedBillingProduct = $('.whmcs-service-listing-select option:selected').data('p-url');
            if(selectedBillingProduct != undefined && selectedBillingProduct != ''){
                // Use the URL constructor to extract the pathname
                let url = new URL(selectedBillingProduct);
                // Get the value of the rp parameter
                let rpValue = url.searchParams.get("rp");
                window.location.href = urls_to_frontend.whmcsSync + '?ccce=index&rp='+rpValue+'';
            }
        });

        if($('#whmcs-get-quotes-table').length > 0){
            $('#whmcs-get-quotes-table').DataTable();
        }

        $('#user-dropdown').selectize();
        $('#addproduct').selectize();
        
    }

    //method to redirect user to the register/tranfer whmcs page
    function domainRegisterAndTransferRedirect(){
        //redirect user to domain search page if user tries to search domain through shortcode field
        $(document).on('click', '.whmcs-btn', function(e){
            e.preventDefault();
            if($(this).prev().val() != ''){
                if(whmcs_data.created_whmcs_page === 'true'){
                    window.location.href = urls_to_frontend.whmcsSync + '?ccce=cart&a=add&domain=register&query='+$(this).prev().val()+'';
                } else {
                    Swal.fire({
                        title: "Oops!",
                        text: "Something went wrong! Your WHMCS-Sync is not configured correctly.",
                        icon: "error"
                    });
                }
            } else {
                Swal.fire({
                    title: "Oops!",
                    text: "You need to add domain first!",
                    icon: "error"
                });
            }
        });

        //redirect user to domain transfer page if user tries to transfer domain through shortcode field
        $(document).on('click', '.whmcs-transfer-btn', function(e){
            e.preventDefault();
            if($(this).prev().val() != ''){
                if(whmcs_data.created_whmcs_page === 'true'){
                    window.location.href = urls_to_frontend.whmcsSync + '?ccce=cart&a=add&domain=transfer&query='+$(this).prev().val()+'';
                } else {
                    Swal.fire({
                        title: "Oops!",
                        text: "Something went wrong! Your WHMCS-Sync is not configured correctly.",
                        icon: "error"
                    });
                }
            } else {
                Swal.fire({
                    title: "Oops!",
                    text: "You need to add domain first!",
                    icon: "error"
                });
            }
        });
    }

    //method to check if the WHMCS user is logged in or not
    function checkWhmcsUserLoggedInStatus(){
        if(whmcs_data.whmcs_page === 'true'){
            let whmcsUser = '';
            if($('#Primary_Navbar-Open_Ticket').length > 0){
                whmcsUser = 'loggedin';
            } else {
                whmcsUser = 'loggedout';
            }
            $.ajax({
                type: 'POST',
                url: urls_to_frontend.ajaxUrl,
                data: {
                    action: 'whmcs_login_status',
                    whmcsUser: whmcsUser
                },
                success: function(response) {
                    
                },
                error: function(error) {
                    return error
                }
            });
        }
    }

    //method to trigger ajax functionality against the AJAX domain search shortcode
    function triggerAjaxDomainSearch(){
        $(document).on('click', '[name="whmcs-ajax-search-shortcode"]', function(e){
            e.preventDefault();
            let searchedDomain = $.trim($('[name="ajax-domain-search"]').val());
            let domain = $('[name="whmcs-tlds"]').val();

            if(searchedDomain != ''){
                $(".loading-icon").show();
                // Define a regular expression pattern for valid domains
                // let domainPattern = /^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/;
                let content = '';

                // Check if the input matches the domain pattern
                // if (domainPattern.test(searchedDomain+'.'+domain)) {
                    $.ajax({
                        type: 'POST',
                        url: urls_to_frontend.ajaxUrl,
                        data: {
                            action: 'whmcs_ajax_domain_search',
                            domainName: searchedDomain+'.'+domain
                        },
                        success: function(response) {
                            if(response.success === false){
                                $(".loading-icon").hide();
                                Swal.fire({
                                    title: "Oops!",
                                    text: "Something went wrong!",
                                    icon: "error"
                                });
                            } else if(response.success === true && response.data != undefined){
                                if(response.data.response.result === 'success' && response.data.response.status === 'available'){
                                    $(".loading-icon").hide();
                                    content = `
                                        <div class="whmcs_available_domain">
                                            YES! domain ${searchedDomain+'.'+domain} is <span class="ajax-available-result"> available. </span>`;

                                            content += '<div class="card-wrapper">';
                                                let count = 1;
                                                $(response.data.register).each(function(index, domain) {
                                                    // Iterate over the properties of the domain object
                                                    for (let key in domain) {
                                                        if (domain.hasOwnProperty(key)) {
                                                            content += `
                                                                <div class="card-container">
                                                                    <div class="domain-period-price">
                                                                        <span class="domain-price">$${domain[key]}</span> 
                                                                        <span class="domain-period"> for 
                                                                        ${key} year </span>
                                                                    </div>
                                                                </div>
                                                            `;
                                                            count++;
                                                        }
                                                    }
                                                });

                                            content += `</div><div class="whmcs_register_available_domain">
                                                <input type="button" data-value="register" class="whmcs-ajax-register" value="Register Domain">
                                                <input type="button" data-value="transfer" class="whmcs-ajax-transfer" value="Transfer Domain">
                                            </div>
                                        </div>
                                    `;

                                    $('.whmcs_non_available_domain').remove();
                                    $('.whmcs_available_domain').remove();
                                    $('.whmcs-ajax-search-results').append(content);
                                    $('.whmcs-ajax-search-results').show();
                                } else {
                                    $(".loading-icon").hide();
                                    content = `
                                        <div class="whmcs_non_available_domain">
                                            Oops! domain ${searchedDomain} is <span class="ajax-not-available-result"> not available. </span>
                                        </div>
                                    `;
                                    $('.whmcs_available_domain').remove();
                                    $('.whmcs_non_available_domain').remove();
                                    $('.whmcs-ajax-search-results').append(content);
                                    $('.whmcs-ajax-search-results').show();
                                }
                            }
                        },
                        error: function(error) {
                            return error
                        }
                    });
                } else {
                    Swal.fire({
                        title: "Oops!",
                        text: "Please enter a valid domain.",
                        icon: "error"
                    });
                }
                
            // } else {
            //     Swal.fire({
            //         title: "Oops!",
            //         text: "You need to add domain first!",
            //         icon: "error"
            //     });
            // }
        });
    }

    //method to get billing cycle of selected product
    function showWhmcsGetProductBillingCycle(){
        $(document).on('change', '.whmcs-service-listing-select', function(){
            $(".service-loading-icon").show();
            $.ajax({
                type: 'POST',
                url: urls_to_frontend.ajaxUrl,
                data: {
                    action: 'whmcs_product_billing_cycle',
                    whmcsProduct: $(this).find(':selected').text(),
                },
                success: function(response) {
                    if(response.success === true && response.data != undefined){
                        $(".service-loading-icon").hide();
                        let content = '';
                        $('.billing-products').empty();
                        $('.billing-products').append(response.data.desc);
                        $.each(response.data.billing_cycle_arr, function(index, item) {
                            content += `
                                <option> <strong>${item.name}</strong> <small>$${item.price}</small> </option>
                            `;
                        });
                        $('.whmcs-billing-cycles').html(content);
                    }
                },
                error: function(error) {
                    $(".service-loading-icon").hide();
                    return error
                }
            });
        });
    }

    //method to trigger clientarea ajax
    function whmcsClientarea(){
        $(document).on('click', '.whmcs-validate-login', function(e){
            e.preventDefault();
            $(".loading-icon").show();
            if($('.whmcs-login-email').val() != '' && $('.whmcs-login-password').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_clientarea',
                        email: $('.whmcs-login-email').val(),
                        password: $('.whmcs-login-password').val()
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            $(".loading-icon").hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-clientarea-wrapper').show();

                            // console.log(response.data.client_products); return
                            let content = `
                            
                                <div class="clientarea-inner">
                                    <div class="whmcs-client-info">
                                        <table id="clientarea-usr-info" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Full Name</th>
                                                    <th>Company</th>
                                                    <th>Address</th>
                                                    <th>Country</th>
                                                    <th>Email</th>
                                                    <th>State</th>
                                                    <th>Phone Number</th>
                                                    <th>Post Code</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${response.data.client_info.fullname}</td>
                                                    <td>${response.data.client_info.companyname}</td>
                                                    <td>${response.data.client_info.address1}</td>
                                                    <td>${response.data.client_info.countryname}</td>
                                                    <td>${response.data.client_info.email}</td>
                                                    <td>${response.data.client_info.state}</td>
                                                    <td>${response.data.client_info.telephoneNumber}</td>
                                                    <td>${response.data.client_info.postcode}</td>
                                                    <td>${response.data.client_info.status}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="whmcs-client-products">
                                        <table id="clientarea-usr-products" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order #</th>
                                                    <th>Billing Cycle</th>
                                                    <th>Domain Name</th>
                                                    <th>Amount</th>
                                                    <th>Group Name</th>
                                                    <th>Product Name</th>
                                                    <th>Payment Method</th>
                                                    <th>Status</th>
                                                    <th>Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                                $(response.data.client_products.product).each(function(index, product){
                                                    content += `
                                                        <tr>
                                                            <td>${product.orderid}</td>
                                                            <td>${product.billingcycle}</td>
                                                            <td>${product.domain}</td>
                                                            <td>${product.firstpaymentamount}</td>
                                                            <td>${product.groupname}</td>
                                                            <td>${product.name}</td>
                                                            <td>${product.paymentmethodname}</td>
                                                            <td>${product.status}</td>
                                                            <td>${product.regdate}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>

                                    <div class="whmcs-client-domains">
                                        <table id="whmcs-client-domains" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order#</th>
                                                    <th>Registration Type</th>
                                                    <th>Domain Name</th>
                                                    <th>Period</th>
                                                    <th>Amount</th>
                                                    <th>Payment Method</th>
                                                    <th>Next due date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;
                                                $(response.data.domains).each(function(index, domain){
                                                    content += `
                                                        <tr>
                                                            <td>${domain.orderid}</td>
                                                            <td>${domain.regtype}</td>
                                                            <td>${domain.domainname}</td>
                                                            <td>${domain.regperiod}</td>
                                                            <td>${domain.firstpaymentamount}</td>
                                                            <td>${domain.paymentmethodname}</td>
                                                            <td>${domain.nextduedate}</td>
                                                            <td>${domain.status}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>
                                </div>
                            `;

                            $('.whmcs-clientarea-wrapper').append(content);

                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        });
    }

    //method to show login and support ticket submission forms
    function whmcsLoginAndSupportTicketForm(){
        $(document).on('click', '.whmcs-login-support-ticket', function(e){
            e.preventDefault();
            $(".loading-icon").show();
            if($('.whmcs-login-email').val() != '' && $('.whmcs-login-password').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_validate_login',
                        email: $('.whmcs-login-email').val(),
                        password: $('.whmcs-login-password').val()
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            let content = '';
                            $(".loading-icon").hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-support-ticket-wrapper').show();

                            content += `
                                <form action="" method="post" enctype="multipart/form-data">
                                    <label for="department">Department:</label>
                                    <select id="department" name="department" required>`;
                                        $(response.data.department_list.department).each(function(index, dept){
                                            content += '<option value="'+dept.id+'">'+dept.name+'</option>';
                                        });
                                    content += `</select>
                                    <br>
                                
                                    <label for="subject">Subject:</label>
                                    <input type="text" id="subject" name="subject" required>
                                    <br>
                                
                                    <label for="message">Message:</label>
                                    <textarea id="message" name="message" rows="4" required></textarea>
                                    <br>
                                
                                    <label for="priority">Priority:</label>
                                    <select id="priority" name="priority" required>
                                        <option value="high">High</option>
                                        <option value="medium">Medium</option>
                                        <option value="low">Low</option>
                                    </select>
                                    <br>
                                
                                    <input type="submit" name="whmcs-open-ticket" class="whmcs-open-ticket" value="Submit">
                                    <div class="loading-icon" style="display: none;">
                                        <i class="fas fa-spinner fa-spin"></i>
                                        Loading...
                                    </div>
                                </form>
                            `;

                            $('.whmcs-support-ticket-wrapper').append(content);
                            
                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        });
    }

    //method to trigger ajax to open WHMCS ticket
    function openWhmcsTicket(){
        $(document).on('click', '[name="whmcs-open-ticket"]', function(e){
            e.preventDefault();
            $('.loading-icon').show();
            if($('#subject').val() != '' && $('#message').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_open_ticket',
                        deptId: $('#department').val(),
                        subject: $('#subject').val(),
                        message: $('#message').val(),
                        priority: $('#priority').val()
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Success!",
                                text: response.data.message,
                                icon: "success"
                            });
                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        });
    }

    //method to trigger usage statistics
    function whmcsUsageStatistics(){
        $(document).on('click', '.whmcs-usage-statistics-login', function (e){
            e.preventDefault();
            if($('.whmcs-login-email').val() != '' && $('.whmcs-login-password').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_validate_login',
                        email: $('.whmcs-login-email').val(),
                        password: $('.whmcs-login-password').val(),
                        shortcodeAction: 'usageStatistics'
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            let content = '';
                            $(".loading-icon").hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-usage-statistics-wrapper').show();

                            content += `
                                <div class="usage-statistics-inner">
                                    <div class="whmcs-client-info">
                                        <table id="usage-statistics" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order#</th>
                                                    <th>Registration Type</th>
                                                    <th>Domain Name</th>
                                                    <th>Period</th>
                                                    <th>Amount</th>
                                                    <th>Payment Method</th>
                                                    <th>Next due date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;
                                                $(response.data.domains).each(function(index, domain){
                                                    content += `
                                                        <tr>
                                                            <td>${domain.orderid}</td>
                                                            <td>${domain.regtype}</td>
                                                            <td>${domain.domainname}</td>
                                                            <td>${domain.regperiod}</td>
                                                            <td>${domain.firstpaymentamount}</td>
                                                            <td>${domain.paymentmethodname}</td>
                                                            <td>${domain.nextduedate}</td>
                                                            <td>${domain.status}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="whmcs-client-products">
                                        <table id="clientarea-usr-products" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order #</th>
                                                    <th>Billing Cycle</th>
                                                    <th>Domain Name</th>
                                                    <th>Amount</th>
                                                    <th>Group Name</th>
                                                    <th>Product Name</th>
                                                    <th>Payment Method</th>
                                                    <th>Status</th>
                                                    <th>Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                                $(response.data.products).each(function(index, product){
                                                    content += `
                                                        <tr>
                                                            <td>${product.orderid}</td>
                                                            <td>${product.billingcycle}</td>
                                                            <td>${product.domain}</td>
                                                            <td>${product.firstpaymentamount}</td>
                                                            <td>${product.groupname}</td>
                                                            <td>${product.name}</td>
                                                            <td>${product.paymentmethodname}</td>
                                                            <td>${product.status}</td>
                                                            <td>${product.regdate}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>
                                </div>
                            `;

                            $('.whmcs-usage-statistics-wrapper').append(content);
                            
                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        })
    }

    //method to render content for the custom dashboard widgets shortcode
    function whmcsCustomDashboardWidgets(){
        $(document).on('click', '.whmcs-custom-dashboard', function(e){
            e.preventDefault();
            if($('.whmcs-login-email').val() != '' && $('.whmcs-login-password').val() != ''){
                $.ajax({
                    type: 'POST',
                    url: urls_to_frontend.ajaxUrl,
                    data: {
                        action: 'whmcs_validate_login',
                        email: $('.whmcs-login-email').val(),
                        password: $('.whmcs-login-password').val(),
                        shortcodeAction: 'customDashboardWidgets'
                    },
                    success: function(response) {
                        if(response.success === true && response.data != undefined){
                            let content = '';
                            $(".loading-icon").hide();
                            $('.whmcs-login').hide();
                            $('.whmcs-usage-statistics-wrapper').show();

                            content += `
                                <div class="usage-statistics-inner">
                                    <div class="whmcs-client-info">
                                        <table id="usage-statistics" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order#</th>
                                                    <th>Registration Type</th>
                                                    <th>Domain Name</th>
                                                    <th>Period</th>
                                                    <th>Amount</th>
                                                    <th>Payment Method</th>
                                                    <th>Next due date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;
                                                $(response.data.domains).each(function(index, domain){
                                                    content += `
                                                        <tr>
                                                            <td>${domain.orderid}</td>
                                                            <td>${domain.regtype}</td>
                                                            <td>${domain.domainname}</td>
                                                            <td>${domain.regperiod}</td>
                                                            <td>${domain.firstpaymentamount}</td>
                                                            <td>${domain.paymentmethodname}</td>
                                                            <td>${domain.nextduedate}</td>
                                                            <td>${domain.status}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="whmcs-client-products">
                                        <table id="clientarea-usr-products" class="tbl whmcs-tbl">
                                            <thead>
                                                <tr>
                                                    <th>Order #</th>
                                                    <th>Billing Cycle</th>
                                                    <th>Domain Name</th>
                                                    <th>Amount</th>
                                                    <th>Group Name</th>
                                                    <th>Product Name</th>
                                                    <th>Payment Method</th>
                                                    <th>Status</th>
                                                    <th>Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                                $(response.data.products).each(function(index, product){
                                                    content += `
                                                        <tr>
                                                            <td>${product.orderid}</td>
                                                            <td>${product.billingcycle}</td>
                                                            <td>${product.domain}</td>
                                                            <td>${product.firstpaymentamount}</td>
                                                            <td>${product.groupname}</td>
                                                            <td>${product.name}</td>
                                                            <td>${product.paymentmethodname}</td>
                                                            <td>${product.status}</td>
                                                            <td>${product.regdate}</td>
                                                        </tr>
                                                    `;
                                                });
                                            content += `</tbody>
                                        </table>
                                    </div>
                                </div>
                            `;

                            $('.whmcs-usage-statistics-wrapper').append(content);
                            
                        } else if(response.success === false){
                            $(".loading-icon").hide();
                            Swal.fire({
                                title: "Oops!",
                                text: response.data.message,
                                icon: "error"
                            });
                        }
                    },
                    error: function(error) {
                        return error
                    }
                });
            } else {
                $(".loading-icon").hide();
                Swal.fire({
                    title: "Oops!",
                    text: "Please fill required fields!",
                    icon: "error"
                });
            }
        });
    }

    //method to delete quote
    function deleteQuote(){
        $(document).on('click', '.delete-quote', function(e){
            e.preventDefault();
            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
              }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'POST',
                        url: urls_to_frontend.ajaxUrl,
                        data: {
                            action: 'whmcs_delete_quote',
                            quoteId: $(this).data('quote-id') ? $(this).data('quote-id') : ''
                        },
                        success: function(response) {
                            if(response.success === true && response.data != undefined){
                                Swal.fire({
                                    title: "Success!",
                                    text: response.data.message,
                                    icon: "success"
                                });
                            } else if(response.success === false){
                                Swal.fire({
                                    title: "Oops!",
                                    text: response.data.message,
                                    icon: "error"
                                });
                            }
                        },
                        error: function(error) {
                            return error
                        }
                    });
                }
            });
        })
    }

    //method to create quote
    function createQuote(){
        $(document).on('click', '.create-quote', function(e){
            e.preventDefault();
            $('.create-quote-wrapper').show();
        });

        $(document).on('change', '[name="client-type"]', function(e){
            if($(this).val() === 'new'){
                $('#new-client-form').show();
            } else {
                $('#new-client-form').hide();
            }
        });

        $('#addproduct').on('change', function(){
            // Get selected option
            let selectedOption = $(this).find('option:selected');
            let productName = selectedOption.text();
            let unitPrice = parseFloat(selectedOption.val()); // Convert unit price to a floating-point number
        
            let newRow = $('<tr class="quote-products">').append(
                $('<td>').append(
                    $('<input>').attr({
                        type: 'text',
                        name: 'add_qty[]', // Changed to array notation
                        value: '1',
                        class: 'form-control'
                    })
                ),
                $('<td>').append(
                    $('<textarea>').attr({
                        name: 'add_desc[]', // Changed to array notation
                        id: 'add_desc',
                        rows: '1',
                        class: 'expanding form-control'
                    }).text(productName)
                ),
                $('<td>').append(
                    $('<input>').attr({
                        type: 'text',
                        name: 'add_up[]', // Changed to array notation
                        value: unitPrice.toFixed(2), // Set unit price with 2 decimal places
                        class: 'form-control'
                    })
                ),
                $('<td>').append(
                    $('<input>').attr({
                        type: 'text',
                        name: 'add_discount[]',
                        value: '0.00',
                        class: 'form-control'
                    })
                ),
                $('<td>'),
                $('<td>').append(
                    $('<input>').attr({
                        type: 'checkbox',
                        name: 'add_taxable[]',
                        value: '1'
                    })
                ),
                $('<td>')
            );
        
            $('.quote-products:last').after(newRow);
        
            // Calculate subtotal and update subtotal row
            updateSubtotal();
        });
        
        //method to update total
        function updateSubtotal() {
            var subtotal = 0;
        
            // Iterate over each row with class quote-products
            $('.quote-products').each(function() {
                var unitPrice = parseFloat($(this).find('[name="add_up[]"]').val()); // Get unit price from each row
                if (!isNaN(unitPrice)) {
                    subtotal += unitPrice; // Add unit price to subtotal
                }
            });
        
            // Update subtotal row with the calculated subtotal
            $('.quote-total').text(subtotal.toFixed(2)); // Set subtotal with 2 decimal places
        }
    }

    //method to update quote
    function updateQuote(){
        if (window.location.href.indexOf("quote") > -1 && window.location.href.indexOf("quote-id") > -1) {
            $('.create-quote-wrapper').show();
            $('.create-quote').hide();
        }        
    }

})(jQuery);