<?php

namespace WPBULKY\Admin;

use WPBULKY\Includes\Data;

defined( 'ABSPATH' ) || exit;

class Admin {

	protected static $instance = null;

	public function __construct() {
		add_action( 'admin_init', [ $this, 'save_settings' ] );
		add_action( 'admin_menu', [ $this, 'admin_menu' ] );

	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self : self::$instance;
	}

	public function admin_menu() {
		$settings = Settings::instance();

		add_menu_page(
			esc_html__( 'WordPress Bulk Edit Post Types', 'wpbulky' ),
			esc_html__( 'WPBulky', 'wpbulky' ),
			WPBULKY_CONST['capability'],
			'vi_wpbulky_settings',
			'',
			'dashicons-media-spreadsheet',
			40
		);

		add_submenu_page( 'vi_wpbulky_settings',
			esc_html__( 'Settings', 'wpbulky' ),
			esc_html__( 'Settings', 'wpbulky' ),
			WPBULKY_CONST['capability'],
			'vi_wpbulky_settings',
			[ $settings, 'setting_page' ]
		);

		$post_types     = Data::get_param( 'post_types' );
		$obj_post_types = get_post_types( [ 'show_ui' => true ], 'objects' );

		if ( ! empty( $post_types ) && is_array( $post_types ) ) {
			foreach ( $post_types as $post_type ) {

				$post_type_data = $obj_post_types[ $post_type ] ?? '';
				if ( ! $post_type_data ) {
					continue;
				}

				$label = $post_type_data->label;

				add_submenu_page(
					'vi_wpbulky_settings',
					"{$label} editor",
					"{$label}",
					WPBULKY_CONST['capability'],
					"vi_wpbulky_edit_{$post_type}",
					[ Editor::instance(), 'editor' ]
				);
			}
		}

	}

	public function setting_page() {
		include_once WPBULKY_CONST['admin_dir'] . 'views/html-settings.php';
	}

	public function save_settings() {
		if ( isset( $_POST['vi_wpbulky_save_settings'], $_POST['_wpnonce'] ) && $_POST['vi_wpbulky_save_settings'] == 'save_settings'
		     && wp_verify_nonce( $_POST['_wpnonce'], 'vi_wpbulky_nonce' ) && current_user_can( 'manage_options' )
		) {
			$auto_update_key = ! empty( $_POST['vi_wpbulky_auto_update_key'] ) ? sanitize_text_field( $_POST['vi_wpbulky_auto_update_key'] ) : '';
			update_option( 'vi_wpbulky_auto_update_key', $auto_update_key );
		}
	}
}