/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-09-02 08:00:40 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=72062 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_play_block_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `notifier_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_related_id` int(11) NOT NULL,
  `action` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `date_notified` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4802 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1247 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "3", "like_count", "1");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_commentmeta` VALUES("3", "8", "like_count", "1");
INSERT INTO `wp_commentmeta` VALUES("4", "8", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_commentmeta` VALUES("17", "27", "dislike_count", "1");
INSERT INTO `wp_commentmeta` VALUES("18", "27", "dislike_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_commentmeta` VALUES("19", "27", "like_count", "1");
INSERT INTO `wp_commentmeta` VALUES("20", "27", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_commentmeta` VALUES("53", "6", "like_count", "1");
INSERT INTO `wp_commentmeta` VALUES("54", "6", "like_user", "a:1:{i:0;i:12;}");
INSERT INTO `wp_commentmeta` VALUES("55", "6", "dislike_count", "0");
INSERT INTO `wp_commentmeta` VALUES("56", "6", "dislike_user", "a:0:{}");
INSERT INTO `wp_commentmeta` VALUES("57", "4", "like_count", "1");
INSERT INTO `wp_commentmeta` VALUES("58", "4", "like_user", "a:1:{i:0;i:9;}");
INSERT INTO `wp_commentmeta` VALUES("69", "34", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("70", "34", "_wp_trash_meta_time", "1725263920");
INSERT INTO `wp_commentmeta` VALUES("71", "33", "_wp_trash_meta_status", "0");
INSERT INTO `wp_commentmeta` VALUES("72", "33", "_wp_trash_meta_time", "1725263922");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "148", "کمال", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "222.212.126.182", "2020-11-05 06:07:20", "2020-11-05 02:37:20", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("4", "394", "حمید", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "173.0.55.66", "2020-12-08 23:40:47", "2020-12-08 20:10:47", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("5", "394", "رضا", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "173.0.55.66", "2020-12-08 23:41:14", "2020-12-08 20:11:14", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "4", "1");
INSERT INTO `wp_comments` VALUES("6", "420", "محمد", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "173.0.55.66", "2020-12-08 23:42:52", "2020-12-08 20:12:52", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("7", "420", "علی", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "173.0.55.66", "2020-12-08 23:43:04", "2020-12-08 20:13:04", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.\n", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("8", "476", "کامران", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "222.212.125.187", "2020-11-11 03:11:07", "2020-11-10 23:41:07", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("9", "476", "علیرضا", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "222.212.125.187", "2020-11-11 03:11:39", "2020-11-10 23:41:39", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("25", "480", "محمد", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "222.212.124.147", "2020-10-29 02:18:40", "2020-10-28 22:48:40", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("26", "480", "زیبا", "hey@flatfull.com", "http://music.flatfull.com/soundwave", "222.212.124.147", "2020-10-29 02:25:50", "2020-10-28 22:55:50", "عالی بود", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("27", "223", "هم ترانه", "wpnovin.ir@gmail.com", "https://themes.wpnovin.com/Waveme", "93.118.185.0", "2022-01-02 01:30:16", "2022-01-01 22:00:16", "سلام از هم ترانه...", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.110 Safari/537.36", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("28", "611", "مستر آرت", "nourifans@gmail.com", "", "95.162.242.108", "2022-01-17 19:08:40", "2022-01-17 15:38:40", "عالی", "0", "spam", "Mozilla/5.0 (Linux; Android 10; Nokia 6.2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "242", "imohawwad", "imohawwad@gmail.com", "", "193.176.86.60", "2022-06-20 18:28:01", "2022-06-20 13:58:01", "SALAM", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36", "comment", "0", "16");
INSERT INTO `wp_comments` VALUES("30", "1206", "طراحی سایت", "wpnovin.ir@gmail.com", "https://iloweb.ir", "2.187.168.196", "2022-08-02 11:54:26", "2022-08-02 07:24:26", "طراحی سایت موزیک بهتر از این ندیدم", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "145", "ایلو وب", "wpnovin.ir@gmail.com", "https://iloweb.ir", "2.187.168.196", "2022-08-02 11:57:05", "2022-08-02 07:27:05", "https://iloweb.ir\r\n\r\n<a href=\"https://iloweb.ir\" rel=\"nofollow ugc\">Telegram</a>", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "145", "طراحی سایت ایلو وب", "wpnovin.ir@gmail.com", "https://iloweb.ir", "2.187.168.196", "2022-08-02 11:58:59", "2022-08-02 07:28:59", "https://iloweb.ir\r\n<a href=\"https://telegram.me/share/url?url=https%3A%2F%2Fwpnovin.com%2Fproduct%2Fwaveme-music-platform-wordpress-theme%2F\" rel=\"nofollow ugc\"></a>", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("33", "178", "hessam", "starsite.iran@gmail.com", "", "78.163.161.139", "2023-08-30 14:05:13", "2023-08-30 10:35:13", "good", "0", "spam", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36", "comment", "0", "40");
INSERT INTO `wp_comments` VALUES("34", "610", "12", "12@gmail.com", "", "5.22.11.206", "2024-04-04 20:45:50", "2024-04-04 17:15:50", "سلام", "0", "spam", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:124.0) Gecko/20100101 Firefox/124.0", "comment", "0", "58");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20220108_d987d985d8aad8b1d8a7d986d987", "cd10051f87c62a7d8026_20240902080029", "21", "2024-09-02 08:00:40", "Waveme", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-02 08:00:29\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:37:\"20220108_d987d985d8aad8b1d8a7d986d987\";s:4:\"Hash\";s:35:\"cd10051f87c62a7d8026_20240902080029\";s:8:\"NameHash\";s:73:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:6:\"Waveme\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/themeswpn/public_html/Waveme\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:609;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4302;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-02 08:00:29\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20220108_d987d985d8aad8b1d8a7d986d987\";s:4:\"Hash\";s:35:\"cd10051f87c62a7d8026_20240902080029\";s:8:\"NameHash\";s:73:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/themeswpn/public_html/Waveme/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:153:\"/home/themeswpn/public_html/Waveme/wp-content/backups-dup-lite/tmp/20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/themeswpn/public_html/Waveme/wp-admin\";i:1;s:46:\"/home/themeswpn/public_html/Waveme/wp-includes\";i:2;s:55:\"/home/themeswpn/public_html/Waveme/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/themeswpn/public_html/Waveme\";i:1;s:34:\"/home/themeswpn/public_html/Waveme\";i:2;s:45:\"/home/themeswpn/public_html/Waveme/wp-content\";i:3;s:53:\"/home/themeswpn/public_html/Waveme/wp-content/uploads\";i:4;s:53:\"/home/themeswpn/public_html/Waveme/wp-content/plugins\";i:5;s:56:\"/home/themeswpn/public_html/Waveme/wp-content/mu-plugins\";i:6;s:52:\"/home/themeswpn/public_html/Waveme/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/themeswpn/public_html/Waveme/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://themes.wpnovin.com/Waveme", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://themes.wpnovin.com/Waveme", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "هم ترانه", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "پوسته وردپرس آهنگ و آلبوم وردپرس", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "wpnovin.ir@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "Y-m-d", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i A", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:157:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:20:\"^embed/([a-z0-9]+)/?\";s:27:\"index.php?embed=$matches[1]\";s:11:\"stations/?$\";s:27:\"index.php?post_type=station\";s:41:\"stations/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=station&feed=$matches[1]\";s:36:\"stations/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=station&feed=$matches[1]\";s:28:\"stations/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=station&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"station/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"station/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"station/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"station/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"station/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"station/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"station/([^/]+)/embed/?$\";s:40:\"index.php?station=$matches[1]&embed=true\";s:28:\"station/([^/]+)/trackback/?$\";s:34:\"index.php?station=$matches[1]&tb=1\";s:48:\"station/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?station=$matches[1]&feed=$matches[2]\";s:43:\"station/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?station=$matches[1]&feed=$matches[2]\";s:36:\"station/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?station=$matches[1]&paged=$matches[2]\";s:43:\"station/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?station=$matches[1]&cpage=$matches[2]\";s:33:\"station/([^/]+)/stream(/(.*))?/?$\";s:48:\"index.php?station=$matches[1]&stream=$matches[3]\";s:28:\"station/([^/]+)/d(/(.*))?/?$\";s:43:\"index.php?station=$matches[1]&d=$matches[3]\";s:32:\"station/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?station=$matches[1]&page=$matches[2]\";s:24:\"station/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"station/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"station/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"station/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"station/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"station/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"artist/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?artist=$matches[1]&feed=$matches[2]\";s:42:\"artist/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?artist=$matches[1]&feed=$matches[2]\";s:23:\"artist/([^/]+)/embed/?$\";s:39:\"index.php?artist=$matches[1]&embed=true\";s:35:\"artist/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?artist=$matches[1]&paged=$matches[2]\";s:17:\"artist/([^/]+)/?$\";s:28:\"index.php?artist=$matches[1]\";s:46:\"genre/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:41:\"genre/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:22:\"genre/([^/]+)/embed/?$\";s:38:\"index.php?genre=$matches[1]&embed=true\";s:34:\"genre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?genre=$matches[1]&paged=$matches[2]\";s:16:\"genre/([^/]+)/?$\";s:27:\"index.php?genre=$matches[1]\";s:45:\"mood/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?mood=$matches[1]&feed=$matches[2]\";s:40:\"mood/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?mood=$matches[1]&feed=$matches[2]\";s:21:\"mood/([^/]+)/embed/?$\";s:37:\"index.php?mood=$matches[1]&embed=true\";s:33:\"mood/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?mood=$matches[1]&paged=$matches[2]\";s:15:\"mood/([^/]+)/?$\";s:26:\"index.php?mood=$matches[1]\";s:49:\"activity/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?activity=$matches[1]&feed=$matches[2]\";s:44:\"activity/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?activity=$matches[1]&feed=$matches[2]\";s:25:\"activity/([^/]+)/embed/?$\";s:41:\"index.php?activity=$matches[1]&embed=true\";s:37:\"activity/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?activity=$matches[1]&paged=$matches[2]\";s:19:\"activity/([^/]+)/?$\";s:30:\"index.php?activity=$matches[1]\";s:52:\"station-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?station_tag=$matches[1]&feed=$matches[2]\";s:47:\"station-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?station_tag=$matches[1]&feed=$matches[2]\";s:28:\"station-tag/([^/]+)/embed/?$\";s:44:\"index.php?station_tag=$matches[1]&embed=true\";s:40:\"station-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?station_tag=$matches[1]&paged=$matches[2]\";s:22:\"station-tag/([^/]+)/?$\";s:33:\"index.php?station_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=11&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:45:\"user/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:40:\"user/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:21:\"user/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:33:\"user/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"user/([^/]+)/stations(/(.*))?/?$\";s:54:\"index.php?author_name=$matches[1]&stations=$matches[3]\";s:30:\"user/([^/]+)/albums(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&albums=$matches[3]\";s:33:\"user/([^/]+)/playlists(/(.*))?/?$\";s:55:\"index.php?author_name=$matches[1]&playlists=$matches[3]\";s:29:\"user/([^/]+)/likes(/(.*))?/?$\";s:51:\"index.php?author_name=$matches[1]&likes=$matches[3]\";s:33:\"user/([^/]+)/followers(/(.*))?/?$\";s:55:\"index.php?author_name=$matches[1]&followers=$matches[3]\";s:33:\"user/([^/]+)/following(/(.*))?/?$\";s:55:\"index.php?author_name=$matches[1]&following=$matches[3]\";s:32:\"user/([^/]+)/download(/(.*))?/?$\";s:54:\"index.php?author_name=$matches[1]&download=$matches[3]\";s:31:\"user/([^/]+)/profile(/(.*))?/?$\";s:53:\"index.php?author_name=$matches[1]&profile=$matches[3]\";s:30:\"user/([^/]+)/upload(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&upload=$matches[3]\";s:37:\"user/([^/]+)/notifications(/(.*))?/?$\";s:59:\"index.php?author_name=$matches[1]&notifications=$matches[3]\";s:30:\"user/([^/]+)/logout(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&logout=$matches[3]\";s:41:\"user/([^/]+)/delete-my-account(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&delete-my-account=$matches[3]\";s:15:\"user/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/stream(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&stream=$matches[3]\";s:20:\"([^/]+)/d(/(.*))?/?$\";s:40:\"index.php?name=$matches[1]&d=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:29:\"Novin-Fonts/font-uploader.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:25:\"loop-block/loop-block.php\";i:4;s:25:\"play-block/play-block.php\";i:5;s:53:\"widget-importer-exporter/widget-importer-exporter.php\";i:6;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "waveme", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "waveme", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "13", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "11", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "1590", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1656592876", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:13:{i:1725266477;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1725280149;a:1:{s:37:\"puc_cron_check_updates_theme-studiare\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725280170;a:1:{s:35:\"puc_cron_check_updates_theme-waveme\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725280877;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725280900;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725280901;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1725302614;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725304419;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1725432215;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725799277;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1725877800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1726344658;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1641040907;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("132", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"wpnovin.ir@gmail.com\";s:7:\"version\";s:5:\"6.6.1\";s:9:\"timestamp\";i:1721766516;}", "off");
INSERT INTO `wp_options` VALUES("141", "current_theme", "Waveme", "yes");
INSERT INTO `wp_options` VALUES("142", "theme_mods_waveme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:5:{s:7:\"primary\";i:99;s:9:\"secondary\";i:100;s:4:\"user\";i:97;s:12:\"before_login\";i:98;s:11:\"after_login\";i:97;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("143", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("149", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("152", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "site_theme", "dark", "yes");
INSERT INTO `wp_options` VALUES("176", "page_animate", "1", "yes");
INSERT INTO `wp_options` VALUES("177", "page_footer", "35", "yes");
INSERT INTO `wp_options` VALUES("178", "page_sidebar", "39", "yes");
INSERT INTO `wp_options` VALUES("179", "page_sidenav", "1547", "yes");
INSERT INTO `wp_options` VALUES("184", "recovery_mode_email_last_sent", "1641043077", "yes");
INSERT INTO `wp_options` VALUES("187", "new_admin_email", "wpnovin.ir@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("188", "envato_purchase_code", "ssss", "yes");
INSERT INTO `wp_options` VALUES("203", "hide_site_title", "0", "yes");
INSERT INTO `wp_options` VALUES("205", "fu_header_font", "KalamehFaNum-Black.ttf", "yes");
INSERT INTO `wp_options` VALUES("206", "fu_lists_font", "KalamehFaNum-Medium.ttf", "yes");
INSERT INTO `wp_options` VALUES("207", "fu_body_font", "KalamehFaNum-Regular.ttf", "yes");
INSERT INTO `wp_options` VALUES("208", "fu_custom_one_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("209", "fu_custom_one", "", "yes");
INSERT INTO `wp_options` VALUES("210", "fu_custom_two_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("211", "fu_custom_two", "", "yes");
INSERT INTO `wp_options` VALUES("212", "fu_custom_three_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("213", "fu_custom_three", "", "yes");
INSERT INTO `wp_options` VALUES("214", "fu_custom_four_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("215", "fu_custom_four", "", "yes");
INSERT INTO `wp_options` VALUES("216", "fu_custom_five_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("217", "fu_custom_five", "", "yes");
INSERT INTO `wp_options` VALUES("218", "fu_google_font_urls", "", "yes");
INSERT INTO `wp_options` VALUES("219", "fu_google_header_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("220", "fu_google_body_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("221", "fu_google_lists_font_name", "", "yes");
INSERT INTO `wp_options` VALUES("222", "fu_ie_header_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("223", "fu_ie_lists_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("224", "fu_ie_body_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("225", "fu_ie_custom_one", "", "yes");
INSERT INTO `wp_options` VALUES("226", "fu_ie_custom_one_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("227", "fu_ie_custom_two", "", "yes");
INSERT INTO `wp_options` VALUES("228", "fu_ie_custom_two_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("229", "fu_ie_custom_three", "", "yes");
INSERT INTO `wp_options` VALUES("230", "fu_ie_custom_three_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("231", "fu_ie_custom_four", "", "yes");
INSERT INTO `wp_options` VALUES("232", "fu_ie_custom_four_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("233", "fu_ie_custom_five", "", "yes");
INSERT INTO `wp_options` VALUES("234", "fu_ie_custom_five_font", "Choose a font", "yes");
INSERT INTO `wp_options` VALUES("235", "fu_header_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("236", "fu_lists_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("237", "fu_body_font_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("238", "fu_custom_one_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("239", "fu_custom_one_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("240", "fu_custom_two_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("241", "fu_custom_two_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("242", "fu_custom_three_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("243", "fu_custom_three_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("244", "fu_custom_four_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("245", "fu_custom_four_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("246", "fu_custom_five_size_element", "", "yes");
INSERT INTO `wp_options` VALUES("247", "fu_custom_five_size", "Choose a size", "yes");
INSERT INTO `wp_options` VALUES("261", "wpp_settings", "a:16:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:20:\"disable_widget_block\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:8:\"dev_mode\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";}", "yes");
INSERT INTO `wp_options` VALUES("262", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("263", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("272", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("281", "play_settings", "a:6:{s:10:\"hide_admin\";s:1:\"0\";s:14:\"show_admin_bar\";s:1:\"1\";s:11:\"page_upload\";s:4:\"1116\";s:13:\"page_download\";s:4:\"1118\";s:10:\"page_login\";s:2:\"48\";s:9:\"page_rank\";s:2:\"12\";}", "yes");
INSERT INTO `wp_options` VALUES("322", "genre_children", "a:2:{i:45;a:17:{i:0;i:52;i:1;i:55;i:2;i:62;i:3;i:74;i:4;i:78;i:5;i:80;i:6;i:82;i:7;i:83;i:8;i:85;i:9;i:86;i:10;i:87;i:11;i:88;i:12;i:90;i:13;i:91;i:14;i:92;i:15;i:93;i:16;i:94;}i:50;a:11:{i:0;i:60;i:1;i:64;i:2;i:67;i:3;i:68;i:4;i:70;i:5;i:79;i:6;i:81;i:7;i:84;i:8;i:89;i:9;i:95;i:10;i:96;}}", "yes");
INSERT INTO `wp_options` VALUES("335", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("347", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":4,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("412", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.10.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:3;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("413", "duplicator_version_plugin", "1.5.10.2", "yes");
INSERT INTO `wp_options` VALUES("415", "puc_external_updates_theme-studiare", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1641644949;s:14:\"checkedVersion\";s:3:\"6.2\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:8:\"studiare\";s:7:\"version\";s:5:\"1.0.2\";s:12:\"download_url\";s:139:\"http://cdn.wpnovin.com/dl3/Files/Themes/studiare/studiareSDFGH5H6G4FDS465S568KJHV46545456465asd4f65gh8hgfd465a465sdf8g479jhg879fd886685.zip\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:1:\"#\";}s:11:\"updateClass\";s:21:\"Puc_v4p6_Theme_Update\";s:15:\"updateBaseClass\";s:12:\"Theme_Update\";}", "no");
INSERT INTO `wp_options` VALUES("417", "puc_external_updates_theme-waveme", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1725263900;s:14:\"checkedVersion\";s:3:\"4.1\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:6:\"waveme\";s:7:\"version\";s:3:\"8.0\";s:12:\"download_url\";s:120:\"http://cdn.wpnovin.com/dl3/Files/Themes/waveme/wavemesdfgh5j46kj6h45g6456ASDFGH4J87K9JHG46F5DS6A54A6S5D4FGH645465465.zip\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:1:\"#\";}s:11:\"updateClass\";s:21:\"Puc_v4p6_Theme_Update\";s:15:\"updateBaseClass\";s:12:\"Theme_Update\";}", "off");
INSERT INTO `wp_options` VALUES("418", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-02 08:00:29\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20220108_d987d985d8aad8b1d8a7d986d987\";s:4:\"Hash\";s:35:\"cd10051f87c62a7d8026_20240902080029\";s:8:\"NameHash\";s:73:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/themeswpn/public_html/Waveme\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:609;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4302;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-02 08:00:29\";s:7:\"Version\";s:8:\"1.5.10.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.11.9\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20220108_d987d985d8aad8b1d8a7d986d987\";s:4:\"Hash\";s:35:\"cd10051f87c62a7d8026_20240902080029\";s:8:\"NameHash\";s:73:\"20220108_d987d985d8aad8b1d8a7d986d987_cd10051f87c62a7d8026_20240902080029\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/themeswpn/public_html/Waveme/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/themeswpn/public_html/Waveme/wp-admin\";i:1;s:46:\"/home/themeswpn/public_html/Waveme/wp-includes\";i:2;s:55:\"/home/themeswpn/public_html/Waveme/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/themeswpn/public_html/Waveme\";i:1;s:34:\"/home/themeswpn/public_html/Waveme\";i:2;s:45:\"/home/themeswpn/public_html/Waveme/wp-content\";i:3;s:53:\"/home/themeswpn/public_html/Waveme/wp-content/uploads\";i:4;s:53:\"/home/themeswpn/public_html/Waveme/wp-content/plugins\";i:5;s:56:\"/home/themeswpn/public_html/Waveme/wp-content/mu-plugins\";i:6;s:52:\"/home/themeswpn/public_html/Waveme/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/themeswpn/public_html/Waveme/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("781", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("15631", "user_count", "34", "off");
INSERT INTO `wp_options` VALUES("60315", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("71976", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1725805800", "off");
INSERT INTO `wp_options` VALUES("71977", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("71984", "_site_transient_timeout_available_translations", "1725218173", "off");
INSERT INTO `wp_options` VALUES("71985", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.8\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.8/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-22 13:29:21\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.25/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-16 06:53:48\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:11:07\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-18 17:26:41\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-23 09:49:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 17:44:28\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-18 01:45:49\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 20:44:09\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.6.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 07:47:37\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 20:44:05\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-29 10:55:14\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-29 10:55:35\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.6.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-02 13:40:02\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 21:41:14\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-11 10:54:13\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-23 06:54:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-13 10:48:39\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-11 10:55:12\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-26 07:43:00\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 11:49:39\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-26 09:32:30\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-28 23:24:21\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 19:05:01\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.15/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.20/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 13:29:14\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-06-02 15:48:46\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-31 22:44:39\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:15:28\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-20 07:24:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-31 21:15:41\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-17 06:59:43\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-21 15:21:05\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-01 06:52:39\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.32\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.32/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-24 18:18:49\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-18 16:12:48\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-15 14:30:21\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 11:59:33\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-15 07:15:06\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-12 07:15:01\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.20/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-01 17:47:37\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 05:28:18\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-24 01:25:58\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-29 07:13:57\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:21:01\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.8\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.8/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 20:34:23\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:22:32\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.14\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.14/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-21 18:30:52\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 22:00:20\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-27 08:08:42\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-29 15:49:05\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-22 04:34:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.33\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.33/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 07:51:49\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 07:51:40\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-26 17:36:49\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-21 08:36:21\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 20:43:45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.15/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 12:19:43\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-28 16:16:47\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-08 11:06:53\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:29:20\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-20 14:19:52\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:29:45\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.9/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.24/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 17:49:29\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-10 11:39:01\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.15/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-28 15:28:54\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-02 11:13:39\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-21 10:37:10\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("72046", "_site_transient_timeout_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "1725868586", "off");
INSERT INTO `wp_options` VALUES("72047", "_site_transient_browser_b9cbd8dc13f19f9e7eb854f472bfa274", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"109.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("72048", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("72049", "_site_transient_timeout_theme_roots", "1725265700", "off");
INSERT INTO `wp_options` VALUES("72050", "_site_transient_theme_roots", "a:2:{s:12:\"waveme-child\";s:7:\"/themes\";s:6:\"waveme\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("72052", "duplicator_install_info", "a:3:{s:7:\"version\";s:7:\"1.5.2.1\";s:4:\"time\";i:1676747882;s:10:\"updateTime\";i:1725263916;}", "off");
INSERT INTO `wp_options` VALUES("72053", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("72054", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("72055", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"=8SU_jn,Ycq3nHLXqtKR&rFN7oXWQCZ8rXA4tO4nQ5NO\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 118,\n    \"siteNumFiles\": 4911,\n    \"siteDbSizeMB\": 2.220000000000000195399252334027551114559173583984375,\n    \"siteDbNumTables\": 14\n}", "auto");
INSERT INTO `wp_options` VALUES("72056", "_site_transient_timeout_wp_theme_files_patterns-602865ad1f42d8eb90ea7e31de05c065", "1725265716", "off");
INSERT INTO `wp_options` VALUES("72057", "_site_transient_wp_theme_files_patterns-602865ad1f42d8eb90ea7e31de05c065", "a:2:{s:7:\"version\";s:3:\"4.1\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("72058", "duplicator_notifications", "a:4:{s:6:\"update\";i:1725263916;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("72059", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.6.1.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.6.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.6.1\";s:7:\"version\";s:5:\"6.6.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1725263916;s:15:\"version_checked\";s:5:\"6.6.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("72060", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1725263916;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.10.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.10.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:53:\"widget-importer-exporter/widget-importer-exporter.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/widget-importer-exporter\";s:4:\"slug\";s:24:\"widget-importer-exporter\";s:6:\"plugin\";s:53:\"widget-importer-exporter/widget-importer-exporter.php\";s:11:\"new_version\";s:5:\"1.6.1\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/widget-importer-exporter/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/widget-importer-exporter.1.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/widget-importer-exporter/assets/icon-256x256.jpg?rev=990577\";s:2:\"1x\";s:76:\"https://ps.w.org/widget-importer-exporter/assets/icon-128x128.jpg?rev=990577\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/widget-importer-exporter/assets/banner-1544x500.jpg?rev=775677\";s:2:\"1x\";s:78:\"https://ps.w.org/widget-importer-exporter/assets/banner-772x250.jpg?rev=741218\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:5:\"4.0.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-parsidate.4.0.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=2044005\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}}}", "off");
INSERT INTO `wp_options` VALUES("72061", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1725263917;s:7:\"checked\";a:2:{s:12:\"waveme-child\";s:0:\"\";s:6:\"waveme\";s:3:\"4.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");

/* INSERT TABLE DATA: wp_play_block_notifications */
INSERT INTO `wp_play_block_notifications` VALUES("1", "0", "1", "27", "0", "like", "", "2022-01-01 22:00:22", "0");
INSERT INTO `wp_play_block_notifications` VALUES("2", "1", "2", "172", "0", "like", "", "2022-01-01 22:50:58", "1");
INSERT INTO `wp_play_block_notifications` VALUES("3", "1", "2", "0", "0", "follow", "", "2022-01-01 22:51:00", "1");
INSERT INTO `wp_play_block_notifications` VALUES("4", "1", "3", "180", "0", "like", "", "2022-01-08 08:00:26", "0");
INSERT INTO `wp_play_block_notifications` VALUES("5", "1", "5", "148", "0", "like", "", "2022-01-08 13:48:03", "0");
INSERT INTO `wp_play_block_notifications` VALUES("6", "1", "6", "0", "0", "follow", "", "2022-01-08 15:00:09", "0");
INSERT INTO `wp_play_block_notifications` VALUES("7", "1", "7", "290", "0", "like", "", "2022-01-09 10:51:37", "0");
INSERT INTO `wp_play_block_notifications` VALUES("8", "1", "7", "0", "0", "follow", "", "2022-01-09 10:51:44", "0");
INSERT INTO `wp_play_block_notifications` VALUES("9", "1", "9", "0", "0", "follow", "", "2022-02-09 06:51:17", "0");
INSERT INTO `wp_play_block_notifications` VALUES("10", "1", "10", "1185", "0", "like", "", "2022-02-17 09:41:19", "0");
INSERT INTO `wp_play_block_notifications` VALUES("11", "1", "12", "0", "0", "follow", "", "2022-03-26 04:45:55", "0");
INSERT INTO `wp_play_block_notifications` VALUES("12", "1", "12", "1185", "0", "download", "", "2022-03-26 04:48:05", "0");
INSERT INTO `wp_play_block_notifications` VALUES("13", "1", "12", "1185", "0", "like", "", "2022-03-26 04:50:15", "0");
INSERT INTO `wp_play_block_notifications` VALUES("14", "0", "12", "6", "0", "like", "", "2022-03-31 16:07:06", "0");
INSERT INTO `wp_play_block_notifications` VALUES("15", "1", "13", "174", "0", "like", "", "2022-04-08 10:13:08", "0");
INSERT INTO `wp_play_block_notifications` VALUES("16", "1", "14", "0", "0", "follow", "", "2022-05-16 21:15:54", "0");
INSERT INTO `wp_play_block_notifications` VALUES("17", "1", "16", "0", "0", "follow", "", "2022-06-20 09:32:55", "0");
INSERT INTO `wp_play_block_notifications` VALUES("18", "1", "16", "480", "0", "like", "", "2022-06-20 09:33:29", "0");
INSERT INTO `wp_play_block_notifications` VALUES("19", "1", "9", "176", "0", "download", "", "2022-06-20 13:52:12", "0");
INSERT INTO `wp_play_block_notifications` VALUES("20", "0", "9", "4", "0", "like", "", "2022-06-20 14:14:44", "0");
INSERT INTO `wp_play_block_notifications` VALUES("21", "1", "9", "148", "0", "like", "", "2022-06-21 10:46:46", "0");
INSERT INTO `wp_play_block_notifications` VALUES("22", "1", "17", "223", "0", "like", "", "2022-06-27 01:50:06", "0");
INSERT INTO `wp_play_block_notifications` VALUES("23", "1", "0", "1206", "0", "comment", "طراحی سایت موزیک بهتر از این ندیدم", "2022-08-02 07:24:27", "0");
INSERT INTO `wp_play_block_notifications` VALUES("24", "1", "19", "0", "0", "follow", "", "2022-10-07 05:39:25", "0");
INSERT INTO `wp_play_block_notifications` VALUES("25", "1", "20", "0", "0", "follow", "", "2022-10-28 13:53:47", "0");
INSERT INTO `wp_play_block_notifications` VALUES("26", "1", "20", "1185", "0", "like", "", "2022-10-28 13:55:13", "0");
INSERT INTO `wp_play_block_notifications` VALUES("27", "1", "24", "157", "0", "like", "", "2023-02-02 07:41:23", "0");
INSERT INTO `wp_play_block_notifications` VALUES("28", "1", "24", "0", "0", "follow", "", "2023-02-02 07:41:33", "0");
INSERT INTO `wp_play_block_notifications` VALUES("29", "1", "25", "1185", "0", "like", "", "2023-02-06 19:59:19", "0");
INSERT INTO `wp_play_block_notifications` VALUES("30", "1", "25", "0", "0", "follow", "", "2023-02-06 19:59:49", "0");
INSERT INTO `wp_play_block_notifications` VALUES("31", "1", "9", "176", "0", "like", "", "2023-02-12 20:30:14", "0");
INSERT INTO `wp_play_block_notifications` VALUES("32", "1", "26", "186", "0", "download", "", "2023-02-14 13:38:04", "0");
INSERT INTO `wp_play_block_notifications` VALUES("33", "1", "26", "610", "0", "like", "", "2023-02-14 15:29:40", "0");
INSERT INTO `wp_play_block_notifications` VALUES("34", "1", "9", "174", "0", "like", "", "2023-03-01 09:21:23", "0");
INSERT INTO `wp_play_block_notifications` VALUES("35", "1", "28", "0", "0", "follow", "", "2023-03-15 13:43:22", "0");
INSERT INTO `wp_play_block_notifications` VALUES("36", "1", "31", "0", "0", "follow", "", "2023-04-01 12:44:43", "0");
INSERT INTO `wp_play_block_notifications` VALUES("37", "1", "32", "0", "0", "follow", "", "2023-04-04 18:19:27", "0");
INSERT INTO `wp_play_block_notifications` VALUES("38", "1", "32", "1185", "0", "download", "", "2023-04-05 15:56:52", "0");
INSERT INTO `wp_play_block_notifications` VALUES("39", "1", "34", "480", "0", "download", "", "2023-05-26 07:20:59", "0");
INSERT INTO `wp_play_block_notifications` VALUES("40", "1", "34", "1185", "0", "download", "", "2023-05-26 07:21:17", "0");
INSERT INTO `wp_play_block_notifications` VALUES("41", "1", "36", "148", "0", "like", "", "2023-06-21 07:09:14", "0");
INSERT INTO `wp_play_block_notifications` VALUES("42", "1", "36", "237", "0", "like", "", "2023-06-21 07:10:41", "0");
INSERT INTO `wp_play_block_notifications` VALUES("43", "1", "36", "237", "0", "download", "", "2023-06-21 07:10:50", "0");
INSERT INTO `wp_play_block_notifications` VALUES("44", "1", "36", "178", "0", "like", "", "2023-06-21 08:20:22", "0");
INSERT INTO `wp_play_block_notifications` VALUES("45", "1", "36", "0", "0", "follow", "", "2023-06-21 09:00:13", "0");
INSERT INTO `wp_play_block_notifications` VALUES("46", "1", "36", "223", "0", "like", "", "2023-06-22 14:42:31", "0");
INSERT INTO `wp_play_block_notifications` VALUES("47", "1", "36", "221", "0", "like", "", "2023-06-22 14:43:53", "0");
INSERT INTO `wp_play_block_notifications` VALUES("48", "1", "36", "222", "0", "like", "", "2023-06-22 14:44:30", "0");
INSERT INTO `wp_play_block_notifications` VALUES("49", "1", "37", "1185", "0", "download", "", "2023-07-24 09:05:42", "0");
INSERT INTO `wp_play_block_notifications` VALUES("50", "1", "37", "157", "0", "like", "", "2023-07-24 09:09:17", "0");
INSERT INTO `wp_play_block_notifications` VALUES("51", "1", "37", "178", "0", "like", "", "2023-07-24 09:09:18", "0");
INSERT INTO `wp_play_block_notifications` VALUES("52", "1", "38", "1185", "0", "like", "", "2023-08-18 11:10:49", "0");
INSERT INTO `wp_play_block_notifications` VALUES("53", "1", "42", "237", "0", "download", "", "2023-09-04 20:35:38", "0");
INSERT INTO `wp_play_block_notifications` VALUES("54", "1", "42", "0", "0", "follow", "", "2023-09-04 21:01:06", "0");
INSERT INTO `wp_play_block_notifications` VALUES("55", "1", "42", "1185", "0", "download", "", "2023-09-04 21:05:56", "0");
INSERT INTO `wp_play_block_notifications` VALUES("56", "1", "46", "766", "0", "like", "", "2023-11-15 19:05:35", "0");
INSERT INTO `wp_play_block_notifications` VALUES("57", "1", "46", "0", "0", "follow", "", "2023-11-15 19:08:03", "0");
INSERT INTO `wp_play_block_notifications` VALUES("58", "1", "46", "1185", "0", "download", "", "2023-11-15 19:08:17", "0");
INSERT INTO `wp_play_block_notifications` VALUES("59", "1", "46", "610", "0", "like", "", "2023-11-15 19:08:56", "0");
INSERT INTO `wp_play_block_notifications` VALUES("60", "1", "46", "611", "0", "like", "", "2023-11-15 19:20:00", "0");
INSERT INTO `wp_play_block_notifications` VALUES("61", "1", "46", "609", "0", "like", "", "2023-11-15 19:24:57", "0");
INSERT INTO `wp_play_block_notifications` VALUES("62", "1", "49", "0", "0", "follow", "", "2023-12-16 17:19:40", "0");
INSERT INTO `wp_play_block_notifications` VALUES("63", "1", "49", "176", "0", "download", "", "2023-12-16 17:23:09", "0");
INSERT INTO `wp_play_block_notifications` VALUES("64", "1", "48", "0", "0", "follow", "", "2023-12-19 21:11:31", "0");
INSERT INTO `wp_play_block_notifications` VALUES("65", "1", "50", "480", "0", "download", "", "2023-12-21 09:35:42", "0");
INSERT INTO `wp_play_block_notifications` VALUES("66", "1", "50", "148", "0", "like", "", "2023-12-21 09:35:49", "0");
INSERT INTO `wp_play_block_notifications` VALUES("67", "1", "52", "148", "0", "like", "", "2024-02-17 03:55:26", "0");
INSERT INTO `wp_play_block_notifications` VALUES("68", "1", "52", "0", "0", "follow", "", "2024-02-17 03:57:31", "0");
INSERT INTO `wp_play_block_notifications` VALUES("69", "1", "55", "1185", "0", "download", "", "2024-02-28 10:48:51", "0");
INSERT INTO `wp_play_block_notifications` VALUES("70", "1", "56", "480", "0", "like", "", "2024-03-20 12:46:41", "0");
INSERT INTO `wp_play_block_notifications` VALUES("71", "1", "56", "1185", "0", "like", "", "2024-03-20 12:47:18", "0");
INSERT INTO `wp_play_block_notifications` VALUES("72", "1", "57", "1185", "0", "download", "", "2024-03-23 11:05:49", "0");
INSERT INTO `wp_play_block_notifications` VALUES("73", "1", "59", "609", "0", "like", "", "2024-04-09 15:34:20", "0");
INSERT INTO `wp_play_block_notifications` VALUES("74", "1", "59", "174", "0", "like", "", "2024-04-09 15:59:41", "0");
INSERT INTO `wp_play_block_notifications` VALUES("75", "1", "60", "148", "0", "like", "", "2024-04-29 20:57:40", "0");
INSERT INTO `wp_play_block_notifications` VALUES("76", "1", "60", "0", "0", "follow", "", "2024-04-29 21:01:03", "0");
INSERT INTO `wp_play_block_notifications` VALUES("77", "1", "60", "172", "0", "like", "", "2024-04-29 21:05:01", "0");
INSERT INTO `wp_play_block_notifications` VALUES("78", "1", "60", "203", "0", "download", "", "2024-04-29 21:19:51", "0");
INSERT INTO `wp_play_block_notifications` VALUES("79", "1", "62", "174", "0", "like", "", "2024-05-16 19:30:51", "0");
INSERT INTO `wp_play_block_notifications` VALUES("80", "1", "62", "178", "0", "like", "", "2024-05-16 21:44:47", "0");
INSERT INTO `wp_play_block_notifications` VALUES("81", "1", "63", "178", "0", "like", "", "2024-06-04 11:10:41", "0");
INSERT INTO `wp_play_block_notifications` VALUES("82", "1", "63", "0", "0", "follow", "", "2024-06-04 11:13:12", "0");
INSERT INTO `wp_play_block_notifications` VALUES("83", "1", "64", "1185", "0", "like", "", "2024-06-04 23:02:54", "0");
INSERT INTO `wp_play_block_notifications` VALUES("84", "1", "52", "480", "0", "like", "", "2024-06-04 23:10:35", "0");
INSERT INTO `wp_play_block_notifications` VALUES("85", "1", "52", "480", "0", "download", "", "2024-06-04 23:10:44", "0");
INSERT INTO `wp_play_block_notifications` VALUES("86", "1", "64", "1185", "0", "download", "", "2024-06-04 23:15:03", "0");
INSERT INTO `wp_play_block_notifications` VALUES("87", "1", "64", "223", "0", "like", "", "2024-06-04 23:25:16", "0");
INSERT INTO `wp_play_block_notifications` VALUES("88", "1", "64", "148", "0", "like", "", "2024-06-04 23:25:46", "0");
INSERT INTO `wp_play_block_notifications` VALUES("89", "1", "65", "1206", "0", "like", "", "2024-06-07 16:35:27", "0");
INSERT INTO `wp_play_block_notifications` VALUES("90", "1", "65", "610", "0", "like", "", "2024-06-07 16:37:51", "0");
INSERT INTO `wp_play_block_notifications` VALUES("91", "1", "65", "174", "0", "like", "", "2024-06-07 16:38:59", "0");
INSERT INTO `wp_play_block_notifications` VALUES("92", "1", "65", "0", "0", "follow", "", "2024-06-07 16:40:49", "0");
INSERT INTO `wp_play_block_notifications` VALUES("93", "1", "65", "1185", "0", "like", "", "2024-06-07 16:43:19", "0");
INSERT INTO `wp_play_block_notifications` VALUES("94", "1", "64", "218", "0", "like", "", "2024-06-26 19:09:21", "0");
INSERT INTO `wp_play_block_notifications` VALUES("95", "1", "52", "176", "0", "like", "", "2024-07-03 01:35:42", "0");
INSERT INTO `wp_play_block_notifications` VALUES("96", "1", "52", "159", "0", "like", "", "2024-07-03 01:35:44", "0");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("7", "500", "_wp_attached_file", "2020/09/Artboard-1.png");
INSERT INTO `wp_postmeta` VALUES("8", "500", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9", "501", "_wp_attached_file", "2020/09/Artboard-2.png");
INSERT INTO `wp_postmeta` VALUES("10", "501", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-2.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11", "502", "_wp_attached_file", "2020/09/Artboard-3.png");
INSERT INTO `wp_postmeta` VALUES("12", "502", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-3.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-3-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13", "503", "_wp_attached_file", "2020/09/Artboard-4.png");
INSERT INTO `wp_postmeta` VALUES("14", "503", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-4.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-4-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15", "504", "_wp_attached_file", "2020/09/Artboard-5.png");
INSERT INTO `wp_postmeta` VALUES("16", "504", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-5.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-5-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("17", "505", "_wp_attached_file", "2020/09/Artboard-6.png");
INSERT INTO `wp_postmeta` VALUES("18", "505", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-6.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-6-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("19", "506", "_wp_attached_file", "2020/09/Artboard-7.png");
INSERT INTO `wp_postmeta` VALUES("20", "506", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-7.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-7-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-7-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("21", "507", "_wp_attached_file", "2020/09/Artboard-8.png");
INSERT INTO `wp_postmeta` VALUES("22", "507", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-8.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-8-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("23", "508", "_wp_attached_file", "2020/09/Artboard-9.png");
INSERT INTO `wp_postmeta` VALUES("24", "508", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:22:\"2020/09/Artboard-9.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Artboard-9-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Artboard-9-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("25", "509", "_wp_attached_file", "2020/09/Artboard-10.png");
INSERT INTO `wp_postmeta` VALUES("26", "509", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-10.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-10-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-10-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27", "510", "_wp_attached_file", "2020/09/Artboard-11.png");
INSERT INTO `wp_postmeta` VALUES("28", "510", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-11.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-11-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-11-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("29", "511", "_wp_attached_file", "2020/09/Artboard-12.png");
INSERT INTO `wp_postmeta` VALUES("30", "511", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-12.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-12-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-12-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("31", "512", "_wp_attached_file", "2020/09/Artboard-13.png");
INSERT INTO `wp_postmeta` VALUES("32", "512", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-13.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-13-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-13-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("33", "513", "_wp_attached_file", "2020/09/Artboard-14.png");
INSERT INTO `wp_postmeta` VALUES("34", "513", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-14.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-14-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-14-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("35", "514", "_wp_attached_file", "2020/09/Artboard-15.png");
INSERT INTO `wp_postmeta` VALUES("36", "514", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-15.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-15-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-15-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("37", "515", "_wp_attached_file", "2020/09/Artboard-16.png");
INSERT INTO `wp_postmeta` VALUES("38", "515", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-16.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-16-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-16-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("39", "516", "_wp_attached_file", "2020/09/Artboard-17.png");
INSERT INTO `wp_postmeta` VALUES("40", "516", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-17.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-17-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-17-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("41", "517", "_wp_attached_file", "2020/09/Artboard-18.png");
INSERT INTO `wp_postmeta` VALUES("42", "517", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-18.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-18-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-18-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("43", "518", "_wp_attached_file", "2020/09/Artboard-19.png");
INSERT INTO `wp_postmeta` VALUES("44", "518", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-19.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-19-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-19-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("45", "519", "_wp_attached_file", "2020/09/Artboard-20.png");
INSERT INTO `wp_postmeta` VALUES("46", "519", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-20.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-20-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-20-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("47", "520", "_wp_attached_file", "2020/09/Artboard-21.png");
INSERT INTO `wp_postmeta` VALUES("48", "520", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-21.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-21-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-21-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("49", "521", "_wp_attached_file", "2020/09/Artboard-22.png");
INSERT INTO `wp_postmeta` VALUES("50", "521", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-22.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-22-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-22-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("51", "522", "_wp_attached_file", "2020/09/Artboard-23.png");
INSERT INTO `wp_postmeta` VALUES("52", "522", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-23.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-23-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-23-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("53", "523", "_wp_attached_file", "2020/09/Artboard-24.png");
INSERT INTO `wp_postmeta` VALUES("54", "523", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-24.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-24-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-24-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("55", "524", "_wp_attached_file", "2020/09/Artboard-25.png");
INSERT INTO `wp_postmeta` VALUES("56", "524", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-25.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-25-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-25-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("57", "525", "_wp_attached_file", "2020/09/Artboard-26.png");
INSERT INTO `wp_postmeta` VALUES("58", "525", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-26.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-26-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-26-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("59", "526", "_wp_attached_file", "2020/09/Artboard-27.png");
INSERT INTO `wp_postmeta` VALUES("60", "526", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-27.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-27-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-27-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("61", "527", "_wp_attached_file", "2020/09/Artboard-28.png");
INSERT INTO `wp_postmeta` VALUES("62", "527", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-28.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-28-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-28-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("63", "528", "_wp_attached_file", "2020/09/Artboard-29.png");
INSERT INTO `wp_postmeta` VALUES("64", "528", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-29.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-29-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-29-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("65", "529", "_wp_attached_file", "2020/09/Artboard-30.png");
INSERT INTO `wp_postmeta` VALUES("66", "529", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-30.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-30-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-30-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("67", "530", "_wp_attached_file", "2020/09/Artboard-31.png");
INSERT INTO `wp_postmeta` VALUES("68", "530", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-31.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-31-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-31-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("69", "531", "_wp_attached_file", "2020/09/Artboard-32.png");
INSERT INTO `wp_postmeta` VALUES("70", "531", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-32.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-32-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-32-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("71", "532", "_wp_attached_file", "2020/09/Artboard-33.png");
INSERT INTO `wp_postmeta` VALUES("72", "532", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-33.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-33-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-33-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("73", "533", "_wp_attached_file", "2020/09/Artboard-34.png");
INSERT INTO `wp_postmeta` VALUES("74", "533", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-34.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-34-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-34-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("75", "534", "_wp_attached_file", "2020/09/Artboard-35.png");
INSERT INTO `wp_postmeta` VALUES("76", "534", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-35.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-35-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-35-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("77", "535", "_wp_attached_file", "2020/09/Artboard-36.png");
INSERT INTO `wp_postmeta` VALUES("78", "535", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-36.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-36-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-36-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("79", "536", "_wp_attached_file", "2020/09/Artboard-37.png");
INSERT INTO `wp_postmeta` VALUES("80", "536", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-37.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-37-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-37-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("81", "537", "_wp_attached_file", "2020/09/Artboard-38.png");
INSERT INTO `wp_postmeta` VALUES("82", "537", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-38.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-38-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-38-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("83", "538", "_wp_attached_file", "2020/09/Artboard-39.png");
INSERT INTO `wp_postmeta` VALUES("84", "538", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-39.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-39-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-39-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("85", "539", "_wp_attached_file", "2020/09/Artboard-40.png");
INSERT INTO `wp_postmeta` VALUES("86", "539", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-40.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-40-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-40-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("87", "540", "_wp_attached_file", "2020/09/Artboard-41.png");
INSERT INTO `wp_postmeta` VALUES("88", "540", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-41.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-41-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-41-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("89", "541", "_wp_attached_file", "2020/09/Artboard-42.png");
INSERT INTO `wp_postmeta` VALUES("90", "541", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-42.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-42-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-42-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("91", "542", "_wp_attached_file", "2020/09/Artboard-43.png");
INSERT INTO `wp_postmeta` VALUES("92", "542", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-43.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-43-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-43-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("93", "543", "_wp_attached_file", "2020/09/Artboard-44.png");
INSERT INTO `wp_postmeta` VALUES("94", "543", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-44.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-44-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-44-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("95", "544", "_wp_attached_file", "2020/09/Artboard-45.png");
INSERT INTO `wp_postmeta` VALUES("96", "544", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-45.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-45-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-45-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("97", "545", "_wp_attached_file", "2020/09/Artboard-46.png");
INSERT INTO `wp_postmeta` VALUES("98", "545", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-46.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-46-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-46-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("99", "546", "_wp_attached_file", "2020/09/Artboard-47.png");
INSERT INTO `wp_postmeta` VALUES("100", "546", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-47.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-47-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-47-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("101", "547", "_wp_attached_file", "2020/09/Artboard-48.png");
INSERT INTO `wp_postmeta` VALUES("102", "547", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-48.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-48-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-48-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("103", "548", "_wp_attached_file", "2020/09/Artboard-49.png");
INSERT INTO `wp_postmeta` VALUES("104", "548", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-49.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-49-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-49-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("105", "549", "_wp_attached_file", "2020/09/Artboard-50.png");
INSERT INTO `wp_postmeta` VALUES("106", "549", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-50.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-50-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-50-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("107", "550", "_wp_attached_file", "2020/09/Artboard-51.png");
INSERT INTO `wp_postmeta` VALUES("108", "550", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-51.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-51-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-51-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("109", "551", "_wp_attached_file", "2020/09/Artboard-52.png");
INSERT INTO `wp_postmeta` VALUES("110", "551", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-52.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-52-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-52-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("111", "552", "_wp_attached_file", "2020/09/Artboard-53.png");
INSERT INTO `wp_postmeta` VALUES("112", "552", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-53.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-53-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-53-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("113", "553", "_wp_attached_file", "2020/09/Artboard-54.png");
INSERT INTO `wp_postmeta` VALUES("114", "553", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/09/Artboard-54.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-54-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-54-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("115", "664", "_wp_attached_file", "2020/10/cropped-screenshot-1.png");
INSERT INTO `wp_postmeta` VALUES("116", "664", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:32:\"2020/10/cropped-screenshot-1.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"cropped-screenshot-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"cropped-screenshot-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("117", "664", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("118", "664", "_oembed_f571c6f9d924003b5edfeb0c01d334fc", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("119", "697", "_wp_attached_file", "2020/10/Artboard-55.png");
INSERT INTO `wp_postmeta` VALUES("120", "697", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-55.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-55-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-55-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("121", "698", "_wp_attached_file", "2020/10/Artboard-56.png");
INSERT INTO `wp_postmeta` VALUES("122", "698", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-56.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-56-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-56-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("123", "699", "_wp_attached_file", "2020/10/Artboard-57.png");
INSERT INTO `wp_postmeta` VALUES("124", "699", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-57.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-57-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-57-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("125", "700", "_wp_attached_file", "2020/10/Artboard-58.png");
INSERT INTO `wp_postmeta` VALUES("126", "700", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-58.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-58-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-58-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("127", "701", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("128", "701", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("129", "701", "_menu_item_object_id", "701");
INSERT INTO `wp_postmeta` VALUES("130", "701", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("131", "701", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("132", "701", "_menu_item_classes", "a:2:{i:0;s:11:\"icon-upload\";i:1;s:8:\"btn-link\";}");
INSERT INTO `wp_postmeta` VALUES("133", "701", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("134", "701", "_menu_item_url", "http://%site_url%/user/%user%/upload/");
INSERT INTO `wp_postmeta` VALUES("135", "702", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("136", "702", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("137", "702", "_menu_item_object_id", "702");
INSERT INTO `wp_postmeta` VALUES("138", "702", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("139", "702", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("140", "702", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("141", "702", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("142", "702", "_menu_item_url", "http://%site_url%/user/%user%/");
INSERT INTO `wp_postmeta` VALUES("143", "703", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("144", "703", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("145", "703", "_menu_item_object_id", "703");
INSERT INTO `wp_postmeta` VALUES("146", "703", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("147", "703", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("148", "703", "_menu_item_classes", "a:1:{i:0;s:15:\"icon-headphones\";}");
INSERT INTO `wp_postmeta` VALUES("149", "703", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("150", "703", "_menu_item_url", "http://%site_url%/user/%user%/");
INSERT INTO `wp_postmeta` VALUES("151", "704", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("152", "704", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("153", "704", "_menu_item_object_id", "704");
INSERT INTO `wp_postmeta` VALUES("154", "704", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("155", "704", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("156", "704", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("157", "704", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("158", "704", "_menu_item_url", "http://%site_url%/user/%user%/playlists/");
INSERT INTO `wp_postmeta` VALUES("159", "705", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("160", "705", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("161", "705", "_menu_item_object_id", "705");
INSERT INTO `wp_postmeta` VALUES("162", "705", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("163", "705", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("164", "705", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("165", "705", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("166", "705", "_menu_item_url", "http://%site_url%/user/%user%/likes/");
INSERT INTO `wp_postmeta` VALUES("167", "706", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("168", "706", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("169", "706", "_menu_item_object_id", "706");
INSERT INTO `wp_postmeta` VALUES("170", "706", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("171", "706", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("172", "706", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("173", "706", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("174", "706", "_menu_item_url", "http://%site_url%/user/%user%/followers/");
INSERT INTO `wp_postmeta` VALUES("175", "707", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("176", "707", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("177", "707", "_menu_item_object_id", "707");
INSERT INTO `wp_postmeta` VALUES("178", "707", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("179", "707", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("180", "707", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("181", "707", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("182", "707", "_menu_item_url", "http://%site_url%/user/%user%/following/");
INSERT INTO `wp_postmeta` VALUES("183", "708", "_wp_attached_file", "2020/10/Artboard-59.png");
INSERT INTO `wp_postmeta` VALUES("184", "708", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-59.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-59-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-59-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("185", "709", "_wp_attached_file", "2020/10/Artboard-60.png");
INSERT INTO `wp_postmeta` VALUES("186", "709", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-60.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-60-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-60-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("187", "710", "_wp_attached_file", "2020/10/Artboard-61.png");
INSERT INTO `wp_postmeta` VALUES("188", "710", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-61.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-61-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-61-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("189", "711", "_wp_attached_file", "2020/10/Artboard-62.png");
INSERT INTO `wp_postmeta` VALUES("190", "711", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-62.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-62-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-62-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("191", "712", "_wp_attached_file", "2020/10/Artboard-63.png");
INSERT INTO `wp_postmeta` VALUES("192", "712", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2020/10/Artboard-63.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Artboard-63-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Artboard-63-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("193", "863", "_wp_attached_file", "2020/11/Artboard.png");
INSERT INTO `wp_postmeta` VALUES("194", "863", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:900;s:4:\"file\";s:20:\"2020/11/Artboard.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Artboard-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"Artboard-1024x768.png\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Artboard-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"Artboard-768x576.png\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("195", "974", "_wp_attached_file", "2020/11/waveme-desktop.png");
INSERT INTO `wp_postmeta` VALUES("196", "974", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1600;s:4:\"file\";s:26:\"2020/11/waveme-desktop.png\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"waveme-desktop-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"waveme-desktop-1024x640.png\";s:5:\"width\";i:1024;s:6:\"height\";i:640;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"waveme-desktop-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"waveme-desktop-768x480.png\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:27:\"waveme-desktop-1536x960.png\";s:5:\"width\";i:1536;s:6:\"height\";i:960;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:28:\"waveme-desktop-2048x1280.png\";s:5:\"width\";i:2048;s:6:\"height\";i:1280;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("197", "977", "_wp_attached_file", "2020/11/waveme-iphone.png");
INSERT INTO `wp_postmeta` VALUES("198", "977", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:672;s:6:\"height\";i:1426;s:4:\"file\";s:25:\"2020/11/waveme-iphone.png\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"waveme-iphone-141x300.png\";s:5:\"width\";i:141;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"waveme-iphone-483x1024.png\";s:5:\"width\";i:483;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"waveme-iphone-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("199", "1314", "_wp_attached_file", "2020/12/Pexels-Videos-2022395.mp4");
INSERT INTO `wp_postmeta` VALUES("200", "1314", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:1133037;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:13;s:16:\"length_formatted\";s:4:\"0:13\";s:5:\"width\";i:640;s:6:\"height\";i:360;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:48000;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:1552671525;}");
INSERT INTO `wp_postmeta` VALUES("201", "1531", "_wp_attached_file", "2020/12/pexels-sound-on-3756943.jpg");
INSERT INTO `wp_postmeta` VALUES("202", "1531", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:1917;s:4:\"file\";s:35:\"2020/12/pexels-sound-on-3756943.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"pexels-sound-on-3756943-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"pexels-sound-on-3756943-684x1024.jpg\";s:5:\"width\";i:684;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"pexels-sound-on-3756943-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"pexels-sound-on-3756943-768x1150.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:37:\"pexels-sound-on-3756943-1026x1536.jpg\";s:5:\"width\";i:1026;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("203", "1532", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("204", "1532", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("205", "1532", "_menu_item_object_id", "1532");
INSERT INTO `wp_postmeta` VALUES("206", "1532", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("207", "1532", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("208", "1532", "_menu_item_classes", "a:1:{i:0;s:12:\"menu-divider\";}");
INSERT INTO `wp_postmeta` VALUES("209", "1532", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("210", "1532", "_menu_item_url", "http://%site_url%/user/%user%/logout/");
INSERT INTO `wp_postmeta` VALUES("211", "1533", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("212", "1533", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("213", "1533", "_menu_item_object_id", "1533");
INSERT INTO `wp_postmeta` VALUES("214", "1533", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("215", "1533", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("216", "1533", "_menu_item_classes", "a:1:{i:0;s:19:\"icon-playlist-audio\";}");
INSERT INTO `wp_postmeta` VALUES("217", "1533", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("218", "1533", "_menu_item_url", "http://%site_url%/user/%user%/playlists/");
INSERT INTO `wp_postmeta` VALUES("219", "1534", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("220", "1534", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("221", "1534", "_menu_item_object_id", "1534");
INSERT INTO `wp_postmeta` VALUES("222", "1534", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("223", "1534", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("224", "1534", "_menu_item_classes", "a:1:{i:0;s:13:\"icon-favorite\";}");
INSERT INTO `wp_postmeta` VALUES("225", "1534", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("226", "1534", "_menu_item_url", "http://%site_url%/user/%user%/likes/");
INSERT INTO `wp_postmeta` VALUES("227", "1535", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("228", "1535", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("229", "1535", "_menu_item_object_id", "1535");
INSERT INTO `wp_postmeta` VALUES("230", "1535", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("231", "1535", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("232", "1535", "_menu_item_classes", "a:1:{i:0;s:11:\"menu-header\";}");
INSERT INTO `wp_postmeta` VALUES("233", "1535", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("234", "1535", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("235", "1536", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("236", "1536", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("237", "1536", "_menu_item_object_id", "1536");
INSERT INTO `wp_postmeta` VALUES("238", "1536", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("239", "1536", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("240", "1536", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("241", "1536", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("242", "1536", "_menu_item_url", "http://%theme-color%");
INSERT INTO `wp_postmeta` VALUES("243", "1537", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("244", "1537", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("245", "1537", "_menu_item_object_id", "1537");
INSERT INTO `wp_postmeta` VALUES("246", "1537", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("247", "1537", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("248", "1537", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("249", "1537", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("250", "1537", "_menu_item_url", "http://%theme-switch%");
INSERT INTO `wp_postmeta` VALUES("251", "1538", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("252", "1538", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("253", "1538", "_menu_item_object_id", "1538");
INSERT INTO `wp_postmeta` VALUES("254", "1538", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("255", "1538", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("256", "1538", "_menu_item_classes", "a:1:{i:0;s:9:\"no-toggle\";}");
INSERT INTO `wp_postmeta` VALUES("257", "1538", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("258", "1538", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("259", "1539", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("260", "1539", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("261", "1539", "_menu_item_object_id", "1539");
INSERT INTO `wp_postmeta` VALUES("262", "1539", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("263", "1539", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("264", "1539", "_menu_item_classes", "a:3:{i:0;s:9:\"no-toggle\";i:1;s:9:\"menu-mega\";i:2;s:11:\"menu-mega-3\";}");
INSERT INTO `wp_postmeta` VALUES("265", "1539", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("266", "1539", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("267", "1540", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("268", "1540", "_menu_item_menu_item_parent", "1539");
INSERT INTO `wp_postmeta` VALUES("269", "1540", "_menu_item_object_id", "1540");
INSERT INTO `wp_postmeta` VALUES("270", "1540", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("271", "1540", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("272", "1540", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("273", "1540", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("274", "1540", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("275", "1541", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("276", "1541", "_menu_item_menu_item_parent", "1539");
INSERT INTO `wp_postmeta` VALUES("277", "1541", "_menu_item_object_id", "1541");
INSERT INTO `wp_postmeta` VALUES("278", "1541", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("279", "1541", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("280", "1541", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("281", "1541", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("282", "1541", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("283", "1542", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("284", "1542", "_menu_item_menu_item_parent", "1539");
INSERT INTO `wp_postmeta` VALUES("285", "1542", "_menu_item_object_id", "1542");
INSERT INTO `wp_postmeta` VALUES("286", "1542", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("287", "1542", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("288", "1542", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("289", "1542", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("290", "1542", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("291", "1543", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("292", "1543", "_menu_item_menu_item_parent", "1538");
INSERT INTO `wp_postmeta` VALUES("293", "1543", "_menu_item_object_id", "1543");
INSERT INTO `wp_postmeta` VALUES("294", "1543", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("295", "1543", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("296", "1543", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("297", "1543", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("298", "1543", "_menu_item_url", "http://wpnovin.com/shop");
INSERT INTO `wp_postmeta` VALUES("299", "1544", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("300", "1544", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("301", "1544", "_menu_item_object_id", "1544");
INSERT INTO `wp_postmeta` VALUES("302", "1544", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("303", "1544", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("304", "1544", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("305", "1544", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("306", "1544", "_menu_item_url", "http://%site_url%/user/%user%/albums/");
INSERT INTO `wp_postmeta` VALUES("307", "1545", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("308", "1545", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("309", "1545", "_menu_item_object_id", "1545");
INSERT INTO `wp_postmeta` VALUES("310", "1545", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("311", "1545", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("312", "1545", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("313", "1545", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("314", "1545", "_menu_item_url", "http://%site_url%/user/%user%/download/");
INSERT INTO `wp_postmeta` VALUES("315", "1546", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("316", "1546", "_menu_item_menu_item_parent", "702");
INSERT INTO `wp_postmeta` VALUES("317", "1546", "_menu_item_object_id", "1546");
INSERT INTO `wp_postmeta` VALUES("318", "1546", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("319", "1546", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("320", "1546", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("321", "1546", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("322", "1546", "_menu_item_url", "http://%site_url%/user/%user%/profile/");
INSERT INTO `wp_postmeta` VALUES("323", "1547", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("324", "1547", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("336", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("337", "10", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("338", "10", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("340", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("341", "11", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("342", "11", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("343", "11", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("344", "11", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("345", "11", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("346", "11", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("347", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("348", "12", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("349", "12", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("350", "12", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("353", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("354", "13", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("355", "13", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("356", "13", "_thumbnail_id", "136");
INSERT INTO `wp_postmeta` VALUES("357", "13", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("358", "13", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("359", "13", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("360", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("361", "15", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("362", "15", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("366", "35", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("367", "35", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("368", "35", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("372", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("373", "39", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("377", "778", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("381", "1548", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("382", "1548", "_menu_item_menu_item_parent", "1538");
INSERT INTO `wp_postmeta` VALUES("383", "1548", "_menu_item_object_id", "1548");
INSERT INTO `wp_postmeta` VALUES("384", "1548", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("385", "1548", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("386", "1548", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("387", "1548", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("388", "1548", "_menu_item_url", "http://wpnovin.com/shop");
INSERT INTO `wp_postmeta` VALUES("389", "1549", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("390", "1549", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("391", "1549", "_menu_item_object_id", "1549");
INSERT INTO `wp_postmeta` VALUES("392", "1549", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("393", "1549", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("394", "1549", "_menu_item_classes", "a:1:{i:0;s:11:\"menu-header\";}");
INSERT INTO `wp_postmeta` VALUES("395", "1549", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("396", "1549", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("397", "1550", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("398", "1550", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("399", "1550", "_menu_item_object_id", "3");
INSERT INTO `wp_postmeta` VALUES("400", "1550", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("401", "1550", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("402", "1550", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("403", "1550", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("404", "1550", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("405", "1551", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("406", "1551", "_menu_item_menu_item_parent", "1538");
INSERT INTO `wp_postmeta` VALUES("407", "1551", "_menu_item_object_id", "1551");
INSERT INTO `wp_postmeta` VALUES("408", "1551", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("409", "1551", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("410", "1551", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("411", "1551", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("412", "1551", "_menu_item_url", "http://music.flatfull.com/docs/");
INSERT INTO `wp_postmeta` VALUES("413", "17", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("414", "17", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("415", "17", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("417", "19", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("418", "19", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("419", "19", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("423", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("424", "21", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("425", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("429", "23", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("430", "23", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("431", "23", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("435", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("436", "25", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("437", "25", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("441", "31", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("442", "31", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("443", "31", "_thumbnail_id", "92");
INSERT INTO `wp_postmeta` VALUES("444", "33", "_thumbnail_id", "136");
INSERT INTO `wp_postmeta` VALUES("445", "33", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("446", "33", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("447", "33", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("450", "48", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("451", "48", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("452", "48", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("454", "49", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("455", "49", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("456", "49", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("459", "130", "_thumbnail_id", "55");
INSERT INTO `wp_postmeta` VALUES("460", "130", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("461", "130", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("464", "132", "_thumbnail_id", "64");
INSERT INTO `wp_postmeta` VALUES("465", "132", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("466", "132", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("469", "282", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("470", "282", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("471", "282", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("475", "326", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("476", "326", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("477", "326", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("482", "741", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("485", "754", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("488", "756", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("491", "758", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("494", "767", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("499", "772", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("502", "776", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("506", "1552", "_wp_old_slug", "hello-world");
INSERT INTO `wp_postmeta` VALUES("507", "1552", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("508", "1552", "_thumbnail_id", "543");
INSERT INTO `wp_postmeta` VALUES("514", "145", "_thumbnail_id", "516");
INSERT INTO `wp_postmeta` VALUES("515", "145", "type", "single");
INSERT INTO `wp_postmeta` VALUES("516", "145", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/03/78/b5/0378b505-0651-5d37-abaf-fdace32fa0a1/mzaf_4885861497912518049.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("517", "145", "purchase_title", "خرید ترانه");
INSERT INTO `wp_postmeta` VALUES("518", "145", "purchase_url", "https://itunes.apple.com/us/album/shallow/id1434371867?i=1434371887");
INSERT INTO `wp_postmeta` VALUES("519", "145", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("520", "145", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("521", "145", "post-count-all", "27");
INSERT INTO `wp_postmeta` VALUES("522", "145", "post-count-week-201926", "5");
INSERT INTO `wp_postmeta` VALUES("523", "145", "post-count-month-201906", "5");
INSERT INTO `wp_postmeta` VALUES("524", "145", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("525", "145", "post", "");
INSERT INTO `wp_postmeta` VALUES("526", "145", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("527", "145", "waveform_data", "a:200:{i:0;i:16;i:1;i:15;i:2;i:4;i:3;i:4;i:4;i:3;i:5;i:6;i:6;i:4;i:7;i:10;i:8;i:5;i:9;i:17;i:10;i:16;i:11;i:22;i:12;i:12;i:13;i:9;i:14;i:2;i:15;i:12;i:16;i:12;i:17;i:16;i:18;i:12;i:19;i:5;i:20;i:4;i:21;i:2;i:22;i:3;i:23;i:3;i:24;i:2;i:25;i:3;i:26;i:2;i:27;i:2;i:28;i:2;i:29;i:1;i:30;i:1;i:31;i:1;i:32;i:1;i:33;i:1;i:34;i:3;i:35;i:7;i:36;i:14;i:37;i:7;i:38;i:12;i:39;i:17;i:40;i:14;i:41;i:11;i:42;i:12;i:43;i:17;i:44;i:12;i:45;i:20;i:46;i:13;i:47;i:7;i:48;i:21;i:49;i:15;i:50;i:8;i:51;i:9;i:52;i:19;i:53;i:8;i:54;i:18;i:55;i:12;i:56;i:9;i:57;i:14;i:58;i:11;i:59;i:9;i:60;i:6;i:61;i:3;i:62;i:2;i:63;i:2;i:64;i:3;i:65;i:2;i:66;i:2;i:67;i:2;i:68;i:2;i:69;i:1;i:70;i:2;i:71;i:1;i:72;i:3;i:73;i:6;i:74;i:5;i:75;i:5;i:76;i:3;i:77;i:1;i:78;i:14;i:79;i:8;i:80;i:3;i:81;i:3;i:82;i:11;i:83;i:6;i:84;i:4;i:85;i:4;i:86;i:2;i:87;i:3;i:88;i:2;i:89;i:2;i:90;i:2;i:91;i:1;i:92;i:1;i:93;i:1;i:94;i:1;i:95;i:1;i:96;i:1;i:97;i:0;i:98;i:0;i:99;i:1;i:100;i:1;i:101;i:2;i:102;i:2;i:103;i:5;i:104;i:2;i:105;i:4;i:106;i:4;i:107;i:4;i:108;i:3;i:109;i:5;i:110;i:2;i:111;i:10;i:112;i:6;i:113;i:5;i:114;i:2;i:115;i:6;i:116;i:5;i:117;i:3;i:118;i:2;i:119;i:3;i:120;i:3;i:121;i:1;i:122;i:2;i:123;i:1;i:124;i:1;i:125;i:1;i:126;i:1;i:127;i:1;i:128;i:1;i:129;i:0;i:130;i:1;i:131;i:0;i:132;i:0;i:133;i:1;i:134;i:3;i:135;i:3;i:136;i:4;i:137;i:2;i:138;i:14;i:139;i:14;i:140;i:7;i:141;i:11;i:142;i:10;i:143;i:14;i:144;i:8;i:145;i:11;i:146;i:13;i:147;i:9;i:148;i:7;i:149;i:13;i:150;i:15;i:151;i:18;i:152;i:17;i:153;i:9;i:154;i:7;i:155;i:6;i:156;i:8;i:157;i:4;i:158;i:3;i:159;i:2;i:160;i:2;i:161;i:2;i:162;i:3;i:163;i:2;i:164;i:2;i:165;i:1;i:166;i:1;i:167;i:1;i:168;i:3;i:169;i:3;i:170;i:3;i:171;i:2;i:172;i:11;i:173;i:5;i:174;i:6;i:175;i:9;i:176;i:19;i:177;i:16;i:178;i:7;i:179;i:6;i:180;i:6;i:181;i:10;i:182;i:15;i:183;i:12;i:184;i:4;i:185;i:12;i:186;i:14;i:187;i:13;i:188;i:15;i:189;i:11;i:190;i:11;i:191;i:11;i:192;i:14;i:193;i:15;i:194;i:11;i:195;i:6;i:196;i:4;i:197;i:3;i:198;i:6;i:199;i:8;}");
INSERT INTO `wp_postmeta` VALUES("528", "145", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("529", "145", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("530", "145", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("531", "145", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("532", "145", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("533", "145", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("534", "145", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("535", "145", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("536", "145", "post-count-year-2020", "9");
INSERT INTO `wp_postmeta` VALUES("537", "145", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("538", "145", "post-count-week-202046", "2");
INSERT INTO `wp_postmeta` VALUES("539", "145", "post-count-month-202011", "2");
INSERT INTO `wp_postmeta` VALUES("540", "145", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("541", "145", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("545", "145", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("546", "145", "post-count-month-202012", "6");
INSERT INTO `wp_postmeta` VALUES("547", "145", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("548", "145", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("549", "145", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("550", "145", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("551", "145", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("552", "145", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("553", "146", "_thumbnail_id", "504");
INSERT INTO `wp_postmeta` VALUES("554", "146", "type", "single");
INSERT INTO `wp_postmeta` VALUES("555", "146", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/07/2c/59/072c59fe-549d-bd0e-f93d-3e4a1f673af5/mzaf_4035597378145374075.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("556", "146", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("557", "146", "purchase_title", "خرید آهنگ");
INSERT INTO `wp_postmeta` VALUES("558", "146", "purchase_url", "https://itunes.apple.com/us/album/taki-taki-feat-selena-gomez-ozuna-cardi-b/id1436781851?i=1436781869");
INSERT INTO `wp_postmeta` VALUES("559", "146", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("560", "146", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("561", "146", "post-count-all", "123");
INSERT INTO `wp_postmeta` VALUES("562", "146", "post-count-week-201926", "13");
INSERT INTO `wp_postmeta` VALUES("563", "146", "post-count-month-201906", "13");
INSERT INTO `wp_postmeta` VALUES("564", "146", "post-count-year-2019", "13");
INSERT INTO `wp_postmeta` VALUES("565", "146", "download_count", "5");
INSERT INTO `wp_postmeta` VALUES("566", "146", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("567", "146", "like_user", "a:2:{i:0;i:2;i:1;i:3;}");
INSERT INTO `wp_postmeta` VALUES("568", "146", "post", "");
INSERT INTO `wp_postmeta` VALUES("569", "146", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("570", "146", "waveform_data", "a:200:{i:0;i:41;i:1;i:34;i:2;i:12;i:3;i:24;i:4;i:36;i:5;i:15;i:6;i:16;i:7;i:30;i:8;i:25;i:9;i:17;i:10;i:20;i:11;i:9;i:12;i:25;i:13;i:9;i:14;i:21;i:15;i:12;i:16;i:31;i:17;i:36;i:18;i:21;i:19;i:19;i:20;i:30;i:21;i:28;i:22;i:18;i:23;i:16;i:24;i:18;i:25;i:12;i:26;i:16;i:27;i:18;i:28;i:23;i:29;i:13;i:30;i:19;i:31;i:20;i:32;i:14;i:33;i:34;i:34;i:34;i:35;i:16;i:36;i:26;i:37;i:38;i:38;i:38;i:39;i:27;i:40;i:24;i:41;i:13;i:42;i:43;i:43;i:25;i:44;i:22;i:45;i:26;i:46;i:38;i:47;i:18;i:48;i:40;i:49;i:17;i:50;i:37;i:51;i:22;i:52;i:18;i:53;i:28;i:54;i:40;i:55;i:41;i:56;i:40;i:57;i:22;i:58;i:45;i:59;i:41;i:60;i:29;i:61;i:23;i:62;i:35;i:63;i:32;i:64;i:42;i:65;i:34;i:66;i:17;i:67;i:42;i:68;i:21;i:69;i:13;i:70;i:25;i:71;i:38;i:72;i:31;i:73;i:31;i:74;i:15;i:75;i:45;i:76;i:29;i:77;i:24;i:78;i:41;i:79;i:33;i:80;i:22;i:81;i:27;i:82;i:30;i:83;i:41;i:84;i:32;i:85;i:16;i:86;i:17;i:87;i:32;i:88;i:35;i:89;i:42;i:90;i:17;i:91;i:17;i:92;i:43;i:93;i:21;i:94;i:17;i:95;i:32;i:96;i:38;i:97;i:34;i:98;i:31;i:99;i:25;i:100;i:43;i:101;i:32;i:102;i:32;i:103;i:37;i:104;i:35;i:105;i:32;i:106;i:35;i:107;i:22;i:108;i:32;i:109;i:44;i:110;i:26;i:111;i:23;i:112;i:33;i:113;i:34;i:114;i:27;i:115;i:43;i:116;i:19;i:117;i:38;i:118;i:24;i:119;i:14;i:120;i:33;i:121;i:44;i:122;i:31;i:123;i:33;i:124;i:18;i:125;i:39;i:126;i:39;i:127;i:22;i:128;i:34;i:129;i:38;i:130;i:38;i:131;i:40;i:132;i:21;i:133;i:20;i:134;i:45;i:135;i:17;i:136;i:13;i:137;i:35;i:138;i:44;i:139;i:18;i:140;i:40;i:141;i:22;i:142;i:44;i:143;i:27;i:144;i:17;i:145;i:35;i:146;i:40;i:147;i:28;i:148;i:37;i:149;i:31;i:150;i:32;i:151;i:34;i:152;i:27;i:153;i:23;i:154;i:42;i:155;i:41;i:156;i:43;i:157;i:20;i:158;i:44;i:159;i:44;i:160;i:25;i:161;i:22;i:162;i:40;i:163;i:44;i:164;i:12;i:165;i:36;i:166;i:31;i:167;i:45;i:168;i:19;i:169;i:26;i:170;i:10;i:171;i:11;i:172;i:20;i:173;i:23;i:174;i:11;i:175;i:10;i:176;i:31;i:177;i:21;i:178;i:20;i:179;i:15;i:180;i:11;i:181;i:11;i:182;i:19;i:183;i:8;i:184;i:36;i:185;i:18;i:186;i:16;i:187;i:18;i:188;i:15;i:189;i:25;i:190;i:23;i:191;i:17;i:192;i:12;i:193;i:22;i:194;i:21;i:195;i:17;i:196;i:15;i:197;i:17;i:198;i:10;i:199;i:17;}");
INSERT INTO `wp_postmeta` VALUES("571", "146", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("572", "146", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("573", "146", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("574", "146", "post-count-week-202044", "2");
INSERT INTO `wp_postmeta` VALUES("575", "146", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("576", "146", "post-count-year-2020", "94");
INSERT INTO `wp_postmeta` VALUES("577", "146", "post-count-month-202011", "9");
INSERT INTO `wp_postmeta` VALUES("578", "146", "post-count-week-202045", "3");
INSERT INTO `wp_postmeta` VALUES("579", "146", "post-count-week-202046", "4");
INSERT INTO `wp_postmeta` VALUES("580", "146", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("581", "146", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("585", "146", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("586", "146", "post-count-week-202050", "8");
INSERT INTO `wp_postmeta` VALUES("587", "146", "post-count-month-202012", "84");
INSERT INTO `wp_postmeta` VALUES("588", "146", "post-count-week-202051", "74");
INSERT INTO `wp_postmeta` VALUES("589", "146", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("590", "146", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("591", "146", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("592", "146", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("593", "146", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("594", "148", "_thumbnail_id", "505");
INSERT INTO `wp_postmeta` VALUES("595", "148", "type", "single");
INSERT INTO `wp_postmeta` VALUES("596", "148", "stream", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2022/01/Majid-Razavi-Negine-Ghalbami-320.mp3");
INSERT INTO `wp_postmeta` VALUES("597", "148", "purchase_title", "هم ترانه");
INSERT INTO `wp_postmeta` VALUES("598", "148", "purchase_url", "https://itunes.apple.com/us/album/promises/id1424361878?i=1424362622");
INSERT INTO `wp_postmeta` VALUES("599", "148", "post-count-all", "577");
INSERT INTO `wp_postmeta` VALUES("600", "148", "like_count", "12");
INSERT INTO `wp_postmeta` VALUES("601", "148", "download_count", "13");
INSERT INTO `wp_postmeta` VALUES("602", "148", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("603", "148", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("604", "148", "post-count-week-201926", "25");
INSERT INTO `wp_postmeta` VALUES("605", "148", "post-count-month-201906", "25");
INSERT INTO `wp_postmeta` VALUES("606", "148", "post-count-year-2019", "29");
INSERT INTO `wp_postmeta` VALUES("607", "148", "like_user", "a:10:{i:0;i:2;i:1;i:1;i:2;i:7;i:3;i:5;i:4;i:9;i:5;i:36;i:6;i:50;i:7;i:52;i:8;i:60;i:9;i:64;}");
INSERT INTO `wp_postmeta` VALUES("608", "148", "post-count-week-201927", "4");
INSERT INTO `wp_postmeta` VALUES("609", "148", "post-count-month-201907", "4");
INSERT INTO `wp_postmeta` VALUES("610", "148", "post-count-week-202037", "3");
INSERT INTO `wp_postmeta` VALUES("611", "148", "post-count-month-202009", "7");
INSERT INTO `wp_postmeta` VALUES("612", "148", "post-count-year-2020", "71");
INSERT INTO `wp_postmeta` VALUES("613", "148", "post", "");
INSERT INTO `wp_postmeta` VALUES("614", "148", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("615", "148", "waveform_data", "a:200:{i:0;i:8;i:1;i:14;i:2;i:44;i:3;i:18;i:4;i:14;i:5;i:49;i:6;i:49;i:7;i:24;i:8;i:36;i:9;i:37;i:10;i:38;i:11;i:42;i:12;i:42;i:13;i:28;i:14;i:37;i:15;i:36;i:16;i:29;i:17;i:11;i:18;i:38;i:19;i:29;i:20;i:22;i:21;i:46;i:22;i:44;i:23;i:44;i:24;i:50;i:25;i:51;i:26;i:19;i:27;i:17;i:28;i:31;i:29;i:22;i:30;i:11;i:31;i:47;i:32;i:45;i:33;i:30;i:34;i:47;i:35;i:44;i:36;i:41;i:37;i:46;i:38;i:51;i:39;i:17;i:40;i:12;i:41;i:36;i:42;i:28;i:43;i:12;i:44;i:40;i:45;i:35;i:46;i:28;i:47;i:39;i:48;i:40;i:49;i:48;i:50;i:32;i:51;i:40;i:52;i:13;i:53;i:5;i:54;i:38;i:55;i:23;i:56;i:16;i:57;i:29;i:58;i:35;i:59;i:48;i:60;i:25;i:61;i:50;i:62;i:51;i:63;i:37;i:64;i:42;i:65;i:26;i:66;i:27;i:67;i:45;i:68;i:23;i:69;i:14;i:70;i:45;i:71;i:41;i:72;i:38;i:73;i:49;i:74;i:44;i:75;i:49;i:76;i:21;i:77;i:35;i:78;i:24;i:79;i:14;i:80;i:39;i:81;i:20;i:82;i:23;i:83;i:34;i:84;i:39;i:85;i:51;i:86;i:29;i:87;i:34;i:88;i:40;i:89;i:45;i:90;i:49;i:91;i:17;i:92;i:13;i:93;i:46;i:94;i:29;i:95;i:14;i:96;i:27;i:97;i:46;i:98;i:44;i:99;i:40;i:100;i:41;i:101;i:32;i:102;i:11;i:103;i:39;i:104;i:19;i:105;i:7;i:106;i:47;i:107;i:15;i:108;i:36;i:109;i:26;i:110;i:26;i:111;i:41;i:112;i:15;i:113;i:18;i:114;i:9;i:115;i:11;i:116;i:20;i:117;i:9;i:118;i:23;i:119;i:21;i:120;i:10;i:121;i:6;i:122;i:17;i:123;i:19;i:124;i:9;i:125;i:17;i:126;i:23;i:127;i:7;i:128;i:7;i:129;i:23;i:130;i:12;i:131;i:1;i:132;i:17;i:133;i:21;i:134;i:5;i:135;i:15;i:136;i:33;i:137;i:7;i:138;i:12;i:139;i:19;i:140;i:8;i:141;i:12;i:142;i:23;i:143;i:12;i:144;i:5;i:145;i:20;i:146;i:18;i:147;i:4;i:148;i:20;i:149;i:33;i:150;i:5;i:151;i:4;i:152;i:18;i:153;i:11;i:154;i:17;i:155;i:19;i:156;i:19;i:157;i:9;i:158;i:6;i:159;i:2;i:160;i:12;i:161;i:42;i:162;i:49;i:163;i:39;i:164;i:21;i:165;i:43;i:166;i:30;i:167;i:50;i:168;i:43;i:169;i:26;i:170;i:14;i:171;i:46;i:172;i:27;i:173;i:18;i:174;i:46;i:175;i:42;i:176;i:22;i:177;i:26;i:178;i:49;i:179;i:48;i:180;i:50;i:181;i:36;i:182;i:31;i:183;i:20;i:184;i:41;i:185;i:46;i:186;i:21;i:187;i:25;i:188;i:50;i:189;i:43;i:190;i:19;i:191;i:48;i:192;i:10;i:193;i:37;i:194;i:46;i:195;i:29;i:196;i:16;i:197;i:33;i:198;i:37;i:199;i:21;}");
INSERT INTO `wp_postmeta` VALUES("616", "148", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("617", "148", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("618", "148", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("619", "148", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("620", "148", "post-count-week-202038", "2");
INSERT INTO `wp_postmeta` VALUES("621", "148", "post-count-week-202039", "2");
INSERT INTO `wp_postmeta` VALUES("622", "148", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("623", "148", "post-count-month-202010", "8");
INSERT INTO `wp_postmeta` VALUES("624", "148", "post-count-week-202044", "8");
INSERT INTO `wp_postmeta` VALUES("625", "148", "post-count-month-202011", "30");
INSERT INTO `wp_postmeta` VALUES("626", "148", "post-count-week-202045", "11");
INSERT INTO `wp_postmeta` VALUES("627", "148", "post-count-week-202046", "7");
INSERT INTO `wp_postmeta` VALUES("628", "148", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("629", "148", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("633", "148", "post-count-week-202047", "11");
INSERT INTO `wp_postmeta` VALUES("634", "148", "post-count-week-202050", "3");
INSERT INTO `wp_postmeta` VALUES("635", "148", "post-count-month-202012", "26");
INSERT INTO `wp_postmeta` VALUES("636", "148", "post-count-week-202051", "12");
INSERT INTO `wp_postmeta` VALUES("637", "148", "post-count-week-202052", "9");
INSERT INTO `wp_postmeta` VALUES("638", "148", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("639", "148", "post-count-week-202101", "4");
INSERT INTO `wp_postmeta` VALUES("640", "148", "post-count-month-202101", "4");
INSERT INTO `wp_postmeta` VALUES("641", "148", "post-count-year-2021", "4");
INSERT INTO `wp_postmeta` VALUES("642", "155", "type", "single");
INSERT INTO `wp_postmeta` VALUES("643", "155", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview115/v4/4c/58/f4/4c58f4f0-ec84-c5e3-15ed-39beb0933e38/mzaf_3604425775820894823.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("644", "155", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("645", "155", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("646", "155", "purchase_title", "هم ترانه");
INSERT INTO `wp_postmeta` VALUES("647", "155", "purchase_url", "https://itunes.apple.com/us/album/be-alright/id1400595841?i=1400596082");
INSERT INTO `wp_postmeta` VALUES("648", "155", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("649", "155", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("650", "155", "_thumbnail_id", "506");
INSERT INTO `wp_postmeta` VALUES("651", "155", "post-count-all", "15");
INSERT INTO `wp_postmeta` VALUES("652", "155", "post-count-week-201926", "7");
INSERT INTO `wp_postmeta` VALUES("653", "155", "post-count-month-201906", "7");
INSERT INTO `wp_postmeta` VALUES("654", "155", "post-count-year-2019", "7");
INSERT INTO `wp_postmeta` VALUES("655", "155", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("656", "155", "like_user", "a:1:{i:0;i:2;}");
INSERT INTO `wp_postmeta` VALUES("657", "155", "download_count", "6");
INSERT INTO `wp_postmeta` VALUES("658", "155", "post", "");
INSERT INTO `wp_postmeta` VALUES("659", "155", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("660", "155", "waveform_data", "a:200:{i:0;i:31;i:1;i:25;i:2;i:17;i:3;i:26;i:4;i:39;i:5;i:40;i:6;i:33;i:7;i:22;i:8;i:14;i:9;i:26;i:10;i:28;i:11;i:32;i:12;i:29;i:13;i:21;i:14;i:24;i:15;i:28;i:16;i:32;i:17;i:31;i:18;i:44;i:19;i:31;i:20;i:35;i:21;i:19;i:22;i:28;i:23;i:35;i:24;i:35;i:25;i:24;i:26;i:34;i:27;i:29;i:28;i:22;i:29;i:44;i:30;i:23;i:31;i:33;i:32;i:25;i:33;i:20;i:34;i:24;i:35;i:23;i:36;i:28;i:37;i:27;i:38;i:23;i:39;i:28;i:40;i:24;i:41;i:39;i:42;i:30;i:43;i:16;i:44;i:13;i:45;i:19;i:46;i:21;i:47;i:9;i:48;i:12;i:49;i:14;i:50;i:15;i:51;i:11;i:52;i:14;i:53;i:17;i:54;i:15;i:55;i:12;i:56;i:9;i:57;i:10;i:58;i:10;i:59;i:8;i:60;i:10;i:61;i:6;i:62;i:7;i:63;i:7;i:64;i:1;i:65;i:1;i:66;i:1;i:67;i:17;i:68;i:16;i:69;i:16;i:70;i:11;i:71;i:9;i:72;i:13;i:73;i:14;i:74;i:7;i:75;i:22;i:76;i:11;i:77;i:15;i:78;i:8;i:79;i:7;i:80;i:5;i:81;i:8;i:82;i:7;i:83;i:9;i:84;i:13;i:85;i:14;i:86;i:14;i:87;i:7;i:88;i:2;i:89;i:5;i:90;i:7;i:91;i:1;i:92;i:6;i:93;i:8;i:94;i:45;i:95;i:14;i:96;i:14;i:97;i:16;i:98;i:17;i:99;i:11;i:100;i:28;i:101;i:16;i:102;i:16;i:103;i:13;i:104;i:10;i:105;i:13;i:106;i:12;i:107;i:35;i:108;i:31;i:109;i:12;i:110;i:11;i:111;i:10;i:112;i:7;i:113;i:28;i:114;i:21;i:115;i:19;i:116;i:13;i:117;i:10;i:118;i:15;i:119;i:21;i:120;i:44;i:121;i:26;i:122;i:14;i:123;i:12;i:124;i:17;i:125;i:14;i:126;i:33;i:127;i:9;i:128;i:9;i:129;i:5;i:130;i:13;i:131;i:18;i:132;i:30;i:133;i:32;i:134;i:14;i:135;i:13;i:136;i:9;i:137;i:32;i:138;i:32;i:139;i:16;i:140;i:18;i:141;i:24;i:142;i:24;i:143;i:16;i:144;i:16;i:145;i:29;i:146;i:25;i:147;i:14;i:148;i:21;i:149;i:30;i:150;i:23;i:151;i:21;i:152;i:25;i:153;i:21;i:154;i:33;i:155;i:18;i:156;i:27;i:157;i:13;i:158;i:35;i:159;i:27;i:160;i:27;i:161;i:20;i:162;i:11;i:163;i:14;i:164;i:22;i:165;i:23;i:166;i:18;i:167;i:22;i:168;i:19;i:169;i:13;i:170;i:40;i:171;i:31;i:172;i:15;i:173;i:12;i:174;i:16;i:175;i:18;i:176;i:14;i:177;i:33;i:178;i:18;i:179;i:7;i:180;i:11;i:181;i:16;i:182;i:18;i:183;i:32;i:184;i:17;i:185;i:26;i:186;i:13;i:187;i:23;i:188;i:17;i:189;i:21;i:190;i:16;i:191;i:20;i:192;i:20;i:193;i:15;i:194;i:15;i:195;i:15;i:196;i:43;i:197;i:37;i:198;i:21;i:199;i:17;}");
INSERT INTO `wp_postmeta` VALUES("661", "155", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("662", "155", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("663", "155", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("664", "155", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("668", "155", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("669", "155", "post-count-month-202012", "7");
INSERT INTO `wp_postmeta` VALUES("670", "155", "post-count-year-2020", "7");
INSERT INTO `wp_postmeta` VALUES("671", "155", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("672", "155", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("673", "155", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("674", "155", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("675", "155", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("676", "155", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("677", "156", "_thumbnail_id", "507");
INSERT INTO `wp_postmeta` VALUES("678", "156", "type", "single");
INSERT INTO `wp_postmeta` VALUES("679", "156", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview125/v4/91/65/e8/9165e84a-49ed-1728-54b4-32360df0eeea/mzaf_7952964905769903156.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("680", "156", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("681", "156", "purchase_title", "آوازی نو");
INSERT INTO `wp_postmeta` VALUES("682", "156", "purchase_url", "https://itunes.apple.com/us/album/in-my-mind/id1390112814?i=1390113209");
INSERT INTO `wp_postmeta` VALUES("683", "156", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("684", "156", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("685", "156", "post-count-all", "22");
INSERT INTO `wp_postmeta` VALUES("686", "156", "post-count-week-201926", "13");
INSERT INTO `wp_postmeta` VALUES("687", "156", "post-count-month-201906", "13");
INSERT INTO `wp_postmeta` VALUES("688", "156", "post-count-year-2019", "13");
INSERT INTO `wp_postmeta` VALUES("689", "156", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("690", "156", "like_user", "a:2:{i:0;i:2;i:1;i:3;}");
INSERT INTO `wp_postmeta` VALUES("691", "156", "download_count", "5");
INSERT INTO `wp_postmeta` VALUES("692", "156", "post", "");
INSERT INTO `wp_postmeta` VALUES("693", "156", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("694", "156", "waveform_data", "a:200:{i:0;i:16;i:1;i:47;i:2;i:49;i:3;i:29;i:4;i:21;i:5;i:44;i:6;i:33;i:7;i:38;i:8;i:49;i:9;i:44;i:10;i:49;i:11;i:49;i:12;i:48;i:13;i:28;i:14;i:45;i:15;i:47;i:16;i:49;i:17;i:26;i:18;i:44;i:19;i:38;i:20;i:46;i:21;i:48;i:22;i:36;i:23;i:38;i:24;i:48;i:25;i:48;i:26;i:38;i:27;i:49;i:28;i:47;i:29;i:17;i:30;i:43;i:31;i:47;i:32;i:29;i:33;i:47;i:34;i:49;i:35;i:43;i:36;i:41;i:37;i:49;i:38;i:40;i:39;i:32;i:40;i:49;i:41;i:44;i:42;i:32;i:43;i:38;i:44;i:34;i:45;i:48;i:46;i:47;i:47;i:46;i:48;i:42;i:49;i:38;i:50;i:45;i:51;i:39;i:52;i:33;i:53;i:48;i:54;i:39;i:55;i:38;i:56;i:39;i:57;i:39;i:58;i:25;i:59;i:48;i:60;i:38;i:61;i:16;i:62;i:43;i:63;i:34;i:64;i:35;i:65;i:48;i:66;i:41;i:67;i:32;i:68;i:49;i:69;i:40;i:70;i:44;i:71;i:47;i:72;i:43;i:73;i:27;i:74;i:36;i:75;i:47;i:76;i:45;i:77;i:31;i:78;i:48;i:79;i:48;i:80;i:31;i:81;i:50;i:82;i:38;i:83;i:29;i:84;i:43;i:85;i:42;i:86;i:35;i:87;i:33;i:88;i:41;i:89;i:47;i:90;i:47;i:91;i:45;i:92;i:48;i:93;i:30;i:94;i:45;i:95;i:49;i:96;i:49;i:97;i:48;i:98;i:40;i:99;i:34;i:100;i:45;i:101;i:23;i:102;i:33;i:103;i:49;i:104;i:42;i:105;i:34;i:106;i:49;i:107;i:33;i:108;i:33;i:109;i:47;i:110;i:48;i:111;i:41;i:112;i:32;i:113;i:45;i:114;i:40;i:115;i:49;i:116;i:44;i:117;i:41;i:118;i:37;i:119;i:38;i:120;i:35;i:121;i:40;i:122;i:48;i:123;i:47;i:124;i:42;i:125;i:49;i:126;i:40;i:127;i:46;i:128;i:49;i:129;i:49;i:130;i:42;i:131;i:14;i:132;i:47;i:133;i:37;i:134;i:40;i:135;i:44;i:136;i:40;i:137;i:46;i:138;i:41;i:139;i:37;i:140;i:50;i:141;i:48;i:142;i:48;i:143;i:44;i:144;i:46;i:145;i:49;i:146;i:45;i:147;i:34;i:148;i:47;i:149;i:38;i:150;i:35;i:151;i:51;i:152;i:35;i:153;i:42;i:154;i:36;i:155;i:44;i:156;i:16;i:157;i:43;i:158;i:48;i:159;i:28;i:160;i:44;i:161;i:40;i:162;i:49;i:163;i:44;i:164;i:39;i:165;i:45;i:166;i:50;i:167;i:40;i:168;i:43;i:169;i:12;i:170;i:40;i:171;i:44;i:172;i:42;i:173;i:48;i:174;i:41;i:175;i:37;i:176;i:34;i:177;i:33;i:178;i:48;i:179;i:42;i:180;i:39;i:181;i:40;i:182;i:12;i:183;i:37;i:184;i:35;i:185;i:39;i:186;i:47;i:187;i:45;i:188;i:34;i:189;i:34;i:190;i:42;i:191;i:42;i:192;i:45;i:193;i:45;i:194;i:35;i:195;i:26;i:196;i:43;i:197;i:41;i:198;i:32;i:199;i:48;}");
INSERT INTO `wp_postmeta` VALUES("695", "156", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("696", "156", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("697", "156", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("698", "156", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("699", "156", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("700", "156", "post-count-year-2020", "7");
INSERT INTO `wp_postmeta` VALUES("701", "156", "post-count-week-202045", "1");
INSERT INTO `wp_postmeta` VALUES("702", "156", "post-count-month-202011", "1");
INSERT INTO `wp_postmeta` VALUES("703", "156", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("704", "156", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("708", "156", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("709", "156", "post-count-month-202012", "5");
INSERT INTO `wp_postmeta` VALUES("710", "156", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("711", "156", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("712", "156", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("713", "156", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("714", "156", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("715", "156", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("716", "157", "_thumbnail_id", "508");
INSERT INTO `wp_postmeta` VALUES("717", "157", "type", "single");
INSERT INTO `wp_postmeta` VALUES("718", "157", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/fa/cc/a3/facca3ab-51ea-11b8-e359-b2a200738fc5/mzaf_2669843299284584791.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("719", "157", "purchase_title", "آوازی نو");
INSERT INTO `wp_postmeta` VALUES("720", "157", "purchase_url", "https://itunes.apple.com/us/album/without-me/id1437572573?i=1437572583");
INSERT INTO `wp_postmeta` VALUES("721", "157", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("722", "157", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("723", "157", "post-count-all", "108");
INSERT INTO `wp_postmeta` VALUES("724", "157", "post-count-week-201926", "13");
INSERT INTO `wp_postmeta` VALUES("725", "157", "post-count-month-201906", "13");
INSERT INTO `wp_postmeta` VALUES("726", "157", "post-count-year-2019", "14");
INSERT INTO `wp_postmeta` VALUES("727", "157", "like_count", "3");
INSERT INTO `wp_postmeta` VALUES("728", "157", "like_user", "a:3:{i:0;i:3;i:1;i:24;i:2;i:37;}");
INSERT INTO `wp_postmeta` VALUES("729", "157", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("730", "157", "post-count-week-201927", "1");
INSERT INTO `wp_postmeta` VALUES("731", "157", "post-count-month-201907", "1");
INSERT INTO `wp_postmeta` VALUES("732", "157", "post", "");
INSERT INTO `wp_postmeta` VALUES("733", "157", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("734", "157", "waveform_data", "a:200:{i:0;i:4;i:1;i:5;i:2;i:28;i:3;i:7;i:4;i:8;i:5;i:21;i:6;i:18;i:7;i:11;i:8;i:25;i:9;i:19;i:10;i:11;i:11;i:10;i:12;i:7;i:13;i:11;i:14;i:19;i:15;i:16;i:16;i:19;i:17;i:24;i:18;i:32;i:19;i:15;i:20;i:29;i:21;i:22;i:22;i:23;i:23;i:10;i:24;i:6;i:25;i:17;i:26;i:17;i:27;i:20;i:28;i:23;i:29;i:14;i:30;i:17;i:31;i:22;i:32;i:17;i:33;i:13;i:34;i:20;i:35;i:12;i:36;i:7;i:37;i:13;i:38;i:8;i:39;i:21;i:40;i:24;i:41;i:21;i:42;i:10;i:43;i:13;i:44;i:16;i:45;i:8;i:46;i:5;i:47;i:5;i:48;i:4;i:49;i:17;i:50;i:15;i:51;i:17;i:52;i:26;i:53;i:12;i:54;i:8;i:55;i:25;i:56;i:28;i:57;i:17;i:58;i:21;i:59;i:19;i:60;i:10;i:61;i:34;i:62;i:14;i:63;i:28;i:64;i:22;i:65;i:25;i:66;i:12;i:67;i:26;i:68;i:14;i:69;i:13;i:70;i:13;i:71;i:14;i:72;i:9;i:73;i:8;i:74;i:12;i:75;i:15;i:76;i:10;i:77;i:16;i:78;i:12;i:79;i:28;i:80;i:38;i:81;i:30;i:82;i:37;i:83;i:43;i:84;i:34;i:85;i:25;i:86;i:34;i:87;i:29;i:88;i:30;i:89;i:42;i:90;i:40;i:91;i:29;i:92;i:35;i:93;i:41;i:94;i:37;i:95;i:26;i:96;i:31;i:97;i:30;i:98;i:43;i:99;i:34;i:100;i:33;i:101;i:31;i:102;i:42;i:103;i:37;i:104;i:39;i:105;i:39;i:106;i:41;i:107;i:39;i:108;i:30;i:109;i:42;i:110;i:35;i:111;i:33;i:112;i:20;i:113;i:35;i:114;i:32;i:115;i:25;i:116;i:37;i:117;i:42;i:118;i:23;i:119;i:27;i:120;i:24;i:121;i:42;i:122;i:37;i:123;i:37;i:124;i:24;i:125;i:42;i:126;i:42;i:127;i:41;i:128;i:32;i:129;i:24;i:130;i:37;i:131;i:42;i:132;i:36;i:133;i:31;i:134;i:43;i:135;i:41;i:136;i:26;i:137;i:34;i:138;i:33;i:139;i:23;i:140;i:39;i:141;i:22;i:142;i:31;i:143;i:30;i:144;i:35;i:145;i:42;i:146;i:31;i:147;i:37;i:148;i:32;i:149;i:42;i:150;i:36;i:151;i:42;i:152;i:22;i:153;i:40;i:154;i:37;i:155;i:23;i:156;i:30;i:157;i:34;i:158;i:42;i:159;i:30;i:160;i:27;i:161;i:31;i:162;i:17;i:163;i:24;i:164;i:31;i:165;i:28;i:166;i:26;i:167;i:37;i:168;i:43;i:169;i:27;i:170;i:42;i:171;i:24;i:172;i:21;i:173;i:20;i:174;i:23;i:175;i:21;i:176;i:21;i:177;i:15;i:178;i:9;i:179;i:23;i:180;i:27;i:181;i:17;i:182;i:23;i:183;i:12;i:184;i:34;i:185;i:17;i:186;i:15;i:187;i:21;i:188;i:12;i:189;i:14;i:190;i:14;i:191;i:17;i:192;i:22;i:193;i:29;i:194;i:20;i:195;i:19;i:196;i:25;i:197;i:18;i:198;i:22;i:199;i:22;}");
INSERT INTO `wp_postmeta` VALUES("735", "157", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("736", "157", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("737", "157", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("738", "157", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("739", "157", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("740", "157", "post-count-week-202037", "2");
INSERT INTO `wp_postmeta` VALUES("741", "157", "post-count-month-202009", "4");
INSERT INTO `wp_postmeta` VALUES("742", "157", "post-count-year-2020", "59");
INSERT INTO `wp_postmeta` VALUES("743", "157", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("744", "157", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("745", "157", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("746", "157", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("747", "157", "post-count-month-202011", "22");
INSERT INTO `wp_postmeta` VALUES("748", "157", "post-count-week-202046", "8");
INSERT INTO `wp_postmeta` VALUES("749", "157", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("750", "157", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("754", "157", "post-count-week-202047", "13");
INSERT INTO `wp_postmeta` VALUES("755", "157", "post-count-week-202050", "12");
INSERT INTO `wp_postmeta` VALUES("756", "157", "post-count-month-202012", "31");
INSERT INTO `wp_postmeta` VALUES("757", "157", "post-count-week-202051", "16");
INSERT INTO `wp_postmeta` VALUES("758", "157", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("759", "157", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("760", "157", "post-count-week-202101", "2");
INSERT INTO `wp_postmeta` VALUES("761", "157", "post-count-month-202101", "2");
INSERT INTO `wp_postmeta` VALUES("762", "157", "post-count-year-2021", "2");
INSERT INTO `wp_postmeta` VALUES("763", "159", "type", "single");
INSERT INTO `wp_postmeta` VALUES("764", "159", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/bb/45/0e/bb450e27-beb6-6006-3add-b01a40cad68d/mzaf_4073501669713213306.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("765", "159", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("766", "159", "thumbnail_pos_y", "40");
INSERT INTO `wp_postmeta` VALUES("767", "159", "post-count-all", "86");
INSERT INTO `wp_postmeta` VALUES("768", "159", "post-count-week-201926", "15");
INSERT INTO `wp_postmeta` VALUES("769", "159", "post-count-month-201906", "15");
INSERT INTO `wp_postmeta` VALUES("770", "159", "post-count-year-2019", "17");
INSERT INTO `wp_postmeta` VALUES("771", "159", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("772", "159", "_thumbnail_id", "509");
INSERT INTO `wp_postmeta` VALUES("773", "159", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("774", "159", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("775", "159", "post-count-week-202037", "2");
INSERT INTO `wp_postmeta` VALUES("776", "159", "post-count-month-202009", "7");
INSERT INTO `wp_postmeta` VALUES("777", "159", "post-count-year-2020", "51");
INSERT INTO `wp_postmeta` VALUES("778", "159", "post", "");
INSERT INTO `wp_postmeta` VALUES("779", "159", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("780", "159", "waveform_data", "a:200:{i:0;i:17;i:1;i:24;i:2;i:10;i:3;i:32;i:4;i:28;i:5;i:19;i:6;i:13;i:7;i:30;i:8;i:11;i:9;i:25;i:10;i:11;i:11;i:20;i:12;i:27;i:13;i:16;i:14;i:10;i:15;i:21;i:16;i:8;i:17;i:10;i:18;i:24;i:19;i:22;i:20;i:26;i:21;i:30;i:22;i:27;i:23;i:31;i:24;i:35;i:25;i:24;i:26;i:25;i:27;i:27;i:28;i:20;i:29;i:28;i:30;i:32;i:31;i:13;i:32;i:19;i:33;i:35;i:34;i:25;i:35;i:28;i:36;i:19;i:37;i:43;i:38;i:28;i:39;i:26;i:40;i:37;i:41;i:28;i:42;i:26;i:43;i:42;i:44;i:35;i:45;i:24;i:46;i:14;i:47;i:21;i:48;i:19;i:49;i:28;i:50;i:20;i:51;i:31;i:52;i:15;i:53;i:42;i:54;i:22;i:55;i:34;i:56;i:21;i:57;i:27;i:58;i:40;i:59;i:41;i:60;i:35;i:61;i:33;i:62;i:32;i:63;i:33;i:64;i:18;i:65;i:30;i:66;i:27;i:67;i:30;i:68;i:31;i:69;i:28;i:70;i:37;i:71;i:17;i:72;i:25;i:73;i:41;i:74;i:36;i:75;i:42;i:76;i:33;i:77;i:24;i:78;i:17;i:79;i:23;i:80;i:31;i:81;i:19;i:82;i:31;i:83;i:29;i:84;i:27;i:85;i:26;i:86;i:34;i:87;i:25;i:88;i:27;i:89;i:42;i:90;i:37;i:91;i:39;i:92;i:26;i:93;i:18;i:94;i:22;i:95;i:23;i:96;i:32;i:97;i:27;i:98;i:17;i:99;i:31;i:100;i:31;i:101;i:43;i:102;i:41;i:103;i:21;i:104;i:27;i:105;i:40;i:106;i:36;i:107;i:41;i:108;i:34;i:109;i:26;i:110;i:20;i:111;i:29;i:112;i:15;i:113;i:16;i:114;i:30;i:115;i:25;i:116;i:20;i:117;i:34;i:118;i:32;i:119;i:31;i:120;i:29;i:121;i:26;i:122;i:41;i:123;i:41;i:124;i:28;i:125;i:32;i:126;i:23;i:127;i:21;i:128;i:31;i:129;i:26;i:130;i:25;i:131;i:26;i:132;i:26;i:133;i:30;i:134;i:41;i:135;i:33;i:136;i:25;i:137;i:35;i:138;i:25;i:139;i:40;i:140;i:41;i:141;i:36;i:142;i:19;i:143;i:20;i:144;i:22;i:145;i:31;i:146;i:31;i:147;i:20;i:148;i:34;i:149;i:37;i:150;i:20;i:151;i:18;i:152;i:15;i:153;i:15;i:154;i:30;i:155;i:16;i:156;i:18;i:157;i:18;i:158;i:16;i:159;i:15;i:160;i:13;i:161;i:22;i:162;i:24;i:163;i:16;i:164;i:12;i:165;i:24;i:166;i:43;i:167;i:15;i:168;i:30;i:169;i:26;i:170;i:17;i:171;i:23;i:172;i:32;i:173;i:19;i:174;i:19;i:175;i:21;i:176;i:17;i:177;i:43;i:178;i:30;i:179;i:22;i:180;i:20;i:181;i:38;i:182;i:40;i:183;i:16;i:184;i:18;i:185;i:41;i:186;i:37;i:187;i:11;i:188;i:16;i:189;i:18;i:190;i:18;i:191;i:15;i:192;i:15;i:193;i:24;i:194;i:21;i:195;i:21;i:196;i:17;i:197;i:40;i:198;i:37;i:199;i:21;}");
INSERT INTO `wp_postmeta` VALUES("781", "159", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("782", "159", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("783", "159", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("784", "159", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("785", "159", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("786", "159", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("787", "159", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("788", "159", "download_count", "3");
INSERT INTO `wp_postmeta` VALUES("789", "159", "post-count-week-202038", "2");
INSERT INTO `wp_postmeta` VALUES("790", "159", "post-count-week-202039", "3");
INSERT INTO `wp_postmeta` VALUES("791", "159", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("792", "159", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("793", "159", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("794", "159", "like_user", "a:2:{i:0;i:1;i:1;i:52;}");
INSERT INTO `wp_postmeta` VALUES("795", "159", "post-count-week-202045", "1");
INSERT INTO `wp_postmeta` VALUES("796", "159", "post-count-month-202011", "18");
INSERT INTO `wp_postmeta` VALUES("797", "159", "post-count-week-202046", "6");
INSERT INTO `wp_postmeta` VALUES("798", "159", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("799", "159", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("803", "159", "post-count-week-202047", "11");
INSERT INTO `wp_postmeta` VALUES("804", "159", "post-count-week-202050", "5");
INSERT INTO `wp_postmeta` VALUES("805", "159", "post-count-month-202012", "24");
INSERT INTO `wp_postmeta` VALUES("806", "159", "post-count-week-202051", "16");
INSERT INTO `wp_postmeta` VALUES("807", "159", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("808", "159", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("809", "159", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("810", "159", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("811", "159", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("812", "169", "type", "single");
INSERT INTO `wp_postmeta` VALUES("813", "169", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/eb/e4/2e/ebe42efd-bbce-75cd-63a2-5813637e25bb/mzaf_6529454398103897146.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("814", "169", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("815", "169", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("816", "169", "_thumbnail_id", "510");
INSERT INTO `wp_postmeta` VALUES("817", "169", "post-count-all", "20");
INSERT INTO `wp_postmeta` VALUES("818", "169", "post-count-week-201926", "5");
INSERT INTO `wp_postmeta` VALUES("819", "169", "post-count-month-201906", "5");
INSERT INTO `wp_postmeta` VALUES("820", "169", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("821", "169", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("822", "169", "like_user", "a:1:{i:0;i:3;}");
INSERT INTO `wp_postmeta` VALUES("823", "169", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("824", "169", "post", "");
INSERT INTO `wp_postmeta` VALUES("825", "169", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("826", "169", "waveform_data", "a:200:{i:0;i:23;i:1;i:24;i:2;i:27;i:3;i:25;i:4;i:27;i:5;i:28;i:6;i:25;i:7;i:19;i:8;i:41;i:9;i:24;i:10;i:30;i:11;i:17;i:12;i:32;i:13;i:41;i:14;i:19;i:15;i:43;i:16;i:43;i:17;i:41;i:18;i:44;i:19;i:32;i:20;i:43;i:21;i:45;i:22;i:35;i:23;i:25;i:24;i:34;i:25;i:31;i:26;i:46;i:27;i:43;i:28;i:30;i:29;i:36;i:30;i:45;i:31;i:20;i:32;i:46;i:33;i:45;i:34;i:45;i:35;i:44;i:36;i:48;i:37;i:49;i:38;i:48;i:39;i:38;i:40;i:45;i:41;i:27;i:42;i:28;i:43;i:46;i:44;i:31;i:45;i:24;i:46;i:43;i:47;i:37;i:48;i:35;i:49;i:34;i:50;i:47;i:51;i:36;i:52;i:23;i:53;i:45;i:54;i:48;i:55;i:33;i:56;i:46;i:57;i:40;i:58;i:32;i:59;i:47;i:60;i:43;i:61;i:36;i:62;i:36;i:63;i:36;i:64;i:42;i:65;i:32;i:66;i:45;i:67;i:32;i:68;i:27;i:69;i:45;i:70;i:30;i:71;i:41;i:72;i:42;i:73;i:25;i:74;i:44;i:75;i:36;i:76;i:46;i:77;i:40;i:78;i:38;i:79;i:37;i:80;i:31;i:81;i:47;i:82;i:33;i:83;i:27;i:84;i:33;i:85;i:19;i:86;i:45;i:87;i:32;i:88;i:28;i:89;i:27;i:90;i:45;i:91;i:43;i:92;i:21;i:93;i:45;i:94;i:42;i:95;i:27;i:96;i:46;i:97;i:48;i:98;i:42;i:99;i:37;i:100;i:29;i:101;i:44;i:102;i:38;i:103;i:46;i:104;i:45;i:105;i:29;i:106;i:48;i:107;i:32;i:108;i:37;i:109;i:30;i:110;i:41;i:111;i:41;i:112;i:22;i:113;i:43;i:114;i:47;i:115;i:45;i:116;i:38;i:117;i:32;i:118;i:33;i:119;i:44;i:120;i:34;i:121;i:34;i:122;i:37;i:123;i:46;i:124;i:35;i:125;i:45;i:126;i:45;i:127;i:38;i:128;i:45;i:129;i:37;i:130;i:39;i:131;i:44;i:132;i:25;i:133;i:42;i:134;i:33;i:135;i:47;i:136;i:44;i:137;i:32;i:138;i:31;i:139;i:32;i:140;i:43;i:141;i:39;i:142;i:35;i:143;i:48;i:144;i:38;i:145;i:28;i:146;i:24;i:147;i:43;i:148;i:42;i:149;i:40;i:150;i:40;i:151;i:24;i:152;i:48;i:153;i:42;i:154;i:46;i:155;i:42;i:156;i:47;i:157;i:35;i:158;i:32;i:159;i:41;i:160;i:44;i:161;i:44;i:162;i:22;i:163;i:19;i:164;i:11;i:165;i:15;i:166;i:7;i:167;i:13;i:168;i:14;i:169;i:22;i:170;i:11;i:171;i:23;i:172;i:34;i:173;i:40;i:174;i:34;i:175;i:41;i:176;i:47;i:177;i:41;i:178;i:8;i:179;i:25;i:180;i:21;i:181;i:22;i:182;i:25;i:183;i:27;i:184;i:46;i:185;i:20;i:186;i:28;i:187;i:27;i:188;i:22;i:189;i:25;i:190;i:20;i:191;i:26;i:192;i:33;i:193;i:30;i:194;i:45;i:195;i:36;i:196;i:36;i:197;i:36;i:198;i:26;i:199;i:22;}");
INSERT INTO `wp_postmeta` VALUES("827", "169", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("828", "169", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("829", "169", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("830", "169", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("831", "169", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("832", "169", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("833", "169", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("834", "169", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("835", "169", "post-count-month-202009", "2");
INSERT INTO `wp_postmeta` VALUES("836", "169", "post-count-year-2020", "13");
INSERT INTO `wp_postmeta` VALUES("837", "169", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("838", "169", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("839", "169", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("840", "169", "post-count-week-202046", "2");
INSERT INTO `wp_postmeta` VALUES("841", "169", "post-count-month-202011", "5");
INSERT INTO `wp_postmeta` VALUES("842", "169", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("843", "169", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("847", "169", "post-count-week-202047", "3");
INSERT INTO `wp_postmeta` VALUES("848", "169", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("849", "169", "post-count-month-202012", "5");
INSERT INTO `wp_postmeta` VALUES("850", "169", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("851", "169", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("852", "169", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("853", "169", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("854", "169", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("855", "169", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("856", "172", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/9c/e6/fd/9ce6fd38-1225-6ac3-f7a6-da80cb50346e/mzaf_1582186890349153418.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("857", "172", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("858", "172", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("859", "172", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("860", "172", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("861", "172", "purchase_url", "https://itunes.apple.com/us/album/happier/id1424703172?i=1424704480");
INSERT INTO `wp_postmeta` VALUES("862", "172", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("863", "172", "_thumbnail_id", "528");
INSERT INTO `wp_postmeta` VALUES("864", "172", "post-count-all", "153");
INSERT INTO `wp_postmeta` VALUES("865", "172", "post-count-week-201926", "11");
INSERT INTO `wp_postmeta` VALUES("866", "172", "post-count-month-201906", "11");
INSERT INTO `wp_postmeta` VALUES("867", "172", "post-count-year-2019", "14");
INSERT INTO `wp_postmeta` VALUES("868", "172", "like_count", "4");
INSERT INTO `wp_postmeta` VALUES("869", "172", "like_user", "a:4:{i:0;i:4;i:1;i:1;i:2;i:2;i:3;i:60;}");
INSERT INTO `wp_postmeta` VALUES("870", "172", "post-count-week-201927", "3");
INSERT INTO `wp_postmeta` VALUES("871", "172", "post-count-month-201907", "3");
INSERT INTO `wp_postmeta` VALUES("872", "172", "post-count-week-202037", "2");
INSERT INTO `wp_postmeta` VALUES("873", "172", "post-count-month-202009", "5");
INSERT INTO `wp_postmeta` VALUES("874", "172", "post-count-year-2020", "91");
INSERT INTO `wp_postmeta` VALUES("875", "172", "type", "single");
INSERT INTO `wp_postmeta` VALUES("876", "172", "post", "");
INSERT INTO `wp_postmeta` VALUES("877", "172", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("878", "172", "waveform_data", "a:200:{i:0;i:32;i:1;i:27;i:2;i:33;i:3;i:35;i:4;i:38;i:5;i:33;i:6;i:34;i:7;i:46;i:8;i:33;i:9;i:43;i:10;i:46;i:11;i:36;i:12;i:46;i:13;i:14;i:14;i:31;i:15;i:27;i:16;i:18;i:17;i:25;i:18;i:35;i:19;i:13;i:20;i:11;i:21;i:37;i:22;i:41;i:23;i:27;i:24;i:44;i:25;i:35;i:26;i:38;i:27;i:11;i:28;i:29;i:29;i:43;i:30;i:32;i:31;i:46;i:32;i:39;i:33;i:47;i:34;i:47;i:35;i:46;i:36;i:35;i:37;i:46;i:38;i:24;i:39;i:33;i:40;i:45;i:41;i:46;i:42;i:20;i:43;i:31;i:44;i:17;i:45;i:22;i:46;i:23;i:47;i:46;i:48;i:46;i:49;i:44;i:50;i:41;i:51;i:27;i:52;i:42;i:53;i:46;i:54;i:34;i:55;i:46;i:56;i:45;i:57;i:49;i:58;i:35;i:59;i:35;i:60;i:46;i:61;i:46;i:62;i:46;i:63;i:45;i:64;i:47;i:65;i:29;i:66;i:40;i:67;i:47;i:68;i:46;i:69;i:46;i:70;i:46;i:71;i:47;i:72;i:35;i:73;i:45;i:74;i:26;i:75;i:41;i:76;i:26;i:77;i:26;i:78;i:45;i:79;i:40;i:80;i:34;i:81;i:36;i:82;i:42;i:83;i:45;i:84;i:47;i:85;i:36;i:86;i:42;i:87;i:38;i:88;i:44;i:89;i:43;i:90;i:24;i:91;i:47;i:92;i:46;i:93;i:40;i:94;i:39;i:95;i:34;i:96;i:39;i:97;i:40;i:98;i:32;i:99;i:44;i:100;i:45;i:101;i:44;i:102;i:40;i:103;i:37;i:104;i:36;i:105;i:27;i:106;i:26;i:107;i:45;i:108;i:27;i:109;i:46;i:110;i:34;i:111;i:34;i:112;i:47;i:113;i:39;i:114;i:47;i:115;i:41;i:116;i:45;i:117;i:33;i:118;i:41;i:119;i:31;i:120;i:34;i:121;i:46;i:122;i:27;i:123;i:34;i:124;i:32;i:125;i:36;i:126;i:48;i:127;i:27;i:128;i:46;i:129;i:46;i:130;i:46;i:131;i:41;i:132;i:46;i:133;i:46;i:134;i:25;i:135;i:47;i:136;i:41;i:137;i:47;i:138;i:24;i:139;i:35;i:140;i:27;i:141;i:48;i:142;i:44;i:143;i:45;i:144;i:47;i:145;i:43;i:146;i:45;i:147;i:37;i:148;i:37;i:149;i:44;i:150;i:32;i:151;i:39;i:152;i:45;i:153;i:43;i:154;i:32;i:155;i:8;i:156;i:24;i:157;i:26;i:158;i:16;i:159;i:44;i:160;i:48;i:161;i:36;i:162;i:39;i:163;i:44;i:164;i:47;i:165;i:47;i:166;i:41;i:167;i:31;i:168;i:33;i:169;i:45;i:170;i:21;i:171;i:34;i:172;i:25;i:173;i:21;i:174;i:28;i:175;i:48;i:176;i:48;i:177;i:46;i:178;i:40;i:179;i:45;i:180;i:41;i:181;i:45;i:182;i:48;i:183;i:47;i:184;i:48;i:185;i:47;i:186;i:28;i:187;i:21;i:188;i:23;i:189;i:9;i:190;i:22;i:191;i:40;i:192;i:41;i:193;i:52;i:194;i:48;i:195;i:45;i:196;i:43;i:197;i:35;i:198;i:39;i:199;i:40;}");
INSERT INTO `wp_postmeta` VALUES("879", "172", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("880", "172", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("881", "172", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("882", "172", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("883", "172", "post-count-week-202039", "2");
INSERT INTO `wp_postmeta` VALUES("884", "172", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("885", "172", "post-count-month-202010", "4");
INSERT INTO `wp_postmeta` VALUES("886", "172", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("887", "172", "post-count-week-202045", "6");
INSERT INTO `wp_postmeta` VALUES("888", "172", "post-count-month-202011", "48");
INSERT INTO `wp_postmeta` VALUES("889", "172", "post-count-week-202046", "17");
INSERT INTO `wp_postmeta` VALUES("890", "172", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("891", "172", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("895", "172", "post-count-week-202047", "25");
INSERT INTO `wp_postmeta` VALUES("896", "172", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("897", "172", "post-count-month-202012", "34");
INSERT INTO `wp_postmeta` VALUES("898", "172", "post-count-week-202050", "8");
INSERT INTO `wp_postmeta` VALUES("899", "172", "post-count-week-202051", "17");
INSERT INTO `wp_postmeta` VALUES("900", "172", "post-count-week-202052", "6");
INSERT INTO `wp_postmeta` VALUES("901", "172", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("902", "172", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("903", "172", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("904", "172", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("905", "174", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/1d/44/74/1d447462-1811-5cfd-90f7-13edea1193d9/mzaf_5901924055590298818.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("906", "174", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("907", "174", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("908", "174", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("909", "174", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("910", "174", "purchase_url", "https://itunes.apple.com/us/album/thunderclouds-feat-sia-diplo-labrinth/id1420592739?i=1420593225");
INSERT INTO `wp_postmeta` VALUES("911", "174", "thumbnail_pos_y", "40");
INSERT INTO `wp_postmeta` VALUES("912", "174", "_thumbnail_id", "527");
INSERT INTO `wp_postmeta` VALUES("913", "174", "post-count-all", "141");
INSERT INTO `wp_postmeta` VALUES("914", "174", "post-count-week-201926", "4");
INSERT INTO `wp_postmeta` VALUES("915", "174", "post-count-month-201906", "4");
INSERT INTO `wp_postmeta` VALUES("916", "174", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("917", "174", "like_count", "7");
INSERT INTO `wp_postmeta` VALUES("918", "174", "like_user", "a:7:{i:0;i:3;i:1;i:1;i:2;i:13;i:3;i:9;i:4;i:59;i:5;i:62;i:6;i:65;}");
INSERT INTO `wp_postmeta` VALUES("919", "174", "post-count-week-201927", "1");
INSERT INTO `wp_postmeta` VALUES("920", "174", "post-count-month-201907", "1");
INSERT INTO `wp_postmeta` VALUES("921", "174", "type", "single");
INSERT INTO `wp_postmeta` VALUES("922", "174", "post", "");
INSERT INTO `wp_postmeta` VALUES("923", "174", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("924", "174", "waveform_data", "a:200:{i:0;i:36;i:1;i:49;i:2;i:33;i:3;i:19;i:4;i:49;i:5;i:49;i:6;i:23;i:7;i:29;i:8;i:18;i:9;i:10;i:10;i:24;i:11;i:28;i:12;i:35;i:13;i:45;i:14;i:23;i:15;i:49;i:16;i:36;i:17;i:38;i:18;i:47;i:19;i:48;i:20;i:34;i:21;i:16;i:22;i:39;i:23;i:24;i:24;i:49;i:25;i:32;i:26;i:15;i:27;i:19;i:28;i:19;i:29;i:47;i:30;i:49;i:31;i:25;i:32;i:28;i:33;i:48;i:34;i:24;i:35;i:30;i:36;i:24;i:37;i:31;i:38;i:49;i:39;i:45;i:40;i:36;i:41;i:23;i:42;i:43;i:43;i:30;i:44;i:40;i:45;i:27;i:46;i:32;i:47;i:45;i:48;i:46;i:49;i:49;i:50;i:26;i:51;i:28;i:52;i:36;i:53;i:29;i:54;i:50;i:55;i:43;i:56;i:28;i:57;i:26;i:58;i:47;i:59;i:34;i:60;i:30;i:61;i:29;i:62;i:34;i:63;i:29;i:64;i:28;i:65;i:38;i:66;i:18;i:67;i:45;i:68;i:46;i:69;i:35;i:70;i:42;i:71;i:29;i:72;i:48;i:73;i:43;i:74;i:29;i:75;i:30;i:76;i:46;i:77;i:41;i:78;i:39;i:79;i:29;i:80;i:20;i:81;i:32;i:82;i:26;i:83;i:27;i:84;i:24;i:85;i:22;i:86;i:48;i:87;i:48;i:88;i:31;i:89;i:31;i:90;i:49;i:91;i:38;i:92;i:48;i:93;i:35;i:94;i:42;i:95;i:46;i:96;i:47;i:97;i:45;i:98;i:30;i:99;i:26;i:100;i:29;i:101;i:48;i:102;i:43;i:103;i:42;i:104;i:34;i:105;i:47;i:106;i:33;i:107;i:30;i:108;i:34;i:109;i:41;i:110;i:44;i:111;i:32;i:112;i:31;i:113;i:41;i:114;i:22;i:115;i:38;i:116;i:39;i:117;i:34;i:118;i:37;i:119;i:48;i:120;i:36;i:121;i:39;i:122;i:46;i:123;i:40;i:124;i:41;i:125;i:40;i:126;i:28;i:127;i:29;i:128;i:32;i:129;i:48;i:130;i:50;i:131;i:30;i:132;i:24;i:133;i:37;i:134;i:49;i:135;i:32;i:136;i:44;i:137;i:33;i:138;i:37;i:139;i:50;i:140;i:26;i:141;i:25;i:142;i:31;i:143;i:14;i:144;i:49;i:145;i:46;i:146;i:24;i:147;i:49;i:148;i:42;i:149;i:45;i:150;i:16;i:151;i:20;i:152;i:25;i:153;i:48;i:154;i:47;i:155;i:31;i:156;i:50;i:157;i:49;i:158;i:16;i:159;i:20;i:160;i:35;i:161;i:32;i:162;i:27;i:163;i:44;i:164;i:50;i:165;i:30;i:166;i:26;i:167;i:38;i:168;i:49;i:169;i:28;i:170;i:28;i:171;i:49;i:172;i:18;i:173;i:18;i:174;i:31;i:175;i:45;i:176;i:30;i:177;i:21;i:178;i:41;i:179;i:37;i:180;i:23;i:181;i:40;i:182;i:49;i:183;i:33;i:184;i:26;i:185;i:46;i:186;i:38;i:187;i:21;i:188;i:43;i:189;i:47;i:190;i:18;i:191;i:36;i:192;i:50;i:193;i:48;i:194;i:27;i:195;i:23;i:196;i:37;i:197;i:35;i:198;i:30;i:199;i:45;}");
INSERT INTO `wp_postmeta` VALUES("925", "174", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("926", "174", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("927", "174", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("928", "174", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("929", "174", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("930", "174", "post-count-year-2020", "94");
INSERT INTO `wp_postmeta` VALUES("931", "174", "post-count-month-202011", "38");
INSERT INTO `wp_postmeta` VALUES("932", "174", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("933", "174", "post-count-week-202046", "33");
INSERT INTO `wp_postmeta` VALUES("934", "174", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("935", "174", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("939", "174", "post-count-week-202047", "2");
INSERT INTO `wp_postmeta` VALUES("940", "174", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("941", "174", "post-count-month-202012", "54");
INSERT INTO `wp_postmeta` VALUES("942", "174", "post-count-week-202050", "32");
INSERT INTO `wp_postmeta` VALUES("943", "174", "post-count-week-202051", "18");
INSERT INTO `wp_postmeta` VALUES("944", "174", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("945", "174", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("946", "174", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("947", "174", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("948", "174", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("949", "394", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("950", "394", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("951", "394", "_oembed_f706ef8d5cd1fab77ddfeaec445e6d1b", "<iframe title=\"Alok &amp; Sevenn - The Wall (Official Music Video)\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/Qs1IQAdp-60?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("952", "394", "_oembed_time_f706ef8d5cd1fab77ddfeaec445e6d1b", "1561904971");
INSERT INTO `wp_postmeta` VALUES("953", "394", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("954", "394", "_thumbnail_id", "708");
INSERT INTO `wp_postmeta` VALUES("955", "394", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("959", "420", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("960", "420", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("961", "420", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("962", "420", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("963", "420", "_thumbnail_id", "711");
INSERT INTO `wp_postmeta` VALUES("967", "477", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("968", "477", "type", "single");
INSERT INTO `wp_postmeta` VALUES("969", "477", "stream", "https://soundcloud.com/forss/voca-nomen-tuum");
INSERT INTO `wp_postmeta` VALUES("970", "477", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("971", "477", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("972", "477", "_wp_old_date", "2019-07-01");
INSERT INTO `wp_postmeta` VALUES("973", "477", "_thumbnail_id", "503");
INSERT INTO `wp_postmeta` VALUES("974", "477", "stream_url", "https://api.soundcloud.com/tracks/41772991/stream");
INSERT INTO `wp_postmeta` VALUES("975", "477", "duration", "213475");
INSERT INTO `wp_postmeta` VALUES("976", "477", "artwork_url", "https://i1.sndcdn.com/artworks-000020951702-l6ktuj-large.jpg");
INSERT INTO `wp_postmeta` VALUES("977", "477", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("978", "477", "download_url", "https://api.soundcloud.com/tracks/41772991/download");
INSERT INTO `wp_postmeta` VALUES("979", "477", "download_count", "1");
INSERT INTO `wp_postmeta` VALUES("980", "477", "post-count-all", "20");
INSERT INTO `wp_postmeta` VALUES("981", "477", "post-count-week-201927", "5");
INSERT INTO `wp_postmeta` VALUES("982", "477", "post-count-month-201907", "5");
INSERT INTO `wp_postmeta` VALUES("983", "477", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("984", "477", "post-count-week-202037", "4");
INSERT INTO `wp_postmeta` VALUES("985", "477", "post-count-month-202009", "4");
INSERT INTO `wp_postmeta` VALUES("986", "477", "post-count-year-2020", "11");
INSERT INTO `wp_postmeta` VALUES("987", "477", "post", "");
INSERT INTO `wp_postmeta` VALUES("988", "477", "purchase_title", "دانلود اپ هم ترانه");
INSERT INTO `wp_postmeta` VALUES("989", "477", "purchase_url", "http://itunes.com/app/ecclesia");
INSERT INTO `wp_postmeta` VALUES("990", "477", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("992", "477", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("993", "477", "post-count-week-202044", "5");
INSERT INTO `wp_postmeta` VALUES("994", "477", "post-count-month-202010", "5");
INSERT INTO `wp_postmeta` VALUES("995", "477", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("996", "477", "post-count-month-202012", "2");
INSERT INTO `wp_postmeta` VALUES("997", "477", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("998", "477", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("999", "477", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1000", "477", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1001", "924", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1007", "1024", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1013", "1116", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1014", "1118", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1015", "1123", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1021", "1168", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1025", "176", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview125/v4/27/a0/69/27a0692a-0205-87f2-1fbf-eec75a5dc94d/mzaf_8399436585982263723.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1026", "176", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1027", "176", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1028", "176", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1029", "176", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1030", "176", "purchase_url", "https://itunes.apple.com/us/album/girls-like-you/id1396383479?i=1396383939");
INSERT INTO `wp_postmeta` VALUES("1031", "176", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1032", "176", "_thumbnail_id", "526");
INSERT INTO `wp_postmeta` VALUES("1033", "176", "post-count-all", "96");
INSERT INTO `wp_postmeta` VALUES("1034", "176", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1035", "176", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1036", "176", "post-count-year-2019", "3");
INSERT INTO `wp_postmeta` VALUES("1037", "176", "like_count", "5");
INSERT INTO `wp_postmeta` VALUES("1038", "176", "like_user", "a:5:{i:0;i:4;i:1;i:5;i:2;i:1;i:3;i:9;i:4;i:52;}");
INSERT INTO `wp_postmeta` VALUES("1039", "176", "post-count-week-201927", "1");
INSERT INTO `wp_postmeta` VALUES("1040", "176", "post-count-month-201907", "1");
INSERT INTO `wp_postmeta` VALUES("1041", "176", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1042", "176", "post", "");
INSERT INTO `wp_postmeta` VALUES("1043", "176", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1044", "176", "waveform_data", "a:200:{i:0;i:19;i:1;i:25;i:2;i:26;i:3;i:20;i:4;i:27;i:5;i:14;i:6;i:22;i:7;i:26;i:8;i:17;i:9;i:24;i:10;i:11;i:11;i:28;i:12;i:27;i:13;i:24;i:14;i:9;i:15;i:33;i:16;i:34;i:17;i:17;i:18;i:12;i:19;i:27;i:20;i:34;i:21;i:27;i:22;i:32;i:23;i:20;i:24;i:23;i:25;i:18;i:26;i:17;i:27;i:18;i:28;i:15;i:29;i:18;i:30;i:28;i:31;i:15;i:32;i:22;i:33;i:24;i:34;i:24;i:35;i:32;i:36;i:18;i:37;i:30;i:38;i:28;i:39;i:26;i:40;i:24;i:41;i:25;i:42;i:13;i:43;i:17;i:44;i:14;i:45;i:21;i:46;i:20;i:47;i:28;i:48;i:19;i:49;i:15;i:50;i:30;i:51;i:21;i:52;i:17;i:53;i:27;i:54;i:29;i:55;i:31;i:56;i:17;i:57;i:27;i:58;i:23;i:59;i:47;i:60;i:47;i:61;i:22;i:62;i:24;i:63;i:17;i:64;i:26;i:65;i:32;i:66;i:40;i:67;i:35;i:68;i:17;i:69;i:27;i:70;i:12;i:71;i:18;i:72;i:48;i:73;i:48;i:74;i:37;i:75;i:39;i:76;i:38;i:77;i:27;i:78;i:26;i:79;i:36;i:80;i:16;i:81;i:23;i:82;i:24;i:83;i:29;i:84;i:34;i:85;i:48;i:86;i:32;i:87;i:42;i:88;i:47;i:89;i:39;i:90;i:19;i:91;i:30;i:92;i:34;i:93;i:25;i:94;i:29;i:95;i:27;i:96;i:28;i:97;i:22;i:98;i:46;i:99;i:47;i:100;i:39;i:101;i:30;i:102;i:36;i:103;i:28;i:104;i:18;i:105;i:46;i:106;i:21;i:107;i:28;i:108;i:38;i:109;i:22;i:110;i:23;i:111;i:42;i:112;i:33;i:113;i:45;i:114;i:43;i:115;i:46;i:116;i:28;i:117;i:31;i:118;i:26;i:119;i:17;i:120;i:25;i:121;i:20;i:122;i:39;i:123;i:28;i:124;i:42;i:125;i:34;i:126;i:35;i:127;i:38;i:128;i:28;i:129;i:30;i:130;i:42;i:131;i:18;i:132;i:18;i:133;i:23;i:134;i:26;i:135;i:18;i:136;i:22;i:137;i:36;i:138;i:35;i:139;i:41;i:140;i:43;i:141;i:33;i:142;i:31;i:143;i:37;i:144;i:25;i:145;i:22;i:146;i:37;i:147;i:35;i:148;i:32;i:149;i:39;i:150;i:44;i:151;i:42;i:152;i:33;i:153;i:38;i:154;i:37;i:155;i:38;i:156;i:30;i:157;i:32;i:158;i:32;i:159;i:27;i:160;i:22;i:161;i:19;i:162;i:27;i:163;i:18;i:164;i:11;i:165;i:15;i:166;i:26;i:167;i:20;i:168;i:15;i:169;i:34;i:170;i:10;i:171;i:7;i:172;i:12;i:173;i:13;i:174;i:14;i:175;i:22;i:176;i:22;i:177;i:27;i:178;i:21;i:179;i:14;i:180;i:13;i:181;i:29;i:182;i:13;i:183;i:15;i:184;i:8;i:185;i:14;i:186;i:20;i:187;i:18;i:188;i:18;i:189;i:26;i:190;i:28;i:191;i:18;i:192;i:14;i:193;i:15;i:194;i:14;i:195;i:9;i:196;i:5;i:197;i:6;i:198;i:4;i:199;i:11;}");
INSERT INTO `wp_postmeta` VALUES("1045", "176", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1046", "176", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1047", "176", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("1048", "176", "post-count-month-202009", "2");
INSERT INTO `wp_postmeta` VALUES("1049", "176", "post-count-year-2020", "56");
INSERT INTO `wp_postmeta` VALUES("1050", "176", "download_count", "25");
INSERT INTO `wp_postmeta` VALUES("1051", "176", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("1052", "176", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("1053", "176", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("1054", "176", "post-count-month-202011", "30");
INSERT INTO `wp_postmeta` VALUES("1055", "176", "post-count-week-202045", "3");
INSERT INTO `wp_postmeta` VALUES("1056", "176", "post-count-week-202046", "16");
INSERT INTO `wp_postmeta` VALUES("1057", "176", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1058", "176", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1062", "176", "post-count-week-202047", "10");
INSERT INTO `wp_postmeta` VALUES("1063", "176", "post-count-week-202050", "6");
INSERT INTO `wp_postmeta` VALUES("1064", "176", "post-count-month-202012", "22");
INSERT INTO `wp_postmeta` VALUES("1065", "176", "post-count-week-202051", "13");
INSERT INTO `wp_postmeta` VALUES("1066", "176", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1067", "176", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("1068", "176", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1069", "176", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1070", "176", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1071", "178", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/54/29/c1/5429c111-92a4-a647-6e85-0577343fbf45/mzaf_5955739319318374110.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1072", "178", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1073", "178", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1074", "178", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1075", "178", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1076", "178", "purchase_url", "https://itunes.apple.com/us/album/mia-feat-drake/id1438445670?i=1438445674");
INSERT INTO `wp_postmeta` VALUES("1077", "178", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("1078", "178", "_thumbnail_id", "529");
INSERT INTO `wp_postmeta` VALUES("1079", "178", "post-count-all", "111");
INSERT INTO `wp_postmeta` VALUES("1080", "178", "post-count-week-201926", "5");
INSERT INTO `wp_postmeta` VALUES("1081", "178", "post-count-month-201906", "5");
INSERT INTO `wp_postmeta` VALUES("1082", "178", "post-count-year-2019", "7");
INSERT INTO `wp_postmeta` VALUES("1083", "178", "like_count", "6");
INSERT INTO `wp_postmeta` VALUES("1084", "178", "like_user", "a:6:{i:0;i:3;i:1;i:1;i:2;i:36;i:3;i:37;i:4;i:62;i:5;i:63;}");
INSERT INTO `wp_postmeta` VALUES("1085", "178", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1086", "178", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1087", "178", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1088", "178", "post", "");
INSERT INTO `wp_postmeta` VALUES("1089", "178", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1090", "178", "waveform_data", "a:200:{i:0;i:24;i:1;i:41;i:2;i:15;i:3;i:10;i:4;i:11;i:5;i:10;i:6;i:11;i:7;i:10;i:8;i:12;i:9;i:10;i:10;i:7;i:11;i:37;i:12;i:31;i:13;i:46;i:14;i:40;i:15;i:44;i:16;i:24;i:17;i:40;i:18;i:45;i:19;i:48;i:20;i:46;i:21;i:29;i:22;i:42;i:23;i:50;i:24;i:47;i:25;i:28;i:26;i:31;i:27;i:47;i:28;i:44;i:29;i:25;i:30;i:24;i:31;i:42;i:32;i:41;i:33;i:42;i:34;i:50;i:35;i:45;i:36;i:45;i:37;i:45;i:38;i:43;i:39;i:40;i:40;i:50;i:41;i:34;i:42;i:48;i:43;i:46;i:44;i:42;i:45;i:31;i:46;i:17;i:47;i:49;i:48;i:42;i:49;i:43;i:50;i:36;i:51;i:28;i:52;i:48;i:53;i:49;i:54;i:44;i:55;i:39;i:56;i:45;i:57;i:43;i:58;i:45;i:59;i:37;i:60;i:46;i:61;i:39;i:62;i:26;i:63;i:33;i:64;i:42;i:65;i:48;i:66;i:24;i:67;i:43;i:68;i:41;i:69;i:41;i:70;i:37;i:71;i:42;i:72;i:48;i:73;i:48;i:74;i:41;i:75;i:36;i:76;i:41;i:77;i:48;i:78;i:35;i:79;i:27;i:80;i:37;i:81;i:44;i:82;i:33;i:83;i:47;i:84;i:28;i:85;i:46;i:86;i:38;i:87;i:42;i:88;i:46;i:89;i:47;i:90;i:49;i:91;i:42;i:92;i:40;i:93;i:49;i:94;i:46;i:95;i:29;i:96;i:40;i:97;i:49;i:98;i:49;i:99;i:30;i:100;i:45;i:101;i:38;i:102;i:36;i:103;i:36;i:104;i:34;i:105;i:48;i:106;i:49;i:107;i:30;i:108;i:41;i:109;i:42;i:110;i:43;i:111;i:39;i:112;i:29;i:113;i:44;i:114;i:46;i:115;i:38;i:116;i:30;i:117;i:48;i:118;i:45;i:119;i:45;i:120;i:30;i:121;i:41;i:122;i:43;i:123;i:38;i:124;i:27;i:125;i:37;i:126;i:47;i:127;i:47;i:128;i:22;i:129;i:23;i:130;i:48;i:131;i:47;i:132;i:31;i:133;i:47;i:134;i:47;i:135;i:47;i:136;i:34;i:137;i:28;i:138;i:37;i:139;i:49;i:140;i:37;i:141;i:46;i:142;i:31;i:143;i:49;i:144;i:40;i:145;i:16;i:146;i:46;i:147;i:38;i:148;i:42;i:149;i:34;i:150;i:27;i:151;i:42;i:152;i:42;i:153;i:26;i:154;i:13;i:155;i:47;i:156;i:43;i:157;i:17;i:158;i:12;i:159;i:37;i:160;i:49;i:161;i:26;i:162;i:10;i:163;i:14;i:164;i:17;i:165;i:14;i:166;i:13;i:167;i:12;i:168;i:11;i:169;i:16;i:170;i:18;i:171;i:11;i:172;i:14;i:173;i:8;i:174;i:26;i:175;i:23;i:176;i:37;i:177;i:26;i:178;i:15;i:179;i:29;i:180;i:49;i:181;i:40;i:182;i:28;i:183;i:28;i:184;i:45;i:185;i:44;i:186;i:26;i:187;i:16;i:188;i:31;i:189;i:48;i:190;i:17;i:191;i:35;i:192;i:47;i:193;i:49;i:194;i:25;i:195;i:13;i:196;i:25;i:197;i:42;i:198;i:24;i:199;i:23;}");
INSERT INTO `wp_postmeta` VALUES("1091", "178", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1092", "178", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1093", "178", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1094", "178", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("1095", "178", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1096", "178", "post-count-year-2020", "59");
INSERT INTO `wp_postmeta` VALUES("1097", "178", "post-count-month-202011", "32");
INSERT INTO `wp_postmeta` VALUES("1098", "178", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("1099", "178", "post-count-week-202046", "26");
INSERT INTO `wp_postmeta` VALUES("1100", "178", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1101", "178", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1105", "178", "post-count-week-202047", "2");
INSERT INTO `wp_postmeta` VALUES("1106", "178", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("1107", "178", "post-count-month-202012", "26");
INSERT INTO `wp_postmeta` VALUES("1108", "178", "post-count-week-202050", "7");
INSERT INTO `wp_postmeta` VALUES("1109", "178", "post-count-week-202051", "15");
INSERT INTO `wp_postmeta` VALUES("1110", "178", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1111", "178", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1112", "178", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1113", "178", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1114", "178", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1115", "180", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/11/72/7e/11727eb5-b6c6-f80f-ddd9-2fb9135c07b1/mzaf_3150787160306402060.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1116", "180", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1117", "180", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1118", "180", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1119", "180", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1120", "180", "purchase_url", "https://itunes.apple.com/cn/album/sunflower-spider-man-into-the-spider-verse/id1439090291?i=1439090295");
INSERT INTO `wp_postmeta` VALUES("1121", "180", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1122", "180", "_thumbnail_id", "524");
INSERT INTO `wp_postmeta` VALUES("1123", "180", "post-count-all", "115");
INSERT INTO `wp_postmeta` VALUES("1124", "180", "post-count-week-201926", "3");
INSERT INTO `wp_postmeta` VALUES("1125", "180", "post-count-month-201906", "3");
INSERT INTO `wp_postmeta` VALUES("1126", "180", "post-count-year-2019", "4");
INSERT INTO `wp_postmeta` VALUES("1127", "180", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1128", "180", "like_user", "a:2:{i:0;i:4;i:1;i:3;}");
INSERT INTO `wp_postmeta` VALUES("1129", "180", "post-count-week-201927", "1");
INSERT INTO `wp_postmeta` VALUES("1130", "180", "post-count-month-201907", "1");
INSERT INTO `wp_postmeta` VALUES("1131", "180", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1132", "180", "post", "");
INSERT INTO `wp_postmeta` VALUES("1133", "180", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1134", "180", "waveform_data", "a:200:{i:0;i:19;i:1;i:37;i:2;i:12;i:3;i:25;i:4;i:25;i:5;i:32;i:6;i:31;i:7;i:25;i:8;i:19;i:9;i:18;i:10;i:22;i:11;i:9;i:12;i:40;i:13;i:30;i:14;i:21;i:15;i:26;i:16;i:23;i:17;i:22;i:18;i:35;i:19;i:17;i:20;i:18;i:21;i:26;i:22;i:23;i:23;i:20;i:24;i:14;i:25;i:22;i:26;i:18;i:27;i:25;i:28;i:12;i:29;i:22;i:30;i:32;i:31;i:18;i:32;i:13;i:33;i:16;i:34;i:22;i:35;i:14;i:36;i:14;i:37;i:14;i:38;i:12;i:39;i:16;i:40;i:22;i:41;i:21;i:42;i:25;i:43;i:27;i:44;i:28;i:45;i:45;i:46;i:17;i:47;i:15;i:48;i:20;i:49;i:15;i:50;i:20;i:51;i:22;i:52;i:17;i:53;i:17;i:54;i:13;i:55;i:21;i:56;i:13;i:57;i:19;i:58;i:17;i:59;i:14;i:60;i:31;i:61;i:14;i:62;i:18;i:63;i:28;i:64;i:20;i:65;i:24;i:66;i:18;i:67;i:15;i:68;i:19;i:69;i:14;i:70;i:24;i:71;i:19;i:72;i:33;i:73;i:14;i:74;i:26;i:75;i:26;i:76;i:24;i:77;i:25;i:78;i:25;i:79;i:14;i:80;i:22;i:81;i:33;i:82;i:20;i:83;i:22;i:84;i:22;i:85;i:21;i:86;i:13;i:87;i:18;i:88;i:19;i:89;i:22;i:90;i:18;i:91;i:18;i:92;i:19;i:93;i:15;i:94;i:19;i:95;i:20;i:96;i:22;i:97;i:12;i:98;i:12;i:99;i:17;i:100;i:13;i:101;i:26;i:102;i:24;i:103;i:26;i:104;i:24;i:105;i:21;i:106;i:17;i:107;i:14;i:108;i:16;i:109;i:10;i:110;i:20;i:111;i:19;i:112;i:27;i:113;i:28;i:114;i:22;i:115;i:21;i:116;i:17;i:117;i:28;i:118;i:27;i:119;i:22;i:120;i:25;i:121;i:23;i:122;i:19;i:123;i:17;i:124;i:13;i:125;i:13;i:126;i:11;i:127;i:19;i:128;i:16;i:129;i:29;i:130;i:17;i:131;i:22;i:132;i:19;i:133;i:25;i:134;i:26;i:135;i:28;i:136;i:15;i:137;i:20;i:138;i:16;i:139;i:15;i:140;i:22;i:141;i:15;i:142;i:19;i:143;i:20;i:144;i:14;i:145;i:9;i:146;i:27;i:147;i:22;i:148;i:19;i:149;i:25;i:150;i:23;i:151;i:16;i:152;i:19;i:153;i:16;i:154;i:15;i:155;i:18;i:156;i:21;i:157;i:20;i:158;i:17;i:159;i:17;i:160;i:21;i:161;i:17;i:162;i:20;i:163;i:21;i:164;i:31;i:165;i:28;i:166;i:46;i:167;i:40;i:168;i:21;i:169;i:31;i:170;i:31;i:171;i:17;i:172;i:43;i:173;i:41;i:174;i:41;i:175;i:31;i:176;i:31;i:177;i:33;i:178;i:30;i:179;i:35;i:180;i:36;i:181;i:24;i:182;i:36;i:183;i:45;i:184;i:45;i:185;i:38;i:186;i:24;i:187;i:25;i:188;i:31;i:189;i:24;i:190;i:44;i:191;i:43;i:192;i:31;i:193;i:22;i:194;i:23;i:195;i:30;i:196;i:29;i:197;i:35;i:198;i:27;i:199;i:33;}");
INSERT INTO `wp_postmeta` VALUES("1135", "180", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1136", "180", "download_count", "4");
INSERT INTO `wp_postmeta` VALUES("1137", "180", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1138", "180", "post-count-week-202044", "8");
INSERT INTO `wp_postmeta` VALUES("1139", "180", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("1140", "180", "post-count-year-2020", "94");
INSERT INTO `wp_postmeta` VALUES("1141", "180", "post-count-month-202011", "67");
INSERT INTO `wp_postmeta` VALUES("1142", "180", "post-count-week-202045", "4");
INSERT INTO `wp_postmeta` VALUES("1143", "180", "post-count-week-202046", "56");
INSERT INTO `wp_postmeta` VALUES("1144", "180", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1145", "180", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1149", "180", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("1150", "180", "post-count-week-202050", "6");
INSERT INTO `wp_postmeta` VALUES("1151", "180", "post-count-month-202012", "25");
INSERT INTO `wp_postmeta` VALUES("1152", "180", "post-count-week-202051", "15");
INSERT INTO `wp_postmeta` VALUES("1153", "180", "post-count-week-202052", "3");
INSERT INTO `wp_postmeta` VALUES("1154", "180", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1155", "180", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1156", "180", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1157", "180", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1158", "182", "post", "148,146,172,174,178,180,203,176");
INSERT INTO `wp_postmeta` VALUES("1159", "182", "type", "album");
INSERT INTO `wp_postmeta` VALUES("1160", "182", "stream", "");
INSERT INTO `wp_postmeta` VALUES("1161", "182", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1162", "182", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1163", "182", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1164", "182", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1165", "182", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1166", "182", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("1167", "182", "_thumbnail_id", "518");
INSERT INTO `wp_postmeta` VALUES("1168", "182", "post-count-all", "29");
INSERT INTO `wp_postmeta` VALUES("1169", "182", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1170", "182", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1171", "182", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1172", "182", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1173", "182", "like_user", "a:2:{i:0;i:3;i:1;i:2;}");
INSERT INTO `wp_postmeta` VALUES("1174", "182", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1175", "182", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("1176", "182", "post-count-week-202044", "2");
INSERT INTO `wp_postmeta` VALUES("1177", "182", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1178", "182", "post-count-year-2020", "11");
INSERT INTO `wp_postmeta` VALUES("1179", "182", "post-count-month-202011", "7");
INSERT INTO `wp_postmeta` VALUES("1180", "182", "post-count-week-202045", "4");
INSERT INTO `wp_postmeta` VALUES("1181", "182", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1182", "182", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1183", "182", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1184", "182", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1185", "182", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1189", "182", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1190", "182", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("1191", "182", "post-count-week-202052", "3");
INSERT INTO `wp_postmeta` VALUES("1192", "182", "post-count-month-202012", "3");
INSERT INTO `wp_postmeta` VALUES("1193", "182", "post-count-week-202101", "2");
INSERT INTO `wp_postmeta` VALUES("1194", "182", "post-count-month-202101", "2");
INSERT INTO `wp_postmeta` VALUES("1195", "182", "post-count-year-2021", "2");
INSERT INTO `wp_postmeta` VALUES("1196", "186", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview125/v4/53/85/65/538565bd-5529-4d94-c5b0-5030ad266024/mzaf_72019562509153648.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1197", "186", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1198", "186", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1199", "186", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1200", "186", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1201", "186", "purchase_url", "https://itunes.apple.com/us/album/eastside/id1405952326?i=1405952327");
INSERT INTO `wp_postmeta` VALUES("1202", "186", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("1203", "186", "_thumbnail_id", "523");
INSERT INTO `wp_postmeta` VALUES("1204", "186", "post-count-all", "27");
INSERT INTO `wp_postmeta` VALUES("1205", "186", "post-count-week-201926", "3");
INSERT INTO `wp_postmeta` VALUES("1206", "186", "post-count-month-201906", "3");
INSERT INTO `wp_postmeta` VALUES("1207", "186", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("1208", "186", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1209", "186", "like_user", "a:1:{i:0;i:4;}");
INSERT INTO `wp_postmeta` VALUES("1210", "186", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1211", "186", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1212", "186", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1213", "186", "post", "");
INSERT INTO `wp_postmeta` VALUES("1214", "186", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1215", "186", "waveform_data", "a:200:{i:0;i:26;i:1;i:30;i:2;i:34;i:3;i:26;i:4;i:48;i:5;i:27;i:6;i:29;i:7;i:47;i:8;i:33;i:9;i:22;i:10;i:49;i:11;i:26;i:12;i:40;i:13;i:48;i:14;i:22;i:15;i:45;i:16;i:47;i:17;i:20;i:18;i:19;i:19;i:25;i:20;i:35;i:21;i:47;i:22;i:48;i:23;i:21;i:24;i:35;i:25;i:47;i:26;i:20;i:27;i:24;i:28;i:17;i:29;i:16;i:30;i:47;i:31;i:33;i:32;i:27;i:33;i:29;i:34;i:47;i:35;i:10;i:36;i:10;i:37;i:14;i:38;i:28;i:39;i:48;i:40;i:31;i:41;i:30;i:42;i:31;i:43;i:45;i:44;i:9;i:45;i:30;i:46;i:26;i:47;i:24;i:48;i:11;i:49;i:27;i:50;i:20;i:51;i:13;i:52;i:16;i:53;i:31;i:54;i:27;i:55;i:29;i:56;i:14;i:57;i:48;i:58;i:15;i:59;i:31;i:60;i:46;i:61;i:45;i:62;i:17;i:63;i:14;i:64;i:32;i:65;i:28;i:66;i:36;i:67;i:20;i:68;i:32;i:69;i:29;i:70;i:14;i:71;i:50;i:72;i:16;i:73;i:32;i:74;i:22;i:75;i:45;i:76;i:29;i:77;i:30;i:78;i:48;i:79;i:23;i:80;i:18;i:81;i:48;i:82;i:24;i:83;i:15;i:84;i:46;i:85;i:29;i:86;i:31;i:87;i:47;i:88;i:29;i:89;i:29;i:90;i:32;i:91;i:39;i:92;i:29;i:93;i:39;i:94;i:16;i:95;i:40;i:96;i:48;i:97;i:28;i:98;i:25;i:99;i:33;i:100;i:12;i:101;i:15;i:102;i:32;i:103;i:21;i:104;i:41;i:105;i:48;i:106;i:12;i:107;i:21;i:108;i:29;i:109;i:24;i:110;i:26;i:111;i:48;i:112;i:23;i:113;i:33;i:114;i:32;i:115;i:30;i:116;i:25;i:117;i:33;i:118;i:32;i:119;i:33;i:120;i:35;i:121;i:31;i:122;i:31;i:123;i:48;i:124;i:27;i:125;i:27;i:126;i:23;i:127;i:30;i:128;i:43;i:129;i:34;i:130;i:14;i:131;i:34;i:132;i:48;i:133;i:20;i:134;i:34;i:135;i:34;i:136;i:24;i:137;i:47;i:138;i:41;i:139;i:31;i:140;i:37;i:141;i:45;i:142;i:22;i:143;i:25;i:144;i:49;i:145;i:20;i:146;i:47;i:147;i:32;i:148;i:37;i:149;i:35;i:150;i:36;i:151;i:30;i:152;i:35;i:153;i:33;i:154;i:22;i:155;i:40;i:156;i:21;i:157;i:34;i:158;i:48;i:159;i:47;i:160;i:18;i:161;i:44;i:162;i:47;i:163;i:49;i:164;i:33;i:165;i:25;i:166;i:44;i:167;i:49;i:168;i:41;i:169;i:24;i:170;i:49;i:171;i:29;i:172;i:24;i:173;i:48;i:174;i:17;i:175;i:26;i:176;i:48;i:177;i:33;i:178;i:30;i:179;i:24;i:180;i:34;i:181;i:31;i:182;i:37;i:183;i:34;i:184;i:45;i:185;i:48;i:186;i:24;i:187;i:43;i:188;i:24;i:189;i:25;i:190;i:18;i:191;i:47;i:192;i:22;i:193;i:35;i:194;i:49;i:195;i:31;i:196;i:22;i:197;i:36;i:198;i:36;i:199;i:26;}");
INSERT INTO `wp_postmeta` VALUES("1216", "186", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1217", "186", "download_count", "3");
INSERT INTO `wp_postmeta` VALUES("1218", "186", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1219", "186", "post-count-week-202044", "5");
INSERT INTO `wp_postmeta` VALUES("1220", "186", "post-count-month-202010", "5");
INSERT INTO `wp_postmeta` VALUES("1221", "186", "post-count-year-2020", "18");
INSERT INTO `wp_postmeta` VALUES("1222", "186", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("1223", "186", "post-count-month-202011", "3");
INSERT INTO `wp_postmeta` VALUES("1224", "186", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1225", "186", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1226", "186", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1230", "186", "post-count-week-202050", "4");
INSERT INTO `wp_postmeta` VALUES("1231", "186", "post-count-month-202012", "10");
INSERT INTO `wp_postmeta` VALUES("1232", "186", "post-count-week-202051", "3");
INSERT INTO `wp_postmeta` VALUES("1233", "186", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("1234", "186", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1235", "186", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1236", "186", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1237", "186", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1238", "188", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/03/e5/25/03e52558-25b4-e41a-8b0a-c5ee14cf51de/mzaf_7464768196891763269.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1239", "188", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1240", "188", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1241", "188", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1242", "188", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1243", "188", "purchase_url", "https://itunes.apple.com/us/album/later-bitches/id1369253595?i=1369253917");
INSERT INTO `wp_postmeta` VALUES("1244", "188", "thumbnail_pos_y", "40");
INSERT INTO `wp_postmeta` VALUES("1245", "188", "_thumbnail_id", "517");
INSERT INTO `wp_postmeta` VALUES("1246", "188", "post-count-all", "20");
INSERT INTO `wp_postmeta` VALUES("1247", "188", "post-count-week-201926", "1");
INSERT INTO `wp_postmeta` VALUES("1248", "188", "post-count-month-201906", "1");
INSERT INTO `wp_postmeta` VALUES("1249", "188", "post-count-year-2019", "3");
INSERT INTO `wp_postmeta` VALUES("1250", "188", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1251", "188", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1252", "188", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1253", "188", "post", "");
INSERT INTO `wp_postmeta` VALUES("1254", "188", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1255", "188", "waveform_data", "a:200:{i:0;i:38;i:1;i:8;i:2;i:15;i:3;i:35;i:4;i:27;i:5;i:13;i:6;i:37;i:7;i:29;i:8;i:8;i:9;i:39;i:10;i:33;i:11;i:16;i:12;i:4;i:13;i:40;i:14;i:25;i:15;i:9;i:16;i:34;i:17;i:31;i:18;i:4;i:19;i:16;i:20;i:34;i:21;i:9;i:22;i:23;i:23;i:39;i:24;i:21;i:25;i:7;i:26;i:33;i:27;i:25;i:28;i:5;i:29;i:26;i:30;i:38;i:31;i:27;i:32;i:25;i:33;i:42;i:34;i:20;i:35;i:22;i:36;i:38;i:37;i:37;i:38;i:21;i:39;i:41;i:40;i:39;i:41;i:13;i:42;i:17;i:43;i:37;i:44;i:19;i:45;i:15;i:46;i:3;i:47;i:9;i:48;i:13;i:49;i:17;i:50;i:13;i:51;i:18;i:52;i:6;i:53;i:8;i:54;i:34;i:55;i:32;i:56;i:8;i:57;i:25;i:58;i:22;i:59;i:11;i:60;i:11;i:61;i:15;i:62;i:15;i:63;i:23;i:64;i:32;i:65;i:28;i:66;i:20;i:67;i:6;i:68;i:21;i:69;i:15;i:70;i:11;i:71;i:16;i:72;i:23;i:73;i:23;i:74;i:22;i:75;i:8;i:76;i:24;i:77;i:15;i:78;i:15;i:79;i:7;i:80;i:13;i:81;i:17;i:82;i:21;i:83;i:15;i:84;i:14;i:85;i:3;i:86;i:11;i:87;i:17;i:88;i:16;i:89;i:16;i:90;i:20;i:91;i:26;i:92;i:14;i:93;i:14;i:94;i:7;i:95;i:12;i:96;i:13;i:97;i:19;i:98;i:12;i:99;i:14;i:100;i:19;i:101;i:18;i:102;i:13;i:103;i:9;i:104;i:20;i:105;i:12;i:106;i:11;i:107;i:11;i:108;i:3;i:109;i:21;i:110;i:16;i:111;i:20;i:112;i:11;i:113;i:16;i:114;i:14;i:115;i:18;i:116;i:17;i:117;i:24;i:118;i:13;i:119;i:10;i:120;i:5;i:121;i:14;i:122;i:21;i:123;i:12;i:124;i:27;i:125;i:18;i:126;i:14;i:127;i:29;i:128;i:18;i:129;i:15;i:130;i:32;i:131;i:19;i:132;i:13;i:133;i:17;i:134;i:3;i:135;i:16;i:136;i:7;i:137;i:23;i:138;i:7;i:139;i:15;i:140;i:30;i:141;i:28;i:142;i:9;i:143;i:7;i:144;i:12;i:145;i:20;i:146;i:9;i:147;i:6;i:148;i:18;i:149;i:17;i:150;i:18;i:151;i:14;i:152;i:9;i:153;i:17;i:154;i:24;i:155;i:14;i:156;i:13;i:157;i:24;i:158;i:21;i:159;i:14;i:160;i:21;i:161;i:21;i:162;i:4;i:163;i:21;i:164;i:28;i:165;i:35;i:166;i:41;i:167;i:28;i:168;i:19;i:169;i:46;i:170;i:23;i:171;i:16;i:172;i:36;i:173;i:25;i:174;i:14;i:175;i:40;i:176;i:33;i:177;i:21;i:178;i:31;i:179;i:40;i:180;i:20;i:181;i:21;i:182;i:39;i:183;i:23;i:184;i:30;i:185;i:42;i:186;i:36;i:187;i:10;i:188;i:29;i:189;i:33;i:190;i:13;i:191;i:9;i:192;i:47;i:193;i:41;i:194;i:17;i:195;i:37;i:196;i:19;i:197;i:19;i:198;i:32;i:199;i:36;}");
INSERT INTO `wp_postmeta` VALUES("1256", "188", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1257", "188", "like_count", "0");
INSERT INTO `wp_postmeta` VALUES("1258", "188", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1259", "188", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1260", "188", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("1261", "188", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("1262", "188", "post-count-year-2020", "13");
INSERT INTO `wp_postmeta` VALUES("1263", "188", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1264", "188", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1265", "188", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("1266", "188", "post-count-month-202011", "4");
INSERT INTO `wp_postmeta` VALUES("1267", "188", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1268", "188", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1269", "188", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1273", "188", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("1274", "188", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1275", "188", "post-count-month-202012", "7");
INSERT INTO `wp_postmeta` VALUES("1276", "188", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1277", "188", "post-count-week-202052", "3");
INSERT INTO `wp_postmeta` VALUES("1278", "188", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1279", "188", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1280", "188", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1281", "188", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1282", "190", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview127/v4/2f/66/71/2f6671ab-482a-99c4-6aba-41b1c608d637/mzaf_5589980244851838569.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1283", "190", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1284", "190", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1285", "190", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1286", "190", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1287", "190", "purchase_url", "https://itunes.apple.com/us/album/zeze-feat-travis-scott-offset/id1438652330?i=1438652331");
INSERT INTO `wp_postmeta` VALUES("1288", "190", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1289", "190", "_thumbnail_id", "514");
INSERT INTO `wp_postmeta` VALUES("1290", "190", "post-count-all", "19");
INSERT INTO `wp_postmeta` VALUES("1291", "190", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1292", "190", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1293", "190", "post-count-year-2019", "4");
INSERT INTO `wp_postmeta` VALUES("1294", "190", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1295", "190", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1296", "190", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1297", "190", "post", "");
INSERT INTO `wp_postmeta` VALUES("1298", "190", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1299", "190", "waveform_data", "a:200:{i:0;i:5;i:1;i:4;i:2;i:3;i:3;i:19;i:4;i:13;i:5;i:29;i:6;i:17;i:7;i:21;i:8;i:20;i:9;i:14;i:10;i:26;i:11;i:25;i:12;i:16;i:13;i:18;i:14;i:16;i:15;i:20;i:16;i:13;i:17;i:19;i:18;i:23;i:19;i:16;i:20;i:21;i:21;i:20;i:22;i:22;i:23;i:16;i:24;i:18;i:25;i:17;i:26;i:7;i:27;i:7;i:28;i:10;i:29;i:6;i:30;i:15;i:31;i:11;i:32;i:32;i:33;i:23;i:34;i:40;i:35;i:29;i:36;i:20;i:37;i:31;i:38;i:22;i:39;i:7;i:40;i:28;i:41;i:8;i:42;i:23;i:43;i:21;i:44;i:16;i:45;i:15;i:46;i:12;i:47;i:22;i:48;i:36;i:49;i:14;i:50;i:16;i:51;i:11;i:52;i:12;i:53;i:19;i:54;i:10;i:55;i:11;i:56;i:29;i:57;i:21;i:58;i:24;i:59;i:16;i:60;i:16;i:61;i:18;i:62;i:10;i:63;i:8;i:64;i:7;i:65;i:12;i:66;i:6;i:67;i:7;i:68;i:3;i:69;i:4;i:70;i:5;i:71;i:6;i:72;i:8;i:73;i:5;i:74;i:4;i:75;i:4;i:76;i:5;i:77;i:7;i:78;i:10;i:79;i:6;i:80;i:15;i:81;i:4;i:82;i:19;i:83;i:21;i:84;i:15;i:85;i:24;i:86;i:25;i:87;i:20;i:88;i:13;i:89;i:9;i:90;i:14;i:91;i:6;i:92;i:4;i:93;i:7;i:94;i:5;i:95;i:5;i:96;i:4;i:97;i:10;i:98;i:9;i:99;i:8;i:100;i:5;i:101;i:4;i:102;i:4;i:103;i:8;i:104;i:11;i:105;i:7;i:106;i:5;i:107;i:4;i:108;i:5;i:109;i:4;i:110;i:18;i:111;i:7;i:112;i:16;i:113;i:15;i:114;i:24;i:115;i:25;i:116;i:17;i:117;i:20;i:118;i:36;i:119;i:24;i:120;i:23;i:121;i:16;i:122;i:10;i:123;i:23;i:124;i:6;i:125;i:20;i:126;i:11;i:127;i:20;i:128;i:25;i:129;i:23;i:130;i:21;i:131;i:22;i:132;i:11;i:133;i:12;i:134;i:12;i:135;i:9;i:136;i:7;i:137;i:16;i:138;i:10;i:139;i:20;i:140;i:18;i:141;i:23;i:142;i:22;i:143;i:10;i:144;i:29;i:145;i:20;i:146;i:19;i:147;i:13;i:148;i:9;i:149;i:17;i:150;i:14;i:151;i:12;i:152;i:16;i:153;i:14;i:154;i:15;i:155;i:16;i:156;i:15;i:157;i:12;i:158;i:14;i:159;i:11;i:160;i:17;i:161;i:10;i:162;i:6;i:163;i:13;i:164;i:24;i:165;i:19;i:166;i:17;i:167;i:12;i:168;i:11;i:169;i:6;i:170;i:6;i:171;i:9;i:172;i:8;i:173;i:6;i:174;i:5;i:175;i:5;i:176;i:6;i:177;i:11;i:178;i:9;i:179;i:7;i:180;i:7;i:181;i:6;i:182;i:4;i:183;i:5;i:184;i:9;i:185;i:4;i:186;i:5;i:187;i:11;i:188;i:7;i:189;i:22;i:190;i:23;i:191;i:12;i:192;i:20;i:193;i:12;i:194;i:26;i:195;i:15;i:196;i:9;i:197;i:15;i:198;i:9;i:199;i:5;}");
INSERT INTO `wp_postmeta` VALUES("1300", "190", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1301", "190", "like_count", "0");
INSERT INTO `wp_postmeta` VALUES("1302", "190", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1303", "190", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1304", "190", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1305", "190", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1306", "190", "post-count-year-2020", "13");
INSERT INTO `wp_postmeta` VALUES("1307", "190", "post-count-week-202046", "7");
INSERT INTO `wp_postmeta` VALUES("1308", "190", "post-count-month-202011", "7");
INSERT INTO `wp_postmeta` VALUES("1309", "190", "_wp_old_slug", "zeze");
INSERT INTO `wp_postmeta` VALUES("1310", "190", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1311", "190", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1315", "190", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1316", "190", "post-count-month-202012", "5");
INSERT INTO `wp_postmeta` VALUES("1317", "190", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1318", "190", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1319", "190", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1320", "190", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1321", "190", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1322", "190", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1323", "192", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/a7/34/5a/a7345af4-5d3c-3736-5dd0-e9d051b0ded3/mzaf_6009557953366571039.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1324", "192", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1325", "192", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1326", "192", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1327", "192", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1328", "192", "purchase_url", "https://itunes.apple.com/us/album/youngblood/id1369109074?i=1369109322");
INSERT INTO `wp_postmeta` VALUES("1329", "192", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("1330", "192", "_thumbnail_id", "513");
INSERT INTO `wp_postmeta` VALUES("1331", "192", "post-count-all", "17");
INSERT INTO `wp_postmeta` VALUES("1332", "192", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1333", "192", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1334", "192", "post-count-year-2019", "4");
INSERT INTO `wp_postmeta` VALUES("1335", "192", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1336", "192", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1337", "192", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1338", "192", "post", "");
INSERT INTO `wp_postmeta` VALUES("1339", "192", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1340", "192", "waveform_data", "a:200:{i:0;i:24;i:1;i:26;i:2;i:17;i:3;i:19;i:4;i:32;i:5;i:23;i:6;i:20;i:7;i:32;i:8;i:39;i:9;i:22;i:10;i:20;i:11;i:40;i:12;i:23;i:13;i:27;i:14;i:28;i:15;i:31;i:16;i:25;i:17;i:42;i:18;i:30;i:19;i:30;i:20;i:36;i:21;i:24;i:22;i:31;i:23;i:24;i:24;i:39;i:25;i:24;i:26;i:27;i:27;i:41;i:28;i:25;i:29;i:12;i:30;i:24;i:31;i:32;i:32;i:22;i:33;i:26;i:34;i:27;i:35;i:13;i:36;i:36;i:37;i:39;i:38;i:38;i:39;i:21;i:40;i:28;i:41;i:21;i:42;i:17;i:43;i:17;i:44;i:31;i:45;i:24;i:46;i:32;i:47;i:30;i:48;i:36;i:49;i:22;i:50;i:35;i:51;i:24;i:52;i:14;i:53;i:32;i:54;i:23;i:55;i:42;i:56;i:11;i:57;i:39;i:58;i:40;i:59;i:19;i:60;i:33;i:61;i:30;i:62;i:28;i:63;i:40;i:64;i:40;i:65;i:36;i:66;i:23;i:67;i:26;i:68;i:29;i:69;i:27;i:70;i:22;i:71;i:25;i:72;i:24;i:73;i:18;i:74;i:31;i:75;i:25;i:76;i:20;i:77;i:21;i:78;i:35;i:79;i:27;i:80;i:34;i:81;i:41;i:82;i:31;i:83;i:43;i:84;i:34;i:85;i:34;i:86;i:15;i:87;i:28;i:88;i:32;i:89;i:42;i:90;i:23;i:91;i:24;i:92;i:12;i:93;i:16;i:94;i:25;i:95;i:32;i:96;i:28;i:97;i:35;i:98;i:28;i:99;i:23;i:100;i:33;i:101;i:33;i:102;i:24;i:103;i:39;i:104;i:38;i:105;i:41;i:106;i:26;i:107;i:29;i:108;i:43;i:109;i:23;i:110;i:25;i:111;i:41;i:112;i:37;i:113;i:29;i:114;i:30;i:115;i:32;i:116;i:25;i:117;i:26;i:118;i:28;i:119;i:40;i:120;i:39;i:121;i:39;i:122;i:39;i:123;i:30;i:124;i:41;i:125;i:40;i:126;i:27;i:127;i:34;i:128;i:42;i:129;i:20;i:130;i:22;i:131;i:23;i:132;i:29;i:133;i:41;i:134;i:28;i:135;i:28;i:136;i:14;i:137;i:25;i:138;i:32;i:139;i:18;i:140;i:23;i:141;i:24;i:142;i:21;i:143;i:40;i:144;i:33;i:145;i:38;i:146;i:19;i:147;i:31;i:148;i:29;i:149;i:26;i:150;i:39;i:151;i:35;i:152;i:32;i:153;i:20;i:154;i:31;i:155;i:43;i:156;i:27;i:157;i:23;i:158;i:38;i:159;i:13;i:160;i:35;i:161;i:39;i:162;i:36;i:163;i:17;i:164;i:25;i:165;i:28;i:166;i:24;i:167;i:20;i:168;i:37;i:169;i:20;i:170;i:31;i:171;i:28;i:172;i:25;i:173;i:26;i:174;i:24;i:175;i:32;i:176;i:23;i:177;i:39;i:178;i:23;i:179;i:21;i:180;i:32;i:181;i:33;i:182;i:34;i:183;i:32;i:184;i:31;i:185;i:36;i:186;i:26;i:187;i:34;i:188;i:34;i:189;i:8;i:190;i:11;i:191;i:14;i:192;i:26;i:193;i:8;i:194;i:19;i:195;i:33;i:196;i:10;i:197;i:10;i:198;i:35;i:199;i:15;}");
INSERT INTO `wp_postmeta` VALUES("1341", "192", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1342", "192", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1343", "192", "download_count", "1");
INSERT INTO `wp_postmeta` VALUES("1344", "192", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1345", "192", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("1346", "192", "post-count-month-202010", "3");
INSERT INTO `wp_postmeta` VALUES("1347", "192", "post-count-year-2020", "10");
INSERT INTO `wp_postmeta` VALUES("1348", "192", "post-count-week-202045", "1");
INSERT INTO `wp_postmeta` VALUES("1349", "192", "post-count-month-202011", "2");
INSERT INTO `wp_postmeta` VALUES("1350", "192", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1351", "192", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1352", "192", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1353", "192", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1357", "192", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1358", "192", "post-count-month-202012", "5");
INSERT INTO `wp_postmeta` VALUES("1359", "192", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1360", "192", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1361", "192", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1362", "192", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1363", "192", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1364", "192", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1365", "194", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/d0/94/1a/d0941aed-432a-7b25-44fb-6e16c58cbc86/mzaf_2496381949757242114.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1366", "194", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1367", "194", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1368", "194", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1369", "194", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("1370", "194", "purchase_url", "https://itunes.apple.com/us/album/let-you-love-me/id1436560878?i=1436560886");
INSERT INTO `wp_postmeta` VALUES("1371", "194", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1372", "194", "_thumbnail_id", "512");
INSERT INTO `wp_postmeta` VALUES("1373", "194", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1374", "194", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1375", "194", "post-count-all", "50");
INSERT INTO `wp_postmeta` VALUES("1376", "194", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1377", "194", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1378", "194", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1379", "194", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1380", "194", "post", "");
INSERT INTO `wp_postmeta` VALUES("1381", "194", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1382", "194", "waveform_data", "a:200:{i:0;i:24;i:1;i:49;i:2;i:46;i:3;i:29;i:4;i:38;i:5;i:48;i:6;i:42;i:7;i:49;i:8;i:50;i:9;i:26;i:10;i:43;i:11;i:40;i:12;i:41;i:13;i:38;i:14;i:40;i:15;i:32;i:16;i:41;i:17;i:36;i:18;i:33;i:19;i:29;i:20;i:50;i:21;i:25;i:22;i:43;i:23;i:40;i:24;i:45;i:25;i:48;i:26;i:38;i:27;i:42;i:28;i:26;i:29;i:43;i:30;i:31;i:31;i:45;i:32;i:49;i:33;i:35;i:34;i:41;i:35;i:33;i:36;i:16;i:37;i:34;i:38;i:42;i:39;i:37;i:40;i:45;i:41;i:28;i:42;i:47;i:43;i:36;i:44;i:37;i:45;i:36;i:46;i:36;i:47;i:45;i:48;i:38;i:49;i:44;i:50;i:38;i:51;i:48;i:52;i:31;i:53;i:29;i:54;i:47;i:55;i:40;i:56;i:27;i:57;i:36;i:58;i:28;i:59;i:42;i:60;i:32;i:61;i:49;i:62;i:43;i:63;i:33;i:64;i:40;i:65;i:48;i:66;i:47;i:67;i:38;i:68;i:50;i:69;i:42;i:70;i:47;i:71;i:44;i:72;i:26;i:73;i:49;i:74;i:46;i:75;i:30;i:76;i:46;i:77;i:21;i:78;i:49;i:79;i:47;i:80;i:27;i:81;i:15;i:82;i:4;i:83;i:20;i:84;i:47;i:85;i:42;i:86;i:38;i:87;i:40;i:88;i:50;i:89;i:33;i:90;i:50;i:91;i:45;i:92;i:46;i:93;i:47;i:94;i:49;i:95;i:48;i:96;i:45;i:97;i:24;i:98;i:46;i:99;i:34;i:100;i:40;i:101;i:40;i:102;i:42;i:103;i:48;i:104;i:41;i:105;i:44;i:106;i:23;i:107;i:48;i:108;i:36;i:109;i:48;i:110;i:47;i:111;i:40;i:112;i:41;i:113;i:38;i:114;i:49;i:115;i:15;i:116;i:17;i:117;i:6;i:118;i:12;i:119;i:28;i:120;i:15;i:121;i:14;i:122;i:24;i:123;i:25;i:124;i:21;i:125;i:19;i:126;i:21;i:127;i:24;i:128;i:19;i:129;i:12;i:130;i:14;i:131;i:19;i:132;i:49;i:133;i:14;i:134;i:11;i:135;i:47;i:136;i:20;i:137;i:15;i:138;i:36;i:139;i:35;i:140;i:34;i:141;i:34;i:142;i:21;i:143;i:45;i:144;i:17;i:145;i:18;i:146;i:26;i:147;i:29;i:148;i:47;i:149;i:40;i:150;i:31;i:151;i:25;i:152;i:31;i:153;i:26;i:154;i:44;i:155;i:33;i:156;i:12;i:157;i:28;i:158;i:31;i:159;i:42;i:160;i:37;i:161;i:36;i:162;i:18;i:163;i:44;i:164;i:41;i:165;i:46;i:166;i:33;i:167;i:30;i:168;i:38;i:169;i:23;i:170;i:18;i:171;i:49;i:172;i:30;i:173;i:27;i:174;i:31;i:175;i:49;i:176;i:29;i:177;i:40;i:178;i:23;i:179;i:26;i:180;i:24;i:181;i:39;i:182;i:40;i:183;i:22;i:184;i:31;i:185;i:27;i:186;i:42;i:187;i:34;i:188;i:50;i:189;i:45;i:190;i:37;i:191;i:23;i:192;i:31;i:193;i:32;i:194;i:28;i:195;i:37;i:196;i:20;i:197;i:27;i:198;i:37;i:199;i:36;}");
INSERT INTO `wp_postmeta` VALUES("1383", "194", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1384", "194", "download_count", "3");
INSERT INTO `wp_postmeta` VALUES("1385", "194", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1386", "194", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1387", "194", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1388", "194", "post-count-year-2020", "41");
INSERT INTO `wp_postmeta` VALUES("1389", "194", "post-count-week-202046", "19");
INSERT INTO `wp_postmeta` VALUES("1390", "194", "post-count-month-202011", "19");
INSERT INTO `wp_postmeta` VALUES("1391", "194", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1392", "194", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1396", "194", "post-count-week-202050", "5");
INSERT INTO `wp_postmeta` VALUES("1397", "194", "post-count-month-202012", "21");
INSERT INTO `wp_postmeta` VALUES("1398", "194", "post-count-week-202051", "14");
INSERT INTO `wp_postmeta` VALUES("1399", "194", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1400", "194", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1401", "194", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1402", "194", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1403", "194", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1404", "196", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/07/7e/24/077e2447-0d02-1c40-729b-a4a87e7ecd51/mzaf_3261492558713394996.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1405", "196", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1406", "196", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1407", "196", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1408", "196", "purchase_title", "اپل");
INSERT INTO `wp_postmeta` VALUES("1409", "196", "purchase_url", "https://itunes.apple.com/us/album/woman-like-me-feat-nicki-minaj/id1438533608?i=1438533761");
INSERT INTO `wp_postmeta` VALUES("1410", "196", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1411", "196", "_thumbnail_id", "511");
INSERT INTO `wp_postmeta` VALUES("1412", "196", "post-count-all", "14");
INSERT INTO `wp_postmeta` VALUES("1413", "196", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1414", "196", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1415", "196", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1416", "196", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1417", "196", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1418", "196", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1419", "196", "post", "");
INSERT INTO `wp_postmeta` VALUES("1420", "196", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1421", "196", "waveform_data", "a:200:{i:0;i:22;i:1;i:34;i:2;i:25;i:3;i:14;i:4;i:18;i:5;i:11;i:6;i:23;i:7;i:31;i:8;i:34;i:9;i:20;i:10;i:25;i:11;i:15;i:12;i:18;i:13;i:9;i:14;i:26;i:15;i:29;i:16;i:23;i:17;i:22;i:18;i:24;i:19;i:31;i:20;i:20;i:21;i:22;i:22;i:21;i:23;i:14;i:24;i:27;i:25;i:18;i:26;i:22;i:27;i:9;i:28;i:41;i:29;i:26;i:30;i:25;i:31;i:33;i:32;i:20;i:33;i:11;i:34;i:11;i:35;i:9;i:36;i:42;i:37;i:32;i:38;i:23;i:39;i:29;i:40;i:37;i:41;i:23;i:42;i:37;i:43;i:29;i:44;i:41;i:45;i:36;i:46;i:28;i:47;i:20;i:48;i:38;i:49;i:27;i:50;i:20;i:51;i:34;i:52;i:34;i:53;i:23;i:54;i:28;i:55;i:21;i:56;i:12;i:57;i:42;i:58;i:38;i:59;i:40;i:60;i:27;i:61;i:24;i:62;i:40;i:63;i:39;i:64;i:31;i:65;i:41;i:66;i:34;i:67;i:33;i:68;i:39;i:69;i:19;i:70;i:32;i:71;i:32;i:72;i:29;i:73;i:22;i:74;i:28;i:75;i:40;i:76;i:26;i:77;i:30;i:78;i:25;i:79;i:37;i:80;i:34;i:81;i:22;i:82;i:36;i:83;i:33;i:84;i:35;i:85;i:27;i:86;i:37;i:87;i:23;i:88;i:29;i:89;i:32;i:90;i:42;i:91;i:43;i:92;i:40;i:93;i:26;i:94;i:32;i:95;i:28;i:96;i:25;i:97;i:28;i:98;i:23;i:99;i:6;i:100;i:39;i:101;i:28;i:102;i:32;i:103;i:35;i:104;i:13;i:105;i:43;i:106;i:31;i:107;i:28;i:108;i:36;i:109;i:35;i:110;i:27;i:111;i:29;i:112;i:38;i:113;i:18;i:114;i:20;i:115;i:22;i:116;i:15;i:117;i:13;i:118;i:22;i:119;i:16;i:120;i:18;i:121;i:12;i:122;i:11;i:123;i:8;i:124;i:12;i:125;i:13;i:126;i:16;i:127;i:25;i:128;i:14;i:129;i:20;i:130;i:18;i:131;i:35;i:132;i:26;i:133;i:10;i:134;i:11;i:135;i:21;i:136;i:24;i:137;i:28;i:138;i:12;i:139;i:25;i:140;i:19;i:141;i:17;i:142;i:19;i:143;i:13;i:144;i:6;i:145;i:6;i:146;i:8;i:147;i:22;i:148;i:15;i:149;i:31;i:150;i:17;i:151;i:25;i:152;i:15;i:153;i:25;i:154;i:26;i:155;i:27;i:156;i:17;i:157;i:20;i:158;i:21;i:159;i:15;i:160;i:23;i:161;i:16;i:162;i:12;i:163;i:16;i:164;i:15;i:165;i:13;i:166;i:12;i:167;i:13;i:168;i:21;i:169;i:24;i:170;i:20;i:171;i:16;i:172;i:15;i:173;i:10;i:174;i:19;i:175;i:20;i:176;i:25;i:177;i:18;i:178;i:11;i:179;i:25;i:180;i:17;i:181;i:19;i:182;i:16;i:183;i:16;i:184;i:17;i:185;i:19;i:186;i:22;i:187;i:8;i:188;i:10;i:189;i:10;i:190;i:23;i:191;i:32;i:192;i:13;i:193;i:18;i:194;i:17;i:195;i:25;i:196;i:15;i:197;i:18;i:198;i:20;i:199;i:24;}");
INSERT INTO `wp_postmeta` VALUES("1422", "196", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1423", "196", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1424", "196", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1425", "196", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1426", "196", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1427", "196", "post-count-year-2020", "10");
INSERT INTO `wp_postmeta` VALUES("1428", "196", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1429", "196", "post-count-month-202011", "1");
INSERT INTO `wp_postmeta` VALUES("1430", "196", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1431", "196", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1435", "196", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("1436", "196", "post-count-month-202012", "8");
INSERT INTO `wp_postmeta` VALUES("1437", "196", "post-count-week-202051", "4");
INSERT INTO `wp_postmeta` VALUES("1438", "196", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1439", "196", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1440", "196", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1441", "196", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1442", "196", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1443", "198", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/c3/6c/db/c36cdbd0-304b-11b0-128d-eda635333cc8/mzaf_1033589088272334209.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1444", "198", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1445", "198", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1446", "198", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1447", "198", "purchase_title", "نوین وردپرس");
INSERT INTO `wp_postmeta` VALUES("1448", "198", "purchase_url", "https://itunes.apple.com/us/album/body-feat-brando/id1296233038?i=1296233048");
INSERT INTO `wp_postmeta` VALUES("1449", "198", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("1450", "198", "_thumbnail_id", "520");
INSERT INTO `wp_postmeta` VALUES("1451", "198", "post-count-all", "14");
INSERT INTO `wp_postmeta` VALUES("1452", "198", "post-count-week-201926", "1");
INSERT INTO `wp_postmeta` VALUES("1453", "198", "post-count-month-201906", "1");
INSERT INTO `wp_postmeta` VALUES("1454", "198", "post-count-year-2019", "1");
INSERT INTO `wp_postmeta` VALUES("1455", "198", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1456", "198", "post", "");
INSERT INTO `wp_postmeta` VALUES("1457", "198", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1458", "198", "waveform_data", "a:200:{i:0;i:29;i:1;i:30;i:2;i:29;i:3;i:25;i:4;i:31;i:5;i:41;i:6;i:37;i:7;i:12;i:8;i:19;i:9;i:38;i:10;i:24;i:11;i:18;i:12;i:33;i:13;i:36;i:14;i:38;i:15;i:41;i:16;i:26;i:17;i:48;i:18;i:45;i:19;i:44;i:20;i:38;i:21;i:39;i:22;i:28;i:23;i:11;i:24;i:34;i:25;i:25;i:26;i:12;i:27;i:37;i:28;i:33;i:29;i:31;i:30;i:49;i:31;i:48;i:32;i:46;i:33;i:40;i:34;i:45;i:35;i:48;i:36;i:42;i:37;i:38;i:38;i:35;i:39;i:38;i:40;i:24;i:41;i:47;i:42;i:49;i:43;i:43;i:44;i:48;i:45;i:43;i:46;i:40;i:47;i:36;i:48;i:24;i:49;i:28;i:50;i:48;i:51;i:42;i:52;i:38;i:53;i:37;i:54;i:44;i:55;i:26;i:56;i:47;i:57;i:43;i:58;i:48;i:59;i:34;i:60;i:43;i:61;i:32;i:62;i:47;i:63;i:48;i:64;i:48;i:65;i:33;i:66;i:40;i:67;i:48;i:68;i:47;i:69;i:43;i:70;i:48;i:71;i:47;i:72;i:28;i:73;i:32;i:74;i:47;i:75;i:46;i:76;i:42;i:77;i:36;i:78;i:22;i:79;i:10;i:80;i:47;i:81;i:43;i:82;i:20;i:83;i:42;i:84;i:47;i:85;i:47;i:86;i:46;i:87;i:37;i:88;i:28;i:89;i:40;i:90;i:44;i:91;i:26;i:92;i:34;i:93;i:47;i:94;i:32;i:95;i:44;i:96;i:45;i:97;i:46;i:98;i:47;i:99;i:47;i:100;i:39;i:101;i:48;i:102;i:14;i:103;i:40;i:104;i:42;i:105;i:41;i:106;i:30;i:107;i:23;i:108;i:48;i:109;i:36;i:110;i:22;i:111;i:35;i:112;i:40;i:113;i:29;i:114;i:50;i:115;i:48;i:116;i:24;i:117;i:39;i:118;i:42;i:119;i:31;i:120;i:51;i:121;i:18;i:122;i:33;i:123;i:38;i:124;i:48;i:125;i:44;i:126;i:33;i:127;i:33;i:128;i:31;i:129;i:42;i:130;i:40;i:131;i:32;i:132;i:36;i:133;i:31;i:134;i:31;i:135;i:35;i:136;i:36;i:137;i:35;i:138;i:48;i:139;i:47;i:140;i:48;i:141;i:42;i:142;i:37;i:143;i:28;i:144;i:46;i:145;i:36;i:146;i:49;i:147;i:24;i:148;i:35;i:149;i:44;i:150;i:41;i:151;i:49;i:152;i:39;i:153;i:46;i:154;i:48;i:155;i:42;i:156;i:42;i:157;i:49;i:158;i:30;i:159;i:47;i:160;i:46;i:161;i:44;i:162;i:36;i:163;i:45;i:164;i:41;i:165;i:47;i:166;i:34;i:167;i:47;i:168;i:35;i:169;i:38;i:170;i:22;i:171;i:42;i:172;i:26;i:173;i:49;i:174;i:45;i:175;i:44;i:176;i:32;i:177;i:44;i:178;i:39;i:179;i:37;i:180;i:31;i:181;i:25;i:182;i:45;i:183;i:45;i:184;i:26;i:185;i:30;i:186;i:36;i:187;i:28;i:188;i:45;i:189;i:44;i:190;i:47;i:191;i:47;i:192;i:47;i:193;i:48;i:194;i:40;i:195;i:50;i:196;i:28;i:197;i:26;i:198;i:45;i:199;i:46;}");
INSERT INTO `wp_postmeta` VALUES("1459", "198", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1460", "198", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1461", "198", "download_count", "1");
INSERT INTO `wp_postmeta` VALUES("1462", "198", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1463", "198", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1464", "198", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1465", "198", "post-count-year-2020", "12");
INSERT INTO `wp_postmeta` VALUES("1466", "198", "post-count-week-202045", "1");
INSERT INTO `wp_postmeta` VALUES("1467", "198", "post-count-month-202011", "6");
INSERT INTO `wp_postmeta` VALUES("1468", "198", "post-count-week-202046", "5");
INSERT INTO `wp_postmeta` VALUES("1469", "198", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1470", "198", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1474", "198", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1475", "198", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1476", "198", "post-count-month-202012", "5");
INSERT INTO `wp_postmeta` VALUES("1477", "198", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1478", "198", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1479", "198", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1480", "198", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1481", "198", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1482", "198", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1483", "200", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/8f/84/bd/8f84bd09-94d3-d6f1-5fca-4b61d7ba135a/mzaf_69877628019454373.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1484", "200", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1485", "200", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1486", "200", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1487", "200", "purchase_title", "اپل");
INSERT INTO `wp_postmeta` VALUES("1488", "200", "purchase_url", "https://itunes.apple.com/us/album/wake-up-in-the-sky/id1436076387?i=1436076396");
INSERT INTO `wp_postmeta` VALUES("1489", "200", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("1490", "200", "_thumbnail_id", "530");
INSERT INTO `wp_postmeta` VALUES("1491", "200", "post-count-all", "25");
INSERT INTO `wp_postmeta` VALUES("1492", "200", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1493", "200", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1494", "200", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1495", "200", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1496", "200", "like_user", "a:1:{i:0;i:2;}");
INSERT INTO `wp_postmeta` VALUES("1497", "200", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1498", "200", "post", "");
INSERT INTO `wp_postmeta` VALUES("1499", "200", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1500", "200", "waveform_data", "a:200:{i:0;i:11;i:1;i:7;i:2;i:17;i:3;i:24;i:4;i:13;i:5;i:13;i:6;i:9;i:7;i:19;i:8;i:17;i:9;i:5;i:10;i:43;i:11;i:36;i:12;i:45;i:13;i:42;i:14;i:42;i:15;i:42;i:16;i:30;i:17;i:32;i:18;i:29;i:19;i:44;i:20;i:23;i:21;i:22;i:22;i:36;i:23;i:36;i:24;i:50;i:25;i:39;i:26;i:51;i:27;i:34;i:28;i:33;i:29;i:24;i:30;i:40;i:31;i:27;i:32;i:51;i:33;i:40;i:34;i:37;i:35;i:36;i:36;i:40;i:37;i:40;i:38;i:50;i:39;i:41;i:40;i:28;i:41;i:20;i:42;i:29;i:43;i:24;i:44;i:21;i:45;i:12;i:46;i:43;i:47;i:38;i:48;i:34;i:49;i:43;i:50;i:29;i:51;i:30;i:52;i:17;i:53;i:39;i:54;i:50;i:55;i:40;i:56;i:23;i:57;i:27;i:58;i:27;i:59;i:34;i:60;i:26;i:61;i:11;i:62;i:33;i:63;i:38;i:64;i:31;i:65;i:23;i:66;i:24;i:67;i:21;i:68;i:27;i:69;i:46;i:70;i:24;i:71;i:27;i:72;i:43;i:73;i:33;i:74;i:27;i:75;i:23;i:76;i:15;i:77;i:39;i:78;i:47;i:79;i:35;i:80;i:33;i:81;i:33;i:82;i:39;i:83;i:49;i:84;i:34;i:85;i:38;i:86;i:42;i:87;i:26;i:88;i:20;i:89;i:38;i:90;i:37;i:91;i:35;i:92;i:35;i:93;i:40;i:94;i:35;i:95;i:34;i:96;i:26;i:97;i:50;i:98;i:36;i:99;i:50;i:100;i:38;i:101;i:37;i:102;i:50;i:103;i:28;i:104;i:36;i:105;i:42;i:106;i:31;i:107;i:30;i:108;i:47;i:109;i:42;i:110;i:22;i:111;i:29;i:112;i:18;i:113;i:43;i:114;i:39;i:115;i:34;i:116;i:34;i:117;i:35;i:118;i:33;i:119;i:32;i:120;i:27;i:121;i:30;i:122;i:33;i:123;i:26;i:124;i:31;i:125;i:31;i:126;i:30;i:127;i:34;i:128;i:43;i:129;i:27;i:130;i:40;i:131;i:36;i:132;i:24;i:133;i:18;i:134;i:16;i:135;i:15;i:136;i:50;i:137;i:38;i:138;i:30;i:139;i:49;i:140;i:35;i:141;i:29;i:142;i:42;i:143;i:36;i:144;i:34;i:145;i:40;i:146;i:25;i:147;i:50;i:148;i:51;i:149;i:32;i:150;i:32;i:151;i:38;i:152;i:36;i:153;i:31;i:154;i:22;i:155;i:22;i:156;i:19;i:157;i:42;i:158;i:42;i:159;i:36;i:160;i:42;i:161;i:47;i:162;i:35;i:163;i:19;i:164;i:17;i:165;i:38;i:166;i:21;i:167;i:44;i:168;i:50;i:169;i:51;i:170;i:47;i:171;i:29;i:172;i:33;i:173;i:31;i:174;i:51;i:175;i:45;i:176;i:25;i:177;i:28;i:178;i:21;i:179;i:39;i:180;i:39;i:181;i:39;i:182;i:36;i:183;i:26;i:184;i:39;i:185;i:29;i:186;i:32;i:187;i:38;i:188;i:28;i:189;i:48;i:190;i:40;i:191;i:40;i:192;i:50;i:193;i:40;i:194;i:35;i:195;i:40;i:196;i:32;i:197;i:41;i:198;i:43;i:199;i:25;}");
INSERT INTO `wp_postmeta` VALUES("1501", "200", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1502", "200", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1503", "200", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1504", "200", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("1505", "200", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("1506", "200", "post-count-year-2020", "22");
INSERT INTO `wp_postmeta` VALUES("1507", "200", "post-count-week-202044", "10");
INSERT INTO `wp_postmeta` VALUES("1508", "200", "post-count-month-202010", "10");
INSERT INTO `wp_postmeta` VALUES("1509", "200", "post-count-week-202046", "5");
INSERT INTO `wp_postmeta` VALUES("1510", "200", "post-count-month-202011", "5");
INSERT INTO `wp_postmeta` VALUES("1511", "200", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1512", "200", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1516", "200", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1517", "200", "post-count-month-202012", "6");
INSERT INTO `wp_postmeta` VALUES("1518", "200", "post-count-week-202051", "3");
INSERT INTO `wp_postmeta` VALUES("1519", "200", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1520", "200", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1521", "200", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1522", "200", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1523", "200", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1524", "203", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1525", "203", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/b9/e3/b7/b9e3b7bd-ca1d-ef23-a06b-0f98bd0455f5/mzaf_218562434776916419.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1526", "203", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1527", "203", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1528", "203", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1529", "203", "_thumbnail_id", "531");
INSERT INTO `wp_postmeta` VALUES("1530", "203", "post-count-all", "45");
INSERT INTO `wp_postmeta` VALUES("1531", "203", "post-count-week-201926", "9");
INSERT INTO `wp_postmeta` VALUES("1532", "203", "post-count-month-201906", "9");
INSERT INTO `wp_postmeta` VALUES("1533", "203", "post-count-year-2019", "9");
INSERT INTO `wp_postmeta` VALUES("1534", "203", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1535", "203", "like_user", "a:1:{i:0;i:2;}");
INSERT INTO `wp_postmeta` VALUES("1536", "203", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("1537", "203", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("1538", "203", "post-count-year-2020", "30");
INSERT INTO `wp_postmeta` VALUES("1539", "203", "post", "");
INSERT INTO `wp_postmeta` VALUES("1540", "203", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1541", "203", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1542", "203", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1543", "203", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1544", "203", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1545", "203", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1546", "203", "download_count", "4");
INSERT INTO `wp_postmeta` VALUES("1547", "203", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("1548", "203", "post-count-month-202010", "3");
INSERT INTO `wp_postmeta` VALUES("1549", "203", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1550", "203", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1551", "203", "_wp_old_slug", "dance-wave");
INSERT INTO `wp_postmeta` VALUES("1552", "203", "waveform_data", "a:200:{i:0;i:28;i:1;i:46;i:2;i:28;i:3;i:17;i:4;i:18;i:5;i:9;i:6;i:8;i:7;i:9;i:8;i:5;i:9;i:35;i:10;i:7;i:11;i:9;i:12;i:15;i:13;i:17;i:14;i:11;i:15;i:7;i:16;i:9;i:17;i:7;i:18;i:10;i:19;i:13;i:20;i:23;i:21;i:19;i:22;i:4;i:23;i:17;i:24;i:3;i:25;i:44;i:26;i:4;i:27;i:38;i:28;i:27;i:29;i:5;i:30;i:10;i:31;i:7;i:32;i:11;i:33;i:14;i:34;i:11;i:35;i:11;i:36;i:11;i:37;i:12;i:38;i:20;i:39;i:21;i:40;i:11;i:41;i:21;i:42;i:22;i:43;i:4;i:44;i:5;i:45;i:40;i:46;i:25;i:47;i:10;i:48;i:14;i:49;i:9;i:50;i:15;i:51;i:39;i:52;i:39;i:53;i:25;i:54;i:12;i:55;i:26;i:56;i:25;i:57;i:26;i:58;i:9;i:59;i:11;i:60;i:8;i:61;i:25;i:62;i:19;i:63;i:11;i:64;i:33;i:65;i:6;i:66;i:21;i:67;i:13;i:68;i:23;i:69;i:5;i:70;i:8;i:71;i:18;i:72;i:5;i:73;i:20;i:74;i:37;i:75;i:33;i:76;i:17;i:77;i:23;i:78;i:9;i:79;i:9;i:80;i:18;i:81;i:13;i:82;i:40;i:83;i:12;i:84;i:10;i:85;i:10;i:86;i:15;i:87;i:18;i:88;i:8;i:89;i:14;i:90;i:15;i:91;i:21;i:92;i:28;i:93;i:30;i:94;i:20;i:95;i:4;i:96;i:18;i:97;i:2;i:98;i:39;i:99;i:11;i:100;i:39;i:101;i:15;i:102;i:13;i:103;i:16;i:104;i:6;i:105;i:17;i:106;i:6;i:107;i:27;i:108;i:8;i:109;i:19;i:110;i:25;i:111;i:24;i:112;i:26;i:113;i:6;i:114;i:23;i:115;i:7;i:116;i:19;i:117;i:15;i:118;i:11;i:119;i:16;i:120;i:10;i:121;i:20;i:122;i:16;i:123;i:6;i:124;i:13;i:125;i:13;i:126;i:24;i:127;i:11;i:128;i:13;i:129;i:8;i:130;i:13;i:131;i:6;i:132;i:11;i:133;i:7;i:134;i:7;i:135;i:10;i:136;i:8;i:137;i:24;i:138;i:21;i:139;i:34;i:140;i:21;i:141;i:27;i:142;i:33;i:143;i:30;i:144;i:24;i:145;i:24;i:146;i:35;i:147;i:21;i:148;i:29;i:149;i:26;i:150;i:25;i:151;i:30;i:152;i:22;i:153;i:21;i:154;i:23;i:155;i:24;i:156;i:28;i:157;i:22;i:158;i:26;i:159;i:20;i:160;i:28;i:161;i:23;i:162;i:22;i:163;i:25;i:164;i:18;i:165;i:24;i:166;i:23;i:167;i:21;i:168;i:19;i:169;i:26;i:170;i:19;i:171;i:19;i:172;i:30;i:173;i:21;i:174;i:19;i:175;i:24;i:176;i:31;i:177;i:20;i:178;i:32;i:179;i:22;i:180;i:36;i:181;i:23;i:182;i:36;i:183;i:27;i:184;i:25;i:185;i:29;i:186;i:28;i:187;i:26;i:188;i:30;i:189;i:32;i:190;i:25;i:191;i:24;i:192;i:25;i:193;i:22;i:194;i:28;i:195;i:22;i:196;i:43;i:197;i:26;i:198;i:23;i:199;i:25;}");
INSERT INTO `wp_postmeta` VALUES("1556", "203", "post-count-week-202046", "8");
INSERT INTO `wp_postmeta` VALUES("1557", "203", "post-count-month-202011", "9");
INSERT INTO `wp_postmeta` VALUES("1558", "203", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("1559", "203", "post-count-week-202050", "4");
INSERT INTO `wp_postmeta` VALUES("1560", "203", "post-count-month-202012", "17");
INSERT INTO `wp_postmeta` VALUES("1561", "203", "post-count-week-202051", "11");
INSERT INTO `wp_postmeta` VALUES("1562", "203", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1563", "203", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1564", "203", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1565", "203", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1566", "203", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1567", "204", "_thumbnail_id", "532");
INSERT INTO `wp_postmeta` VALUES("1568", "204", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1569", "204", "stream", "");
INSERT INTO `wp_postmeta` VALUES("1570", "204", "stream_url", "https://aspb28.cdn.asset.aparat.com/aparat-video/3ae2f16f4a92cfef12d68c5132986a7f37028287-720p.mp4");
INSERT INTO `wp_postmeta` VALUES("1571", "204", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1572", "204", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1573", "204", "post-count-all", "34");
INSERT INTO `wp_postmeta` VALUES("1574", "204", "post-count-week-201926", "2");
INSERT INTO `wp_postmeta` VALUES("1575", "204", "post-count-month-201906", "2");
INSERT INTO `wp_postmeta` VALUES("1576", "204", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1577", "204", "_wp_old_slug", "radio-groove");
INSERT INTO `wp_postmeta` VALUES("1578", "204", "post", "");
INSERT INTO `wp_postmeta` VALUES("1579", "204", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1580", "204", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1581", "204", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1582", "204", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1583", "204", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1584", "204", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1585", "204", "like_count", "0");
INSERT INTO `wp_postmeta` VALUES("1586", "204", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1587", "204", "post-count-week-202044", "2");
INSERT INTO `wp_postmeta` VALUES("1588", "204", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("1589", "204", "post-count-year-2020", "29");
INSERT INTO `wp_postmeta` VALUES("1590", "204", "post-count-week-202045", "8");
INSERT INTO `wp_postmeta` VALUES("1591", "204", "post-count-month-202011", "8");
INSERT INTO `wp_postmeta` VALUES("1592", "204", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1593", "204", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1597", "204", "post-count-week-202050", "17");
INSERT INTO `wp_postmeta` VALUES("1598", "204", "post-count-month-202012", "19");
INSERT INTO `wp_postmeta` VALUES("1599", "204", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1600", "204", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1601", "204", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1602", "204", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1603", "204", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1604", "215", "_thumbnail_id", "534");
INSERT INTO `wp_postmeta` VALUES("1605", "215", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1606", "215", "stream", "http://streaming308.radionomy.com/1000HITSCountry");
INSERT INTO `wp_postmeta` VALUES("1607", "215", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1608", "215", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1609", "215", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1610", "215", "post-count-all", "6");
INSERT INTO `wp_postmeta` VALUES("1611", "215", "post-count-week-201926", "3");
INSERT INTO `wp_postmeta` VALUES("1612", "215", "post-count-month-201906", "3");
INSERT INTO `wp_postmeta` VALUES("1613", "215", "post-count-year-2019", "3");
INSERT INTO `wp_postmeta` VALUES("1614", "215", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1615", "215", "like_user", "a:1:{i:0;i:2;}");
INSERT INTO `wp_postmeta` VALUES("1616", "215", "_wp_old_slug", "enjoy-hits");
INSERT INTO `wp_postmeta` VALUES("1617", "215", "post", "");
INSERT INTO `wp_postmeta` VALUES("1618", "215", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1619", "215", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1620", "215", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1621", "215", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1622", "215", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1623", "215", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1624", "215", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1625", "215", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1626", "215", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1627", "215", "post-count-year-2020", "4");
INSERT INTO `wp_postmeta` VALUES("1628", "215", "_wp_old_slug", "radioboss-stream");
INSERT INTO `wp_postmeta` VALUES("1629", "215", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1630", "215", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1631", "215", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1632", "215", "post-count-month-202011", "1");
INSERT INTO `wp_postmeta` VALUES("1636", "215", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("1637", "215", "post-count-month-202012", "2");
INSERT INTO `wp_postmeta` VALUES("1638", "216", "_thumbnail_id", "535");
INSERT INTO `wp_postmeta` VALUES("1639", "216", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1640", "216", "stream", "http://live.topfm.hu:8000/comedy.mp3?icecast");
INSERT INTO `wp_postmeta` VALUES("1641", "216", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1642", "216", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1643", "216", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1644", "216", "post-count-all", "11");
INSERT INTO `wp_postmeta` VALUES("1645", "216", "post-count-week-201926", "4");
INSERT INTO `wp_postmeta` VALUES("1646", "216", "post-count-month-201906", "4");
INSERT INTO `wp_postmeta` VALUES("1647", "216", "post-count-year-2019", "4");
INSERT INTO `wp_postmeta` VALUES("1648", "216", "post", "");
INSERT INTO `wp_postmeta` VALUES("1649", "216", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1650", "216", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1651", "216", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1652", "216", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1653", "216", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1654", "216", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1655", "216", "like_count", "0");
INSERT INTO `wp_postmeta` VALUES("1656", "216", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1657", "216", "post-count-week-202044", "5");
INSERT INTO `wp_postmeta` VALUES("1658", "216", "post-count-month-202010", "5");
INSERT INTO `wp_postmeta` VALUES("1659", "216", "post-count-year-2020", "9");
INSERT INTO `wp_postmeta` VALUES("1660", "216", "_wp_old_slug", "orf-radio-tirol");
INSERT INTO `wp_postmeta` VALUES("1661", "216", "_wp_old_slug", "traders-desk-tv");
INSERT INTO `wp_postmeta` VALUES("1662", "216", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1663", "216", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1667", "216", "post-count-week-202046", "3");
INSERT INTO `wp_postmeta` VALUES("1668", "216", "post-count-month-202011", "3");
INSERT INTO `wp_postmeta` VALUES("1669", "216", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1670", "216", "post-count-month-202012", "1");
INSERT INTO `wp_postmeta` VALUES("1671", "216", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1672", "216", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1673", "216", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1674", "221", "_thumbnail_id", "553");
INSERT INTO `wp_postmeta` VALUES("1675", "221", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1676", "221", "stream", "https://directory.shoutcast.com/Player/GetStreamUrl?station=403602");
INSERT INTO `wp_postmeta` VALUES("1677", "221", "stream_url", "http://85.25.243.132:8000/mp3?shoutcast");
INSERT INTO `wp_postmeta` VALUES("1678", "221", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1679", "221", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("1680", "221", "post-count-all", "50");
INSERT INTO `wp_postmeta` VALUES("1681", "221", "post-count-week-201926", "5");
INSERT INTO `wp_postmeta` VALUES("1682", "221", "post-count-month-201906", "5");
INSERT INTO `wp_postmeta` VALUES("1683", "221", "post-count-year-2019", "5");
INSERT INTO `wp_postmeta` VALUES("1684", "221", "like_count", "3");
INSERT INTO `wp_postmeta` VALUES("1685", "221", "like_user", "a:3:{i:0;i:2;i:1;i:5;i:2;i:36;}");
INSERT INTO `wp_postmeta` VALUES("1686", "221", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1687", "221", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1688", "221", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1689", "221", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1690", "221", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1691", "221", "_wp_old_slug", "rauland");
INSERT INTO `wp_postmeta` VALUES("1692", "221", "post", "");
INSERT INTO `wp_postmeta` VALUES("1693", "221", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1694", "221", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1695", "221", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1696", "221", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1697", "221", "post-count-year-2020", "44");
INSERT INTO `wp_postmeta` VALUES("1698", "221", "post-count-week-202045", "1");
INSERT INTO `wp_postmeta` VALUES("1699", "221", "post-count-month-202011", "16");
INSERT INTO `wp_postmeta` VALUES("1703", "221", "post-count-week-202047", "12");
INSERT INTO `wp_postmeta` VALUES("1704", "221", "post-count-week-202048", "3");
INSERT INTO `wp_postmeta` VALUES("1705", "221", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("1706", "221", "post-count-month-202012", "27");
INSERT INTO `wp_postmeta` VALUES("1707", "221", "post-count-week-202050", "23");
INSERT INTO `wp_postmeta` VALUES("1708", "221", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("1709", "221", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1710", "221", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1711", "221", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1712", "221", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1713", "227", "_thumbnail_id", "551");
INSERT INTO `wp_postmeta` VALUES("1714", "227", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1715", "227", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview128/v4/0a/8c/65/0a8c653e-d6b2-cfe4-435d-ba89e6f65d00/mzaf_681405281136151657.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1716", "227", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1717", "227", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1718", "227", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("1719", "227", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1720", "227", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("1721", "227", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1722", "227", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1723", "227", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1724", "227", "post-count-all", "147");
INSERT INTO `wp_postmeta` VALUES("1725", "227", "post-count-week-201926", "1");
INSERT INTO `wp_postmeta` VALUES("1726", "227", "post-count-month-201906", "1");
INSERT INTO `wp_postmeta` VALUES("1727", "227", "post-count-year-2019", "1");
INSERT INTO `wp_postmeta` VALUES("1728", "227", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1729", "227", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1730", "227", "post", "");
INSERT INTO `wp_postmeta` VALUES("1731", "227", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1732", "227", "download_count", "4");
INSERT INTO `wp_postmeta` VALUES("1733", "227", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1734", "227", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1735", "227", "waveform_data", "a:200:{i:0;i:15;i:1;i:36;i:2;i:37;i:3;i:40;i:4;i:29;i:5;i:28;i:6;i:41;i:7;i:34;i:8;i:23;i:9;i:18;i:10;i:33;i:11;i:20;i:12;i:38;i:13;i:31;i:14;i:23;i:15;i:43;i:16;i:37;i:17;i:21;i:18;i:32;i:19;i:20;i:20;i:36;i:21;i:32;i:22;i:43;i:23;i:31;i:24;i:42;i:25;i:28;i:26;i:27;i:27;i:45;i:28;i:32;i:29;i:50;i:30;i:39;i:31;i:26;i:32;i:29;i:33;i:50;i:34;i:27;i:35;i:26;i:36;i:25;i:37;i:25;i:38;i:37;i:39;i:39;i:40;i:35;i:41;i:26;i:42;i:41;i:43;i:30;i:44;i:23;i:45;i:16;i:46;i:35;i:47;i:29;i:48;i:47;i:49;i:29;i:50;i:31;i:51;i:42;i:52;i:36;i:53;i:27;i:54;i:27;i:55;i:33;i:56;i:31;i:57;i:26;i:58;i:32;i:59;i:30;i:60;i:17;i:61;i:25;i:62;i:24;i:63;i:40;i:64;i:43;i:65;i:41;i:66;i:33;i:67;i:41;i:68;i:38;i:69;i:40;i:70;i:50;i:71;i:39;i:72;i:48;i:73;i:38;i:74;i:28;i:75;i:29;i:76;i:38;i:77;i:26;i:78;i:39;i:79;i:42;i:80;i:40;i:81;i:40;i:82;i:16;i:83;i:31;i:84;i:23;i:85;i:37;i:86;i:18;i:87;i:43;i:88;i:15;i:89;i:24;i:90;i:35;i:91;i:43;i:92;i:30;i:93;i:43;i:94;i:35;i:95;i:24;i:96;i:39;i:97;i:30;i:98;i:31;i:99;i:31;i:100;i:35;i:101;i:29;i:102;i:35;i:103;i:30;i:104;i:36;i:105;i:29;i:106;i:27;i:107;i:39;i:108;i:25;i:109;i:23;i:110;i:24;i:111;i:37;i:112;i:33;i:113;i:38;i:114;i:41;i:115;i:29;i:116;i:45;i:117;i:38;i:118;i:46;i:119;i:32;i:120;i:37;i:121;i:42;i:122;i:37;i:123;i:32;i:124;i:34;i:125;i:21;i:126;i:17;i:127;i:35;i:128;i:23;i:129;i:38;i:130;i:30;i:131;i:22;i:132;i:51;i:133;i:36;i:134;i:43;i:135;i:42;i:136;i:31;i:137;i:32;i:138;i:25;i:139;i:27;i:140;i:21;i:141;i:32;i:142;i:44;i:143;i:29;i:144;i:34;i:145;i:27;i:146;i:40;i:147;i:29;i:148;i:21;i:149;i:47;i:150;i:28;i:151;i:35;i:152;i:31;i:153;i:38;i:154;i:41;i:155;i:32;i:156;i:46;i:157;i:23;i:158;i:33;i:159;i:50;i:160;i:43;i:161;i:40;i:162;i:40;i:163;i:24;i:164;i:37;i:165;i:27;i:166;i:44;i:167;i:49;i:168;i:32;i:169;i:20;i:170;i:33;i:171;i:39;i:172;i:37;i:173;i:46;i:174;i:27;i:175;i:27;i:176;i:35;i:177;i:33;i:178;i:20;i:179;i:12;i:180;i:9;i:181;i:11;i:182;i:7;i:183;i:6;i:184;i:3;i:185;i:12;i:186;i:9;i:187;i:11;i:188;i:21;i:189;i:6;i:190;i:8;i:191;i:6;i:192;i:1;i:193;i:10;i:194;i:10;i:195;i:10;i:196;i:7;i:197;i:5;i:198;i:11;i:199;i:11;}");
INSERT INTO `wp_postmeta` VALUES("1736", "227", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("1737", "227", "post-count-month-202011", "5");
INSERT INTO `wp_postmeta` VALUES("1738", "227", "post-count-year-2020", "24");
INSERT INTO `wp_postmeta` VALUES("1739", "227", "_wp_old_slug", "radio-de-mexico");
INSERT INTO `wp_postmeta` VALUES("1743", "227", "post-count-week-202047", "4");
INSERT INTO `wp_postmeta` VALUES("1744", "227", "post-count-week-202050", "4");
INSERT INTO `wp_postmeta` VALUES("1745", "227", "post-count-month-202012", "19");
INSERT INTO `wp_postmeta` VALUES("1746", "227", "post-count-week-202051", "12");
INSERT INTO `wp_postmeta` VALUES("1747", "227", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("1748", "227", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1749", "227", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1750", "227", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1751", "227", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1752", "242", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/67/23/dc/6723dc8c-f03b-7ae4-7ca4-a3d1c2c32901/mzaf_8553914273243381881.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("1753", "242", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("1754", "242", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1755", "242", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1756", "242", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1757", "242", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1758", "242", "thumbnail_pos_y", "40");
INSERT INTO `wp_postmeta` VALUES("1759", "242", "_thumbnail_id", "552");
INSERT INTO `wp_postmeta` VALUES("1760", "242", "post-count-all", "18");
INSERT INTO `wp_postmeta` VALUES("1761", "242", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("1762", "242", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("1763", "242", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("1764", "242", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1765", "242", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1766", "242", "_wp_old_slug", "something-blue");
INSERT INTO `wp_postmeta` VALUES("1767", "242", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1768", "242", "post", "");
INSERT INTO `wp_postmeta` VALUES("1769", "242", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1770", "242", "waveform_data", "a:200:{i:0;i:21;i:1;i:34;i:2;i:46;i:3;i:22;i:4;i:19;i:5;i:42;i:6;i:25;i:7;i:24;i:8;i:43;i:9;i:29;i:10;i:29;i:11;i:43;i:12;i:37;i:13;i:27;i:14;i:42;i:15;i:42;i:16;i:21;i:17;i:23;i:18;i:44;i:19;i:9;i:20;i:16;i:21;i:44;i:22;i:19;i:23;i:28;i:24;i:47;i:25;i:43;i:26;i:17;i:27;i:33;i:28;i:38;i:29;i:38;i:30;i:47;i:31;i:45;i:32;i:22;i:33;i:29;i:34;i:42;i:35;i:25;i:36;i:43;i:37;i:39;i:38;i:16;i:39;i:26;i:40;i:46;i:41;i:43;i:42;i:31;i:43;i:48;i:44;i:49;i:45;i:13;i:46;i:46;i:47;i:43;i:48;i:28;i:49;i:28;i:50;i:39;i:51;i:43;i:52;i:24;i:53;i:46;i:54;i:21;i:55;i:36;i:56;i:45;i:57;i:43;i:58;i:31;i:59;i:36;i:60;i:27;i:61;i:33;i:62;i:21;i:63;i:39;i:64;i:15;i:65;i:21;i:66;i:45;i:67;i:29;i:68;i:32;i:69;i:44;i:70;i:22;i:71;i:13;i:72;i:43;i:73;i:47;i:74;i:32;i:75;i:32;i:76;i:46;i:77;i:11;i:78;i:39;i:79;i:43;i:80;i:24;i:81;i:42;i:82;i:45;i:83;i:25;i:84;i:23;i:85;i:41;i:86;i:31;i:87;i:45;i:88;i:44;i:89;i:47;i:90;i:41;i:91;i:41;i:92;i:41;i:93;i:43;i:94;i:44;i:95;i:42;i:96;i:29;i:97;i:25;i:98;i:31;i:99;i:16;i:100;i:39;i:101;i:45;i:102;i:45;i:103;i:28;i:104;i:42;i:105;i:30;i:106;i:49;i:107;i:43;i:108;i:20;i:109;i:19;i:110;i:46;i:111;i:30;i:112;i:28;i:113;i:25;i:114;i:25;i:115;i:8;i:116;i:22;i:117;i:20;i:118;i:8;i:119;i:24;i:120;i:21;i:121;i:6;i:122;i:3;i:123;i:18;i:124;i:19;i:125;i:10;i:126;i:6;i:127;i:29;i:128;i:11;i:129;i:22;i:130;i:24;i:131;i:26;i:132;i:42;i:133;i:17;i:134;i:4;i:135;i:15;i:136;i:35;i:137;i:23;i:138;i:12;i:139;i:28;i:140;i:5;i:141;i:12;i:142;i:17;i:143;i:23;i:144;i:16;i:145;i:17;i:146;i:20;i:147;i:17;i:148;i:14;i:149;i:31;i:150;i:11;i:151;i:20;i:152;i:42;i:153;i:12;i:154;i:13;i:155;i:34;i:156;i:15;i:157;i:42;i:158;i:37;i:159;i:10;i:160;i:16;i:161;i:20;i:162;i:21;i:163;i:14;i:164;i:17;i:165;i:13;i:166;i:3;i:167;i:12;i:168;i:26;i:169;i:9;i:170;i:16;i:171;i:7;i:172;i:8;i:173;i:20;i:174;i:32;i:175;i:29;i:176;i:11;i:177;i:12;i:178;i:18;i:179;i:6;i:180;i:20;i:181;i:38;i:182;i:7;i:183;i:10;i:184;i:43;i:185;i:7;i:186;i:21;i:187;i:16;i:188;i:28;i:189;i:30;i:190;i:11;i:191;i:16;i:192;i:10;i:193;i:13;i:194;i:19;i:195;i:8;i:196;i:33;i:197;i:20;i:198;i:12;i:199;i:20;}");
INSERT INTO `wp_postmeta` VALUES("1771", "242", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1772", "242", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1773", "242", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1774", "242", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("1775", "242", "post-count-month-202009", "2");
INSERT INTO `wp_postmeta` VALUES("1776", "242", "post-count-year-2020", "14");
INSERT INTO `wp_postmeta` VALUES("1777", "242", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("1778", "242", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("1779", "242", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("1780", "242", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1781", "242", "post-count-week-202046", "4");
INSERT INTO `wp_postmeta` VALUES("1782", "242", "post-count-month-202011", "4");
INSERT INTO `wp_postmeta` VALUES("1783", "242", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1784", "242", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1788", "242", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("1789", "242", "post-count-month-202012", "6");
INSERT INTO `wp_postmeta` VALUES("1790", "242", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1791", "242", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("1792", "242", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1793", "242", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1794", "242", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1795", "242", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1796", "290", "post", "222,221,223");
INSERT INTO `wp_postmeta` VALUES("1797", "290", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("1798", "290", "stream", "");
INSERT INTO `wp_postmeta` VALUES("1799", "290", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1800", "290", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1801", "290", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1802", "290", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1803", "290", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1804", "290", "thumbnail_pos_y", "20");
INSERT INTO `wp_postmeta` VALUES("1805", "290", "_thumbnail_id", "519");
INSERT INTO `wp_postmeta` VALUES("1806", "290", "post-count-all", "856");
INSERT INTO `wp_postmeta` VALUES("1807", "290", "post-count-week-201926", "1");
INSERT INTO `wp_postmeta` VALUES("1808", "290", "post-count-month-201906", "1");
INSERT INTO `wp_postmeta` VALUES("1809", "290", "post-count-year-2019", "1");
INSERT INTO `wp_postmeta` VALUES("1810", "290", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1811", "290", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1812", "290", "like_user", "a:2:{i:0;i:3;i:1;i:7;}");
INSERT INTO `wp_postmeta` VALUES("1813", "290", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1814", "290", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1815", "290", "post-count-year-2020", "1");
INSERT INTO `wp_postmeta` VALUES("1816", "290", "_wp_old_slug", "playlist");
INSERT INTO `wp_postmeta` VALUES("1817", "290", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1818", "290", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1819", "290", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1820", "290", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1821", "290", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1825", "290", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1826", "290", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1827", "290", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1828", "217", "_thumbnail_id", "545");
INSERT INTO `wp_postmeta` VALUES("1829", "217", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1830", "217", "stream", "http://stream.streamaudio.de:8000/bridge-radio-fx?icecast");
INSERT INTO `wp_postmeta` VALUES("1831", "217", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1832", "217", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1833", "217", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1834", "217", "post-count-all", "10");
INSERT INTO `wp_postmeta` VALUES("1835", "217", "post-count-week-201926", "3");
INSERT INTO `wp_postmeta` VALUES("1836", "217", "post-count-month-201906", "3");
INSERT INTO `wp_postmeta` VALUES("1837", "217", "post-count-year-2019", "3");
INSERT INTO `wp_postmeta` VALUES("1838", "217", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("1839", "217", "like_user", "a:1:{i:0;i:2;}");
INSERT INTO `wp_postmeta` VALUES("1840", "217", "_wp_old_slug", "spirit-radio-network");
INSERT INTO `wp_postmeta` VALUES("1841", "217", "post", "");
INSERT INTO `wp_postmeta` VALUES("1842", "217", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1843", "217", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1844", "217", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1845", "217", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1846", "217", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1847", "217", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1848", "217", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1849", "217", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("1850", "217", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("1851", "217", "post-count-year-2020", "7");
INSERT INTO `wp_postmeta` VALUES("1852", "217", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("1853", "217", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1854", "217", "post-count-week-202046", "4");
INSERT INTO `wp_postmeta` VALUES("1855", "217", "post-count-month-202011", "4");
INSERT INTO `wp_postmeta` VALUES("1856", "217", "_wp_old_slug", "bridge-radio-fx");
INSERT INTO `wp_postmeta` VALUES("1860", "217", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("1861", "217", "post-count-month-202012", "2");
INSERT INTO `wp_postmeta` VALUES("1862", "217", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1863", "217", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1864", "217", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1865", "217", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1866", "218", "_thumbnail_id", "544");
INSERT INTO `wp_postmeta` VALUES("1867", "218", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1868", "218", "stream", "https://directory.shoutcast.com/Player/GetStreamUrl?station=426124");
INSERT INTO `wp_postmeta` VALUES("1869", "218", "stream_url", "http://5.135.188.130:8000/1?shoutcast");
INSERT INTO `wp_postmeta` VALUES("1870", "218", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1871", "218", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1872", "218", "post-count-all", "26");
INSERT INTO `wp_postmeta` VALUES("1873", "218", "post-count-week-201926", "5");
INSERT INTO `wp_postmeta` VALUES("1874", "218", "post-count-month-201906", "5");
INSERT INTO `wp_postmeta` VALUES("1875", "218", "post-count-year-2019", "6");
INSERT INTO `wp_postmeta` VALUES("1876", "218", "post-count-week-201927", "1");
INSERT INTO `wp_postmeta` VALUES("1877", "218", "post-count-month-201907", "1");
INSERT INTO `wp_postmeta` VALUES("1878", "218", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("1879", "218", "post-count-month-202009", "1");
INSERT INTO `wp_postmeta` VALUES("1880", "218", "post-count-year-2020", "18");
INSERT INTO `wp_postmeta` VALUES("1881", "218", "_wp_old_slug", "orf-radio-oberosterreich");
INSERT INTO `wp_postmeta` VALUES("1882", "218", "post", "");
INSERT INTO `wp_postmeta` VALUES("1883", "218", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1884", "218", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1885", "218", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1886", "218", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1887", "218", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1888", "218", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1889", "218", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1890", "218", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("1891", "218", "post-count-week-202044", "7");
INSERT INTO `wp_postmeta` VALUES("1892", "218", "post-count-month-202010", "4");
INSERT INTO `wp_postmeta` VALUES("1893", "218", "_wp_old_slug", "city-80-radio");
INSERT INTO `wp_postmeta` VALUES("1894", "218", "post-count-month-202011", "6");
INSERT INTO `wp_postmeta` VALUES("1895", "218", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1896", "218", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1900", "218", "like_user", "a:2:{i:0;i:1;i:1;i:64;}");
INSERT INTO `wp_postmeta` VALUES("1901", "218", "post-count-week-202048", "2");
INSERT INTO `wp_postmeta` VALUES("1902", "218", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("1903", "218", "post-count-month-202012", "7");
INSERT INTO `wp_postmeta` VALUES("1904", "218", "post-count-week-202050", "4");
INSERT INTO `wp_postmeta` VALUES("1905", "218", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("1906", "218", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1907", "218", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1908", "218", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1909", "218", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1910", "220", "_thumbnail_id", "547");
INSERT INTO `wp_postmeta` VALUES("1911", "220", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1912", "220", "stream", "https://directory.shoutcast.com/Player/GetStreamUrl?station=1304518");
INSERT INTO `wp_postmeta` VALUES("1913", "220", "stream_url", "http://s1.voscast.com:7274/;?shoutcast");
INSERT INTO `wp_postmeta` VALUES("1914", "220", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1915", "220", "thumbnail_pos_y", "40");
INSERT INTO `wp_postmeta` VALUES("1916", "220", "post-count-all", "105");
INSERT INTO `wp_postmeta` VALUES("1917", "220", "post-count-week-201926", "7");
INSERT INTO `wp_postmeta` VALUES("1918", "220", "post-count-month-201906", "7");
INSERT INTO `wp_postmeta` VALUES("1919", "220", "post-count-year-2019", "14");
INSERT INTO `wp_postmeta` VALUES("1920", "220", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("1921", "220", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("1922", "220", "post-count-week-201927", "7");
INSERT INTO `wp_postmeta` VALUES("1923", "220", "post-count-month-201907", "7");
INSERT INTO `wp_postmeta` VALUES("1924", "220", "post-count-week-202037", "2");
INSERT INTO `wp_postmeta` VALUES("1925", "220", "post-count-month-202009", "6");
INSERT INTO `wp_postmeta` VALUES("1926", "220", "post-count-year-2020", "91");
INSERT INTO `wp_postmeta` VALUES("1927", "220", "post-count-week-202038", "2");
INSERT INTO `wp_postmeta` VALUES("1928", "220", "post-count-week-202039", "2");
INSERT INTO `wp_postmeta` VALUES("1929", "220", "post-count-week-202043", "3");
INSERT INTO `wp_postmeta` VALUES("1930", "220", "post-count-month-202010", "13");
INSERT INTO `wp_postmeta` VALUES("1931", "220", "post-count-week-202044", "16");
INSERT INTO `wp_postmeta` VALUES("1932", "220", "post", "");
INSERT INTO `wp_postmeta` VALUES("1933", "220", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1934", "220", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1935", "220", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("1936", "220", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("1937", "220", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1938", "220", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1939", "220", "download_count", "4");
INSERT INTO `wp_postmeta` VALUES("1940", "220", "post-count-month-202011", "57");
INSERT INTO `wp_postmeta` VALUES("1941", "220", "post-count-week-202046", "31");
INSERT INTO `wp_postmeta` VALUES("1942", "220", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1943", "220", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1947", "220", "post-count-week-202047", "16");
INSERT INTO `wp_postmeta` VALUES("1948", "220", "post-count-week-202048", "4");
INSERT INTO `wp_postmeta` VALUES("1949", "220", "post-count-week-202049", "1");
INSERT INTO `wp_postmeta` VALUES("1950", "220", "post-count-month-202012", "15");
INSERT INTO `wp_postmeta` VALUES("1951", "220", "post-count-week-202050", "12");
INSERT INTO `wp_postmeta` VALUES("1952", "220", "post-count-week-202051", "2");
INSERT INTO `wp_postmeta` VALUES("1953", "220", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1954", "220", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("1955", "220", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("1956", "222", "_thumbnail_id", "548");
INSERT INTO `wp_postmeta` VALUES("1957", "222", "type", "single");
INSERT INTO `wp_postmeta` VALUES("1958", "222", "stream", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2022/01/Majid-Razavi-Negine-Ghalbami-320.mp3");
INSERT INTO `wp_postmeta` VALUES("1959", "222", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("1960", "222", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1961", "222", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("1962", "222", "post-count-all", "173");
INSERT INTO `wp_postmeta` VALUES("1963", "222", "post-count-week-201926", "16");
INSERT INTO `wp_postmeta` VALUES("1964", "222", "post-count-month-201906", "16");
INSERT INTO `wp_postmeta` VALUES("1965", "222", "post-count-year-2019", "19");
INSERT INTO `wp_postmeta` VALUES("1966", "222", "like_count", "3");
INSERT INTO `wp_postmeta` VALUES("1967", "222", "like_user", "a:3:{i:0;i:2;i:1;i:1;i:2;i:36;}");
INSERT INTO `wp_postmeta` VALUES("1968", "222", "post-count-week-201927", "3");
INSERT INTO `wp_postmeta` VALUES("1969", "222", "post-count-month-201907", "3");
INSERT INTO `wp_postmeta` VALUES("1970", "222", "post-count-week-202038", "2");
INSERT INTO `wp_postmeta` VALUES("1971", "222", "post-count-month-202009", "3");
INSERT INTO `wp_postmeta` VALUES("1972", "222", "post-count-year-2020", "133");
INSERT INTO `wp_postmeta` VALUES("1973", "222", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("1974", "222", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("1975", "222", "post-count-month-202010", "22");
INSERT INTO `wp_postmeta` VALUES("1976", "222", "post-count-week-202044", "22");
INSERT INTO `wp_postmeta` VALUES("1977", "222", "post", "");
INSERT INTO `wp_postmeta` VALUES("1978", "222", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("1979", "222", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("1980", "222", "downloadable", "on");
INSERT INTO `wp_postmeta` VALUES("1981", "222", "download_url", "https://themes.wpnovin.com/Waveme/");
INSERT INTO `wp_postmeta` VALUES("1982", "222", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("1983", "222", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("1984", "222", "download_count", "1");
INSERT INTO `wp_postmeta` VALUES("1985", "222", "post-count-month-202011", "61");
INSERT INTO `wp_postmeta` VALUES("1986", "222", "post-count-week-202045", "6");
INSERT INTO `wp_postmeta` VALUES("1987", "222", "post-count-week-202046", "17");
INSERT INTO `wp_postmeta` VALUES("1988", "222", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("1989", "222", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("1993", "222", "post-count-week-202047", "37");
INSERT INTO `wp_postmeta` VALUES("1994", "222", "post-count-week-202050", "29");
INSERT INTO `wp_postmeta` VALUES("1995", "222", "post-count-month-202012", "47");
INSERT INTO `wp_postmeta` VALUES("1996", "222", "post-count-week-202051", "15");
INSERT INTO `wp_postmeta` VALUES("1997", "222", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("1998", "222", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("1999", "222", "post-count-week-202101", "2");
INSERT INTO `wp_postmeta` VALUES("2000", "222", "post-count-month-202101", "2");
INSERT INTO `wp_postmeta` VALUES("2001", "222", "post-count-year-2021", "2");
INSERT INTO `wp_postmeta` VALUES("2002", "223", "_thumbnail_id", "549");
INSERT INTO `wp_postmeta` VALUES("2003", "223", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2004", "223", "stream", "https://directory.shoutcast.com/Player/GetStreamUrl?station=1781178");
INSERT INTO `wp_postmeta` VALUES("2005", "223", "stream_url", "http://89.238.227.6:8002/;?shoutcast");
INSERT INTO `wp_postmeta` VALUES("2006", "223", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2007", "223", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("2008", "223", "post-count-all", "111");
INSERT INTO `wp_postmeta` VALUES("2009", "223", "post-count-week-201926", "6");
INSERT INTO `wp_postmeta` VALUES("2010", "223", "post-count-month-201906", "6");
INSERT INTO `wp_postmeta` VALUES("2011", "223", "post-count-year-2019", "9");
INSERT INTO `wp_postmeta` VALUES("2012", "223", "post-count-week-201927", "3");
INSERT INTO `wp_postmeta` VALUES("2013", "223", "post-count-month-201907", "3");
INSERT INTO `wp_postmeta` VALUES("2014", "223", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("2015", "223", "post-count-month-202009", "5");
INSERT INTO `wp_postmeta` VALUES("2016", "223", "post-count-year-2020", "94");
INSERT INTO `wp_postmeta` VALUES("2017", "223", "post-count-week-202038", "3");
INSERT INTO `wp_postmeta` VALUES("2018", "223", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("2019", "223", "post", "");
INSERT INTO `wp_postmeta` VALUES("2020", "223", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2021", "223", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2022", "223", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2023", "223", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2024", "223", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2025", "223", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2026", "223", "like_count", "5");
INSERT INTO `wp_postmeta` VALUES("2027", "223", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2028", "223", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("2029", "223", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("2030", "223", "_wp_old_slug", "the-blues-cove");
INSERT INTO `wp_postmeta` VALUES("2031", "223", "like_user", "a:5:{i:0;i:3;i:1;i:1;i:2;i:17;i:3;i:36;i:4;i:64;}");
INSERT INTO `wp_postmeta` VALUES("2032", "223", "post-count-week-202045", "10");
INSERT INTO `wp_postmeta` VALUES("2033", "223", "post-count-month-202011", "59");
INSERT INTO `wp_postmeta` VALUES("2034", "223", "_wp_old_slug", "rock-antenne");
INSERT INTO `wp_postmeta` VALUES("2035", "223", "_wp_old_slug", "alex-jones");
INSERT INTO `wp_postmeta` VALUES("2036", "223", "post-count-week-202046", "41");
INSERT INTO `wp_postmeta` VALUES("2037", "223", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2038", "223", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2042", "223", "post-count-week-202047", "8");
INSERT INTO `wp_postmeta` VALUES("2043", "223", "post-count-week-202050", "23");
INSERT INTO `wp_postmeta` VALUES("2044", "223", "post-count-month-202012", "29");
INSERT INTO `wp_postmeta` VALUES("2045", "223", "post-count-week-202051", "5");
INSERT INTO `wp_postmeta` VALUES("2046", "223", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("2047", "223", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2048", "223", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2049", "223", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2050", "237", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2051", "237", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/c9/1b/49/c91b49d0-a027-2e0a-8889-72db0fcff0f0/mzaf_7074307823200982280.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("2052", "237", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2053", "237", "thumbnail_pos_y", "10");
INSERT INTO `wp_postmeta` VALUES("2054", "237", "post-count-all", "139");
INSERT INTO `wp_postmeta` VALUES("2055", "237", "post-count-week-201926", "6");
INSERT INTO `wp_postmeta` VALUES("2056", "237", "post-count-month-201906", "6");
INSERT INTO `wp_postmeta` VALUES("2057", "237", "post-count-year-2019", "8");
INSERT INTO `wp_postmeta` VALUES("2058", "237", "_thumbnail_id", "550");
INSERT INTO `wp_postmeta` VALUES("2059", "237", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("2060", "237", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("2061", "237", "post-count-week-202037", "4");
INSERT INTO `wp_postmeta` VALUES("2062", "237", "post-count-month-202009", "9");
INSERT INTO `wp_postmeta` VALUES("2063", "237", "post-count-year-2020", "109");
INSERT INTO `wp_postmeta` VALUES("2064", "237", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2065", "237", "like_user", "a:2:{i:0;i:1;i:1;i:36;}");
INSERT INTO `wp_postmeta` VALUES("2066", "237", "post", "");
INSERT INTO `wp_postmeta` VALUES("2067", "237", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2068", "237", "waveform_data", "a:200:{i:0;i:42;i:1;i:39;i:2;i:33;i:3;i:41;i:4;i:39;i:5;i:35;i:6;i:18;i:7;i:25;i:8;i:28;i:9;i:35;i:10;i:23;i:11;i:40;i:12;i:18;i:13;i:33;i:14;i:40;i:15;i:41;i:16;i:22;i:17;i:32;i:18;i:29;i:19;i:23;i:20;i:27;i:21;i:29;i:22;i:15;i:23;i:29;i:24;i:40;i:25;i:32;i:26;i:26;i:27;i:24;i:28;i:29;i:29;i:38;i:30;i:33;i:31;i:30;i:32;i:24;i:33;i:27;i:34;i:30;i:35;i:25;i:36;i:41;i:37;i:25;i:38;i:32;i:39;i:18;i:40;i:30;i:41;i:42;i:42;i:21;i:43;i:25;i:44;i:33;i:45;i:35;i:46;i:16;i:47;i:36;i:48;i:37;i:49;i:39;i:50;i:38;i:51;i:41;i:52;i:41;i:53;i:41;i:54;i:20;i:55;i:37;i:56;i:25;i:57;i:33;i:58;i:22;i:59;i:40;i:60;i:34;i:61;i:41;i:62;i:21;i:63;i:24;i:64;i:41;i:65;i:37;i:66;i:28;i:67;i:24;i:68;i:18;i:69;i:35;i:70;i:35;i:71;i:40;i:72;i:33;i:73;i:35;i:74;i:37;i:75;i:41;i:76;i:40;i:77;i:32;i:78;i:34;i:79;i:38;i:80;i:34;i:81;i:39;i:82;i:27;i:83;i:33;i:84;i:37;i:85;i:25;i:86;i:39;i:87;i:37;i:88;i:22;i:89;i:27;i:90;i:34;i:91;i:41;i:92;i:42;i:93;i:35;i:94;i:32;i:95;i:30;i:96;i:39;i:97;i:25;i:98;i:35;i:99;i:41;i:100;i:41;i:101;i:36;i:102;i:27;i:103;i:38;i:104;i:30;i:105;i:40;i:106;i:25;i:107;i:27;i:108;i:25;i:109;i:34;i:110;i:41;i:111;i:19;i:112;i:21;i:113;i:26;i:114;i:31;i:115;i:25;i:116;i:28;i:117;i:28;i:118;i:37;i:119;i:28;i:120;i:21;i:121;i:33;i:122;i:36;i:123;i:26;i:124;i:29;i:125;i:34;i:126;i:29;i:127;i:29;i:128;i:20;i:129;i:41;i:130;i:21;i:131;i:27;i:132;i:10;i:133;i:29;i:134;i:34;i:135;i:14;i:136;i:26;i:137;i:26;i:138;i:34;i:139;i:16;i:140;i:41;i:141;i:27;i:142;i:42;i:143;i:35;i:144;i:40;i:145;i:32;i:146;i:29;i:147;i:18;i:148;i:34;i:149;i:31;i:150;i:27;i:151;i:25;i:152;i:26;i:153;i:31;i:154;i:17;i:155;i:19;i:156;i:11;i:157;i:25;i:158;i:29;i:159;i:8;i:160;i:16;i:161;i:15;i:162;i:17;i:163;i:14;i:164;i:16;i:165;i:10;i:166;i:8;i:167;i:15;i:168;i:16;i:169;i:14;i:170;i:14;i:171;i:5;i:172;i:7;i:173;i:6;i:174;i:9;i:175;i:16;i:176;i:28;i:177;i:24;i:178;i:12;i:179;i:8;i:180;i:27;i:181;i:19;i:182;i:21;i:183;i:12;i:184;i:9;i:185;i:15;i:186;i:28;i:187;i:10;i:188;i:15;i:189;i:10;i:190;i:5;i:191;i:6;i:192;i:28;i:193;i:23;i:194;i:8;i:195;i:9;i:196;i:10;i:197;i:11;i:198;i:19;i:199;i:27;}");
INSERT INTO `wp_postmeta` VALUES("2069", "237", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("2070", "237", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2071", "237", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("2072", "237", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2073", "237", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2074", "237", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2075", "237", "download_count", "18");
INSERT INTO `wp_postmeta` VALUES("2076", "237", "_wp_old_slug", "bone");
INSERT INTO `wp_postmeta` VALUES("2077", "237", "post-count-week-202038", "3");
INSERT INTO `wp_postmeta` VALUES("2078", "237", "post-count-week-202039", "2");
INSERT INTO `wp_postmeta` VALUES("2079", "237", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("2080", "237", "post-count-month-202010", "4");
INSERT INTO `wp_postmeta` VALUES("2081", "237", "post-count-week-202044", "4");
INSERT INTO `wp_postmeta` VALUES("2082", "237", "post-count-month-202011", "51");
INSERT INTO `wp_postmeta` VALUES("2083", "237", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("2084", "237", "post-count-week-202046", "35");
INSERT INTO `wp_postmeta` VALUES("2085", "237", "_wp_old_slug", "ignis");
INSERT INTO `wp_postmeta` VALUES("2086", "237", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2087", "237", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2091", "237", "post-count-week-202047", "11");
INSERT INTO `wp_postmeta` VALUES("2092", "237", "post-count-week-202048", "2");
INSERT INTO `wp_postmeta` VALUES("2093", "237", "post-count-week-202049", "1");
INSERT INTO `wp_postmeta` VALUES("2094", "237", "post-count-month-202012", "45");
INSERT INTO `wp_postmeta` VALUES("2095", "237", "post-count-week-202050", "26");
INSERT INTO `wp_postmeta` VALUES("2096", "237", "post-count-week-202051", "15");
INSERT INTO `wp_postmeta` VALUES("2097", "237", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("2098", "237", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2099", "237", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2100", "237", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2101", "237", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2102", "469", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("2103", "469", "_thumbnail_id", "521");
INSERT INTO `wp_postmeta` VALUES("2104", "469", "post", "148,159,172,220,237");
INSERT INTO `wp_postmeta` VALUES("2105", "469", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("2106", "469", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2107", "469", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("2108", "469", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2109", "469", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2110", "469", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2111", "469", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2112", "469", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2113", "469", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2114", "469", "post-count-all", "1269");
INSERT INTO `wp_postmeta` VALUES("2115", "469", "post-count-week-201927", "2");
INSERT INTO `wp_postmeta` VALUES("2116", "469", "post-count-month-201907", "2");
INSERT INTO `wp_postmeta` VALUES("2117", "469", "post-count-year-2019", "2");
INSERT INTO `wp_postmeta` VALUES("2118", "469", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2119", "469", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2120", "469", "post-count-week-202037", "2");
INSERT INTO `wp_postmeta` VALUES("2121", "469", "post-count-month-202009", "5");
INSERT INTO `wp_postmeta` VALUES("2122", "469", "post-count-year-2020", "29");
INSERT INTO `wp_postmeta` VALUES("2123", "469", "post-count-week-202038", "1");
INSERT INTO `wp_postmeta` VALUES("2124", "469", "post-count-week-202039", "2");
INSERT INTO `wp_postmeta` VALUES("2125", "469", "post-count-week-202043", "1");
INSERT INTO `wp_postmeta` VALUES("2126", "469", "post-count-month-202010", "2");
INSERT INTO `wp_postmeta` VALUES("2127", "469", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("2128", "469", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("2129", "469", "post-count-month-202011", "11");
INSERT INTO `wp_postmeta` VALUES("2130", "469", "post-count-week-202046", "7");
INSERT INTO `wp_postmeta` VALUES("2131", "469", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2132", "469", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2133", "469", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2134", "469", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2135", "469", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2136", "469", "_wp_old_slug", "summer");
INSERT INTO `wp_postmeta` VALUES("2137", "469", "_wp_old_slug", "on-the-aia");
INSERT INTO `wp_postmeta` VALUES("2141", "469", "post-count-week-202047", "2");
INSERT INTO `wp_postmeta` VALUES("2142", "469", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2143", "469", "post-count-month-202012", "11");
INSERT INTO `wp_postmeta` VALUES("2144", "469", "post-count-week-202052", "10");
INSERT INTO `wp_postmeta` VALUES("2145", "469", "post-count-week-202101", "2");
INSERT INTO `wp_postmeta` VALUES("2146", "469", "post-count-month-202101", "2");
INSERT INTO `wp_postmeta` VALUES("2147", "469", "post-count-year-2021", "2");
INSERT INTO `wp_postmeta` VALUES("2148", "476", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("2149", "476", "_thumbnail_id", "500");
INSERT INTO `wp_postmeta` VALUES("2150", "476", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2151", "476", "stream", "https://www.youtube.com/watch?v=aJOTlE1K90k");
INSERT INTO `wp_postmeta` VALUES("2152", "476", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2153", "476", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2154", "476", "thumbnail_pos_y", "30");
INSERT INTO `wp_postmeta` VALUES("2155", "476", "post-count-all", "123");
INSERT INTO `wp_postmeta` VALUES("2156", "476", "post-count-week-201927", "6");
INSERT INTO `wp_postmeta` VALUES("2157", "476", "post-count-month-201907", "6");
INSERT INTO `wp_postmeta` VALUES("2158", "476", "post-count-year-2019", "6");
INSERT INTO `wp_postmeta` VALUES("2159", "476", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2160", "476", "like_user", "a:2:{i:0;i:2;i:1;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2161", "476", "post-count-week-202037", "3");
INSERT INTO `wp_postmeta` VALUES("2162", "476", "post-count-month-202009", "17");
INSERT INTO `wp_postmeta` VALUES("2163", "476", "post-count-year-2020", "99");
INSERT INTO `wp_postmeta` VALUES("2164", "476", "post-count-week-202038", "13");
INSERT INTO `wp_postmeta` VALUES("2165", "476", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("2166", "476", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("2167", "476", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("2168", "476", "post-count-month-202011", "67");
INSERT INTO `wp_postmeta` VALUES("2169", "476", "post-count-week-202045", "4");
INSERT INTO `wp_postmeta` VALUES("2170", "476", "post-count-week-202046", "37");
INSERT INTO `wp_postmeta` VALUES("2174", "476", "post-count-week-202047", "24");
INSERT INTO `wp_postmeta` VALUES("2175", "476", "post-count-week-202050", "5");
INSERT INTO `wp_postmeta` VALUES("2176", "476", "post-count-month-202012", "14");
INSERT INTO `wp_postmeta` VALUES("2177", "476", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2178", "476", "post-count-week-202052", "7");
INSERT INTO `wp_postmeta` VALUES("2179", "476", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2180", "476", "post-count-week-202101", "3");
INSERT INTO `wp_postmeta` VALUES("2181", "476", "post-count-month-202101", "3");
INSERT INTO `wp_postmeta` VALUES("2182", "476", "post-count-year-2021", "3");
INSERT INTO `wp_postmeta` VALUES("2183", "480", "hide_title", "");
INSERT INTO `wp_postmeta` VALUES("2184", "480", "_wp_old_date", "2019-07-01");
INSERT INTO `wp_postmeta` VALUES("2185", "480", "_thumbnail_id", "502");
INSERT INTO `wp_postmeta` VALUES("2186", "480", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2187", "480", "stream", "https://audio-ssl.itunes.apple.com/apple-assets-us-std-000001/AudioPreview118/v4/93/96/41/939641e5-ba9c-28e0-7ddc-370b61410ff8/mzaf_1861367385818359665.plus.aac.p.m4a");
INSERT INTO `wp_postmeta` VALUES("2188", "480", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2189", "480", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("2190", "480", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2191", "480", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2192", "480", "thumbnail_pos_y", "");
INSERT INTO `wp_postmeta` VALUES("2193", "480", "_wp_old_slug", "camara");
INSERT INTO `wp_postmeta` VALUES("2194", "480", "post-count-all", "321");
INSERT INTO `wp_postmeta` VALUES("2195", "480", "post-count-week-201927", "3");
INSERT INTO `wp_postmeta` VALUES("2196", "480", "post-count-month-201907", "3");
INSERT INTO `wp_postmeta` VALUES("2197", "480", "post-count-year-2019", "3");
INSERT INTO `wp_postmeta` VALUES("2198", "480", "like_count", "6");
INSERT INTO `wp_postmeta` VALUES("2199", "480", "like_user", "a:6:{i:0;i:2;i:1;i:1;i:2;i:6;i:3;i:16;i:4;i:56;i:5;i:52;}");
INSERT INTO `wp_postmeta` VALUES("2200", "480", "post", "");
INSERT INTO `wp_postmeta` VALUES("2201", "480", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("2202", "480", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2203", "480", "purchase_title", "Apple");
INSERT INTO `wp_postmeta` VALUES("2204", "480", "purchase_url", "https://itunes.apple.com/us/album/broken/id1282657568?i=1282658109");
INSERT INTO `wp_postmeta` VALUES("2205", "480", "download_count", "35");
INSERT INTO `wp_postmeta` VALUES("2206", "480", "post-count-week-202037", "1");
INSERT INTO `wp_postmeta` VALUES("2207", "480", "post-count-month-202009", "4");
INSERT INTO `wp_postmeta` VALUES("2208", "480", "post-count-year-2020", "270");
INSERT INTO `wp_postmeta` VALUES("2209", "480", "waveform_data", "a:200:{i:0;i:19;i:1;i:32;i:2;i:46;i:3;i:25;i:4;i:16;i:5;i:20;i:6;i:25;i:7;i:23;i:8;i:19;i:9;i:18;i:10;i:10;i:11;i:23;i:12;i:33;i:13;i:28;i:14;i:10;i:15;i:50;i:16;i:41;i:17;i:33;i:18;i:38;i:19;i:33;i:20;i:47;i:21;i:35;i:22;i:42;i:23;i:49;i:24;i:40;i:25;i:26;i:26;i:39;i:27;i:35;i:28;i:44;i:29;i:30;i:30;i:50;i:31;i:45;i:32;i:41;i:33;i:39;i:34;i:43;i:35;i:37;i:36;i:25;i:37;i:38;i:38;i:49;i:39;i:21;i:40;i:27;i:41;i:29;i:42;i:35;i:43;i:49;i:44;i:42;i:45;i:40;i:46;i:31;i:47;i:46;i:48;i:34;i:49;i:49;i:50;i:41;i:51;i:49;i:52;i:37;i:53;i:34;i:54;i:51;i:55;i:39;i:56;i:33;i:57;i:46;i:58;i:34;i:59;i:37;i:60;i:39;i:61;i:49;i:62;i:50;i:63;i:23;i:64;i:29;i:65;i:37;i:66;i:33;i:67;i:29;i:68;i:46;i:69;i:35;i:70;i:51;i:71;i:35;i:72;i:47;i:73;i:38;i:74;i:45;i:75;i:46;i:76;i:49;i:77;i:40;i:78;i:49;i:79;i:27;i:80;i:49;i:81;i:46;i:82;i:41;i:83;i:40;i:84;i:49;i:85;i:33;i:86;i:45;i:87;i:24;i:88;i:32;i:89;i:50;i:90;i:32;i:91;i:23;i:92;i:12;i:93;i:52;i:94;i:47;i:95;i:50;i:96;i:40;i:97;i:42;i:98;i:21;i:99;i:50;i:100;i:37;i:101;i:40;i:102;i:49;i:103;i:43;i:104;i:49;i:105;i:47;i:106;i:36;i:107;i:43;i:108;i:49;i:109;i:41;i:110;i:38;i:111;i:25;i:112;i:32;i:113;i:33;i:114;i:32;i:115;i:28;i:116;i:46;i:117;i:34;i:118;i:36;i:119;i:46;i:120;i:38;i:121;i:39;i:122;i:33;i:123;i:16;i:124;i:32;i:125;i:28;i:126;i:48;i:127;i:47;i:128;i:50;i:129;i:39;i:130;i:47;i:131;i:21;i:132;i:34;i:133;i:36;i:134;i:26;i:135;i:37;i:136;i:34;i:137;i:37;i:138;i:35;i:139;i:47;i:140;i:44;i:141;i:28;i:142;i:47;i:143;i:35;i:144;i:23;i:145;i:44;i:146;i:37;i:147;i:21;i:148;i:35;i:149;i:40;i:150;i:32;i:151;i:17;i:152;i:30;i:153;i:51;i:154;i:46;i:155;i:45;i:156;i:36;i:157;i:26;i:158;i:50;i:159;i:24;i:160;i:33;i:161;i:27;i:162;i:26;i:163;i:48;i:164;i:37;i:165;i:40;i:166;i:24;i:167;i:34;i:168;i:27;i:169;i:50;i:170;i:32;i:171;i:36;i:172;i:39;i:173;i:40;i:174;i:45;i:175;i:34;i:176;i:37;i:177;i:25;i:178;i:35;i:179;i:33;i:180;i:42;i:181;i:49;i:182;i:45;i:183;i:37;i:184;i:24;i:185;i:35;i:186;i:44;i:187;i:43;i:188;i:31;i:189;i:29;i:190;i:40;i:191;i:23;i:192;i:28;i:193;i:46;i:194;i:50;i:195;i:42;i:196;i:34;i:197;i:52;i:198;i:27;i:199;i:36;}");
INSERT INTO `wp_postmeta` VALUES("2210", "480", "_wp_old_slug", "hearthis");
INSERT INTO `wp_postmeta` VALUES("2211", "480", "post-count-week-202038", "2");
INSERT INTO `wp_postmeta` VALUES("2212", "480", "post-count-week-202039", "1");
INSERT INTO `wp_postmeta` VALUES("2213", "480", "post-count-week-202044", "30");
INSERT INTO `wp_postmeta` VALUES("2214", "480", "post-count-month-202010", "24");
INSERT INTO `wp_postmeta` VALUES("2215", "480", "post-count-month-202011", "217");
INSERT INTO `wp_postmeta` VALUES("2216", "480", "post-count-week-202045", "8");
INSERT INTO `wp_postmeta` VALUES("2217", "480", "post-count-week-202046", "191");
INSERT INTO `wp_postmeta` VALUES("2218", "480", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2219", "480", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2223", "480", "post-count-week-202047", "12");
INSERT INTO `wp_postmeta` VALUES("2224", "480", "post-count-week-202050", "8");
INSERT INTO `wp_postmeta` VALUES("2225", "480", "post-count-month-202012", "25");
INSERT INTO `wp_postmeta` VALUES("2226", "480", "post-count-week-202051", "11");
INSERT INTO `wp_postmeta` VALUES("2227", "480", "post-count-week-202052", "4");
INSERT INTO `wp_postmeta` VALUES("2228", "480", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("2229", "480", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2230", "480", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2231", "480", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2232", "609", "_thumbnail_id", "543");
INSERT INTO `wp_postmeta` VALUES("2233", "609", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2234", "609", "post", "");
INSERT INTO `wp_postmeta` VALUES("2235", "609", "stream", "http://kvnovm-hd3.unomaha.edu:8000/mobile.aac?icecast");
INSERT INTO `wp_postmeta` VALUES("2236", "609", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2237", "609", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2238", "609", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2239", "609", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2240", "609", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2241", "609", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2242", "609", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2243", "609", "post-count-all", "134");
INSERT INTO `wp_postmeta` VALUES("2244", "609", "like_count", "3");
INSERT INTO `wp_postmeta` VALUES("2245", "609", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2246", "609", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2247", "609", "post-count-week-202044", "44");
INSERT INTO `wp_postmeta` VALUES("2248", "609", "post-count-month-202010", "16");
INSERT INTO `wp_postmeta` VALUES("2249", "609", "post-count-year-2020", "127");
INSERT INTO `wp_postmeta` VALUES("2250", "609", "like_user", "a:3:{i:0;i:1;i:1;i:46;i:2;i:59;}");
INSERT INTO `wp_postmeta` VALUES("2251", "609", "post-count-month-202011", "80");
INSERT INTO `wp_postmeta` VALUES("2252", "609", "post-count-week-202045", "14");
INSERT INTO `wp_postmeta` VALUES("2253", "609", "_wp_old_slug", "bbc-world-service");
INSERT INTO `wp_postmeta` VALUES("2254", "609", "post-count-week-202046", "24");
INSERT INTO `wp_postmeta` VALUES("2255", "609", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2256", "609", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2260", "609", "post-count-week-202047", "14");
INSERT INTO `wp_postmeta` VALUES("2261", "609", "post-count-week-202049", "9");
INSERT INTO `wp_postmeta` VALUES("2262", "609", "post-count-month-202012", "31");
INSERT INTO `wp_postmeta` VALUES("2263", "609", "post-count-week-202050", "14");
INSERT INTO `wp_postmeta` VALUES("2264", "609", "post-count-week-202051", "5");
INSERT INTO `wp_postmeta` VALUES("2265", "609", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("2266", "609", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("2267", "609", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2268", "609", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2269", "609", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2270", "610", "_thumbnail_id", "536");
INSERT INTO `wp_postmeta` VALUES("2271", "610", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2272", "610", "post", "");
INSERT INTO `wp_postmeta` VALUES("2273", "610", "stream", "http://streaming314.radionomy.com/foxnews");
INSERT INTO `wp_postmeta` VALUES("2274", "610", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2275", "610", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2276", "610", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2277", "610", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2278", "610", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2279", "610", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2280", "610", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2281", "610", "post-count-all", "253");
INSERT INTO `wp_postmeta` VALUES("2282", "610", "like_count", "3");
INSERT INTO `wp_postmeta` VALUES("2283", "610", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2284", "610", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2285", "610", "post-count-week-202044", "125");
INSERT INTO `wp_postmeta` VALUES("2286", "610", "post-count-month-202010", "112");
INSERT INTO `wp_postmeta` VALUES("2287", "610", "post-count-year-2020", "249");
INSERT INTO `wp_postmeta` VALUES("2288", "610", "like_user", "a:3:{i:0;i:1;i:1;i:26;i:2;i:65;}");
INSERT INTO `wp_postmeta` VALUES("2289", "610", "post-count-month-202011", "128");
INSERT INTO `wp_postmeta` VALUES("2290", "610", "post-count-week-202045", "68");
INSERT INTO `wp_postmeta` VALUES("2291", "610", "post-count-week-202046", "38");
INSERT INTO `wp_postmeta` VALUES("2292", "610", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2293", "610", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2297", "610", "post-count-week-202047", "6");
INSERT INTO `wp_postmeta` VALUES("2298", "610", "post-count-week-202048", "3");
INSERT INTO `wp_postmeta` VALUES("2299", "610", "post-count-week-202049", "5");
INSERT INTO `wp_postmeta` VALUES("2300", "610", "post-count-month-202012", "9");
INSERT INTO `wp_postmeta` VALUES("2301", "610", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("2302", "610", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2303", "610", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("2304", "610", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2305", "610", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2306", "610", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2307", "611", "_thumbnail_id", "700");
INSERT INTO `wp_postmeta` VALUES("2308", "611", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2309", "611", "post", "");
INSERT INTO `wp_postmeta` VALUES("2310", "611", "stream", "https://directory.shoutcast.com/Player/GetStreamUrl?station=1794468");
INSERT INTO `wp_postmeta` VALUES("2311", "611", "stream_url", "http://185.80.221.113:7550/stream?shoutcast");
INSERT INTO `wp_postmeta` VALUES("2312", "611", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2313", "611", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2314", "611", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2315", "611", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2316", "611", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2317", "611", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2318", "611", "post-count-all", "941");
INSERT INTO `wp_postmeta` VALUES("2319", "611", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2320", "611", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2321", "611", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2322", "611", "post-count-week-202044", "3");
INSERT INTO `wp_postmeta` VALUES("2323", "611", "post-count-month-202010", "3");
INSERT INTO `wp_postmeta` VALUES("2324", "611", "post-count-year-2020", "7");
INSERT INTO `wp_postmeta` VALUES("2325", "611", "_wp_old_slug", "cnn-radio");
INSERT INTO `wp_postmeta` VALUES("2326", "611", "_wp_old_slug", "raw-fm");
INSERT INTO `wp_postmeta` VALUES("2327", "611", "like_user", "a:2:{i:0;i:1;i:1;i:46;}");
INSERT INTO `wp_postmeta` VALUES("2328", "611", "post-count-week-202046", "1");
INSERT INTO `wp_postmeta` VALUES("2329", "611", "post-count-month-202011", "1");
INSERT INTO `wp_postmeta` VALUES("2330", "611", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2331", "611", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2335", "611", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("2336", "611", "post-count-month-202012", "3");
INSERT INTO `wp_postmeta` VALUES("2337", "611", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2338", "611", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2339", "611", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2340", "611", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2341", "611", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2342", "613", "_thumbnail_id", "546");
INSERT INTO `wp_postmeta` VALUES("2343", "613", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2344", "613", "post", "");
INSERT INTO `wp_postmeta` VALUES("2345", "613", "stream", "https://hearthis.at/3pcxn2yj/2020-11-1021h30m24/");
INSERT INTO `wp_postmeta` VALUES("2346", "613", "stream_url", "https://api-v2.hearthis.at/3pcxn2yj/2020-11-1021h30m24/listen/?s=Ivt");
INSERT INTO `wp_postmeta` VALUES("2347", "613", "waveform_data", "a:3000:{i:0;i:128;i:1;i:128;i:2;i:128;i:3;i:128;i:4;i:128;i:5;i:128;i:6;i:139;i:7;i:144;i:8;i:150;i:9;i:145;i:10;i:155;i:11;i:147;i:12;i:152;i:13;i:136;i:14;i:146;i:15;i:148;i:16;i:149;i:17;i:140;i:18;i:149;i:19;i:142;i:20;i:149;i:21;i:146;i:22;i:151;i:23;i:153;i:24;i:133;i:25;i:138;i:26;i:147;i:27;i:137;i:28;i:138;i:29;i:135;i:30;i:140;i:31;i:149;i:32;i:148;i:33;i:151;i:34;i:150;i:35;i:146;i:36;i:146;i:37;i:142;i:38;i:146;i:39;i:147;i:40;i:146;i:41;i:153;i:42;i:143;i:43;i:147;i:44;i:150;i:45;i:141;i:46;i:143;i:47;i:142;i:48;i:147;i:49;i:145;i:50;i:141;i:51;i:150;i:52;i:148;i:53;i:155;i:54;i:144;i:55;i:144;i:56;i:145;i:57;i:148;i:58;i:161;i:59;i:150;i:60;i:142;i:61;i:146;i:62;i:155;i:63;i:145;i:64;i:146;i:65;i:148;i:66;i:141;i:67;i:136;i:68;i:136;i:69;i:139;i:70;i:133;i:71;i:138;i:72;i:136;i:73;i:148;i:74;i:155;i:75;i:153;i:76;i:147;i:77;i:144;i:78;i:150;i:79;i:148;i:80;i:143;i:81;i:147;i:82;i:140;i:83;i:145;i:84;i:152;i:85;i:147;i:86;i:146;i:87;i:145;i:88;i:153;i:89;i:141;i:90;i:151;i:91;i:148;i:92;i:149;i:93;i:142;i:94;i:148;i:95;i:153;i:96;i:151;i:97;i:139;i:98;i:145;i:99;i:146;i:100;i:139;i:101;i:142;i:102;i:152;i:103;i:147;i:104;i:147;i:105;i:147;i:106;i:145;i:107;i:141;i:108;i:150;i:109;i:142;i:110;i:140;i:111;i:153;i:112;i:158;i:113;i:144;i:114;i:150;i:115;i:140;i:116;i:150;i:117;i:142;i:118;i:148;i:119;i:142;i:120;i:143;i:121;i:142;i:122;i:139;i:123;i:139;i:124;i:150;i:125;i:143;i:126;i:143;i:127;i:149;i:128;i:147;i:129;i:144;i:130;i:143;i:131;i:146;i:132;i:147;i:133;i:142;i:134;i:150;i:135;i:146;i:136;i:163;i:137;i:156;i:138;i:143;i:139;i:153;i:140;i:149;i:141;i:141;i:142;i:146;i:143;i:131;i:144;i:138;i:145;i:138;i:146;i:140;i:147;i:133;i:148;i:136;i:149;i:135;i:150;i:134;i:151;i:144;i:152;i:142;i:153;i:140;i:154;i:149;i:155;i:151;i:156;i:145;i:157;i:144;i:158;i:147;i:159;i:148;i:160;i:144;i:161;i:145;i:162;i:147;i:163;i:154;i:164;i:154;i:165;i:150;i:166;i:152;i:167;i:134;i:168;i:141;i:169;i:141;i:170;i:152;i:171;i:145;i:172;i:145;i:173;i:140;i:174;i:150;i:175;i:136;i:176;i:134;i:177;i:154;i:178;i:150;i:179;i:137;i:180;i:138;i:181;i:147;i:182;i:144;i:183;i:154;i:184;i:141;i:185;i:153;i:186;i:145;i:187;i:147;i:188;i:149;i:189;i:148;i:190;i:151;i:191;i:152;i:192;i:146;i:193;i:156;i:194;i:152;i:195;i:169;i:196;i:152;i:197;i:146;i:198;i:146;i:199;i:151;i:200;i:159;i:201;i:156;i:202;i:144;i:203;i:156;i:204;i:147;i:205;i:171;i:206;i:153;i:207;i:155;i:208;i:145;i:209;i:152;i:210;i:157;i:211;i:165;i:212;i:156;i:213;i:160;i:214;i:153;i:215;i:152;i:216;i:152;i:217;i:151;i:218;i:156;i:219;i:151;i:220;i:162;i:221;i:157;i:222;i:149;i:223;i:156;i:224;i:155;i:225;i:149;i:226;i:162;i:227;i:148;i:228;i:149;i:229;i:160;i:230;i:147;i:231;i:154;i:232;i:166;i:233;i:155;i:234;i:159;i:235;i:154;i:236;i:152;i:237;i:161;i:238;i:158;i:239;i:157;i:240;i:169;i:241;i:159;i:242;i:166;i:243;i:167;i:244;i:157;i:245;i:155;i:246;i:157;i:247;i:157;i:248;i:163;i:249;i:159;i:250;i:159;i:251;i:155;i:252;i:156;i:253;i:155;i:254;i:150;i:255;i:161;i:256;i:154;i:257;i:156;i:258;i:179;i:259;i:160;i:260;i:159;i:261;i:161;i:262;i:155;i:263;i:157;i:264;i:182;i:265;i:153;i:266;i:153;i:267;i:154;i:268;i:165;i:269;i:150;i:270;i:149;i:271;i:152;i:272;i:153;i:273;i:164;i:274;i:152;i:275;i:153;i:276;i:149;i:277;i:155;i:278;i:152;i:279;i:160;i:280;i:158;i:281;i:159;i:282;i:158;i:283;i:158;i:284;i:155;i:285;i:160;i:286;i:156;i:287;i:156;i:288;i:165;i:289;i:160;i:290;i:152;i:291;i:157;i:292;i:149;i:293;i:151;i:294;i:149;i:295;i:155;i:296;i:153;i:297;i:149;i:298;i:149;i:299;i:148;i:300;i:152;i:301;i:148;i:302;i:152;i:303;i:146;i:304;i:146;i:305;i:158;i:306;i:161;i:307;i:153;i:308;i:153;i:309;i:147;i:310;i:157;i:311;i:151;i:312;i:150;i:313;i:142;i:314;i:160;i:315;i:165;i:316;i:157;i:317;i:161;i:318;i:158;i:319;i:157;i:320;i:159;i:321;i:168;i:322;i:158;i:323;i:156;i:324;i:153;i:325;i:162;i:326;i:155;i:327;i:174;i:328;i:165;i:329;i:159;i:330;i:158;i:331;i:156;i:332;i:165;i:333;i:157;i:334;i:154;i:335;i:159;i:336;i:151;i:337;i:165;i:338;i:154;i:339;i:145;i:340;i:155;i:341;i:145;i:342;i:149;i:343;i:157;i:344;i:165;i:345;i:146;i:346;i:154;i:347;i:165;i:348;i:151;i:349;i:155;i:350;i:154;i:351;i:160;i:352;i:148;i:353;i:162;i:354;i:154;i:355;i:155;i:356;i:181;i:357;i:155;i:358;i:157;i:359;i:161;i:360;i:161;i:361;i:156;i:362;i:156;i:363;i:152;i:364;i:156;i:365;i:157;i:366;i:173;i:367;i:154;i:368;i:160;i:369;i:158;i:370;i:153;i:371;i:160;i:372;i:150;i:373;i:148;i:374;i:162;i:375;i:157;i:376;i:153;i:377;i:160;i:378;i:160;i:379;i:153;i:380;i:155;i:381;i:147;i:382;i:167;i:383;i:154;i:384;i:152;i:385;i:161;i:386;i:153;i:387;i:153;i:388;i:155;i:389;i:154;i:390;i:158;i:391;i:149;i:392;i:155;i:393;i:159;i:394;i:161;i:395;i:168;i:396;i:155;i:397;i:162;i:398;i:170;i:399;i:160;i:400;i:150;i:401;i:160;i:402;i:150;i:403;i:157;i:404;i:150;i:405;i:165;i:406;i:150;i:407;i:178;i:408;i:170;i:409;i:161;i:410;i:166;i:411;i:155;i:412;i:150;i:413;i:143;i:414;i:145;i:415;i:141;i:416;i:141;i:417;i:165;i:418;i:171;i:419;i:155;i:420;i:157;i:421;i:152;i:422;i:154;i:423;i:153;i:424;i:161;i:425;i:149;i:426;i:165;i:427;i:160;i:428;i:153;i:429;i:158;i:430;i:171;i:431;i:149;i:432;i:153;i:433;i:149;i:434;i:162;i:435;i:159;i:436;i:166;i:437;i:167;i:438;i:161;i:439;i:155;i:440;i:157;i:441;i:154;i:442;i:156;i:443;i:164;i:444;i:163;i:445;i:162;i:446;i:159;i:447;i:150;i:448;i:164;i:449;i:159;i:450;i:163;i:451;i:153;i:452;i:150;i:453;i:161;i:454;i:150;i:455;i:159;i:456;i:156;i:457;i:165;i:458;i:146;i:459;i:161;i:460;i:153;i:461;i:151;i:462;i:162;i:463;i:162;i:464;i:160;i:465;i:161;i:466;i:165;i:467;i:168;i:468;i:159;i:469;i:154;i:470;i:150;i:471;i:154;i:472;i:164;i:473;i:148;i:474;i:155;i:475;i:160;i:476;i:162;i:477;i:160;i:478;i:167;i:479;i:162;i:480;i:160;i:481;i:159;i:482;i:161;i:483;i:158;i:484;i:159;i:485;i:162;i:486;i:157;i:487;i:150;i:488;i:150;i:489;i:167;i:490;i:152;i:491;i:155;i:492;i:151;i:493;i:154;i:494;i:158;i:495;i:159;i:496;i:163;i:497;i:168;i:498;i:160;i:499;i:156;i:500;i:162;i:501;i:165;i:502;i:161;i:503;i:161;i:504;i:160;i:505;i:153;i:506;i:154;i:507;i:160;i:508;i:168;i:509;i:157;i:510;i:162;i:511;i:156;i:512;i:154;i:513;i:160;i:514;i:166;i:515;i:150;i:516;i:161;i:517;i:148;i:518;i:160;i:519;i:168;i:520;i:156;i:521;i:162;i:522;i:154;i:523;i:169;i:524;i:161;i:525;i:161;i:526;i:161;i:527;i:151;i:528;i:152;i:529;i:151;i:530;i:156;i:531;i:153;i:532;i:159;i:533;i:175;i:534;i:178;i:535;i:165;i:536;i:162;i:537;i:165;i:538;i:160;i:539;i:152;i:540;i:151;i:541;i:158;i:542;i:168;i:543;i:160;i:544;i:165;i:545;i:157;i:546;i:154;i:547;i:164;i:548;i:161;i:549;i:158;i:550;i:156;i:551;i:164;i:552;i:152;i:553;i:158;i:554;i:167;i:555;i:157;i:556;i:166;i:557;i:155;i:558;i:157;i:559;i:158;i:560;i:153;i:561;i:147;i:562;i:157;i:563;i:161;i:564;i:162;i:565;i:159;i:566;i:165;i:567;i:175;i:568;i:170;i:569;i:160;i:570;i:174;i:571;i:173;i:572;i:159;i:573;i:169;i:574;i:170;i:575;i:179;i:576;i:162;i:577;i:174;i:578;i:159;i:579;i:164;i:580;i:175;i:581;i:165;i:582;i:165;i:583;i:161;i:584;i:171;i:585;i:172;i:586;i:168;i:587;i:163;i:588;i:167;i:589;i:180;i:590;i:163;i:591;i:158;i:592;i:170;i:593;i:173;i:594;i:171;i:595;i:170;i:596;i:170;i:597;i:161;i:598;i:171;i:599;i:171;i:600;i:169;i:601;i:185;i:602;i:152;i:603;i:158;i:604;i:158;i:605;i:158;i:606;i:152;i:607;i:155;i:608;i:154;i:609;i:149;i:610;i:155;i:611;i:154;i:612;i:161;i:613;i:148;i:614;i:152;i:615;i:150;i:616;i:152;i:617;i:157;i:618;i:147;i:619;i:155;i:620;i:156;i:621;i:167;i:622;i:160;i:623;i:158;i:624;i:149;i:625;i:155;i:626;i:154;i:627;i:157;i:628;i:154;i:629;i:154;i:630;i:161;i:631;i:158;i:632;i:158;i:633;i:146;i:634;i:157;i:635;i:156;i:636;i:152;i:637;i:149;i:638;i:155;i:639;i:145;i:640;i:153;i:641;i:151;i:642;i:154;i:643;i:152;i:644;i:163;i:645;i:154;i:646;i:149;i:647;i:170;i:648;i:156;i:649;i:152;i:650;i:169;i:651;i:158;i:652;i:163;i:653;i:155;i:654;i:157;i:655;i:155;i:656;i:157;i:657;i:156;i:658;i:153;i:659;i:151;i:660;i:150;i:661;i:153;i:662;i:166;i:663;i:155;i:664;i:154;i:665;i:155;i:666;i:160;i:667;i:159;i:668;i:155;i:669;i:150;i:670;i:151;i:671;i:157;i:672;i:160;i:673;i:156;i:674;i:155;i:675;i:157;i:676;i:160;i:677;i:160;i:678;i:151;i:679;i:161;i:680;i:153;i:681;i:151;i:682;i:150;i:683;i:158;i:684;i:158;i:685;i:163;i:686;i:159;i:687;i:150;i:688;i:152;i:689;i:157;i:690;i:154;i:691;i:154;i:692;i:159;i:693;i:159;i:694;i:160;i:695;i:165;i:696;i:158;i:697;i:155;i:698;i:164;i:699;i:156;i:700;i:153;i:701;i:150;i:702;i:150;i:703;i:153;i:704;i:151;i:705;i:157;i:706;i:156;i:707;i:155;i:708;i:173;i:709;i:151;i:710;i:159;i:711;i:164;i:712;i:156;i:713;i:158;i:714;i:161;i:715;i:143;i:716;i:158;i:717;i:152;i:718;i:162;i:719;i:147;i:720;i:155;i:721;i:148;i:722;i:151;i:723;i:146;i:724;i:156;i:725;i:150;i:726;i:148;i:727;i:149;i:728;i:156;i:729;i:151;i:730;i:149;i:731;i:143;i:732;i:146;i:733;i:147;i:734;i:162;i:735;i:147;i:736;i:165;i:737;i:149;i:738;i:166;i:739;i:148;i:740;i:151;i:741;i:148;i:742;i:151;i:743;i:154;i:744;i:147;i:745;i:152;i:746;i:154;i:747;i:150;i:748;i:179;i:749;i:158;i:750;i:150;i:751;i:149;i:752;i:157;i:753;i:158;i:754;i:159;i:755;i:153;i:756;i:157;i:757;i:146;i:758;i:157;i:759;i:145;i:760;i:153;i:761;i:152;i:762;i:164;i:763;i:153;i:764;i:154;i:765;i:159;i:766;i:152;i:767;i:158;i:768;i:157;i:769;i:143;i:770;i:156;i:771;i:156;i:772;i:162;i:773;i:152;i:774;i:147;i:775;i:152;i:776;i:154;i:777;i:157;i:778;i:166;i:779;i:159;i:780;i:170;i:781;i:161;i:782;i:152;i:783;i:155;i:784;i:151;i:785;i:160;i:786;i:168;i:787;i:153;i:788;i:164;i:789;i:156;i:790;i:154;i:791;i:147;i:792;i:150;i:793;i:149;i:794;i:150;i:795;i:151;i:796;i:159;i:797;i:152;i:798;i:151;i:799;i:155;i:800;i:156;i:801;i:163;i:802;i:154;i:803;i:153;i:804;i:149;i:805;i:146;i:806;i:172;i:807;i:176;i:808;i:149;i:809;i:156;i:810;i:156;i:811;i:153;i:812;i:158;i:813;i:154;i:814;i:161;i:815;i:157;i:816;i:153;i:817;i:151;i:818;i:164;i:819;i:156;i:820;i:157;i:821;i:146;i:822;i:158;i:823;i:159;i:824;i:153;i:825;i:159;i:826;i:154;i:827;i:159;i:828;i:152;i:829;i:151;i:830;i:147;i:831;i:159;i:832;i:155;i:833;i:149;i:834;i:153;i:835;i:165;i:836;i:163;i:837;i:154;i:838;i:162;i:839;i:163;i:840;i:155;i:841;i:165;i:842;i:148;i:843;i:170;i:844;i:151;i:845;i:161;i:846;i:145;i:847;i:154;i:848;i:153;i:849;i:154;i:850;i:161;i:851;i:157;i:852;i:162;i:853;i:166;i:854;i:156;i:855;i:153;i:856;i:152;i:857;i:153;i:858;i:153;i:859;i:160;i:860;i:159;i:861;i:160;i:862;i:152;i:863;i:155;i:864;i:158;i:865;i:160;i:866;i:151;i:867;i:152;i:868;i:149;i:869;i:156;i:870;i:159;i:871;i:153;i:872;i:152;i:873;i:159;i:874;i:148;i:875;i:163;i:876;i:160;i:877;i:152;i:878;i:161;i:879;i:147;i:880;i:155;i:881;i:165;i:882;i:158;i:883;i:154;i:884;i:163;i:885;i:156;i:886;i:148;i:887;i:177;i:888;i:157;i:889;i:159;i:890;i:159;i:891;i:165;i:892;i:152;i:893;i:158;i:894;i:169;i:895;i:155;i:896;i:153;i:897;i:158;i:898;i:149;i:899;i:152;i:900;i:155;i:901;i:171;i:902;i:157;i:903;i:150;i:904;i:148;i:905;i:150;i:906;i:153;i:907;i:158;i:908;i:156;i:909;i:169;i:910;i:151;i:911;i:160;i:912;i:152;i:913;i:151;i:914;i:151;i:915;i:159;i:916;i:150;i:917;i:152;i:918;i:152;i:919;i:151;i:920;i:150;i:921;i:155;i:922;i:151;i:923;i:146;i:924;i:157;i:925;i:142;i:926;i:149;i:927;i:144;i:928;i:175;i:929;i:146;i:930;i:146;i:931;i:153;i:932;i:150;i:933;i:157;i:934;i:154;i:935;i:168;i:936;i:139;i:937;i:156;i:938;i:156;i:939;i:172;i:940;i:164;i:941;i:154;i:942;i:150;i:943;i:144;i:944;i:146;i:945;i:145;i:946;i:143;i:947;i:145;i:948;i:143;i:949;i:149;i:950;i:143;i:951;i:150;i:952;i:152;i:953;i:160;i:954;i:151;i:955;i:154;i:956;i:152;i:957;i:146;i:958;i:148;i:959;i:142;i:960;i:149;i:961;i:151;i:962;i:145;i:963;i:155;i:964;i:155;i:965;i:154;i:966;i:153;i:967;i:147;i:968;i:149;i:969;i:149;i:970;i:160;i:971;i:153;i:972;i:148;i:973;i:149;i:974;i:143;i:975;i:158;i:976;i:151;i:977;i:150;i:978;i:162;i:979;i:175;i:980;i:170;i:981;i:147;i:982;i:156;i:983;i:159;i:984;i:156;i:985;i:143;i:986;i:162;i:987;i:151;i:988;i:158;i:989;i:148;i:990;i:177;i:991;i:155;i:992;i:149;i:993;i:151;i:994;i:153;i:995;i:154;i:996;i:148;i:997;i:159;i:998;i:168;i:999;i:163;i:1000;i:165;i:1001;i:159;i:1002;i:145;i:1003;i:167;i:1004;i:153;i:1005;i:150;i:1006;i:159;i:1007;i:150;i:1008;i:150;i:1009;i:146;i:1010;i:146;i:1011;i:153;i:1012;i:144;i:1013;i:153;i:1014;i:162;i:1015;i:153;i:1016;i:145;i:1017;i:155;i:1018;i:150;i:1019;i:160;i:1020;i:148;i:1021;i:148;i:1022;i:151;i:1023;i:165;i:1024;i:150;i:1025;i:161;i:1026;i:149;i:1027;i:150;i:1028;i:152;i:1029;i:161;i:1030;i:160;i:1031;i:143;i:1032;i:152;i:1033;i:147;i:1034;i:158;i:1035;i:149;i:1036;i:151;i:1037;i:155;i:1038;i:147;i:1039;i:145;i:1040;i:145;i:1041;i:149;i:1042;i:143;i:1043;i:153;i:1044;i:169;i:1045;i:165;i:1046;i:150;i:1047;i:148;i:1048;i:161;i:1049;i:149;i:1050;i:149;i:1051;i:149;i:1052;i:151;i:1053;i:140;i:1054;i:151;i:1055;i:159;i:1056;i:151;i:1057;i:154;i:1058;i:155;i:1059;i:162;i:1060;i:157;i:1061;i:151;i:1062;i:153;i:1063;i:149;i:1064;i:160;i:1065;i:158;i:1066;i:155;i:1067;i:160;i:1068;i:153;i:1069;i:149;i:1070;i:139;i:1071;i:137;i:1072;i:149;i:1073;i:167;i:1074;i:144;i:1075;i:133;i:1076;i:146;i:1077;i:146;i:1078;i:157;i:1079;i:157;i:1080;i:158;i:1081;i:153;i:1082;i:145;i:1083;i:160;i:1084;i:160;i:1085;i:163;i:1086;i:147;i:1087;i:154;i:1088;i:151;i:1089;i:147;i:1090;i:148;i:1091;i:147;i:1092;i:161;i:1093;i:173;i:1094;i:155;i:1095;i:148;i:1096;i:147;i:1097;i:154;i:1098;i:149;i:1099;i:152;i:1100;i:170;i:1101;i:146;i:1102;i:147;i:1103;i:172;i:1104;i:155;i:1105;i:159;i:1106;i:181;i:1107;i:160;i:1108;i:149;i:1109;i:152;i:1110;i:169;i:1111;i:161;i:1112;i:152;i:1113;i:177;i:1114;i:165;i:1115;i:143;i:1116;i:180;i:1117;i:159;i:1118;i:170;i:1119;i:160;i:1120;i:158;i:1121;i:168;i:1122;i:147;i:1123;i:173;i:1124;i:156;i:1125;i:165;i:1126;i:155;i:1127;i:160;i:1128;i:162;i:1129;i:172;i:1130;i:175;i:1131;i:183;i:1132;i:159;i:1133;i:158;i:1134;i:161;i:1135;i:178;i:1136;i:152;i:1137;i:142;i:1138;i:155;i:1139;i:163;i:1140;i:153;i:1141;i:152;i:1142;i:160;i:1143;i:153;i:1144;i:147;i:1145;i:156;i:1146;i:152;i:1147;i:157;i:1148;i:141;i:1149;i:164;i:1150;i:149;i:1151;i:157;i:1152;i:155;i:1153;i:164;i:1154;i:154;i:1155;i:156;i:1156;i:171;i:1157;i:153;i:1158;i:158;i:1159;i:149;i:1160;i:158;i:1161;i:167;i:1162;i:164;i:1163;i:148;i:1164;i:151;i:1165;i:161;i:1166;i:131;i:1167;i:131;i:1168;i:143;i:1169;i:163;i:1170;i:147;i:1171;i:146;i:1172;i:156;i:1173;i:149;i:1174;i:160;i:1175;i:146;i:1176;i:148;i:1177;i:138;i:1178;i:154;i:1179;i:150;i:1180;i:145;i:1181;i:157;i:1182;i:148;i:1183;i:159;i:1184;i:156;i:1185;i:161;i:1186;i:154;i:1187;i:163;i:1188;i:153;i:1189;i:156;i:1190;i:158;i:1191;i:174;i:1192;i:154;i:1193;i:160;i:1194;i:165;i:1195;i:164;i:1196;i:154;i:1197;i:159;i:1198;i:162;i:1199;i:157;i:1200;i:166;i:1201;i:155;i:1202;i:172;i:1203;i:166;i:1204;i:157;i:1205;i:175;i:1206;i:160;i:1207;i:163;i:1208;i:163;i:1209;i:189;i:1210;i:156;i:1211;i:169;i:1212;i:173;i:1213;i:173;i:1214;i:159;i:1215;i:166;i:1216;i:162;i:1217;i:167;i:1218;i:163;i:1219;i:155;i:1220;i:166;i:1221;i:163;i:1222;i:155;i:1223;i:167;i:1224;i:154;i:1225;i:150;i:1226;i:163;i:1227;i:158;i:1228;i:158;i:1229;i:162;i:1230;i:153;i:1231;i:163;i:1232;i:163;i:1233;i:161;i:1234;i:162;i:1235;i:167;i:1236;i:158;i:1237;i:159;i:1238;i:164;i:1239;i:150;i:1240;i:156;i:1241;i:165;i:1242;i:152;i:1243;i:153;i:1244;i:166;i:1245;i:159;i:1246;i:163;i:1247;i:163;i:1248;i:167;i:1249;i:163;i:1250;i:167;i:1251;i:157;i:1252;i:165;i:1253;i:153;i:1254;i:156;i:1255;i:160;i:1256;i:163;i:1257;i:153;i:1258;i:162;i:1259;i:166;i:1260;i:158;i:1261;i:158;i:1262;i:156;i:1263;i:154;i:1264;i:166;i:1265;i:161;i:1266;i:156;i:1267;i:163;i:1268;i:165;i:1269;i:152;i:1270;i:161;i:1271;i:167;i:1272;i:153;i:1273;i:158;i:1274;i:166;i:1275;i:158;i:1276;i:165;i:1277;i:161;i:1278;i:152;i:1279;i:158;i:1280;i:169;i:1281;i:154;i:1282;i:160;i:1283;i:171;i:1284;i:155;i:1285;i:165;i:1286;i:152;i:1287;i:165;i:1288;i:161;i:1289;i:159;i:1290;i:156;i:1291;i:163;i:1292;i:171;i:1293;i:160;i:1294;i:171;i:1295;i:180;i:1296;i:194;i:1297;i:213;i:1298;i:181;i:1299;i:174;i:1300;i:207;i:1301;i:191;i:1302;i:197;i:1303;i:171;i:1304;i:200;i:1305;i:239;i:1306;i:186;i:1307;i:196;i:1308;i:198;i:1309;i:195;i:1310;i:227;i:1311;i:208;i:1312;i:179;i:1313;i:199;i:1314;i:185;i:1315;i:191;i:1316;i:217;i:1317;i:209;i:1318;i:192;i:1319;i:189;i:1320;i:178;i:1321;i:189;i:1322;i:211;i:1323;i:208;i:1324;i:202;i:1325;i:156;i:1326;i:201;i:1327;i:208;i:1328;i:186;i:1329;i:204;i:1330;i:192;i:1331;i:199;i:1332;i:178;i:1333;i:195;i:1334;i:199;i:1335;i:210;i:1336;i:224;i:1337;i:192;i:1338;i:224;i:1339;i:188;i:1340;i:191;i:1341;i:188;i:1342;i:191;i:1343;i:195;i:1344;i:202;i:1345;i:189;i:1346;i:201;i:1347;i:181;i:1348;i:195;i:1349;i:173;i:1350;i:162;i:1351;i:182;i:1352;i:163;i:1353;i:174;i:1354;i:164;i:1355;i:175;i:1356;i:169;i:1357;i:164;i:1358;i:173;i:1359;i:167;i:1360;i:166;i:1361;i:167;i:1362;i:199;i:1363;i:170;i:1364;i:171;i:1365;i:165;i:1366;i:173;i:1367;i:169;i:1368;i:177;i:1369;i:145;i:1370;i:142;i:1371;i:146;i:1372;i:149;i:1373;i:149;i:1374;i:141;i:1375;i:136;i:1376;i:131;i:1377;i:129;i:1378;i:129;i:1379;i:130;i:1380;i:131;i:1381;i:141;i:1382;i:165;i:1383;i:171;i:1384;i:196;i:1385;i:186;i:1386;i:194;i:1387;i:195;i:1388;i:210;i:1389;i:196;i:1390;i:216;i:1391;i:203;i:1392;i:219;i:1393;i:188;i:1394;i:194;i:1395;i:191;i:1396;i:191;i:1397;i:199;i:1398;i:177;i:1399;i:209;i:1400;i:183;i:1401;i:187;i:1402;i:195;i:1403;i:178;i:1404;i:199;i:1405;i:189;i:1406;i:228;i:1407;i:200;i:1408;i:208;i:1409;i:201;i:1410;i:194;i:1411;i:194;i:1412;i:194;i:1413;i:197;i:1414;i:195;i:1415;i:191;i:1416;i:221;i:1417;i:184;i:1418;i:200;i:1419;i:198;i:1420;i:185;i:1421;i:203;i:1422;i:195;i:1423;i:197;i:1424;i:197;i:1425;i:196;i:1426;i:225;i:1427;i:173;i:1428;i:164;i:1429;i:163;i:1430;i:157;i:1431;i:158;i:1432;i:153;i:1433;i:157;i:1434;i:161;i:1435;i:158;i:1436;i:148;i:1437;i:163;i:1438;i:164;i:1439;i:159;i:1440;i:163;i:1441;i:162;i:1442;i:161;i:1443;i:160;i:1444;i:160;i:1445;i:156;i:1446;i:160;i:1447;i:159;i:1448;i:155;i:1449;i:173;i:1450;i:161;i:1451;i:155;i:1452;i:163;i:1453;i:159;i:1454;i:154;i:1455;i:160;i:1456;i:155;i:1457;i:145;i:1458;i:147;i:1459;i:138;i:1460;i:141;i:1461;i:140;i:1462;i:137;i:1463;i:145;i:1464;i:145;i:1465;i:138;i:1466;i:150;i:1467;i:142;i:1468;i:141;i:1469;i:139;i:1470;i:139;i:1471;i:139;i:1472;i:158;i:1473;i:159;i:1474;i:152;i:1475;i:152;i:1476;i:156;i:1477;i:160;i:1478;i:158;i:1479;i:152;i:1480;i:156;i:1481;i:158;i:1482;i:151;i:1483;i:163;i:1484;i:146;i:1485;i:152;i:1486;i:162;i:1487;i:152;i:1488;i:153;i:1489;i:148;i:1490;i:150;i:1491;i:152;i:1492;i:158;i:1493;i:157;i:1494;i:159;i:1495;i:149;i:1496;i:158;i:1497;i:158;i:1498;i:157;i:1499;i:152;i:1500;i:162;i:1501;i:155;i:1502;i:157;i:1503;i:151;i:1504;i:154;i:1505;i:154;i:1506;i:167;i:1507;i:162;i:1508;i:160;i:1509;i:147;i:1510;i:157;i:1511;i:161;i:1512;i:166;i:1513;i:161;i:1514;i:154;i:1515;i:158;i:1516;i:157;i:1517;i:153;i:1518;i:156;i:1519;i:163;i:1520;i:155;i:1521;i:160;i:1522;i:155;i:1523;i:162;i:1524;i:155;i:1525;i:167;i:1526;i:153;i:1527;i:155;i:1528;i:155;i:1529;i:160;i:1530;i:163;i:1531;i:156;i:1532;i:157;i:1533;i:162;i:1534;i:158;i:1535;i:157;i:1536;i:158;i:1537;i:157;i:1538;i:152;i:1539;i:176;i:1540;i:149;i:1541;i:163;i:1542;i:155;i:1543;i:162;i:1544;i:160;i:1545;i:152;i:1546;i:155;i:1547;i:152;i:1548;i:180;i:1549;i:157;i:1550;i:166;i:1551;i:164;i:1552;i:158;i:1553;i:156;i:1554;i:161;i:1555;i:152;i:1556;i:158;i:1557;i:170;i:1558;i:154;i:1559;i:159;i:1560;i:147;i:1561;i:154;i:1562;i:146;i:1563;i:151;i:1564;i:159;i:1565;i:153;i:1566;i:150;i:1567;i:153;i:1568;i:167;i:1569;i:160;i:1570;i:151;i:1571;i:157;i:1572;i:166;i:1573;i:153;i:1574;i:164;i:1575;i:166;i:1576;i:151;i:1577;i:155;i:1578;i:157;i:1579;i:158;i:1580;i:150;i:1581;i:162;i:1582;i:158;i:1583;i:163;i:1584;i:163;i:1585;i:154;i:1586;i:163;i:1587;i:151;i:1588;i:150;i:1589;i:165;i:1590;i:171;i:1591;i:165;i:1592;i:146;i:1593;i:155;i:1594;i:153;i:1595;i:153;i:1596;i:159;i:1597;i:151;i:1598;i:151;i:1599;i:151;i:1600;i:166;i:1601;i:165;i:1602;i:160;i:1603;i:154;i:1604;i:168;i:1605;i:166;i:1606;i:161;i:1607;i:157;i:1608;i:161;i:1609;i:154;i:1610;i:157;i:1611;i:150;i:1612;i:151;i:1613;i:157;i:1614;i:156;i:1615;i:161;i:1616;i:154;i:1617;i:160;i:1618;i:159;i:1619;i:161;i:1620;i:153;i:1621;i:161;i:1622;i:160;i:1623;i:168;i:1624;i:158;i:1625;i:152;i:1626;i:151;i:1627;i:160;i:1628;i:156;i:1629;i:166;i:1630;i:157;i:1631;i:153;i:1632;i:168;i:1633;i:159;i:1634;i:164;i:1635;i:158;i:1636;i:157;i:1637;i:159;i:1638;i:159;i:1639;i:167;i:1640;i:158;i:1641;i:163;i:1642;i:161;i:1643;i:156;i:1644;i:149;i:1645;i:160;i:1646;i:159;i:1647;i:154;i:1648;i:154;i:1649;i:163;i:1650;i:162;i:1651;i:171;i:1652;i:157;i:1653;i:159;i:1654;i:154;i:1655;i:162;i:1656;i:155;i:1657;i:145;i:1658;i:163;i:1659;i:154;i:1660;i:162;i:1661;i:157;i:1662;i:147;i:1663;i:159;i:1664;i:159;i:1665;i:154;i:1666;i:165;i:1667;i:155;i:1668;i:165;i:1669;i:159;i:1670;i:154;i:1671;i:155;i:1672;i:160;i:1673;i:159;i:1674;i:160;i:1675;i:163;i:1676;i:159;i:1677;i:155;i:1678;i:159;i:1679;i:155;i:1680;i:159;i:1681;i:171;i:1682;i:161;i:1683;i:160;i:1684;i:166;i:1685;i:162;i:1686;i:155;i:1687;i:160;i:1688;i:167;i:1689;i:169;i:1690;i:164;i:1691;i:155;i:1692;i:165;i:1693;i:163;i:1694;i:161;i:1695;i:155;i:1696;i:173;i:1697;i:154;i:1698;i:155;i:1699;i:165;i:1700;i:157;i:1701;i:163;i:1702;i:161;i:1703;i:168;i:1704;i:159;i:1705;i:157;i:1706;i:149;i:1707;i:156;i:1708;i:162;i:1709;i:153;i:1710;i:161;i:1711;i:164;i:1712;i:174;i:1713;i:154;i:1714;i:179;i:1715;i:170;i:1716;i:163;i:1717;i:156;i:1718;i:156;i:1719;i:155;i:1720;i:152;i:1721;i:161;i:1722;i:161;i:1723;i:164;i:1724;i:174;i:1725;i:159;i:1726;i:171;i:1727;i:154;i:1728;i:169;i:1729;i:177;i:1730;i:170;i:1731;i:174;i:1732;i:164;i:1733;i:166;i:1734;i:159;i:1735;i:151;i:1736;i:164;i:1737;i:169;i:1738;i:164;i:1739;i:154;i:1740;i:179;i:1741;i:151;i:1742;i:151;i:1743;i:155;i:1744;i:160;i:1745;i:155;i:1746;i:163;i:1747;i:148;i:1748;i:150;i:1749;i:162;i:1750;i:158;i:1751;i:171;i:1752;i:160;i:1753;i:167;i:1754;i:160;i:1755;i:154;i:1756;i:156;i:1757;i:161;i:1758;i:158;i:1759;i:165;i:1760;i:165;i:1761;i:163;i:1762;i:169;i:1763;i:151;i:1764;i:158;i:1765;i:170;i:1766;i:169;i:1767;i:157;i:1768;i:158;i:1769;i:162;i:1770;i:174;i:1771;i:164;i:1772;i:183;i:1773;i:162;i:1774;i:151;i:1775;i:174;i:1776;i:153;i:1777;i:168;i:1778;i:158;i:1779;i:160;i:1780;i:164;i:1781;i:170;i:1782;i:163;i:1783;i:162;i:1784;i:158;i:1785;i:170;i:1786;i:160;i:1787;i:159;i:1788;i:172;i:1789;i:168;i:1790;i:178;i:1791;i:172;i:1792;i:169;i:1793;i:181;i:1794;i:157;i:1795;i:184;i:1796;i:183;i:1797;i:159;i:1798;i:176;i:1799;i:164;i:1800;i:162;i:1801;i:176;i:1802;i:157;i:1803;i:170;i:1804;i:163;i:1805;i:156;i:1806;i:158;i:1807;i:156;i:1808;i:156;i:1809;i:154;i:1810;i:158;i:1811;i:152;i:1812;i:158;i:1813;i:150;i:1814;i:166;i:1815;i:152;i:1816;i:146;i:1817;i:162;i:1818;i:156;i:1819;i:152;i:1820;i:157;i:1821;i:163;i:1822;i:160;i:1823;i:142;i:1824;i:168;i:1825;i:148;i:1826;i:157;i:1827;i:165;i:1828;i:168;i:1829;i:168;i:1830;i:167;i:1831;i:164;i:1832;i:172;i:1833;i:166;i:1834;i:168;i:1835;i:153;i:1836;i:161;i:1837;i:163;i:1838;i:187;i:1839;i:176;i:1840;i:159;i:1841;i:159;i:1842;i:161;i:1843;i:162;i:1844;i:174;i:1845;i:147;i:1846;i:181;i:1847;i:171;i:1848;i:176;i:1849;i:158;i:1850;i:166;i:1851;i:171;i:1852;i:162;i:1853;i:188;i:1854;i:193;i:1855;i:164;i:1856;i:155;i:1857;i:172;i:1858;i:155;i:1859;i:153;i:1860;i:158;i:1861;i:162;i:1862;i:164;i:1863;i:155;i:1864;i:163;i:1865;i:181;i:1866;i:171;i:1867;i:173;i:1868;i:179;i:1869;i:162;i:1870;i:158;i:1871;i:150;i:1872;i:189;i:1873;i:181;i:1874;i:169;i:1875;i:169;i:1876;i:161;i:1877;i:172;i:1878;i:167;i:1879;i:174;i:1880;i:163;i:1881;i:151;i:1882;i:174;i:1883;i:157;i:1884;i:159;i:1885;i:182;i:1886;i:165;i:1887;i:166;i:1888;i:151;i:1889;i:170;i:1890;i:171;i:1891;i:153;i:1892;i:175;i:1893;i:166;i:1894;i:180;i:1895;i:165;i:1896;i:165;i:1897;i:170;i:1898;i:187;i:1899;i:190;i:1900;i:163;i:1901;i:163;i:1902;i:159;i:1903;i:170;i:1904;i:164;i:1905;i:155;i:1906;i:174;i:1907;i:165;i:1908;i:160;i:1909;i:152;i:1910;i:179;i:1911;i:171;i:1912;i:160;i:1913;i:173;i:1914;i:177;i:1915;i:172;i:1916;i:161;i:1917;i:170;i:1918;i:158;i:1919;i:188;i:1920;i:178;i:1921;i:158;i:1922;i:169;i:1923;i:166;i:1924;i:178;i:1925;i:173;i:1926;i:170;i:1927;i:164;i:1928;i:166;i:1929;i:165;i:1930;i:155;i:1931;i:155;i:1932;i:167;i:1933;i:153;i:1934;i:171;i:1935;i:183;i:1936;i:162;i:1937;i:171;i:1938;i:169;i:1939;i:175;i:1940;i:158;i:1941;i:183;i:1942;i:168;i:1943;i:168;i:1944;i:160;i:1945;i:182;i:1946;i:174;i:1947;i:189;i:1948;i:180;i:1949;i:182;i:1950;i:177;i:1951;i:169;i:1952;i:171;i:1953;i:178;i:1954;i:176;i:1955;i:180;i:1956;i:189;i:1957;i:176;i:1958;i:176;i:1959;i:166;i:1960;i:173;i:1961;i:167;i:1962;i:175;i:1963;i:176;i:1964;i:189;i:1965;i:203;i:1966;i:179;i:1967;i:187;i:1968;i:176;i:1969;i:188;i:1970;i:198;i:1971;i:232;i:1972;i:198;i:1973;i:218;i:1974;i:209;i:1975;i:195;i:1976;i:184;i:1977;i:213;i:1978;i:188;i:1979;i:203;i:1980;i:191;i:1981;i:204;i:1982;i:194;i:1983;i:180;i:1984;i:186;i:1985;i:192;i:1986;i:204;i:1987;i:182;i:1988;i:207;i:1989;i:219;i:1990;i:226;i:1991;i:184;i:1992;i:201;i:1993;i:211;i:1994;i:201;i:1995;i:196;i:1996;i:185;i:1997;i:178;i:1998;i:180;i:1999;i:216;i:2000;i:199;i:2001;i:187;i:2002;i:200;i:2003;i:189;i:2004;i:201;i:2005;i:187;i:2006;i:200;i:2007;i:216;i:2008;i:172;i:2009;i:201;i:2010;i:177;i:2011;i:182;i:2012;i:185;i:2013;i:175;i:2014;i:197;i:2015;i:181;i:2016;i:187;i:2017;i:187;i:2018;i:182;i:2019;i:182;i:2020;i:202;i:2021;i:189;i:2022;i:228;i:2023;i:181;i:2024;i:221;i:2025;i:186;i:2026;i:180;i:2027;i:172;i:2028;i:195;i:2029;i:210;i:2030;i:181;i:2031;i:182;i:2032;i:198;i:2033;i:178;i:2034;i:165;i:2035;i:203;i:2036;i:183;i:2037;i:191;i:2038;i:207;i:2039;i:211;i:2040;i:211;i:2041;i:213;i:2042;i:183;i:2043;i:211;i:2044;i:183;i:2045;i:195;i:2046;i:216;i:2047;i:207;i:2048;i:189;i:2049;i:200;i:2050;i:185;i:2051;i:186;i:2052;i:217;i:2053;i:205;i:2054;i:208;i:2055;i:181;i:2056;i:198;i:2057;i:196;i:2058;i:189;i:2059;i:212;i:2060;i:182;i:2061;i:184;i:2062;i:183;i:2063;i:219;i:2064;i:191;i:2065;i:178;i:2066;i:192;i:2067;i:195;i:2068;i:194;i:2069;i:175;i:2070;i:181;i:2071;i:196;i:2072;i:225;i:2073;i:203;i:2074;i:199;i:2075;i:192;i:2076;i:193;i:2077;i:209;i:2078;i:182;i:2079;i:208;i:2080;i:210;i:2081;i:164;i:2082;i:203;i:2083;i:185;i:2084;i:209;i:2085;i:182;i:2086;i:184;i:2087;i:178;i:2088;i:190;i:2089;i:234;i:2090;i:206;i:2091;i:201;i:2092;i:193;i:2093;i:194;i:2094;i:180;i:2095;i:200;i:2096;i:211;i:2097;i:175;i:2098;i:189;i:2099;i:195;i:2100;i:208;i:2101;i:186;i:2102;i:194;i:2103;i:214;i:2104;i:198;i:2105;i:212;i:2106;i:210;i:2107;i:213;i:2108;i:173;i:2109;i:219;i:2110;i:162;i:2111;i:226;i:2112;i:162;i:2113;i:198;i:2114;i:193;i:2115;i:186;i:2116;i:195;i:2117;i:170;i:2118;i:200;i:2119;i:185;i:2120;i:199;i:2121;i:182;i:2122;i:181;i:2123;i:185;i:2124;i:186;i:2125;i:184;i:2126;i:185;i:2127;i:215;i:2128;i:206;i:2129;i:180;i:2130;i:183;i:2131;i:178;i:2132;i:213;i:2133;i:176;i:2134;i:211;i:2135;i:196;i:2136;i:173;i:2137;i:204;i:2138;i:209;i:2139;i:191;i:2140;i:183;i:2141;i:158;i:2142;i:196;i:2143;i:202;i:2144;i:189;i:2145;i:197;i:2146;i:193;i:2147;i:191;i:2148;i:209;i:2149;i:189;i:2150;i:183;i:2151;i:183;i:2152;i:180;i:2153;i:213;i:2154;i:185;i:2155;i:202;i:2156;i:191;i:2157;i:202;i:2158;i:188;i:2159;i:210;i:2160;i:208;i:2161;i:188;i:2162;i:203;i:2163;i:199;i:2164;i:187;i:2165;i:213;i:2166;i:162;i:2167;i:185;i:2168;i:192;i:2169;i:201;i:2170;i:182;i:2171;i:184;i:2172;i:174;i:2173;i:195;i:2174;i:203;i:2175;i:209;i:2176;i:195;i:2177;i:180;i:2178;i:204;i:2179;i:182;i:2180;i:196;i:2181;i:179;i:2182;i:190;i:2183;i:186;i:2184;i:211;i:2185;i:206;i:2186;i:191;i:2187;i:190;i:2188;i:194;i:2189;i:179;i:2190;i:183;i:2191;i:216;i:2192;i:195;i:2193;i:191;i:2194;i:181;i:2195;i:197;i:2196;i:206;i:2197;i:181;i:2198;i:189;i:2199;i:199;i:2200;i:224;i:2201;i:221;i:2202;i:196;i:2203;i:185;i:2204;i:189;i:2205;i:206;i:2206;i:191;i:2207;i:192;i:2208;i:221;i:2209;i:184;i:2210;i:199;i:2211;i:183;i:2212;i:205;i:2213;i:189;i:2214;i:205;i:2215;i:201;i:2216;i:191;i:2217;i:197;i:2218;i:184;i:2219;i:173;i:2220;i:210;i:2221;i:177;i:2222;i:190;i:2223;i:199;i:2224;i:206;i:2225;i:191;i:2226;i:218;i:2227;i:189;i:2228;i:187;i:2229;i:194;i:2230;i:172;i:2231;i:221;i:2232;i:178;i:2233;i:191;i:2234;i:204;i:2235;i:216;i:2236;i:188;i:2237;i:198;i:2238;i:215;i:2239;i:191;i:2240;i:180;i:2241;i:187;i:2242;i:209;i:2243;i:200;i:2244;i:209;i:2245;i:193;i:2246;i:213;i:2247;i:206;i:2248;i:201;i:2249;i:190;i:2250;i:198;i:2251;i:214;i:2252;i:196;i:2253;i:220;i:2254;i:187;i:2255;i:173;i:2256;i:207;i:2257;i:148;i:2258;i:188;i:2259;i:162;i:2260;i:184;i:2261;i:164;i:2262;i:161;i:2263;i:168;i:2264;i:157;i:2265;i:145;i:2266;i:142;i:2267;i:154;i:2268;i:154;i:2269;i:166;i:2270;i:152;i:2271;i:165;i:2272;i:167;i:2273;i:161;i:2274;i:164;i:2275;i:167;i:2276;i:161;i:2277;i:184;i:2278;i:164;i:2279;i:179;i:2280;i:173;i:2281;i:156;i:2282;i:175;i:2283;i:178;i:2284;i:184;i:2285;i:164;i:2286;i:151;i:2287;i:156;i:2288;i:149;i:2289;i:165;i:2290;i:162;i:2291;i:150;i:2292;i:174;i:2293;i:178;i:2294;i:146;i:2295;i:163;i:2296;i:180;i:2297;i:169;i:2298;i:161;i:2299;i:176;i:2300;i:163;i:2301;i:167;i:2302;i:169;i:2303;i:152;i:2304;i:170;i:2305;i:144;i:2306;i:149;i:2307;i:167;i:2308;i:162;i:2309;i:173;i:2310;i:148;i:2311;i:152;i:2312;i:159;i:2313;i:168;i:2314;i:169;i:2315;i:161;i:2316;i:156;i:2317;i:168;i:2318;i:171;i:2319;i:164;i:2320;i:174;i:2321;i:173;i:2322;i:161;i:2323;i:160;i:2324;i:187;i:2325;i:192;i:2326;i:152;i:2327;i:163;i:2328;i:161;i:2329;i:165;i:2330;i:153;i:2331;i:147;i:2332;i:153;i:2333;i:153;i:2334;i:162;i:2335;i:161;i:2336;i:165;i:2337;i:160;i:2338;i:170;i:2339;i:164;i:2340;i:151;i:2341;i:178;i:2342;i:174;i:2343;i:166;i:2344;i:164;i:2345;i:170;i:2346;i:170;i:2347;i:157;i:2348;i:157;i:2349;i:167;i:2350;i:162;i:2351;i:151;i:2352;i:168;i:2353;i:170;i:2354;i:157;i:2355;i:176;i:2356;i:161;i:2357;i:173;i:2358;i:163;i:2359;i:159;i:2360;i:171;i:2361;i:173;i:2362;i:174;i:2363;i:175;i:2364;i:174;i:2365;i:175;i:2366;i:167;i:2367;i:168;i:2368;i:186;i:2369;i:162;i:2370;i:171;i:2371;i:159;i:2372;i:165;i:2373;i:153;i:2374;i:171;i:2375;i:164;i:2376;i:160;i:2377;i:157;i:2378;i:175;i:2379;i:162;i:2380;i:155;i:2381;i:177;i:2382;i:169;i:2383;i:164;i:2384;i:159;i:2385;i:158;i:2386;i:165;i:2387;i:152;i:2388;i:153;i:2389;i:175;i:2390;i:161;i:2391;i:157;i:2392;i:167;i:2393;i:164;i:2394;i:149;i:2395;i:164;i:2396;i:169;i:2397;i:158;i:2398;i:162;i:2399;i:165;i:2400;i:184;i:2401;i:163;i:2402;i:163;i:2403;i:176;i:2404;i:177;i:2405;i:173;i:2406;i:158;i:2407;i:166;i:2408;i:163;i:2409;i:160;i:2410;i:169;i:2411;i:164;i:2412;i:162;i:2413;i:160;i:2414;i:167;i:2415;i:163;i:2416;i:160;i:2417;i:163;i:2418;i:163;i:2419;i:156;i:2420;i:157;i:2421;i:165;i:2422;i:162;i:2423;i:158;i:2424;i:185;i:2425;i:171;i:2426;i:163;i:2427;i:160;i:2428;i:170;i:2429;i:143;i:2430;i:162;i:2431;i:170;i:2432;i:188;i:2433;i:159;i:2434;i:139;i:2435;i:152;i:2436;i:177;i:2437;i:158;i:2438;i:153;i:2439;i:181;i:2440;i:167;i:2441;i:165;i:2442;i:150;i:2443;i:160;i:2444;i:153;i:2445;i:147;i:2446;i:165;i:2447;i:146;i:2448;i:162;i:2449;i:147;i:2450;i:159;i:2451;i:147;i:2452;i:139;i:2453;i:163;i:2454;i:155;i:2455;i:147;i:2456;i:167;i:2457;i:155;i:2458;i:153;i:2459;i:142;i:2460;i:167;i:2461;i:170;i:2462;i:171;i:2463;i:157;i:2464;i:146;i:2465;i:154;i:2466;i:156;i:2467;i:156;i:2468;i:146;i:2469;i:151;i:2470;i:155;i:2471;i:160;i:2472;i:164;i:2473;i:164;i:2474;i:159;i:2475;i:154;i:2476;i:150;i:2477;i:160;i:2478;i:170;i:2479;i:150;i:2480;i:186;i:2481;i:168;i:2482;i:168;i:2483;i:155;i:2484;i:162;i:2485;i:173;i:2486;i:156;i:2487;i:165;i:2488;i:162;i:2489;i:164;i:2490;i:143;i:2491;i:147;i:2492;i:147;i:2493;i:149;i:2494;i:157;i:2495;i:166;i:2496;i:151;i:2497;i:153;i:2498;i:158;i:2499;i:156;i:2500;i:182;i:2501;i:152;i:2502;i:146;i:2503;i:155;i:2504;i:152;i:2505;i:152;i:2506;i:154;i:2507;i:145;i:2508;i:160;i:2509;i:156;i:2510;i:146;i:2511;i:159;i:2512;i:168;i:2513;i:163;i:2514;i:149;i:2515;i:160;i:2516;i:153;i:2517;i:151;i:2518;i:168;i:2519;i:142;i:2520;i:155;i:2521;i:145;i:2522;i:166;i:2523;i:163;i:2524;i:154;i:2525;i:168;i:2526;i:152;i:2527;i:155;i:2528;i:192;i:2529;i:159;i:2530;i:170;i:2531;i:149;i:2532;i:173;i:2533;i:157;i:2534;i:160;i:2535;i:167;i:2536;i:167;i:2537;i:163;i:2538;i:170;i:2539;i:147;i:2540;i:145;i:2541;i:157;i:2542;i:158;i:2543;i:177;i:2544;i:158;i:2545;i:173;i:2546;i:156;i:2547;i:167;i:2548;i:175;i:2549;i:165;i:2550;i:170;i:2551;i:163;i:2552;i:160;i:2553;i:153;i:2554;i:147;i:2555;i:154;i:2556;i:162;i:2557;i:178;i:2558;i:152;i:2559;i:153;i:2560;i:165;i:2561;i:150;i:2562;i:145;i:2563;i:171;i:2564;i:159;i:2565;i:167;i:2566;i:155;i:2567;i:155;i:2568;i:168;i:2569;i:163;i:2570;i:172;i:2571;i:156;i:2572;i:173;i:2573;i:155;i:2574;i:159;i:2575;i:152;i:2576;i:161;i:2577;i:173;i:2578;i:166;i:2579;i:176;i:2580;i:163;i:2581;i:158;i:2582;i:158;i:2583;i:172;i:2584;i:184;i:2585;i:169;i:2586;i:151;i:2587;i:156;i:2588;i:160;i:2589;i:186;i:2590;i:160;i:2591;i:157;i:2592;i:157;i:2593;i:152;i:2594;i:170;i:2595;i:157;i:2596;i:150;i:2597;i:150;i:2598;i:154;i:2599;i:160;i:2600;i:147;i:2601;i:172;i:2602;i:156;i:2603;i:154;i:2604;i:163;i:2605;i:164;i:2606;i:157;i:2607;i:157;i:2608;i:155;i:2609;i:168;i:2610;i:172;i:2611;i:156;i:2612;i:157;i:2613;i:165;i:2614;i:149;i:2615;i:154;i:2616;i:166;i:2617;i:155;i:2618;i:158;i:2619;i:163;i:2620;i:152;i:2621;i:167;i:2622;i:166;i:2623;i:148;i:2624;i:154;i:2625;i:149;i:2626;i:159;i:2627;i:167;i:2628;i:161;i:2629;i:170;i:2630;i:161;i:2631;i:153;i:2632;i:178;i:2633;i:166;i:2634;i:147;i:2635;i:166;i:2636;i:159;i:2637;i:180;i:2638;i:152;i:2639;i:159;i:2640;i:150;i:2641;i:146;i:2642;i:154;i:2643;i:149;i:2644;i:152;i:2645;i:163;i:2646;i:150;i:2647;i:174;i:2648;i:166;i:2649;i:146;i:2650;i:159;i:2651;i:140;i:2652;i:146;i:2653;i:164;i:2654;i:175;i:2655;i:148;i:2656;i:153;i:2657;i:141;i:2658;i:168;i:2659;i:161;i:2660;i:194;i:2661;i:162;i:2662;i:160;i:2663;i:145;i:2664;i:143;i:2665;i:179;i:2666;i:168;i:2667;i:152;i:2668;i:156;i:2669;i:156;i:2670;i:172;i:2671;i:153;i:2672;i:161;i:2673;i:156;i:2674;i:166;i:2675;i:152;i:2676;i:157;i:2677;i:151;i:2678;i:154;i:2679;i:163;i:2680;i:159;i:2681;i:171;i:2682;i:164;i:2683;i:174;i:2684;i:155;i:2685;i:164;i:2686;i:157;i:2687;i:180;i:2688;i:165;i:2689;i:151;i:2690;i:140;i:2691;i:133;i:2692;i:132;i:2693;i:132;i:2694;i:133;i:2695;i:131;i:2696;i:131;i:2697;i:134;i:2698;i:132;i:2699;i:139;i:2700;i:139;i:2701;i:145;i:2702;i:140;i:2703;i:136;i:2704;i:144;i:2705;i:140;i:2706;i:140;i:2707;i:136;i:2708;i:136;i:2709;i:140;i:2710;i:138;i:2711;i:139;i:2712;i:139;i:2713;i:144;i:2714;i:139;i:2715;i:139;i:2716;i:140;i:2717;i:147;i:2718;i:149;i:2719;i:142;i:2720;i:157;i:2721;i:144;i:2722;i:157;i:2723;i:141;i:2724;i:160;i:2725;i:160;i:2726;i:142;i:2727;i:148;i:2728;i:146;i:2729;i:161;i:2730;i:173;i:2731;i:158;i:2732;i:169;i:2733;i:163;i:2734;i:163;i:2735;i:150;i:2736;i:157;i:2737;i:148;i:2738;i:145;i:2739;i:155;i:2740;i:162;i:2741;i:145;i:2742;i:152;i:2743;i:149;i:2744;i:150;i:2745;i:144;i:2746;i:160;i:2747;i:153;i:2748;i:147;i:2749;i:157;i:2750;i:158;i:2751;i:153;i:2752;i:144;i:2753;i:156;i:2754;i:157;i:2755;i:151;i:2756;i:161;i:2757;i:161;i:2758;i:155;i:2759;i:157;i:2760;i:141;i:2761;i:168;i:2762;i:149;i:2763;i:160;i:2764;i:163;i:2765;i:160;i:2766;i:158;i:2767;i:162;i:2768;i:156;i:2769;i:162;i:2770;i:154;i:2771;i:141;i:2772;i:143;i:2773;i:149;i:2774;i:147;i:2775;i:156;i:2776;i:156;i:2777;i:141;i:2778;i:151;i:2779;i:147;i:2780;i:154;i:2781;i:144;i:2782;i:142;i:2783;i:143;i:2784;i:149;i:2785;i:157;i:2786;i:146;i:2787;i:150;i:2788;i:146;i:2789;i:145;i:2790;i:157;i:2791;i:143;i:2792;i:156;i:2793;i:147;i:2794;i:156;i:2795;i:152;i:2796;i:160;i:2797;i:170;i:2798;i:162;i:2799;i:143;i:2800;i:153;i:2801;i:146;i:2802;i:159;i:2803;i:142;i:2804;i:169;i:2805;i:164;i:2806;i:146;i:2807;i:157;i:2808;i:154;i:2809;i:150;i:2810;i:164;i:2811;i:155;i:2812;i:164;i:2813;i:152;i:2814;i:157;i:2815;i:162;i:2816;i:165;i:2817;i:154;i:2818;i:148;i:2819;i:146;i:2820;i:151;i:2821;i:149;i:2822;i:157;i:2823;i:150;i:2824;i:150;i:2825;i:150;i:2826;i:163;i:2827;i:150;i:2828;i:158;i:2829;i:157;i:2830;i:144;i:2831;i:157;i:2832;i:139;i:2833;i:143;i:2834;i:149;i:2835;i:139;i:2836;i:142;i:2837;i:145;i:2838;i:161;i:2839;i:165;i:2840;i:151;i:2841;i:173;i:2842;i:147;i:2843;i:145;i:2844;i:168;i:2845;i:156;i:2846;i:151;i:2847;i:155;i:2848;i:166;i:2849;i:148;i:2850;i:150;i:2851;i:159;i:2852;i:156;i:2853;i:166;i:2854;i:147;i:2855;i:165;i:2856;i:156;i:2857;i:151;i:2858;i:158;i:2859;i:173;i:2860;i:159;i:2861;i:163;i:2862;i:151;i:2863;i:146;i:2864;i:156;i:2865;i:146;i:2866;i:151;i:2867;i:153;i:2868;i:157;i:2869;i:146;i:2870;i:155;i:2871;i:156;i:2872;i:145;i:2873;i:155;i:2874;i:159;i:2875;i:151;i:2876;i:157;i:2877;i:155;i:2878;i:154;i:2879;i:148;i:2880;i:156;i:2881;i:159;i:2882;i:149;i:2883;i:160;i:2884;i:153;i:2885;i:159;i:2886;i:161;i:2887;i:190;i:2888;i:179;i:2889;i:195;i:2890;i:146;i:2891;i:189;i:2892;i:183;i:2893;i:148;i:2894;i:167;i:2895;i:187;i:2896;i:190;i:2897;i:145;i:2898;i:202;i:2899;i:198;i:2900;i:175;i:2901;i:196;i:2902;i:197;i:2903;i:190;i:2904;i:154;i:2905;i:193;i:2906;i:205;i:2907;i:175;i:2908;i:193;i:2909;i:181;i:2910;i:200;i:2911;i:186;i:2912;i:189;i:2913;i:193;i:2914;i:186;i:2915;i:182;i:2916;i:164;i:2917;i:195;i:2918;i:159;i:2919;i:200;i:2920;i:179;i:2921;i:160;i:2922;i:193;i:2923;i:169;i:2924;i:180;i:2925;i:157;i:2926;i:191;i:2927;i:148;i:2928;i:154;i:2929;i:153;i:2930;i:150;i:2931;i:154;i:2932;i:145;i:2933;i:150;i:2934;i:148;i:2935;i:180;i:2936;i:159;i:2937;i:162;i:2938;i:157;i:2939;i:158;i:2940;i:163;i:2941;i:147;i:2942;i:152;i:2943;i:150;i:2944;i:158;i:2945;i:146;i:2946;i:150;i:2947;i:152;i:2948;i:147;i:2949;i:147;i:2950;i:145;i:2951;i:159;i:2952;i:155;i:2953;i:151;i:2954;i:152;i:2955;i:188;i:2956;i:199;i:2957;i:185;i:2958;i:192;i:2959;i:152;i:2960;i:193;i:2961;i:190;i:2962;i:195;i:2963;i:152;i:2964;i:197;i:2965;i:183;i:2966;i:164;i:2967;i:151;i:2968;i:151;i:2969;i:188;i:2970;i:189;i:2971;i:199;i:2972;i:196;i:2973;i:160;i:2974;i:194;i:2975;i:196;i:2976;i:195;i:2977;i:196;i:2978;i:188;i:2979;i:191;i:2980;i:175;i:2981;i:191;i:2982;i:193;i:2983;i:191;i:2984;i:202;i:2985;i:195;i:2986;i:196;i:2987;i:181;i:2988;i:184;i:2989;i:191;i:2990;i:171;i:2991;i:166;i:2992;i:175;i:2993;i:190;i:2994;i:166;i:2995;i:191;i:2996;i:197;i:2997;i:159;i:2998;i:155;i:2999;i:158;}");
INSERT INTO `wp_postmeta` VALUES("2348", "613", "duration", "3466000");
INSERT INTO `wp_postmeta` VALUES("2349", "613", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2350", "613", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2351", "613", "download_url", "https://hearthis.at/zyzcphmx/biotech-04102020-roberto-del-burgo/download/");
INSERT INTO `wp_postmeta` VALUES("2352", "613", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2353", "613", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2354", "613", "post-count-all", "279");
INSERT INTO `wp_postmeta` VALUES("2355", "613", "like_count", "0");
INSERT INTO `wp_postmeta` VALUES("2356", "613", "download_count", "57");
INSERT INTO `wp_postmeta` VALUES("2357", "613", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2358", "613", "post-count-week-202044", "16");
INSERT INTO `wp_postmeta` VALUES("2359", "613", "post-count-month-202010", "16");
INSERT INTO `wp_postmeta` VALUES("2360", "613", "post-count-year-2020", "279");
INSERT INTO `wp_postmeta` VALUES("2361", "613", "post-count-week-202046", "3");
INSERT INTO `wp_postmeta` VALUES("2362", "613", "post-count-month-202011", "4");
INSERT INTO `wp_postmeta` VALUES("2363", "613", "_wp_old_slug", "biotech-roberto-del-burgo");
INSERT INTO `wp_postmeta` VALUES("2364", "613", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2365", "613", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2366", "613", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2370", "613", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("2371", "613", "post-count-week-202050", "58");
INSERT INTO `wp_postmeta` VALUES("2372", "613", "post-count-month-202012", "259");
INSERT INTO `wp_postmeta` VALUES("2373", "613", "post-count-week-202051", "199");
INSERT INTO `wp_postmeta` VALUES("2374", "613", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("2375", "613", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2376", "613", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2377", "613", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2378", "613", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2379", "666", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2380", "666", "post", "");
INSERT INTO `wp_postmeta` VALUES("2381", "666", "stream", "https://music.youtube.com/watch?v=hmdBm3GYJks&list=RDCLAK5uy_kwEk3O8OP2Tu0u7WjoTbOGoruciyaDpDs");
INSERT INTO `wp_postmeta` VALUES("2382", "666", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2383", "666", "duration", "183000");
INSERT INTO `wp_postmeta` VALUES("2384", "666", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2385", "666", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2386", "666", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2387", "666", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2388", "666", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2389", "666", "post-count-all", "119");
INSERT INTO `wp_postmeta` VALUES("2390", "666", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2391", "666", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2392", "666", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2393", "666", "post-count-week-202044", "7");
INSERT INTO `wp_postmeta` VALUES("2394", "666", "post-count-month-202010", "5");
INSERT INTO `wp_postmeta` VALUES("2395", "666", "post-count-year-2020", "110");
INSERT INTO `wp_postmeta` VALUES("2396", "666", "_thumbnail_id", "698");
INSERT INTO `wp_postmeta` VALUES("2397", "666", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2398", "666", "post-count-month-202011", "30");
INSERT INTO `wp_postmeta` VALUES("2399", "666", "post-count-week-202045", "8");
INSERT INTO `wp_postmeta` VALUES("2400", "666", "post-count-week-202046", "18");
INSERT INTO `wp_postmeta` VALUES("2401", "666", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2402", "666", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2406", "666", "post-count-week-202047", "2");
INSERT INTO `wp_postmeta` VALUES("2407", "666", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("2408", "666", "post-count-month-202012", "75");
INSERT INTO `wp_postmeta` VALUES("2409", "666", "post-count-week-202050", "65");
INSERT INTO `wp_postmeta` VALUES("2410", "666", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2411", "666", "post-count-week-202052", "6");
INSERT INTO `wp_postmeta` VALUES("2412", "666", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2413", "666", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2414", "666", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2415", "666", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2416", "763", "_thumbnail_id", "540");
INSERT INTO `wp_postmeta` VALUES("2417", "763", "post", "222,480,172,157");
INSERT INTO `wp_postmeta` VALUES("2418", "763", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("2419", "763", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2420", "763", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2421", "763", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2422", "763", "post-count-all", "323");
INSERT INTO `wp_postmeta` VALUES("2423", "763", "post-count-week-202046", "4");
INSERT INTO `wp_postmeta` VALUES("2424", "763", "post-count-month-202011", "5");
INSERT INTO `wp_postmeta` VALUES("2425", "763", "post-count-year-2020", "14");
INSERT INTO `wp_postmeta` VALUES("2426", "763", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2427", "763", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2428", "763", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2429", "763", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2430", "763", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2431", "763", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2432", "763", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2433", "763", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2434", "763", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2435", "763", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2436", "763", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2440", "763", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("2441", "763", "post-count-week-202050", "3");
INSERT INTO `wp_postmeta` VALUES("2442", "763", "post-count-month-202012", "9");
INSERT INTO `wp_postmeta` VALUES("2443", "763", "post-count-week-202052", "6");
INSERT INTO `wp_postmeta` VALUES("2444", "763", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2445", "763", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2446", "763", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2447", "764", "_thumbnail_id", "542");
INSERT INTO `wp_postmeta` VALUES("2448", "764", "post", "609,218,221,217,176");
INSERT INTO `wp_postmeta` VALUES("2449", "764", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("2450", "764", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2451", "764", "post-count-all", "1119");
INSERT INTO `wp_postmeta` VALUES("2452", "764", "post-count-week-202044", "1");
INSERT INTO `wp_postmeta` VALUES("2453", "764", "post-count-month-202011", "11");
INSERT INTO `wp_postmeta` VALUES("2454", "764", "post-count-year-2020", "24");
INSERT INTO `wp_postmeta` VALUES("2455", "764", "post-count-week-202045", "4");
INSERT INTO `wp_postmeta` VALUES("2456", "764", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2457", "764", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2458", "764", "post-count-week-202046", "5");
INSERT INTO `wp_postmeta` VALUES("2459", "764", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2460", "764", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2461", "764", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2462", "764", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2463", "764", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2464", "764", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2465", "764", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2466", "764", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2467", "764", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2468", "764", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2469", "764", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2473", "764", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("2474", "764", "post-count-week-202049", "1");
INSERT INTO `wp_postmeta` VALUES("2475", "764", "post-count-month-202012", "13");
INSERT INTO `wp_postmeta` VALUES("2476", "764", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("2477", "764", "post-count-week-202051", "7");
INSERT INTO `wp_postmeta` VALUES("2478", "764", "post-count-week-202052", "2");
INSERT INTO `wp_postmeta` VALUES("2479", "764", "post-count-week-202053", "1");
INSERT INTO `wp_postmeta` VALUES("2480", "764", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2481", "764", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2482", "764", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2483", "765", "_thumbnail_id", "538");
INSERT INTO `wp_postmeta` VALUES("2484", "765", "post", "476,666");
INSERT INTO `wp_postmeta` VALUES("2485", "765", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("2486", "765", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2487", "765", "post-count-all", "154");
INSERT INTO `wp_postmeta` VALUES("2488", "765", "post-count-week-202044", "2");
INSERT INTO `wp_postmeta` VALUES("2489", "765", "post-count-month-202010", "1");
INSERT INTO `wp_postmeta` VALUES("2490", "765", "post-count-year-2020", "21");
INSERT INTO `wp_postmeta` VALUES("2491", "765", "post-count-month-202011", "8");
INSERT INTO `wp_postmeta` VALUES("2492", "765", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("2493", "765", "like_count", "1");
INSERT INTO `wp_postmeta` VALUES("2494", "765", "like_user", "a:1:{i:0;i:1;}");
INSERT INTO `wp_postmeta` VALUES("2495", "765", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2496", "765", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2497", "765", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2498", "765", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2499", "765", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2500", "765", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2501", "765", "thumbnail_pos_y", "50");
INSERT INTO `wp_postmeta` VALUES("2502", "765", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2503", "765", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2504", "765", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2505", "765", "editor_note", "This is a collection with Youtube video and music.");
INSERT INTO `wp_postmeta` VALUES("2506", "765", "copyright", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2507", "765", "_wp_old_slug", "mtv");
INSERT INTO `wp_postmeta` VALUES("2508", "765", "post-count-week-202046", "4");
INSERT INTO `wp_postmeta` VALUES("2512", "765", "post-count-week-202047", "1");
INSERT INTO `wp_postmeta` VALUES("2513", "765", "post-count-week-202050", "1");
INSERT INTO `wp_postmeta` VALUES("2514", "765", "post-count-month-202012", "12");
INSERT INTO `wp_postmeta` VALUES("2515", "765", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2516", "765", "post-count-week-202052", "10");
INSERT INTO `wp_postmeta` VALUES("2517", "765", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2518", "765", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2519", "765", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2520", "766", "_thumbnail_id", "541");
INSERT INTO `wp_postmeta` VALUES("2521", "766", "post", "157,476,237,146");
INSERT INTO `wp_postmeta` VALUES("2522", "766", "type", "album");
INSERT INTO `wp_postmeta` VALUES("2523", "766", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2524", "766", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2525", "766", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2526", "766", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2527", "766", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2528", "766", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2529", "766", "thumbnail_pos_y", "50");
INSERT INTO `wp_postmeta` VALUES("2530", "766", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2531", "766", "post-count-all", "12380");
INSERT INTO `wp_postmeta` VALUES("2532", "766", "post-count-week-202045", "2");
INSERT INTO `wp_postmeta` VALUES("2533", "766", "post-count-month-202011", "4");
INSERT INTO `wp_postmeta` VALUES("2534", "766", "post-count-year-2020", "8");
INSERT INTO `wp_postmeta` VALUES("2535", "766", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2536", "766", "like_user", "a:2:{i:0;i:1;i:1;i:46;}");
INSERT INTO `wp_postmeta` VALUES("2537", "766", "post-count-week-202046", "2");
INSERT INTO `wp_postmeta` VALUES("2538", "766", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2539", "766", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2540", "766", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2541", "766", "editor_note", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.");
INSERT INTO `wp_postmeta` VALUES("2542", "766", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2546", "766", "post-count-week-202050", "2");
INSERT INTO `wp_postmeta` VALUES("2547", "766", "post-count-month-202012", "4");
INSERT INTO `wp_postmeta` VALUES("2548", "766", "post-count-week-202051", "1");
INSERT INTO `wp_postmeta` VALUES("2549", "766", "post-count-week-202052", "1");
INSERT INTO `wp_postmeta` VALUES("2550", "766", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2551", "766", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2552", "766", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2553", "1185", "_thumbnail_id", "699");
INSERT INTO `wp_postmeta` VALUES("2554", "1185", "type", "single");
INSERT INTO `wp_postmeta` VALUES("2555", "1185", "post", "");
INSERT INTO `wp_postmeta` VALUES("2556", "1185", "stream", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2022/01/Majid-Razavi-Negine-Ghalbami-320.mp3");
INSERT INTO `wp_postmeta` VALUES("2557", "1185", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2558", "1185", "waveform_data", "a:200:{i:0;i:28;i:1;i:11;i:2;i:31;i:3;i:26;i:4;i:41;i:5;i:39;i:6;i:29;i:7;i:36;i:8;i:32;i:9;i:36;i:10;i:18;i:11;i:18;i:12;i:14;i:13;i:14;i:14;i:13;i:15;i:23;i:16;i:31;i:17;i:18;i:18;i:44;i:19;i:32;i:20;i:25;i:21;i:30;i:22;i:24;i:23;i:17;i:24;i:14;i:25;i:10;i:26;i:18;i:27;i:12;i:28;i:16;i:29;i:6;i:30;i:10;i:31;i:37;i:32;i:32;i:33;i:28;i:34;i:28;i:35;i:49;i:36;i:27;i:37;i:16;i:38;i:28;i:39;i:31;i:40;i:20;i:41;i:27;i:42;i:44;i:43;i:26;i:44;i:29;i:45;i:17;i:46;i:46;i:47;i:30;i:48;i:18;i:49;i:19;i:50;i:20;i:51;i:40;i:52;i:29;i:53;i:6;i:54;i:17;i:55;i:24;i:56;i:23;i:57;i:11;i:58;i:25;i:59;i:21;i:60;i:31;i:61;i:18;i:62;i:10;i:63;i:25;i:64;i:38;i:65;i:16;i:66;i:19;i:67;i:31;i:68;i:20;i:69;i:24;i:70;i:27;i:71;i:26;i:72;i:30;i:73;i:10;i:74;i:21;i:75;i:40;i:76;i:30;i:77;i:17;i:78;i:31;i:79;i:36;i:80;i:25;i:81;i:14;i:82;i:20;i:83;i:44;i:84;i:27;i:85;i:21;i:86;i:24;i:87;i:24;i:88;i:34;i:89;i:16;i:90;i:13;i:91;i:29;i:92;i:22;i:93;i:18;i:94;i:8;i:95;i:32;i:96;i:38;i:97;i:29;i:98;i:27;i:99;i:28;i:100;i:42;i:101;i:28;i:102;i:30;i:103;i:29;i:104;i:34;i:105;i:19;i:106;i:20;i:107;i:33;i:108;i:30;i:109;i:40;i:110;i:13;i:111;i:29;i:112;i:23;i:113;i:17;i:114;i:24;i:115;i:30;i:116;i:38;i:117;i:21;i:118;i:23;i:119;i:26;i:120;i:29;i:121;i:20;i:122;i:13;i:123;i:28;i:124;i:14;i:125;i:16;i:126;i:7;i:127;i:23;i:128;i:24;i:129;i:40;i:130;i:26;i:131;i:23;i:132;i:36;i:133;i:18;i:134;i:14;i:135;i:23;i:136;i:25;i:137;i:32;i:138;i:17;i:139;i:20;i:140;i:20;i:141;i:37;i:142;i:15;i:143;i:36;i:144;i:19;i:145;i:22;i:146;i:18;i:147;i:31;i:148;i:36;i:149;i:29;i:150;i:22;i:151;i:21;i:152;i:17;i:153;i:10;i:154;i:18;i:155;i:19;i:156;i:27;i:157;i:26;i:158;i:19;i:159;i:17;i:160;i:49;i:161;i:24;i:162;i:26;i:163;i:33;i:164;i:38;i:165;i:33;i:166;i:33;i:167;i:27;i:168;i:51;i:169;i:46;i:170;i:39;i:171;i:41;i:172;i:31;i:173;i:28;i:174;i:37;i:175;i:20;i:176;i:40;i:177;i:49;i:178;i:27;i:179;i:26;i:180;i:47;i:181;i:23;i:182;i:35;i:183;i:27;i:184;i:36;i:185;i:40;i:186;i:45;i:187;i:26;i:188;i:39;i:189;i:32;i:190;i:33;i:191;i:34;i:192;i:29;i:193;i:50;i:194;i:41;i:195;i:40;i:196;i:46;i:197;i:32;i:198;i:39;i:199;i:31;}");
INSERT INTO `wp_postmeta` VALUES("2559", "1185", "duration", "29929");
INSERT INTO `wp_postmeta` VALUES("2560", "1185", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2561", "1185", "downloadable", "1");
INSERT INTO `wp_postmeta` VALUES("2562", "1185", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2563", "1185", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2564", "1185", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2565", "1185", "post-count-all", "332");
INSERT INTO `wp_postmeta` VALUES("2566", "1185", "like_count", "8");
INSERT INTO `wp_postmeta` VALUES("2567", "1185", "download_count", "70");
INSERT INTO `wp_postmeta` VALUES("2568", "1185", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2569", "1185", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2570", "1185", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2571", "1185", "post-count-week-202046", "3");
INSERT INTO `wp_postmeta` VALUES("2572", "1185", "post-count-month-202011", "12");
INSERT INTO `wp_postmeta` VALUES("2573", "1185", "post-count-year-2020", "86");
INSERT INTO `wp_postmeta` VALUES("2574", "1185", "like_user", "a:9:{i:0;i:1;i:1;i:10;i:2;i:12;i:3;i:20;i:4;i:25;i:5;i:38;i:6;i:56;i:7;i:64;i:8;i:65;}");
INSERT INTO `wp_postmeta` VALUES("2578", "1185", "post-count-week-202047", "8");
INSERT INTO `wp_postmeta` VALUES("2579", "1185", "post-count-week-202048", "1");
INSERT INTO `wp_postmeta` VALUES("2580", "1185", "post-count-week-202049", "2");
INSERT INTO `wp_postmeta` VALUES("2581", "1185", "post-count-month-202012", "74");
INSERT INTO `wp_postmeta` VALUES("2582", "1185", "post-count-week-202050", "53");
INSERT INTO `wp_postmeta` VALUES("2583", "1185", "post-count-week-202051", "11");
INSERT INTO `wp_postmeta` VALUES("2584", "1185", "post-count-week-202052", "6");
INSERT INTO `wp_postmeta` VALUES("2585", "1185", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("2586", "1185", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2587", "1185", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2588", "1185", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2589", "1206", "_thumbnail_id", "711");
INSERT INTO `wp_postmeta` VALUES("2590", "1206", "post", "148,480,1185,227,237,172,180,174,157,159,178,176,146,194,203,613,200,186,156,169,242,190,192,188,198,145,155,196");
INSERT INTO `wp_postmeta` VALUES("2591", "1206", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("2592", "1206", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2593", "1206", "post-count-all", "1666");
INSERT INTO `wp_postmeta` VALUES("2594", "1206", "post-count-week-202050", "4");
INSERT INTO `wp_postmeta` VALUES("2595", "1206", "post-count-month-202012", "62");
INSERT INTO `wp_postmeta` VALUES("2596", "1206", "post-count-year-2020", "62");
INSERT INTO `wp_postmeta` VALUES("2597", "1206", "stream", "");
INSERT INTO `wp_postmeta` VALUES("2598", "1206", "stream_url", "");
INSERT INTO `wp_postmeta` VALUES("2599", "1206", "duration", "0");
INSERT INTO `wp_postmeta` VALUES("2600", "1206", "artwork_url", "");
INSERT INTO `wp_postmeta` VALUES("2601", "1206", "downloadable", "");
INSERT INTO `wp_postmeta` VALUES("2602", "1206", "download_url", "");
INSERT INTO `wp_postmeta` VALUES("2603", "1206", "purchase_title", "");
INSERT INTO `wp_postmeta` VALUES("2604", "1206", "purchase_url", "");
INSERT INTO `wp_postmeta` VALUES("2605", "1206", "like_count", "2");
INSERT INTO `wp_postmeta` VALUES("2606", "1206", "download_count", "0");
INSERT INTO `wp_postmeta` VALUES("2607", "1206", "editor_note", "");
INSERT INTO `wp_postmeta` VALUES("2608", "1206", "copyright", "");
INSERT INTO `wp_postmeta` VALUES("2612", "1206", "like_user", "a:2:{i:0;i:1;i:1;i:65;}");
INSERT INTO `wp_postmeta` VALUES("2613", "1206", "post-count-week-202051", "16");
INSERT INTO `wp_postmeta` VALUES("2614", "1206", "post-count-week-202052", "40");
INSERT INTO `wp_postmeta` VALUES("2615", "1206", "post-count-week-202053", "2");
INSERT INTO `wp_postmeta` VALUES("2616", "1206", "post-count-week-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2617", "1206", "post-count-month-202101", "1");
INSERT INTO `wp_postmeta` VALUES("2618", "1206", "post-count-year-2021", "1");
INSERT INTO `wp_postmeta` VALUES("2619", "867", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2623", "926", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2624", "926", "footer", "");
INSERT INTO `wp_postmeta` VALUES("2625", "926", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("2626", "926", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("2627", "1095", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2631", "1096", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2635", "1553", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2636", "1553", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2637", "1553", "_menu_item_object_id", "15");
INSERT INTO `wp_postmeta` VALUES("2638", "1553", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2639", "1553", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2640", "1553", "_menu_item_classes", "a:1:{i:0;s:9:\"icon-grid\";}");
INSERT INTO `wp_postmeta` VALUES("2641", "1553", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2642", "1553", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2643", "1554", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2644", "1554", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2645", "1554", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("2646", "1554", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2647", "1554", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2648", "1554", "_menu_item_classes", "a:1:{i:0;s:16:\"icon-trending-up\";}");
INSERT INTO `wp_postmeta` VALUES("2649", "1554", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2650", "1554", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2651", "1555", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2652", "1555", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2653", "1555", "_menu_item_object_id", "11");
INSERT INTO `wp_postmeta` VALUES("2654", "1555", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2655", "1555", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2656", "1555", "_menu_item_classes", "a:1:{i:0;s:9:\"icon-disc\";}");
INSERT INTO `wp_postmeta` VALUES("2657", "1555", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2658", "1555", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2659", "1556", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2660", "1556", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2661", "1556", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("2662", "1556", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2663", "1556", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2664", "1556", "_menu_item_classes", "a:1:{i:0;s:10:\"icon-music\";}");
INSERT INTO `wp_postmeta` VALUES("2665", "1556", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2666", "1556", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2667", "1557", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2668", "1557", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2669", "1557", "_menu_item_object_id", "48");
INSERT INTO `wp_postmeta` VALUES("2670", "1557", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2671", "1557", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2672", "1557", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2673", "1557", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2674", "1557", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2675", "1558", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2676", "1558", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2677", "1558", "_menu_item_object_id", "48");
INSERT INTO `wp_postmeta` VALUES("2678", "1558", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2679", "1558", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2680", "1558", "_menu_item_classes", "a:2:{i:0;s:9:\"icon-user\";i:1;s:8:\"btn-link\";}");
INSERT INTO `wp_postmeta` VALUES("2681", "1558", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2682", "1558", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2683", "1559", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2684", "1559", "_menu_item_menu_item_parent", "1556");
INSERT INTO `wp_postmeta` VALUES("2685", "1559", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("2686", "1559", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2687", "1559", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2688", "1559", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2689", "1559", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2690", "1559", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2691", "1560", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2692", "1560", "_menu_item_menu_item_parent", "1556");
INSERT INTO `wp_postmeta` VALUES("2693", "1560", "_menu_item_object_id", "17");
INSERT INTO `wp_postmeta` VALUES("2694", "1560", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2695", "1560", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2696", "1560", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2697", "1560", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2698", "1560", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2699", "1561", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2700", "1561", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2701", "1561", "_menu_item_object_id", "326");
INSERT INTO `wp_postmeta` VALUES("2702", "1561", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2703", "1561", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2704", "1561", "_menu_item_classes", "a:2:{i:0;s:16:\"icon-filter-list\";i:1;s:16:\"hide-menu-folded\";}");
INSERT INTO `wp_postmeta` VALUES("2705", "1561", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2706", "1561", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2707", "1562", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2708", "1562", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2709", "1562", "_menu_item_object_id", "222");
INSERT INTO `wp_postmeta` VALUES("2710", "1562", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2711", "1562", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2712", "1562", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2713", "1562", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2714", "1562", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2715", "1563", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2716", "1563", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2717", "1563", "_menu_item_object_id", "204");
INSERT INTO `wp_postmeta` VALUES("2718", "1563", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2719", "1563", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2720", "1563", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2721", "1563", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2722", "1563", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2723", "1564", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2724", "1564", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2725", "1564", "_menu_item_object_id", "476");
INSERT INTO `wp_postmeta` VALUES("2726", "1564", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2727", "1564", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2728", "1564", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2729", "1564", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2730", "1564", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2731", "1565", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2732", "1565", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2733", "1565", "_menu_item_object_id", "477");
INSERT INTO `wp_postmeta` VALUES("2734", "1565", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2735", "1565", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2736", "1565", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2737", "1565", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2738", "1565", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2739", "1566", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2740", "1566", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2741", "1566", "_menu_item_object_id", "613");
INSERT INTO `wp_postmeta` VALUES("2742", "1566", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2743", "1566", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2744", "1566", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2745", "1566", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2746", "1566", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2747", "1567", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2748", "1567", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2749", "1567", "_menu_item_object_id", "666");
INSERT INTO `wp_postmeta` VALUES("2750", "1567", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2751", "1567", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2752", "1567", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2753", "1567", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2754", "1567", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2755", "1568", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2756", "1568", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2757", "1568", "_menu_item_object_id", "480");
INSERT INTO `wp_postmeta` VALUES("2758", "1568", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2759", "1568", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2760", "1568", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2761", "1568", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2762", "1568", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2763", "1569", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2764", "1569", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2765", "1569", "_menu_item_object_id", "469");
INSERT INTO `wp_postmeta` VALUES("2766", "1569", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2767", "1569", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2768", "1569", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2769", "1569", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2770", "1569", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2771", "1570", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2772", "1570", "_menu_item_menu_item_parent", "1541");
INSERT INTO `wp_postmeta` VALUES("2773", "1570", "_menu_item_object_id", "182");
INSERT INTO `wp_postmeta` VALUES("2774", "1570", "_menu_item_object", "station");
INSERT INTO `wp_postmeta` VALUES("2775", "1570", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2776", "1570", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2777", "1570", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2778", "1570", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2779", "1571", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2780", "1571", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2781", "1571", "_menu_item_object_id", "130");
INSERT INTO `wp_postmeta` VALUES("2782", "1571", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2783", "1571", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2784", "1571", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2785", "1571", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2786", "1571", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2787", "1572", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2788", "1572", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2789", "1572", "_menu_item_object_id", "132");
INSERT INTO `wp_postmeta` VALUES("2790", "1572", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2791", "1572", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2792", "1572", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2793", "1572", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2794", "1572", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2795", "1573", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2796", "1573", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2797", "1573", "_menu_item_object_id", "49");
INSERT INTO `wp_postmeta` VALUES("2798", "1573", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2799", "1573", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2800", "1573", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2801", "1573", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2802", "1573", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2803", "1574", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2804", "1574", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2805", "1574", "_menu_item_object_id", "741");
INSERT INTO `wp_postmeta` VALUES("2806", "1574", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2807", "1574", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2808", "1574", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2809", "1574", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2810", "1574", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2811", "1575", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2812", "1575", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2813", "1575", "_menu_item_object_id", "758");
INSERT INTO `wp_postmeta` VALUES("2814", "1575", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2815", "1575", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2816", "1575", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2817", "1575", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2818", "1575", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2819", "1576", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2820", "1576", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2821", "1576", "_menu_item_object_id", "756");
INSERT INTO `wp_postmeta` VALUES("2822", "1576", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2823", "1576", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2824", "1576", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2825", "1576", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2826", "1576", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2827", "1577", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2828", "1577", "_menu_item_menu_item_parent", "1540");
INSERT INTO `wp_postmeta` VALUES("2829", "1577", "_menu_item_object_id", "754");
INSERT INTO `wp_postmeta` VALUES("2830", "1577", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2831", "1577", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2832", "1577", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2833", "1577", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2834", "1577", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2835", "1578", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2836", "1578", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2837", "1578", "_menu_item_object_id", "776");
INSERT INTO `wp_postmeta` VALUES("2838", "1578", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2839", "1578", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2840", "1578", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2841", "1578", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2842", "1578", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2843", "1579", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2844", "1579", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2845", "1579", "_menu_item_object_id", "772");
INSERT INTO `wp_postmeta` VALUES("2846", "1579", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2847", "1579", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2848", "1579", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2849", "1579", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2850", "1579", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2851", "1580", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2852", "1580", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2853", "1580", "_menu_item_object_id", "767");
INSERT INTO `wp_postmeta` VALUES("2854", "1580", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2855", "1580", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2856", "1580", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2857", "1580", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2858", "1580", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2859", "1581", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2860", "1581", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("2861", "1581", "_menu_item_object_id", "19");
INSERT INTO `wp_postmeta` VALUES("2862", "1581", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2863", "1581", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2864", "1581", "_menu_item_classes", "a:1:{i:0;s:10:\"icon-radio\";}");
INSERT INTO `wp_postmeta` VALUES("2865", "1581", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2866", "1581", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2867", "1582", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2868", "1582", "_menu_item_menu_item_parent", "1556");
INSERT INTO `wp_postmeta` VALUES("2869", "1582", "_menu_item_object_id", "23");
INSERT INTO `wp_postmeta` VALUES("2870", "1582", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2871", "1582", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2872", "1582", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2873", "1582", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2874", "1582", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2875", "1583", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2876", "1583", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2877", "1583", "_menu_item_object_id", "924");
INSERT INTO `wp_postmeta` VALUES("2878", "1583", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2879", "1583", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2880", "1583", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2881", "1583", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2882", "1583", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2883", "1584", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2884", "1584", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2885", "1584", "_menu_item_object_id", "1024");
INSERT INTO `wp_postmeta` VALUES("2886", "1584", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2887", "1584", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2888", "1584", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2889", "1584", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2890", "1584", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2891", "1585", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("2892", "1585", "_menu_item_menu_item_parent", "1542");
INSERT INTO `wp_postmeta` VALUES("2893", "1585", "_menu_item_object_id", "1123");
INSERT INTO `wp_postmeta` VALUES("2894", "1585", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("2895", "1585", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("2896", "1585", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("2897", "1585", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("2898", "1585", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("2909", "1590", "_wp_attached_file", "2022/01/logo-sv.png");
INSERT INTO `wp_postmeta` VALUES("2910", "1590", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:40;s:6:\"height\";i:36;s:4:\"file\";s:19:\"2022/01/logo-sv.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2913", "1206", "_edit_lock", "1685715235:1");
INSERT INTO `wp_postmeta` VALUES("2917", "1206", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("2918", "1206", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("2919", "1206", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("2920", "1206", "post-count-week-202252", "3");
INSERT INTO `wp_postmeta` VALUES("2921", "1206", "post-count-month-202201", "66");
INSERT INTO `wp_postmeta` VALUES("2922", "1206", "post-count-year-2022", "153");
INSERT INTO `wp_postmeta` VALUES("2923", "148", "_edit_lock", "1641075306:1");
INSERT INTO `wp_postmeta` VALUES("2924", "1593", "_wp_attached_file", "2022/01/Majid-Razavi-Negine-Ghalbami-320.mp3");
INSERT INTO `wp_postmeta` VALUES("2925", "1594", "_wp_attached_file", "2022/01/Majid-Razavi-Negine-Ghalbami-320-mp3-image.jpg");
INSERT INTO `wp_postmeta` VALUES("2926", "1594", "_cover_hash", "0a9e408999278ab21d642c942d58655a");
INSERT INTO `wp_postmeta` VALUES("2927", "1594", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:54:\"2022/01/Majid-Razavi-Negine-Ghalbami-320-mp3-image.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:54:\"Majid-Razavi-Negine-Ghalbami-320-mp3-image-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:54:\"Majid-Razavi-Negine-Ghalbami-320-mp3-image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2928", "1593", "_thumbnail_id", "1594");
INSERT INTO `wp_postmeta` VALUES("2929", "1593", "_wp_attachment_metadata", "a:23:{s:10:\"dataformat\";s:3:\"mp3\";s:8:\"channels\";i:2;s:11:\"sample_rate\";i:44100;s:7:\"bitrate\";i:320000;s:11:\"channelmode\";s:12:\"joint stereo\";s:12:\"bitrate_mode\";s:3:\"cbr\";s:5:\"codec\";s:4:\"LAME\";s:7:\"encoder\";s:9:\"LAME3.100\";s:8:\"lossless\";b:0;s:15:\"encoder_options\";s:15:\"--preset insane\";s:17:\"compression_ratio\";d:0.226757369614512482858259545537293888628482818603515625;s:10:\"fileformat\";s:3:\"mp3\";s:8:\"filesize\";i:7701090;s:9:\"mime_type\";s:10:\"audio/mpeg\";s:6:\"length\";i:184;s:16:\"length_formatted\";s:4:\"3:04\";s:5:\"title\";s:30:\"Negine Ghalbami ~ Music-Fa.Com\";s:6:\"artist\";s:27:\"Majid Razavi ~ Music-Fa.Com\";s:5:\"album\";s:24:\"Negine Ghalbami (Single)\";s:4:\"year\";s:4:\"2021\";s:5:\"genre\";s:4:\"2021\";s:7:\"comment\";s:16:\"[ Music-Fa.Com ]\";s:5:\"image\";a:3:{s:4:\"mime\";s:10:\"image/jpeg\";s:5:\"width\";i:600;s:6:\"height\";i:600;}}");
INSERT INTO `wp_postmeta` VALUES("2934", "148", "_wp_old_slug", "promises__trashed");
INSERT INTO `wp_postmeta` VALUES("2935", "222", "_edit_lock", "1641074871:1");
INSERT INTO `wp_postmeta` VALUES("2939", "11", "_edit_lock", "1685715217:1");
INSERT INTO `wp_postmeta` VALUES("2942", "13", "_edit_lock", "1641045319:1");
INSERT INTO `wp_postmeta` VALUES("2943", "35", "_edit_lock", "1641076510:1");
INSERT INTO `wp_postmeta` VALUES("2944", "1024", "_edit_lock", "1641045971:1");
INSERT INTO `wp_postmeta` VALUES("2975", "1024", "hide_sidenav", "1");
INSERT INTO `wp_postmeta` VALUES("2976", "1024", "footer", "35");
INSERT INTO `wp_postmeta` VALUES("2977", "1024", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("2978", "1024", "add_classes", "hide-search hide-sidenav-icon site-header-transparent");
INSERT INTO `wp_postmeta` VALUES("2979", "1024", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("2980", "1185", "_edit_lock", "1641598653:1");
INSERT INTO `wp_postmeta` VALUES("2981", "480", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("2982", "480", "post-count-month-202201", "10");
INSERT INTO `wp_postmeta` VALUES("2983", "480", "post-count-year-2022", "26");
INSERT INTO `wp_postmeta` VALUES("2984", "1185", "post-count-week-202252", "2");
INSERT INTO `wp_postmeta` VALUES("2985", "1185", "post-count-month-202201", "37");
INSERT INTO `wp_postmeta` VALUES("2986", "1185", "post-count-year-2022", "76");
INSERT INTO `wp_postmeta` VALUES("2987", "227", "post-count-week-202252", "2");
INSERT INTO `wp_postmeta` VALUES("2988", "227", "post-count-month-202201", "4");
INSERT INTO `wp_postmeta` VALUES("2989", "227", "post-count-year-2022", "9");
INSERT INTO `wp_postmeta` VALUES("2990", "237", "post-count-week-202252", "2");
INSERT INTO `wp_postmeta` VALUES("2991", "237", "post-count-month-202201", "5");
INSERT INTO `wp_postmeta` VALUES("2992", "237", "post-count-year-2022", "12");
INSERT INTO `wp_postmeta` VALUES("2993", "1593", "_edit_lock", "1641053323:1");
INSERT INTO `wp_postmeta` VALUES("2994", "148", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("2995", "148", "post-count-month-202201", "70");
INSERT INTO `wp_postmeta` VALUES("2996", "148", "post-count-year-2022", "137");
INSERT INTO `wp_postmeta` VALUES("2997", "172", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("2998", "172", "post-count-month-202201", "9");
INSERT INTO `wp_postmeta` VALUES("2999", "172", "post-count-year-2022", "18");
INSERT INTO `wp_postmeta` VALUES("3000", "180", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3001", "180", "post-count-month-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3002", "180", "post-count-year-2022", "8");
INSERT INTO `wp_postmeta` VALUES("3003", "174", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3004", "174", "post-count-month-202201", "5");
INSERT INTO `wp_postmeta` VALUES("3005", "174", "post-count-year-2022", "13");
INSERT INTO `wp_postmeta` VALUES("3006", "157", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3007", "157", "post-count-month-202201", "3");
INSERT INTO `wp_postmeta` VALUES("3008", "157", "post-count-year-2022", "11");
INSERT INTO `wp_postmeta` VALUES("3009", "159", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3010", "159", "post-count-month-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3011", "159", "post-count-year-2022", "7");
INSERT INTO `wp_postmeta` VALUES("3012", "178", "post-count-week-202252", "2");
INSERT INTO `wp_postmeta` VALUES("3013", "178", "post-count-month-202201", "8");
INSERT INTO `wp_postmeta` VALUES("3014", "178", "post-count-year-2022", "24");
INSERT INTO `wp_postmeta` VALUES("3015", "176", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3016", "176", "post-count-month-202201", "6");
INSERT INTO `wp_postmeta` VALUES("3017", "176", "post-count-year-2022", "18");
INSERT INTO `wp_postmeta` VALUES("3018", "146", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3019", "146", "post-count-month-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3020", "146", "post-count-year-2022", "9");
INSERT INTO `wp_postmeta` VALUES("3021", "194", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3022", "194", "post-count-month-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3023", "194", "post-count-year-2022", "4");
INSERT INTO `wp_postmeta` VALUES("3024", "203", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3025", "203", "post-count-month-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3026", "203", "post-count-year-2022", "4");
INSERT INTO `wp_postmeta` VALUES("3027", "613", "post-count-week-202252", "1");
INSERT INTO `wp_postmeta` VALUES("3028", "613", "post-count-month-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3029", "613", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3030", "766", "post-count-week-202252", "3");
INSERT INTO `wp_postmeta` VALUES("3031", "766", "post-count-month-202201", "11");
INSERT INTO `wp_postmeta` VALUES("3032", "766", "post-count-year-2022", "27");
INSERT INTO `wp_postmeta` VALUES("3033", "10", "_edit_lock", "1641070508:1");
INSERT INTO `wp_postmeta` VALUES("3034", "766", "_edit_lock", "1641074801:1");
INSERT INTO `wp_postmeta` VALUES("3035", "765", "_edit_lock", "1641074793:1");
INSERT INTO `wp_postmeta` VALUES("3036", "204", "_edit_lock", "1641074913:1");
INSERT INTO `wp_postmeta` VALUES("3043", "10", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3044", "10", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3045", "10", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3046", "10", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3047", "12", "_edit_lock", "1641070559:1");
INSERT INTO `wp_postmeta` VALUES("3048", "12", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3049", "12", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3050", "12", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3051", "31", "_edit_lock", "1641070572:1");
INSERT INTO `wp_postmeta` VALUES("3052", "31", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3053", "31", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3054", "31", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3055", "33", "_edit_lock", "1641070575:1");
INSERT INTO `wp_postmeta` VALUES("3056", "130", "_edit_lock", "1641070623:1");
INSERT INTO `wp_postmeta` VALUES("3057", "130", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3058", "130", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3059", "130", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3060", "1123", "_edit_lock", "1641070712:1");
INSERT INTO `wp_postmeta` VALUES("3061", "1123", "hide_sidenav", "1");
INSERT INTO `wp_postmeta` VALUES("3062", "1123", "footer", "35");
INSERT INTO `wp_postmeta` VALUES("3063", "1123", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3064", "1123", "add_classes", "site-header-transparent hide-sidenav-icon hide-search");
INSERT INTO `wp_postmeta` VALUES("3065", "1123", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3066", "1118", "_edit_lock", "1641070741:1");
INSERT INTO `wp_postmeta` VALUES("3067", "1118", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3068", "1118", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3069", "1118", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3076", "132", "_edit_lock", "1641071129:1");
INSERT INTO `wp_postmeta` VALUES("3077", "132", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3078", "132", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3079", "132", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3080", "758", "_edit_lock", "1641071138:1");
INSERT INTO `wp_postmeta` VALUES("3081", "758", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3082", "758", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3083", "758", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3084", "924", "_edit_lock", "1641071546:1");
INSERT INTO `wp_postmeta` VALUES("3085", "924", "hide_sidenav", "1");
INSERT INTO `wp_postmeta` VALUES("3086", "924", "footer", "35");
INSERT INTO `wp_postmeta` VALUES("3087", "924", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3088", "924", "add_classes", "hide-search hide-sidenav-icon site-header-transparent");
INSERT INTO `wp_postmeta` VALUES("3089", "924", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3090", "756", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3091", "756", "_edit_lock", "1641071572:1");
INSERT INTO `wp_postmeta` VALUES("3092", "48", "_edit_lock", "1641071587:1");
INSERT INTO `wp_postmeta` VALUES("3093", "776", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3094", "776", "_edit_lock", "1641071606:1");
INSERT INTO `wp_postmeta` VALUES("3095", "767", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3096", "767", "_edit_lock", "1641071611:1");
INSERT INTO `wp_postmeta` VALUES("3097", "772", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3098", "772", "_edit_lock", "1641071621:1");
INSERT INTO `wp_postmeta` VALUES("3099", "754", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3100", "754", "_edit_lock", "1641071627:1");
INSERT INTO `wp_postmeta` VALUES("3105", "3", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("3106", "3", "_edit_lock", "1641071696:1");
INSERT INTO `wp_postmeta` VALUES("3110", "1547", "_edit_lock", "1641071811:1");
INSERT INTO `wp_postmeta` VALUES("3114", "1547", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3115", "1547", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3116", "1547", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3117", "39", "_edit_lock", "1641071864:1");
INSERT INTO `wp_postmeta` VALUES("3118", "39", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3119", "39", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3120", "39", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3121", "778", "_edit_lock", "1641071921:1");
INSERT INTO `wp_postmeta` VALUES("3122", "778", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3123", "778", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3124", "778", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3125", "741", "_edit_lock", "1641071955:1");
INSERT INTO `wp_postmeta` VALUES("3126", "741", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3127", "741", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3128", "741", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3129", "1168", "_edit_lock", "1641072051:1");
INSERT INTO `wp_postmeta` VALUES("3130", "1168", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3131", "1168", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3132", "1168", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3133", "49", "_edit_lock", "1641072070:1");
INSERT INTO `wp_postmeta` VALUES("3134", "49", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3135", "49", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3136", "49", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3137", "1116", "_edit_lock", "1641072080:1");
INSERT INTO `wp_postmeta` VALUES("3138", "1116", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3139", "1116", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3140", "1116", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3141", "15", "_edit_lock", "1641072133:1");
INSERT INTO `wp_postmeta` VALUES("3142", "15", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3143", "15", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3144", "15", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3145", "15", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3146", "326", "_edit_lock", "1641075840:1");
INSERT INTO `wp_postmeta` VALUES("3151", "17", "_edit_lock", "1641072157:1");
INSERT INTO `wp_postmeta` VALUES("3152", "17", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3153", "17", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3154", "17", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3155", "17", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3156", "21", "_edit_lock", "1641072674:1");
INSERT INTO `wp_postmeta` VALUES("3157", "21", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3158", "21", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3159", "21", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3160", "21", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3161", "19", "_edit_lock", "1641072171:1");
INSERT INTO `wp_postmeta` VALUES("3162", "25", "_edit_lock", "1641072177:1");
INSERT INTO `wp_postmeta` VALUES("3163", "282", "_edit_lock", "1641072180:1");
INSERT INTO `wp_postmeta` VALUES("3164", "23", "_edit_lock", "1641072183:1");
INSERT INTO `wp_postmeta` VALUES("3165", "198", "_edit_lock", "1641075210:1");
INSERT INTO `wp_postmeta` VALUES("3169", "764", "_edit_lock", "1641074768:1");
INSERT INTO `wp_postmeta` VALUES("3170", "763", "_edit_lock", "1641074783:1");
INSERT INTO `wp_postmeta` VALUES("3171", "666", "_edit_lock", "1641074788:1");
INSERT INTO `wp_postmeta` VALUES("3172", "613", "_edit_lock", "1641074801:1");
INSERT INTO `wp_postmeta` VALUES("3173", "611", "_edit_lock", "1641074810:1");
INSERT INTO `wp_postmeta` VALUES("3174", "610", "_edit_lock", "1641074819:1");
INSERT INTO `wp_postmeta` VALUES("3175", "609", "_edit_lock", "1641074827:1");
INSERT INTO `wp_postmeta` VALUES("3176", "476", "_edit_lock", "1641074836:1");
INSERT INTO `wp_postmeta` VALUES("3177", "469", "_edit_lock", "1641074841:1");
INSERT INTO `wp_postmeta` VALUES("3178", "480", "_edit_lock", "1641074825:1");
INSERT INTO `wp_postmeta` VALUES("3179", "237", "_edit_lock", "1641598661:1");
INSERT INTO `wp_postmeta` VALUES("3180", "223", "_edit_lock", "1641074856:1");
INSERT INTO `wp_postmeta` VALUES("3181", "220", "_edit_lock", "1641074878:1");
INSERT INTO `wp_postmeta` VALUES("3182", "218", "_edit_lock", "1641074888:1");
INSERT INTO `wp_postmeta` VALUES("3183", "217", "_edit_lock", "1641074892:1");
INSERT INTO `wp_postmeta` VALUES("3184", "216", "_edit_lock", "1641074900:1");
INSERT INTO `wp_postmeta` VALUES("3185", "215", "_edit_lock", "1641074905:1");
INSERT INTO `wp_postmeta` VALUES("3186", "203", "_edit_lock", "1641075094:1");
INSERT INTO `wp_postmeta` VALUES("3187", "194", "_edit_lock", "1641075135:1");
INSERT INTO `wp_postmeta` VALUES("3188", "290", "_edit_lock", "1641075143:1");
INSERT INTO `wp_postmeta` VALUES("3189", "242", "_edit_lock", "1641075148:1");
INSERT INTO `wp_postmeta` VALUES("3190", "172", "_edit_lock", "1685715867:1");
INSERT INTO `wp_postmeta` VALUES("3191", "174", "_edit_lock", "1641075156:1");
INSERT INTO `wp_postmeta` VALUES("3192", "176", "_edit_lock", "1641075166:1");
INSERT INTO `wp_postmeta` VALUES("3193", "477", "_edit_lock", "1641075348:1");
INSERT INTO `wp_postmeta` VALUES("3194", "145", "_edit_lock", "1641075321:1");
INSERT INTO `wp_postmeta` VALUES("3195", "146", "_edit_lock", "1641075314:1");
INSERT INTO `wp_postmeta` VALUES("3196", "155", "_edit_lock", "1641075347:1");
INSERT INTO `wp_postmeta` VALUES("3197", "156", "_edit_lock", "1641075342:1");
INSERT INTO `wp_postmeta` VALUES("3198", "157", "_edit_lock", "1641075335:1");
INSERT INTO `wp_postmeta` VALUES("3199", "159", "_edit_lock", "1641075215:1");
INSERT INTO `wp_postmeta` VALUES("3200", "169", "_edit_lock", "1641075211:1");
INSERT INTO `wp_postmeta` VALUES("3201", "227", "_edit_lock", "1641075254:1");
INSERT INTO `wp_postmeta` VALUES("3202", "221", "_edit_lock", "1641075248:1");
INSERT INTO `wp_postmeta` VALUES("3203", "200", "_edit_lock", "1641075242:1");
INSERT INTO `wp_postmeta` VALUES("3204", "196", "_edit_lock", "1641075225:1");
INSERT INTO `wp_postmeta` VALUES("3205", "192", "_edit_lock", "1641075207:1");
INSERT INTO `wp_postmeta` VALUES("3206", "190", "_edit_lock", "1641075209:1");
INSERT INTO `wp_postmeta` VALUES("3207", "188", "_edit_lock", "1641075204:1");
INSERT INTO `wp_postmeta` VALUES("3208", "186", "_edit_lock", "1641075194:1");
INSERT INTO `wp_postmeta` VALUES("3209", "182", "_edit_lock", "1641075187:1");
INSERT INTO `wp_postmeta` VALUES("3210", "178", "_edit_lock", "1641075172:1");
INSERT INTO `wp_postmeta` VALUES("3211", "180", "_edit_lock", "1641075188:1");
INSERT INTO `wp_postmeta` VALUES("3212", "1552", "_edit_lock", "1641074585:1");
INSERT INTO `wp_postmeta` VALUES("3213", "420", "_edit_lock", "1641074657:1");
INSERT INTO `wp_postmeta` VALUES("3214", "394", "_edit_lock", "1641074661:1");
INSERT INTO `wp_postmeta` VALUES("3217", "1552", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3218", "1552", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3219", "1552", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3222", "420", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3223", "420", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3224", "420", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3227", "394", "_pingme", "1");
INSERT INTO `wp_postmeta` VALUES("3228", "394", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3229", "394", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3230", "394", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3231", "613", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3232", "613", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3233", "613", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3234", "764", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3235", "764", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3236", "764", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3237", "763", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3238", "763", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3239", "763", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3240", "666", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3241", "666", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3242", "666", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3243", "765", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3244", "765", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3245", "765", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3246", "766", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3247", "766", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3248", "766", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3249", "611", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3250", "611", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3251", "611", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3252", "610", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3253", "610", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3254", "610", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3255", "609", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3256", "609", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3257", "609", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3258", "476", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3259", "476", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3260", "476", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3261", "469", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3262", "469", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3263", "469", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3264", "223", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3265", "223", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3266", "223", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3270", "220", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3271", "220", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3272", "220", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3273", "218", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3274", "218", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3275", "218", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3276", "217", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3277", "217", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3278", "217", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3279", "216", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3280", "216", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3281", "216", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3282", "215", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3283", "215", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3284", "215", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3285", "204", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3286", "204", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3287", "204", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3288", "194", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3289", "194", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3290", "194", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3291", "290", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3292", "290", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3293", "290", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3294", "242", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3295", "242", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3296", "242", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3297", "172", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3298", "172", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3299", "172", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3300", "176", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3301", "176", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3302", "176", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3303", "178", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3304", "178", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3305", "178", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3306", "180", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3307", "180", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3308", "180", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3309", "188", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3310", "188", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3311", "188", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3312", "190", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3313", "190", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3314", "190", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3315", "196", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3316", "196", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3317", "196", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3318", "200", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3319", "200", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3320", "200", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3321", "221", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3322", "221", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3323", "221", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3324", "227", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3325", "227", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3326", "227", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3327", "157", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3328", "157", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3329", "157", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3330", "156", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3331", "156", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3332", "156", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3333", "155", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3334", "155", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3335", "155", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3336", "148", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3337", "148", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3338", "148", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3339", "146", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3340", "146", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3341", "146", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3342", "145", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3343", "145", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3344", "145", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3345", "477", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3346", "477", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3347", "477", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3348", "1549", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3349", "1555", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3350", "1556", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3351", "1560", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3352", "1559", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3353", "1582", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3354", "1553", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3355", "1561", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3356", "1554", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3357", "1581", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3358", "1535", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3359", "703", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3360", "1533", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3361", "1534", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3362", "1536", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3363", "1537", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3369", "326", "hide_title", "1");
INSERT INTO `wp_postmeta` VALUES("3370", "326", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3371", "326", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3372", "326", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3379", "35", "footer", "0");
INSERT INTO `wp_postmeta` VALUES("3380", "35", "sidebar", "0");
INSERT INTO `wp_postmeta` VALUES("3381", "35", "add_classes", "");
INSERT INTO `wp_postmeta` VALUES("3382", "1675", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("3383", "1675", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("3384", "1675", "_menu_item_object_id", "1675");
INSERT INTO `wp_postmeta` VALUES("3385", "1675", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("3386", "1675", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("3387", "1675", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("3388", "1675", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("3389", "1675", "_menu_item_url", "http://%theme-switch%");
INSERT INTO `wp_postmeta` VALUES("3391", "1539", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3392", "1540", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3393", "1572", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3394", "1573", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3395", "1571", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3396", "1574", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3397", "1577", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3398", "1576", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3399", "1575", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3400", "1541", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3401", "1570", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3402", "1569", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3403", "1567", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3404", "1564", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3405", "1565", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3406", "1566", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3407", "1562", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3408", "1563", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3409", "1542", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3410", "1580", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3411", "1579", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3412", "1578", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3413", "1568", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3414", "1583", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3415", "1584", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3416", "1550", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3417", "1585", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3418", "1538", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3419", "1543", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3420", "1551", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3421", "1548", "_wp_old_date", "2022-01-01");
INSERT INTO `wp_postmeta` VALUES("3422", "159", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3423", "1206", "post-count-week-202201", "39");
INSERT INTO `wp_postmeta` VALUES("3424", "148", "post-count-week-202201", "28");
INSERT INTO `wp_postmeta` VALUES("3425", "145", "post-count-week-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3426", "145", "post-count-month-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3427", "145", "post-count-year-2022", "9");
INSERT INTO `wp_postmeta` VALUES("3428", "765", "post-count-week-202201", "17");
INSERT INTO `wp_postmeta` VALUES("3429", "765", "post-count-month-202201", "27");
INSERT INTO `wp_postmeta` VALUES("3430", "765", "post-count-year-2022", "54");
INSERT INTO `wp_postmeta` VALUES("3431", "764", "post-count-week-202201", "7");
INSERT INTO `wp_postmeta` VALUES("3432", "764", "post-count-month-202201", "12");
INSERT INTO `wp_postmeta` VALUES("3433", "764", "post-count-year-2022", "36");
INSERT INTO `wp_postmeta` VALUES("3434", "469", "post-count-week-202201", "6");
INSERT INTO `wp_postmeta` VALUES("3435", "469", "post-count-month-202201", "12");
INSERT INTO `wp_postmeta` VALUES("3436", "469", "post-count-year-2022", "24");
INSERT INTO `wp_postmeta` VALUES("3437", "1185", "post-count-week-202201", "13");
INSERT INTO `wp_postmeta` VALUES("3438", "178", "post-count-week-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3439", "763", "post-count-week-202201", "8");
INSERT INTO `wp_postmeta` VALUES("3440", "763", "post-count-month-202201", "12");
INSERT INTO `wp_postmeta` VALUES("3441", "763", "post-count-year-2022", "24");
INSERT INTO `wp_postmeta` VALUES("3442", "611", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3443", "611", "post-count-month-202201", "3");
INSERT INTO `wp_postmeta` VALUES("3444", "611", "post-count-year-2022", "5");
INSERT INTO `wp_postmeta` VALUES("3445", "176", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3446", "188", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3447", "188", "post-count-month-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3448", "188", "post-count-year-2022", "2");
INSERT INTO `wp_postmeta` VALUES("3449", "222", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3450", "222", "post-count-month-202201", "5");
INSERT INTO `wp_postmeta` VALUES("3451", "222", "post-count-year-2022", "8");
INSERT INTO `wp_postmeta` VALUES("3452", "169", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3453", "169", "post-count-month-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3454", "169", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3455", "172", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3456", "182", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3457", "182", "post-count-month-202201", "3");
INSERT INTO `wp_postmeta` VALUES("3458", "182", "post-count-year-2022", "7");
INSERT INTO `wp_postmeta` VALUES("3459", "610", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3460", "610", "post-count-month-202201", "4");
INSERT INTO `wp_postmeta` VALUES("3461", "610", "post-count-year-2022", "5");
INSERT INTO `wp_postmeta` VALUES("3462", "204", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3463", "204", "post-count-month-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3464", "204", "post-count-year-2022", "2");
INSERT INTO `wp_postmeta` VALUES("3465", "290", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3466", "290", "post-count-month-202201", "5");
INSERT INTO `wp_postmeta` VALUES("3467", "290", "post-count-year-2022", "13");
INSERT INTO `wp_postmeta` VALUES("3468", "476", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3469", "476", "post-count-month-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3470", "476", "post-count-year-2022", "4");
INSERT INTO `wp_postmeta` VALUES("3471", "766", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3472", "666", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3473", "666", "post-count-month-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3474", "666", "post-count-year-2022", "5");
INSERT INTO `wp_postmeta` VALUES("3475", "480", "post-count-week-202201", "1");
INSERT INTO `wp_postmeta` VALUES("3476", "223", "post-count-week-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3477", "223", "post-count-month-202201", "2");
INSERT INTO `wp_postmeta` VALUES("3478", "223", "post-count-year-2022", "6");
INSERT INTO `wp_postmeta` VALUES("3479", "609", "post-count-week-202201", "3");
INSERT INTO `wp_postmeta` VALUES("3480", "609", "post-count-month-202201", "3");
INSERT INTO `wp_postmeta` VALUES("3481", "609", "post-count-year-2022", "6");
INSERT INTO `wp_postmeta` VALUES("3482", "469", "post-count-week-202202", "5");
INSERT INTO `wp_postmeta` VALUES("3483", "148", "post-count-week-202202", "38");
INSERT INTO `wp_postmeta` VALUES("3484", "765", "post-count-week-202202", "6");
INSERT INTO `wp_postmeta` VALUES("3485", "290", "post-count-week-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3486", "222", "post-count-week-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3487", "1206", "post-count-week-202202", "20");
INSERT INTO `wp_postmeta` VALUES("3488", "480", "post-count-week-202202", "7");
INSERT INTO `wp_postmeta` VALUES("3489", "1185", "post-count-week-202202", "18");
INSERT INTO `wp_postmeta` VALUES("3490", "182", "post-count-week-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3491", "764", "post-count-week-202202", "4");
INSERT INTO `wp_postmeta` VALUES("3492", "763", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3493", "172", "post-count-week-202202", "6");
INSERT INTO `wp_postmeta` VALUES("3494", "178", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3495", "174", "post-count-week-202202", "4");
INSERT INTO `wp_postmeta` VALUES("3496", "227", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3497", "237", "post-count-week-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3498", "180", "post-count-week-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3499", "157", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3500", "159", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3501", "176", "post-count-week-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3502", "146", "post-count-week-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3503", "766", "post-count-week-202202", "6");
INSERT INTO `wp_postmeta` VALUES("3504", "610", "post-count-week-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3505", "765", "post-count-week-202203", "4");
INSERT INTO `wp_postmeta` VALUES("3506", "1206", "post-count-week-202203", "4");
INSERT INTO `wp_postmeta` VALUES("3507", "764", "post-count-week-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3508", "148", "post-count-week-202203", "3");
INSERT INTO `wp_postmeta` VALUES("3509", "480", "post-count-week-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3510", "1185", "post-count-week-202203", "3");
INSERT INTO `wp_postmeta` VALUES("3511", "611", "post-count-week-202203", "2");
INSERT INTO `wp_postmeta` VALUES("3512", "469", "post-count-week-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3513", "763", "post-count-week-202203", "2");
INSERT INTO `wp_postmeta` VALUES("3514", "172", "post-count-week-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3515", "1185", "post-count-week-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3516", "176", "post-count-week-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3517", "178", "post-count-week-202205", "2");
INSERT INTO `wp_postmeta` VALUES("3518", "178", "post-count-month-202202", "6");
INSERT INTO `wp_postmeta` VALUES("3519", "1206", "post-count-week-202205", "4");
INSERT INTO `wp_postmeta` VALUES("3520", "1206", "post-count-month-202202", "11");
INSERT INTO `wp_postmeta` VALUES("3521", "148", "post-count-week-202205", "6");
INSERT INTO `wp_postmeta` VALUES("3522", "148", "post-count-month-202202", "20");
INSERT INTO `wp_postmeta` VALUES("3523", "480", "post-count-week-202205", "5");
INSERT INTO `wp_postmeta` VALUES("3524", "480", "post-count-month-202202", "9");
INSERT INTO `wp_postmeta` VALUES("3525", "1185", "post-count-week-202205", "5");
INSERT INTO `wp_postmeta` VALUES("3526", "1185", "post-count-month-202202", "11");
INSERT INTO `wp_postmeta` VALUES("3527", "227", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3528", "227", "post-count-month-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3529", "237", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3530", "237", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3531", "172", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3532", "172", "post-count-month-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3533", "180", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3534", "180", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3535", "174", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3536", "174", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3537", "157", "post-count-week-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3538", "157", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3539", "148", "post-count-week-202206", "6");
INSERT INTO `wp_postmeta` VALUES("3540", "178", "post-count-week-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3541", "145", "post-count-week-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3542", "145", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3543", "1185", "post-count-week-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3544", "227", "post-count-week-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3545", "237", "post-count-week-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3546", "182", "post-count-week-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3547", "182", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3548", "1206", "post-count-week-202207", "7");
INSERT INTO `wp_postmeta` VALUES("3549", "764", "post-count-week-202207", "5");
INSERT INTO `wp_postmeta` VALUES("3550", "764", "post-count-month-202202", "5");
INSERT INTO `wp_postmeta` VALUES("3551", "176", "post-count-week-202207", "4");
INSERT INTO `wp_postmeta` VALUES("3552", "176", "post-count-month-202202", "4");
INSERT INTO `wp_postmeta` VALUES("3553", "480", "post-count-week-202207", "4");
INSERT INTO `wp_postmeta` VALUES("3554", "611", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3555", "611", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3556", "609", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3557", "609", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3558", "218", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3559", "218", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3560", "218", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3561", "172", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3562", "148", "post-count-week-202207", "6");
INSERT INTO `wp_postmeta` VALUES("3563", "1185", "post-count-week-202207", "5");
INSERT INTO `wp_postmeta` VALUES("3564", "227", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3565", "180", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3566", "174", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3567", "157", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3568", "159", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3569", "159", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3570", "178", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3571", "146", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3572", "146", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3573", "194", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3574", "194", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3575", "203", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3576", "203", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3577", "469", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3578", "469", "post-count-month-202202", "3");
INSERT INTO `wp_postmeta` VALUES("3579", "766", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3580", "766", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3581", "763", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3582", "763", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3583", "666", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3584", "666", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3585", "610", "post-count-week-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3586", "610", "post-count-month-202202", "1");
INSERT INTO `wp_postmeta` VALUES("3587", "765", "post-count-week-202207", "2");
INSERT INTO `wp_postmeta` VALUES("3588", "765", "post-count-month-202202", "2");
INSERT INTO `wp_postmeta` VALUES("3589", "469", "post-count-week-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3590", "148", "post-count-week-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3591", "1206", "post-count-week-202209", "1");
INSERT INTO `wp_postmeta` VALUES("3592", "1206", "post-count-month-202203", "11");
INSERT INTO `wp_postmeta` VALUES("3593", "148", "post-count-week-202209", "1");
INSERT INTO `wp_postmeta` VALUES("3594", "148", "post-count-month-202203", "6");
INSERT INTO `wp_postmeta` VALUES("3595", "1206", "post-count-week-202210", "2");
INSERT INTO `wp_postmeta` VALUES("3596", "148", "post-count-week-202210", "2");
INSERT INTO `wp_postmeta` VALUES("3597", "480", "post-count-week-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3598", "480", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3599", "148", "post-count-week-202211", "2");
INSERT INTO `wp_postmeta` VALUES("3600", "1206", "post-count-week-202211", "6");
INSERT INTO `wp_postmeta` VALUES("3601", "764", "post-count-week-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3602", "764", "post-count-month-202203", "2");
INSERT INTO `wp_postmeta` VALUES("3603", "469", "post-count-week-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3604", "469", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3605", "290", "post-count-week-202212", "7");
INSERT INTO `wp_postmeta` VALUES("3606", "290", "post-count-month-202203", "7");
INSERT INTO `wp_postmeta` VALUES("3607", "1206", "post-count-week-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3608", "172", "post-count-week-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3609", "172", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3610", "764", "post-count-week-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3611", "1206", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3612", "766", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3613", "766", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3614", "146", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3615", "146", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3616", "148", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3617", "611", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3618", "611", "post-count-month-202203", "1");
INSERT INTO `wp_postmeta` VALUES("3619", "1185", "post-count-week-202213", "1");
INSERT INTO `wp_postmeta` VALUES("3620", "1185", "post-count-month-202204", "2");
INSERT INTO `wp_postmeta` VALUES("3621", "1206", "post-count-week-202214", "6");
INSERT INTO `wp_postmeta` VALUES("3622", "1206", "post-count-month-202204", "8");
INSERT INTO `wp_postmeta` VALUES("3623", "764", "post-count-week-202214", "2");
INSERT INTO `wp_postmeta` VALUES("3624", "764", "post-count-month-202204", "3");
INSERT INTO `wp_postmeta` VALUES("3625", "192", "post-count-week-202214", "1");
INSERT INTO `wp_postmeta` VALUES("3626", "192", "post-count-month-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3627", "192", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3628", "765", "post-count-week-202214", "3");
INSERT INTO `wp_postmeta` VALUES("3629", "765", "post-count-month-202204", "3");
INSERT INTO `wp_postmeta` VALUES("3630", "766", "post-count-week-202214", "2");
INSERT INTO `wp_postmeta` VALUES("3631", "766", "post-count-month-202204", "3");
INSERT INTO `wp_postmeta` VALUES("3632", "237", "post-count-week-202214", "1");
INSERT INTO `wp_postmeta` VALUES("3633", "237", "post-count-month-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3634", "146", "post-count-week-202214", "1");
INSERT INTO `wp_postmeta` VALUES("3635", "146", "post-count-month-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3636", "148", "post-count-week-202214", "1");
INSERT INTO `wp_postmeta` VALUES("3637", "148", "post-count-month-202204", "2");
INSERT INTO `wp_postmeta` VALUES("3638", "148", "post-count-week-202215", "1");
INSERT INTO `wp_postmeta` VALUES("3639", "766", "post-count-week-202215", "1");
INSERT INTO `wp_postmeta` VALUES("3640", "764", "post-count-week-202216", "1");
INSERT INTO `wp_postmeta` VALUES("3641", "1206", "post-count-week-202216", "2");
INSERT INTO `wp_postmeta` VALUES("3642", "763", "post-count-week-202216", "1");
INSERT INTO `wp_postmeta` VALUES("3643", "763", "post-count-month-202204", "1");
INSERT INTO `wp_postmeta` VALUES("3644", "1185", "post-count-week-202217", "1");
INSERT INTO `wp_postmeta` VALUES("3645", "178", "post-count-week-202217", "1");
INSERT INTO `wp_postmeta` VALUES("3646", "178", "post-count-month-202205", "2");
INSERT INTO `wp_postmeta` VALUES("3647", "480", "post-count-week-202218", "1");
INSERT INTO `wp_postmeta` VALUES("3648", "480", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3649", "766", "post-count-week-202218", "1");
INSERT INTO `wp_postmeta` VALUES("3650", "766", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3651", "157", "post-count-week-202218", "1");
INSERT INTO `wp_postmeta` VALUES("3652", "157", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3653", "1206", "post-count-week-202219", "1");
INSERT INTO `wp_postmeta` VALUES("3654", "1206", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3655", "148", "post-count-week-202219", "1");
INSERT INTO `wp_postmeta` VALUES("3656", "148", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3657", "765", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3658", "765", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3659", "666", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3660", "666", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3661", "764", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3662", "764", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3663", "609", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3664", "609", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3665", "237", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3666", "237", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3667", "174", "post-count-week-202220", "1");
INSERT INTO `wp_postmeta` VALUES("3668", "174", "post-count-month-202205", "1");
INSERT INTO `wp_postmeta` VALUES("3669", "178", "post-count-week-202222", "1");
INSERT INTO `wp_postmeta` VALUES("3670", "1206", "post-count-week-202224", "3");
INSERT INTO `wp_postmeta` VALUES("3671", "1206", "post-count-month-202206", "8");
INSERT INTO `wp_postmeta` VALUES("3672", "1185", "post-count-week-202224", "2");
INSERT INTO `wp_postmeta` VALUES("3673", "1185", "post-count-month-202206", "7");
INSERT INTO `wp_postmeta` VALUES("3674", "765", "post-count-week-202224", "3");
INSERT INTO `wp_postmeta` VALUES("3675", "765", "post-count-month-202206", "7");
INSERT INTO `wp_postmeta` VALUES("3676", "182", "post-count-week-202224", "2");
INSERT INTO `wp_postmeta` VALUES("3677", "182", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3678", "148", "post-count-week-202224", "2");
INSERT INTO `wp_postmeta` VALUES("3679", "148", "post-count-month-202206", "8");
INSERT INTO `wp_postmeta` VALUES("3680", "766", "post-count-week-202224", "1");
INSERT INTO `wp_postmeta` VALUES("3681", "766", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3682", "176", "post-count-week-202224", "1");
INSERT INTO `wp_postmeta` VALUES("3683", "176", "post-count-month-202206", "4");
INSERT INTO `wp_postmeta` VALUES("3684", "764", "post-count-week-202224", "2");
INSERT INTO `wp_postmeta` VALUES("3685", "764", "post-count-month-202206", "4");
INSERT INTO `wp_postmeta` VALUES("3686", "172", "post-count-week-202224", "1");
INSERT INTO `wp_postmeta` VALUES("3687", "172", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3688", "480", "post-count-week-202224", "1");
INSERT INTO `wp_postmeta` VALUES("3689", "480", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3690", "178", "post-count-week-202225", "2");
INSERT INTO `wp_postmeta` VALUES("3691", "178", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3692", "766", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3693", "1676", "_thumbnail_id", "502");
INSERT INTO `wp_postmeta` VALUES("3694", "1676", "post", "480");
INSERT INTO `wp_postmeta` VALUES("3695", "1676", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("3696", "148", "post-count-week-202225", "5");
INSERT INTO `wp_postmeta` VALUES("3697", "145", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3698", "145", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3699", "176", "post-count-week-202225", "3");
INSERT INTO `wp_postmeta` VALUES("3700", "476", "post-count-week-202225", "2");
INSERT INTO `wp_postmeta` VALUES("3701", "476", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3702", "1206", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3703", "480", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3704", "1185", "post-count-week-202225", "2");
INSERT INTO `wp_postmeta` VALUES("3705", "237", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3706", "237", "post-count-month-202206", "2");
INSERT INTO `wp_postmeta` VALUES("3707", "172", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3708", "180", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3709", "180", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3710", "174", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3711", "174", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3712", "157", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3713", "157", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3714", "159", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3715", "159", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3716", "146", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3717", "146", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3718", "194", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3719", "194", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3720", "203", "post-count-week-202225", "1");
INSERT INTO `wp_postmeta` VALUES("3721", "203", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3722", "223", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3723", "223", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3724", "1677", "_thumbnail_id", "543");
INSERT INTO `wp_postmeta` VALUES("3725", "1677", "post", "609");
INSERT INTO `wp_postmeta` VALUES("3726", "1677", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("3727", "763", "post-count-week-202226", "2");
INSERT INTO `wp_postmeta` VALUES("3728", "763", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3729", "222", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3730", "222", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3731", "1206", "post-count-week-202226", "10");
INSERT INTO `wp_postmeta` VALUES("3732", "148", "post-count-week-202226", "4");
INSERT INTO `wp_postmeta` VALUES("3733", "196", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3734", "196", "post-count-month-202206", "1");
INSERT INTO `wp_postmeta` VALUES("3735", "196", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3736", "765", "post-count-week-202226", "5");
INSERT INTO `wp_postmeta` VALUES("3737", "237", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3738", "764", "post-count-week-202226", "2");
INSERT INTO `wp_postmeta` VALUES("3739", "1185", "post-count-week-202226", "5");
INSERT INTO `wp_postmeta` VALUES("3740", "1206", "post-count-month-202207", "7");
INSERT INTO `wp_postmeta` VALUES("3741", "148", "post-count-month-202207", "3");
INSERT INTO `wp_postmeta` VALUES("3742", "469", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3743", "469", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3744", "145", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3745", "145", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3746", "188", "post-count-week-202226", "1");
INSERT INTO `wp_postmeta` VALUES("3747", "188", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3748", "765", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3749", "1185", "post-count-month-202207", "3");
INSERT INTO `wp_postmeta` VALUES("3750", "763", "post-count-month-202207", "3");
INSERT INTO `wp_postmeta` VALUES("3751", "178", "post-count-week-202228", "1");
INSERT INTO `wp_postmeta` VALUES("3752", "178", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3753", "1185", "post-count-week-202228", "1");
INSERT INTO `wp_postmeta` VALUES("3754", "764", "post-count-week-202228", "1");
INSERT INTO `wp_postmeta` VALUES("3755", "764", "post-count-month-202207", "1");
INSERT INTO `wp_postmeta` VALUES("3756", "763", "post-count-week-202228", "2");
INSERT INTO `wp_postmeta` VALUES("3757", "1206", "post-count-week-202230", "1");
INSERT INTO `wp_postmeta` VALUES("3758", "1206", "post-count-week-202231", "5");
INSERT INTO `wp_postmeta` VALUES("3759", "1206", "post-count-month-202208", "6");
INSERT INTO `wp_postmeta` VALUES("3760", "666", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3761", "666", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3762", "148", "post-count-week-202231", "6");
INSERT INTO `wp_postmeta` VALUES("3763", "148", "post-count-month-202208", "6");
INSERT INTO `wp_postmeta` VALUES("3764", "480", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3765", "480", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3766", "1185", "post-count-week-202231", "2");
INSERT INTO `wp_postmeta` VALUES("3767", "1185", "post-count-month-202208", "3");
INSERT INTO `wp_postmeta` VALUES("3768", "227", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3769", "227", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3770", "237", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3771", "237", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3772", "172", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3773", "172", "post-count-month-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3774", "180", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3775", "180", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3776", "174", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3777", "174", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3778", "157", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3779", "157", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3780", "159", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3781", "159", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3782", "178", "post-count-week-202231", "2");
INSERT INTO `wp_postmeta` VALUES("3783", "178", "post-count-month-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3784", "176", "post-count-week-202231", "2");
INSERT INTO `wp_postmeta` VALUES("3785", "176", "post-count-month-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3786", "146", "post-count-week-202231", "2");
INSERT INTO `wp_postmeta` VALUES("3787", "146", "post-count-month-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3788", "194", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3789", "194", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3790", "203", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3791", "203", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3792", "223", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3793", "223", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3794", "469", "post-count-week-202231", "1");
INSERT INTO `wp_postmeta` VALUES("3795", "469", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3796", "172", "post-count-week-202232", "1");
INSERT INTO `wp_postmeta` VALUES("3797", "763", "post-count-week-202233", "1");
INSERT INTO `wp_postmeta` VALUES("3798", "763", "post-count-month-202208", "2");
INSERT INTO `wp_postmeta` VALUES("3799", "1185", "post-count-week-202234", "1");
INSERT INTO `wp_postmeta` VALUES("3800", "763", "post-count-week-202234", "1");
INSERT INTO `wp_postmeta` VALUES("3801", "764", "post-count-week-202234", "1");
INSERT INTO `wp_postmeta` VALUES("3802", "764", "post-count-month-202208", "1");
INSERT INTO `wp_postmeta` VALUES("3803", "1206", "post-count-week-202234", "1");
INSERT INTO `wp_postmeta` VALUES("3804", "223", "post-count-week-202235", "2");
INSERT INTO `wp_postmeta` VALUES("3805", "223", "post-count-month-202209", "2");
INSERT INTO `wp_postmeta` VALUES("3806", "1206", "post-count-week-202235", "1");
INSERT INTO `wp_postmeta` VALUES("3807", "1206", "post-count-month-202209", "7");
INSERT INTO `wp_postmeta` VALUES("3808", "148", "post-count-week-202235", "1");
INSERT INTO `wp_postmeta` VALUES("3809", "148", "post-count-month-202209", "4");
INSERT INTO `wp_postmeta` VALUES("3810", "1206", "post-count-week-202236", "1");
INSERT INTO `wp_postmeta` VALUES("3811", "148", "post-count-week-202236", "1");
INSERT INTO `wp_postmeta` VALUES("3812", "765", "post-count-week-202237", "1");
INSERT INTO `wp_postmeta` VALUES("3813", "765", "post-count-month-202209", "2");
INSERT INTO `wp_postmeta` VALUES("3814", "148", "post-count-week-202238", "2");
INSERT INTO `wp_postmeta` VALUES("3815", "1206", "post-count-week-202238", "5");
INSERT INTO `wp_postmeta` VALUES("3816", "1185", "post-count-week-202238", "2");
INSERT INTO `wp_postmeta` VALUES("3817", "1185", "post-count-month-202209", "2");
INSERT INTO `wp_postmeta` VALUES("3818", "765", "post-count-week-202238", "1");
INSERT INTO `wp_postmeta` VALUES("3819", "182", "post-count-week-202238", "1");
INSERT INTO `wp_postmeta` VALUES("3820", "182", "post-count-month-202209", "1");
INSERT INTO `wp_postmeta` VALUES("3821", "1206", "post-count-week-202239", "1");
INSERT INTO `wp_postmeta` VALUES("3822", "1206", "post-count-month-202210", "4");
INSERT INTO `wp_postmeta` VALUES("3823", "148", "post-count-week-202239", "3");
INSERT INTO `wp_postmeta` VALUES("3824", "148", "post-count-month-202210", "5");
INSERT INTO `wp_postmeta` VALUES("3825", "764", "post-count-week-202240", "2");
INSERT INTO `wp_postmeta` VALUES("3826", "764", "post-count-month-202210", "2");
INSERT INTO `wp_postmeta` VALUES("3827", "1206", "post-count-week-202240", "3");
INSERT INTO `wp_postmeta` VALUES("3828", "469", "post-count-week-202240", "4");
INSERT INTO `wp_postmeta` VALUES("3829", "469", "post-count-month-202210", "4");
INSERT INTO `wp_postmeta` VALUES("3830", "148", "post-count-week-202240", "2");
INSERT INTO `wp_postmeta` VALUES("3831", "765", "post-count-week-202240", "2");
INSERT INTO `wp_postmeta` VALUES("3832", "765", "post-count-month-202210", "3");
INSERT INTO `wp_postmeta` VALUES("3833", "1185", "post-count-week-202240", "2");
INSERT INTO `wp_postmeta` VALUES("3834", "1185", "post-count-month-202210", "5");
INSERT INTO `wp_postmeta` VALUES("3835", "178", "post-count-week-202240", "1");
INSERT INTO `wp_postmeta` VALUES("3836", "178", "post-count-month-202210", "2");
INSERT INTO `wp_postmeta` VALUES("3837", "763", "post-count-week-202241", "1");
INSERT INTO `wp_postmeta` VALUES("3838", "763", "post-count-month-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3839", "222", "post-count-week-202241", "1");
INSERT INTO `wp_postmeta` VALUES("3840", "222", "post-count-month-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3841", "765", "post-count-week-202242", "1");
INSERT INTO `wp_postmeta` VALUES("3842", "290", "post-count-week-202242", "1");
INSERT INTO `wp_postmeta` VALUES("3843", "290", "post-count-month-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3844", "1185", "post-count-week-202242", "1");
INSERT INTO `wp_postmeta` VALUES("3845", "178", "post-count-week-202242", "1");
INSERT INTO `wp_postmeta` VALUES("3846", "1678", "_thumbnail_id", "549");
INSERT INTO `wp_postmeta` VALUES("3847", "1678", "post", "223");
INSERT INTO `wp_postmeta` VALUES("3848", "1678", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("3849", "174", "post-count-week-202243", "1");
INSERT INTO `wp_postmeta` VALUES("3850", "174", "post-count-month-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3851", "1185", "post-count-week-202243", "2");
INSERT INTO `wp_postmeta` VALUES("3852", "1679", "_thumbnail_id", "699");
INSERT INTO `wp_postmeta` VALUES("3853", "1679", "post", "");
INSERT INTO `wp_postmeta` VALUES("3854", "1679", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("3855", "176", "post-count-week-202243", "1");
INSERT INTO `wp_postmeta` VALUES("3856", "176", "post-count-month-202210", "1");
INSERT INTO `wp_postmeta` VALUES("3857", "1206", "post-count-week-202244", "1");
INSERT INTO `wp_postmeta` VALUES("3858", "1206", "post-count-month-202211", "13");
INSERT INTO `wp_postmeta` VALUES("3859", "178", "post-count-week-202246", "1");
INSERT INTO `wp_postmeta` VALUES("3860", "178", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3861", "765", "post-count-week-202246", "1");
INSERT INTO `wp_postmeta` VALUES("3862", "765", "post-count-month-202211", "3");
INSERT INTO `wp_postmeta` VALUES("3863", "1206", "post-count-week-202246", "1");
INSERT INTO `wp_postmeta` VALUES("3864", "766", "post-count-week-202247", "3");
INSERT INTO `wp_postmeta` VALUES("3865", "766", "post-count-month-202211", "3");
INSERT INTO `wp_postmeta` VALUES("3866", "763", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3867", "763", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3868", "222", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3869", "222", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3870", "1206", "post-count-week-202247", "10");
INSERT INTO `wp_postmeta` VALUES("3871", "148", "post-count-week-202247", "5");
INSERT INTO `wp_postmeta` VALUES("3872", "148", "post-count-month-202211", "7");
INSERT INTO `wp_postmeta` VALUES("3873", "764", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3874", "764", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3875", "765", "post-count-week-202247", "2");
INSERT INTO `wp_postmeta` VALUES("3876", "1185", "post-count-week-202247", "5");
INSERT INTO `wp_postmeta` VALUES("3877", "1185", "post-count-month-202211", "6");
INSERT INTO `wp_postmeta` VALUES("3878", "145", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3879", "145", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3880", "480", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3881", "480", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3882", "469", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3883", "469", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3884", "174", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3885", "174", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3886", "157", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3887", "157", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3888", "176", "post-count-week-202247", "1");
INSERT INTO `wp_postmeta` VALUES("3889", "176", "post-count-month-202211", "1");
INSERT INTO `wp_postmeta` VALUES("3890", "148", "post-count-week-202248", "2");
INSERT INTO `wp_postmeta` VALUES("3891", "1185", "post-count-week-202248", "1");
INSERT INTO `wp_postmeta` VALUES("3892", "1206", "post-count-week-202248", "3");
INSERT INTO `wp_postmeta` VALUES("3893", "765", "post-count-week-202248", "1");
INSERT INTO `wp_postmeta` VALUES("3894", "765", "post-count-month-202212", "5");
INSERT INTO `wp_postmeta` VALUES("3895", "763", "post-count-week-202248", "1");
INSERT INTO `wp_postmeta` VALUES("3896", "763", "post-count-month-202212", "2");
INSERT INTO `wp_postmeta` VALUES("3897", "1206", "post-count-month-202212", "11");
INSERT INTO `wp_postmeta` VALUES("3898", "480", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3899", "480", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3900", "766", "post-count-week-202249", "5");
INSERT INTO `wp_postmeta` VALUES("3901", "766", "post-count-month-202212", "5");
INSERT INTO `wp_postmeta` VALUES("3902", "157", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3903", "157", "post-count-month-202212", "2");
INSERT INTO `wp_postmeta` VALUES("3904", "764", "post-count-week-202249", "3");
INSERT INTO `wp_postmeta` VALUES("3905", "764", "post-count-month-202212", "4");
INSERT INTO `wp_postmeta` VALUES("3906", "1206", "post-count-week-202249", "4");
INSERT INTO `wp_postmeta` VALUES("3907", "148", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3908", "148", "post-count-month-202212", "5");
INSERT INTO `wp_postmeta` VALUES("3909", "763", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3910", "227", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3911", "227", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3912", "469", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3913", "469", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3914", "765", "post-count-week-202249", "1");
INSERT INTO `wp_postmeta` VALUES("3915", "174", "post-count-week-202250", "1");
INSERT INTO `wp_postmeta` VALUES("3916", "174", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3917", "172", "post-count-week-202250", "1");
INSERT INTO `wp_postmeta` VALUES("3918", "172", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3919", "148", "post-count-week-202250", "2");
INSERT INTO `wp_postmeta` VALUES("3920", "764", "post-count-week-202250", "1");
INSERT INTO `wp_postmeta` VALUES("3921", "1206", "post-count-week-202250", "3");
INSERT INTO `wp_postmeta` VALUES("3922", "765", "post-count-week-202250", "1");
INSERT INTO `wp_postmeta` VALUES("3923", "1206", "post-count-week-202251", "2");
INSERT INTO `wp_postmeta` VALUES("3924", "148", "post-count-week-202251", "2");
INSERT INTO `wp_postmeta` VALUES("3925", "765", "post-count-week-202251", "2");
INSERT INTO `wp_postmeta` VALUES("3926", "157", "post-count-week-202251", "1");
INSERT INTO `wp_postmeta` VALUES("3927", "186", "post-count-week-202251", "1");
INSERT INTO `wp_postmeta` VALUES("3928", "186", "post-count-month-202212", "1");
INSERT INTO `wp_postmeta` VALUES("3929", "186", "post-count-year-2022", "1");
INSERT INTO `wp_postmeta` VALUES("3930", "1206", "post-count-week-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3931", "1206", "post-count-month-202301", "6");
INSERT INTO `wp_postmeta` VALUES("3932", "1206", "post-count-year-2023", "172");
INSERT INTO `wp_postmeta` VALUES("3933", "174", "post-count-week-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3934", "174", "post-count-month-202301", "2");
INSERT INTO `wp_postmeta` VALUES("3935", "174", "post-count-year-2023", "20");
INSERT INTO `wp_postmeta` VALUES("3936", "1206", "post-count-week-202303", "4");
INSERT INTO `wp_postmeta` VALUES("3937", "148", "post-count-week-202303", "2");
INSERT INTO `wp_postmeta` VALUES("3938", "148", "post-count-month-202301", "3");
INSERT INTO `wp_postmeta` VALUES("3939", "148", "post-count-year-2023", "90");
INSERT INTO `wp_postmeta` VALUES("3940", "1206", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3941", "148", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3942", "1185", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3943", "1185", "post-count-month-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3944", "1185", "post-count-year-2023", "43");
INSERT INTO `wp_postmeta` VALUES("3945", "765", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3946", "765", "post-count-month-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3947", "765", "post-count-year-2023", "51");
INSERT INTO `wp_postmeta` VALUES("3948", "476", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3949", "476", "post-count-month-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3950", "476", "post-count-year-2023", "6");
INSERT INTO `wp_postmeta` VALUES("3951", "182", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3952", "182", "post-count-month-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3953", "182", "post-count-year-2023", "5");
INSERT INTO `wp_postmeta` VALUES("3954", "764", "post-count-week-202304", "1");
INSERT INTO `wp_postmeta` VALUES("3955", "764", "post-count-month-202301", "1");
INSERT INTO `wp_postmeta` VALUES("3956", "764", "post-count-year-2023", "34");
INSERT INTO `wp_postmeta` VALUES("3957", "1185", "post-count-week-202306", "4");
INSERT INTO `wp_postmeta` VALUES("3958", "1185", "post-count-month-202302", "7");
INSERT INTO `wp_postmeta` VALUES("3959", "148", "post-count-week-202306", "6");
INSERT INTO `wp_postmeta` VALUES("3960", "148", "post-count-month-202302", "11");
INSERT INTO `wp_postmeta` VALUES("3961", "176", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("3962", "176", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3963", "176", "post-count-year-2023", "10");
INSERT INTO `wp_postmeta` VALUES("3964", "1206", "post-count-week-202306", "3");
INSERT INTO `wp_postmeta` VALUES("3965", "1206", "post-count-month-202302", "15");
INSERT INTO `wp_postmeta` VALUES("3966", "765", "post-count-week-202306", "4");
INSERT INTO `wp_postmeta` VALUES("3967", "765", "post-count-month-202302", "4");
INSERT INTO `wp_postmeta` VALUES("3968", "174", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("3969", "174", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3970", "145", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3971", "145", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3972", "145", "post-count-year-2023", "2");
INSERT INTO `wp_postmeta` VALUES("3973", "480", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("3974", "480", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3975", "480", "post-count-year-2023", "11");
INSERT INTO `wp_postmeta` VALUES("3976", "227", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3977", "227", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3978", "227", "post-count-year-2023", "7");
INSERT INTO `wp_postmeta` VALUES("3979", "237", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3980", "237", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3981", "237", "post-count-year-2023", "7");
INSERT INTO `wp_postmeta` VALUES("3982", "172", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("3983", "172", "post-count-month-202302", "3");
INSERT INTO `wp_postmeta` VALUES("3984", "172", "post-count-year-2023", "20");
INSERT INTO `wp_postmeta` VALUES("3985", "180", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3986", "180", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3987", "180", "post-count-year-2023", "6");
INSERT INTO `wp_postmeta` VALUES("3988", "157", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3989", "157", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3990", "157", "post-count-year-2023", "16");
INSERT INTO `wp_postmeta` VALUES("3991", "159", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3992", "159", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3993", "159", "post-count-year-2023", "6");
INSERT INTO `wp_postmeta` VALUES("3994", "178", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3995", "178", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("3996", "178", "post-count-year-2023", "11");
INSERT INTO `wp_postmeta` VALUES("3997", "146", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("3998", "146", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("3999", "146", "post-count-year-2023", "5");
INSERT INTO `wp_postmeta` VALUES("4000", "194", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4001", "194", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("4002", "194", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4003", "203", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4004", "203", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("4005", "203", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4006", "476", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("4007", "476", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("4008", "666", "post-count-week-202306", "2");
INSERT INTO `wp_postmeta` VALUES("4009", "666", "post-count-month-202302", "2");
INSERT INTO `wp_postmeta` VALUES("4010", "666", "post-count-year-2023", "2");
INSERT INTO `wp_postmeta` VALUES("4011", "182", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4012", "182", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("4013", "469", "post-count-week-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4014", "469", "post-count-month-202302", "4");
INSERT INTO `wp_postmeta` VALUES("4015", "469", "post-count-year-2023", "12");
INSERT INTO `wp_postmeta` VALUES("4016", "1185", "post-count-week-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4017", "766", "post-count-week-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4018", "766", "post-count-month-202302", "3");
INSERT INTO `wp_postmeta` VALUES("4019", "766", "post-count-year-2023", "27");
INSERT INTO `wp_postmeta` VALUES("4020", "157", "post-count-week-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4021", "1206", "post-count-week-202307", "9");
INSERT INTO `wp_postmeta` VALUES("4022", "148", "post-count-week-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4023", "290", "post-count-week-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4024", "290", "post-count-month-202302", "1");
INSERT INTO `wp_postmeta` VALUES("4025", "290", "post-count-year-2023", "7");
INSERT INTO `wp_postmeta` VALUES("4026", "178", "post-count-week-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4027", "172", "post-count-week-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4028", "469", "post-count-week-202308", "3");
INSERT INTO `wp_postmeta` VALUES("4029", "1206", "post-count-week-202308", "3");
INSERT INTO `wp_postmeta` VALUES("4030", "148", "post-count-week-202308", "3");
INSERT INTO `wp_postmeta` VALUES("4031", "1185", "post-count-week-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4032", "766", "post-count-week-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4033", "469", "post-count-week-202309", "2");
INSERT INTO `wp_postmeta` VALUES("4034", "469", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4035", "182", "post-count-week-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4036", "182", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4037", "148", "post-count-week-202309", "2");
INSERT INTO `wp_postmeta` VALUES("4038", "148", "post-count-month-202303", "13");
INSERT INTO `wp_postmeta` VALUES("4039", "764", "post-count-week-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4040", "764", "post-count-month-202303", "7");
INSERT INTO `wp_postmeta` VALUES("4041", "766", "post-count-week-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4042", "766", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4043", "146", "post-count-week-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4044", "146", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4045", "1206", "post-count-week-202310", "2");
INSERT INTO `wp_postmeta` VALUES("4046", "1206", "post-count-month-202303", "21");
INSERT INTO `wp_postmeta` VALUES("4047", "148", "post-count-week-202310", "2");
INSERT INTO `wp_postmeta` VALUES("4048", "765", "post-count-week-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4049", "765", "post-count-month-202303", "8");
INSERT INTO `wp_postmeta` VALUES("4050", "172", "post-count-week-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4051", "172", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4052", "765", "post-count-week-202311", "5");
INSERT INTO `wp_postmeta` VALUES("4053", "1206", "post-count-week-202311", "4");
INSERT INTO `wp_postmeta` VALUES("4054", "148", "post-count-week-202311", "3");
INSERT INTO `wp_postmeta` VALUES("4055", "469", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4056", "174", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4057", "174", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4058", "764", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4059", "763", "post-count-week-202311", "2");
INSERT INTO `wp_postmeta` VALUES("4060", "763", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4061", "763", "post-count-year-2023", "14");
INSERT INTO `wp_postmeta` VALUES("4062", "1185", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4063", "1185", "post-count-month-202303", "3");
INSERT INTO `wp_postmeta` VALUES("4064", "237", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4065", "237", "post-count-month-202303", "2");
INSERT INTO `wp_postmeta` VALUES("4066", "172", "post-count-week-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4067", "1206", "post-count-week-202312", "13");
INSERT INTO `wp_postmeta` VALUES("4068", "148", "post-count-week-202312", "6");
INSERT INTO `wp_postmeta` VALUES("4069", "1185", "post-count-week-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4070", "182", "post-count-week-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4071", "227", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4072", "227", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4073", "237", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4074", "223", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4075", "223", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4076", "223", "post-count-year-2023", "2");
INSERT INTO `wp_postmeta` VALUES("4077", "763", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4078", "764", "post-count-week-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4079", "765", "post-count-week-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4080", "766", "post-count-week-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4081", "172", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4082", "242", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4083", "242", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4084", "242", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4085", "480", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4086", "480", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4087", "190", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4088", "190", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4089", "190", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4090", "192", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4091", "192", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4092", "192", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4093", "188", "post-count-week-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4094", "188", "post-count-month-202303", "1");
INSERT INTO `wp_postmeta` VALUES("4095", "188", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4096", "1206", "post-count-week-202313", "4");
INSERT INTO `wp_postmeta` VALUES("4097", "764", "post-count-week-202313", "4");
INSERT INTO `wp_postmeta` VALUES("4098", "1206", "post-count-month-202304", "13");
INSERT INTO `wp_postmeta` VALUES("4099", "764", "post-count-month-202304", "3");
INSERT INTO `wp_postmeta` VALUES("4100", "763", "post-count-week-202313", "1");
INSERT INTO `wp_postmeta` VALUES("4101", "763", "post-count-month-202304", "2");
INSERT INTO `wp_postmeta` VALUES("4102", "765", "post-count-week-202313", "1");
INSERT INTO `wp_postmeta` VALUES("4103", "765", "post-count-month-202304", "5");
INSERT INTO `wp_postmeta` VALUES("4104", "148", "post-count-week-202313", "1");
INSERT INTO `wp_postmeta` VALUES("4105", "148", "post-count-month-202304", "4");
INSERT INTO `wp_postmeta` VALUES("4106", "174", "post-count-week-202314", "1");
INSERT INTO `wp_postmeta` VALUES("4107", "174", "post-count-month-202304", "1");
INSERT INTO `wp_postmeta` VALUES("4108", "157", "post-count-week-202314", "1");
INSERT INTO `wp_postmeta` VALUES("4109", "157", "post-count-month-202304", "1");
INSERT INTO `wp_postmeta` VALUES("4110", "1206", "post-count-week-202314", "4");
INSERT INTO `wp_postmeta` VALUES("4111", "765", "post-count-week-202314", "2");
INSERT INTO `wp_postmeta` VALUES("4112", "148", "post-count-week-202314", "2");
INSERT INTO `wp_postmeta` VALUES("4113", "1185", "post-count-week-202314", "3");
INSERT INTO `wp_postmeta` VALUES("4114", "1185", "post-count-month-202304", "4");
INSERT INTO `wp_postmeta` VALUES("4115", "172", "post-count-week-202314", "1");
INSERT INTO `wp_postmeta` VALUES("4116", "172", "post-count-month-202304", "1");
INSERT INTO `wp_postmeta` VALUES("4117", "765", "post-count-week-202315", "1");
INSERT INTO `wp_postmeta` VALUES("4118", "764", "post-count-week-202315", "1");
INSERT INTO `wp_postmeta` VALUES("4119", "1206", "post-count-week-202316", "6");
INSERT INTO `wp_postmeta` VALUES("4120", "148", "post-count-week-202316", "1");
INSERT INTO `wp_postmeta` VALUES("4121", "764", "post-count-week-202316", "1");
INSERT INTO `wp_postmeta` VALUES("4122", "765", "post-count-week-202316", "1");
INSERT INTO `wp_postmeta` VALUES("4123", "1185", "post-count-week-202316", "1");
INSERT INTO `wp_postmeta` VALUES("4124", "763", "post-count-week-202317", "1");
INSERT INTO `wp_postmeta` VALUES("4125", "1206", "post-count-week-202317", "1");
INSERT INTO `wp_postmeta` VALUES("4126", "766", "post-count-week-202317", "1");
INSERT INTO `wp_postmeta` VALUES("4127", "766", "post-count-month-202304", "1");
INSERT INTO `wp_postmeta` VALUES("4128", "1185", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4129", "1185", "post-count-month-202305", "9");
INSERT INTO `wp_postmeta` VALUES("4130", "765", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4131", "765", "post-count-month-202305", "3");
INSERT INTO `wp_postmeta` VALUES("4132", "1206", "post-count-week-202319", "9");
INSERT INTO `wp_postmeta` VALUES("4133", "1206", "post-count-month-202305", "21");
INSERT INTO `wp_postmeta` VALUES("4134", "148", "post-count-week-202319", "3");
INSERT INTO `wp_postmeta` VALUES("4135", "148", "post-count-month-202305", "12");
INSERT INTO `wp_postmeta` VALUES("4136", "764", "post-count-week-202319", "2");
INSERT INTO `wp_postmeta` VALUES("4137", "764", "post-count-month-202305", "4");
INSERT INTO `wp_postmeta` VALUES("4138", "763", "post-count-week-202319", "2");
INSERT INTO `wp_postmeta` VALUES("4139", "763", "post-count-month-202305", "3");
INSERT INTO `wp_postmeta` VALUES("4140", "222", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4141", "222", "post-count-month-202305", "2");
INSERT INTO `wp_postmeta` VALUES("4142", "222", "post-count-year-2023", "7");
INSERT INTO `wp_postmeta` VALUES("4143", "480", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4144", "480", "post-count-month-202305", "3");
INSERT INTO `wp_postmeta` VALUES("4145", "172", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4146", "172", "post-count-month-202305", "2");
INSERT INTO `wp_postmeta` VALUES("4147", "157", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4148", "157", "post-count-month-202305", "1");
INSERT INTO `wp_postmeta` VALUES("4149", "186", "post-count-week-202319", "1");
INSERT INTO `wp_postmeta` VALUES("4150", "186", "post-count-month-202305", "1");
INSERT INTO `wp_postmeta` VALUES("4151", "186", "post-count-year-2023", "2");
INSERT INTO `wp_postmeta` VALUES("4152", "764", "post-count-week-202320", "2");
INSERT INTO `wp_postmeta` VALUES("4153", "763", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4154", "222", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4155", "765", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4156", "1206", "post-count-week-202320", "4");
INSERT INTO `wp_postmeta` VALUES("4157", "766", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4158", "766", "post-count-month-202305", "1");
INSERT INTO `wp_postmeta` VALUES("4159", "148", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4160", "1185", "post-count-week-202320", "1");
INSERT INTO `wp_postmeta` VALUES("4161", "148", "post-count-week-202321", "8");
INSERT INTO `wp_postmeta` VALUES("4162", "1185", "post-count-week-202321", "7");
INSERT INTO `wp_postmeta` VALUES("4163", "146", "post-count-week-202321", "2");
INSERT INTO `wp_postmeta` VALUES("4164", "146", "post-count-month-202305", "2");
INSERT INTO `wp_postmeta` VALUES("4165", "1206", "post-count-week-202321", "6");
INSERT INTO `wp_postmeta` VALUES("4166", "480", "post-count-week-202321", "2");
INSERT INTO `wp_postmeta` VALUES("4167", "765", "post-count-week-202321", "1");
INSERT INTO `wp_postmeta` VALUES("4168", "172", "post-count-week-202321", "1");
INSERT INTO `wp_postmeta` VALUES("4169", "1206", "post-count-week-202322", "6");
INSERT INTO `wp_postmeta` VALUES("4170", "1206", "post-count-month-202306", "16");
INSERT INTO `wp_postmeta` VALUES("4171", "148", "post-count-week-202322", "1");
INSERT INTO `wp_postmeta` VALUES("4172", "148", "post-count-month-202306", "5");
INSERT INTO `wp_postmeta` VALUES("4173", "480", "post-count-week-202322", "2");
INSERT INTO `wp_postmeta` VALUES("4174", "480", "post-count-month-202306", "3");
INSERT INTO `wp_postmeta` VALUES("4175", "1185", "post-count-week-202322", "1");
INSERT INTO `wp_postmeta` VALUES("4176", "1185", "post-count-month-202306", "4");
INSERT INTO `wp_postmeta` VALUES("4177", "765", "post-count-week-202322", "1");
INSERT INTO `wp_postmeta` VALUES("4178", "765", "post-count-month-202306", "7");
INSERT INTO `wp_postmeta` VALUES("4179", "178", "post-count-week-202322", "1");
INSERT INTO `wp_postmeta` VALUES("4180", "178", "post-count-month-202306", "2");
INSERT INTO `wp_postmeta` VALUES("4181", "174", "post-count-week-202322", "1");
INSERT INTO `wp_postmeta` VALUES("4182", "174", "post-count-month-202306", "2");
INSERT INTO `wp_postmeta` VALUES("4183", "766", "post-count-week-202323", "1");
INSERT INTO `wp_postmeta` VALUES("4184", "766", "post-count-month-202306", "4");
INSERT INTO `wp_postmeta` VALUES("4185", "765", "post-count-week-202323", "2");
INSERT INTO `wp_postmeta` VALUES("4186", "1206", "post-count-week-202323", "2");
INSERT INTO `wp_postmeta` VALUES("4187", "469", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4188", "469", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4189", "148", "post-count-week-202324", "4");
INSERT INTO `wp_postmeta` VALUES("4190", "765", "post-count-week-202324", "2");
INSERT INTO `wp_postmeta` VALUES("4191", "178", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4192", "1206", "post-count-week-202324", "4");
INSERT INTO `wp_postmeta` VALUES("4193", "1185", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4194", "227", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4195", "227", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4196", "237", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4197", "237", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4198", "172", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4199", "172", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4200", "180", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4201", "180", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4202", "174", "post-count-week-202324", "1");
INSERT INTO `wp_postmeta` VALUES("4203", "1206", "post-count-week-202325", "5");
INSERT INTO `wp_postmeta` VALUES("4204", "1185", "post-count-week-202325", "2");
INSERT INTO `wp_postmeta` VALUES("4205", "1681", "_thumbnail_id", "550");
INSERT INTO `wp_postmeta` VALUES("4206", "1681", "post", "237,221,223");
INSERT INTO `wp_postmeta` VALUES("4207", "1681", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4208", "766", "post-count-week-202325", "3");
INSERT INTO `wp_postmeta` VALUES("4209", "290", "post-count-week-202325", "3");
INSERT INTO `wp_postmeta` VALUES("4210", "290", "post-count-month-202306", "3");
INSERT INTO `wp_postmeta` VALUES("4211", "765", "post-count-week-202325", "2");
INSERT INTO `wp_postmeta` VALUES("4212", "763", "post-count-week-202325", "1");
INSERT INTO `wp_postmeta` VALUES("4213", "763", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4214", "222", "post-count-week-202325", "3");
INSERT INTO `wp_postmeta` VALUES("4215", "222", "post-count-month-202306", "3");
INSERT INTO `wp_postmeta` VALUES("4216", "764", "post-count-week-202325", "1");
INSERT INTO `wp_postmeta` VALUES("4217", "764", "post-count-month-202306", "1");
INSERT INTO `wp_postmeta` VALUES("4218", "1206", "post-count-week-202326", "1");
INSERT INTO `wp_postmeta` VALUES("4219", "480", "post-count-week-202326", "1");
INSERT INTO `wp_postmeta` VALUES("4220", "148", "post-count-week-202327", "2");
INSERT INTO `wp_postmeta` VALUES("4221", "148", "post-count-month-202307", "5");
INSERT INTO `wp_postmeta` VALUES("4222", "766", "post-count-week-202327", "3");
INSERT INTO `wp_postmeta` VALUES("4223", "766", "post-count-month-202307", "3");
INSERT INTO `wp_postmeta` VALUES("4224", "145", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4225", "145", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4226", "172", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4227", "172", "post-count-month-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4228", "174", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4229", "174", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4230", "157", "post-count-week-202327", "2");
INSERT INTO `wp_postmeta` VALUES("4231", "157", "post-count-month-202307", "7");
INSERT INTO `wp_postmeta` VALUES("4232", "763", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4233", "763", "post-count-month-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4234", "1206", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4235", "1206", "post-count-month-202307", "13");
INSERT INTO `wp_postmeta` VALUES("4236", "159", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4237", "159", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4238", "764", "post-count-week-202327", "1");
INSERT INTO `wp_postmeta` VALUES("4239", "764", "post-count-month-202307", "6");
INSERT INTO `wp_postmeta` VALUES("4240", "1185", "post-count-week-202328", "2");
INSERT INTO `wp_postmeta` VALUES("4241", "1185", "post-count-month-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4242", "1206", "post-count-week-202328", "6");
INSERT INTO `wp_postmeta` VALUES("4243", "148", "post-count-week-202328", "2");
INSERT INTO `wp_postmeta` VALUES("4244", "764", "post-count-week-202328", "4");
INSERT INTO `wp_postmeta` VALUES("4245", "227", "post-count-week-202328", "1");
INSERT INTO `wp_postmeta` VALUES("4246", "227", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4247", "763", "post-count-week-202328", "1");
INSERT INTO `wp_postmeta` VALUES("4248", "222", "post-count-week-202328", "1");
INSERT INTO `wp_postmeta` VALUES("4249", "222", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4250", "157", "post-count-week-202328", "1");
INSERT INTO `wp_postmeta` VALUES("4251", "1206", "post-count-week-202329", "6");
INSERT INTO `wp_postmeta` VALUES("4252", "764", "post-count-week-202329", "1");
INSERT INTO `wp_postmeta` VALUES("4253", "765", "post-count-week-202329", "1");
INSERT INTO `wp_postmeta` VALUES("4254", "765", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4255", "148", "post-count-week-202329", "1");
INSERT INTO `wp_postmeta` VALUES("4256", "172", "post-count-week-202330", "1");
INSERT INTO `wp_postmeta` VALUES("4257", "178", "post-count-week-202330", "2");
INSERT INTO `wp_postmeta` VALUES("4258", "178", "post-count-month-202307", "2");
INSERT INTO `wp_postmeta` VALUES("4259", "157", "post-count-week-202330", "4");
INSERT INTO `wp_postmeta` VALUES("4260", "1683", "_thumbnail_id", "508");
INSERT INTO `wp_postmeta` VALUES("4261", "1683", "post", "157,178");
INSERT INTO `wp_postmeta` VALUES("4262", "1683", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4263", "186", "post-count-week-202330", "1");
INSERT INTO `wp_postmeta` VALUES("4264", "186", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4265", "1683", "post-count-all", "1");
INSERT INTO `wp_postmeta` VALUES("4266", "1683", "post-count-week-202330", "1");
INSERT INTO `wp_postmeta` VALUES("4267", "1683", "post-count-month-202307", "1");
INSERT INTO `wp_postmeta` VALUES("4268", "1683", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4269", "176", "post-count-week-202331", "1");
INSERT INTO `wp_postmeta` VALUES("4270", "176", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4271", "1206", "post-count-week-202331", "1");
INSERT INTO `wp_postmeta` VALUES("4272", "1206", "post-count-month-202308", "22");
INSERT INTO `wp_postmeta` VALUES("4273", "148", "post-count-week-202331", "1");
INSERT INTO `wp_postmeta` VALUES("4274", "148", "post-count-month-202308", "12");
INSERT INTO `wp_postmeta` VALUES("4275", "765", "post-count-week-202331", "1");
INSERT INTO `wp_postmeta` VALUES("4276", "765", "post-count-month-202308", "8");
INSERT INTO `wp_postmeta` VALUES("4277", "178", "post-count-week-202331", "1");
INSERT INTO `wp_postmeta` VALUES("4278", "178", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4279", "763", "post-count-week-202332", "2");
INSERT INTO `wp_postmeta` VALUES("4280", "763", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4281", "172", "post-count-week-202332", "2");
INSERT INTO `wp_postmeta` VALUES("4282", "172", "post-count-month-202308", "3");
INSERT INTO `wp_postmeta` VALUES("4283", "223", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4284", "223", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4285", "1206", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4286", "148", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4287", "480", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4288", "480", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4289", "1185", "post-count-week-202332", "2");
INSERT INTO `wp_postmeta` VALUES("4290", "1185", "post-count-month-202308", "6");
INSERT INTO `wp_postmeta` VALUES("4291", "227", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4292", "227", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4293", "237", "post-count-week-202332", "1");
INSERT INTO `wp_postmeta` VALUES("4294", "237", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4295", "148", "post-count-week-202333", "8");
INSERT INTO `wp_postmeta` VALUES("4296", "159", "post-count-week-202333", "2");
INSERT INTO `wp_postmeta` VALUES("4297", "159", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4298", "172", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4299", "1206", "post-count-week-202333", "13");
INSERT INTO `wp_postmeta` VALUES("4300", "290", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4301", "290", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4302", "222", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4303", "222", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4304", "766", "post-count-week-202333", "4");
INSERT INTO `wp_postmeta` VALUES("4305", "766", "post-count-month-202308", "8");
INSERT INTO `wp_postmeta` VALUES("4306", "1185", "post-count-week-202333", "3");
INSERT INTO `wp_postmeta` VALUES("4307", "765", "post-count-week-202333", "2");
INSERT INTO `wp_postmeta` VALUES("4308", "174", "post-count-week-202333", "2");
INSERT INTO `wp_postmeta` VALUES("4309", "174", "post-count-month-202308", "3");
INSERT INTO `wp_postmeta` VALUES("4310", "176", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4311", "764", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4312", "764", "post-count-month-202308", "4");
INSERT INTO `wp_postmeta` VALUES("4313", "180", "post-count-week-202333", "1");
INSERT INTO `wp_postmeta` VALUES("4314", "180", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4315", "1206", "post-count-week-202334", "7");
INSERT INTO `wp_postmeta` VALUES("4316", "765", "post-count-week-202334", "5");
INSERT INTO `wp_postmeta` VALUES("4317", "1185", "post-count-week-202334", "1");
INSERT INTO `wp_postmeta` VALUES("4318", "766", "post-count-week-202334", "4");
INSERT INTO `wp_postmeta` VALUES("4319", "764", "post-count-week-202334", "3");
INSERT INTO `wp_postmeta` VALUES("4320", "469", "post-count-week-202334", "2");
INSERT INTO `wp_postmeta` VALUES("4321", "469", "post-count-month-202308", "2");
INSERT INTO `wp_postmeta` VALUES("4322", "157", "post-count-week-202334", "1");
INSERT INTO `wp_postmeta` VALUES("4323", "157", "post-count-month-202308", "1");
INSERT INTO `wp_postmeta` VALUES("4324", "148", "post-count-week-202334", "2");
INSERT INTO `wp_postmeta` VALUES("4325", "180", "post-count-week-202334", "1");
INSERT INTO `wp_postmeta` VALUES("4326", "174", "post-count-week-202334", "1");
INSERT INTO `wp_postmeta` VALUES("4327", "290", "post-count-week-202334", "1");
INSERT INTO `wp_postmeta` VALUES("4328", "1206", "post-count-week-202335", "1");
INSERT INTO `wp_postmeta` VALUES("4329", "1206", "post-count-month-202309", "5");
INSERT INTO `wp_postmeta` VALUES("4330", "172", "post-count-week-202336", "2");
INSERT INTO `wp_postmeta` VALUES("4331", "172", "post-count-month-202309", "2");
INSERT INTO `wp_postmeta` VALUES("4332", "148", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4333", "148", "post-count-month-202309", "3");
INSERT INTO `wp_postmeta` VALUES("4334", "1206", "post-count-week-202336", "3");
INSERT INTO `wp_postmeta` VALUES("4335", "766", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4336", "766", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4337", "480", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4338", "480", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4339", "765", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4340", "765", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4341", "1185", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4342", "1185", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4343", "227", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4344", "227", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4345", "237", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4346", "237", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4347", "180", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4348", "180", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4349", "174", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4350", "174", "post-count-month-202309", "3");
INSERT INTO `wp_postmeta` VALUES("4351", "157", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4352", "157", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4353", "159", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4354", "159", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4355", "178", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4356", "178", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4357", "176", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4358", "176", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4359", "146", "post-count-week-202336", "1");
INSERT INTO `wp_postmeta` VALUES("4360", "146", "post-count-month-202309", "1");
INSERT INTO `wp_postmeta` VALUES("4361", "1206", "post-count-week-202338", "1");
INSERT INTO `wp_postmeta` VALUES("4362", "148", "post-count-week-202338", "2");
INSERT INTO `wp_postmeta` VALUES("4363", "174", "post-count-week-202338", "2");
INSERT INTO `wp_postmeta` VALUES("4364", "178", "post-count-week-202340", "1");
INSERT INTO `wp_postmeta` VALUES("4365", "178", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4366", "764", "post-count-week-202340", "1");
INSERT INTO `wp_postmeta` VALUES("4367", "764", "post-count-month-202310", "3");
INSERT INTO `wp_postmeta` VALUES("4368", "1206", "post-count-week-202340", "3");
INSERT INTO `wp_postmeta` VALUES("4369", "1206", "post-count-month-202310", "15");
INSERT INTO `wp_postmeta` VALUES("4370", "148", "post-count-week-202340", "1");
INSERT INTO `wp_postmeta` VALUES("4371", "148", "post-count-month-202310", "5");
INSERT INTO `wp_postmeta` VALUES("4372", "156", "post-count-week-202340", "1");
INSERT INTO `wp_postmeta` VALUES("4373", "156", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4374", "156", "post-count-year-2023", "1");
INSERT INTO `wp_postmeta` VALUES("4375", "148", "post-count-week-202341", "4");
INSERT INTO `wp_postmeta` VALUES("4376", "1206", "post-count-week-202341", "6");
INSERT INTO `wp_postmeta` VALUES("4377", "1185", "post-count-week-202341", "2");
INSERT INTO `wp_postmeta` VALUES("4378", "1185", "post-count-month-202310", "4");
INSERT INTO `wp_postmeta` VALUES("4379", "765", "post-count-week-202341", "6");
INSERT INTO `wp_postmeta` VALUES("4380", "765", "post-count-month-202310", "8");
INSERT INTO `wp_postmeta` VALUES("4381", "469", "post-count-week-202341", "1");
INSERT INTO `wp_postmeta` VALUES("4382", "469", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4383", "176", "post-count-week-202341", "2");
INSERT INTO `wp_postmeta` VALUES("4384", "176", "post-count-month-202310", "3");
INSERT INTO `wp_postmeta` VALUES("4385", "476", "post-count-week-202341", "2");
INSERT INTO `wp_postmeta` VALUES("4386", "476", "post-count-month-202310", "2");
INSERT INTO `wp_postmeta` VALUES("4387", "1206", "post-count-week-202342", "5");
INSERT INTO `wp_postmeta` VALUES("4388", "1185", "post-count-week-202342", "1");
INSERT INTO `wp_postmeta` VALUES("4389", "764", "post-count-week-202342", "1");
INSERT INTO `wp_postmeta` VALUES("4390", "227", "post-count-week-202342", "1");
INSERT INTO `wp_postmeta` VALUES("4391", "227", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4392", "174", "post-count-week-202342", "1");
INSERT INTO `wp_postmeta` VALUES("4393", "174", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4394", "157", "post-count-week-202342", "1");
INSERT INTO `wp_postmeta` VALUES("4395", "157", "post-count-month-202310", "1");
INSERT INTO `wp_postmeta` VALUES("4396", "172", "post-count-week-202343", "2");
INSERT INTO `wp_postmeta` VALUES("4397", "172", "post-count-month-202310", "3");
INSERT INTO `wp_postmeta` VALUES("4398", "765", "post-count-week-202343", "2");
INSERT INTO `wp_postmeta` VALUES("4399", "176", "post-count-week-202343", "1");
INSERT INTO `wp_postmeta` VALUES("4400", "764", "post-count-week-202343", "1");
INSERT INTO `wp_postmeta` VALUES("4401", "1185", "post-count-week-202344", "1");
INSERT INTO `wp_postmeta` VALUES("4402", "172", "post-count-week-202344", "1");
INSERT INTO `wp_postmeta` VALUES("4403", "1206", "post-count-week-202344", "2");
INSERT INTO `wp_postmeta` VALUES("4404", "1206", "post-count-month-202311", "9");
INSERT INTO `wp_postmeta` VALUES("4405", "1206", "post-count-week-202345", "1");
INSERT INTO `wp_postmeta` VALUES("4406", "148", "post-count-week-202345", "3");
INSERT INTO `wp_postmeta` VALUES("4407", "148", "post-count-month-202311", "8");
INSERT INTO `wp_postmeta` VALUES("4408", "765", "post-count-week-202345", "1");
INSERT INTO `wp_postmeta` VALUES("4409", "765", "post-count-month-202311", "2");
INSERT INTO `wp_postmeta` VALUES("4410", "1206", "post-count-week-202346", "4");
INSERT INTO `wp_postmeta` VALUES("4411", "766", "post-count-week-202346", "1");
INSERT INTO `wp_postmeta` VALUES("4412", "766", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4413", "157", "post-count-week-202346", "1");
INSERT INTO `wp_postmeta` VALUES("4414", "157", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4415", "1684", "_thumbnail_id", "526");
INSERT INTO `wp_postmeta` VALUES("4416", "1684", "post", "176,159");
INSERT INTO `wp_postmeta` VALUES("4417", "1684", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4418", "1685", "_thumbnail_id", "509");
INSERT INTO `wp_postmeta` VALUES("4419", "1685", "post", "159");
INSERT INTO `wp_postmeta` VALUES("4420", "1685", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4421", "148", "post-count-week-202346", "2");
INSERT INTO `wp_postmeta` VALUES("4422", "1686", "_thumbnail_id", "700");
INSERT INTO `wp_postmeta` VALUES("4423", "1686", "post", "611");
INSERT INTO `wp_postmeta` VALUES("4424", "1686", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4425", "180", "post-count-week-202346", "1");
INSERT INTO `wp_postmeta` VALUES("4426", "180", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4427", "174", "post-count-week-202346", "1");
INSERT INTO `wp_postmeta` VALUES("4428", "174", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4429", "765", "post-count-week-202347", "1");
INSERT INTO `wp_postmeta` VALUES("4430", "237", "post-count-week-202347", "1");
INSERT INTO `wp_postmeta` VALUES("4431", "237", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4432", "764", "post-count-week-202347", "1");
INSERT INTO `wp_postmeta` VALUES("4433", "764", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4434", "1206", "post-count-week-202347", "3");
INSERT INTO `wp_postmeta` VALUES("4435", "148", "post-count-week-202347", "3");
INSERT INTO `wp_postmeta` VALUES("4436", "1687", "_thumbnail_id", "526");
INSERT INTO `wp_postmeta` VALUES("4437", "1687", "post", "176");
INSERT INTO `wp_postmeta` VALUES("4438", "1687", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4439", "176", "post-count-week-202348", "1");
INSERT INTO `wp_postmeta` VALUES("4440", "176", "post-count-month-202311", "1");
INSERT INTO `wp_postmeta` VALUES("4441", "765", "post-count-week-202348", "1");
INSERT INTO `wp_postmeta` VALUES("4442", "765", "post-count-month-202312", "3");
INSERT INTO `wp_postmeta` VALUES("4443", "764", "post-count-week-202348", "1");
INSERT INTO `wp_postmeta` VALUES("4444", "764", "post-count-month-202312", "4");
INSERT INTO `wp_postmeta` VALUES("4445", "148", "post-count-week-202348", "1");
INSERT INTO `wp_postmeta` VALUES("4446", "148", "post-count-month-202312", "9");
INSERT INTO `wp_postmeta` VALUES("4447", "174", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4448", "174", "post-count-month-202312", "3");
INSERT INTO `wp_postmeta` VALUES("4449", "1185", "post-count-week-202349", "2");
INSERT INTO `wp_postmeta` VALUES("4450", "1185", "post-count-month-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4451", "1206", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4452", "1206", "post-count-month-202312", "16");
INSERT INTO `wp_postmeta` VALUES("4453", "148", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4454", "764", "post-count-week-202349", "2");
INSERT INTO `wp_postmeta` VALUES("4455", "765", "post-count-week-202349", "2");
INSERT INTO `wp_postmeta` VALUES("4456", "766", "post-count-week-202349", "2");
INSERT INTO `wp_postmeta` VALUES("4457", "766", "post-count-month-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4458", "157", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4459", "157", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4460", "763", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4461", "763", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4462", "469", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4463", "469", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4464", "159", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4465", "159", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4466", "476", "post-count-week-202349", "1");
INSERT INTO `wp_postmeta` VALUES("4467", "476", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4468", "764", "post-count-week-202350", "1");
INSERT INTO `wp_postmeta` VALUES("4469", "174", "post-count-week-202350", "1");
INSERT INTO `wp_postmeta` VALUES("4470", "1206", "post-count-week-202350", "1");
INSERT INTO `wp_postmeta` VALUES("4471", "1206", "post-count-week-202351", "7");
INSERT INTO `wp_postmeta` VALUES("4472", "148", "post-count-week-202351", "3");
INSERT INTO `wp_postmeta` VALUES("4473", "290", "post-count-week-202351", "1");
INSERT INTO `wp_postmeta` VALUES("4474", "290", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4475", "176", "post-count-week-202351", "1");
INSERT INTO `wp_postmeta` VALUES("4476", "176", "post-count-month-202312", "1");
INSERT INTO `wp_postmeta` VALUES("4477", "178", "post-count-week-202351", "1");
INSERT INTO `wp_postmeta` VALUES("4478", "178", "post-count-month-202312", "2");
INSERT INTO `wp_postmeta` VALUES("4479", "1688", "_thumbnail_id", "699");
INSERT INTO `wp_postmeta` VALUES("4480", "1688", "post", "1185");
INSERT INTO `wp_postmeta` VALUES("4481", "1688", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4482", "1689", "_thumbnail_id", "699");
INSERT INTO `wp_postmeta` VALUES("4483", "1689", "post", "1185");
INSERT INTO `wp_postmeta` VALUES("4484", "1689", "type", "playlist");
INSERT INTO `wp_postmeta` VALUES("4485", "178", "post-count-week-202352", "1");
INSERT INTO `wp_postmeta` VALUES("4486", "1206", "post-count-week-202352", "7");
INSERT INTO `wp_postmeta` VALUES("4487", "148", "post-count-week-202352", "4");
INSERT INTO `wp_postmeta` VALUES("4488", "174", "post-count-week-202352", "1");
INSERT INTO `wp_postmeta` VALUES("4489", "1206", "post-count-week-202401", "3");
INSERT INTO `wp_postmeta` VALUES("4490", "1206", "post-count-month-202401", "8");
INSERT INTO `wp_postmeta` VALUES("4491", "1206", "post-count-year-2024", "76");
INSERT INTO `wp_postmeta` VALUES("4492", "764", "post-count-week-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4493", "764", "post-count-month-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4494", "764", "post-count-year-2024", "10");
INSERT INTO `wp_postmeta` VALUES("4495", "1185", "post-count-week-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4496", "1185", "post-count-month-202401", "3");
INSERT INTO `wp_postmeta` VALUES("4497", "1185", "post-count-year-2024", "23");
INSERT INTO `wp_postmeta` VALUES("4498", "148", "post-count-week-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4499", "148", "post-count-month-202401", "5");
INSERT INTO `wp_postmeta` VALUES("4500", "148", "post-count-year-2024", "45");
INSERT INTO `wp_postmeta` VALUES("4501", "176", "post-count-week-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4502", "176", "post-count-month-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4503", "176", "post-count-year-2024", "8");
INSERT INTO `wp_postmeta` VALUES("4504", "1206", "post-count-week-202402", "2");
INSERT INTO `wp_postmeta` VALUES("4505", "148", "post-count-week-202402", "2");
INSERT INTO `wp_postmeta` VALUES("4506", "766", "post-count-week-202402", "3");
INSERT INTO `wp_postmeta` VALUES("4507", "766", "post-count-month-202401", "4");
INSERT INTO `wp_postmeta` VALUES("4508", "766", "post-count-year-2024", "17");
INSERT INTO `wp_postmeta` VALUES("4509", "763", "post-count-week-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4510", "763", "post-count-month-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4511", "763", "post-count-year-2024", "19");
INSERT INTO `wp_postmeta` VALUES("4512", "1185", "post-count-week-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4513", "178", "post-count-week-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4514", "178", "post-count-month-202401", "2");
INSERT INTO `wp_postmeta` VALUES("4515", "178", "post-count-year-2024", "9");
INSERT INTO `wp_postmeta` VALUES("4516", "148", "post-count-week-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4517", "1206", "post-count-week-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4518", "766", "post-count-week-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4519", "1185", "post-count-week-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4520", "480", "post-count-week-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4521", "480", "post-count-month-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4522", "480", "post-count-year-2024", "10");
INSERT INTO `wp_postmeta` VALUES("4523", "1206", "post-count-week-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4524", "148", "post-count-week-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4525", "145", "post-count-week-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4526", "145", "post-count-month-202401", "1");
INSERT INTO `wp_postmeta` VALUES("4527", "145", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4528", "172", "post-count-week-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4529", "172", "post-count-month-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4530", "172", "post-count-year-2024", "9");
INSERT INTO `wp_postmeta` VALUES("4531", "1206", "post-count-week-202406", "2");
INSERT INTO `wp_postmeta` VALUES("4532", "1206", "post-count-month-202402", "6");
INSERT INTO `wp_postmeta` VALUES("4533", "1185", "post-count-week-202406", "3");
INSERT INTO `wp_postmeta` VALUES("4534", "1185", "post-count-month-202402", "5");
INSERT INTO `wp_postmeta` VALUES("4535", "148", "post-count-week-202406", "3");
INSERT INTO `wp_postmeta` VALUES("4536", "148", "post-count-month-202402", "6");
INSERT INTO `wp_postmeta` VALUES("4537", "290", "post-count-week-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4538", "290", "post-count-month-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4539", "290", "post-count-year-2024", "3");
INSERT INTO `wp_postmeta` VALUES("4540", "1206", "post-count-week-202407", "1");
INSERT INTO `wp_postmeta` VALUES("4541", "148", "post-count-week-202407", "2");
INSERT INTO `wp_postmeta` VALUES("4542", "1206", "post-count-week-202408", "2");
INSERT INTO `wp_postmeta` VALUES("4543", "764", "post-count-week-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4544", "764", "post-count-month-202402", "2");
INSERT INTO `wp_postmeta` VALUES("4545", "763", "post-count-week-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4546", "763", "post-count-month-202402", "2");
INSERT INTO `wp_postmeta` VALUES("4547", "765", "post-count-week-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4548", "765", "post-count-month-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4549", "765", "post-count-year-2024", "27");
INSERT INTO `wp_postmeta` VALUES("4550", "174", "post-count-week-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4551", "174", "post-count-month-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4552", "174", "post-count-year-2024", "8");
INSERT INTO `wp_postmeta` VALUES("4553", "148", "post-count-week-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4554", "1185", "post-count-week-202409", "2");
INSERT INTO `wp_postmeta` VALUES("4555", "1206", "post-count-week-202409", "2");
INSERT INTO `wp_postmeta` VALUES("4556", "764", "post-count-week-202409", "1");
INSERT INTO `wp_postmeta` VALUES("4557", "763", "post-count-week-202409", "1");
INSERT INTO `wp_postmeta` VALUES("4558", "176", "post-count-week-202409", "1");
INSERT INTO `wp_postmeta` VALUES("4559", "176", "post-count-month-202402", "1");
INSERT INTO `wp_postmeta` VALUES("4560", "1206", "post-count-month-202403", "16");
INSERT INTO `wp_postmeta` VALUES("4561", "765", "post-count-week-202409", "1");
INSERT INTO `wp_postmeta` VALUES("4562", "765", "post-count-month-202403", "9");
INSERT INTO `wp_postmeta` VALUES("4563", "1206", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4564", "148", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4565", "148", "post-count-month-202403", "8");
INSERT INTO `wp_postmeta` VALUES("4566", "763", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4567", "763", "post-count-month-202403", "7");
INSERT INTO `wp_postmeta` VALUES("4568", "480", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4569", "480", "post-count-month-202403", "3");
INSERT INTO `wp_postmeta` VALUES("4570", "766", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4571", "766", "post-count-month-202403", "3");
INSERT INTO `wp_postmeta` VALUES("4572", "157", "post-count-week-202410", "1");
INSERT INTO `wp_postmeta` VALUES("4573", "157", "post-count-month-202403", "5");
INSERT INTO `wp_postmeta` VALUES("4574", "157", "post-count-year-2024", "6");
INSERT INTO `wp_postmeta` VALUES("4575", "1206", "post-count-week-202411", "2");
INSERT INTO `wp_postmeta` VALUES("4576", "765", "post-count-week-202411", "2");
INSERT INTO `wp_postmeta` VALUES("4577", "148", "post-count-week-202411", "1");
INSERT INTO `wp_postmeta` VALUES("4578", "763", "post-count-week-202411", "2");
INSERT INTO `wp_postmeta` VALUES("4579", "1206", "post-count-week-202412", "12");
INSERT INTO `wp_postmeta` VALUES("4580", "148", "post-count-week-202412", "5");
INSERT INTO `wp_postmeta` VALUES("4581", "480", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4582", "1185", "post-count-week-202412", "3");
INSERT INTO `wp_postmeta` VALUES("4583", "1185", "post-count-month-202403", "3");
INSERT INTO `wp_postmeta` VALUES("4584", "227", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4585", "227", "post-count-month-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4586", "227", "post-count-year-2024", "2");
INSERT INTO `wp_postmeta` VALUES("4587", "237", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4588", "237", "post-count-month-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4589", "237", "post-count-year-2024", "3");
INSERT INTO `wp_postmeta` VALUES("4590", "172", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4591", "172", "post-count-month-202403", "3");
INSERT INTO `wp_postmeta` VALUES("4592", "180", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4593", "180", "post-count-month-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4594", "180", "post-count-year-2024", "2");
INSERT INTO `wp_postmeta` VALUES("4595", "174", "post-count-week-202412", "5");
INSERT INTO `wp_postmeta` VALUES("4596", "174", "post-count-month-202403", "5");
INSERT INTO `wp_postmeta` VALUES("4597", "157", "post-count-week-202412", "4");
INSERT INTO `wp_postmeta` VALUES("4598", "159", "post-count-week-202412", "3");
INSERT INTO `wp_postmeta` VALUES("4599", "159", "post-count-month-202403", "3");
INSERT INTO `wp_postmeta` VALUES("4600", "159", "post-count-year-2024", "4");
INSERT INTO `wp_postmeta` VALUES("4601", "178", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4602", "178", "post-count-month-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4603", "176", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4604", "176", "post-count-month-202403", "2");
INSERT INTO `wp_postmeta` VALUES("4605", "146", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4606", "146", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4607", "146", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4608", "194", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4609", "194", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4610", "194", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4611", "203", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4612", "203", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4613", "203", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4614", "763", "post-count-week-202412", "4");
INSERT INTO `wp_postmeta` VALUES("4615", "222", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4616", "222", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4617", "222", "post-count-year-2024", "5");
INSERT INTO `wp_postmeta` VALUES("4618", "182", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4619", "182", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4620", "182", "post-count-year-2024", "2");
INSERT INTO `wp_postmeta` VALUES("4621", "764", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4622", "764", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4623", "223", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4624", "223", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4625", "223", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4626", "477", "post-count-week-202412", "1");
INSERT INTO `wp_postmeta` VALUES("4627", "477", "post-count-month-202403", "1");
INSERT INTO `wp_postmeta` VALUES("4628", "477", "post-count-year-2024", "3");
INSERT INTO `wp_postmeta` VALUES("4629", "765", "post-count-week-202412", "6");
INSERT INTO `wp_postmeta` VALUES("4630", "766", "post-count-week-202412", "2");
INSERT INTO `wp_postmeta` VALUES("4631", "148", "post-count-week-202413", "1");
INSERT INTO `wp_postmeta` VALUES("4632", "172", "post-count-week-202413", "1");
INSERT INTO `wp_postmeta` VALUES("4633", "1206", "post-count-week-202414", "1");
INSERT INTO `wp_postmeta` VALUES("4634", "1206", "post-count-month-202404", "12");
INSERT INTO `wp_postmeta` VALUES("4635", "172", "post-count-week-202414", "1");
INSERT INTO `wp_postmeta` VALUES("4636", "172", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4637", "477", "post-count-week-202414", "2");
INSERT INTO `wp_postmeta` VALUES("4638", "477", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4639", "765", "post-count-week-202415", "4");
INSERT INTO `wp_postmeta` VALUES("4640", "765", "post-count-month-202404", "6");
INSERT INTO `wp_postmeta` VALUES("4641", "476", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4642", "476", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4643", "476", "post-count-year-2024", "5");
INSERT INTO `wp_postmeta` VALUES("4644", "666", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4645", "666", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4646", "666", "post-count-year-2024", "2");
INSERT INTO `wp_postmeta` VALUES("4647", "290", "post-count-week-202415", "2");
INSERT INTO `wp_postmeta` VALUES("4648", "290", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4649", "1206", "post-count-week-202415", "3");
INSERT INTO `wp_postmeta` VALUES("4650", "148", "post-count-week-202415", "2");
INSERT INTO `wp_postmeta` VALUES("4651", "148", "post-count-month-202404", "8");
INSERT INTO `wp_postmeta` VALUES("4652", "763", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4653", "763", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4654", "394", "_oembed_539f6a15143687b5b8e71347f79a89c9", "<iframe title=\"Alok &amp; Sevenn - The Wall (Official Music Video)\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/Qs1IQAdp-60?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4655", "394", "_oembed_time_539f6a15143687b5b8e71347f79a89c9", "1712676688");
INSERT INTO `wp_postmeta` VALUES("4656", "222", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4657", "222", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4658", "1185", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4659", "1185", "post-count-month-202404", "4");
INSERT INTO `wp_postmeta` VALUES("4660", "766", "post-count-week-202415", "1");
INSERT INTO `wp_postmeta` VALUES("4661", "766", "post-count-month-202404", "4");
INSERT INTO `wp_postmeta` VALUES("4662", "766", "post-count-week-202416", "2");
INSERT INTO `wp_postmeta` VALUES("4663", "157", "post-count-week-202416", "1");
INSERT INTO `wp_postmeta` VALUES("4664", "157", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4665", "763", "post-count-week-202416", "1");
INSERT INTO `wp_postmeta` VALUES("4666", "222", "post-count-week-202416", "1");
INSERT INTO `wp_postmeta` VALUES("4667", "1185", "post-count-week-202416", "1");
INSERT INTO `wp_postmeta` VALUES("4668", "764", "post-count-week-202417", "1");
INSERT INTO `wp_postmeta` VALUES("4669", "764", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4670", "1206", "post-count-week-202417", "1");
INSERT INTO `wp_postmeta` VALUES("4671", "1206", "post-count-week-202418", "7");
INSERT INTO `wp_postmeta` VALUES("4672", "148", "post-count-week-202418", "7");
INSERT INTO `wp_postmeta` VALUES("4673", "480", "post-count-week-202418", "4");
INSERT INTO `wp_postmeta` VALUES("4674", "480", "post-count-month-202404", "4");
INSERT INTO `wp_postmeta` VALUES("4675", "765", "post-count-week-202418", "2");
INSERT INTO `wp_postmeta` VALUES("4676", "766", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4677", "1185", "post-count-week-202418", "2");
INSERT INTO `wp_postmeta` VALUES("4678", "182", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4679", "182", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4680", "172", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4681", "174", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4682", "174", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4683", "178", "post-count-week-202418", "2");
INSERT INTO `wp_postmeta` VALUES("4684", "178", "post-count-month-202404", "2");
INSERT INTO `wp_postmeta` VALUES("4685", "237", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4686", "237", "post-count-month-202404", "1");
INSERT INTO `wp_postmeta` VALUES("4687", "469", "post-count-week-202418", "1");
INSERT INTO `wp_postmeta` VALUES("4688", "469", "post-count-month-202405", "2");
INSERT INTO `wp_postmeta` VALUES("4689", "469", "post-count-year-2024", "4");
INSERT INTO `wp_postmeta` VALUES("4690", "148", "post-count-month-202405", "4");
INSERT INTO `wp_postmeta` VALUES("4691", "1185", "post-count-week-202419", "1");
INSERT INTO `wp_postmeta` VALUES("4692", "1185", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4693", "172", "post-count-week-202419", "1");
INSERT INTO `wp_postmeta` VALUES("4694", "172", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4695", "765", "post-count-week-202419", "2");
INSERT INTO `wp_postmeta` VALUES("4696", "765", "post-count-month-202405", "3");
INSERT INTO `wp_postmeta` VALUES("4697", "763", "post-count-week-202419", "2");
INSERT INTO `wp_postmeta` VALUES("4698", "763", "post-count-month-202405", "4");
INSERT INTO `wp_postmeta` VALUES("4699", "1206", "post-count-week-202419", "5");
INSERT INTO `wp_postmeta` VALUES("4700", "1206", "post-count-month-202405", "9");
INSERT INTO `wp_postmeta` VALUES("4701", "148", "post-count-week-202419", "2");
INSERT INTO `wp_postmeta` VALUES("4702", "178", "post-count-week-202419", "1");
INSERT INTO `wp_postmeta` VALUES("4703", "178", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4704", "222", "post-count-week-202419", "1");
INSERT INTO `wp_postmeta` VALUES("4705", "222", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4706", "1206", "post-count-week-202420", "3");
INSERT INTO `wp_postmeta` VALUES("4707", "469", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4708", "766", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4709", "766", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4710", "476", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4711", "476", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4712", "765", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4713", "666", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4714", "666", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4715", "763", "post-count-week-202420", "1");
INSERT INTO `wp_postmeta` VALUES("4716", "174", "post-count-week-202421", "1");
INSERT INTO `wp_postmeta` VALUES("4717", "174", "post-count-month-202405", "1");
INSERT INTO `wp_postmeta` VALUES("4718", "1206", "post-count-week-202422", "2");
INSERT INTO `wp_postmeta` VALUES("4719", "148", "post-count-week-202422", "1");
INSERT INTO `wp_postmeta` VALUES("4720", "763", "post-count-week-202422", "1");
INSERT INTO `wp_postmeta` VALUES("4721", "1206", "post-count-month-202406", "13");
INSERT INTO `wp_postmeta` VALUES("4722", "469", "post-count-week-202422", "1");
INSERT INTO `wp_postmeta` VALUES("4723", "469", "post-count-month-202406", "2");
INSERT INTO `wp_postmeta` VALUES("4724", "148", "post-count-week-202423", "5");
INSERT INTO `wp_postmeta` VALUES("4725", "148", "post-count-month-202406", "7");
INSERT INTO `wp_postmeta` VALUES("4726", "1206", "post-count-week-202423", "8");
INSERT INTO `wp_postmeta` VALUES("4727", "1185", "post-count-week-202423", "4");
INSERT INTO `wp_postmeta` VALUES("4728", "1185", "post-count-month-202406", "4");
INSERT INTO `wp_postmeta` VALUES("4729", "766", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4730", "766", "post-count-month-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4731", "480", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4732", "480", "post-count-month-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4733", "764", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4734", "764", "post-count-month-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4735", "172", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4736", "172", "post-count-month-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4737", "763", "post-count-week-202423", "2");
INSERT INTO `wp_postmeta` VALUES("4738", "763", "post-count-month-202406", "2");
INSERT INTO `wp_postmeta` VALUES("4739", "222", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4740", "222", "post-count-month-202406", "1");
INSERT INTO `wp_postmeta` VALUES("4741", "469", "post-count-week-202423", "1");
INSERT INTO `wp_postmeta` VALUES("4742", "1206", "post-count-week-202424", "4");
INSERT INTO `wp_postmeta` VALUES("4743", "148", "post-count-week-202424", "2");
INSERT INTO `wp_postmeta` VALUES("4744", "176", "post-count-week-202424", "2");
INSERT INTO `wp_postmeta` VALUES("4745", "176", "post-count-month-202406", "2");
INSERT INTO `wp_postmeta` VALUES("4746", "765", "post-count-week-202427", "1");
INSERT INTO `wp_postmeta` VALUES("4747", "765", "post-count-month-202407", "5");
INSERT INTO `wp_postmeta` VALUES("4748", "476", "post-count-week-202427", "1");
INSERT INTO `wp_postmeta` VALUES("4749", "476", "post-count-month-202407", "2");
INSERT INTO `wp_postmeta` VALUES("4750", "1206", "post-count-week-202427", "1");
INSERT INTO `wp_postmeta` VALUES("4751", "1206", "post-count-month-202407", "8");
INSERT INTO `wp_postmeta` VALUES("4752", "148", "post-count-week-202427", "1");
INSERT INTO `wp_postmeta` VALUES("4753", "148", "post-count-month-202407", "3");
INSERT INTO `wp_postmeta` VALUES("4754", "766", "post-count-week-202428", "3");
INSERT INTO `wp_postmeta` VALUES("4755", "766", "post-count-month-202407", "3");
INSERT INTO `wp_postmeta` VALUES("4756", "764", "post-count-week-202428", "2");
INSERT INTO `wp_postmeta` VALUES("4757", "764", "post-count-month-202407", "2");
INSERT INTO `wp_postmeta` VALUES("4758", "765", "post-count-week-202428", "4");
INSERT INTO `wp_postmeta` VALUES("4759", "1206", "post-count-week-202428", "6");
INSERT INTO `wp_postmeta` VALUES("4760", "148", "post-count-week-202428", "2");
INSERT INTO `wp_postmeta` VALUES("4761", "190", "post-count-week-202428", "1");
INSERT INTO `wp_postmeta` VALUES("4762", "190", "post-count-month-202407", "1");
INSERT INTO `wp_postmeta` VALUES("4763", "190", "post-count-year-2024", "1");
INSERT INTO `wp_postmeta` VALUES("4764", "178", "post-count-week-202428", "1");
INSERT INTO `wp_postmeta` VALUES("4765", "178", "post-count-month-202407", "1");
INSERT INTO `wp_postmeta` VALUES("4766", "1185", "post-count-week-202428", "2");
INSERT INTO `wp_postmeta` VALUES("4767", "1185", "post-count-month-202407", "2");
INSERT INTO `wp_postmeta` VALUES("4768", "476", "post-count-week-202428", "1");
INSERT INTO `wp_postmeta` VALUES("4769", "176", "post-count-week-202429", "1");
INSERT INTO `wp_postmeta` VALUES("4770", "176", "post-count-month-202407", "1");
INSERT INTO `wp_postmeta` VALUES("4771", "1206", "post-count-week-202430", "1");
INSERT INTO `wp_postmeta` VALUES("4772", "159", "post-count-week-202431", "1");
INSERT INTO `wp_postmeta` VALUES("4773", "159", "post-count-month-202407", "1");
INSERT INTO `wp_postmeta` VALUES("4774", "765", "post-count-week-202431", "2");
INSERT INTO `wp_postmeta` VALUES("4775", "765", "post-count-month-202408", "3");
INSERT INTO `wp_postmeta` VALUES("4776", "764", "post-count-week-202432", "1");
INSERT INTO `wp_postmeta` VALUES("4777", "764", "post-count-month-202408", "2");
INSERT INTO `wp_postmeta` VALUES("4778", "766", "post-count-week-202432", "1");
INSERT INTO `wp_postmeta` VALUES("4779", "766", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4780", "476", "post-count-week-202432", "1");
INSERT INTO `wp_postmeta` VALUES("4781", "476", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4782", "1206", "post-count-week-202432", "1");
INSERT INTO `wp_postmeta` VALUES("4783", "1206", "post-count-month-202408", "4");
INSERT INTO `wp_postmeta` VALUES("4784", "480", "post-count-week-202432", "1");
INSERT INTO `wp_postmeta` VALUES("4785", "480", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4786", "178", "post-count-week-202433", "1");
INSERT INTO `wp_postmeta` VALUES("4787", "178", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4788", "764", "post-count-week-202433", "1");
INSERT INTO `wp_postmeta` VALUES("4789", "1206", "post-count-week-202433", "2");
INSERT INTO `wp_postmeta` VALUES("4790", "148", "post-count-week-202433", "4");
INSERT INTO `wp_postmeta` VALUES("4791", "148", "post-count-month-202408", "4");
INSERT INTO `wp_postmeta` VALUES("4792", "763", "post-count-week-202433", "1");
INSERT INTO `wp_postmeta` VALUES("4793", "763", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4794", "172", "post-count-week-202433", "1");
INSERT INTO `wp_postmeta` VALUES("4795", "172", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4796", "765", "post-count-week-202433", "1");
INSERT INTO `wp_postmeta` VALUES("4797", "1206", "post-count-week-202434", "1");
INSERT INTO `wp_postmeta` VALUES("4798", "1185", "post-count-week-202434", "1");
INSERT INTO `wp_postmeta` VALUES("4799", "1185", "post-count-month-202408", "1");
INSERT INTO `wp_postmeta` VALUES("4800", "176", "post-count-week-202435", "1");
INSERT INTO `wp_postmeta` VALUES("4801", "176", "post-count-month-202408", "1");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("3", "1", "2022-01-01 16:11:17", "2022-01-01 12:41:17", "<!-- wp:heading --><h2>ما که هستیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>نشانی وب‌سایت ما: https://themes.wpnovin.com/Waveme.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>رسانه</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>کوکی‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ترک کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر شما انتخاب کنید &quot; به یاد داشته باشید من Me&quot;، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما یک تنظیم دوباره رمز عبور را درخواست دادید، نشانی IP شما در ایمیل تنظیم دوباره وجود خواهد داشت.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر یک نظر را ترک کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم به جای برگزاری آنها در یک خط مؤثر، به طور خودکار هر نظر پیگیری را تصدیق و تأیید کنیم.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>حقوقی که بر روی داده‌هایتان دارید</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر در این سایت حساب کاربری دارید یا نظرها را ترک کرده اید، می‌توانید درخواست دریافت یک فایل صادر شده از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هر گونه داده‌ای که برای ما ارائه کرده اید. همچنین می‌توانید درخواست کنید که ما هر گونه اطلاعات شخصی که در مورد شما نگه داریم پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>داده‌های شما را به کجا ارسال می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p><!-- /wp:paragraph -->", "سیاست حریم خصوصی", "", "publish", "closed", "closed", "", "%d8%b3%db%8c%d8%a7%d8%b3%d8%aa-%d8%ad%d9%81%d8%b8-%d8%ad%d8%b1%db%8c%d9%85-%d8%ae%d8%b5%d9%88%d8%b5%db%8c", "", "", "2022-01-02 00:44:56", "2022-01-01 21:14:56", "", "0", "https://themes.wpnovin.com/Waveme/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2019-06-26 00:52:07", "2019-06-26 00:52:07", "<!-- wp:block/loop {\"type\":\"station\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"cols\":4,\"gap\":24} /-->\n\n<!-- wp:cover {\"customOverlayColor\":\"#121416\"} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-color:#121416\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"has-text-align-center\"><strong>به هم ترانه سلام کنید!</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"w-50 m-auto\"} -->\n<p class=\"has-text-align-center w-50 m-auto\"><meta charset=\"utf-8\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"color\":{\"background\":\"#ffffff\"}},\"className\":\"text-primary\"} -->\n<div class=\"wp-block-button aligncenter text-primary\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" href=\"http://wpnovin.com/shop\" style=\"background-color:#ffffff\">خرید قالب از نوین وردپرس</a></div>\n<!-- /wp:button --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>ویژه ها</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"pages\":7} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>رادیو هم ترانه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"pages\":7,\"className\":\"block-loop-hover\"} /-->", "انتخاب", "", "publish", "closed", "closed", "", "browse", "", "", "2022-01-02 00:25:07", "2022-01-01 20:55:07", "", "0", "http://music.flatfull.com/waveme/?page_id=7", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2019-06-26 00:52:23", "2019-06-26 00:52:23", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>محبوب ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین کاربران</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "صفحه اصلی", "", "publish", "closed", "closed", "", "discover", "", "", "2022-01-01 17:19:07", "2022-01-01 13:49:07", "", "0", "http://music.flatfull.com/waveme/?page_id=9", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2019-06-26 00:52:37", "2019-06-26 00:52:37", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-all\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دار ها", "", "publish", "closed", "closed", "", "charts", "", "", "2022-01-02 00:25:58", "2022-01-01 20:55:58", "", "0", "http://music.flatfull.com/waveme/?page_id=11", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2019-06-26 00:52:45", "2019-06-26 00:52:45", "<!-- wp:block/loop {\"type\":\"post\",\"template\":\"templates/content/content-loop-post.php\",\"cols\":3,\"pages\":3,\"className\":\"row-md post-thumbnail-16x9\"} /-->\r\n<p>&nbsp;</p>\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>جدید ترین ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"post\",\"template\":\"templates/loop-post-excerpt.php\",\"className\":\"block-loop-row block-loop-lg post-thumbnail-16x9 entry-title-lg \"} /-->", "وبلاگ", "", "publish", "closed", "closed", "", "blog", "", "", "2022-01-01 17:27:39", "2022-01-01 13:57:39", "", "0", "http://music.flatfull.com/waveme/?page_id=13", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2019-06-26 00:53:22", "2019-06-26 00:53:22", "<!-- wp:block/loop {\"type\":\"station\",\"template\":\"templates/content/content-loop-post.php\",\"slider\":true,\"sliderOption\":\"\",\"cols\":3,\"className\":\"post-thumbnail-16x9\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>آهنگ جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"\",\"orderby\":\"date\",\"order\":\"DESC\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"debug\":false,\"className\":\"block-loop-hover\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>رادیو جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"orderby\":\"date\",\"order\":\"DESC\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"debug\":false} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>پلی لیست جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=playlist\",\"orderby\":\"date\",\"template\":\"templates/content/content-loop.php\",\"pages\":5} /-->", "جدید ترین ها", "", "publish", "closed", "closed", "", "new-release", "", "", "2022-01-02 00:52:13", "2022-01-01 21:22:13", "", "10", "http://music.flatfull.com/waveme/?page_id=15", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2019-06-26 00:53:55", "2019-06-26 00:53:55", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"template\":\"templates/content/content-loop.php\",\"pages\":10,\"pager\":\"pagination\"} /-->", "موزیک", "", "publish", "closed", "closed", "", "audio", "", "", "2022-01-02 00:52:37", "2022-01-01 21:22:37", "", "10", "http://music.flatfull.com/waveme/?page_id=17", "1", "page", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2019-06-26 00:54:06", "2019-06-25 20:24:06", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"template\":\"templates/content/content-loop.php\",\"pages\":10,\"pager\":\"more\"} /-->", "رادیو", "", "publish", "closed", "closed", "", "radio", "", "", "2022-01-02 00:52:51", "2022-01-01 21:22:51", "", "10", "http://music.flatfull.com/waveme/?page_id=19", "3", "page", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2019-06-26 00:54:20", "2019-06-26 00:54:20", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:podcast\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":12,\"pager\":\"more\"} /-->", "پادکست", "", "publish", "closed", "closed", "", "podcasts", "", "", "2022-01-02 00:52:48", "2022-01-01 21:22:48", "", "10", "http://music.flatfull.com/waveme/?page_id=21", "2", "page", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2019-06-26 00:54:38", "2019-06-25 20:24:38", "<!-- wp:heading {\"level\":3} -->\n<h3>Music genre</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"taxonomy\",\"taxonomy\":\"genre\",\"query\":\"parent=14\",\"template\":\"templates/content/content-loop-taxonomy.php\",\"pages\":30,\"className\":\"block-loop-overlay block-loop-overlay-center  post-thumbnail-16x9\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Podcast genre</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"taxonomy\",\"taxonomy\":\"genre\",\"query\":\"parent=16\",\"template\":\"templates/content/content-loop-taxonomy.php\",\"className\":\"block-loop-overlay block-loop-overlay-center  post-thumbnail-16x9\"} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "ژانر", "", "publish", "closed", "closed", "", "genre", "", "", "2022-01-02 00:53:03", "2022-01-01 21:23:03", "", "10", "http://music.flatfull.com/waveme/?page_id=23", "6", "page", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2019-06-26 00:54:53", "2019-06-25 20:24:53", "<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=album\",\"template\":\"templates/content/content-loop.php\"} /-->", "آلبوم", "", "publish", "closed", "closed", "", "album", "", "", "2022-01-02 00:52:57", "2022-01-01 21:22:57", "", "10", "http://music.flatfull.com/waveme/?page_id=25", "4", "page", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2019-06-26 01:00:03", "2019-06-26 01:00:03", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-month-\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دارهای ماه", "", "publish", "closed", "closed", "", "monthly-top-charts", "", "", "2022-01-02 00:26:11", "2022-01-01 20:56:11", "", "12", "http://music.flatfull.com/waveme/?page_id=31", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2019-06-26 01:00:19", "2019-06-25 20:30:19", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-week-\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دارهای هفته", "", "publish", "closed", "closed", "", "weekly-top-chart", "", "", "2022-01-02 00:26:15", "2022-01-01 20:56:15", "", "12", "http://music.flatfull.com/waveme/?page_id=33", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2019-06-26 01:03:53", "2019-06-25 20:33:53", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#121416\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#121416\"><!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"l-h-3\"} -->\n<div class=\"wp-block-columns l-h-3\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">دسترسی سریع</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\">خرید هم ترانه</a></li><li><a href=\"http://music.flatfull.com/docs\">مستندات قالب</a></li><li><a href=\"http://flatfull.com\" data-type=\"URL\" data-id=\"http://flatfull.com\">دریافت پشتیبانی</a></li><li><a href=\"https://themeforest.net/collections/8004334-wordpress-music-theme\">قالب های بیشتر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">شروع کنید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#\">لیست آهنگ ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/radio-playlist/\">ایستگاه های راد</a>یو</li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/icecast/\">اینکست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\" data-type=\"URL\" data-id=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\">شات کست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/mtv-youtube-video-and-music/\">موزیک ویدئو</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/category/press/\">پرس ها</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">حساب کاربری</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/login/?action=register\">عضویت</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/contact/\">درخواست تایید</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/login\">شروع آپلود</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">درباره</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/contact/\">تماس با ما</a></li><li><a href=\"http://music.flatfull.com/waveme/terms/\">قوانین و مقررات</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:social-links {\"align\":\"right\",\"className\":\"no-float-sm\"} -->\n<ul class=\"wp-block-social-links alignright no-float-sm\"><!-- wp:social-link {\"url\":\"https://twitter.com/soundwave\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://facebook.com/soundwave\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"linkedin\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://youtube.com/soundwave\",\"service\":\"youtube\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"fivehundredpx\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"http://instgram.com/aa\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:14px\"><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"normal\"} -->\n<p class=\"has-text-color has-normal-font-size\" style=\"color:#888888\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر", "", "publish", "closed", "closed", "", "footer", "", "", "2022-01-02 02:05:10", "2022-01-01 22:35:10", "", "0", "http://music.flatfull.com/waveme/?page_id=35", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2019-06-26 01:05:12", "2019-06-26 01:05:12", "<!-- wp:cover {\"customOverlayColor\":\"#121416\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim h-auto\" style=\"background-color:#121416\"><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"w-75 m-auto\"} -->\n<h3 class=\"has-text-align-center w-75 m-auto\"><strong>دنبال کردن خواننده</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#cccccc\"}},\"className\":\"w-75 m-auto\"} -->\n<p class=\"has-text-align-center w-75 m-auto has-text-color\" style=\"color:#cccccc\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"very-light-gray\",\"textColor\":\"very-dark-gray\",\"align\":\"center\",\"className\":\"btn-sm btn-primary\"} -->\n<div class=\"wp-block-button aligncenter btn-sm btn-primary\"><a class=\"wp-block-button__link has-very-dark-gray-color has-very-light-gray-background-color has-text-color has-background\" href=\"#\">دنبال کنید...</a></div>\n<!-- /wp:button -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:11px\">تبلیغات توسط نوین وردپرس</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:cover {\"gradient\":\"vivid-cyan-blue-to-vivid-purple\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim has-background-gradient has-vivid-cyan-blue-to-vivid-purple-gradient-background h-auto\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#fefefe\"}},\"className\":\"no-margin\"} -->\n<p class=\"has-text-align-center no-margin has-text-color\" style=\"color:#fefefe\">بهترین قالب موزیک و ویدئو و البوم در ایران</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "سایدبار", "", "publish", "closed", "closed", "", "sidebar", "", "", "2022-01-02 00:47:44", "2022-01-01 21:17:44", "", "0", "http://music.flatfull.com/waveme/?page_id=39", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2019-06-26 01:05:35", "2019-06-25 20:35:35", "<!-- wp:shortcode -->\n[play_login_form]\n<!-- /wp:shortcode -->", "ورود", "", "publish", "closed", "closed", "", "login", "", "", "2022-01-02 00:43:07", "2022-01-01 21:13:07", "", "0", "http://music.flatfull.com/waveme/?page_id=41", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2019-06-26 01:06:39", "2019-06-26 01:06:39", "<!-- wp:block/loop {\"title\":\"16x9\",\"type\":\"station\",\"cols\":3,\"pages\":3,\"className\":\"post-thumbnail-16x9\"} /-->\n\n<!-- wp:block/loop {\"title\":\"21x9\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":2,\"pages\":2,\"className\":\"post-thumbnail-21x9\"} /-->\n\n<!-- wp:block/loop {\"title\":\"4x3\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":3,\"pages\":3,\"className\":\"post-thumbnail-4x3\"} /-->", "تصویر شاخص", "", "publish", "closed", "closed", "", "thumbnail", "", "", "2022-01-02 00:51:09", "2022-01-01 21:21:09", "", "0", "http://music.flatfull.com/waveme/?page_id=43", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2019-06-27 07:30:55", "2019-06-27 07:30:55", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block/loop {\"title\":\"دو ستونه\",\"type\":\"station\",\"cols\":2,\"pages\":2} /-->\n\n<!-- wp:block/loop {\"title\":\"سه ستونه\",\"type\":\"station\",\"orderby\":\"title\",\"cols\":3,\"pages\":3} /-->\n\n<!-- wp:block/loop {\"title\":\"جهار ستونه\",\"type\":\"station\",\"orderby\":\"title\",\"order\":\"ASC\",\"cols\":4,\"pages\":4} /-->\n\n<!-- wp:block/loop {\"title\":\"پنج ستونه\",\"type\":\"station\",\"cols\":5,\"pages\":5} /-->\n\n<!-- wp:block/loop {\"title\":\"شش ستونه\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":6} /-->", "ستون ها", "", "publish", "closed", "closed", "", "columns", "", "", "2022-01-02 00:27:02", "2022-01-01 20:57:02", "", "0", "http://music.flatfull.com/waveme/?page_id=130", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2019-06-27 07:32:11", "2019-06-27 07:32:11", "<!-- wp:block/loop {\"title\":\"پازلی\",\"type\":\"station\",\"cols\":5,\"pages\":5} /-->\n\n<!-- wp:block/loop {\"title\":\"لیستی\",\"type\":\"station\",\"cols\":1,\"pages\":2,\"className\":\"block-loop-row block-loop-index\"} /-->\n\n<!-- wp:block/loop {\"title\":\"لیست کوچک\",\"type\":\"station\",\"cols\":2,\"pages\":4,\"className\":\"block-loop-row block-loop-sm\"} /-->\n\n<!-- wp:block/loop {\"title\":\"لیست کوچک ویژه\",\"type\":\"station\",\"cols\":2,\"pages\":4,\"className\":\"block-loop-row block-loop-xs\"} /-->", "پازلی و لیستی", "", "publish", "closed", "closed", "", "grid-list-style", "", "", "2022-01-02 00:35:29", "2022-01-01 21:05:29", "", "0", "http://music.flatfull.com/waveme/?page_id=132", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2019-06-27 14:54:28", "2019-06-27 10:24:28", "", "بنشین با ناز در کنج دلم خانه کن", "", "publish", "open", "closed", "", "shallow", "", "", "2022-01-02 01:45:21", "2022-01-01 22:15:21", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=145", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("146", "1", "2019-06-27 15:33:13", "2019-06-27 11:03:13", "", "سینا مهدوی چشمان تو", "", "publish", "open", "closed", "", "taki-taki", "", "", "2022-01-02 01:45:13", "2022-01-01 22:15:13", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=146", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("148", "1", "2019-06-27 15:41:37", "2019-06-27 11:11:37", "", "کم کم ولیم بریدن", "", "publish", "open", "closed", "", "promises", "", "", "2022-01-02 01:45:05", "2022-01-01 22:15:05", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=148", "0", "station", "", "1");
INSERT INTO `wp_posts` VALUES("155", "1", "2019-06-28 06:32:31", "2019-06-28 02:02:31", "", "رفتن تو می ارزه به اومدن خیلیا", "", "publish", "open", "closed", "", "be-alright", "", "", "2022-01-02 01:44:58", "2022-01-01 22:14:58", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=155", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2019-06-28 06:50:59", "2019-06-28 02:20:59", "", "احمد سلو عاشقم", "", "publish", "open", "closed", "", "in-my-mind", "", "", "2022-01-02 01:44:47", "2022-01-01 22:14:47", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=156", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2019-06-28 06:53:21", "2019-06-28 02:23:21", "", "مه سرگشته پریشانم", "", "publish", "open", "closed", "", "without-me", "", "", "2022-01-02 01:44:41", "2022-01-01 22:14:41", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=157", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2019-06-28 07:50:00", "2019-06-28 03:20:00", "", "عزیز بشینه کنارم حجت اشرف زاده", "", "publish", "open", "closed", "", "natural", "", "", "2022-01-02 01:25:50", "2022-01-01 21:55:50", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=159", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("169", "1", "2019-06-28 11:36:40", "2019-06-28 07:06:40", "", "امین بانی دل منم خدایی داره", "", "publish", "open", "closed", "", "high-hopes", "", "", "2022-01-02 01:25:57", "2022-01-01 21:55:57", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=169", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("172", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "فاضل صفوی بن بست", "", "publish", "open", "closed", "", "happier", "", "", "2022-01-02 01:42:36", "2022-01-01 22:12:36", "", "0", "http://music.flatfull.com/waveme/station/happier/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("174", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "ایمان بیک نژاد اتمسفر", "", "publish", "open", "closed", "", "thunderclouds", "", "", "2022-01-02 01:24:36", "2022-01-01 21:54:36", "", "0", "http://music.flatfull.com/waveme/station/thunderclouds/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("176", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "افشین آذری هامی بيزدن دانيشير", "", "publish", "open", "closed", "", "girls-like-you", "", "", "2022-01-02 01:42:45", "2022-01-01 22:12:45", "", "0", "http://music.flatfull.com/waveme/station/girls-like-you/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("178", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "بهروز لطفی میوه ی ممنوعه", "", "publish", "open", "closed", "", "mia", "", "", "2022-01-02 01:42:51", "2022-01-01 22:12:51", "", "0", "http://music.flatfull.com/waveme/station/mia/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("180", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "رضا بهرام عاشقی ممنوع", "", "publish", "open", "closed", "", "sunflower-spider-man-into-the-spider-verse", "", "", "2022-01-02 01:43:07", "2022-01-01 22:13:07", "", "0", "http://music.flatfull.com/waveme/station/sunflower-spider-man-into-the-spider-verse/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("182", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "محمد طاهری زاده عشق مجازی", "", "publish", "closed", "closed", "", "collection", "", "", "2022-01-02 01:27:07", "2022-01-01 21:57:07", "", "0", "http://music.flatfull.com/waveme/station/collection/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("186", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "متیار گمت کردم", "", "publish", "open", "closed", "", "eastside", "", "", "2022-01-02 01:27:01", "2022-01-01 21:57:01", "", "0", "http://music.flatfull.com/waveme/station/eastside/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("188", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "مهدی مهداد بازم تنها", "", "publish", "closed", "closed", "", "later-bitches", "", "", "2022-01-02 01:43:24", "2022-01-01 22:13:24", "", "0", "http://music.flatfull.com/waveme/station/later-bitches/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("190", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "مهرداد فلاحتی زندگیمی تو", "", "publish", "open", "closed", "", "sign-of-the-times", "", "", "2022-01-02 01:43:29", "2022-01-01 22:13:29", "", "0", "http://music.flatfull.com/waveme/station/zeze/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("192", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "امین تیرزاد اگه میدونستم", "", "publish", "open", "closed", "", "youngblood", "", "", "2022-01-02 01:26:40", "2022-01-01 21:56:40", "", "0", "http://music.flatfull.com/waveme/station/youngblood/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("194", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "نم نم خیس بشم آروم کم کم", "", "publish", "open", "closed", "", "let-you-love-me", "", "", "2022-01-02 01:42:15", "2022-01-01 22:12:15", "", "0", "http://music.flatfull.com/waveme/station/let-you-love-me/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("196", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "امو بند همدم", "", "publish", "open", "closed", "", "woman-like-me", "", "", "2022-01-02 01:43:45", "2022-01-01 22:13:45", "", "0", "http://music.flatfull.com/waveme/station/woman-like-me/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("198", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "ویحک رویای من", "", "publish", "open", "closed", "", "body", "", "", "2022-01-02 01:26:20", "2022-01-01 21:56:20", "", "0", "http://music.flatfull.com/waveme/station/body/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("200", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "کامی یوسفی كارما", "", "publish", "open", "closed", "", "wake-up-in-the-sky", "", "", "2022-01-02 01:44:02", "2022-01-01 22:14:02", "", "0", "http://music.flatfull.com/waveme/station/wake-up-in-the-sky/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("203", "1", "2019-06-29 09:32:26", "2019-06-29 05:02:26", "", "احسان عالی رفیق", "", "publish", "open", "closed", "", "10-freaky-girls", "", "", "2022-01-02 01:23:59", "2022-01-01 21:53:59", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=203", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("204", "1", "2019-06-29 09:35:33", "2019-06-29 05:05:33", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "مهدی صالحی هفت خط", "", "publish", "open", "closed", "", "dance-wave-retro", "", "", "2022-01-02 01:38:32", "2022-01-01 22:08:32", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=204", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("215", "1", "2019-06-29 09:58:24", "2019-06-29 05:28:24", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "محمد میرزایی برگرد", "", "publish", "open", "closed", "", "1000-hits-country", "", "", "2022-01-02 01:38:24", "2022-01-01 22:08:24", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=215", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("216", "1", "2019-06-29 10:02:25", "2019-06-29 05:32:25", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "یونس ایکان نقاشی", "", "publish", "open", "closed", "", "top-fm-comedy", "", "", "2022-01-02 01:38:19", "2022-01-01 22:08:19", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=216", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("217", "1", "2019-06-29 10:03:57", "2019-06-29 05:33:57", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "سینا واله حال و هوا", "", "publish", "open", "closed", "", "free-radio-provo", "", "", "2022-01-02 01:38:11", "2022-01-01 22:08:11", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=217", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("218", "1", "2019-06-29 10:05:13", "2019-06-29 05:35:13", "<!-- wp:paragraph -->\n<p><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong></p>\n<!-- /wp:paragraph -->", "بمب ساعتی امیر رمضانی", "", "publish", "open", "closed", "", "maxi-80-webradio-france", "", "", "2022-01-02 01:38:08", "2022-01-01 22:08:08", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=218", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("220", "1", "2019-06-29 10:13:23", "2019-06-29 05:43:23", "<!-- wp:paragraph -->\n<p><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "علیرضا رئوف تو کجایی", "", "publish", "open", "closed", "", "radio-musical", "", "", "2022-01-02 01:37:58", "2022-01-01 22:07:58", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=220", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("221", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "محمود شیخ زاده دلبر خاص", "", "publish", "closed", "closed", "", "radio-siebenbuergen", "", "", "2022-01-02 01:44:07", "2022-01-01 22:14:07", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=221", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("222", "1", "2019-06-29 00:00:00", "2019-06-29 00:00:00", "<!-- wp:paragraph -->\r\n<p><em>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</em></p>\r\n<!-- /wp:paragraph -->", "محسن یگانه - بیت آخر", "", "private", "closed", "closed", "", "blues-radio-uk", "", "", "2022-01-02 01:47:14", "2022-01-01 22:17:14", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=222", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2019-06-29 10:19:35", "2019-06-29 05:49:35", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "محمد شهریاری تمنا", "", "publish", "open", "closed", "", "radio-romania-actualitati", "", "", "2022-01-02 01:37:36", "2022-01-01 22:07:36", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=223", "0", "station", "", "1");
INSERT INTO `wp_posts` VALUES("227", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "صدای بارون رضا شهریور", "", "publish", "closed", "closed", "", "a-million-dreams", "", "", "2022-01-02 01:44:13", "2022-01-01 22:14:13", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=227", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("237", "1", "2019-06-29 12:09:24", "2019-06-29 07:39:24", "", "مسعود فراهانی عاشقم", "", "publish", "open", "closed", "", "leave-a-light-on", "", "", "2022-01-02 01:23:01", "2022-01-01 21:53:01", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=237", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("242", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "", "احسان امیر اسم کوچیک", "", "publish", "open", "closed", "", "losing-it", "", "", "2022-01-02 01:42:28", "2022-01-01 22:12:28", "", "0", "http://music.flatfull.com/waveme/station/something-blue/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("282", "1", "2019-06-29 15:14:12", "2019-06-29 10:44:12", "<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=playlist\",\"template\":\"templates/content/content-loop.php\",\"pages\":12,\"pager\":\"more\"} /-->", "لیست پخش", "", "publish", "closed", "closed", "", "playlist", "", "", "2022-01-02 00:53:00", "2022-01-01 21:23:00", "", "10", "http://music.flatfull.com/waveme/?page_id=282", "5", "page", "", "0");
INSERT INTO `wp_posts` VALUES("290", "1", "2019-06-29 00:00:00", "2019-06-28 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "احسان امیر فریاد", "", "publish", "open", "closed", "", "radio-playlist", "", "", "2022-01-02 01:42:23", "2022-01-01 22:12:23", "", "0", "http://music.flatfull.com/waveme/station/playlist/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("326", "1", "2019-06-30 00:07:58", "2019-06-30 00:07:58", "<!-- wp:block/loop {\"title\":\"محبوب ترین ها\",\"type\":\"station\",\"metaQuery\":[\"waveform_data:1:EXISTS\"],\"query\":\"\",\"orderby\":\"all\",\"template\":\"templates/loop-waveform.php\",\"pages\":12,\"pager\":\"more\",\"filter\":[\"orderby::all[همه زمان ها]\",\"orderby::week[این هفته]\",\"orderby::month[این ماه]\",\"orderby::year[این سال]\",\"taxQuery::genre__[همه ٰژانر ها]\",\"taxQuery::genre__pop[پاپ]\",\"taxQuery::genre__blues[سنتی]\",\"taxQuery::genre__rock[راک]\",\"metaQuery::type__[همه]\",\"metaQuery::type__single[تک آهنگ]\",\"metaQuery::type__playlist[آلبوم]\",\"metaQuery::type__album[پلی لیست]\"],\"empty\":true,\"emptyContent\":\"چیزی یافت نشد... \\u003ca href=\\u0022javascript: window.history.go(-1);\\u0022\\u003eبازگشت به عقب\\u003c/a\\u003e\",\"debug\":false,\"className\":\"block-loop-row block-loop-index\"} /-->", "محبوب ترین ها", "", "publish", "closed", "closed", "", "popular", "", "", "2022-01-02 01:56:16", "2022-01-01 22:26:16", "", "10", "http://music.flatfull.com/waveme/?page_id=326", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("394", "1", "2019-06-30 14:14:38", "2019-06-30 14:14:38", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {\"url\":\"https://www.youtube.com/watch?v=Qs1IQAdp-60\",\"type\":\"video\",\"providerNameSlug\":\"youtube\",\"responsive\":true,\"className\":\"wp-embed-aspect-16-9 wp-has-aspect-ratio\"} -->\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\nhttps://www.youtube.com/watch?v=Qs1IQAdp-60\n</div></figure>\n<!-- /wp:embed -->", "بهترین آلبوم محمد اصفهانی", "", "publish", "open", "open", "", "alok-sevenn-drop-new-song-the-wall-recreating-the-pink-floyd-classic", "", "", "2022-01-02 01:32:47", "2022-01-01 22:02:47", "", "0", "http://music.flatfull.com/waveme/?p=394", "0", "post", "", "2");
INSERT INTO `wp_posts` VALUES("420", "1", "2019-06-30 17:57:58", "2019-06-30 17:57:58", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "آلبوم جدید سالار عقیلی در راه است...", "", "publish", "open", "open", "", "wave-racer-returns-with-lively-new-single-auto", "", "", "2022-01-02 01:32:28", "2022-01-01 22:02:28", "", "0", "http://music.flatfull.com/waveme/?p=420", "0", "post", "", "2");
INSERT INTO `wp_posts` VALUES("469", "1", "2019-07-01 00:00:00", "2019-06-30 19:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "طاها سیدی نفس", "", "publish", "open", "closed", "", "on-the-flight", "", "", "2022-01-02 01:37:21", "2022-01-01 22:07:21", "", "0", "http://music.flatfull.com/waveme/station/summer/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("476", "1", "2019-07-01 04:20:03", "2019-06-30 23:50:03", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "محمدرضا خانی چشمای تو", "", "publish", "open", "closed", "", "girls-like-you-ft-cardi-b-youtube", "", "", "2022-01-02 01:37:15", "2022-01-01 22:07:15", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=476", "0", "station", "", "2");
INSERT INTO `wp_posts` VALUES("477", "1", "2015-05-27 01:52:34", "2015-05-26 21:22:34", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "کاشکی امید افخم", "", "publish", "open", "closed", "", "soundcloud", "", "", "2022-01-02 01:45:47", "2022-01-01 22:15:47", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=477", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("480", "1", "2019-06-29 19:34:25", "2019-06-29 15:04:25", "", "سهیل درخشانی کمبود", "", "publish", "open", "closed", "", "broken", "", "", "2022-01-02 01:22:54", "2022-01-01 21:52:54", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=480", "0", "station", "", "2");
INSERT INTO `wp_posts` VALUES("500", "1", "2020-09-12 08:53:28", "2020-09-12 08:53:28", "", "Artboard 1", "", "inherit", "open", "closed", "", "artboard-1", "", "", "2020-09-12 08:53:28", "2020-09-12 08:53:28", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("501", "1", "2020-09-12 08:53:30", "2020-09-12 08:53:30", "", "Artboard 2", "", "inherit", "open", "closed", "", "artboard-2", "", "", "2020-09-12 08:53:30", "2020-09-12 08:53:30", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("502", "1", "2020-09-12 08:53:33", "2020-09-12 08:53:33", "", "Artboard 3", "", "inherit", "open", "closed", "", "artboard-3", "", "", "2020-09-12 08:53:33", "2020-09-12 08:53:33", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("503", "1", "2020-09-12 08:53:41", "2020-09-12 08:53:41", "", "Artboard 4", "", "inherit", "open", "closed", "", "artboard-4", "", "", "2020-09-12 08:53:41", "2020-09-12 08:53:41", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("504", "1", "2020-09-12 08:53:44", "2020-09-12 08:53:44", "", "Artboard 5", "", "inherit", "open", "closed", "", "artboard-5", "", "", "2020-09-12 08:53:44", "2020-09-12 08:53:44", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-5.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("505", "1", "2020-09-12 08:53:47", "2020-09-12 08:53:47", "", "Artboard 6", "", "inherit", "open", "closed", "", "artboard-6", "", "", "2020-09-12 08:53:47", "2020-09-12 08:53:47", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-6.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("506", "1", "2020-09-12 08:53:49", "2020-09-12 08:53:49", "", "Artboard 7", "", "inherit", "open", "closed", "", "artboard-7", "", "", "2020-09-12 08:53:49", "2020-09-12 08:53:49", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-7.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("507", "1", "2020-09-12 08:53:51", "2020-09-12 08:53:51", "", "Artboard 8", "", "inherit", "open", "closed", "", "artboard-8", "", "", "2020-09-12 08:53:51", "2020-09-12 08:53:51", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-8.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("508", "1", "2020-09-12 08:53:53", "2020-09-12 08:53:53", "", "Artboard 9", "", "inherit", "open", "closed", "", "artboard-9", "", "", "2020-09-12 08:53:53", "2020-09-12 08:53:53", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-9.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("509", "1", "2020-09-12 08:53:55", "2020-09-12 08:53:55", "", "Artboard 10", "", "inherit", "open", "closed", "", "artboard-10", "", "", "2020-09-12 08:53:55", "2020-09-12 08:53:55", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-10.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("510", "1", "2020-09-12 08:53:58", "2020-09-12 08:53:58", "", "Artboard 11", "", "inherit", "open", "closed", "", "artboard-11", "", "", "2020-09-12 08:53:58", "2020-09-12 08:53:58", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-11.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("511", "1", "2020-09-12 08:54:01", "2020-09-12 08:54:01", "", "Artboard 12", "", "inherit", "open", "closed", "", "artboard-12", "", "", "2020-09-12 08:54:01", "2020-09-12 08:54:01", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-12.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("512", "1", "2020-09-12 08:54:09", "2020-09-12 08:54:09", "", "Artboard 13", "", "inherit", "open", "closed", "", "artboard-13", "", "", "2020-09-12 08:54:09", "2020-09-12 08:54:09", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-13.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("513", "1", "2020-09-12 08:54:15", "2020-09-12 08:54:15", "", "Artboard 14", "", "inherit", "open", "closed", "", "artboard-14", "", "", "2020-09-12 08:54:15", "2020-09-12 08:54:15", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-14.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("514", "1", "2020-09-12 08:54:20", "2020-09-12 08:54:20", "", "Artboard 15", "", "inherit", "open", "closed", "", "artboard-15", "", "", "2020-09-12 08:54:20", "2020-09-12 08:54:20", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-15.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("515", "1", "2020-09-12 08:54:23", "2020-09-12 08:54:23", "", "Artboard 16", "", "inherit", "open", "closed", "", "artboard-16", "", "", "2020-09-12 08:54:23", "2020-09-12 08:54:23", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-16.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("516", "1", "2020-09-12 08:54:31", "2020-09-12 08:54:31", "", "Artboard 17", "", "inherit", "open", "closed", "", "artboard-17", "", "", "2020-09-12 08:54:31", "2020-09-12 08:54:31", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-17.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("517", "1", "2020-09-12 08:54:35", "2020-09-12 08:54:35", "", "Artboard 18", "", "inherit", "open", "closed", "", "artboard-18", "", "", "2020-09-12 08:54:35", "2020-09-12 08:54:35", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-18.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("518", "1", "2020-09-12 08:54:38", "2020-09-12 08:54:38", "", "Artboard 19", "", "inherit", "open", "closed", "", "artboard-19", "", "", "2020-09-12 08:54:38", "2020-09-12 08:54:38", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-19.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("519", "1", "2020-09-12 08:54:41", "2020-09-12 08:54:41", "", "Artboard 20", "", "inherit", "open", "closed", "", "artboard-20", "", "", "2020-09-12 08:54:41", "2020-09-12 08:54:41", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-20.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("520", "1", "2020-09-12 08:54:44", "2020-09-12 08:54:44", "", "Artboard 21", "", "inherit", "open", "closed", "", "artboard-21", "", "", "2020-09-12 08:54:44", "2020-09-12 08:54:44", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-21.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("521", "1", "2020-09-12 08:54:49", "2020-09-12 08:54:49", "", "Artboard 22", "", "inherit", "open", "closed", "", "artboard-22", "", "", "2020-09-12 08:54:49", "2020-09-12 08:54:49", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-22.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("522", "1", "2020-09-12 08:54:52", "2020-09-12 08:54:52", "", "Artboard 23", "", "inherit", "open", "closed", "", "artboard-23", "", "", "2020-09-12 08:54:52", "2020-09-12 08:54:52", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-23.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("523", "1", "2020-09-12 08:54:57", "2020-09-12 08:54:57", "", "Artboard 24", "", "inherit", "open", "closed", "", "artboard-24", "", "", "2020-09-12 08:54:57", "2020-09-12 08:54:57", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-24.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("524", "1", "2020-09-12 08:54:59", "2020-09-12 08:54:59", "", "Artboard 25", "", "inherit", "open", "closed", "", "artboard-25", "", "", "2020-09-12 08:54:59", "2020-09-12 08:54:59", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-25.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("525", "1", "2020-09-12 08:55:04", "2020-09-12 08:55:04", "", "Artboard 26", "", "inherit", "open", "closed", "", "artboard-26", "", "", "2020-09-12 08:55:04", "2020-09-12 08:55:04", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-26.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("526", "1", "2020-09-12 08:55:08", "2020-09-12 08:55:08", "", "Artboard 27", "", "inherit", "open", "closed", "", "artboard-27", "", "", "2020-09-12 08:55:08", "2020-09-12 08:55:08", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-27.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("527", "1", "2020-09-12 08:55:16", "2020-09-12 08:55:16", "", "Artboard 28", "", "inherit", "open", "closed", "", "artboard-28", "", "", "2020-09-12 08:55:16", "2020-09-12 08:55:16", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-28.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("528", "1", "2020-09-12 08:55:19", "2020-09-12 08:55:19", "", "Artboard 29", "", "inherit", "open", "closed", "", "artboard-29", "", "", "2020-09-12 08:55:19", "2020-09-12 08:55:19", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-29.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("529", "1", "2020-09-12 08:55:21", "2020-09-12 08:55:21", "", "Artboard 30", "", "inherit", "open", "closed", "", "artboard-30", "", "", "2020-09-12 08:55:21", "2020-09-12 08:55:21", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-30.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("530", "1", "2020-09-12 08:55:23", "2020-09-12 08:55:23", "", "Artboard 31", "", "inherit", "open", "closed", "", "artboard-31", "", "", "2020-09-12 08:55:23", "2020-09-12 08:55:23", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-31.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("531", "1", "2020-09-12 08:55:26", "2020-09-12 08:55:26", "", "Artboard 32", "", "inherit", "open", "closed", "", "artboard-32", "", "", "2020-09-12 08:55:26", "2020-09-12 08:55:26", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-32.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("532", "1", "2020-09-12 08:55:27", "2020-09-12 08:55:27", "", "Artboard 33", "", "inherit", "open", "closed", "", "artboard-33", "", "", "2020-09-12 08:55:27", "2020-09-12 08:55:27", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-33.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("533", "1", "2020-09-12 08:55:30", "2020-09-12 08:55:30", "", "Artboard 34", "", "inherit", "open", "closed", "", "artboard-34", "", "", "2020-09-12 08:55:30", "2020-09-12 08:55:30", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-34.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("534", "1", "2020-09-12 08:55:31", "2020-09-12 08:55:31", "", "Artboard 35", "", "inherit", "open", "closed", "", "artboard-35", "", "", "2020-09-12 08:55:31", "2020-09-12 08:55:31", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-35.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("535", "1", "2020-09-12 08:55:36", "2020-09-12 08:55:36", "", "Artboard 36", "", "inherit", "open", "closed", "", "artboard-36", "", "", "2020-09-12 08:55:36", "2020-09-12 08:55:36", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-36.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("536", "1", "2020-09-12 08:55:38", "2020-09-12 08:55:38", "", "Artboard 37", "", "inherit", "open", "closed", "", "artboard-37", "", "", "2020-09-12 08:55:38", "2020-09-12 08:55:38", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-37.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("537", "1", "2020-09-12 08:55:40", "2020-09-12 08:55:40", "", "Artboard 38", "", "inherit", "open", "closed", "", "artboard-38", "", "", "2020-09-12 08:55:40", "2020-09-12 08:55:40", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-38.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("538", "1", "2020-09-12 08:55:41", "2020-09-12 08:55:41", "", "Artboard 39", "", "inherit", "open", "closed", "", "artboard-39", "", "", "2020-09-12 08:55:41", "2020-09-12 08:55:41", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-39.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("539", "1", "2020-09-12 08:55:42", "2020-09-12 08:55:42", "", "Artboard 40", "", "inherit", "open", "closed", "", "artboard-40", "", "", "2020-09-12 08:55:42", "2020-09-12 08:55:42", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-40.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("540", "1", "2020-09-12 08:55:43", "2020-09-12 08:55:43", "", "Artboard 41", "", "inherit", "open", "closed", "", "artboard-41", "", "", "2020-09-12 08:55:43", "2020-09-12 08:55:43", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-41.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("541", "1", "2020-09-12 08:55:45", "2020-09-12 08:55:45", "", "Artboard 42", "", "inherit", "open", "closed", "", "artboard-42", "", "", "2020-09-12 08:55:45", "2020-09-12 08:55:45", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-42.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("542", "1", "2020-09-12 08:55:47", "2020-09-12 08:55:47", "", "Artboard 43", "", "inherit", "open", "closed", "", "artboard-43", "", "", "2020-09-12 08:55:47", "2020-09-12 08:55:47", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-43.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("543", "1", "2020-09-12 08:55:50", "2020-09-12 08:55:50", "", "Artboard 44", "", "inherit", "open", "closed", "", "artboard-44", "", "", "2020-09-12 08:55:50", "2020-09-12 08:55:50", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-44.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("544", "1", "2020-09-12 08:55:51", "2020-09-12 08:55:51", "", "Artboard 45", "", "inherit", "open", "closed", "", "artboard-45", "", "", "2020-09-12 08:55:51", "2020-09-12 08:55:51", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-45.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("545", "1", "2020-09-12 08:55:55", "2020-09-12 08:55:55", "", "Artboard 46", "", "inherit", "open", "closed", "", "artboard-46", "", "", "2020-09-12 08:55:55", "2020-09-12 08:55:55", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-46.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("546", "1", "2020-09-12 08:55:59", "2020-09-12 08:55:59", "", "Artboard 47", "", "inherit", "open", "closed", "", "artboard-47", "", "", "2020-09-12 08:55:59", "2020-09-12 08:55:59", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-47.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("547", "1", "2020-09-12 08:56:04", "2020-09-12 08:56:04", "", "Artboard 48", "", "inherit", "open", "closed", "", "artboard-48", "", "", "2020-09-12 08:56:04", "2020-09-12 08:56:04", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("548", "1", "2020-09-12 08:56:10", "2020-09-12 08:56:10", "", "Artboard 49", "", "inherit", "open", "closed", "", "artboard-49", "", "", "2020-09-12 08:56:10", "2020-09-12 08:56:10", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-49.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("549", "1", "2020-09-12 08:56:12", "2020-09-12 08:56:12", "", "Artboard 50", "", "inherit", "open", "closed", "", "artboard-50", "", "", "2020-09-12 08:56:12", "2020-09-12 08:56:12", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-50.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("550", "1", "2020-09-12 08:56:14", "2020-09-12 08:56:14", "", "Artboard 51", "", "inherit", "open", "closed", "", "artboard-51", "", "", "2020-09-12 08:56:14", "2020-09-12 08:56:14", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-51.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("551", "1", "2020-09-12 08:56:20", "2020-09-12 08:56:20", "", "Artboard 52", "", "inherit", "open", "closed", "", "artboard-52", "", "", "2020-09-12 08:56:20", "2020-09-12 08:56:20", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-52.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("552", "1", "2020-09-12 08:56:24", "2020-09-12 08:56:24", "", "Artboard 53", "", "inherit", "open", "closed", "", "artboard-53", "", "", "2020-09-12 08:56:24", "2020-09-12 08:56:24", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-53.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("553", "1", "2020-09-12 08:56:27", "2020-09-12 08:56:27", "", "Artboard 54", "", "inherit", "open", "closed", "", "artboard-54", "", "", "2020-09-12 08:56:27", "2020-09-12 08:56:27", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-54.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("609", "1", "2020-10-28 01:34:48", "2020-10-27 22:04:48", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "رضا میرحسینی تلک و تلک", "", "publish", "open", "closed", "", "news-radio", "", "", "2022-01-02 01:37:07", "2022-01-01 22:07:07", "", "0", "http://music.flatfull.com/soundwave/?post_type=station&#038;p=609", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("610", "1", "2020-10-28 01:45:16", "2020-10-27 22:15:16", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "مسعود صادقلو دورهمی", "", "publish", "open", "closed", "", "fox-news-radio", "", "", "2022-01-02 01:36:58", "2022-01-01 22:06:58", "", "0", "http://music.flatfull.com/soundwave/?post_type=station&#038;p=610", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("611", "1", "2020-10-28 01:50:18", "2020-10-27 22:20:18", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "گرشا رضایی ماهی", "", "publish", "open", "closed", "", "british-comedy-radio", "", "", "2022-01-02 01:36:50", "2022-01-01 22:06:50", "", "0", "http://music.flatfull.com/soundwave/?post_type=station&#038;p=611", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("613", "1", "2020-10-28 03:10:29", "2020-10-27 23:40:29", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "ماکان بند خواب بودم", "", "publish", "open", "closed", "", "hearthis", "", "", "2022-01-02 01:33:11", "2022-01-01 22:03:11", "", "0", "http://music.flatfull.com/soundwave/?post_type=station&#038;p=613", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("664", "1", "2020-10-28 13:03:06", "2020-10-28 13:03:06", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/cropped-screenshot-1.png", "cropped-screenshot-1.png", "", "inherit", "open", "closed", "", "cropped-screenshot-1-png", "", "", "2020-10-28 13:03:06", "2020-10-28 13:03:06", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/cropped-screenshot-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("666", "1", "2020-10-29 00:11:05", "2020-10-28 20:41:05", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "سامان یاسین اسکویید گیم", "", "publish", "open", "closed", "", "same-devil", "", "", "2022-01-02 01:36:28", "2022-01-01 22:06:28", "", "0", "http://music.flatfull.com/soundwave/?post_type=station&#038;p=666", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("697", "1", "2020-10-29 03:30:37", "2020-10-29 03:30:37", "", "Artboard 55", "", "inherit", "open", "closed", "", "artboard-55", "", "", "2020-10-29 03:30:37", "2020-10-29 03:30:37", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-55.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("698", "1", "2020-10-29 03:30:38", "2020-10-29 03:30:38", "", "Artboard 56", "", "inherit", "open", "closed", "", "artboard-56", "", "", "2020-10-29 03:30:38", "2020-10-29 03:30:38", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-56.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("699", "1", "2020-10-29 03:30:42", "2020-10-29 03:30:42", "", "Artboard 57", "", "inherit", "open", "closed", "", "artboard-57", "", "", "2020-10-29 03:30:42", "2020-10-29 03:30:42", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-57.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("700", "1", "2020-10-29 03:30:53", "2020-10-29 03:30:53", "", "Artboard 58", "", "inherit", "open", "closed", "", "artboard-58", "", "", "2020-10-29 03:30:53", "2020-10-29 03:30:53", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-58.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("701", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "آپلود آهنگ", "", "publish", "closed", "closed", "", "upload", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=701", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("702", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "%avatar%", "", "publish", "closed", "closed", "", "avatar", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=702", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("703", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:33", "", "استریم ها", "", "publish", "closed", "closed", "", "stream", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=703", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("704", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "پلی لیست ها", "", "publish", "closed", "closed", "", "playlists", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=704", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("705", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "پسندیده ها", "", "publish", "closed", "closed", "", "likes", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=705", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("706", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "دنبال کننده ها", "", "publish", "closed", "closed", "", "followers", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=706", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("707", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:33", "", "دنبالر ها", "", "publish", "closed", "closed", "", "following", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=707", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("708", "1", "2020-10-29 03:30:54", "2020-10-29 03:30:54", "", "Artboard 59", "", "inherit", "open", "closed", "", "artboard-59", "", "", "2020-10-29 03:30:54", "2020-10-29 03:30:54", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-59.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("709", "1", "2020-10-29 03:30:56", "2020-10-29 03:30:56", "", "Artboard 60", "", "inherit", "open", "closed", "", "artboard-60", "", "", "2020-10-29 03:30:56", "2020-10-29 03:30:56", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-60.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("710", "1", "2020-10-29 03:30:57", "2020-10-29 03:30:57", "", "Artboard 61", "", "inherit", "open", "closed", "", "artboard-61", "", "", "2020-10-29 03:30:57", "2020-10-29 03:30:57", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-61.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("711", "1", "2020-10-29 03:30:58", "2020-10-29 03:30:58", "", "Artboard 62", "", "inherit", "open", "closed", "", "artboard-62", "", "", "2020-10-29 03:30:58", "2020-10-29 03:30:58", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("712", "1", "2020-10-29 03:31:00", "2020-10-29 03:31:00", "", "Artboard 63", "", "inherit", "open", "closed", "", "artboard-63", "", "", "2020-10-29 03:31:00", "2020-10-29 03:31:00", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-63.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("741", "1", "2020-10-29 05:59:50", "2020-10-29 05:59:50", "<!-- wp:block/loop {\"title\":\"پخش خودکار\",\"type\":\"station\",\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"pages\":10} /-->\n\n<!-- wp:block/loop {\"title\":\"پیکان\",\"type\":\"station\",\"slider\":true,\"cols\":5,\"pages\":8} /-->\n\n<!-- wp:block/loop {\"title\":\"نقطه ناوبری\",\"type\":\"station\",\"slider\":true,\"sliderOption\":\"{dots:true}\",\"cols\":5,\"pages\":9} /-->", "اسلایدر", "", "publish", "closed", "closed", "", "slider", "", "", "2022-01-02 00:49:15", "2022-01-01 21:19:15", "", "0", "http://music.flatfull.com/soundwave/?page_id=741", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("754", "1", "2020-10-29 11:41:26", "2020-10-29 08:11:26", "<!-- wp:block/loop {\"type\":\"station\",\"slider\":false,\"cols\":5,\"pages\":10,\"pager\":\"pagination\"} /-->", "ناوبری", "", "publish", "closed", "closed", "", "pagination", "", "", "2022-01-02 00:43:47", "2022-01-01 21:13:47", "", "0", "http://music.flatfull.com/soundwave/?page_id=754", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("756", "1", "2020-10-29 11:43:12", "2020-10-29 08:13:12", "<!-- wp:block/loop {\"type\":\"station\",\"pager\":\"more\",\"className\":\"block-loop-row\"} /-->", "بارگذاری بیشتر", "", "publish", "closed", "closed", "", "load-more", "", "", "2022-01-02 00:42:52", "2022-01-01 21:12:52", "", "0", "http://music.flatfull.com/soundwave/?page_id=756", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("758", "1", "2020-10-29 11:45:20", "2020-10-29 11:45:20", "<!-- wp:block/loop {\"type\":\"station\",\"pages\":4,\"pager\":\"scroll\",\"className\":\"block-loop-row block-loop-sm\"} /-->", "اسکرول نامحدود", "", "publish", "closed", "closed", "", "infinite", "", "", "2022-01-02 00:35:37", "2022-01-01 21:05:37", "", "0", "http://music.flatfull.com/soundwave/?page_id=758", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("763", "1", "2020-10-29 14:02:51", "2020-10-29 10:32:51", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "ناصر پورکرم یکی یه دونمی", "", "publish", "open", "closed", "", "rock-collection", "", "", "2022-01-02 01:36:23", "2022-01-01 22:06:23", "", "0", "http://music.flatfull.com/soundwave/station/rock-collection/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("764", "1", "2020-10-29 14:03:48", "2020-10-29 10:33:48", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "غلامرضا صنعتگر قاسم هنوز زنده ست", "", "publish", "open", "closed", "", "radio-station", "", "", "2022-01-02 01:36:07", "2022-01-01 22:06:07", "", "0", "http://music.flatfull.com/soundwave/station/radio-station/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("765", "1", "2020-10-29 00:00:00", "2020-10-28 20:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "عماد طالب زاده تو اگه قدرمو میدونستی", "", "publish", "closed", "closed", "", "mtv-youtube-video-and-music", "", "", "2022-01-02 01:36:33", "2022-01-01 22:06:33", "", "0", "http://music.flatfull.com/soundwave/station/mtv/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("766", "1", "2020-10-29 00:00:00", "2020-10-28 20:30:00", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "امیر رشوند گل من", "", "publish", "closed", "closed", "", "album-2020", "", "", "2022-01-02 01:36:41", "2022-01-01 22:06:41", "", "0", "http://music.flatfull.com/soundwave/station/album-2020/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("767", "1", "2020-11-01 09:55:34", "2020-11-01 06:25:34", "<!-- wp:block/loop {\"type\":\"station\",\"pages\":10} /-->", "صفحه بدون ناوبری", "", "publish", "closed", "closed", "", "page-with-hidden-nav", "", "", "2022-01-02 00:43:31", "2022-01-01 21:13:31", "", "0", "http://music.flatfull.com/soundwave/?page_id=767", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("772", "1", "2020-11-01 10:06:08", "2020-11-01 06:36:08", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"cols\":3,\"pages\":9} /-->", "صفحه با سایدبار", "", "publish", "closed", "closed", "", "page-with-sidebar", "", "", "2022-01-02 00:43:41", "2022-01-01 21:13:41", "", "0", "http://music.flatfull.com/soundwave/?page_id=772", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("776", "1", "2020-11-01 10:14:06", "2020-11-01 06:44:06", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"cols\":4,\"pages\":4} /-->", "صفحه با فوتر", "", "publish", "closed", "closed", "", "page-with-diff-footer", "", "", "2022-01-02 00:43:26", "2022-01-01 21:13:26", "", "0", "http://music.flatfull.com/soundwave/?page_id=776", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("778", "1", "2020-11-01 10:21:02", "2020-11-01 10:21:02", "<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-left has-text-color\" style=\"color:#888888;font-size:11px\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":11}}} -->\n<p style=\"font-size:11px\"><a href=\"http://music.flatfull.com/waveme/terms\">سرویس پخش </a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/\">قوانین موزیک</a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/#cookies\">کوکی ها</a>⠀•⠀<a href=\"http://flatfull.com\">پشتیبانی</a>⠀•⠀<a href=\"mailto:hey@flatfull.com\">بازخورد ها</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر ساده", "", "publish", "closed", "closed", "", "simple-footer", "", "", "2022-01-02 00:48:41", "2022-01-01 21:18:41", "", "0", "http://music.flatfull.com/soundwave/?page_id=778", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("863", "1", "2020-11-09 00:19:26", "2020-11-09 00:19:26", "", "Artboard", "", "inherit", "open", "closed", "", "artboard-64", "", "", "2020-11-09 00:19:26", "2020-11-09 00:19:26", "", "11", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("867", "1", "2020-11-09 00:24:17", "2020-11-09 00:24:17", "<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"60%\",\"className\":\"text-center-sm\"} -->\n<div class=\"wp-block-column text-center-sm\" style=\"flex-basis:60%\"><!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"textColor\":\"cyan-bluish-gray\"} -->\n<h5 class=\"has-cyan-bluish-gray-color has-text-color\">بهترین قالب آهنگ و ویدئو</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"fontSize\":\"medium\"} -->\n<h2 class=\"has-medium-font-size\">به دنیای هم ترانه سلام کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"cyan-bluish-gray\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-cyan-bluish-gray-color has-text-color\" href=\"https://themes.wpnovin.com/Waveme//discover\"><strong>شروع کنید...</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:block/loop {\"type\":\"station\",\"ids\":[\"176\",\"223\",\"666\",\"174\"],\"orderby\":\"post__in\",\"template\":\"templates/content/content-thumbnail.php\",\"slider\":true,\"sliderOption\":\"{arrows:false, dots: true, autoplay: true}\",\"cols\":1,\"className\":\"block-loop-overlay\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Hero 1", "", "publish", "closed", "closed", "", "untitled-reusable-block", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "0", "http://music.flatfull.com/waveme/2020/11/09/untitled-reusable-block/", "0", "wp_block", "", "0");
INSERT INTO `wp_posts` VALUES("924", "1", "2020-11-09 05:57:06", "2020-11-09 05:57:06", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"gradient\":\"linear-gradient(135deg,rgb(31,44,52) 0%,rgb(0,0,0) 100%)\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background:linear-gradient(135deg,rgb(31,44,52) 0%,rgb(0,0,0) 100%)\"><!-- wp:spacer {\"height\":140} -->\n<div style=\"height:140px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block {\"ref\":867} /-->\n\n<!-- wp:spacer {\"height\":110} -->\n<div style=\"height:110px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-49.png\",\"id\":548,\"hasParallax\":true,\"dimRatio\":85,\"align\":\"full\",\"className\":\"container-wrap no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-90 has-background-dim has-parallax container-wrap no-margin\" style=\"background-image:url(https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-49.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"fontSize\":\"huge\"} -->\n<h2 class=\"has-huge-font-size\">آهنگ ، ویدئو ، آلبوم و استریم و...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>بهترین آهنگ ها</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\"><a href=\"https://themes.wpnovin.com/Waveme/\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>ویدئو های جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>پلی لیست های محبوب</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"no-padding\"} -->\n<div class=\"wp-block-group alignfull no-padding has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"template\":\"templates/content/content-thumbnail.php\",\"slider\":true,\"sliderOption\":\"{arrows: false, autoplay: true}\",\"cols\":7,\"gap\":20,\"pages\":20,\"align\":\"full\",\"className\":\"block-loop-overlay\"} /-->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"has-large-font-size\">به راحتی آب خوردن...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block {\"ref\":1095} /-->\n\n<!-- wp:block {\"ref\":1096} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":10} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "لندینگ", "", "publish", "closed", "closed", "", "landing", "", "", "2022-01-02 00:42:16", "2022-01-01 21:12:16", "", "0", "http://music.flatfull.com/waveme/?page_id=924", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("926", "1", "2020-11-09 05:58:07", "2020-11-09 05:58:07", "<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"align\":\"center\",\"id\":974,\"sizeSlug\":\"large\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/waveme-desktop-1024x640.png\" alt=\"\" class=\"wp-image-974\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>Responsive Layout</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\"} -->\n<h2 class=\"heading\">Responsive Web Application For Any Screen</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"http://music.flatfull.com/waveme/login\">Register Now</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Hero 2", "", "publish", "closed", "closed", "", "untitled-reusable-block-2", "", "", "2020-11-09 05:58:07", "2020-11-09 05:58:07", "", "0", "http://music.flatfull.com/waveme/2020/11/09/untitled-reusable-block-2/", "0", "wp_block", "", "0");
INSERT INTO `wp_posts` VALUES("974", "1", "2020-11-09 13:34:23", "2020-11-09 13:34:23", "", "waveme-desktop", "", "inherit", "open", "closed", "", "waveme-desktop", "", "", "2020-11-09 13:34:23", "2020-11-09 13:34:23", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/waveme-desktop.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("977", "1", "2020-11-09 13:34:42", "2020-11-09 13:34:42", "", "waveme-iphone", "", "inherit", "open", "closed", "", "waveme-iphone", "", "", "2020-11-09 13:34:42", "2020-11-09 13:34:42", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/waveme-iphone.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("1024", "1", "2020-11-12 01:02:54", "2020-11-12 01:02:54", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">جدید ترین آهنگ ها</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\"><meta charset=\"utf-8\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"fontSize\":\"normal\"} -->\n<h5 class=\"has-normal-font-size\">هم ترانه بهترین قالب ممکن...</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\"><meta charset=\"utf-8\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">پلفرم موسیقی ایران...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>صدایی به وسعت ایران عزیز...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "publish", "closed", "closed", "", "about", "", "", "2022-01-01 17:36:01", "2022-01-01 14:06:01", "", "0", "http://music.flatfull.com/waveme/?page_id=1024", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1095", "1", "2020-11-12 06:15:35", "2020-11-12 06:15:35", "<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۱ صفحه ساز گوتنبرگ</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#aaaaaa\"}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">تمامی صفحات و آهنگ ها و استریم ها به راحتی با صفحه ساز گوتنبرگ قابل ویرایش می باشد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۲ ساخت آهنگ و ویدئو...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#aaaaaa\"}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">به راحتی و با چند کلیک آهنگ ها و پلی لیست ها و موزیک ویدئو های خود را ایجاد کنید.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Text drop", "", "publish", "closed", "closed", "", "untitled-reusable-block-3", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "0", "http://music.flatfull.com/waveme/2020/11/12/untitled-reusable-block-3/", "0", "wp_block", "", "0");
INSERT INTO `wp_posts` VALUES("1096", "1", "2020-11-12 06:15:49", "2020-11-12 06:15:49", "<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">3 امکان ارسال آهنگ </h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#999999\"}}} -->\n<p class=\"has-text-color\" style=\"color:#999999;font-size:18px\">کاربران به راحتی از طریق پنل کاربری خود میتوانید آهنگ ها ، ویدئو ها و آلبوم های رایگان و پولی خود را ارسال کنند.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۴ نسخه تیره و روشن</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#999999\"}}} -->\n<p class=\"has-text-color\" style=\"color:#999999;font-size:18px\">وجود بی نهایت رنگ بندی آنلاین به همراه طراحی عالی و نسخه تیره و روشن از ویژگی های دیگر این قالب است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Text drop 2", "", "publish", "closed", "closed", "", "untitled-reusable-block-4", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "0", "http://music.flatfull.com/waveme/2020/11/12/untitled-reusable-block-4/", "0", "wp_block", "", "0");
INSERT INTO `wp_posts` VALUES("1116", "1", "2020-11-12 08:16:39", "2020-11-12 08:16:39", "<!-- wp:shortcode -->\n[play_upload_form]\n<!-- /wp:shortcode -->", "ارسال آهنگ", "", "publish", "closed", "closed", "", "upload", "", "", "2022-01-02 00:51:20", "2022-01-01 21:21:20", "", "0", "http://music.flatfull.com/waveme/?page_id=1116", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1118", "1", "2020-11-12 08:16:59", "2020-11-12 08:16:59", "<!-- wp:shortcode -->\n[play_download]\n<!-- /wp:shortcode -->", "دانلود", "", "publish", "closed", "closed", "", "download", "", "", "2022-01-02 00:29:00", "2022-01-01 20:59:00", "", "0", "http://music.flatfull.com/waveme/?page_id=1118", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1123", "1", "2020-11-12 08:34:25", "2020-11-12 08:34:25", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/pexels-sound-on-3756943.jpg\",\"id\":1531,\"dimRatio\":90,\"customGradient\":\"linear-gradient(135deg,rgb(1,32,51) 0%,rgb(155,81,224) 100%)\",\"align\":\"full\",\"className\":\"container-wrap no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-90 has-background-dim has-background-gradient container-wrap no-margin\"><span aria-hidden=\"true\" class=\"wp-block-cover__gradient-background\" style=\"background:linear-gradient(135deg,rgb(1,32,51) 0%,rgb(155,81,224) 100%)\"></span><img class=\"wp-block-cover__image-background wp-image-1531\" alt=\"\" src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/pexels-sound-on-3756943.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":160} -->\n<div style=\"height:160px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">تماس با ما</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"fontSize\":\"medium\"} -->\n<h2 class=\"has-medium-font-size\">با هم ترانه در ارتباط باشید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"fontSize\":\"normal\"} -->\n<p class=\"has-normal-font-size\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff9f00\"}},\"className\":\"is-style-fill\"} -->\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-background\" href=\"mailto:verify@flatfull.com\" style=\"background-color:#ff9f00\"><strong>ارسال ایمیل همکاری</strong></a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color\" href=\"mailto:partner@flatfull.com\"><strong>درخواست انتشار ترانه</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fffff1\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fffff1\"><a class=\"btn-play has-text-color\" style=\"color:#ffbb00\" data-play-id=\"1206\" href=\"#\"></a>⠀<strong> به وسعت ایران زیبا...</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":70} -->\n<div style=\"height:70px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#4837e1\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#4837e1\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"160px\",\"className\":\"alignmiddle\"} -->\n<div class=\"wp-block-column alignmiddle\" style=\"flex-basis:160px\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"style\":{\"color\":{\"text\":\"#4837e1\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\" style=\"color:#4837e1\"><strong>خرید هم ترانه</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "تماس با ما", "", "publish", "closed", "closed", "", "contact", "", "", "2022-01-02 00:28:32", "2022-01-01 20:58:32", "", "0", "http://music.flatfull.com/waveme/?page_id=1123", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1168", "1", "2020-11-12 13:21:00", "2020-11-12 13:21:00", "<!-- wp:paragraph -->\n<p>با بازدید، دسترسی یا استفاده از سایت ما، نشان می‌دهید که حق، اختیار و ظرفیت لازم برای ورود به این توافق‌نامه را دارید، این موافقت‌نامه را خوانده‌اید و درک کرده‌اید، و موافقت می‌کنید که تمام شرایط و ضوابط را رعایت کنید. این توافقنامه، از جمله تمدید خودکار اشتراک شما و مقررات حاکم بر حل و فصل اختلافات. لطفا این شرایط را با دقت بخوانید. اگر موافق نیستید، به خدمات دسترسی نداشته باشید یا از آن استفاده نکنید.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":4} -->\n<h4 id=\"introduction\">معرفی</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>این سند («شرایط») به همراه خط‌مشی رازداری ایالات متحده (مجموعاً «توافقنامه») شرایط و ضوابط حاکم بر بازدیدها، دسترسی و استفاده از سرویس توسط کاربر نهایی («شما») را تعیین می‌کند. عبارت \"شما\" شامل کاربران ثبت نام شده اضافی هر زمان که طبق اشتراک قابل اجرا مجاز باشد، بازدیدکنندگان و سایر افرادی که به هر یک از خدمات دسترسی دارند یا از آنها استفاده می کنند، می شود.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>«سرویس‌ها» به معنای خدماتی است که سایت ما را با نام تجاری نشان می‌دهد و برای سرویس‌های موسیقی دیجیتال با موقعیت مشابه سازگار است. اینها ممکن است شامل وب‌سایت‌ها و برنامه‌های کاربردی برای رایانه‌های رومیزی، تبلت‌ها و گوشی‌های تلفن همراه، ست‌اپ باکس‌ها و تجهیزات استریو باشد، اما محدود به آن‌ها نیست. این خدمات همچنین شامل توانایی شما برای ویرایش محتوای سرویس خاص است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4 id=\"content-restrictions\">محدودیت های محتوا</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>این سرویس ها حاوی محتوایی مانند ضبط صدا، آثار سمعی و بصری، سایر آثار ویدیویی یا صوتی، کلیپ ها، تصاویر، گرافیک، متن، نرم افزار، آثار نویسندگی، فایل ها، اسناد، برنامه ها، آثار هنری، علائم تجاری، نام های تجاری، ابرداده ها، عناوین آلبوم است. ، عناوین ضبط صدا، نام هنرمندان، مالکیت معنوی، یا مطالب مربوط به آنها یا هر گونه مطالب دیگر، و انتخاب، هماهنگی و ترتیب آنها (در مجموع، \"محتوای خدمات\"). محتوای سرویس متعلق به سایت ما و/یا اشخاص ثالث است و تحت قوانین ایالات متحده و قوانین خارجی توسط حق چاپ محافظت می شود.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4 id=\"user-content\">محتوای کاربر</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>تا جایی که سرویس‌ها اجازه می‌دهند، هر اثر موسیقی (صداهای ضبط‌شده و ساخته‌های موسیقی زیربنایی)، آثار سمعی و بصری (شامل اما نه محدود به موزیک ویدیوهای برتر سبک MTV، کلیپ‌ها و به اصطلاح محتوای سمعی و بصری «پشت صحنه»)، ویدیوهای دیگر یا آثار صوتی، تصاویر، گرافیک، متن، آثار تألیفی، فایل‌ها، اسناد، برنامه‌های کاربردی، آثار هنری، علائم تجاری، نام‌های تجاری، ابرداده‌ها، عناوین آلبوم، عناوین ضبط صدا، نام هنرمندان، مالکیت معنوی، یا مطالب مرتبط با آن‌ها یا هر ماده دیگری که شما به این سرویس ارسال می کنید (\"محتوای کاربر\") تنها توسط شما و/یا دارندگان مجوز شما تولید، مالکیت و کنترل می شوند. ما هیچ گونه حقوق مالکیت معنوی در محتوای کاربر را ادعا نمی کنیم. پس از ارسال مستقیم (\"ارسال\") محتوای کاربری خود به سرویس ها، شما همچنان هرگونه حقوق مالکیت معنوی را که ممکن است در محتوای کاربری خود داشته باشید، مشروط به مجوز زیر حفظ کنید.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:list {\"className\":\"sticky-top\"} -->\n<ul class=\"sticky-top\"><li><a href=\"#introduction\">معرفی</a></li><li><a href=\"#content-restrictions\">محدودیت های محتوا</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"#user-content\">محتوای کاربر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "قوانین و مقررات", "", "publish", "closed", "closed", "", "terms", "", "", "2022-01-02 00:50:50", "2022-01-01 21:20:50", "", "0", "http://music.flatfull.com/waveme/?page_id=1168", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1185", "1", "2020-11-13 12:55:39", "2020-11-13 09:25:39", "", "مهرزاد اسفندیاری اگه هستی", "", "publish", "open", "closed", "", "remind-me-to-forget", "", "", "2022-01-02 01:20:58", "2022-01-01 21:50:58", "", "0", "http://music.flatfull.com/waveme/?post_type=station&#038;p=1185", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("1206", "1", "2020-12-10 03:35:18", "2020-12-10 00:05:18", "", "مجید رضوی - نگین قلبمی", "", "publish", "open", "closed", "", "sound-waveform", "", "", "2022-01-01 17:02:08", "2022-01-01 13:32:08", "", "0", "http://music.flatfull.com/waveme/station/sound-waveform/", "0", "station", "", "0");
INSERT INTO `wp_posts` VALUES("1314", "1", "2020-12-14 00:13:54", "2020-12-14 00:13:54", "", "Pexels-Videos-2022395", "", "inherit", "open", "closed", "", "pexels-videos-2022395", "", "", "2020-12-14 00:13:54", "2020-12-14 00:13:54", "", "1024", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("1531", "1", "2020-12-17 01:40:55", "2020-12-17 01:40:55", "", "pexels-sound-on-3756943", "", "inherit", "open", "closed", "", "pexels-sound-on-3756943", "", "", "2020-12-17 01:40:55", "2020-12-17 01:40:55", "", "1123", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/pexels-sound-on-3756943.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1532", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:57", "", "خروج", "", "publish", "closed", "closed", "", "log-out", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=1532", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1533", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "پلی لیست ها", "", "publish", "closed", "closed", "", "playlists-2", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1533", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1534", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "پسندیده ها", "", "publish", "closed", "closed", "", "likes-2", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1534", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1535", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "کتابخانه", "", "publish", "closed", "closed", "", "library", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1535", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1536", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "رنگ سفارشی", "", "publish", "closed", "closed", "", "primary-color", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1536", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1537", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "تیره / روشن", "", "publish", "closed", "closed", "", "dark-theme", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1537", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1538", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "• • •", "", "publish", "closed", "closed", "", "1538", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1538", "28", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1539", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "شروع کنید!", "", "publish", "closed", "closed", "", "explore", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1539", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1540", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "حلقه ها", "", "publish", "closed", "closed", "", "loop", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1540", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1541", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "پخش", "", "publish", "closed", "closed", "", "play", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1541", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1542", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "صفحات", "", "publish", "closed", "closed", "", "pages", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1542", "19", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1543", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "خرید قالب", "", "publish", "closed", "closed", "", "purchase", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1543", "29", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1544", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:57", "", "آلبوم ها", "", "publish", "closed", "closed", "", "albums", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=1544", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1545", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:57", "", "دانلودها", "", "publish", "closed", "closed", "", "downloads", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=1545", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1546", "1", "2022-01-01 17:20:34", "2022-01-01 13:10:57", "", "پروفایل", "", "publish", "closed", "closed", "", "profile", "", "", "2022-01-01 17:20:34", "2022-01-01 13:50:34", "", "0", "https://themes.wpnovin.com/Waveme/?p=1546", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1547", "1", "2020-09-10 14:01:11", "2020-09-10 14:01:11", "<!-- wp:paragraph -->\n<p><a href=\"https://themes.wpnovin.com/Waveme/contact\">اتاق های موزیک</a> <a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a> <a href=\"https://themes.wpnovin.com/Waveme/contact\">تماس با ما</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://music.flatfull.com/waveme/terms\">قوانین و مقررات</a> <a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"small\"} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#888888\">@ ارائه شده توسط نوین وردپرس</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "فوتر کناری", "", "publish", "closed", "open", "", "side-footer", "", "", "2022-01-02 00:46:50", "2022-01-01 21:16:50", "", "0", "http://music.flatfull.com/soundwave/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("1548", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "ثبت بازخورد", "", "publish", "closed", "closed", "", "feedback", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1548", "31", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1549", "1", "2022-01-02 02:19:38", "2022-01-01 13:10:57", "", "فهرست ترانه ها", "", "publish", "closed", "closed", "", "browse", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1549", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1550", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "وبلاگ", "", "publish", "closed", "closed", "", "blog", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1550", "26", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1551", "1", "2022-01-02 02:05:47", "2022-01-01 13:10:57", "", "مستندات", "", "publish", "closed", "closed", "", "document", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1551", "30", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1552", "1", "2020-09-10 14:01:11", "2020-09-10 14:01:11", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "سلام هم ترانه...", "", "publish", "open", "open", "", "hello-music", "", "", "2022-01-02 01:32:14", "2022-01-01 22:02:14", "", "0", "http://music.flatfull.com/soundwave/?p=1", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1553", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", " ", "", "", "publish", "closed", "closed", "", "1553", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1553", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1554", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", "", "منتخب ها", "", "publish", "closed", "closed", "", "1554", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1554", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1555", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", " ", "", "", "publish", "closed", "closed", "", "1555", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1555", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1556", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", "", "براساس نوع", "", "publish", "closed", "closed", "", "1556", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "0", "https://themes.wpnovin.com/Waveme/?p=1556", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1557", "1", "2022-01-01 17:21:31", "2022-01-01 13:11:00", "", "ورود به سایت", "", "publish", "closed", "closed", "", "signin", "", "", "2022-01-01 17:21:31", "2022-01-01 13:51:31", "", "0", "https://themes.wpnovin.com/Waveme/?p=1557", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1558", "1", "2022-01-01 17:21:31", "2022-01-01 13:11:00", "", "عضویت", "?action=register", "publish", "closed", "closed", "", "signup", "", "", "2022-01-01 17:21:31", "2022-01-01 13:51:31", "", "0", "https://themes.wpnovin.com/Waveme/?p=1558", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1559", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", "", "پادکست ها", "", "publish", "closed", "closed", "", "1559", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1559", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1560", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", "", "آهنگ", "", "publish", "closed", "closed", "", "1560", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1560", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1561", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:00", " ", "", "", "publish", "closed", "closed", "", "1561", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1561", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1562", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:00", "", "شات کست", "", "publish", "closed", "closed", "", "shoutcast", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1562", "17", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1563", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:00", "", "آیس کست", "", "publish", "closed", "closed", "", "icecast", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1563", "18", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1564", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "یوتیوب", "", "publish", "closed", "closed", "", "youtube", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1564", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1565", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "ساند کلاد", "", "publish", "closed", "closed", "", "soundcloud", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1565", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1566", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "هیردیس", "", "publish", "closed", "closed", "", "hearthis", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1566", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1567", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "موزیک از یوتیوب", "", "publish", "closed", "closed", "", "youtube-music", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1567", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1568", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "نظرات اسکرول نامحدود", "", "publish", "closed", "closed", "", "infinite-comments", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1568", "23", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1569", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "پلی لیست ها", "", "publish", "closed", "closed", "", "playlist", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1569", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1570", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "آلبوم", "", "publish", "closed", "closed", "", "album", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1570", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1571", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1571", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1571", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1572", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "سبک پازلی و لیستی", "", "publish", "closed", "closed", "", "1572", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1572", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1573", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "تصویر کوچک", "", "publish", "closed", "closed", "", "1573", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1573", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1574", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1574", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1574", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1575", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1575", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1575", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1576", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1576", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1576", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1577", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "صفحه بندی شده", "", "publish", "closed", "closed", "", "1577", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1577", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1578", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1578", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1578", "22", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1579", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "صفحه بدون سایدبار", "", "publish", "closed", "closed", "", "1579", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1579", "21", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1580", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "page-without-nav", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1580", "20", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1581", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1581", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1581", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1582", "1", "2022-01-02 02:19:38", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1582", "", "", "2022-01-02 02:19:38", "2022-01-01 22:49:38", "", "10", "https://themes.wpnovin.com/Waveme/?p=1582", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1583", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "صفحه فرود", "", "publish", "closed", "closed", "", "1583", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1583", "24", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1584", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", "", "درباره", "", "publish", "closed", "closed", "", "1584", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1584", "25", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1585", "1", "2022-01-02 02:05:47", "2022-01-01 13:11:01", " ", "", "", "publish", "closed", "closed", "", "1585", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1585", "27", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1590", "1", "2022-01-01 12:22:12", "2022-01-01 13:22:12", "", "logo-sv", "", "inherit", "open", "closed", "", "logo-sv", "", "", "2022-01-01 12:22:12", "2022-01-01 13:22:12", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2022/01/logo-sv.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("1593", "1", "2022-01-01 17:06:23", "2022-01-01 13:36:23", "\"Negine Ghalbami ~ Music-Fa.Com\" از Negine Ghalbami (Single) توسط Majid Razavi ~ Music-Fa.Com. منتشرشده: 2021. سبک: 2021.", "Negine Ghalbami ~ Music-Fa.Com", "", "inherit", "open", "closed", "", "negine-ghalbami-music-fa-com", "", "", "2022-01-01 17:06:23", "2022-01-01 13:36:23", "", "0", "https://themes.wpnovin.com/Waveme/wp-content/uploads/2022/01/Majid-Razavi-Negine-Ghalbami-320.mp3", "0", "attachment", "audio/mpeg", "0");
INSERT INTO `wp_posts` VALUES("1594", "1", "2022-01-01 17:06:23", "2022-01-01 13:36:23", "", "", "", "inherit", "open", "closed", "", "1594", "", "", "2022-01-01 17:06:23", "2022-01-01 13:36:23", "", "0", "https://themes.wpnovin.com/Waveme/1594/", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1596", "1", "2022-01-01 17:17:29", "2022-01-01 13:47:29", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>شاید دوست داشته باشید:</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین اخبار</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "Discover", "", "inherit", "closed", "closed", "", "11-revision-v1", "", "", "2022-01-01 17:17:29", "2022-01-01 13:47:29", "", "11", "https://themes.wpnovin.com/Waveme/?p=1596", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1597", "1", "2022-01-01 17:17:47", "2022-01-01 13:47:47", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>شاید دوست داشته باشید:</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین کاربران</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "Discover", "", "inherit", "closed", "closed", "", "11-revision-v1", "", "", "2022-01-01 17:17:47", "2022-01-01 13:47:47", "", "11", "https://themes.wpnovin.com/Waveme/?p=1597", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1598", "1", "2022-01-01 17:18:12", "2022-01-01 13:48:12", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>شاید دوست داشته باشید:</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین کاربران</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "صفحه اصلی", "", "inherit", "closed", "closed", "", "11-revision-v1", "", "", "2022-01-01 17:18:12", "2022-01-01 13:48:12", "", "11", "https://themes.wpnovin.com/Waveme/?p=1598", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1600", "1", "2022-01-01 17:18:56", "2022-01-01 13:48:56", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>محبوب ها:</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین کاربران</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "صفحه اصلی", "", "inherit", "closed", "closed", "", "11-revision-v1", "", "", "2022-01-01 17:18:56", "2022-01-01 13:48:56", "", "11", "https://themes.wpnovin.com/Waveme/?p=1600", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1601", "1", "2022-01-01 17:19:07", "2022-01-01 13:49:07", "<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>ویژه ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"station_tag:featured\"],\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"className\":\"block-loop-overlay\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>محبوب ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"meta_key=type\\u0026amp;meta_value=single\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"pages\":10} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>رادیو آنلاین</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"className\":\"block-loop-hover\"} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>آخرین کاربران</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"user\",\"metaQuery\":[\"verified:true\"],\"pages\":5} /-->\r\n\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>پلی لیست ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"station\",\"metaQuery\":[\"type:playlist:=\"],\"pages\":5,\"debug\":false} /-->\r\n\r\n<!-- wp:block/loop {\"title\":\"Recently played\",\"type\":\"station\",\"orderby\":\"user_played\",\"pages\":5} /-->\r\n\r\n<!-- wp:spacer {\"height\":20} -->\r\n<div class=\"wp-block-spacer\" style=\"height: 20px;\" aria-hidden=\"true\"> </div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"className\":\"white dark-white no-margin\",\"textColor\":\"very-dark-gray\"} -->\r\n<div class=\"wp-block-group alignfull white dark-white no-margin has-very-dark-gray-color has-text-color\">\r\n<div class=\"wp-block-group__inner-container\"> </div>\r\n</div>\r\n<!-- /wp:group -->", "صفحه اصلی", "", "inherit", "closed", "closed", "", "11-revision-v1", "", "", "2022-01-01 17:19:07", "2022-01-01 13:49:07", "", "11", "https://themes.wpnovin.com/Waveme/?p=1601", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1602", "1", "2022-01-01 17:27:39", "2022-01-01 13:57:39", "<!-- wp:block/loop {\"type\":\"post\",\"template\":\"templates/content/content-loop-post.php\",\"cols\":3,\"pages\":3,\"className\":\"row-md post-thumbnail-16x9\"} /-->\r\n<p>&nbsp;</p>\r\n<!-- wp:heading {\"level\":3} -->\r\n<h3>جدید ترین ها</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:block/loop {\"type\":\"post\",\"template\":\"templates/loop-post-excerpt.php\",\"className\":\"block-loop-row block-loop-lg post-thumbnail-16x9 entry-title-lg \"} /-->", "وبلاگ", "", "inherit", "closed", "closed", "", "13-revision-v1", "", "", "2022-01-01 17:27:39", "2022-01-01 13:57:39", "", "13", "https://themes.wpnovin.com/Waveme/?p=1602", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1603", "1", "2022-01-01 17:28:59", "2022-01-01 13:58:59", "<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\",\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#121416\"}}} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#121416\"><div class=\"wp-block-group__inner-container\"><!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"l-h-3\"} -->\n<div class=\"wp-block-columns l-h-3\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">Get Started</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themeforest.net/user/flatfull/portfolio\">Get This Theme</a></li><li><a href=\"http://music.flatfull.com/docs\">Read Documents</a></li><li><a href=\"http://flatfull.com\" data-type=\"URL\" data-id=\"http://flatfull.com\">Get Supported</a></li><li><a href=\"https://themeforest.net/collections/8004334-wordpress-music-theme\">More Music Themes</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">Browse &amp; Explore</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#\">Streaming Library</a></li><li><a href=\"http://music.flatfull.com/waveme/station/radio-playlist/\">Live Radio Stations</a></li><li><a href=\"http://music.flatfull.com/waveme/station-tag/icecast/\">Icecast</a></li><li><a href=\"http://music.flatfull.com/waveme/station-tag/shoutcast/\">Shoutcast</a></li><li><a href=\"http://music.flatfull.com/waveme/station/mtv-youtube-video-and-music/\">Youtube Music</a></li><li><a href=\"http://music.flatfull.com/waveme/category/press/\">Press</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">Account</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://music.flatfull.com/waveme/login/?action=register\">Sign Up</a></li><li><a href=\"http://music.flatfull.com/waveme/contact/\">Verified on Waveme</a></li><li><a href=\"http://music.flatfull.com/waveme/login\">Start Upload</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">About</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://music.flatfull.com/waveme/about/\">About Us</a></li><li><a href=\"http://music.flatfull.com/waveme/contact/\">Contact</a></li><li><a href=\"http://music.flatfull.com/waveme/terms/\">Terms</a></li><li><a href=\"http://music.flatfull.com/waveme/privacy-policy/\">Service Policy</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:social-links {\"align\":\"right\",\"className\":\"no-float-sm\"} -->\n<ul class=\"wp-block-social-links alignright no-float-sm\"><!-- wp:social-link {\"url\":\"https://twitter.com/soundwave\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://facebook.com/soundwave\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"linkedin\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://youtube.com/soundwave\",\"service\":\"youtube\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"fivehundredpx\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"http://instgram.com/aa\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":12}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:12px\"><strong>Waveme</strong> is a music WordPress theme with many features to build a professional music web application, It aim for Music platform, Audio publisher, Sophisticated DJ application. The Social Network for who love music.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":12}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:12px\">© Copyright 2020 Soundwave Entertainment Inc.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:group -->", "Footer", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2022-01-01 17:28:59", "2022-01-01 13:58:59", "", "35", "https://themes.wpnovin.com/Waveme/?p=1603", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1605", "1", "2022-01-01 17:32:49", "2022-01-01 14:02:49", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textColor\":\"black\",\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-black-color has-text-color has-normal-font-size\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:18px\">Waveme for Artists provides artists and their teams with audience stats and tools for promoting their music and managing their profile on Waveme. You also become a verified artist, so your profile on Waveme gets a verification check mark.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:32:49", "2022-01-01 14:02:49", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1605", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1606", "1", "2022-01-01 17:33:22", "2022-01-01 14:03:22", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5,\"textColor\":\"black\",\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h5 class=\"w-75 has-black-color has-text-color has-normal-font-size\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است...</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:18px\">Waveme for Artists provides artists and their teams with audience stats and tools for promoting their music and managing their profile on Waveme. You also become a verified artist, so your profile on Waveme gets a verification check mark.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:33:22", "2022-01-01 14:03:22", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1606", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1607", "1", "2022-01-01 17:34:08", "2022-01-01 14:04:08", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5,\"textColor\":\"black\",\"className\":\"w-75\",\"fontSize\":\"small\"} -->\n<h5 class=\"w-75 has-black-color has-text-color has-small-font-size\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است...</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:34:08", "2022-01-01 14:04:08", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1607", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1608", "1", "2022-01-01 17:34:25", "2022-01-01 14:04:25", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5,\"textColor\":\"black\",\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h5 class=\"w-75 has-black-color has-text-color has-normal-font-size\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است...</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:34:25", "2022-01-01 14:04:25", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1608", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1609", "1", "2022-01-01 17:34:52", "2022-01-01 14:04:52", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:34:52", "2022-01-01 14:04:52", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1609", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1610", "1", "2022-01-01 17:35:07", "2022-01-01 14:05:07", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">Music Community</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\">Build your audience at any stage and learn from your fans, Get listeners into your new music and stay connected with your followers, Waveme is the music community platform.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5>WordPress<sup>5</sup> Theme</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\">Whether you make music, work at a label, manage an artist, or do it all yourself. Waveme is the best way to bring it all together</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">Next Music Platform</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>Gutenberg Block Editor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:35:07", "2022-01-01 14:05:07", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1610", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1611", "1", "2022-01-01 17:36:01", "2022-01-01 14:06:01", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\",\"id\":1314,\"backgroundType\":\"video\",\"minHeight\":650,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"no-padding no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim no-padding no-margin\" style=\"min-height:650px\"><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/Pexels-Videos-2022395.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group container-wrap\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">پلی لیست ها و موزیک ها</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آهنگ های مورد علاقه</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین اخبار سایت</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">آخرین کنسرت ها</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"white\",\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-white-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":4} -->\n<h4>هم ترانه با شما</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">صدای خود را</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"className\":\"heading\",\"fontSize\":\"medium\"} -->\n<h2 class=\"heading has-medium-font-size\">به دنیا تقدیم کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#222222;font-size:18px\">هم ترانه ، یک قالب وردپرس پخش آهنگ و آلبوم و استریم است که بهترین امکانات را با بالاترین سرعت ممکن به شما تقدیم خواهد کرد...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-black-color has-text-color\"><strong>خرید هم ترانه از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":863,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/11/Artboard-1024x768.png\" alt=\"\" class=\"wp-image-863\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40,\"className\":\"plugin-slider\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer plugin-slider\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading -->\n<h2>هم ترانه ، همراه شما...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/\"><strong>خرید از نوین وردپرس</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"textColor\":\"black\",\"className\":\"plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin\"} -->\n<div class=\"wp-block-group alignfull plugin-slider data-child-true data-dots-true block-loop-dot-left grid-1 no-margin has-black-color has-text-color\"><!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f0eee9\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f0eee9\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":547,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-48.png\" alt=\"\" class=\"wp-image-547\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4} -->\n<h4>به هم ترانه خوش آمدید...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#000011\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"w-75\"} -->\n<p class=\"w-75 has-text-color\" style=\"color:#000011;font-size:15px\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#dadcd0\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#dadcd0\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#75613f\"}}} -->\n<h4 class=\"has-text-color\" style=\"color:#75613f\">جدید ترین آهنگ ها</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#75613f\"}},\"className\":\"w-75\",\"fontSize\":\"normal\"} -->\n<h2 class=\"w-75 has-text-color has-normal-font-size\" style=\"color:#75613f\"><meta charset=\"utf-8\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":704,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/10/Artboard-62.png\" alt=\"\" class=\"wp-image-704\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f3ddba\"}},\"textColor\":\"black\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-black-color has-text-color has-background\" style=\"background-color:#f3ddba\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"fontSize\":\"normal\"} -->\n<h5 class=\"has-normal-font-size\">هم ترانه بهترین قالب ممکن...</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#151515\"},\"typography\":{\"fontSize\":18}},\"className\":\"w-50\"} -->\n<p class=\"w-50 has-text-color\" style=\"color:#151515;font-size:18px\"><meta charset=\"utf-8\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"style\":{\"color\":{\"text\":\"#753a0f\"}},\"className\":\"f-w-8\",\"fontSize\":\"huge\"} -->\n<h2 class=\"f-w-8 has-text-color has-huge-font-size\" style=\"color:#753a0f\">پلفرم موسیقی ایران...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4>صدایی به وسعت ایران عزیز...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "درباره ما", "", "inherit", "closed", "closed", "", "1024-revision-v1", "", "", "2022-01-01 17:36:01", "2022-01-01 14:06:01", "", "1024", "https://themes.wpnovin.com/Waveme/?p=1611", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1614", "1", "2022-01-02 00:25:07", "2022-01-01 20:55:07", "<!-- wp:block/loop {\"type\":\"station\",\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"sliderOption\":\"\",\"cols\":4,\"gap\":24} /-->\n\n<!-- wp:cover {\"customOverlayColor\":\"#121416\"} -->\n<div class=\"wp-block-cover has-background-dim\" style=\"background-color:#121416\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"has-text-align-center\"><strong>به هم ترانه سلام کنید!</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"w-50 m-auto\"} -->\n<p class=\"has-text-align-center w-50 m-auto\"><meta charset=\"utf-8\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"color\":{\"background\":\"#ffffff\"}},\"className\":\"text-primary\"} -->\n<div class=\"wp-block-button aligncenter text-primary\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" href=\"http://wpnovin.com/shop\" style=\"background-color:#ffffff\">خرید قالب از نوین وردپرس</a></div>\n<!-- /wp:button --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>ویژه ها</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"pages\":7} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>رادیو هم ترانه</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"template\":\"templates/content/content-loop.php\",\"slider\":true,\"pages\":7,\"className\":\"block-loop-hover\"} /-->", "انتخاب", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2022-01-02 00:25:07", "2022-01-01 20:55:07", "", "10", "https://themes.wpnovin.com/Waveme/?p=1614", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1615", "1", "2022-01-02 00:25:58", "2022-01-01 20:55:58", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-all\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دار ها", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2022-01-02 00:25:58", "2022-01-01 20:55:58", "", "12", "https://themes.wpnovin.com/Waveme/?p=1615", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1616", "1", "2022-01-02 00:26:11", "2022-01-01 20:56:11", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-month-\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دارهای ماه", "", "inherit", "closed", "closed", "", "31-revision-v1", "", "", "2022-01-02 00:26:11", "2022-01-01 20:56:11", "", "31", "https://themes.wpnovin.com/Waveme/?p=1616", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1617", "1", "2022-01-02 00:26:15", "2022-01-01 20:56:15", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"post-count-week-\",\"template\":\"templates/loop-waveform.php\",\"pages\":50,\"className\":\"block-loop-row block-loop-index\"} /-->", "رکورد دارهای هفته", "", "inherit", "closed", "closed", "", "33-revision-v1", "", "", "2022-01-02 00:26:15", "2022-01-01 20:56:15", "", "33", "https://themes.wpnovin.com/Waveme/?p=1617", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1618", "1", "2022-01-02 00:27:02", "2022-01-01 20:57:02", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:block/loop {\"title\":\"دو ستونه\",\"type\":\"station\",\"cols\":2,\"pages\":2} /-->\n\n<!-- wp:block/loop {\"title\":\"سه ستونه\",\"type\":\"station\",\"orderby\":\"title\",\"cols\":3,\"pages\":3} /-->\n\n<!-- wp:block/loop {\"title\":\"جهار ستونه\",\"type\":\"station\",\"orderby\":\"title\",\"order\":\"ASC\",\"cols\":4,\"pages\":4} /-->\n\n<!-- wp:block/loop {\"title\":\"پنج ستونه\",\"type\":\"station\",\"cols\":5,\"pages\":5} /-->\n\n<!-- wp:block/loop {\"title\":\"شش ستونه\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":6} /-->", "ستون ها", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2022-01-02 00:27:02", "2022-01-01 20:57:02", "", "130", "https://themes.wpnovin.com/Waveme/?p=1618", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1620", "1", "2022-01-02 00:28:32", "2022-01-01 20:58:32", "<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/pexels-sound-on-3756943.jpg\",\"id\":1531,\"dimRatio\":90,\"customGradient\":\"linear-gradient(135deg,rgb(1,32,51) 0%,rgb(155,81,224) 100%)\",\"align\":\"full\",\"className\":\"container-wrap no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-90 has-background-dim has-background-gradient container-wrap no-margin\"><span aria-hidden=\"true\" class=\"wp-block-cover__gradient-background\" style=\"background:linear-gradient(135deg,rgb(1,32,51) 0%,rgb(155,81,224) 100%)\"></span><img class=\"wp-block-cover__image-background wp-image-1531\" alt=\"\" src=\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/12/pexels-sound-on-3756943.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":160} -->\n<div style=\"height:160px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#b9cdd6\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#b9cdd6\">تماس با ما</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"fontSize\":\"medium\"} -->\n<h2 class=\"has-medium-font-size\">با هم ترانه در ارتباط باشید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"fontSize\":\"normal\"} -->\n<p class=\"has-normal-font-size\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff9f00\"}},\"className\":\"is-style-fill\"} -->\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-background\" href=\"mailto:verify@flatfull.com\" style=\"background-color:#ff9f00\"><strong>ارسال ایمیل همکاری</strong></a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color\" href=\"mailto:partner@flatfull.com\"><strong>درخواست انتشار ترانه</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fffff1\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fffff1\"><a class=\"btn-play has-text-color\" style=\"color:#ffbb00\" data-play-id=\"1206\" href=\"#\"></a>⠀<strong> به وسعت ایران زیبا...</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":70} -->\n<div style=\"height:70px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#4837e1\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#4837e1\"><!-- wp:spacer {\"height\":80} -->\n<div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"160px\",\"className\":\"alignmiddle\"} -->\n<div class=\"wp-block-column alignmiddle\" style=\"flex-basis:160px\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"style\":{\"color\":{\"text\":\"#4837e1\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\" style=\"color:#4837e1\"><strong>خرید هم ترانه</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "تماس با ما", "", "inherit", "closed", "closed", "", "1123-revision-v1", "", "", "2022-01-02 00:28:32", "2022-01-01 20:58:32", "", "1123", "https://themes.wpnovin.com/Waveme/?p=1620", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1621", "1", "2022-01-02 00:29:00", "2022-01-01 20:59:00", "<!-- wp:shortcode -->\n[play_download]\n<!-- /wp:shortcode -->", "دانلود", "", "inherit", "closed", "closed", "", "1118-revision-v1", "", "", "2022-01-02 00:29:00", "2022-01-01 20:59:00", "", "1118", "https://themes.wpnovin.com/Waveme/?p=1621", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1624", "1", "2022-01-02 00:34:26", "2022-01-01 21:04:26", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#121416\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#121416\"><!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"l-h-3\"} -->\n<div class=\"wp-block-columns l-h-3\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">دسترسی سریع</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\">خرید هم ترانه</a></li><li><a href=\"http://music.flatfull.com/docs\">مستندات قالب</a></li><li><a href=\"http://flatfull.com\" data-type=\"URL\" data-id=\"http://flatfull.com\">دریافت پشتیبانی</a></li><li><a href=\"https://themeforest.net/collections/8004334-wordpress-music-theme\">قالب های بیشتر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">شروع کنید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#\">لیست آهنگ ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/radio-playlist/\">ایستگاه های راد</a>یو</li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/icecast/\">اینکست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\" data-type=\"URL\" data-id=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\">شات کست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/mtv-youtube-video-and-music/\">موزیک ویدئو</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/category/press/\">پرس ها</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">حساب کاربری</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/login/?action=register\">عضویت</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/contact/\">درخواست تایید</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/login\">شروع آپلود</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">درباره</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/contact/\">تماس با ما</a></li><li><a href=\"http://music.flatfull.com/waveme/terms/\">قوانین و مقررات</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:social-links {\"align\":\"right\",\"className\":\"no-float-sm\"} -->\n<ul class=\"wp-block-social-links alignright no-float-sm\"><!-- wp:social-link {\"url\":\"https://twitter.com/soundwave\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://facebook.com/soundwave\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"linkedin\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://youtube.com/soundwave\",\"service\":\"youtube\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"fivehundredpx\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"http://instgram.com/aa\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":12}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:12px\"><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":12}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:12px\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2022-01-02 00:34:26", "2022-01-01 21:04:26", "", "35", "https://themes.wpnovin.com/Waveme/?p=1624", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1625", "1", "2022-01-02 00:35:28", "2022-01-01 21:05:28", "<!-- wp:block/loop {\"title\":\"پازلی\",\"type\":\"station\",\"cols\":5,\"pages\":5} /-->\n\n<!-- wp:block/loop {\"title\":\"لیستی\",\"type\":\"station\",\"cols\":1,\"pages\":2,\"className\":\"block-loop-row block-loop-index\"} /-->\n\n<!-- wp:block/loop {\"title\":\"لیست کوچک\",\"type\":\"station\",\"cols\":2,\"pages\":4,\"className\":\"block-loop-row block-loop-sm\"} /-->\n\n<!-- wp:block/loop {\"title\":\"لیست کوچک ویژه\",\"type\":\"station\",\"cols\":2,\"pages\":4,\"className\":\"block-loop-row block-loop-xs\"} /-->", "پازلی و لیستی", "", "inherit", "closed", "closed", "", "132-revision-v1", "", "", "2022-01-02 00:35:28", "2022-01-01 21:05:28", "", "132", "https://themes.wpnovin.com/Waveme/?p=1625", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1626", "1", "2022-01-02 00:35:37", "2022-01-01 21:05:37", "<!-- wp:block/loop {\"type\":\"station\",\"pages\":4,\"pager\":\"scroll\",\"className\":\"block-loop-row block-loop-sm\"} /-->", "اسکرول نامحدود", "", "inherit", "closed", "closed", "", "758-revision-v1", "", "", "2022-01-02 00:35:37", "2022-01-01 21:05:37", "", "758", "https://themes.wpnovin.com/Waveme/?p=1626", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1628", "1", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"gradient\":\"linear-gradient(135deg,rgb(31,44,52) 0%,rgb(0,0,0) 100%)\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background:linear-gradient(135deg,rgb(31,44,52) 0%,rgb(0,0,0) 100%)\"><!-- wp:spacer {\"height\":140} -->\n<div style=\"height:140px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block {\"ref\":867} /-->\n\n<!-- wp:spacer {\"height\":110} -->\n<div style=\"height:110px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:cover {\"url\":\"https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-49.png\",\"id\":548,\"hasParallax\":true,\"dimRatio\":85,\"align\":\"full\",\"className\":\"container-wrap no-margin\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-90 has-background-dim has-parallax container-wrap no-margin\" style=\"background-image:url(https://themes.wpnovin.com/Waveme/wp-content/uploads/2020/09/Artboard-49.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"fontSize\":\"huge\"} -->\n<h2 class=\"has-huge-font-size\">آهنگ ، ویدئو ، آلبوم و استریم و...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>بهترین آهنگ ها</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\"><a href=\"https://themes.wpnovin.com/Waveme/\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>ویدئو های جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3>پلی لیست های محبوب</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#aaaaaa\"},\"typography\":{\"fontSize\":18}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"no-padding\"} -->\n<div class=\"wp-block-group alignfull no-padding has-white-color has-black-background-color has-text-color has-background\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"template\":\"templates/content/content-thumbnail.php\",\"slider\":true,\"sliderOption\":\"{arrows: false, autoplay: true}\",\"cols\":7,\"gap\":20,\"pages\":20,\"align\":\"full\",\"className\":\"block-loop-overlay\"} /-->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"has-large-font-size\">به راحتی آب خوردن...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":60} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:block {\"ref\":1095} /-->\n\n<!-- wp:block {\"ref\":1096} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":10} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "لندینگ", "", "inherit", "closed", "closed", "", "924-revision-v1", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "924", "https://themes.wpnovin.com/Waveme/?p=1628", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1629", "1", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"60%\",\"className\":\"text-center-sm\"} -->\n<div class=\"wp-block-column text-center-sm\" style=\"flex-basis:60%\"><!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5,\"textColor\":\"cyan-bluish-gray\"} -->\n<h5 class=\"has-cyan-bluish-gray-color has-text-color\">بهترین قالب آهنگ و ویدئو</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"fontSize\":\"medium\"} -->\n<h2 class=\"has-medium-font-size\">به دنیای هم ترانه سلام کنید...</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"cyan-bluish-gray\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-cyan-bluish-gray-color has-text-color\" href=\"https://themes.wpnovin.com/Waveme//discover\"><strong>شروع کنید...</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:block/loop {\"type\":\"station\",\"ids\":[\"176\",\"223\",\"666\",\"174\"],\"orderby\":\"post__in\",\"template\":\"templates/content/content-thumbnail.php\",\"slider\":true,\"sliderOption\":\"{arrows:false, dots: true, autoplay: true}\",\"cols\":1,\"className\":\"block-loop-overlay\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Hero 1", "", "inherit", "closed", "closed", "", "867-revision-v1", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "867", "https://themes.wpnovin.com/Waveme/?p=1629", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1630", "1", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۱ صفحه ساز گوتنبرگ</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#aaaaaa\"}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">تمامی صفحات و آهنگ ها و استریم ها به راحتی با صفحه ساز گوتنبرگ قابل ویرایش می باشد.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۲ ساخت آهنگ و ویدئو...</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#aaaaaa\"}}} -->\n<p class=\"has-text-color\" style=\"color:#aaaaaa;font-size:18px\">به راحتی و با چند کلیک آهنگ ها و پلی لیست ها و موزیک ویدئو های خود را ایجاد کنید.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Text drop", "", "inherit", "closed", "closed", "", "1095-revision-v1", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "1095", "https://themes.wpnovin.com/Waveme/?p=1630", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1631", "1", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "<!-- wp:columns {\"className\":\"has-medium-gap\"} -->\n<div class=\"wp-block-columns has-medium-gap\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">3 امکان ارسال آهنگ </h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#999999\"}}} -->\n<p class=\"has-text-color\" style=\"color:#999999;font-size:18px\">کاربران به راحتی از طریق پنل کاربری خود میتوانید آهنگ ها ، ویدئو ها و آلبوم های رایگان و پولی خود را ارسال کنند.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"className\":\"has-drop-cap has-drop-cap-2\"} -->\n<h4 class=\"has-drop-cap has-drop-cap-2\">۴ نسخه تیره و روشن</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#999999\"}}} -->\n<p class=\"has-text-color\" style=\"color:#999999;font-size:18px\">وجود بی نهایت رنگ بندی آنلاین به همراه طراحی عالی و نسخه تیره و روشن از ویژگی های دیگر این قالب است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Text drop 2", "", "inherit", "closed", "closed", "", "1096-revision-v1", "", "", "2022-01-02 00:42:15", "2022-01-01 21:12:15", "", "1096", "https://themes.wpnovin.com/Waveme/?p=1631", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1632", "1", "2022-01-02 00:42:52", "2022-01-01 21:12:52", "<!-- wp:block/loop {\"type\":\"station\",\"pager\":\"more\",\"className\":\"block-loop-row\"} /-->", "بارگذاری بیشتر", "", "inherit", "closed", "closed", "", "756-revision-v1", "", "", "2022-01-02 00:42:52", "2022-01-01 21:12:52", "", "756", "https://themes.wpnovin.com/Waveme/?p=1632", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1633", "1", "2022-01-02 00:43:07", "2022-01-01 21:13:07", "<!-- wp:shortcode -->\n[play_login_form]\n<!-- /wp:shortcode -->", "ورود", "", "inherit", "closed", "closed", "", "48-revision-v1", "", "", "2022-01-02 00:43:07", "2022-01-01 21:13:07", "", "48", "https://themes.wpnovin.com/Waveme/?p=1633", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1634", "1", "2022-01-02 00:43:26", "2022-01-01 21:13:26", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"cols\":4,\"pages\":4} /-->", "صفحه با فوتر", "", "inherit", "closed", "closed", "", "776-revision-v1", "", "", "2022-01-02 00:43:26", "2022-01-01 21:13:26", "", "776", "https://themes.wpnovin.com/Waveme/?p=1634", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1635", "1", "2022-01-02 00:43:31", "2022-01-01 21:13:31", "<!-- wp:block/loop {\"type\":\"station\",\"pages\":10} /-->", "صفحه بدون ناوبری", "", "inherit", "closed", "closed", "", "767-revision-v1", "", "", "2022-01-02 00:43:31", "2022-01-01 21:13:31", "", "767", "https://themes.wpnovin.com/Waveme/?p=1635", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1636", "1", "2022-01-02 00:43:41", "2022-01-01 21:13:41", "<!-- wp:block/loop {\"type\":\"station\",\"orderby\":\"rand\",\"cols\":3,\"pages\":9} /-->", "صفحه با سایدبار", "", "inherit", "closed", "closed", "", "772-revision-v1", "", "", "2022-01-02 00:43:41", "2022-01-01 21:13:41", "", "772", "https://themes.wpnovin.com/Waveme/?p=1636", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1637", "1", "2022-01-02 00:43:44", "2022-01-01 21:13:44", "<!-- wp:block/loop {\"type\":\"station\",\"slider\":false,\"cols\":5,\"pages\":10,\"pager\":\"pagination\"} /-->", "ناوبذی", "", "inherit", "closed", "closed", "", "754-revision-v1", "", "", "2022-01-02 00:43:44", "2022-01-01 21:13:44", "", "754", "https://themes.wpnovin.com/Waveme/?p=1637", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1638", "1", "2022-01-02 00:43:47", "2022-01-01 21:13:47", "<!-- wp:block/loop {\"type\":\"station\",\"slider\":false,\"cols\":5,\"pages\":10,\"pager\":\"pagination\"} /-->", "ناوبری", "", "inherit", "closed", "closed", "", "754-revision-v1", "", "", "2022-01-02 00:43:47", "2022-01-01 21:13:47", "", "754", "https://themes.wpnovin.com/Waveme/?p=1638", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1640", "1", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "<!-- wp:paragraph -->\n<p><a href=\"http://music.flatfull.com/waveme/category/press/\">Press Room</a> <a href=\"http://music.flatfull.com/waveme/about/\">About</a> <a href=\"http://music.flatfull.com/waveme/contact\">Contact Us</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://music.flatfull.com/waveme/terms\">Terms</a> <a href=\"http://music.flatfull.com/waveme/privacy-policy/\">Privacy Policy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"fontSize\":\"small\",\"style\":{\"color\":{\"text\":\"#888888\"}}} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#888888\">@2021 Music Theme</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Side Footer", "", "inherit", "closed", "closed", "", "1547-revision-v1", "", "", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "", "1547", "https://themes.wpnovin.com/Waveme/?p=1640", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1641", "1", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "<!-- wp:cover {\"customOverlayColor\":\"#121416\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim h-auto\" style=\"background-color:#121416\"><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"w-75 m-auto\"} -->\n<h3 class=\"has-text-align-center w-75 m-auto\"><strong>Follow Artists</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"w-75 m-auto\",\"style\":{\"color\":{\"text\":\"#cccccc\"}}} -->\n<p class=\"has-text-align-center w-75 m-auto has-text-color\" style=\"color:#cccccc\">Stay connected with your favorite artists, intimate sets streamed directly from their homes to yours.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"very-light-gray\",\"textColor\":\"very-dark-gray\",\"align\":\"center\",\"className\":\"btn-sm btn-primary\"} -->\n<div class=\"wp-block-button aligncenter btn-sm btn-primary\"><a class=\"wp-block-button__link has-very-dark-gray-color has-very-light-gray-background-color has-text-color has-background\" href=\"#\">Explore Artists</a></div>\n<!-- /wp:button -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:11px\">Advertisement by Flatfull.com</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:cover {\"gradient\":\"vivid-cyan-blue-to-vivid-purple\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim has-background-gradient has-vivid-cyan-blue-to-vivid-purple-gradient-background h-auto\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"className\":\"no-margin\",\"style\":{\"color\":{\"text\":\"#fefefe\"}}} -->\n<p class=\"has-text-align-center no-margin has-text-color\" style=\"color:#fefefe\">Music Theme 2021</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->", "Sidebar", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "", "39", "https://themes.wpnovin.com/Waveme/?p=1641", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1642", "1", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap\"><div class=\"wp-block-group__inner-container\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-left has-text-color\" style=\"color:#888888;font-size:11px\">@ Copyright 2021 Waveme Theme. All Rights Reserved</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":11}}} -->\n<p style=\"font-size:11px\"><a href=\"http://music.flatfull.com/waveme/terms\">Service Terms</a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/\">Music Policy</a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/#cookies\">Cookie Warnings</a>⠀•⠀<a href=\"http://flatfull.com\">Support</a>⠀•⠀<a href=\"mailto:hey@flatfull.com\">Feedback</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:group -->", "Simple Footer", "", "inherit", "closed", "closed", "", "778-revision-v1", "", "", "2022-01-02 00:44:42", "2022-01-01 21:14:42", "", "778", "https://themes.wpnovin.com/Waveme/?p=1642", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1643", "1", "2022-01-02 00:44:56", "2022-01-01 21:14:56", "<!-- wp:heading --><h2>ما که هستیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>نشانی وب‌سایت ما: https://themes.wpnovin.com/Waveme.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>رسانه</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>کوکی‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ترک کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر شما انتخاب کنید &quot; به یاد داشته باشید من Me&quot;، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما یک تنظیم دوباره رمز عبور را درخواست دادید، نشانی IP شما در ایمیل تنظیم دوباره وجود خواهد داشت.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر یک نظر را ترک کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم به جای برگزاری آنها در یک خط مؤثر، به طور خودکار هر نظر پیگیری را تصدیق و تأیید کنیم.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>حقوقی که بر روی داده‌هایتان دارید</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر در این سایت حساب کاربری دارید یا نظرها را ترک کرده اید، می‌توانید درخواست دریافت یک فایل صادر شده از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هر گونه داده‌ای که برای ما ارائه کرده اید. همچنین می‌توانید درخواست کنید که ما هر گونه اطلاعات شخصی که در مورد شما نگه داریم پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>داده‌های شما را به کجا ارسال می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p><!-- /wp:paragraph -->", "سیاست حریم خصوصی", "", "inherit", "closed", "closed", "", "3-revision-v1", "", "", "2022-01-02 00:44:56", "2022-01-01 21:14:56", "", "3", "https://themes.wpnovin.com/Waveme/?p=1643", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1646", "1", "2022-01-02 00:46:28", "2022-01-01 21:16:28", "<!-- wp:paragraph -->\n<p><a href=\"https://themes.wpnovin.com/Waveme/contact\">اتاق های موزیک</a> <a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a> <a href=\"https://themes.wpnovin.com/Waveme/contact\">تماس با ما</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://music.flatfull.com/waveme/terms\">قوانین و مقررات</a> <a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"small\"} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#888888\">@2021 Music Theme</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "فوتر کناری", "", "inherit", "closed", "closed", "", "1547-revision-v1", "", "", "2022-01-02 00:46:28", "2022-01-01 21:16:28", "", "1547", "https://themes.wpnovin.com/Waveme/?p=1646", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1647", "1", "2022-01-02 00:46:50", "2022-01-01 21:16:50", "<!-- wp:paragraph -->\n<p><a href=\"https://themes.wpnovin.com/Waveme/contact\">اتاق های موزیک</a> <a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a> <a href=\"https://themes.wpnovin.com/Waveme/contact\">تماس با ما</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://music.flatfull.com/waveme/terms\">قوانین و مقررات</a> <a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"small\"} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#888888\">@ ارائه شده توسط نوین وردپرس</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":40} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "فوتر کناری", "", "inherit", "closed", "closed", "", "1547-revision-v1", "", "", "2022-01-02 00:46:50", "2022-01-01 21:16:50", "", "1547", "https://themes.wpnovin.com/Waveme/?p=1647", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1648", "1", "2022-01-02 00:47:43", "2022-01-01 21:17:43", "<!-- wp:cover {\"customOverlayColor\":\"#121416\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim h-auto\" style=\"background-color:#121416\"><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"w-75 m-auto\"} -->\n<h3 class=\"has-text-align-center w-75 m-auto\"><strong>دنبال کردن خواننده</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#cccccc\"}},\"className\":\"w-75 m-auto\"} -->\n<p class=\"has-text-align-center w-75 m-auto has-text-color\" style=\"color:#cccccc\">قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:button {\"backgroundColor\":\"very-light-gray\",\"textColor\":\"very-dark-gray\",\"align\":\"center\",\"className\":\"btn-sm btn-primary\"} -->\n<div class=\"wp-block-button aligncenter btn-sm btn-primary\"><a class=\"wp-block-button__link has-very-dark-gray-color has-very-light-gray-background-color has-text-color has-background\" href=\"#\">دنبال کنید...</a></div>\n<!-- /wp:button -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:11px\">تبلیغات توسط نوین وردپرس</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:cover {\"gradient\":\"vivid-cyan-blue-to-vivid-purple\",\"className\":\"h-auto\"} -->\n<div class=\"wp-block-cover has-background-dim has-background-gradient has-vivid-cyan-blue-to-vivid-purple-gradient-background h-auto\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#fefefe\"}},\"className\":\"no-margin\"} -->\n<p class=\"has-text-align-center no-margin has-text-color\" style=\"color:#fefefe\">بهترین قالب موزیک و ویدئو و البوم در ایران</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "سایدبار", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2022-01-02 00:47:43", "2022-01-01 21:17:43", "", "39", "https://themes.wpnovin.com/Waveme/?p=1648", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1649", "1", "2022-01-02 00:48:40", "2022-01-01 21:18:40", "<!-- wp:group {\"align\":\"full\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap\"><!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":11}}} -->\n<p class=\"has-text-align-left has-text-color\" style=\"color:#888888;font-size:11px\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":11}}} -->\n<p style=\"font-size:11px\"><a href=\"http://music.flatfull.com/waveme/terms\">سرویس پخش </a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/\">قوانین موزیک</a>⠀•⠀<a href=\"http://music.flatfull.com/waveme/privacy-policy/#cookies\">کوکی ها</a>⠀•⠀<a href=\"http://flatfull.com\">پشتیبانی</a>⠀•⠀<a href=\"mailto:hey@flatfull.com\">بازخورد ها</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":30} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر ساده", "", "inherit", "closed", "closed", "", "778-revision-v1", "", "", "2022-01-02 00:48:40", "2022-01-01 21:18:40", "", "778", "https://themes.wpnovin.com/Waveme/?p=1649", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1650", "1", "2022-01-02 00:49:14", "2022-01-01 21:19:14", "<!-- wp:block/loop {\"title\":\"پخش خودکار\",\"type\":\"station\",\"orderby\":\"rand\",\"slider\":true,\"sliderOption\":\"{autoplay:true}\",\"cols\":4,\"pages\":10} /-->\n\n<!-- wp:block/loop {\"title\":\"پیکان\",\"type\":\"station\",\"slider\":true,\"cols\":5,\"pages\":8} /-->\n\n<!-- wp:block/loop {\"title\":\"نقطه ناوبری\",\"type\":\"station\",\"slider\":true,\"sliderOption\":\"{dots:true}\",\"cols\":5,\"pages\":9} /-->", "اسلایدر", "", "inherit", "closed", "closed", "", "741-revision-v1", "", "", "2022-01-02 00:49:14", "2022-01-01 21:19:14", "", "741", "https://themes.wpnovin.com/Waveme/?p=1650", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1652", "1", "2022-01-02 00:50:50", "2022-01-01 21:20:50", "<!-- wp:paragraph -->\n<p>با بازدید، دسترسی یا استفاده از سایت ما، نشان می‌دهید که حق، اختیار و ظرفیت لازم برای ورود به این توافق‌نامه را دارید، این موافقت‌نامه را خوانده‌اید و درک کرده‌اید، و موافقت می‌کنید که تمام شرایط و ضوابط را رعایت کنید. این توافقنامه، از جمله تمدید خودکار اشتراک شما و مقررات حاکم بر حل و فصل اختلافات. لطفا این شرایط را با دقت بخوانید. اگر موافق نیستید، به خدمات دسترسی نداشته باشید یا از آن استفاده نکنید.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":4} -->\n<h4 id=\"introduction\">معرفی</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>این سند («شرایط») به همراه خط‌مشی رازداری ایالات متحده (مجموعاً «توافقنامه») شرایط و ضوابط حاکم بر بازدیدها، دسترسی و استفاده از سرویس توسط کاربر نهایی («شما») را تعیین می‌کند. عبارت \"شما\" شامل کاربران ثبت نام شده اضافی هر زمان که طبق اشتراک قابل اجرا مجاز باشد، بازدیدکنندگان و سایر افرادی که به هر یک از خدمات دسترسی دارند یا از آنها استفاده می کنند، می شود.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>«سرویس‌ها» به معنای خدماتی است که سایت ما را با نام تجاری نشان می‌دهد و برای سرویس‌های موسیقی دیجیتال با موقعیت مشابه سازگار است. اینها ممکن است شامل وب‌سایت‌ها و برنامه‌های کاربردی برای رایانه‌های رومیزی، تبلت‌ها و گوشی‌های تلفن همراه، ست‌اپ باکس‌ها و تجهیزات استریو باشد، اما محدود به آن‌ها نیست. این خدمات همچنین شامل توانایی شما برای ویرایش محتوای سرویس خاص است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4 id=\"content-restrictions\">محدودیت های محتوا</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>این سرویس ها حاوی محتوایی مانند ضبط صدا، آثار سمعی و بصری، سایر آثار ویدیویی یا صوتی، کلیپ ها، تصاویر، گرافیک، متن، نرم افزار، آثار نویسندگی، فایل ها، اسناد، برنامه ها، آثار هنری، علائم تجاری، نام های تجاری، ابرداده ها، عناوین آلبوم است. ، عناوین ضبط صدا، نام هنرمندان، مالکیت معنوی، یا مطالب مربوط به آنها یا هر گونه مطالب دیگر، و انتخاب، هماهنگی و ترتیب آنها (در مجموع، \"محتوای خدمات\"). محتوای سرویس متعلق به سایت ما و/یا اشخاص ثالث است و تحت قوانین ایالات متحده و قوانین خارجی توسط حق چاپ محافظت می شود.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"level\":4} -->\n<h4 id=\"user-content\">محتوای کاربر</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>تا جایی که سرویس‌ها اجازه می‌دهند، هر اثر موسیقی (صداهای ضبط‌شده و ساخته‌های موسیقی زیربنایی)، آثار سمعی و بصری (شامل اما نه محدود به موزیک ویدیوهای برتر سبک MTV، کلیپ‌ها و به اصطلاح محتوای سمعی و بصری «پشت صحنه»)، ویدیوهای دیگر یا آثار صوتی، تصاویر، گرافیک، متن، آثار تألیفی، فایل‌ها، اسناد، برنامه‌های کاربردی، آثار هنری، علائم تجاری، نام‌های تجاری، ابرداده‌ها، عناوین آلبوم، عناوین ضبط صدا، نام هنرمندان، مالکیت معنوی، یا مطالب مرتبط با آن‌ها یا هر ماده دیگری که شما به این سرویس ارسال می کنید (\"محتوای کاربر\") تنها توسط شما و/یا دارندگان مجوز شما تولید، مالکیت و کنترل می شوند. ما هیچ گونه حقوق مالکیت معنوی در محتوای کاربر را ادعا نمی کنیم. پس از ارسال مستقیم (\"ارسال\") محتوای کاربری خود به سرویس ها، شما همچنان هرگونه حقوق مالکیت معنوی را که ممکن است در محتوای کاربری خود داشته باشید، مشروط به مجوز زیر حفظ کنید.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:list {\"className\":\"sticky-top\"} -->\n<ul class=\"sticky-top\"><li><a href=\"#introduction\">معرفی</a></li><li><a href=\"#content-restrictions\">محدودیت های محتوا</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"#user-content\">محتوای کاربر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "قوانین و مقررات", "", "inherit", "closed", "closed", "", "1168-revision-v1", "", "", "2022-01-02 00:50:50", "2022-01-01 21:20:50", "", "1168", "https://themes.wpnovin.com/Waveme/?p=1652", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1653", "1", "2022-01-02 00:51:09", "2022-01-01 21:21:09", "<!-- wp:block/loop {\"title\":\"16x9\",\"type\":\"station\",\"cols\":3,\"pages\":3,\"className\":\"post-thumbnail-16x9\"} /-->\n\n<!-- wp:block/loop {\"title\":\"21x9\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":2,\"pages\":2,\"className\":\"post-thumbnail-21x9\"} /-->\n\n<!-- wp:block/loop {\"title\":\"4x3\",\"type\":\"station\",\"orderby\":\"rand\",\"cols\":3,\"pages\":3,\"className\":\"post-thumbnail-4x3\"} /-->", "تصویر شاخص", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2022-01-02 00:51:09", "2022-01-01 21:21:09", "", "49", "https://themes.wpnovin.com/Waveme/?p=1653", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1654", "1", "2022-01-02 00:51:19", "2022-01-01 21:21:19", "<!-- wp:shortcode -->\n[play_upload_form]\n<!-- /wp:shortcode -->", "ارسال آهنگ", "", "inherit", "closed", "closed", "", "1116-revision-v1", "", "", "2022-01-02 00:51:19", "2022-01-01 21:21:19", "", "1116", "https://themes.wpnovin.com/Waveme/?p=1654", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1655", "1", "2022-01-02 00:52:12", "2022-01-01 21:22:12", "<!-- wp:block/loop {\"type\":\"station\",\"template\":\"templates/content/content-loop-post.php\",\"slider\":true,\"sliderOption\":\"\",\"cols\":3,\"className\":\"post-thumbnail-16x9\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>آهنگ جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"query\":\"\",\"orderby\":\"date\",\"order\":\"DESC\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"debug\":false,\"className\":\"block-loop-hover\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>رادیو جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"orderby\":\"date\",\"order\":\"DESC\",\"template\":\"templates/content/content-loop.php\",\"pages\":5,\"debug\":false} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>پلی لیست جدید</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=playlist\",\"orderby\":\"date\",\"template\":\"templates/content/content-loop.php\",\"pages\":5} /-->", "جدید ترین ها", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2022-01-02 00:52:12", "2022-01-01 21:22:12", "", "15", "https://themes.wpnovin.com/Waveme/?p=1655", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1656", "1", "2022-01-02 00:52:28", "2022-01-01 21:22:28", "<!-- wp:block/loop {\"title\":\"محبوب ترین ها\",\"type\":\"station\",\"metaQuery\":[\"waveform_data:1:EXISTS\"],\"query\":\"\",\"orderby\":\"all\",\"template\":\"templates/loop-waveform.php\",\"pages\":12,\"pager\":\"more\",\"filter\":[\"orderby::all[All Time]\",\"orderby::week[This Week]\",\"orderby::month[This Month]\",\"orderby::year[This Year]\",\"taxQuery::genre__[All Genres]\",\"taxQuery::genre__pop[Pop]\",\"taxQuery::genre__blues[Blues]\",\"taxQuery::genre__rock[Rock]\",\"metaQuery::type__[All]\",\"metaQuery::type__single[Song]\",\"metaQuery::type__playlist[Playlist]\",\"metaQuery::type__album[Album]\"],\"empty\":true,\"emptyContent\":\"No music songs found., \\u003ca href=\\u0022javascript: window.history.go(-1);\\u0022\\u003eGo back\\u003c/a\\u003e\",\"debug\":false,\"className\":\"block-loop-row block-loop-index\"} /-->", "محبوب ترین ها", "", "inherit", "closed", "closed", "", "326-revision-v1", "", "", "2022-01-02 00:52:28", "2022-01-01 21:22:28", "", "326", "https://themes.wpnovin.com/Waveme/?p=1656", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1657", "1", "2022-01-02 00:52:36", "2022-01-01 21:22:36", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:music\"],\"template\":\"templates/content/content-loop.php\",\"pages\":10,\"pager\":\"pagination\"} /-->", "موزیک", "", "inherit", "closed", "closed", "", "17-revision-v1", "", "", "2022-01-02 00:52:36", "2022-01-01 21:22:36", "", "17", "https://themes.wpnovin.com/Waveme/?p=1657", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1658", "1", "2022-01-02 00:52:47", "2022-01-01 21:22:47", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:podcast\"],\"query\":\"\",\"template\":\"templates/content/content-loop.php\",\"pages\":12,\"pager\":\"more\"} /-->", "پادکست", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2022-01-02 00:52:47", "2022-01-01 21:22:47", "", "21", "https://themes.wpnovin.com/Waveme/?p=1658", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1659", "1", "2022-01-02 00:52:51", "2022-01-01 21:22:51", "<!-- wp:block/loop {\"type\":\"station\",\"taxQuery\":[\"genre:radio\"],\"template\":\"templates/content/content-loop.php\",\"pages\":10,\"pager\":\"more\"} /-->", "رادیو", "", "inherit", "closed", "closed", "", "19-revision-v1", "", "", "2022-01-02 00:52:51", "2022-01-01 21:22:51", "", "19", "https://themes.wpnovin.com/Waveme/?p=1659", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1660", "1", "2022-01-02 00:52:55", "2022-01-01 21:22:55", "<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=album\",\"template\":\"templates/content/content-loop.php\"} /-->", "آلبومک", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2022-01-02 00:52:55", "2022-01-01 21:22:55", "", "25", "https://themes.wpnovin.com/Waveme/?p=1660", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1661", "1", "2022-01-02 00:52:57", "2022-01-01 21:22:57", "<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=album\",\"template\":\"templates/content/content-loop.php\"} /-->", "آلبوم", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2022-01-02 00:52:57", "2022-01-01 21:22:57", "", "25", "https://themes.wpnovin.com/Waveme/?p=1661", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1662", "1", "2022-01-02 00:53:00", "2022-01-01 21:23:00", "<!-- wp:block/loop {\"type\":\"station\",\"query\":\"meta_key=type\\u0026meta_value=playlist\",\"template\":\"templates/content/content-loop.php\",\"pages\":12,\"pager\":\"more\"} /-->", "لیست پخش", "", "inherit", "closed", "closed", "", "282-revision-v1", "", "", "2022-01-02 00:53:00", "2022-01-01 21:23:00", "", "282", "https://themes.wpnovin.com/Waveme/?p=1662", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1663", "1", "2022-01-02 00:53:03", "2022-01-01 21:23:03", "<!-- wp:heading {\"level\":3} -->\n<h3>Music genre</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"taxonomy\",\"taxonomy\":\"genre\",\"query\":\"parent=14\",\"template\":\"templates/content/content-loop-taxonomy.php\",\"pages\":30,\"className\":\"block-loop-overlay block-loop-overlay-center  post-thumbnail-16x9\"} /-->\n\n<!-- wp:heading {\"level\":3} -->\n<h3>Podcast genre</h3>\n<!-- /wp:heading -->\n\n<!-- wp:block/loop {\"type\":\"taxonomy\",\"taxonomy\":\"genre\",\"query\":\"parent=16\",\"template\":\"templates/content/content-loop-taxonomy.php\",\"className\":\"block-loop-overlay block-loop-overlay-center  post-thumbnail-16x9\"} /-->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "ژانر", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2022-01-02 00:53:03", "2022-01-01 21:23:03", "", "23", "https://themes.wpnovin.com/Waveme/?p=1663", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1664", "1", "2022-01-02 01:32:13", "2022-01-01 22:02:13", "قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و... است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.", "سلام هم ترانه...", "", "inherit", "closed", "closed", "", "1552-revision-v1", "", "", "2022-01-02 01:32:13", "2022-01-01 22:02:13", "", "1552", "https://themes.wpnovin.com/Waveme/?p=1664", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1665", "1", "2022-01-02 01:32:28", "2022-01-01 22:02:28", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->", "آلبوم جدید سالار عقیلی در راه است...", "", "inherit", "closed", "closed", "", "420-revision-v1", "", "", "2022-01-02 01:32:28", "2022-01-01 22:02:28", "", "420", "https://themes.wpnovin.com/Waveme/?p=1665", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1666", "1", "2022-01-02 01:32:46", "2022-01-01 22:02:46", "<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:embed {\"url\":\"https://www.youtube.com/watch?v=Qs1IQAdp-60\",\"type\":\"video\",\"providerNameSlug\":\"youtube\",\"responsive\":true,\"className\":\"wp-embed-aspect-16-9 wp-has-aspect-ratio\"} -->\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\nhttps://www.youtube.com/watch?v=Qs1IQAdp-60\n</div></figure>\n<!-- /wp:embed -->", "بهترین آلبوم محمد اصفهانی", "", "inherit", "closed", "closed", "", "394-revision-v1", "", "", "2022-01-02 01:32:46", "2022-01-01 22:02:46", "", "394", "https://themes.wpnovin.com/Waveme/?p=1666", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1669", "1", "2022-01-02 01:54:24", "2022-01-01 22:24:24", "<!-- wp:block/loop {\"title\":\"محبوب ترین ها\",\"type\":\"station\",\"metaQuery\":[\"waveform_data:1:EXISTS\"],\"query\":\"\",\"orderby\":\"all\",\"template\":\"templates/loop-waveform.php\",\"pages\":12,\"pager\":\"more\",\"filter\":[\"orderby::all[All Time]\",\"orderby::week[This Week]\",\"orderby::month[This Month]\",\"orderby::year[This Year]\",\"taxQuery::genre__[All Genres]\",\"taxQuery::genre__pop[Pop]\",\"taxQuery::genre__blues[Blues]\",\"taxQuery::genre__rock[Rock]\",\"metaQuery::type__[All]\",\"metaQuery::type__single[Song]\",\"metaQuery::type__playlist[Playlist]\",\"metaQuery::type__album[Album]\"],\"empty\":true,\"emptyContent\":\"چیزی یافت نشد... \\u003ca href=\\u0022javascript: window.history.go(-1);\\u0022\\u003eبازگشت به عقب\\u003c/a\\u003e\",\"debug\":false,\"className\":\"block-loop-row block-loop-index\"} /-->", "محبوب ترین ها", "", "inherit", "closed", "closed", "", "326-revision-v1", "", "", "2022-01-02 01:54:24", "2022-01-01 22:24:24", "", "326", "https://themes.wpnovin.com/Waveme/?p=1669", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1670", "1", "2022-01-02 01:55:59", "2022-01-01 22:25:59", "<!-- wp:block/loop {\"title\":\"محبوب ترین ها\",\"type\":\"station\",\"metaQuery\":[\"waveform_data:1:EXISTS\"],\"query\":\"\",\"orderby\":\"all\",\"template\":\"templates/loop-waveform.php\",\"pages\":12,\"pager\":\"more\",\"filter\":[\"orderby::all[همه زمان ها]\",\"orderby::week[این هفته]\",\"orderby::month[این ماه]\",\"orderby::year[این سال]\",\"taxQuery::genre__[همه ٰژانر ها]\",\"taxQuery::genre__pop[پاپ]\",\"taxQuery::genre__blues[سنتی]\",\"taxQuery::genre__rock[راک]\",\"metaQuery::type__[All]\",\"metaQuery::type__single[Song]\",\"metaQuery::type__playlist[Playlist]\",\"metaQuery::type__album[Album]\"],\"empty\":true,\"emptyContent\":\"چیزی یافت نشد... \\u003ca href=\\u0022javascript: window.history.go(-1);\\u0022\\u003eبازگشت به عقب\\u003c/a\\u003e\",\"debug\":false,\"className\":\"block-loop-row block-loop-index\"} /-->", "محبوب ترین ها", "", "inherit", "closed", "closed", "", "326-autosave-v1", "", "", "2022-01-02 01:55:59", "2022-01-01 22:25:59", "", "326", "https://themes.wpnovin.com/Waveme/?p=1670", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1671", "1", "2022-01-02 01:56:16", "2022-01-01 22:26:16", "<!-- wp:block/loop {\"title\":\"محبوب ترین ها\",\"type\":\"station\",\"metaQuery\":[\"waveform_data:1:EXISTS\"],\"query\":\"\",\"orderby\":\"all\",\"template\":\"templates/loop-waveform.php\",\"pages\":12,\"pager\":\"more\",\"filter\":[\"orderby::all[همه زمان ها]\",\"orderby::week[این هفته]\",\"orderby::month[این ماه]\",\"orderby::year[این سال]\",\"taxQuery::genre__[همه ٰژانر ها]\",\"taxQuery::genre__pop[پاپ]\",\"taxQuery::genre__blues[سنتی]\",\"taxQuery::genre__rock[راک]\",\"metaQuery::type__[همه]\",\"metaQuery::type__single[تک آهنگ]\",\"metaQuery::type__playlist[آلبوم]\",\"metaQuery::type__album[پلی لیست]\"],\"empty\":true,\"emptyContent\":\"چیزی یافت نشد... \\u003ca href=\\u0022javascript: window.history.go(-1);\\u0022\\u003eبازگشت به عقب\\u003c/a\\u003e\",\"debug\":false,\"className\":\"block-loop-row block-loop-index\"} /-->", "محبوب ترین ها", "", "inherit", "closed", "closed", "", "326-revision-v1", "", "", "2022-01-02 01:56:16", "2022-01-01 22:26:16", "", "326", "https://themes.wpnovin.com/Waveme/?p=1671", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1672", "1", "2022-01-02 02:03:29", "2022-01-01 22:33:29", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#121416\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#121416\"><!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"l-h-3\"} -->\n<div class=\"wp-block-columns l-h-3\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">دسترسی سریع</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\">خرید هم ترانه</a></li><li><a href=\"http://music.flatfull.com/docs\">مستندات قالب</a></li><li><a href=\"http://flatfull.com\" data-type=\"URL\" data-id=\"http://flatfull.com\">دریافت پشتیبانی</a></li><li><a href=\"https://themeforest.net/collections/8004334-wordpress-music-theme\">قالب های بیشتر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">شروع کنید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#\">لیست آهنگ ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/radio-playlist/\">ایستگاه های راد</a>یو</li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/icecast/\">اینکست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\" data-type=\"URL\" data-id=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\">شات کست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/mtv-youtube-video-and-music/\">موزیک ویدئو</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/category/press/\">پرس ها</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">حساب کاربری</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/login/?action=register\">عضویت</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/contact/\">درخواست تایید</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/login\">شروع آپلود</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">درباره</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/contact/\">تماس با ما</a></li><li><a href=\"http://music.flatfull.com/waveme/terms/\">قوانین و مقررات</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:social-links {\"align\":\"right\",\"className\":\"no-float-sm\"} -->\n<ul class=\"wp-block-social-links alignright no-float-sm\"><!-- wp:social-link {\"url\":\"https://twitter.com/soundwave\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://facebook.com/soundwave\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"linkedin\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://youtube.com/soundwave\",\"service\":\"youtube\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"fivehundredpx\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"http://instgram.com/aa\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:14px\"><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"small\"} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#888888\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2022-01-02 02:03:29", "2022-01-01 22:33:29", "", "35", "https://themes.wpnovin.com/Waveme/?p=1672", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1673", "1", "2022-01-02 02:03:42", "2022-01-01 22:33:42", "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#121416\"}},\"textColor\":\"white\",\"className\":\"container-wrap\"} -->\n<div class=\"wp-block-group alignfull container-wrap has-white-color has-text-color has-background\" style=\"background-color:#121416\"><!-- wp:spacer {\"height\":50} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"l-h-3\"} -->\n<div class=\"wp-block-columns l-h-3\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">دسترسی سریع</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://wpnovin.com/product-category/wp-themes/music-themes/\">خرید هم ترانه</a></li><li><a href=\"http://music.flatfull.com/docs\">مستندات قالب</a></li><li><a href=\"http://flatfull.com\" data-type=\"URL\" data-id=\"http://flatfull.com\">دریافت پشتیبانی</a></li><li><a href=\"https://themeforest.net/collections/8004334-wordpress-music-theme\">قالب های بیشتر</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">شروع کنید</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"#\">لیست آهنگ ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/radio-playlist/\">ایستگاه های راد</a>یو</li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/icecast/\">اینکست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\" data-type=\"URL\" data-id=\"https://themes.wpnovin.com/Waveme/station-tag/shoutcast/\">شات کست ها</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/station/mtv-youtube-video-and-music/\">موزیک ویدئو</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/category/press/\">پرس ها</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">حساب کاربری</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/login/?action=register\">عضویت</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/contact/\">درخواست تایید</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/login\">شروع آپلود</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":5,\"style\":{\"color\":{\"text\":\"#999999\"}}} -->\n<h5 class=\"has-text-color\" style=\"color:#999999\">درباره</h5>\n<!-- /wp:heading -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://themes.wpnovin.com/Waveme/about/\">درباره ما</a></li><li><a style=\"font-family: Vazir, tahoma, arial; letter-spacing: -0.05px;\" href=\"http://music.flatfull.com/waveme/contact/\">تماس با ما</a></li><li><a href=\"http://music.flatfull.com/waveme/terms/\">قوانین و مقررات</a></li><li><a href=\"https://themes.wpnovin.com/Waveme/privacy-policy/\">حریم خصوصی</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":20} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:social-links {\"align\":\"right\",\"className\":\"no-float-sm\"} -->\n<ul class=\"wp-block-social-links alignright no-float-sm\"><!-- wp:social-link {\"url\":\"https://twitter.com/soundwave\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://facebook.com/soundwave\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"linkedin\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://youtube.com/soundwave\",\"service\":\"youtube\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"service\":\"fivehundredpx\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"http://instgram.com/aa\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-color\" style=\"color:#888888;font-size:14px\"><strong>قالب وردپرس هم ترانه یکی از بهترین و کاربردی ترین قالب های وردپرس پخش موزیک و آلبوم و موزیک ویدئو و… است که بصورت اختصاصی برای اولین بار در ایران توسط نوین وردپرس بصورت کاملا فارسی ارائه شده است.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#888888\"}},\"fontSize\":\"normal\"} -->\n<p class=\"has-text-color has-normal-font-size\" style=\"color:#888888\">تمامی حقوق برای مدیر سایت محفوظ است. فارسی سازی توسط <a href=\"https://wpnovin.com/\">نوین وردپرس</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->", "فوتر", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2022-01-02 02:03:42", "2022-01-01 22:33:42", "", "35", "https://themes.wpnovin.com/Waveme/?p=1673", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1675", "1", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "تیره / روشن", "", "publish", "closed", "closed", "", "%d8%aa%db%8c%d8%b1%d9%87-%d8%b1%d9%88%d8%b4%d9%86", "", "", "2022-01-02 02:05:47", "2022-01-01 22:35:47", "", "0", "https://themes.wpnovin.com/Waveme/?p=1675", "32", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("1676", "16", "2022-06-20 14:04:24", "2022-06-20 09:34:24", "", "1", "", "private", "open", "open", "", "1-2", "", "", "2022-06-20 14:04:24", "2022-06-20 09:34:24", "", "0", "https://themes.wpnovin.com/Waveme/1-2/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1677", "17", "2022-06-27 06:20:02", "2022-06-27 01:50:02", "", "جدید", "", "private", "open", "open", "", "%d8%ac%d8%af%db%8c%d8%af", "", "", "2022-06-27 06:20:02", "2022-06-27 01:50:02", "", "0", "https://themes.wpnovin.com/Waveme/%d8%ac%d8%af%db%8c%d8%af/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1678", "15", "2022-10-25 12:15:28", "2022-10-25 08:45:28", "", "qq", "", "private", "open", "open", "", "qq", "", "", "2022-10-25 12:15:28", "2022-10-25 08:45:28", "", "0", "https://themes.wpnovin.com/Waveme/qq/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1679", "20", "2022-10-28 17:25:44", "2022-10-28 13:55:44", "", "تست", "", "private", "open", "open", "", "%d8%aa%d8%b3%d8%aa", "", "", "2022-10-28 17:25:44", "2022-10-28 13:55:44", "", "0", "https://themes.wpnovin.com/Waveme/%d8%aa%d8%b3%d8%aa/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1681", "36", "2023-06-21 17:18:43", "2023-06-21 13:48:43", "", "21", "", "private", "open", "open", "", "21-2", "", "", "2023-06-21 17:18:43", "2023-06-21 13:48:43", "", "0", "https://themes.wpnovin.com/Waveme/21-2/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1683", "37", "2023-07-24 12:41:27", "2023-07-24 09:11:27", "", "تست", "", "private", "open", "open", "", "%d8%aa%d8%b3%d8%aa-2", "", "", "2023-07-24 12:41:27", "2023-07-24 09:11:27", "", "0", "https://themes.wpnovin.com/Waveme/%d8%aa%d8%b3%d8%aa-2/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1684", "46", "2023-11-15 22:47:07", "2023-11-15 19:17:07", "", "بللب", "", "private", "open", "open", "", "%d8%a8%d9%84%d9%84%d8%a8", "", "", "2023-11-15 22:47:07", "2023-11-15 19:17:07", "", "0", "https://themes.wpnovin.com/Waveme/%d8%a8%d9%84%d9%84%d8%a8/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1685", "46", "2023-11-15 22:49:11", "2023-11-15 19:19:11", "", "قبفقفقف", "", "private", "open", "open", "", "%d9%82%d8%a8%d9%81%d9%82%d9%81%d9%82%d9%81", "", "", "2023-11-15 22:49:11", "2023-11-15 19:19:11", "", "0", "https://themes.wpnovin.com/Waveme/%d9%82%d8%a8%d9%81%d9%82%d9%81%d9%82%d9%81/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1686", "46", "2023-11-15 22:50:06", "2023-11-15 19:20:06", "", "ربلبل", "", "private", "open", "open", "", "%d8%b1%d8%a8%d9%84%d8%a8%d9%84", "", "", "2023-11-15 22:50:06", "2023-11-15 19:20:06", "", "0", "https://themes.wpnovin.com/Waveme/%d8%b1%d8%a8%d9%84%d8%a8%d9%84/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1687", "48", "2023-11-27 13:04:20", "2023-11-27 09:34:20", "", "تست", "", "private", "open", "open", "", "%d8%aa%d8%b3%d8%aa-3", "", "", "2023-11-27 13:04:20", "2023-11-27 09:34:20", "", "0", "https://themes.wpnovin.com/Waveme/%d8%aa%d8%b3%d8%aa-3/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1688", "50", "2023-12-21 13:05:59", "2023-12-21 09:35:59", "", "غمگین", "", "private", "open", "open", "", "%d8%ba%d9%85%da%af%db%8c%d9%86", "", "", "2023-12-21 13:05:59", "2023-12-21 09:35:59", "", "0", "https://themes.wpnovin.com/Waveme/%d8%ba%d9%85%da%af%db%8c%d9%86/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1689", "50", "2023-12-21 13:06:06", "2023-12-21 09:36:06", "", "jadid", "", "private", "open", "open", "", "jadid", "", "", "2023-12-21 13:06:06", "2023-12-21 09:36:06", "", "0", "https://themes.wpnovin.com/Waveme/jadid/", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1690", "1", "2024-09-02 11:26:26", "0000-00-00 00:00:00", "", "پیش‌نویس خودکار", "", "auto-draft", "open", "open", "", "", "", "", "2024-09-02 11:26:26", "0000-00-00 00:00:00", "", "0", "https://themes.wpnovin.com/Waveme/?p=1690", "0", "post", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("145", "11", "1");
INSERT INTO `wp_term_relationships` VALUES("145", "36", "2");
INSERT INTO `wp_term_relationships` VALUES("145", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("146", "15", "1");
INSERT INTO `wp_term_relationships` VALUES("146", "19", "2");
INSERT INTO `wp_term_relationships` VALUES("146", "47", "3");
INSERT INTO `wp_term_relationships` VALUES("146", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("148", "11", "1");
INSERT INTO `wp_term_relationships` VALUES("148", "63", "2");
INSERT INTO `wp_term_relationships` VALUES("148", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("155", "17", "1");
INSERT INTO `wp_term_relationships` VALUES("155", "55", "0");
INSERT INTO `wp_term_relationships` VALUES("156", "20", "1");
INSERT INTO `wp_term_relationships` VALUES("156", "24", "2");
INSERT INTO `wp_term_relationships` VALUES("156", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("157", "26", "1");
INSERT INTO `wp_term_relationships` VALUES("157", "74", "0");
INSERT INTO `wp_term_relationships` VALUES("159", "31", "1");
INSERT INTO `wp_term_relationships` VALUES("159", "74", "0");
INSERT INTO `wp_term_relationships` VALUES("169", "49", "1");
INSERT INTO `wp_term_relationships` VALUES("169", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("172", "8", "1");
INSERT INTO `wp_term_relationships` VALUES("172", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("172", "41", "2");
INSERT INTO `wp_term_relationships` VALUES("172", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("172", "85", "0");
INSERT INTO `wp_term_relationships` VALUES("174", "16", "0");
INSERT INTO `wp_term_relationships` VALUES("174", "18", "1");
INSERT INTO `wp_term_relationships` VALUES("174", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("174", "35", "2");
INSERT INTO `wp_term_relationships` VALUES("174", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("174", "74", "0");
INSERT INTO `wp_term_relationships` VALUES("176", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("176", "40", "1");
INSERT INTO `wp_term_relationships` VALUES("176", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("178", "7", "1");
INSERT INTO `wp_term_relationships` VALUES("178", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("178", "94", "0");
INSERT INTO `wp_term_relationships` VALUES("180", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("180", "53", "1");
INSERT INTO `wp_term_relationships` VALUES("180", "69", "2");
INSERT INTO `wp_term_relationships` VALUES("180", "91", "0");
INSERT INTO `wp_term_relationships` VALUES("182", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("182", "83", "0");
INSERT INTO `wp_term_relationships` VALUES("186", "10", "1");
INSERT INTO `wp_term_relationships` VALUES("186", "26", "2");
INSERT INTO `wp_term_relationships` VALUES("186", "32", "3");
INSERT INTO `wp_term_relationships` VALUES("186", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("186", "62", "0");
INSERT INTO `wp_term_relationships` VALUES("188", "72", "1");
INSERT INTO `wp_term_relationships` VALUES("188", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("190", "28", "1");
INSERT INTO `wp_term_relationships` VALUES("190", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("192", "6", "1");
INSERT INTO `wp_term_relationships` VALUES("192", "88", "0");
INSERT INTO `wp_term_relationships` VALUES("194", "61", "1");
INSERT INTO `wp_term_relationships` VALUES("194", "83", "0");
INSERT INTO `wp_term_relationships` VALUES("196", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("198", "38", "1");
INSERT INTO `wp_term_relationships` VALUES("198", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("200", "13", "1");
INSERT INTO `wp_term_relationships` VALUES("200", "25", "2");
INSERT INTO `wp_term_relationships` VALUES("200", "33", "3");
INSERT INTO `wp_term_relationships` VALUES("200", "78", "0");
INSERT INTO `wp_term_relationships` VALUES("203", "42", "1");
INSERT INTO `wp_term_relationships` VALUES("203", "88", "0");
INSERT INTO `wp_term_relationships` VALUES("204", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("204", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("204", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("215", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("215", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("215", "85", "0");
INSERT INTO `wp_term_relationships` VALUES("216", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("216", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("216", "84", "0");
INSERT INTO `wp_term_relationships` VALUES("217", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("217", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("217", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("217", "92", "0");
INSERT INTO `wp_term_relationships` VALUES("218", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("218", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("220", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("220", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("221", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("221", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("221", "89", "0");
INSERT INTO `wp_term_relationships` VALUES("222", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("222", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("222", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("223", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("223", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("223", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("223", "68", "0");
INSERT INTO `wp_term_relationships` VALUES("227", "48", "1");
INSERT INTO `wp_term_relationships` VALUES("227", "65", "0");
INSERT INTO `wp_term_relationships` VALUES("227", "74", "0");
INSERT INTO `wp_term_relationships` VALUES("237", "73", "1");
INSERT INTO `wp_term_relationships` VALUES("237", "83", "0");
INSERT INTO `wp_term_relationships` VALUES("242", "22", "1");
INSERT INTO `wp_term_relationships` VALUES("242", "51", "0");
INSERT INTO `wp_term_relationships` VALUES("242", "83", "0");
INSERT INTO `wp_term_relationships` VALUES("290", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("394", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("394", "4", "0");
INSERT INTO `wp_term_relationships` VALUES("420", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("420", "5", "0");
INSERT INTO `wp_term_relationships` VALUES("469", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("476", "40", "1");
INSERT INTO `wp_term_relationships` VALUES("476", "52", "0");
INSERT INTO `wp_term_relationships` VALUES("476", "75", "0");
INSERT INTO `wp_term_relationships` VALUES("477", "50", "0");
INSERT INTO `wp_term_relationships` VALUES("477", "66", "0");
INSERT INTO `wp_term_relationships` VALUES("477", "96", "0");
INSERT INTO `wp_term_relationships` VALUES("480", "39", "1");
INSERT INTO `wp_term_relationships` VALUES("480", "83", "0");
INSERT INTO `wp_term_relationships` VALUES("609", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("609", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("609", "96", "0");
INSERT INTO `wp_term_relationships` VALUES("610", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("610", "58", "0");
INSERT INTO `wp_term_relationships` VALUES("611", "30", "0");
INSERT INTO `wp_term_relationships` VALUES("611", "56", "0");
INSERT INTO `wp_term_relationships` VALUES("611", "84", "0");
INSERT INTO `wp_term_relationships` VALUES("613", "29", "0");
INSERT INTO `wp_term_relationships` VALUES("613", "80", "0");
INSERT INTO `wp_term_relationships` VALUES("666", "12", "1");
INSERT INTO `wp_term_relationships` VALUES("666", "75", "0");
INSERT INTO `wp_term_relationships` VALUES("666", "77", "0");
INSERT INTO `wp_term_relationships` VALUES("666", "85", "0");
INSERT INTO `wp_term_relationships` VALUES("701", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("702", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("703", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("704", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("705", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("706", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("707", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("764", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("764", "23", "0");
INSERT INTO `wp_term_relationships` VALUES("764", "57", "0");
INSERT INTO `wp_term_relationships` VALUES("765", "44", "0");
INSERT INTO `wp_term_relationships` VALUES("765", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("766", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("1185", "34", "1");
INSERT INTO `wp_term_relationships` VALUES("1185", "43", "2");
INSERT INTO `wp_term_relationships` VALUES("1185", "86", "0");
INSERT INTO `wp_term_relationships` VALUES("1206", "45", "0");
INSERT INTO `wp_term_relationships` VALUES("1532", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("1533", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1534", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1535", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1536", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1537", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1538", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1539", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1540", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1541", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1542", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1543", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1544", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("1545", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("1546", "97", "0");
INSERT INTO `wp_term_relationships` VALUES("1548", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1549", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1550", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1551", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1552", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("1552", "3", "0");
INSERT INTO `wp_term_relationships` VALUES("1553", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1554", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1555", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1556", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1557", "98", "0");
INSERT INTO `wp_term_relationships` VALUES("1558", "98", "0");
INSERT INTO `wp_term_relationships` VALUES("1559", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1560", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1561", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1562", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1563", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1564", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1565", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1566", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1567", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1568", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1569", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1570", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1571", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1572", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1573", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1574", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1575", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1576", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1577", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1578", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1579", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1580", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1581", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1582", "99", "0");
INSERT INTO `wp_term_relationships` VALUES("1583", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1584", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1585", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1675", "100", "0");
INSERT INTO `wp_term_relationships` VALUES("1676", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1677", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1678", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1679", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1681", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1683", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1684", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1685", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1686", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1687", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1688", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("1689", "1", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("6", "6", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("7", "7", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("8", "8", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("9", "9", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("10", "10", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("11", "11", "artist", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("12", "12", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("13", "13", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("14", "14", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("15", "15", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("16", "16", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("17", "17", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("18", "18", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("19", "19", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("20", "20", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("21", "21", "station_tag", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("22", "22", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("23", "23", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("24", "24", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("25", "25", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("26", "26", "artist", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("27", "27", "station_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("28", "28", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("29", "29", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("30", "30", "station_tag", "", "0", "5");
INSERT INTO `wp_term_taxonomy` VALUES("31", "31", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("32", "32", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("33", "33", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("34", "34", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("35", "35", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("36", "36", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("37", "37", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("38", "38", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("39", "39", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("40", "40", "artist", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("41", "41", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("42", "42", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("43", "43", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("44", "44", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("45", "45", "genre", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("46", "46", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("47", "47", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("48", "48", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("49", "49", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("50", "50", "genre", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("51", "51", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("52", "52", "genre", "", "45", "10");
INSERT INTO `wp_term_taxonomy` VALUES("53", "53", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("54", "54", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("55", "55", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("56", "56", "genre", "", "0", "11");
INSERT INTO `wp_term_taxonomy` VALUES("57", "57", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("58", "58", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("59", "59", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("60", "60", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("61", "61", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("62", "62", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("63", "63", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("64", "64", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("65", "65", "station_tag", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("66", "66", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("67", "67", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("68", "68", "genre", "", "50", "1");
INSERT INTO `wp_term_taxonomy` VALUES("69", "69", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("70", "70", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("71", "71", "station_tag", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("72", "72", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("73", "73", "artist", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("74", "74", "genre", "", "45", "4");
INSERT INTO `wp_term_taxonomy` VALUES("75", "75", "station_tag", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("76", "76", "artist", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("77", "77", "station_tag", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("78", "78", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("79", "79", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("80", "80", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("81", "81", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("82", "82", "genre", "", "45", "0");
INSERT INTO `wp_term_taxonomy` VALUES("83", "83", "genre", "", "45", "5");
INSERT INTO `wp_term_taxonomy` VALUES("84", "84", "genre", "", "50", "2");
INSERT INTO `wp_term_taxonomy` VALUES("85", "85", "genre", "", "45", "3");
INSERT INTO `wp_term_taxonomy` VALUES("86", "86", "genre", "", "45", "8");
INSERT INTO `wp_term_taxonomy` VALUES("87", "87", "genre", "", "45", "0");
INSERT INTO `wp_term_taxonomy` VALUES("88", "88", "genre", "", "45", "2");
INSERT INTO `wp_term_taxonomy` VALUES("89", "89", "genre", "", "50", "1");
INSERT INTO `wp_term_taxonomy` VALUES("90", "90", "genre", "", "45", "0");
INSERT INTO `wp_term_taxonomy` VALUES("91", "91", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("92", "92", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("93", "93", "genre", "", "45", "0");
INSERT INTO `wp_term_taxonomy` VALUES("94", "94", "genre", "", "45", "1");
INSERT INTO `wp_term_taxonomy` VALUES("95", "95", "genre", "", "50", "0");
INSERT INTO `wp_term_taxonomy` VALUES("96", "96", "genre", "", "50", "2");
INSERT INTO `wp_term_taxonomy` VALUES("97", "97", "nav_menu", "", "0", "10");
INSERT INTO `wp_term_taxonomy` VALUES("98", "98", "nav_menu", "", "0", "2");
INSERT INTO `wp_term_taxonomy` VALUES("99", "99", "nav_menu", "", "0", "16");
INSERT INTO `wp_term_taxonomy` VALUES("100", "100", "nav_menu", "", "0", "32");

/* INSERT TABLE DATA: wp_termmeta */
INSERT INTO `wp_termmeta` VALUES("1", "7", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("2", "40", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("3", "45", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("4", "50", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("5", "52", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("6", "55", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("7", "56", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("8", "60", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("9", "62", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("10", "64", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("11", "67", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("12", "68", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("13", "70", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("14", "74", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("15", "78", "thumbnail_id", "543");
INSERT INTO `wp_termmeta` VALUES("16", "79", "thumbnail_id", "542");
INSERT INTO `wp_termmeta` VALUES("17", "80", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("18", "81", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("19", "82", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("20", "83", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("21", "84", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("22", "85", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("23", "86", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("24", "87", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("25", "88", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("26", "89", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("27", "90", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("28", "91", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("29", "92", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("30", "93", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("31", "94", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUES("32", "95", "thumbnail_id", "0");
INSERT INTO `wp_termmeta` VALUE