<?php
/**
 * Display user header
 */
defined( 'ABSPATH' ) || exit;

if( apply_filters('play_user_header_before', true) === false ){
	return;
}

$user_id = get_queried_object_id();

// author template
if(is_page($user_id)){
    if(is_user_logged_in()){
        $user_id = get_current_user_id();
    }else{
        return;
    }
}
$user = get_userdata($user_id);
// add css class on own page
$class= '';
if( get_current_user_id() == $user_id ){
	$class= 'current-user';
}
// add css on thumbnail
$thumbnail_pos_y = get_user_meta($user_id, 'thumbnail_pos_y', true);
$size = (int) get_option( 'large_size_w' ) / 2;
$image = get_avatar($user_id, $size ? $size : 1, '', '', 
	array(
		'attr' => array(
			'style' => 'object-position: 50% '.$thumbnail_pos_y.'%', 
			'data-pos-y' => $thumbnail_pos_y
		)
	)
);
?>

<div class="entry-header-container header-user <?php echo esc_attr($class);?>">
	<figure class="post-thumbnail">
		<?php echo wp_kses_post($image); ?>
	</figure>
	<header class="entry-header">
		<h1 class="entry-title"><a href="<?php echo esc_url(get_author_posts_url($user_id)); ?>"><?php echo esc_html( $user->display_name ); ?></a> <?php do_action('the_verified_button', $user_id); ?></h1>
		<div class="entry-description"><?php echo wp_kses_post($user->description); ?></div>
		<div class="entry-meta">
		<?php
			do_action( 'the_play_button', $user_id, 'user', '', true);
			do_action( 'the_follow_button', $user_id, 'button-rounded');
			do_action( 'the_user_links', $user);
			do_action( 'play_after_user_meta', $user_id);
		?>
		</div>
	</header>
</div>
